package DBIS.Configurator;

import java.sql.*;
import java.util.Vector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.io.FileInputStream;
import DBIS.Tools.Singleton;
import DBIS.Tools.QueryEngine;
import DBIS.Tools.PageGenerator;
import DBIS.Tools.HtmlTemplate;

/** This class contains the implementation of the class to generate
 * html pages for various menus This accepts the name of the menu
 * and returns the html class containing that menu The name of the servlet to 
 * handle the menu requests is taken from the Singleton class*/

public class MenuManager extends PageGenerator {

	String menuName="MainMenu";

	static HtmlTemplate _template;

	static	{
		_template=HtmlTemplate.loadHtmlTemplate(Singleton.DBIS_CONFIGURATOR_MENUFILE);
	}
	
	public MenuManager(String menuName)	{
		super(MenuManager._template);
		this.menuName=menuName;
	}

	public MenuManager()	{
		super(MenuManager._template);
	}

	/** This function returns the menu page for the current table*/
	public String format()	{
		return super.format(getParameters(MenuManager._template.getTags()));
	}

	/** This function takes an enumeration and determines the required
	 * parameters These parameters are determined by a heuristics which
	 * is encapsulated in this function and can thus be easily changed or
	 * overloaded*/
	public Hashtable getParameters(Enumeration enumeration)	{
		Hashtable hashtable=new Hashtable();
		ResultSet rs=QueryEngine.executeQuery("select * from Menu where menuName="+"\'"+menuName+"\' order by choiceDescription asc");
		if(rs==null)	{
			while(enumeration.hasMoreElements())	{
				hashtable.put(enumeration.nextElement(),"Unknown MenuName");
			}
			return hashtable;
		}
		String allSubMenuLinks="";
		String table="<center><table>\n";

		try {
			while(rs.next())	{
					table+="<tr>";
					table+=getRow(rs);
					table+="</tr>\n";
			}
		}catch(SQLException e) {e.printStackTrace();}
		table+="</table></center>\n";
				
		while(enumeration.hasMoreElements())	{
			String element=(String)enumeration.nextElement();
			String tag="";
			if(element.equals("$$DBIS_CONFIGURATOR_MENUTABLE$$"))	{
				tag=table;
			}
			else if(element.equals("$$DBIS_CONFIGURATOR_MENUNAME$$"))	{
				tag=menuName;
			}
			else if(element.equals("$$DBIS_CONFIGURATOR_HHTP_BASEADDRESS$$"))	{
				tag=Singleton.DBIS_HTTP_BASEADDRESS;
			}
			hashtable.put(element,tag);
		}
		return hashtable;
	}

	protected String getRow(ResultSet rs)	{
		String row="<td>";
		String servlet=Singleton.getServletBody(Singleton.DBIS_SERVLET_MENUHANDLER);
		try {
			String desc=rs.getString("choiceDescription"); 	
			desc="<font size=+2>"+desc+"</font>";
			String handlerName=Singleton.substituteString(rs.getString("handlerName"),"#","&");
			String servletLine=servlet+"?handlerName="+handlerName;
			String finalLine="<b><a HREF=\""+servletLine+"\"> "+desc+"</a></b>";
			row+=finalLine;
		}catch(SQLException e) {e.printStackTrace();}
		row+="</td>";
		return row;
	}

	public static void main(String args[])	{
		System.out.println((new MenuManager()).format());
	}
}

