package DBIS.RoomSpace;

import java.sql.*;
import java.util.Vector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import DBIS.Tools.Singleton;
import DBIS.Tools.QueryEngine;
import DBIS.Tools.PageGenerator;
import DBIS.Tools.HtmlTemplate;

/** This generates a html page which contains all items These are
 * primarily links to the item page*/
public class AllRoomPageGenerator	extends PageGenerator {

	String orderBy="room_name";
	String orderNature="asc";

	static HtmlTemplate _template;

	/** This static block loads the template file and stores
	 * it once for all for further instances*/
	static	{
		_template=HtmlTemplate.loadHtmlTemplate(Singleton.DBIS_ROOMSPACE_AllROOMSTEMPLATEFILE);
	}
	
	public AllRoomPageGenerator()	{
		super(AllRoomPageGenerator._template);
	}

	public AllRoomPageGenerator(String orderBy,String orderNature)	{
		super(AllRoomPageGenerator._template);
		this.orderBy=orderBy;
		this.orderNature=orderNature;
	}

	public AllRoomPageGenerator(String orderBy)	{
		super(AllRoomPageGenerator._template);
		this.orderBy=orderBy;
	}

	public AllRoomPageGenerator(HtmlTemplate _template,String orderBy,String orderNature)	{
		super(_template);
		this.orderBy=orderBy;
		this.orderNature=orderNature;
	}

	public AllRoomPageGenerator(HtmlTemplate _template)	{
		super(_template);
	}

	public AllRoomPageGenerator(HtmlTemplate _template,String orderBy)	{
		super(_template);
		this.orderBy=orderBy;
	}



	/** In this case we are overloading the format function Basically
	 * the AllPageGenerator has enough information to determine
	 * the paraeters required which it does so by invoking
	 * the underlying database*/
	public String format()	{
		return super.format(getParameters(getHtmlTemplate().getTags()));
	}

	/** This function takes an enumeration and determines the required
	 * parameters These parameters are determined by a heuristics which
	 * is encapsulated in this function and can thus be easily changed or
	 * overloaded*/
	public Hashtable getParameters(Enumeration enumeration)	{
		Hashtable hashtable=new Hashtable();

		String query="select * from Room where par_room_id=0 order by "+orderBy+" "+orderNature; 
		ResultSet rs=QueryEngine.executeQuery(query);
		if(rs==null)	{
			while(enumeration.hasMoreElements())	{
				hashtable.put((String)enumeration.nextElement(),"Unknown");
			}
			return hashtable;
		}
		String allItemsLink="";
		String table="<table>\n";

		try {
			while(rs.next())	{
					table+="<tr>";
					table+=getRow(rs);
					table+="</tr>\n";
			}
		}catch(SQLException e) {e.printStackTrace();}
		table+="</table>\n";
		while(enumeration.hasMoreElements())	{
			String element=(String)enumeration.nextElement();
			String tag="";
			if(element.equals("$$DBIS_ROOMSPACE_ROOMLIST$$"))	{
				tag=table;
			}
			hashtable.put(element,tag);
		}
		return hashtable;
	}

	protected String getRow(ResultSet rs)	{
		String row="<td>";
		String servlet=getServlet();
		try {
			int itemId=rs.getInt("room_id");
			String name=rs.getString("room_name");	
			String desc=rs.getString("room_desc");
			int len=25;
			if(desc.length()<=25)
				len=desc.length();
			desc=desc.substring(0,len);
			String servletLine=servlet+"?roomId="+itemId;
			String finalLine="<b><font size=+2><a HREF=\""+servletLine+"\"> "+name+"</a></font></b>";
			row+=finalLine;
			row+="</td>";
			row+="<td>"+desc+"...</td>";
		}catch(SQLException e) {e.printStackTrace();}
		return row;
	}

	protected String getServlet()	{
		String servlet=Singleton.getServletBody(Singleton.DBIS_SERVLET_ROOMPAGE);
		return servlet;
	}

	public static void main(String args[])	{
		System.out.println((new AllRoomPageGenerator()).format());
	}
}

