package DBIS.RoomSpace;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.StringTokenizer;
import java.sql.*;
import DBIS.Tools.HtmlTemplate;
import DBIS.Tools.PageGenerator;
import DBIS.Tools.Singleton;
import DBIS.Tools.QueryEngine;
import DBIS.Components.Item;

/** This class generates the page for the item with the suppiled
 * item id At first theinformation about the item is retrived
 * and is then used to get the requisite page*/
public class ItemPageGenerator	extends PageGenerator	{
 
	int itemId=-1;

	static HtmlTemplate _template;

	/** This static block loads the template file and stores
	 * it once for all for further instances*/
	static	{
		_template=HtmlTemplate.loadHtmlTemplate(Singleton.DBIS_ROOMSPACE_ITEMTEMPLATEFILE);
	}
	
	public ItemPageGenerator(int itemId)	{
		super(ItemPageGenerator._template);
		this.itemId=itemId;
	}

	public ItemPageGenerator(HtmlTemplate  _template,int itemId)	{
		super(_template);
		this.itemId=itemId;
	}

	/** In this case we are overloading the format function Basically
	 * the ItemPageGenerator has enough information to determine
	 * the paraeters required which it does so by invoking
	 * the underlying database*/
	public String format()	{
		return super.format(getParameters(getHtmlTemplate().getTags()));
	}

	/** This function takes an enumeration and determines the required
	 * parameters These parameters are determined by a heuristics which
	 * is encapsulated in this function and can thus be easily changed or
	 * overloaded*/
	public Hashtable getParameters(Enumeration enumeration)	{
		Item item=new Item(itemId);
		Hashtable hashtable=new Hashtable();
		while(enumeration.hasMoreElements())	{
			String tag=(String)enumeration.nextElement();
			String value="";
			if(tag.equals("$$DBIS_PRODUCT_NAME"))	{
				value=item.getName();
			}else if(tag.equals("$$DBIS_PRODUCT_IMAGE"))	{
				value=item.getPreviewURL();
			}else if(tag.equals("$$DBIS_PRODUCT_DESCRIPTION"))	{
				value=item.getDescription();
			}else if(tag.equals("$$DBIS_PRODUCT_ADDTOCART$$"))	{
				String servlet=Singleton.DBIS_SERVLET_ADDTOCART;
				String parameters="item_id="+item.getItemId();
				String servletLine=servlet+"?"+parameters;
				value=servletLine;
			}else if(tag.equals("$$DBIS_PRODUCT_VIEWCART$$"))	{
				String servlet=Singleton.DBIS_SERVLET_VIEWSHOPPINGCART;
				String servletLine=servlet;
				value=servletLine;
			}
			else if(tag.equals("$$DBIS_PRODUCT_RELATED"))	{
				value=getRoomLink(itemId);
			}
			hashtable.put(tag,value);
		}
		return hashtable;
	}

	protected String getRoomLink(int itemId)	{
		ResultSet tmp=QueryEngine.executeQuery("select room.room_name,room.room_id from roomItems,room where room.room_id=roomItems.room_id and roomItems.item_id="+itemId);
		String result="";
		try	{
			tmp.next();
			String name=tmp.getString("room_name");	
			String servlet=Singleton.getServletBody(Singleton.DBIS_SERVLET_ROOMPAGE);
			String servletLine=servlet+"?roomId="+tmp.getString("room_id");
			String finalLine="<b><i><font size=+1><a HREF=\""+servletLine+"\"> "+name+"</a></font></i></b>";
			result=finalLine;
		}catch(SQLException e) {e.printStackTrace();}
		return result;
	}

	public static void main(String args[])	{
		int id=1;
		System.out.println((new ItemPageGenerator(id)).format());
	}
}		
