import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.lang.*;
import java.sql.*;
import DBIS.Tools.*;
import DBIS.RoomSpace.ItemPageGenerator;

/**
 * This servelet is a utility by which the user can update her shopping cart.
 * The user gets details of all the items in her cart.
 * This servlet is invoked by the the <code>ViewShoppingCart</code>
 * servlet when the user presses the update button and it updates
 * and sets the quantities asset by the user in the textfields for the
 * different items in her cart.
 *
 * @author Dilys  Thomas
					Fri Oct  6 18:01:15 IST 2000
 */

public class AddtoCart extends HttpServlet {

 private Connection con;	


/**sets up the database connection and initialises the  the servlet.
 * @param 	<code>ServletConfig</code>
 * 
 */
public void init(ServletConfig config) throws ServletException
{
	super.init(config);
	try {
		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		con =DriverManager.getConnection(Singleton.DBIS_SQL_CONF,Singleton.DBIS_SQL_USERNAME,Singleton.DBIS_SQL_PASSWORD);
//		con =DriverManager.getConnection(Config.connection,Config.loginid,Config.password);
		 } catch (SQLException e) { 
		   throw new UnavailableException(this,"Could not Connect To the Database!!");}
}


	 /**Adds an item to the cart.
	  * If the item already exists in the cart its quantity
	  * is increased by one else it is inserted in the cart with quantity =1.
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
 public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException  
{
try{
 	Statement stmt;
	ResultSet rset;
	stmt = con.createStatement();
    // Get the current session object, create one if necessary
    HttpSession session = req.getSession(true);
  	String user_id=(String)session.getValue("user_id");
	res.setContentType("text/html");
    	PrintWriter toClient = res.getWriter();
	toClient.println(Singleton.DBIS_HTML_CSS);
	if (user_id == null)
	{
		 toClient.println("Please authenticate !!");
		 toClient.println("Either your session has expired or you have not yet logged in");
		 toClient.println("Login now to proceed");
		 toClient.println("<A HREF="+Singleton.DBIS_SQL_LOGINURL+"> Login Now!</A>");
	      toClient.println("</html>");
	}
    else
	{
		 String itemid=req.getParameter("item_id");
		 int item_id =Integer.parseInt(itemid);
		 String querystr="select quantity from ShoppingBasket where ((user_id = '"+ user_id+"' ) and (item_id = " + item_id+" ))"; 
	     rset=stmt.executeQuery(querystr);	
		 if (rset.next()) //item already present in the basket.
		 { //only increment the quantity field of the item in the users basket
			int oldquantity=rset.getInt(1);
			int newqty=oldquantity+1;
			String updatestr="update ShoppingBasket set quantity=" +newqty + " where ((user_id = '"+ user_id+"' ) and (item_id = " + item_id+" ))" ; 
		 	stmt.executeUpdate(updatestr);
		 }
		 else //item must be added to the basket
		 {
			  String insertstr="insert into ShoppingBasket values('"+user_id+"','"+item_id+"','"+"1')";
	   		  System.out.println(insertstr);
			  stmt.executeUpdate(insertstr);
		 }
		 toClient.println((new ItemPageGenerator(item_id)).format());
//		 ViewShoppingCart.generatePage(req,res);
//		 toClient.println("Your request has been  processed");
//		 toClient.println("To view your Updated cart click below");
//		 toClient.println("<body>");
//		 toClient.println("<form action="+Singleton.DBIS_SERVLET_BASEURL+"ViewShoppingCart  method=GET>");
//		 toClient.println("<BR><BR><input type=submit value=ViewCart>");
//		 toClient.println("</form></body></html>");
	}
} catch (SQLException e) { System.out.println("SQLexception"+e);} 
}

}
