
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.lang.*;
import java.sql.*;
import DBIS.Tools.*;



/**
 * This servelet is a utility by which the user can update her shopping cart.
 * The user gets details of all the items in her cart.
 * This servlet is invoked by the the <code>ViewShoppingCart</code>
 * servlet when the user presses the update button and it updates
 * and sets the quantities asset by the user in the textfields for the
 * different items in her cart.
 *
 * @author Dilys  Thomas
					Fri Oct  6 18:01:15 IST 2000
 */

public class UpdateCart extends HttpServlet {

 private Connection con;	


/**sets up the database connection and initialises the  the servlet.
 * @param 	<code>ServletConfig</code>
 * 
 */
public void init(ServletConfig config) throws ServletException
{
	super.init(config);
	try {
		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
//		con =DriverManager.getConnection(Config.connection,Config.loginid,Config.password);
		con =DriverManager.getConnection(Singleton.DBIS_SQL_CONF,Singleton.DBIS_SQL_USERNAME,Singleton.DBIS_SQL_PASSWORD);
		 } catch (SQLException e) { 
		   throw new UnavailableException(this,"Could not Connect To the Database!!");}
}


	 /**Edits the cart
	  * Updates the users cart.The main method of this class.
	  * @param req HttpServletRequest
	  * @param res HttpServletResponse
	  */
 public void doPost(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException  
{
try{
 	 Statement stmt;
	 ResultSet rset;
	 stmt = con.createStatement();
    res.setContentType("text/html");
    PrintWriter toClient = res.getWriter();
    // Get the current session object, create one if necessary
    HttpSession session = req.getSession(true);
    toClient.println(Singleton.DBIS_HTML_CSS);
  	String user_id=(String)session.getValue("user_id");
	if (user_id == null)
	{
		 toClient.println("Please authenticate !!");
		 toClient.println("Either your session has expired or you have not yet logged in");
		 toClient.println("Login now to proceed");
		 toClient.println("<A HREF="+Singleton.DBIS_SQL_LOGINURL+"> Login Now!</A>");
	     toClient.println("</html>");
	}
    else
	{
		 Enumeration names=req.getParameterNames();
		 while (names.hasMoreElements())
		 {
			  String paramname=(String)names.nextElement();
			  String header="data__";//this header is prefixed to those fields
			  				//that  have item_id's as input!
			  if (paramname.regionMatches(0,header,0,header.length()))
			  {
				 System.out.println(paramname);
				 String item_id=paramname.substring(header.length());
				 			//trimming the parameter name  to get the item_id
				 String newqtystr=req.getParameter(paramname);
				 System.out.println("newqtystr is::"+newqtystr);
				 int newqty=0;

				 try{
					 newqty=Integer.parseInt(newqtystr.trim());
				 } catch (NumberFormatException e) {
					String page=(new ErrorPageGenerator("The number enetered is not of valid format")).format();
					toClient.println(page);
				}
					
				 if (newqty==0) //do delete!!
				 {
	 				String sqlstmt="delete from ShoppingBasket where ((user_id = '"+ user_id+"' ) and (item_id = " + item_id+" ))" ; 
		     		stmt.executeUpdate(sqlstmt);
				 }
				 else  //do update of the quantity!
				{
					System.out.println("item id is::"+item_id);
					String updatestr="update ShoppingBasket set quantity=" +newqty + " where ((user_id = '"+ user_id+"' ) and (item_id = " + item_id+" ))" ; 
					System.out.println(updatestr);
					stmt.executeUpdate(updatestr);
					System.out.println("DONE!!");
				}
		}
	}
 }
 ViewShoppingCart.generatePage(req,res);
// toClient.println("Your request has been  processed");
// toClient.println("To view your Updated cart click below");
// toClient.println("<body>");
// toClient.println("<form action="+Singleton.DBIS_SERVLET_BASEURL+"ViewShoppingCart  method=GET>");
// toClient.println("<BR><BR><input type=submit value=ViewCart>");
// toClient.println("</form></body></html>");
 } catch (SQLException e) { System.out.println("SQLexception"+e);} 
}

}
