import java.io.*;
import java.text.*;
import java.util.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import DBIS.Tools.*;

public class Auction extends HttpServlet{

	 static Connection conn = null;
	 static Statement stmt = null;
	 static int incr_price = 10;

	 public void init(ServletConfig scfg) throws ServletException{
		  try{
			   DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
			   conn = DriverManager.getConnection(Singleton.DBIS_SQL_CONF,Singleton.DBIS_SQL_USERNAME,Singleton.DBIS_SQL_PASSWORD);
			   stmt = conn.createStatement();  
		  } catch(SQLException sqle){System.out.println(sqle);}

	 }

	 public void doPost(HttpServletRequest req,HttpServletResponse resp){
		  String act = req.getParameter("activity");
		  if(act.equals("selling")){
			   try{
					sello(req,resp);
			   }catch(Exception e){ System.out.println(e.toString());}
		  }else{
			   try{
					buyo(req,resp);
			   }catch(Exception e){ System.out.println(e.toString());}
		  }
	 }

	 public static void init_prnt(PrintWriter out,String title){
		  out.println("<html> <head> <title> " + title + " </title>");
		  out.println("</head> " + Singleton.DBIS_HTML_CSS);
		  out.println("<body>");
	 }

	 public static void end_prnt(PrintWriter out){
		  out.println("</body> </html>");
	 }

	 public synchronized static int getItemId(){
		  int item_id = 0;
		  try{
			   String q_str = "select * from GlobalVarz";
			   ResultSet rs = stmt.executeQuery(q_str);
			   while(rs.next()){
					String name = rs.getString("name");
					if(name.equals("item_id")){
						 String item_str = rs.getString("value");
						 item_id = Integer.parseInt(item_str);
						 break;
					}
			   }
			   item_id++;
			   String u_str = "update GlobalVarz set value = '" + item_id + "' where " +
					"name = 'item_id'";
			   stmt.executeUpdate(u_str);
		  }catch(Exception e){ System.out.println(e.toString() + "gotch2");}
		  return item_id;
	 }

	 public static String getMonth(int month){
		  switch(month){
			   case 0: return "JAN";
			   case 1: return "FEB";
			   case 2: return "MAR";
			   case 3: return "APR";
			   case 4: return "MAY";
			   case 5: return "JUN";
			   case 6: return "JUL";
			   case 7: return "AUG";
			   case 8: return "SEP";
			   case 9: return "OCT";
			   case 10: return "NOV";
			   case 11: return "DEC";
		  }
		  return "ERROR";
	 }


	 public static void sello(HttpServletRequest req,HttpServletResponse resp) throws Exception{
		  PrintWriter out = null;
		  try{
			   out = resp.getWriter();
		  }catch(Exception e){ System.out.println(e.toString());}
		  resp.setContentType("text/html");
		  init_prnt(out,"SELLING ITEMS");
		  HttpSession sess = req.getSession(true);
		  String user = sess.getValue("user_id") + ""; 

		  if((user == null) || (user.equals(""))){
			   out.println("Sorry,you need to be a registered user to "
						 + " avail of this service");
			   out.println("You can register <a href=" + Singleton.DBIS_SQL_REGISTERURL + ">here</a>");
			   out.println("If you have a registered user,kindly login " +
						 "<a href=" + Singleton.DBIS_SQL_LOGINURL + ">here</a>");
			   out.println("</body></html>");
			   return;
		  }	  
		  String item_name = req.getParameter("item_name");
		  int item_qty = Integer.parseInt(req.getParameter("item_qty"));
		  float reserve_price = 
			   (Float.valueOf(req.getParameter("reserve_price"))).floatValue();
		  String preview_url = req.getParameter("preview_url");
		  int year = Integer.parseInt(req.getParameter("year"));
		  int month = Integer.parseInt(req.getParameter("month"));
		  month--;
		  int day = Integer.parseInt(req.getParameter("day"));
		  String item_desc = req.getParameter("item_desc");
		  java.sql.Date cal = new java.sql.Date(year - 1900,month,day);
		  java.sql.Date cal_tmp = new java.sql.Date(System.currentTimeMillis() + 
					3*30*24*60*60*1000);
		  java.sql.Date curr_tmp = new java.sql.Date(System.currentTimeMillis());
		  if(cal.before(curr_tmp)){
			out.println("Sorry,your lapse period is too long....change it to a "
			+ " a value less than 3 months");
			out.println("Or your lapse date is before the current date");
			String redirect =  HttpUtils.getRequestURL(req).toString(); 
			out.println("<a href=" + redirect + "> Back </a>");
			end_prnt(out);
			return;
			}
		  
		  int item_id = getItemId();	
		  String date_str = "to_date('" + cal.toString() + "','yyyy-mm-dd')";
		  String update_str = "insert into auctionz values(" + item_id + 
			   ",'" + item_name + "'," + item_qty + "," + reserve_price + ",'" + preview_url 
			   + "','" + item_desc + "'," + date_str + ",'" +  user + "')";
		  System.out.println(update_str);
		  try{
			   stmt.executeUpdate(update_str);
		  }catch(Exception e){System.out.println(e.toString());}

		  out.println("Thank you for availing of i-shop.com`s auction-" 
					+ "selling facility");
		  out.println("</body> </html>");

	 }

	 public static void buyo(HttpServletRequest req,HttpServletResponse resp) throws Exception{
		  PrintWriter out = null;
		  try{
			   out = resp.getWriter();
		  }catch(Exception e){ System.out.println(e.toString());}
		  resp.setContentType("text/html");
		  init_prnt(out,"BUYING ITEMS");
		  HttpSession sess = req.getSession(true);
		  String user = sess.getValue("user_id") + ""; 

		  if((user == null) || (user.equals(""))){
			   out.println("Sorry,you need to be a registered user to "
						 + " avail of this service");
			   out.println("You can register <a href=" + Singleton.DBIS_SQL_REGISTERURL + ">here</a>");
			   out.println("If you have a registered user,kindly login " +
						 "<a href=" + Singleton.DBIS_SQL_LOGINURL + ">here</a>");
			   out.println("</body></html>");
			   return;
		  }	 
		  int item_id = Integer.parseInt(req.getParameter("item_id"));
		  float qtd_price = 
			   (Float.valueOf(req.getParameter("qtd_price"))).floatValue();
		  String query_str = "select qtd_price from aucstatz where "
			   + "item_id = " + item_id;
		  ResultSet rs = stmt.executeQuery(query_str);
		  if(rs.next()){
			   float original_price = rs.getFloat(1);
			   System.out.println(original_price + " orig price ");
			   if(qtd_price >= (original_price + incr_price)){
					//Concurrency issuez??
					//can the two updatez be rolled into one??
					try{
						 String update_str = "update aucstatz set qtd_price = " +
							  qtd_price + " where item_id = " + item_id;
						 stmt.executeUpdate(update_str);
						 update_str = "update aucstatz set buyer = '" +
							  user + "' where item_id = " + item_id;
						 stmt.executeUpdate(update_str);
						 out.println("Congratz,your quote has been accepted");
						 end_prnt(out);
					}catch(Exception e){ System.out.println(e.toString());}
			   }else{
					float ft = original_price + incr_price;
					out.println("Sorry,your quote has to be atleast "
							  + ft);
					end_prnt(out);
					return;
			   }
		  }else{
			   String q_str = "select reserve_price from auctionz where item_id = "
					+ item_id ;
			   rs = stmt.executeQuery(q_str);
			   rs.next();
			   float r_price = rs.getFloat("reserve_price");
			   if(qtd_price < r_price){
					out.println("Sorry,your quote has to be at least " + r_price);
					end_prnt(out);
					return;
			   }
			   String update_str = "insert into aucstatz values(" + item_id + 
					"," + qtd_price + ",'" + user + "')";
			   stmt.executeUpdate(update_str);
			   out.println("Congratz,your quote has been accepted");
			   end_prnt(out);
		  }
	 }


	 public static void auc_detailz(HttpServletRequest req,HttpServletResponse resp) throws Exception{
		  PrintWriter out = resp.getWriter();
		  resp.setContentType("text/html");
		  init_prnt(out,"AUCTION DETAILS");
		  String query_str1 = "select auctionz.item_id,item_name,item_qty,reserve_price,preview_url,"
			   + "item_desc,join_date,seller,qtd_price,buyer from auctionz,aucstatz where "
			   + "auctionz.item_id = aucstatz.item_id";
		  //String query_str1 = "select * from auctionz,aucstatz where "
		  //   + "auctionz.item_id = aucstatz.item_id";
		  String query_str2 = "select item_id,item_name,item_qty,reserve_price,preview_url,"
			   + "item_desc,join_date,seller,0,'' from auctionz where item_id not in "
			   + "(select item_id from aucstatz)";
		  //put 0 and '' instead of null,null coz of cribz
		  String query_str = query_str1 + " union " + query_str2;
		  ResultSet rs = null;
		  try{			
			   rs = stmt.executeQuery(query_str);
		  }catch(Exception e){ System.out.println(e + " gotch1");}
		  ResultSetMetaData rsmd = rs.getMetaData();
		  out.println("<table border=1> <tr class=frow>");
		  for(int i = 1;i <= rsmd.getColumnCount();i++){
			   if(!(rsmd.getColumnName(i).equals("item_id"))){
					out.println("<td> " + rsmd.getColumnName(i) + "</td>");
			   }
		  }
		  out.println("</tr>");
		  while(rs.next()){
			   out.println("<tr class=orow>");
			   int item_id = rs.getInt("item_id");
			   for(int j = 1; j <= rsmd.getColumnCount() ; j++){
					if(rsmd.getColumnName(j).equals("ITEM_NAME")){
						 out.println("<td> <a href=" + Singleton.DBIS_SERVLET_BASEURL + "Auction?activity=item_quote" +
								   "&item=" + item_id + "> " +
								   rs.getObject(j) + "</a> </td>");
						 continue;
					}
					if(rsmd.getColumnName(j).equals("PREVIEW_URL")){
						 out.println("<td> <a href=" + rs.getObject(j) +
								   ">" + rs.getObject(j) + "</a> </td> ");
						 continue;
					}

					if(!(rsmd.getColumnName(j).equals("item_id"))){
						 out.println("<td> " + rs.getObject(j) + " </td>");
					}
			   }
			   out.println("</tr>");
		  }
		  out.println("</table>");
		  out.println("Click on the item for which you want to give a quote");
		  out.println("Click <a href=" + Singleton.DBIS_SERVLET_BASEURL + "Auction?activity=item_sell>here</a> " 
					+ "if you want to sell something");
		  out.println("</body> </html>");
	 }


	 public static void item_sell(HttpServletRequest req,HttpServletResponse resp) throws Exception{
		  resp.setContentType("text/html");
		  PrintWriter out = resp.getWriter();
		  out.println("<html> <head> SELLING ITEMS </head> </html> <body>");
		  out.println("Please enter the following information :: ");
		  out.println("<form action=" + Singleton.DBIS_SERVLET_BASEURL + "Auction method=POST>");
		  out.println("ITEM_NAME <br>");
		  out.println("<input type=text size=20 name=item_name> <br>");
		  out.println("ITEM_QTY <br>");
		  out.println("<input type=text size=5 name=item_qty> <br>");
		  out.println("RESERVE_PRICE <br>");
		  out.println("<input type=text size=10 name=reserve_price> <br>");
		  out.println("PREVIEW_URL <br>");
		  out.println("<input type=text size=20 name=preview_url> <br>");
		  out.println("ITEM_DESC <br>");
		  out.println("<input type=text size=50 name=item_desc> <br>");
		  out.println("give the date till auction should last ::");
		  out.println("DAY <br>");
		  out.println("<input type=text size=2 name=day> <br>");
		  out.println("MONTH <br>");
		  out.println("<input type=text size=2 name=month> <br>");
		  out.println("YEAR <br>");
		  out.println("<input type=text size=4 name=year> <br>");
		  out.println("<input type=hidden name=activity value=selling>");
		  out.println("<input type=submit>");
		  out.println("</form>");
		  out.println("</body> </html>");
	 }

	 public static void item_quote(HttpServletRequest req,HttpServletResponse resp) throws Exception{
		  PrintWriter out = resp.getWriter();
		  resp.setContentType("text/html");
		  int item_id = Integer.parseInt(req.getParameter("item"));
		  out.println("<html> <head> <title> QUOTE OF ITEMS </title> </head> ");
		  out.println(Singleton.DBIS_HTML_CSS + "<body>");
		  out.println("<br> Please quote the price for the chosen item ::");
		  out.println("<form action= " + Singleton.DBIS_SERVLET_BASEURL + "Auction method=POST>");
		  out.println("<input type=text size=10 name=qtd_price> <br>");
		  out.println("<input type=hidden name=activity value=item_quote>");
		  out.println("<input type=hidden name=item_id value=" + 
					item_id + ">");
		  out.println("<input type=submit>");
		  out.println("</form>");
		  out.println("</body> </html>");
	 }

	 /*
		String update_str = "insert into auctionz values(" + item_id + 
		",'" + item_name + "'," + item_qty + "," + reserve_price + ",'" + 
		preview_url + "','" + item_desc + "','" + day + "-" + 
		getMonth(month) + "-" + year + "','" + user + "'";

	  */

	 public void doGet(HttpServletRequest req,HttpServletResponse resp){
		  String activity = req.getParameter("activity");
		  try{
			   if(activity.equals("auc_detailz")){
					auc_detailz(req,resp);
			   }else if(activity.equals("item_quote")){
					item_quote(req,resp);
			   }else if(activity.equals("item_sell")){
					item_sell(req,resp);
			   }
		  }catch(Exception e){ System.out.println(e.toString());}
	 }
}

