package DBIS.Tools;

import java.sql.*;
import java.util.Vector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.io.FileInputStream;
import DBIS.Tools.Singleton;
import DBIS.Tools.QueryEngine;
import DBIS.Tools.PageGenerator;
import DBIS.Tools.HtmlTemplate;

/** This generates a html page which contains all items These are
 * primarily links to the item page*/
public class PlotPageGenerator	extends PageGenerator {

	String message="";
	String appletCode="";

	static HtmlTemplate _template;

	/** This static block loads the template file and stores
	 * it once for all for further instances*/
	static	{
		_template=HtmlTemplate.loadHtmlTemplate(Singleton.DBIS_CONFIGURATOR_PLOT_LINEGRAPHTEMPLATE);
	}
	
	public PlotPageGenerator()	{
		super(PlotPageGenerator._template);
	}

	public PlotPageGenerator(String appletCode,String message)	{
		super(PlotPageGenerator._template);
		this.appletCode=appletCode;
		this.message=message;
	}

	public PlotPageGenerator(String appletCode)	{
		super(PlotPageGenerator._template);
		this.appletCode=appletCode;
	}
		

	/** In this case we are overloading the format function Basically
	 * the AllPageGenerator has enough information to determine
	 * the paraeters required which it does so by invoking
	 * the underlying database*/
	public String format()	{
		return super.format(getParameters(PlotPageGenerator._template.getTags()));
	}

	/** This function takes an enumeration and determines the required
	 * parameters These parameters are determined by a heuristics which
	 * is encapsulated in this function and can thus be easily changed or
	 * overloaded*/
	public Hashtable getParameters(Enumeration enumeration)	{
		Hashtable hashtable=new Hashtable();

		while(enumeration.hasMoreElements())	{
			String element=(String)enumeration.nextElement();
			String tag="";
			if(element.equals("$$DBIS_CONFIGURATOR_PLOTS_INFO$$"))	{
				tag=message;
			}
			if(element.equals("$$DBIS_CONFIGURATOR_PLOTS_APPLETCODE$$"))	{
				tag=appletCode;
			}
			hashtable.put(element,tag);
		}
		return hashtable;
	}

}
