drop table LOGIN;
drop table REGISTER;
drop table RESOLVE;
drop table COMPLAINT_TYPE;
drop table WORKER_TYPE;
drop table WORKS_FOR;
drop table COMPLAINTEE;
drop table COMPLAINT;
drop table WORKER;
drop table SUPERVISOR;
drop table TYPE;

create table LOGIN
(
name char(20),
passwd varchar(30) not null,
login_type char(15) not null 
--primary key (name)
);

create table COMPLAINTEE 
(user_id char(20),
name varchar(50) not null,
job varchar(20),
contact_info long not null,
room_no varchar(50),
building varchar(50),
primary key (user_id));

create table COMPLAINT
(complaint_id integer,
title varchar(50),
description long not null,
status varchar(100),
date_lodged date,
start_date date,
end_date date,
feedback varchar(200),
rating integer,
location varchar(100),
primary key (complaint_id));

create table WORKER
(worker_id char(20),
name varchar(50) not null,
designation varchar(20),
company varchar(40),
contact_info long not null,
room_no varchar(50),
building varchar(50),
primary key (worker_id));

create table SUPERVISOR
(supervisor_id char(20),
name varchar(50) not null,
contact_info long not null,
room_no varchar(50),
building varchar(50),
primary key (supervisor_id));

create table TYPE
(type_id char(20),
description varchar(50) not null,
primary key (type_id));

create table REGISTER
(user_id char(20) references COMPLAINTEE,
complaint_id integer references COMPLAINT);

create table RESOLVE
(worker_id char(20) references WORKER,
complaint_id integer references COMPLAINT);

create table COMPLAINT_TYPE
(type_id char(20) references TYPE,
complaint_id integer references COMPLAINT);

create table WORKER_TYPE
(type_id char(20) references TYPE,
worker_id char(20) references WORKER);

create table WORKS_FOR
(worker_id char(20) references WORKER,
supervisor_id char(20) references SUPERVISOR);

--
-- LOGIN
insert into LOGIN values ('pravin','pravin','complaintee');
insert into LOGIN values ('c1','c1','complaintee');
insert into LOGIN values ('c2','c2','complaintee');
insert into LOGIN values ('c3','c3','complaintee');
insert into LOGIN values ('c4','c4','complaintee');
insert into LOGIN values ('c5','c5','complaintee');
insert into LOGIN values ('s1','s1','supervisor');
insert into LOGIN values ('s2','s2','supervisor');
insert into LOGIN values ('s3','s3','supervisor');
insert into LOGIN values ('w1','w1','worker');
insert into LOGIN values ('w2','w2','worker');
insert into LOGIN values ('w3','w3','worker');
insert into LOGIN values ('gava','gavaa','worker');
insert into LOGIN values ('a1','a1','analyst');
insert into LOGIN values ('a2','a2','analyst');
insert into LOGIN values ('a3','a3','analyst');
insert into LOGIN values ('gav','gav','administrator');


--COMPLAINTEE

insert into COMPLAINTEE values ('pravin', 'Pravin Paratey', 'Student',
	'5602', '127', 'Hostel 2');
insert into COMPLAINTEE values ('c1', 'Complaintee 1', 'Student',
	'5602', '1', 'Hostel 2');
insert into COMPLAINTEE values ('c2', 'Complaintee 2', 'Student',
	'5602', '2', 'Hostel 2');
insert into COMPLAINTEE values ('c3', 'Complaintee 3', 'Student',
	'5602', '3', 'Hostel 2');
insert into COMPLAINTEE values ('c4', 'Complaintee 4', 'Student',
	'5602', '4', 'Hostel 2');
insert into COMPLAINTEE values ('c5', 'Complaintee 5', 'Student',
	'5602', '5', 'Hostel 2');

--COMPLAINT
insert into COMPLAINT values (1, 'Replace Window Pane', 
'Hi. My window pane is broken. I am very sad. Now i feel cold.','',
'10-OCT-2001','14-OCT-2001','','','','H2');

insert into COMPLAINT values (2,'Painting room',
'Paint my room or else the wrath of dr. varun will get you','','15-SEP-2001','','','','','H7');

insert into COMPLAINT values (3, 'Broken Table','My tables broken. Fix it','Starting tomorrow',
'13-OCT-2001','15-OCT-2001','','','','H2');

insert into COMPLAINT values (4, 'Grounding', 'My room needs to be grounded.','','3-NOV-2001',
'4-NOV-2001','5-NOV-2001','','','H2');

insert into COMPLAINT values (5, 'Hard Disk', 'My hard disk crashed.','','15-NOV-2001',
'17-NOV-2001','21-NOV-2001','','','H2');

insert into COMPLAINT values (6, 'Water Heater', 'My wing has a faulty water heater.','',
'5-NOV-2001','','','','','H6');

insert into COMPLAINT values (7, 'Water Heater', 'My wing has a faulty bog.','',
'2-NOV-2001','','','','','H7');


--REGISTER
insert into REGISTER values ('pravin',1);
insert into REGISTER values ('pravin',3);
insert into REGISTER values ('pravin',4);
insert into REGISTER values ('pravin',7);
insert into REGISTER values ('c1',2);
insert into REGISTER values ('c1',5);
insert into REGISTER values ('c1',6);

--WORKER
insert into WORKER values ('gava', 'gava', 'plumber', 'Gufa Plumbers Inc.', 
	'mobile:9820004567', '146', 'Hostel 2');
insert into WORKER values ('w1', 'Worker 1', 'plumber', 'Gufa Plumbers Inc.', 
	'mobile:9820004567', '146', 'Hostel 2');
insert into WORKER values ('w2', 'Worker 2', 'plumber', 'Gufa Plumbers Inc.', 
	'mobile:9820004567', '146', 'Hostel 3');
insert into WORKER values ('w3', 'Worker 3', 'plumber', 'Gufa Plumbers Inc.', 
	'mobile:9820004567', '141', 'Hostel 4');

--RESOLVE
insert into RESOLVE values ('gava', 1);
insert into RESOLVE values ('gava', 2);
insert into RESOLVE values ('w1', 4);
insert into RESOLVE values ('gava', 6);

--TYPE
insert into TYPE values ('comp','Computer');
insert into TYPE values ('elec','Electrical');
insert into TYPE values ('carp','Carpentry');
insert into TYPE values ('mason','Masonary');
insert into TYPE values ('paint','Paint Job');
insert into TYPE values ('mess','Mess Food ;)');

--COMPLAINT_TYPE
insert into COMPLAINT_TYPE values ('carp', 1);
insert into COMPLAINT_TYPE values ('paint', 2);
insert into COMPLAINT_TYPE values ('carp', 3);
insert into COMPLAINT_TYPE values ('elec', 4);
insert into COMPLAINT_TYPE values ('comp', 5);
insert into COMPLAINT_TYPE values ('mason', 6);
insert into COMPLAINT_TYPE values ('mason', 7);



--SUPERVISOR
insert into SUPERVISOR values ('s1', 'Supervisor 1', 'plumber', '301','H7');
insert into SUPERVISOR values ('s2', 'Supervisor 2', 'Computer Guy', '289','H3');

--WORKS_FOR
insert into WORKS_FOR values ('gava','s1');
insert into WORKS_FOR values ('w1','s1');
insert into WORKS_FOR values ('w2','s2');
insert into WORKS_FOR values ('w3','s2');

--WORKER_TYPE
insert into worker_type values ('carp','gava');
insert into worker_type values ('carp','w1');
insert into worker_type values ('mason','w2');
insert into worker_type values ('elec','w3');
