package bin.amit;
import java.io.*;
import java.sql.*;
import java.lang.*;
import java.util.*;

public class ConnectionManager {
    Connection con[];
    Statement stmt[];
    ResultSet rs[];
    boolean free[];
    static String dbURL;
    static String dbLogin;
    static String dbPasswd;
    static String basedir="/home2/ug99/amit/MIMS/";
    public static int MAX = 5;
    static {
	 try{
	     String s = null;
	     FileReader fr = new FileReader(basedir+"scripts/properties");
	     BufferedReader br= new BufferedReader(fr);
	     while((s=br.readLine())!=null){
		 int i=s.indexOf("=");
		 if (i==-1) break;
		 String name=s.substring(0,i);
		 String val=s.substring(i+1);
		 System.out.println("name =" +name+"val ="+val);
		
		 if (name.equals("dbURL")){
		     dbURL=val;
		 }

		 if (name.equals("dbLogin")){
		     dbLogin=val;
		 }
		 if (name.equals("dbPasswd")){
		     dbPasswd=val;
		 }
	     }

	     System.out.println(dbURL);
	     System.out.println(dbLogin);
	     System.out.println(dbPasswd);
	     
	 }catch(IOException e){
	     System.out.println("Exception in Config : "+e);
	 }
    }



    ConnectionManager(){
	try{
	    con = new Connection[MAX];
	    stmt = new Statement[MAX];
	    rs = new ResultSet[MAX];
	    free = new boolean[MAX];
	    DriverManager.registerDriver( new oracle.jdbc.driver.OracleDriver());
	    for (int i=0;i<MAX;i++){
		con[i] = DriverManager.getConnection( dbURL, dbLogin,dbPasswd);
		stmt[i] = con[i].createStatement();
		free[i] = true;
	    }
	}catch(Exception sqle){
	    System.out.println("Exception " + sqle);
	}
    }

    public synchronized int getHandle() {
	for (int i=0;i<MAX;i++){
	    if (free[i]) {
		free[i] = false;
		return i;
	    }
	}
	return -1;
    }

    public  ResultSet executeQuery(String query) throws SQLException{
	try {
	    if(query!=null){
		int k;
		System.out.println("query is :" + query);
		while ((k = getHandle()) == -1) {
		    Thread.sleep(1000);
		    System.out.println("sleeping");
		}
		System.out.println("In executeQuery k="+k);
		rs[k] = stmt[k].executeQuery(query);
		free[k] = true;
		 return rs[k];
	    }
	    else{
		return null;
	    }

	}catch(Exception sqle){
	    System.out.println("Exception " + sqle);
	    return null;
	}
    }


    public  void executeUpdate(String query) throws SQLException{
	try {
	    if(query!=null){
		int k;
		System.out.println("query is :" + query);
		while ((k = getHandle()) == -1) {
		    Thread.sleep(1000);
		    System.out.println("sleeping");
		}
		System.out.println("In executeUpdate k="+k);
		stmt[k].executeUpdate(query);
		free[k] = true;
	    }
	}catch(Exception sqle){
	    System.out.println("Exception " + sqle);
	}
    }
}







