/*tables assumed 
  CELEBRITY(CELEB_ID, CELEB_NAME, CELEB_DESCRIPTION, CELEB_SEX, CELEB_ADDRESS, CELEB_PHONE_NUMBER, CELEB_EMAIL)
  
  CELEB_ASSOC_WITH(CELEB_ID, CELEB_DESIGNATION, EVENT_ID, ROUND_NO)

*/
/*
Purposes:
    o putCelebRegisterForm
    o putViewCelebInfoForm
    o addEventToCeleb //left
    o registerCeleb
    o viewCelebInfoByName
    o changeCelebInfo //left
    o viewAllCelebs
*/
package bin.janik;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

public class CelebrityStuff extends HttpServlet { 
    
    Connection con;
    Statement stmt;
    ResultSet rs ;
    ResultSetMetaData rsmd;
    
    Config config = new Config();

    public void init (ServletConfig conf) throws ServletException {
	super.init(conf);
	con = null;
	stmt = null;
	rs = null;
	rsmd = null;
	try {
	    DriverManager.registerDriver( new oracle.jdbc.driver.OracleDriver());
	    con = DriverManager.getConnection(Config.dbURL, Config.dbLogin, Config.dbPasswd);
	    int numtries = 0;
	    while ((con==null) && (numtries<=10)) {//take care of this while loop
		con = DriverManager.getConnection( Config.dbURL, Config.dbLogin, Config.dbPasswd);
		try{ Thread.sleep(500);}catch(Exception e){System.out.println("Thread interrupted");}
		numtries++;
	    }
	    stmt = con.createStatement();
	} catch (SQLException sqle) {System.out.println("Unable to make connection");}
    }
    
    
    public synchronized void doGet (HttpServletRequest req, 
		       HttpServletResponse res) 
	throws ServletException, IOException {
	PrintWriter out;
	HttpSession session = req.getSession(false);//false is used because if a session dne, then I dont want to create a new one. Is this correct?
	out = res.getWriter();
	res.setContentType("text/html");    	

	String purpose = req.getParameter("purpose");
	String queryMaker = "";

	System.out.println("Purpose is " + purpose);

	if (session != null) { 
	    
	    queryMaker = (String)session.getValue("login");

	    if (purpose.equals("putCelebRegisterForm")) {
		OutputGenerator.dumpCelebRegisterForm1(out);
		dumpCelebRegisterForm(out);
		out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		out.close();
	    }


	    if (purpose.equals("putViewCelebInfoForm")) {
		OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		dumpViewCelebInfoForm(out);
		out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		out.close();
	    }
	    
	    if (purpose.equals("registerCeleb")) {
		String celeb_name = req.getParameter("name1");
		String celeb_sex = req.getParameter("sex");
		String celeb_email = req.getParameter("email");
		String celeb_address = req.getParameter("address");
		String celeb_phone_number = req.getParameter("phonenumber");
		String event_name = req.getParameter("event");
		String round_no = req.getParameter("round");
		String desig = req.getParameter("desig");
		String descrip = req.getParameter("descrip");	
		//ANY TEAM MEMBER CAN ADD A CELEB. NO HASSLES OF MANAGING THE SAME EVENT
		if (checkCG(queryMaker) || checkOC(queryMaker) || existsCordi(queryMaker)) {
		    String query = "";
		    int count = 0;
		    int event_id = retEventID(event_name);
		    try {
			if (checkUniqueCeleb(celeb_name)) {
			    
			    count = genCelebID();
			    System.out.println("celeb_id is "+count);
			    query = "insert into CELEBRITY values ("+count+",'"+celeb_name+"','"+descrip+"','"+celeb_sex+"','"+celeb_address+"','"+celeb_phone_number+"','"+celeb_email+"')";
			    System.out.println(query);
			    stmt.executeUpdate(query);
			    System.out.println("inserted into CELEBRITY");
		
			    query = "insert into CELEB_ASSOC_WITH values ("+count+",'"+desig+"',"+event_id+","+round_no+")";
			    System.out.println(query);
			    stmt.executeUpdate(query);
			    System.out.println("inserted into CELEB_ASSOC_WITH");

			    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			    out.println(celeb_name + "registered successfully.<br>");
			    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
			} else {
			    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			    out.println("Please change the celeb name. This one is already taken.<br><a href="+Config.servletURL+"CelebrityStuff?purpose=putCelebregisterForm>Back</a> to registration page.");
			    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
			}
		    } catch (Exception e) {
			System.out.println("Some exception");
			OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			out.println("There is some error in your query. Please try again.<br><a href="+Config.servletURL+"CelebrityStuff?purpose=putCelebRegisterForm>Back</a> to registration page.");
			out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		    }
		} else {//if not CG or OC or Cordi
		    OutputGenerator.putFile(out, "forms/NoPerms.html");
		}
	    }//end purpose registerCeleb
	    
	    if (purpose.equals("viewAllCelebs")) {
		if ((checkCG(queryMaker)) || (checkOC(queryMaker)) || (existsCordi(queryMaker))) {
		    String query = "select CELEB_ID Id, CELEB_NAME Name, CELEB_DESCRIPTION Description, CELEB_EMAIL EMail, CELEB_SEX Sex, CELEB_ADDRESS Address, CELEB_PHONE_NUMBER Phone from CELEBRITY";
		int temp_id = 0;
		String query2 = "";
		Statement stmt2 = null;
		ResultSet rs2 = null;
		ResultSetMetaData rsmd2 = null;
		try {
		    stmt2 = con.createStatement();
		    System.out.println(query);
		    rs = stmt.executeQuery(query);
		    rsmd = rs.getMetaData();
		    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		    out.println("<h3>Celebrity Information<h3>");
		    out.println("<table width=90% cellpadding=0 border=2 cellspacing=1>");
		    out.print("<tr align=center>");
		    for (int i = 1; i<=rsmd.getColumnCount(); i++) 
			out.print("<td>"+rsmd.getColumnName(i)+"</td>");
		    
		    out.println("<td>(Event, round, designation)</td></tr>");
		    System.out.println("rsmd wala part ho gaya, error nahin aaya");
		    while (rs.next()) {
			System.out.println("before extracting celeb_id");
			//temp_id = rs.getInt("celeb_id");
			temp_id = rs.getInt("id");
			System.out.println("after extracting celeb_id");
			query2 = "select A.EVENT_NAME Event, B.ROUND_NO Round, B.CELEB_DESIGNATION Designation from EVENT A, CELEB_ASSOC_WITH B where A.EVENT_ID = B.EVENT_ID and B.CELEB_ID = "+temp_id;
			System.out.println(query2);
			rs2 = stmt2.executeQuery(query2);
			System.out.println("query2 executed");
			rsmd2 = rs2.getMetaData();
			System.out.println("meta-data aa gaya");
			out.print("<tr align=center>");
			for (int i = 1; i<=rsmd.getColumnCount(); i++)
			    out.print("<td>"+rs.getString(i)+"</td>");
			out.print("<td>");
			while (rs2.next()) 
			    out.print("("+rs2.getString(1)+", "+rs2.getInt(2)+", "+rs2.getString(3)+") ;");
			out.println("</td></tr>");
			System.out.println("One row of table done");
		    }
		    out.println("</table>");
		    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		} catch (Exception e) {System.out.println("Some exception");
		e.printStackTrace();
		OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		out.println("There is something wrong with your query. Please try again.<br><a href="+Config.servletURL+"CelebrityStuff?purpose=putViewCelebInfoForm>Back</a> to CG registration page</body></html>");
		out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		}
		} else 
		    OutputGenerator.putFile(out, "forms/NoPerms");
	    }//end purpose viewAllCelebs
	    
	    if (purpose.equals("viewCelebInfoByName")) {
		String celeb_name = req.getParameter("celebname");
				
		//All team members are allowed to view details of celebs
		if ((checkCG(queryMaker)) || (checkOC(queryMaker)) || (existsCordi(queryMaker))) {
		    try {
			String query = "select CELEB_ID Id_Number, CELEB_NAME Name, CELEB_DESCRIPTION Description, CELEB_EMAIL EMail, CELEB_SEX Sex, CELEB_ADDRESS Address, CELEB_PHONE_NUMBER Phone from CELEBRITY where CELEB_NAME = '"+celeb_name+"'";
			
			OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			out.println("The celebrity information is as follows:<br>");
			rs = stmt.executeQuery(query);
			OutputGenerator.genVerticalTable(rs, out);
			out.println("<br>Events associated with "+celeb_name+":<br>");
			query = "select A.EVENT_NAME Event, B.ROUND_NO Round, B.CELEB_DESIGNATION Designation from EVENT A, CELEB_ASSOC_WITH B, CELEBRITY C where A.EVENT_ID = B.EVENT_ID and B.CELEB_ID = C.CELEB_ID and C.CELEB_NAME = '"+celeb_name+"'";
			rs = stmt.executeQuery(query);
			OutputGenerator.genTable(rs, out);
			out.println("Go<a href="+Config.servletURL+"CelebrityStuff?purpose=viewCelebrityInfoByName> back</a>.");
			out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");		
			OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		    } catch (Exception e) {System.out.println("Some exception");
		    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		    out.println("There was an error in your query. Please try again.<br>Check that the celebrity name is correct. This is a pre-requisite for this query to work.<br><a href="+Config.servletURL+"CelebrityStuff?purpose=viewCelebrityInfoByName>Back</a>");
		    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		    }
		} else {//if not allowed
		    OutputGenerator.putFile(out, "forms/NoPerms.html");
		}
	    }//finish purpose



	    if (purpose.equals("changeCelebInfo")) {
	    
	    }//end purpose changeCelebInfo
	
	} else {//if(session == null)
	    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
	    out.println("Please login first");
	    out.println("<a href="+Config.servletURL+"MITeamLogin>Login page</a>");
	    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
	}
    }//doGet finish
    
    
    //Now functions to execute database queries

    public synchronized boolean checkCG(String queryMaker) {
	String queryString = "";
	boolean ret = false;
	try {
	    queryString = "select MI_DESIGNATION from MI_TEAM where MI_ID = '"+ queryMaker + "'";
	    rs = stmt.executeQuery(queryString);
	    String desig = "";
	    while (rs.next())
		desig = rs.getString(1);
	    if (desig.equals("cg"))
		ret = true;
	}catch (SQLException sqle) {System.out.println("Some SQL Exception");}
	return ret;
    }//finish checkCG

    public synchronized boolean checkOC(String queryMaker) {
	String queryString = "";
	boolean ret = false;
	try {
	    queryString = "select MI_DESIGNATION from MI_TEAM where MI_ID = '"+ queryMaker + "'";
	    System.out.println(queryString);
	    rs = stmt.executeQuery(queryString);
	    String desig="";
	    while (rs.next())
		desig = rs.getString(1);
	    if (desig.equals("oc"))
		ret = true;
	}catch (SQLException sqle) {System.out.println("Some SQL Exception");}
	return ret;
    }//finish checkOC
    
    public synchronized boolean allowOperateOnEvent(String queryMaker, String event_id) {
	boolean ret = false;
	if (checkCG(queryMaker)) {//then
	    //if dept of CG is dept of event then allowed
	    String query = "select DEPT_NAME from DEPT_MI_TEAM where MI_ID = '"+ queryMaker + "'";
	    try {
		rs = stmt.executeQuery(query);
		String deptCG = "";
		String deptEvent = "";
		while (rs.next()) 
		    deptCG = rs.getString(1);
		
		if (existsEvent(event_id)) {
		    query = "select DEPT_NAME from DEPT_EVENTS where EVENT_ID = "+event_id;
		    rs = stmt.executeQuery(query);
		    while (rs.next()) 
			deptEvent = rs.getString(1);
		    
		    if (deptCG.equals(deptEvent)) 
			ret = true;
		}
		return ret;
	    } catch (SQLException sqle) {System.out.println("Some SQL Exception");}
	    
	} else {//if quertMaker is not a cg
	    return ret;
	}	
	return ret;
    }//finish allowOperateOnEvent

    public synchronized boolean existsCordi(String cordi_id) {
	String query = "select * from MI_TEAM where MI_ID = '" +cordi_id+"' and MI_DESIGNATION = 'cordi'";
	int count = 0;
	boolean ret = false;
	try {
	    rs = stmt.executeQuery(query);
	    while (rs.next())
		count++;
	    if (count==1) 
		ret = true;
	} catch (SQLException sqle) {System.out.println("Some SQL Exception");}
	    return ret;
	}//finish existsCordi
	
    public synchronized boolean existsEvent(String event_id) {
	String query = "select * from EVENT where MI_ID = " +event_id;
	int count = 0;
	boolean ret = false;
	try {
	    rs = stmt.executeQuery(query);
	    while (rs.next())
		count++;
	    if (count==1) 
		ret = true;
	} catch (SQLException sqle) {System.out.println("Some SQL Exception");}
	    return ret;
	}//finish existsEvent

    public synchronized boolean checkUniqueCeleb(String celeb_name) {
	String query = "";
	boolean ret = false;
	int cnt = 0;
	try { 
	    query = "select * from CELEBRITY where CELEB_NAME='"+celeb_name+"'";
	    rs = stmt.executeQuery(query);
	    rsmd = rs.getMetaData();
	    while (rs.next()) 
		cnt++;
	} catch (Exception e) {System.out.println("Some exception");}

	if (cnt==0) 
	    ret = true;
	
	return ret;//true if celeb_name is not duplicated
    }

    public synchronized int genCelebID() {
	int count=0;
	int id=0;
	String query="";
	try {
	    query = "select max(CELEB_ID) from CELEBRITY";
	    rs = stmt.executeQuery(query);
	    while (rs.next()) {
		id = rs.getInt(1);//if resultset is not empty then id will be the max id value till now
		count++;//if resultset is empty then count will not increase
	    }
	    
	    if (count==0) { 
		id = 1;
		return id;
	    } else {
		id++;
		return id;
	    }
	} catch (Exception e) {System.out.println("Some exception");}
	return id;
    }

    public synchronized int retEventID(String event_name) {
	String query = "select EVENT_ID from EVENT where EVENT_NAME = '"+event_name+"'";
	int event_id = 0;
	try {
	    rs = stmt.executeQuery(query);
	    while (rs.next())
		event_id = rs.getInt(1);
	} catch (Exception e) {System.out.println("Exception while calculating eventID");}
	return event_id;
    }//finish retEventID

    public synchronized void dumpCelebRegisterForm(PrintWriter out) throws IOException {
	out.println("<FORM name=authenticate>");
	out.println("<b> Registeration Form</b><br>");
	out.println("<table width=100% cellpadding=2 border=0>");
	out.println("<tr>"); 
	out.println("<td> Celeb Name:</td><td><input type=text name=name1 size=20 maxlength=20></td>");
	out.println("</tr><tr>");
	out.println("<td> Sex:</td><td><input type=radio name=sex value=m checked>Male<br><input type=radio name=sex value=f>Female</td>");
	out.println("</tr><tr>");
	out.println("<td>Email:</td><td><INPUT TYPE=text NAME=email maxlength=30 size=30></td>");
	out.println("</tr><tr>");
	out.println("<td>Phone Number: </td><td><INPUT TYPE=text NAME=phonenumber size=15 maxlength=15></td>");
	out.println("</tr><tr>");
	out.println("<td>Address: </td><td><textarea name=address rows=4 cols=40></textarea></td>");
	out.println("</tr><tr>");
	out.println("<td>Description:</td><td><input type=text name=descrip size=30 maxlength=100></td>");
	out.println("<tr><b>Association with events:</b>");
	out.println("</tr><tr>");
	out.println("<td>Select Event:</td><td>");
	String query = "select EVENT_NAME from EVENT";
	try {
	    System.out.println(query + ": inside dumpCelebRegisterForm");
	    rs = stmt.executeQuery(query);
	    System.out.println(query + ": after executing it inside dumpCelebRegisterForm");
	    OutputGenerator.genDropDown(out, rs, "event", "str");
	} catch (SQLException sqle) {System.out.println("Exception while generating dd menu");}
	out.println("</td>");
	out.println("</tr><tr>");
	out.println("<td>Round Number:</td><td><input type=text name=\"round\" size=2 maxlength=2></td>");
	out.println("</tr><tr>");
	out.println("<td>Designation:</td><td><input type=text name=\"desig\" size=30 maxlength=50></td>");
	out.println("</tr>");
	out.println("</table>");
	out.println("<INPUT TYPE=button value=Register onClick=\"return verify(this.form)\">");
	out.println("</FORM>");
    }

    public synchronized void dumpViewCelebInfoForm(PrintWriter out) {
	out.println("<h3>View Celebrity Profile</h3>");
	out.println("<form action="+Config.servletURL+"CelebrityStuff method=get>");
	out.println("<table width=50% cellpadding=2 border=0>");
	out.println("<tr><td>");
	out.println("Name of Celebrity:</td><td><input type=text size=10 name=celebname></td></tr>");
	out.println("<tr><input type=hidden value=viewCelebInfoByName name=purpose></tr>");
	out.println("</table>");
	out.println("<input type=submit value=\"Click ONCE to proceed\">");
	out.println("</form>");
    }


}//class finish




