/*tables assumed 
  MI_TEAM(MI_ID, MI_PASSWD, MI_NAME, MI_SEX, MI_EMAIL, MI_ADDRESS, MI_PHONE_NUMBER, MI_DESIGNATION)

  EVENT_MI_TEAM(MI_ID, EVENT_ID)

  DEPT_MI_TEAM(MI_ID, DEPT_NAME)

*/


/*
Purposes:
    o putChangePasswdForm
    o changePasswd
    o putCordiRegisterForm
    o putCGRegisterForm
    o putCordiUnregisterForm
    o putAddCordiEventForm
    o putDeleteCordiEventForm
    o putViewTeamMemberInfoForm
    o registerCordi
    o unregisterCordi //equivalent to deleting all events of that cordi
    o registerCG
    o addCordiEvent
    o deleteCordiEvent
    o changeTeamMemberInfo
    o viewTeamMemberInfo
    o viewAllTeamMembers
//No form for OC registration. That will be done by manual insertion into database(by SQL)
*/
package bin.janik;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

public class MITeamStuff extends HttpServlet { 
    
    Connection con;
    Statement stmt;
    ResultSet rs ;
    ResultSetMetaData rsmd;
    
    Config config = new Config();

    public void init (ServletConfig conf) throws ServletException {
	super.init(conf);
	con = null;
	stmt = null;
	rs = null;
	rsmd = null;
	try {
	    DriverManager.registerDriver( new oracle.jdbc.driver.OracleDriver());
	    con = DriverManager.getConnection(Config.dbURL, Config.dbLogin, Config.dbPasswd);
	    int numtries = 0;
	    while ((con==null) && (numtries<=10)) {//take care of this while loop
		con = DriverManager.getConnection( Config.dbURL, Config.dbLogin, Config.dbPasswd);
		try{ Thread.sleep(500);}catch(Exception e){System.out.println("Thread interrupted");}
		numtries++;
	    }
	    stmt = con.createStatement();
	} catch (SQLException sqle) {System.out.println("Unable to make connection");}
    }
    
    
    public synchronized void doGet (HttpServletRequest req, 
		       HttpServletResponse res) 
	throws ServletException, IOException {
	PrintWriter out;
	HttpSession session = req.getSession(false);//false is used because if a session dne, then I dont want to create a new one. Is this correct?
	out = res.getWriter();
	res.setContentType("text/html");    	

	String purpose = req.getParameter("purpose");
	String queryMaker = "";

	System.out.println("Purpose is " + purpose);

	if (session != null) { 
	    
	    queryMaker = (String)session.getValue("login");

	    if (purpose.equals("putCordiRegisterForm")) {
		//OutputGenerator.putFile(out, Config.formdirURL+"CordiRegister.html");
		OutputGenerator.dumpCordiRegisterForm(out);
		//out.close();
	    }


	    if (purpose.equals("putCGRegisterForm")) {
		OutputGenerator.dumpCGRegisterForm1(out);
		dumpCGRegisterForm(out);
		out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		//out.close();
	    }


	    if (purpose.equals("putCordiUnregisterForm")) { //not implemented
		OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		dumpCordiUnregisterForm(out);
		out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		//out.close();
	    }

	    
	    if (purpose.equals("putAddCordiEventForm")) {
		OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		out.println("<h2>Add event to cordi profile</h2>");
		dumpAddCordiEventsForm(out);
		out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		//out.close();
	    }


	    if (purpose.equals("putDeleteCordiEventForm")) {
		OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		out.println("<h2>Delete event from cordi profile</h2>");
		dumpDeleteCordiEventsForm(out);
		out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		//out.close();
	    }


	    /*	    if (purpose.equals("putChangeTeamMemberInfoForm")) {
		OutputGenerator.putFile(out, Config.formdirURL+"changeTeamMemberInfo.html");
		out.close();
		}*/


	    if (purpose.equals("putViewTeamMemberInfoForm")) {
		OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		out.println("<h3>View Team Member Profile</h3>");
		out.println("<b>Choose \"Name\" or \"ID\" from the Drop-down menu and fill in the field accordingly</b><br>");
		dumpViewTeamMemberInfoForm(out);
		out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		
		//out.close();
	    }
	    
	    /*
	    if (purpose.equals("putViewTeamMemberInfoByNameForm")) {
		OutputGenerator.putFile(out, Config.formdirURL+"viewTeamMemberInfoByName.html");
		out.close();
	    }
	    */

	    if (purpose.equals("putChangePasswdForm")) {
		OutputGenerator.dumpChangePasswdForm(out);
	    }
	    	    

	    if (purpose.equals("registerCordi")) {
		String mi_id = req.getParameter("login");
		String mi_passwd = req.getParameter("password1");
		String mi_name = req.getParameter("name1");
		String mi_sex = req.getParameter("sex");
		String mi_email = req.getParameter("email");
		String mi_phone_number = req.getParameter("phonenumber");
	    
		System.out.println("All initialised");

		if (checkCG(queryMaker) || checkOC(queryMaker)) {
		    System.out.println("OC or CG checked");
		    String query = "";
		    try {
			if (checkUniqueLogin(mi_id)) {

			    query = "insert into MI_TEAM values ('"+mi_id+"','"+mi_passwd+"','"+mi_name+"','"+mi_sex+"','"+mi_email+"','"+mi_phone_number+"','cordi')";
			    System.out.println(query);
			    stmt.executeUpdate(query);
			    //SharedResources.best.executeUpdate(query);

			    con.commit();

			    System.out.println("Query executed");
			    
			    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			    out.println("Congrats!!!<br>"+mi_id+" registered successfully as cordi.<br> <a href="+Config.servletURL+"MITeamStuff?purpose=putAddCordiEventForm>Go to Add Cordi Event Page Page</a><br><a href="+Config.servletURL+"MITeamStuff?purpose=putCordiRegisterForm>Register another cordi</a>");
			    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
			    
			    
			    //inserted into table and sent to login page
			} else {
			    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			    out.println("Please change your login name. This one is already taken.<br><a href="+Config.servletURL+"MITeamStuff?purpose=putCordiRegisterForm>Back</a> to cordi registration page.");//say that login-id should be changed
			    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");

			}
		    } catch (Exception e) {System.out.println("Some exception");
		    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		    out.println("There is some error in your query. Please try again.<br><a href="+Config.servletURL+"MITeamStuff?purpose=putCordiRegisterForm>Back</a> to registration page");    
		    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		    }
		    
		} else {//if not CG or OC
		    OutputGenerator.putFile(out, Config.formdirURL+"NoPerms.html");
		}
	    }//end purpose registerCordi
	    
	    if (purpose.equals("unregisterCordi")) {
		String cordi_id = req.getParameter("login");
		
		if (allowOperateOnCordi(queryMaker, cordi_id)) {
		    try {
			String query = "delete from MI_TEAM where MI_ID = '"+cordi_id+"'";//on delete cascade
		    stmt.executeUpdate(query);
		    
		    con.commit();
		    }catch (SQLException sqle) {System.out.println("SQL Exception while deleting cordi");}
		} else 
		    OutputGenerator.putFile(out, Config.formdirURL+"NoPerms.html");
	    }//finish purpose.equals unregisterCordi


	    if (purpose.equals("registerCG")) {
		String mi_id = req.getParameter("login");
		String mi_passwd = req.getParameter("password1");
		String mi_name = req.getParameter("name1");
		String mi_sex = req.getParameter("sex");
		String mi_email = req.getParameter("email");
		String mi_phone_number = req.getParameter("phonenumber");
		String dept_name = req.getParameter("dept_name");
		
		if (checkOC(queryMaker)) {
		    String query = "";
		    try {
			if (checkUniqueLogin(mi_id)) {
			    query = "insert into MI_TEAM values ('"+mi_id+"','"+mi_passwd+"','"+mi_name+"','"+mi_sex+"','"+mi_email+"','"+mi_phone_number+"','cg')";
			stmt.executeUpdate(query);

			con.commit();
			
			query = "insert into DEPT_MI_TEAM values ('"+mi_id+"','"+dept_name+"')";
			stmt.executeUpdate(query);
			
			con.commit();
			OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			out.println("Congrats!!!<br>"+mi_id+" registered successfully as CG<br><a href="+Config.servletURL+"MITeamStuff?purpose=putCGRegisterForm>Register another Cordi</a><br><a href="+Config.servletURL+"MITeamLogin>If you want to logout</a>");//inserted into table as CG
			out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
			
			
			} else {
			    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			    out.println("Please change your login name. This one is already taken.<br><a href="+Config.servletURL+"MITeamStuff?purpose=putCGRegisterForm>Back</a> to registration page");
			    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
			    
			    //say that login-id should be changed
			}
		    } catch (Exception e) {System.out.println("Some exception");
			    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			    out.println("There is something wrong with your query. Please try again.<br><a href="+Config.servletURL+"MITeamStuff?purpose=putCGRegisterForm>Back</a> to CG registration page.");
			    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		    }
		} else {//if not OC
		    OutputGenerator.putFile(out, Config.formdirURL+"NoPerms.html");
		}
	    }//finish purpose registerCG
	    
	    if (purpose.equals("addCordiEvent")) {
		String cordi_id = req.getParameter("cordi_id");
		String event_name = req.getParameter("event");

		System.out.println("cordi is "+cordi_id);
		System.out.println("event is "+event_name);
		
		int event_id = retEventID(event_name);
		
		if (allowOperateOnEvent(queryMaker, event_id)) {//will return TRUE only if the queryMaker is a CG and handles the dept associated eith the event
		    System.out.println("Operate on event allowed");
		    String query = "";
		    try {
			if (existsCordi(cordi_id)) {
			    System.out.println("Cordi exists");
			    query = "insert into EVENT_MI_TEAM values ('"+cordi_id+"',"+event_id+")";
			    System.out.println(query);
			    
			    stmt.executeUpdate(query);
			    
			    con.commit();
			    
			    System.out.println("Event added and committed");
			    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			    out.println("Congrats!!!<br>Event added successfully to cordi profile.<br> <a href="+Config.servletURL+"MITeamStuff?purpose=putAddCordiEventForm>Add another event for this cordi</a><br><a href="+Config.servletURL+"MITeamLogin>Logout</a>");
			    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");

			    //inserted into table
			} else {
			    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			    out.println("There was an error in your query. Please try again.<br>Check that the cordi_id and event exist. Their existence is a pre-requisite for this query to work.<br><a href="+Config.servletURL+"MITeamStuff?purpose=putAddCordiEventForm>Back</a>");
			    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");

			    //say that login-id should be changed
			}
		    } catch (SQLException e) {System.out.println("Some exception");
		    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		    out.println("There was an error in your query. Please try again.<br>Check that the cordi_id and event exist. Their existence is a pre-requisite for this query to work.<br><a href="+Config.servletURL+"MITeamStuff?purpose=putAddCordiEventForm>Back</a>");
		    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		    }

		} else {
		    OutputGenerator.putFile(out, Config.formdirURL+"NoPerms.html");
		}
	    }//finish purpose addCordiEvent

	    if (purpose.equals("deleteCordiEvent")) {
		String cordi_id = req.getParameter("cordi_id");
		String event_name = req.getParameter("event");
		
		int event_id = retEventID(event_name); 

		if (allowOperateOnEvent(queryMaker, event_id)) {//will return TRUE only if the queryMaker is a CG and handles the dept associated with the event
		    String query = "";
		    try {
			if (existsCordi(cordi_id)) {
			    query = "delete from EVENT_MI_TEAM where MI_ID = '"+cordi_id+"' and EVENT_ID = "+event_id;
			    stmt.executeUpdate(query);
			    
			    con.commit();

			    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			    out.println("Event deleted successfully from cordi profile.<br> <a href="+Config.servletURL+"MITeamStuff?purpose=putDeleteCordiEventForm>Delete another event for a cordi</a><br><a href="+Config.servletURL+"MITeamLogin>Logout</a>");
			    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");


			    //inserted into table
			} else {//cordi does not exist
			    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			    out.println("There was an error in your query. Please try again.<br>Check that the cordi_id exists. Its existence is a pre-requisite for this query to work.<br><a href="+Config.servletURL+"MITeamStuff?purpose=putDeleteCordiEventForm>Back</a>");
			    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");

		//say that login-id should be changed
			}
		    } catch (Exception e) {System.out.println("Some exception");
		    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		    out.println("There was an error in your query. Please try again.<br>Check that the cordi_id and event exist. Their existence is a pre-requisite for this query to work.<br><a href="+Config.servletURL+"MITeamStuff?purpose=putDeleteCordiEventForm>Back</a>");
		    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		    }
		    
		} else {//allowOperateOnEvent  returned false
		    OutputGenerator.putFile(out, Config.formdirURL+"NoPerms.html");
		}
	    }//finish purpose addCordiEvent
	    

	    //no form for this
	    if (purpose.equals("viewAllTeamMembers")) {
		if (checkCG(queryMaker) || checkOC(queryMaker) || existsCordi(queryMaker)) {
		    try {//view cordis first
			String query = "select MI_ID Login, MI_NAME Name, MI_EMAIL EMail, MI_SEX Sex, MI_PHONE_NUMBER Phone from MI_TEAM where MI_DESIGNATION = 'cordi'";   
			String temp_id = "";
			String query2 = "";
			Statement stmt2 = null;
			stmt2 = con.createStatement();
			ResultSet rs2 = null;
			ResultSetMetaData rsmd2 = null;
			rs = stmt.executeQuery(query);
			rsmd = rs.getMetaData();
			System.out.println(query);
			OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			out.println("Team information for Cordis<br>");
			out.println("<table width=90% cellpadding=0 border=0 cellspacing=2>");
			out.print("<tr bgcolor=#ffcc99 align=center>");
			for (int i = 1; i<=rsmd.getColumnCount(); i++) {
			    out.print("<td>"+rsmd.getColumnName(i)+"</td>");
			}
			out.println("<td>Managing Events</td></tr>");
			
			while (rs.next()) {
			    System.out.println("Inside while loop");
			    temp_id = rs.getString(1);
			    System.out.println("temp_id is " + temp_id);
			    query2 = "select A.EVENT_NAME Event from EVENT A, EVENT_MI_TEAM B where A.EVENT_ID = B.EVENT_ID and B.MI_ID = '"+temp_id+"'";
			    System.out.println(query2);
			    rs2 = stmt2.executeQuery(query2);
			    rsmd2 = rs2.getMetaData();
			    out.print("<tr bgcolor=#ccccff align=center>");
			    for (int i = 1; i<=rsmd.getColumnCount(); i++)
				out.print("<td>"+rs.getString(i)+"</td>");
			    out.print("<td>");
			    while (rs2.next()) 
				out.print(rs2.getString(1)+", ");
			    out.println("</td></tr>");
			}
			out.println("</table>");
			//Now all CGs
			query = "select A.MI_ID Login, A.MI_NAME Name, A.MI_EMAIL EMail, A.MI_SEX Sex, A.MI_PHONE_NUMBER Phone, B.DEPT_NAME Department from MI_TEAM A, DEPT_MI_TEAM B where A.MI_DESIGNATION = 'cg' and A.MI_ID = B.MI_ID";
			System.out.println(query);
			rs = stmt.executeQuery(query);
			out.println("<br>List of Core Group Members<br>");
			out.println("<table width=90% cellpadding=0 border=0 cellspacing=2>");
			out.print("<tr bgcolor=#ffcc99 align=center>");
			for (int i = 1; i<=rsmd.getColumnCount(); i++) 
			    out.print("<td>"+rsmd.getColumnName(i)+"</td>");
			out.println("</tr>");
			while (rs.next()) {
			    out.print("<tr bgcolor=#ccccff align = center>");
			    for (int i=1; i<=rsmd.getColumnCount(); i++)
				out.print("<td>"+rs.getString(i)+"</td>");
			    out.println("</tr>");
			}
			out.println("</table>");
			out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>My Main page</a>");
			OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		    }  catch (Exception e) {System.out.println("Some exception");
		    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		    out.println("There is something wrong with your query. Please try again.<br><a href="+Config.servletURL+"MITeamStuff?purpose=putCGRegisterForm>Back</a> to CG registration page.");
		    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>My Main page</a>");
		    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		    }
		} else {//if not allowed
		    OutputGenerator.putFile(out, Config.formdirURL+"NoPerms.html");
		}
	    }//finish purpose viewAllTeamMembers

	    if (purpose.equals("viewTeamMemberInfo")) {
		String mi_id = "";
		String method = req.getParameter("how");
		try {
		    if (method.equals("id")) {
			mi_id = req.getParameter("login");
			OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			dumpTeamMemberInfo(queryMaker, mi_id, out);
			out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		    } else if (method.equals("name")) {	
			String mi_name = req.getParameter("login");
			
			String qry = "select MI_ID from MI_TEAM where MI_NAME like '%"+ mi_name +"%'";
			rs = stmt.executeQuery(qry);
			
			OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			while (rs.next()) {
			    System.out.println("Inside while");
			    mi_id = rs.getString(1);
			    dumpTeamMemberInfo(queryMaker, mi_id, out);
			    System.out.println("Inside while : after exiting from dumpTeamMemberInfo");
			    
			}
			out.println("<a href="+Config.servletURL+"MITeamStuff?purpose=putViewTeamMemberInfoForm>Another query</a>.");
			out.println("<br>Go to your <a href="+Config.servletURL+"MainPage>main page</a>.<br>Go<a href="+Config.servletURL+"MITeamStuff?purpose=putViewTeamMemberInfoForm> back</a>.");
			out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		    }
		} catch (SQLException sqle) {
		    sqle.printStackTrace();
		    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		    out.println("Sorry, there is an error");
		    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		}
	    }
	

		//Now I have the mi_id rest is common
		//All team members are allowed to view details of each other 
	    
		//out.close();
	    //finish purpose viewTeamMemberInfoByID

	    /*
	    if (purpose.equals("viewTeamMemberInfoByName")) {
		String mi_name = req.getParameter("name");
		String mi_id = "";
		try {
		    String qry = "select MI_ID from MI_TEAM where MI_NAME = '"+ mi_name +"'";
		    rs = stmt.executeQuery(qry);
		    
		    while (rs.next()) 
			mi_id = getString(1);
			
		} catch (SQLException sqle) {System.out.println("Exception while resolving id from name");}

		//now I have the MI_ID				
		//All team members are allowed to view details of each other 
		if ((checkCG(queryMaker)) || (checkOC(queryMaker)) || (existsCordi(queryMaker))) {
		    if (existsCordi(mi_id)) {
			try {
			    String query = "select MI_ID Login, MI_NAME Name, MI_EMAIL EMail, MI_SEX Sex, MI_ADDRESS Address, MI_PHONE_NUMBER Phone from MI_TEAM where MI_DESIGNATION = 'cordi' and MI_ID = '"+mi_id+"'";   
			    out.println("<html><head><title>Team Information</title></head><body>The person queried on is a cordi. The personal information is as follows:<br>");
			    rs = stmt.executeQuery(query);
			    OutputGenerator.genTable(rs, out);
			    out.println("<br>Events managed by "+mi_id+":<br>");
			    query = "select A.EVENT_NAME Event from EVENT A, EVENTS_MI_TEAM B where A.EVENT_ID = B.EVENT_ID and B.MI_ID = '"+mi_id+"'";
			    rs = stmt.executeQuery(query);
			    OutputGenerator.genTable(rs, out);
			    out.println("Go to your <a href="+Config.servletURL+"MainPage>main page</a>.<br>Go<a href="+Config.servletURL+"MITeamStuff?purpose=viewTeamMemberInfoByID> back</a>.");
			    out.println("</body></html>");
			} catch (Exception e) {System.out.println("Some exception");
			out.println("<html><head></head><body>There was an error in your query. Please try again.<br>Check that the cordi_id exists. Its existence is a pre-requisite for this query to work.<br><a href="+Config.servletURL+"MITeamStuff?purpose=viewTeamMemberInfoByID>Back</a></body></html>");}
		    } else {//if not cordi then CG or OC
			try {
			    String query = "select MI_ID Login, MI_NAME Name, MI_EMAIL EMail, MI_SEX Sex, MI_ADDRESS Address, MI_PHONE_NUMBER Phone from MI_TEAM where MI_DESIGNATION = 'cordi' and MI_ID = '"+mi_id+"'";   
			    out.println("<html><head><title>Team Information</title></head><body>The personal information is as follows:<br>");
			    rs = stmt.executeQuery(query);
			    OutputGenerator.genTable(rs, out);
			    out.println("<br>Department(s) managed by "+mi_id+":<br>");
			    query = "select B.DEPT_NAME Department from EVENT A, DEPARTMENT_MI_TEAM B where A.EVENT_ID = B.EVENT_ID and B.MI_ID = '"+mi_id+"'";
			    rs = stmt.executeQuery(query);
			    OutputGenerator.genTable(rs, out);
			    out.println("Go to your <a href="+Config.servletURL+"MainPage>main page</a>.<br>Go<a href="+Config.servletURL+"MITeamStuff?purpose=viewTeamMemberInfoByID> back</a>.");
			    out.println("</body></html>");
			} catch (Exception e) {System.out.println("Some exception");
			out.println("<html><head></head><body>There was an error in your query. Please try again.<br>Check that the cordi_id exists. Its existence is a pre-requisite for this query to work.<br><a href="+Config.servletURL+"MITeamStuff?purpose=viewTeamMemberInfoByID>Back</a></body></html>");}
		    }
		} else {//if not allowed
		    OutputGenerator.putFile(out, Config.formdirURL+"NoPerms.html");
		}
	    }//finish purpose viewTeamMemberInfoByName
	    */

	if (purpose.equals("putChangeTeamMemberInfoForm")) {
	    //String queryMaker = (String)session.getValue("login");
	    OutputGenerator.putFile(out, Config.formdirURL+"ChangeTeamMemberInfoFormJS.html");
		out.println("This is your info as of now. Fill <b>all</b> fields again to update information.<br>");
		try {
		    String query = "select MI_ID as ID, MI_NAME as Name, MI_EMAIL as email, MI_PHONE_NUMBER as Phone, MI_SEX as Sex from MI_TEAM where mi_id = '"+queryMaker+"'";
		    System.out.println(query);
		    rs = stmt.executeQuery(query);
		    System.out.println("query executed");
		    OutputGenerator.genVerticalTable(rs, out);
		    System.out.println("Table generated");
		} catch (SQLException sqle) {System.out.println("SQLException");}
		out.println("Fill out the form below...please dont leave any fields blank<br>");
		OutputGenerator.putFile(out, Config.formdirURL+"ChangeTeamMemberInfoForm.html");
		out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
	    } //finish purpose putViewChangeTeamMemberInfoForm
	       
	
	    if (purpose.equals("changeTeamMemberInfo")) {//only you yourself can change your personal info. Adding deleting events is a different case and can be done by CGs and OCs
		String email = (String)req.getParameter("email");
		String phone = (String)req.getParameter("phonenumber");
		String name = (String)req.getParameter("name1");
		String sex = (String)req.getParameter("sex");
		
		try {
		    String query = "update MI_TEAM set MI_EMAIL = '"+email+"', MI_PHONE_NUMBER = '"+phone+"', MI_NAME = '"+name+"', MI_SEX = '"+sex+"' where MI_ID = '"+queryMaker+"'";
		    System.out.println(query);
		    rs = stmt.executeQuery(query);
		    con.commit();
		    System.out.println("Executed and committed");
		} catch (Exception e) {System.out.println("Some exception");
		OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		out.println("There was an error in your query. Please try again.<br>Check that all fields were filled. <a href="+Config.servletURL+"MITeamStuff?purpose=putChangeTeamMemberInfoForm>Back</a>");
		out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		}
		OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		out.println("Changes made successfully. Click <a href="+Config.servletURL+"MainPage>here</a> to go to your main page.");
		out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
	    }//end purpose changeTeamMemberInfo
	    
	    if (purpose.equals("changePasswd")) {
		String old_passwd = req.getParameter("passwordold");
		String new_passwd = req.getParameter("password1");

		if (new_passwd != null) {
		    if ((existsCordi(queryMaker)) || (checkCG(queryMaker)) || checkOC(queryMaker)) {
			
			String old_p_stored = "";
			String query = "select MI_PASSWD from MI_TEAM where MI_ID = '"+queryMaker+"'";
			System.out.println(query);
			try {
			    rs = stmt.executeQuery(query);
			    System.out.println("query executed");
			    while (rs.next()) 
				old_p_stored = rs.getString(1);
			    System.out.println(old_p_stored);
			    if (old_p_stored.equals(old_passwd)) {
				query = "update MI_TEAM set MI_PASSWD = '"+new_passwd+"' where MI_ID = '"+queryMaker+"'";
				stmt.executeUpdate(query);
				con.commit();
				OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
				out.println("Password changed successfully");
				out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
				OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
			    } else {
				OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
				out.println("Your old password is not correct.");
				out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
				OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
			    }
			} catch (SQLException sqle) {
			    System.out.println("SQL Error");
			    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			    out.println("Some SQL Exception");
			    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
			}
		    } else {
			OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			out.println("Sorry, you are not a team member.");
			out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		    }
		}
	    }

	} else {//if(session == null) 
	    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
	    out.println("Please login first");
	    out.println("<a href="+Config.servletURL+"MITeamLogin>Login page</a>");
	    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
	}
	System.out.println("Closing PrintWriter stream");
	out.close();
    }//doGet finish
    
    
    //Now functions to execute database queries

   

    public synchronized boolean checkCG(String queryMaker) {
	String queryString = "";
	boolean ret = false;
	try {
	    Statement stmt = con.createStatement();
	    ResultSet rs = null;
	    queryString = "select MI_DESIGNATION from MI_TEAM where MI_ID = '"+ queryMaker + "'";
	    rs = stmt.executeQuery(queryString);
	    String desig = "";
	    while (rs.next())
		desig = rs.getString(1);
	    if (desig.equals("cg"))
		ret = true;
	}catch (SQLException sqle) {System.out.println("Some SQL Exception");}
	return ret;
    }//finish checkCG

    public synchronized boolean checkOC(String queryMaker) {
	String queryString = "";
	boolean ret = false;
	try {
	    Statement stmt = con.createStatement();
	    ResultSet rs = null;
	    queryString = "select MI_DESIGNATION from MI_TEAM where MI_ID = '"+ queryMaker + "'";
	    rs = stmt.executeQuery(queryString);
	    String desig="";
	    while (rs.next())
		desig = rs.getString(1);
	    if (desig.equals("oc"))
		ret = true;
	}catch (SQLException sqle) {System.out.println("Some SQL Exception");}
	return ret;
    }//finish checkOC
    
    public synchronized boolean checkUniqueLogin(String mi_id) {
	boolean ret = false;
	int count=0;
	String query = "";
	try {
	    Statement stmt = con.createStatement();
	    ResultSet rs = null;
	    query = "select * from MI_TEAM where MI_ID = '"+ mi_id+"'";
	    rs = stmt.executeQuery(query);
	    //rsmd = rs.getMetaData();
	    while (rs.next()) {
		count++;
	    }
	    
	    query = "select * from USERS where USER_ID = '"+ mi_id+"'";
	    rs = stmt.executeQuery(query);
	    //rsmd = rs.getMetaData();
	    while (rs.next()) {
		count++;
	    }
	    
	    query = "select * from TEAM where TEAM_ID = '"+ mi_id+"'";
	    rs = stmt.executeQuery(query);
	    //rsmd = rs.getMetaData();
	    while (rs.next()) {
		count++;
	    }
	    
	    if (count==0) 
		ret = true;
	} catch (SQLException sqle) {System.out.println("Some SQL Exception");}
	return ret;
    }//finish checkUniqueLogin

    public synchronized boolean allowOperateOnEvent(String queryMaker, int event_id) {
	boolean ret = false;
	if (checkOC(queryMaker)) {
	    return true;
	}
	if (checkCG(queryMaker)) {//then
	    //if dept of CG is dept of event then allowed
	    String query = "select DEPT_NAME from DEPT_MI_TEAM where MI_ID = '"+ queryMaker + "'";
	    try {
		Statement stmt = con.createStatement();
		ResultSet rs = null;
		rs = stmt.executeQuery(query);
		String deptCG = "";
		String deptEvent = "";
		while (rs.next()) 
		    deptCG = rs.getString(1);
		
		System.out.println("department of CG is  "+deptCG);

		if (existsEvent(event_id)) {
		    query = "select DEPT_NAME from DEPT_EVENTS where EVENT_ID = "+event_id;
		    rs = stmt.executeQuery(query);
		    while (rs.next()) 
			deptEvent = rs.getString(1);
		    
		    System.out.println("department of event is  "+deptEvent);
		    
		    if (deptCG.equals(deptEvent)) 
			ret = true;
		}
		return ret;
	    } catch (SQLException sqle) {System.out.println("Some SQL Exception in allowOperateOnEvent");}
	    
	} else {//if queryMaker is not a cg
	    return ret;
	}	
	return ret;
    }//finish allowOperateOnEvent

    public synchronized int retEventID(String event_name) {
	String query = "select EVENT_ID from EVENT where EVENT_NAME = '"+event_name+"'";
	int event_id = 0;
	try {
	    Statement stmt = con.createStatement();
	    ResultSet rs = null;
	    rs = stmt.executeQuery(query);
	    while (rs.next())
		event_id = rs.getInt(1);
	    System.out.println("Event_name is "+event_name + " and event_id is "+event_id); 
	} catch (Exception e) {System.out.println("Exception while calculating eventID");}
	return event_id;
    }//finish retEventID

    public synchronized boolean existsCordi(String cordi_id) {
	System.out.println("cordi_id passed is " + cordi_id);
	String query = "select * from MI_TEAM where MI_ID = '" +cordi_id+"' and MI_DESIGNATION = 'cordi'";
	int count = 0;
	try {
	    Statement stmt = con.createStatement();
	    ResultSet rs = null;
	    rs = stmt.executeQuery(query);
	    while (rs.next())
		count++;
	    System.out.println("count is "+count);
	    if (count==1) 
		return true;
	} catch (SQLException sqle) {System.out.println("Some SQL Exception");}
	    return false;
	}//finish existsCordi
	
    public synchronized boolean existsEvent(int event_id) {
	String query = "select * from EVENT where EVENT_ID = " +event_id;
	int count = 0;
	boolean ret = false;
	try {
	    Statement stmt = con.createStatement();
	    ResultSet rs = null;
	    rs = stmt.executeQuery(query);
	    while (rs.next())
		count++;
	    if (count==1) 
		ret = true;
	} catch (SQLException sqle) {System.out.println("Some SQL Exception");}
	return ret;
    }//finish existsEvent
    
    public synchronized boolean allowOperateOnCordi(String queryMaker, String cordi_id) {
	String query = "";
	if (checkOC(queryMaker)) 
	    return true;
	else if (checkCG(queryMaker)) {
	    query = "select DEPT_NAME from DEPT_MI_TEAM where MI_ID = '"+ queryMaker + "'";
	    String deptCG = "";
	    String deptCordi = "";
	    try {
		Statement stmt = con.createStatement();
		ResultSet rs = null;
		rs = stmt.executeQuery(query);
		
		while (rs.next()) 
		    deptCG = rs.getString(1);
		
		query = "select EVENT_ID from EVENT_MI_TEAM where MI_ID = '"+cordi_id+"'";
		rs = stmt.executeQuery(query);
		
		String query2 = "";
		ResultSet rs2 = null;
		Statement stmt2 = null;
		int event_id;
		while (rs.next()) {
		    stmt2=con.createStatement();
		    event_id = rs.getInt(1);
		    query2 = "select DEPT_NAME from DEPT_EVENTS where EVENT_ID = "+event_id;
		    rs2 = stmt2.executeQuery(query2);
		    while (rs2.next()) {
			deptCordi = rs2.getString(1);
			if (deptCordi.equals(deptCG)) 
			    return true;
		    }
		}
	    }catch (SQLException sqle) {System.out.println("Some SQL Exception");}
	    return false;
	}
	return false;
    }
		    
    //Now some form dumping

    public synchronized void dumpTeamMemberInfo(String queryMaker, String mi_id, PrintWriter out) throws IOException, SQLException {
	if ((checkCG(queryMaker)) || (checkOC(queryMaker)) || (existsCordi(queryMaker))) {
	    Statement stmt2 = null;
	    stmt2 = con.createStatement();
	    ResultSet rs2 = null;
		    
	    if (existsCordi(mi_id)) {
		try {
		    String query = "select MI_ID Login, MI_NAME Name, MI_EMAIL EMail, MI_SEX Sex, MI_PHONE_NUMBER Phone from MI_TEAM where MI_DESIGNATION = 'cordi' and MI_ID = '"+mi_id+"'";   
		    
		    System.out.println(query);
		    rs2 = stmt2.executeQuery(query);
		    System.out.println("Query executed");
		    out.println("<b>"+mi_id + "</b> is a cordi. The personal information is as follows:<br>");
		    OutputGenerator.genTable(rs2, out);
		    out.println("<br>Events managed by <b>"+mi_id+"</b>:<br>");
		    query = "select A.EVENT_NAME Event from EVENT A, EVENT_MI_TEAM B where A.EVENT_ID = B.EVENT_ID and B.MI_ID = '"+mi_id+"'";
		    System.out.println(query);
		    rs2 = stmt2.executeQuery(query);
		    System.out.println("Both the queries executed successfully");
		    OutputGenerator.genTable(rs2, out);
		    System.out.println("Table generated");
		
		} catch (Exception e) {System.out.println("Some exception in viewTeamMemberInfo");
			OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			out.println("There was an error in your query. Please try again.<br>Check that the cordi_id exists. Its existence is a pre-requisite for this query to work.<br><a href="+Config.servletURL+"MITeamStuff?purpose=viewTeamMemberInfo>Back</a>");
			out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
			OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		}
	    } else {//if not cordi then CG or OC
		try {
		    System.out.println("person is a CG or OC");
		    String query = "select MI_ID Login, MI_NAME Name, MI_EMAIL EMail, MI_SEX Sex, MI_PHONE_NUMBER Phone from MI_TEAM where MI_DESIGNATION = 'cg' and MI_ID = '"+mi_id+"'";
		    
		    System.out.println(query);
		    rs2 = stmt2.executeQuery(query);
		    System.out.println("query executed");
		    OutputGenerator.genTable(rs2, out);
		    query = "select MI_ID Login, MI_NAME Name, MI_EMAIL EMail, MI_SEX Sex, MI_PHONE_NUMBER Phone from MI_TEAM where MI_DESIGNATION = 'oc' and MI_ID = '"+mi_id+"'";      
		    System.out.println(query);
		    rs2 = stmt2.executeQuery(query);
		    System.out.println("query executed");
		    out.println("The personal information for <b>"+mi_id+"</b> is as follows:<br>");
		    OutputGenerator.genTable(rs2, out);
		    out.println("<br>Department(s) managed by <b>"+mi_id+"</b>:<br>");
		    System.out.println("table generated and output sent");
		    query = "select B.DEPT_NAME Department from DEPT_MI_TEAM B where B.MI_ID = '"+mi_id+"'";
		    System.out.println(query);
		    rs2 = stmt2.executeQuery(query);
		    System.out.println("query executed");
		    OutputGenerator.genTable(rs2, out);
		    System.out.println("table generated and output sent");
		} catch (Exception e) {System.out.println("Some exception");
		OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		out.println("There was an error in your query. Please try again.<br>Check that the cordi_id exists. Its existence is a pre-requisite for this query to work.<br><a href="+Config.servletURL+"MITeamStuff?purpose=viewTeamMemberInfo>Back</a><br>");
		out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
		}
	    }
	} else {//if not allowed
	    OutputGenerator.putFile(out, Config.formdirURL+"NoPerms.html");
	}
    }



    public synchronized void dumpCGRegisterForm(PrintWriter out) throws IOException {
	out.println("<FORM name=authenticate><b> Registeration Form<br>");
	out.println("<table width=50% cellpadding=2 border=0>");
	out.println("<tr><td> Login:</td> <td> <INPUT TYPE=text size=10 NAME=login maxlength=10 > </td>");
	out.println("</tr><tr>");
	out.println("<td>PassWord:</td><td> <INPUT TYPE=password size=10 NAME=password1 maxlength=10> </td>");
	out.println("</tr><tr>");
	out.println("<td>Re-enter your password:</td><td><INPUT TYPE=password size=10 NAME=password2 maxlength=10> </td>");
	out.println("</tr><tr>");
	out.println("<td> Name:</td><td><input type=text name=name1 size=20 maxlength=20></td>");
	out.println("</tr><tr>");
	out.println("<td> Sex:</td><td><input type=radio name=sex value=m checked>Male<br><input type=radio name=sex value=f>Female</td>");
	out.println("</tr><tr>");
	out.println("<td>Email:</td><td><INPUT TYPE=text NAME=email maxlength=30 size=30></td>");
	out.println("</tr><tr>");
	out.println("<td>Phone Number: </td><td><INPUT TYPE=text NAME=phonenumber size=15 maxlength=15></td>");
	out.println("</tr><tr>");
	out.println("<td>Select Department: </td><td>");
	//Drop down menu
	String query="select DEPT_NAME from DEPARTMENT";
	try {
	    rs = stmt.executeQuery(query);
	} catch(SQLException sqle) {System.out.println("SQL exception dumpAddCGForm");}
	OutputGenerator.genDropDown(out, rs, "department", "str");
	out.println("</td></tr></table>");
	out.println("<INPUT TYPE=button value=Register onClick=\"return verify(this.form)\"></FORM>");
    }//dumpCGRegisterForm finish


    public synchronized void dumpAddCordiEventsForm(PrintWriter out) throws IOException {
	out.println("<FORM name=authenticate action="+Config.servletURL+"MITeamStuff method=get><b>Fill out this form<br>");
	out.println("<table width=50% cellpadding=2 border=0>");
	out.println("<tr><td> Login:</td> <td> <INPUT TYPE=text size=10 NAME=cordi_id maxlength=10 > </td>");
	out.println("</tr><tr>");
	out.println("<td>Select Event: </td><td>");
	//Drop down menu
	String query="select EVENT_NAME from EVENT";
	try {
	    rs = stmt.executeQuery(query);
	} catch(SQLException sqle) {System.out.println("SQL exception dumpAddCGForm");}
	OutputGenerator.genDropDown(out, rs, "event", "str");
	out.println("</td></tr>");
	out.println("<tr><input type=hidden name=purpose value=addCordiEvent></tr>");
	out.println("</table>");
	out.println("<INPUT TYPE=submit value=\"Click ONCE to proceed\"></FORM>");
    }

    public synchronized void dumpDeleteCordiEventsForm(PrintWriter out) throws IOException {
	out.println("<FORM name=authenticate action="+Config.servletURL+"MITeamStuff method=get><b>Fill out this form<br>");
	out.println("<table width=50% cellpadding=2 border=0>");
	out.println("<tr><td> Login:</td> <td> <INPUT TYPE=text size=10 NAME=cordi_id maxlength=10 > </td>");
	out.println("</tr><tr>");
	out.println("<td>Select Event: </td><td>");
	//Drop down menu
	String query="select EVENT_NAME from EVENT";
	try {
	    rs = stmt.executeQuery(query);
	} catch(SQLException sqle) {System.out.println("SQL exception dumpAddCGForm");}
	OutputGenerator.genDropDown(out, rs, "event", "str");
	out.println("</td></tr>");
	out.println("<tr><input type=hidden name=purpose value=deleteCordiEvent></tr>");
	out.println("</table>");
	out.println("<INPUT TYPE=submit value=\"Click ONCE to proceed\"></FORM>"); 
    }

    public synchronized void dumpViewTeamMemberInfoForm(PrintWriter out) throws IOException {
	
	out.println("<form action="+Config.servletURL+"MITeamStuff method=get>");
	out.println("<table width=50% cellpadding=2 border=0>");
	out.println("<tr><td>");
	out.println("<select name=how>");
	out.println("<option value=id>Query by ID</option>");
	out.println("<option value=name>Query by Name</option>");
	out.println("</select>");
	out.println("</td><tr>");
	out.println("<tr><td>ID or Name(as selected):</td><td><input type=text size=30 name=login></td></tr>");
	out.println("<tr><input type=hidden value=viewTeamMemberInfo name=purpose></tr>");
	out.println("</table>");
	out.println("<input type=submit value=\"Click ONCE to proceed\">");
	out.println("</form>");
    } 

    public synchronized void dumpCordiUnregisterForm(PrintWriter out) throws IOException {
	out.println("<FORM action="+Config.servletURL+"MITeamStuff method=get>");
	out.println("<b> Cordi Unregister Form<br>");
	out.println("<table width=100% cellpadding=2 border=0>");
	out.println("<tr> ");
	out.println("<td>Cordi ID:</td> <td> <INPUT TYPE=text size=10 NAME=\"login\" maxlength=10 > </td>");
	out.println("</tr>");
	out.println("</table>");
	out.println("<input type=hidden name=purpose value=unregisterCordi>");
	out.println("<INPUT TYPE=submit value=UnRegister>");
	out.println("</FORM>");
    }



}//class finish
