/*
  PROZES(EVENT_ID, ROUND_NO, POSITION, POINTS, DESCRIPTION)
  COLLEGE_POS(COLLEGE_ID, EVENT_ID, ROUND_NO, POSITION)
  TEAM_POS(TEAM_ID, EVENT_ID, ROUND_NO, POSITION)
  USER_POS(USER_ID, EVENT_ID, ROUND_NO, POSITION)
  EVENTS(EVENT_NAME, EVENT_ID)
 */

/*
  Purposes
  o putAddPointsForm
  o specRound : handles both user and team points by checking whether the id supplied is of a user of team. If the ID dne, then they will have to first register by going to Khandu's site. Assuming the id exists, events will be taken from a dropdown menu and then they go to another page. This figures as the second purpose
  
  o specPos : round number will be chosen from dropdown menus. 
  o makeEntry : position will be chosen from a dropdown menu. This completes the point addition process 

  o putViewUTPointsForm
  o viewUTPoints : view points of a user or team
  
  o putViewCollegeRankingForm
  o viewCollegeRanking
*/
package bin.janik;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

public class Positions extends HttpServlet { 
    
    Connection con;
    Statement stmt;
    ResultSet rs ;
    ResultSetMetaData rsmd;
    
    Config config = new Config();

    public void init (ServletConfig conf) throws ServletException {
	super.init(conf);
	con = null;
	stmt = null;
	rs = null;
	rsmd = null;
	try {
	    DriverManager.registerDriver( new oracle.jdbc.driver.OracleDriver());
	    con = DriverManager.getConnection(Config.dbURL, Config.dbLogin, Config.dbPasswd);
	    int numtries = 0;
	    while ((con==null) && (numtries<=10)) {//take care of this while loop
		con = DriverManager.getConnection( Config.dbURL, Config.dbLogin, Config.dbPasswd);
		try{ Thread.sleep(500);}catch(Exception e){System.out.println("Thread interrupted");}
		numtries++;
	    }
	    stmt = con.createStatement();
	} catch (SQLException sqle) {System.out.println("Unable to make connection");}
    }
    
    
    public synchronized void doGet (HttpServletRequest req, 
		       HttpServletResponse res) 
	throws ServletException, IOException {
	PrintWriter out;
	HttpSession session = req.getSession(false);//false is used because if a session dne, then I dont want to create a new one. Is this correct?
	out = res.getWriter();
	res.setContentType("text/html");    	

	String purpose = req.getParameter("purpose");
	String queryMaker = "";

	System.out.println("Purpose is " + purpose);

	if (session != null) { 
	    
	    queryMaker = (String)session.getValue("login");
	    
	    /*	    if (purpose.equals("putAddPointsForm")) {
		OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		out.println("<h2>Give the points information</h2>");
		dumpEventsForm(out, queryMaker);//will put the form with field for teamID/userID and a drop-down menu for events under that querymaker. queryMaker may be a CG or a cordi
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
	    }

	    if (purpose.equals("specRound")) {
		String id = req.getParameter("login");
		String event_name = req.getParameter("event");
		int event_id = 0;
		
		try {
		    String query = "select EVENT_ID from EVENTS where EVENT_NAME = '"+event_name + "'";
		    System.out.println(query);
		    rs = stmt.executeQuery(query);
		    while (rs.next()) {
			System.out.println("Inside rs.next()");
			event_id = rs.getInt(1);
			System.out.println("event_id is "+ event_id);
		    }
		} catch (SQLException sqle) {System.out.println("Event does not exist");
		out.println("<html><head></head><body>There was an error. The evnt does not exist. Please try<a href="+Config.servletURL+"Positions?purpose=putAddPointsForm> again</a></body></html>.");
		out.close();}
		
		System.out.println("event_id is "+event_id);
		
		if (existsID(id)) { 
		    System.out.println("ID "+id+" exists");
		    if (allowOperateOnEvent(queryMaker, event_id)) {
			System.out.println("ooperation on event allowed");
			//put the rounds. This form should send the userid 
			OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
			out.println("<h2>Specify the round</h2>");
			dumpRoundsForm(out, id, event_id);
			OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
			System.out.println("Dumped rounds form for event "+event_name + ", " + event_id); 
 		    } else //no perms 
			out.println("<html><head></head><body>You are not allowed to operate on this event. <a href="+Config.servletURL+"MainpageServlet>Go to you main page</a></body></html>.");
		} else //ID invalid
		    out.println("<html><head></head><body>The ID does not exist as a team or individual. <a href="+Config.servletURL+"KhanduregisterServlet?purpose=putAddPointsForm>Please register first.</a></body></html>");		    
	    } //finish purpose specRound
	    
	    if (purpose.equals("specPos")) {
		String id = req.getParameter("login");
		String event_id = req.getParameter("event");
		String round_num = req.getParameter("round");
		OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		out.println("<h2>Specify position</h2>");
		dumpPosForm(out, id, event_id, round_num);
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
	    } //finish purpose specPos

	    if (purpose.equals("makeEntry")) {
		String pos = req.getParameter("position");
		String id = req.getParameter("login");
		String event_id = req.getParameter("event");
		String round_num = req.getParameter("round");
		
		String id_type = "";
		
		id_type = retTypeID(id);
		String tab_name1 = "";
		String tab_name2 = "";
		String field2 = "";

		if (id_type.equals("user")) {
		    tab_name1 = "USER_POS";
		    tab_name2 = "STUDENT_OF";
		    field2 = "USER_ID";
		}
		else if (id_type.equals("team")) {
		    tab_name1 = "TEAM_POS";
		    tab_name2 = "TEAM_OF";
		    field2 = "TEAM_ID";
		}
		
		try {
		    String query = "insert into "+tab_name1+" values ('"+id+"',"+event_id+","+round_num+","+pos+")";
		    System.out.println(query);
		    stmt.executeUpdate(query);
		    con.commit();
		    query = "select COLLEGE_ID from "+ tab_name2 +" where "+ field2 +" = '"+id+"'";
		    System.out.println(query);
		    rs = stmt.executeQuery(query);
		    int col_id = 0;
		    while (rs.next()) 
			col_id = rs.getInt(1);
		    System.out.println("college_id is "+col_id);
		    query = "insert into COLLEGE_POS values ('"+col_id+"',"+event_id+","+round_num+","+pos+")";
		    System.out.println(query);
		    stmt.executeUpdate(query);
		    con.commit();
		} catch (SQLException sqle) {System.out.println("Event does not exist");
		out.println("<html><head></head><body>There was an error. Please try<a href="+Config.servletURL+"Positions?purpose=putAddPointsForm> again</a></body></html>.");}
	    }//finish purpose makeEntry
	    */

	    if (purpose.equals("putViewUTPointsForm")) {
		OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		dumpUTPointsForm(out);
		out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");
	    }

	    if (purpose.equals("viewUTPoints")) {
		//anyone may view these details
		String id = req.getParameter("login");
		
		String id_type = "";
		
		id_type = retTypeID(id);
		
		String tab_name1 = "";
		String field2 = "";

		if (id_type.equals("user")) {
		    tab_name1 = "USER_POS";
		    field2 = "USER_ID";
		    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		    out.println("Points information for the user "+id+":<br>");
		}
		else if (id_type.equals("team")) {
		    tab_name1 = "TEAM_POS";
		    field2 = "TEAM_ID";
		    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");
		    out.println("Points information for the team "+id+":<br>");
		}
		
		try {
		    //first give total points of the team
		    out.println("Total points:<br>");
		    String query = "select sum(points) Tot_Pts from "+tab_name1+" A, prizes B where A.event_id = B.event_id and A.round_no = B.round_no and A.position = B.position and A."+field2+" = '"+id+"'";
		    System.out.println(query);
		    rs = stmt.executeQuery(query);
		    System.out.println("query executed");
		    OutputGenerator.genTable(rs, out);
		    out.println("Event-wise points:<br>");
		    query = "select E.EVENT_NAME Event, sum(points) Tot_Pts from "+tab_name1+" A, prizes B, event E where A.event_id = B.event_id and A.round_no = B.round_no and A.position = B.position and A."+field2+" = '"+id+"' and A.event_id = E.event_id group by E.event_name";
		    System.out.println(query);
		    rs = stmt.executeQuery(query);
		    System.out.println("query executed");
		    OutputGenerator.genTable(rs, out);
		    out.println("Event-wise round-wise points:<br>");
		    query = "select E.event_name Event, A.round_no Round, sum(points) Tot_Pts from "+tab_name1+" A, prizes B, event E where A.event_id = B.event_id and A.round_no = B.round_no and A.position = B.position and A."+field2+" = '"+id+"' and A.event_id = E.event_id group by E.event_name, A.round_no";
		    rs = stmt.executeQuery(query);
		    OutputGenerator.genTable(rs, out);
		    out.println("Total points of all contenders:<br>");
		    query = "select A."+field2+" ID, sum(points) Tot_Pts from "+tab_name1+" A, prizes B where A.event_id = B.event_id and A.round_no = B.round_no and A.position = B.position group by A."+field2+" order by Tot_pts desc";
		    rs = stmt.executeQuery(query);
		    OutputGenerator.genTable(rs, out);
		    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");		   
		} catch (SQLException sqle) {System.out.println("Event does not exist");
		OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");		   
		out.println("There was an error. <br>Please check whether the user name entered is correct or not.<br>Please try<a href="+Config.servletURL+"Positions?purpose=putViewUTPointsForm> again</a>");
		out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");		   
		}
	    }// finish purpose viewUTPoints

	    /*if (purpose.equals("putViewCollegeRankingForm")) 
		dumpCollegeRankingForm(out);
	    */
	    

	    //no form for calling this. call it directly
	    if (purpose.equals("viewCollegeRanking")) {
		
		try {
		OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");		   
		    out.println("College Rankings:<br>");
		    String query = "select college_name College, sum(points) Tot_Pts from college_pos A, prizes B, college C where A.event_id = B.event_id and A.round_no = B.round_no and A.position = B.position and A.college_id = C.college_id group by college_name order by Tot_Pts";
		    System.out.println(query);
		    rs = stmt.executeQuery(query);
		    System.out.println("query executed");
		    OutputGenerator.genTable(rs, out);
		    //Event-wise ranking for a college
		    out.println("College ranks in Events:<br>");
		    query = "select C.college_name College, E.event_name Event, sum(points) Total_Points from college_pos A, prizes B, college C, event E where A.event_id = B.event_id and A.round_no = B.round_no and A.position = B.position and A.college_id = C.college_id and A.event_id = E.event_id group by E.event_name, C.college_name";
		    System.out.println(query);
		    rs = stmt.executeQuery(query);
		    System.out.println("query executed");
		    OutputGenerator.genTable(rs, out);
		    out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");		   
		} catch (SQLException sqle) {System.out.println("Event does not exist");
		OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");		   
		out.println("There was an error. Please try<a href="+Config.servletURL+"Positions?purpose=putViewUTPointsForm> again</a>");
		out.println("<a href="+Config.servletURL+"MITeamLogin?purpose=getMainPage>Main page</a>");
		OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");		   
		}
		
	    }//finish purpose viewCollegeRankings
	} else {//if session is null
	    OutputGenerator.putFile(out, Config.formdirURL+"HeadHTML.html");	
	    out.println("Please login first<br>");
	    out.println("<a href="+Config.servletURL+"MITeamLogin>login page</a>");
	    OutputGenerator.putFile(out, Config.formdirURL+"EndHTML.html");		   
	}
    }//finish doGet


    //Now all the functions which do the HTML + SQL stuff

    /*    public boolean existsID(String id) {
	//check in team and user whether this id is valid
	int count = 0;
	try {
	    String query = "select * from USERS where USER_ID = '"+id+"'";
	    rs = stmt.executeQuery(query);
	    while (rs.next()) 
		count++;
	    if (count==1)
		return true;
	    else if (count==0) {
		query = "select * from TEAM where TEAM_ID = '"+id+"'";
		rs = stmt.executeQuery(query);
		while (rs.next()) 
		    count++;
		if (count==1) 
		    return true;
		else 
		    return false;
	    }
	} catch (Exception e) {System.out.println("Exception");}
	return false;
	}//end existsID
    */

    public synchronized String retTypeID(String id) {
	int count=0;
	try {
	    String query = "select * from USERS where USER_ID = '"+id+"'";
	    rs = stmt.executeQuery(query);
	    while (rs.next()) 
		count++;
	    if (count==1)
		return "user";
	    else if (count==0) {
		query = "select * from TEAM where TEAM_ID = '"+id+"'";
		rs = stmt.executeQuery(query);
		while (rs.next()) 
		    count++;
		if (count==1) 
		    return "team";
		else 
		    return "";//neither user nor team
	    }
	} catch (Exception e) {System.out.println("Exception");}
	return "";
	}//end retTypeID

    public synchronized void dumpUTPointsForm(PrintWriter out) {
	out.println("<h3>View User or Team Points</h3>");
	out.println("<b>Fill in the ID of the user or team:</b><br>");
	out.println("<form action="+Config.servletURL+"Positions method=get>");
	out.println("<table width=50% cellpadding=2 border=0>");
	out.println("<tr><td>ID:</td><td><input type=text size=10 name=login maxlength=10></td></tr>");
	out.println("<tr><input type=hidden value=viewUTPoints name=purpose></tr>");
	out.println("</table>");
	out.println("<input type=submit value=\"Click ONCE to proceed\">");
	out.println("</form>");
    }

    /*    public synchronized boolean checkOC(String queryMaker) {
	String queryString = "";
	boolean ret = false;
	try {
	    queryString = "select MI_DESIGNATION from MI_TEAM where MI_ID = '"+ queryMaker + "'";
	    rs = stmt.executeQuery(queryString);
	    String desig="";
	    while (rs.next())
		desig = rs.getString(1);
	    if (desig.equals("oc"))
		ret = true;
	}catch (SQLException sqle) {System.out.println("Some SQL Exception");}
	return ret;
    }//finish checkOC
    
    public synchronized boolean allowOperateOnEvent(String queryMaker, int event_id) {
	//two cases: qM can be cordi, or qM can be CG
	boolean ret=false;
	if (checkOC(queryMaker))
	    return true;
	if (checkCG(queryMaker)) {//then
	    //if dept of CG is dept of event then allowed
	    System.out.println(queryMaker + "is a CG");
	    String query = "select DEPT_NAME from DEPT_MI_TEAM where MI_ID = '"+ queryMaker + "'";
	    System.out.println(query);
	    try {
		rs = stmt.executeQuery(query);
		System.out.println("query executed");
		String deptCG = "";
		String deptEvent = "";
		while (rs.next()) 
		    deptCG = rs.getString(1);
		
		System.out.println("dept of CG is "+deptCG);
		
		if (existsEvent(event_id)) {
		    query = "select DEPT_NAME from DEPT_EVENTS where EVENT_ID = "+event_id;
		    System.out.println(query);

		    rs = stmt.executeQuery(query);
		    while (rs.next()) 
			deptEvent = rs.getString(1);
		    System.out.println("deptEvent is "+deptEvent);

		    if (deptCG.equals(deptEvent)) 
			ret = true;
		}
		return ret;
	    } catch (SQLException sqle) {System.out.println("Some SQL Exception");}
	} else if (existsCordi(queryMaker)) {//if id is a cordi
	    System.out.println(queryMaker + "is a cordi");
	    if (existsEvent(event_id)) {
		try {
		    String query = "select DEPT_NAME from DEPT_EVENTS where EVENT_ID = "+event_id;
		    System.out.println(query);
		    rs = stmt.executeQuery(query);
		    System.out.println("query executed");
		    String deptEvent = "";
		    while (rs.next()) 
			deptEvent = rs.getString(1);
		    System.out.println("deptEvent is "+deptEvent);
		    
		    //Now compare with dept of cordi
		    query = "select EVENT_ID from EVENT_MI_TEAM where MI_ID = '"+queryMaker+"'";
		    System.out.println(query);
		    rs = stmt.executeQuery(query);
		    System.out.println("query executed");
		    ResultSet rs2 = null;
		    Statement stmt2 = con.createStatement();
		    while (rs.next()) {
			query="select DEPT_NAME from DEPT_EVENTS where EVENT_ID = '"+rs.getInt(1)+"'";
			System.out.println(query);
			rs2 = stmt2.executeQuery(query);
			System.out.println("query executed");
			while (rs2.next()) 
			    if (deptEvent.equals(rs2.getString(1)))
				return true;
		    }
		    return false;
		} catch (Exception e) {System.out.println("Exception in allowOperateOnEvent");}
	    return false;
	    } else 
		return false;
	} else 
	    return false;
	return false;
    }//finish allowOperateOnEvent
    
    public synchronized boolean existsCordi(String cordi_id) {
	String query = "select * from MI_TEAM where MI_ID = '" +cordi_id+"' and MI_DESIGNATION = 'cordi'";
	int count = 0;
	boolean ret = false;
	try {
	    rs = stmt.executeQuery(query);
	    while (rs.next())
		count++;
	    if (count==1) 
		ret = true;
	} catch (SQLException sqle) {System.out.println("Some SQL Exception");}
	    return ret;
	}//finish existsCordi
	
    public synchronized boolean existsEvent(int event_id) {
	String query = "select * from EVENTS where EVENT_ID = " +event_id;
	int count = 0;
	boolean ret = false;
	try {
	    rs = stmt.executeQuery(query);
	    while (rs.next())
		count++;
	    if (count==1) 
		ret = true;
	} catch (SQLException sqle) {System.out.println("Some SQL Exception");}
	return ret;
    }//finish existsEvent

    
    public synchronized boolean checkCG(String queryMaker) {
	String queryString = "";
	boolean ret = false;
	try {
	    queryString = "select MI_DESIGNATION from MI_TEAM where MI_ID = '"+ queryMaker + "'";
	    rs = stmt.executeQuery(queryString);
	    String desig = "";
	    while (rs.next())
		desig = rs.getString(1);
	    if (desig.equals("cg"))
		ret = true;
	}catch (SQLException sqle) {System.out.println("Some SQL Exception");}
	return ret;
    }//finish checkCG
    */

    /*    public synchronized void dumpEventsForm(PrintWriter out, String queryMaker) {
	out.println("<form action="+Config.servletURL+"Positions method=get><b>Enter user/team id and select event</b><br>");
	out.println("<table width=100% cellpadding=2 border=0>");
	out.println("<tr><td> User/Team ID:</td> <td> <INPUT TYPE=text size=10 NAME=\"login\"> </td></tr>");
	out.println("<tr><td> Select one event:</td> <td>");
	//now call a functio that will return the drop-down menu
	//OutputGenerator.genDropDown(out, rs, ddname)

	String query = "select EVENT_NAME from EVENTS, EVENT_MI_TEAM where EVENTS.EVENT_ID = EVENT_MI_TEAM.EVENT_ID and EVENT_MI_TEAM.MI_ID = '"+queryMaker+"'";
	
	try {
	    rs = stmt.executeQuery(query);
	} catch (SQLException sqle) {System.out.println("SQL Exception generated");}
	OutputGenerator.genDropDown(out, rs, "event", "str"); 
	out.println("</td></tr>");
	out.println("<tr><input type=hidden name=purpose value=specRound></tr>");
	out.println("<tr><input type=submit value=\"Click ONCE to Proceed\"></tr>");
	out.println("</table>");
	out.println("</form>");
    }

    
    public synchronized void dumpRoundsForm(PrintWriter out, String id, int event_id) {
	out.println("<form action="+Config.servletURL+"Positions method=get><b>Enter user/team id and select event</b><br>");
	out.println("<table width=50% cellpadding=2 border=0>");
	out.println("<tr><td> Select one round:</td> <td>");
	//now call a functio that will return the drop-down menu
	//OutputGenerator.genDropDown(out, rs, ddname)

	String query = "select ROUND_NO from PRIZES where EVENT_ID = "+event_id;
	try {
	    rs = stmt.executeQuery(query);
	} catch (SQLException sqle) {System.out.println("SQL Exception generated");}
	OutputGenerator.genDropDown(out, rs, "round", "num"); 
	out.println("</td></tr>");
	out.println("<tr><input type=hidden name=login value="+id+"></tr>");
	out.println("<tr><input type=hidden name=event value="+event_id+"></tr>");
	out.println("<tr><input type=hidden name=purpose value=specPos></tr>");
	out.println("<tr><input type=submit value=\"Click ONCE to Proceed\"></tr>");
	out.println("</table>");
	out.println("</form>");
    }

    
    public synchronized void dumpPosForm(PrintWriter out, String id, String event_id, String round_num) {
	out.println("<form action="+Config.servletURL+"Positions method=get><b>Enter user/team id and select event</b><br>");
	out.println("<table width=50% cellpadding=2 border=0>");
	out.println("<tr><td> Select the position obtained:</td> <td>");
	//now call a functio that will return the drop-down menu
	//OutputGenerator.genDropDown(out, rs, ddname)

	String query = "select POSITION from PRIZES where EVENT_ID = "+event_id+" and ROUND_NO = "+round_num;
	try {
	    rs = stmt.executeQuery(query);
	} catch (SQLException sqle) {System.out.println("SQL Exception generated");}
	OutputGenerator.genDropDown(out, rs, "position", "num"); 
	out.println("</td></tr>");
	out.println("<tr><input type=hidden name=login value="+id+"></tr>");
	out.println("<tr><input type=hidden name=event value="+event_id+"></tr>");
	out.println("<tr><input type=hidden name=round value="+round_num+"></tr>");
	out.println("<tr><input type=hidden name=purpose value=makeEntry></tr>");
	out.println("<tr><input type=submit value=\"Click ONCE to Proceed\"></tr>");
	out.println("</table>");
	out.println("</form>");
	}*/



    
}//class finish    
    

