package bin.nsethi;
import java.sql.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;


/** Authentication routines **/


public class Authenticator {
    public static final int CL = -1;
    public static final int ASSISTANCE = -2;
    public static boolean authenticate(HttpServletRequest req,HttpServletResponse res,int type, boolean sessionFlag, Database db)
	throws ServletException, IOException {
	
	if(sessionFlag && type == CL) {//we are req to create a new session
	    String login = req.getParameter("login");
	    String passwd = req.getParameter("passwd");
	    String college = req.getParameter("college");
	    
	    if(db.isCorrect(login,passwd,college)) {
		HttpSession session = req.getSession(true);
		session.putValue("login",login);
		session.putValue("type",new Integer(type));
		session.putValue("college",college);
		return true;
	    }
	} else if (sessionFlag && type == ASSISTANCE) {//we are req to create a new session
	    String login = req.getParameter("login");
	    String passwd = req.getParameter("passwd");
	    if(db.isAssistanceCorrect(login,passwd)) {
		HttpSession session = req.getSession(true);
		session.putValue("login",login);
		session.putValue("type",new Integer(type));
		return true;
	    }
	}
	return false;
    }
    
    
    
    public static boolean isCorrect(HttpServletRequest req,HttpServletResponse res,int type)
	throws ServletException, IOException {
	HttpSession session = req.getSession(false);
	if(session != null) {
	    int ltype = ((Integer) session.getValue("type")).intValue();
	    if(ltype == type)
		return true;
	}
	return false;
    }
    
    
    public static boolean isCorrect(HttpServletRequest req,HttpServletResponse res,int type, String college)
	throws ServletException, IOException {
	HttpSession session = req.getSession(false);
	if(session != null) {
	    String sc = (String) session.getValue("college");
	    System.out.println("session college:" + sc +"*");
	    System.out.println("parameter college:" + college +"*");
	    
	    int ltype = ((Integer) session.getValue("type")).intValue();
	    if(sc.equals(college) && ltype == type)
		return true;
	}
	return false;
    }
    
    public static void logout(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	HttpSession session = req.getSession(true);
	session.invalidate();
    }
}
		

