package bin.nsethi;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

public class CLLogin extends HttpServlet {
    
    private Database database;
    private Config config;
    private boolean flag;
    public void init() {
	try {
	    database = new Database();
	    config = new Config();
	    flag = true;
	} catch(Exception e) {
	    System.out.println(e);
	    database = null;
	    config = null;
	    flag = false;
	}
    }
    
    public void doGet(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	if(flag == false) init();
	if(flag == false) {
	    res.setContentType("text/html");
	    PrintWriter out = res.getWriter();
	    out.println("<html><head><title>Network Error</title></head>");
	    out.println("<h1> Network resources unavailable please try again later</h1>");
	    out.println("<p> Page generated by servlet CLLogin </p>");
	    out.println("</body></html>");
	    return;
	}
	
	
	String flag = req.getParameter("flag");
	
	if(flag == null) 
	    loginPage(req,res);
	else if(flag.equals("takeAllNames"))
	    takeAllNames(req,res);
	
	
    }
    
    public void loginPage(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	ArrayList colleges = database.getColleges();
	out.println("<center><form action=\"" + config.servletURL + "CLLogin\" method=POST>");
	out.println("<table><tr><td>College Name: </td><td><select name=college size=1>");
	
	int x = colleges.size();
	for(int i=0;i<x;i++)
	    out.println("<option>" + (String)colleges.get(i) + "</option>");
	out.println("</select></td><tr>" +
		    "<tr><td>Login: </td><td><input type=text size=10 name=login></td></tr>");
	out.println("<tr><td>Password: </td><td><input type=password size=10 name=passwd></td></tr></table>");
	out.println("<input type=hidden name=flag value=login>" + 
		    "<input type=submit value=\"Login\"</form></center>");
	OutputGenerator.genHTMLEnd(out);
    }

    public void doPost(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	if(flag == false) init();
	if(flag == false) {
	    res.setContentType("text/html");
	    PrintWriter out = res.getWriter();
	    out.println("<html><head><title>Network Error</title></head>");
	    out.println("<h1> Network resources unavailable please try again later</h1>");
	    out.println("<p> Page generated by servlet CLLogin </p>");
	    out.println("</body></html>");
	    return;
	}
	
	String tmp = req.getParameter("flag");
	if(tmp.equals("login")) {
	    boolean allow = Authenticator.authenticate(req,res,Authenticator.CL,true,database);
	    
	    if (allow) {
		System.out.println("CL LOGIN success");
		giveOptions(req,res);
	    } else {
		System.out.println("CL LOGIN failed");
		res.setContentType("text/html");
		PrintWriter out = res.getWriter();
		OutputGenerator.genHTMLHead(out);
		out.println("<p>Login Incorrect</p>" +
			    "<p><a href=\""+config.servletURL+"CLLogin\">back</a></p>");
		OutputGenerator.genHTMLEnd(out);
	    }
	} else if(tmp.equals("insertNames")) 
	    insertNames(req,res);
    }
    
    private void giveOptions(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	HttpSession session = req.getSession(false);
	if (session == null) { 
	    out.println("<p>Login Incorrect</p>" +
			"<p><a href=\""+config.servletURL+"CLLogin\">back</a></p>");
	} else {
	    String college = (String) session.getValue("college");
	    String login = (String) session.getValue("login");
	    out.println("<center><form action=\"" + config.servletURL + "CLLogin\" method=GET>");
	    out.println("<table><tr><td>Number of Males: </td><td><input type=text name=males value=0></td></tr>" +
			"<tr><td>Number of Females: </td><td><input type=text name=females value=0></td></tr>"+
			"</table><input type=hidden name=flag value=takeAllNames>" + 
			"<input type=hidden name=college value=\"" +college+"\">" +
			"<input type=submit value=next></form></center>");
	}
	OutputGenerator.genHTMLEnd(out);
    }

    private void takeAllNames(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	String college = req.getParameter("college");
	int males;
	int females;
	
	try {
	    males = Integer.parseInt(req.getParameter("males"));
	}catch(NumberFormatException e) {
	    males = 0;
	}
	try {
	    females = Integer.parseInt(req.getParameter("females"));
	}catch(NumberFormatException e) {
	    females = 0;
	}
	boolean allow = Authenticator.isCorrect(req,res,Authenticator.CL,college);
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	
	if(!allow) {
	    out.println("<p>You are not Authorized for this Action</p><p>First please login <a href=\"" + config.servletURL +"CLLogin\">here</a></p>");
	} else {
	    out.println("<form action=\"" + config.servletURL + "CLLogin\" method=post>" +
			"<input type=hidden name=college value=\"" + college +"\">" +
			"<input type=hidden name=males value=\"" + males +"\">" +
			"<input type=hidden name=females value=\"" + females +"\">" +
			"<input type=hidden name=flag value=insertNames>");
	    out.println("<h2>Please fill in names of male members</h2>");
	    out.println("<center><table cellpadding=5 border=2><tr><th>S.No</th><th>Gender</th><th>Name</th></tr>");
	    for(int i = 1;i<=males;i++)
		out.println("<tr><td>"+i+"</td><td>Male</td><td><input type=text name=maleName size=20 maxlength=20></td></tr>");
	    out.println("</table></center>");
	    
	    out.println("<h2>Please fill in names of female members</h2>");
	    out.println("<center><table cellpadding=5 border=2><tr><th>S.No</th><th>Gender</th><th>Name</th></tr>");
	    for(int i = 1;i<=females;i++)
		out.println("<tr><td>"+i+"</td><td>Female</td><td><input type=text name=femaleName size=20 maxlength=20></td></tr>");
	    out.println("</table><input type=submit value=submit></center></form>");
	}
	
	OutputGenerator.genHTMLEnd(out);
    }
    
    
    private void insertNames(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	String college = req.getParameter("college");
	int males;
	int females;
	try {
	    males = Integer.parseInt(req.getParameter("males"));
	}catch(NumberFormatException e) {
	    males = 0;
	}
	try {
	    females = Integer.parseInt(req.getParameter("females"));
	}catch(NumberFormatException e) {
	    females = 0;
	}
	boolean allow = Authenticator.isCorrect(req,res,Authenticator.CL,college);
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	
	if(!allow) {
	    out.println("<p>You are not Authorized for this Action</p><p>First please login <a href=\"" + config.servletURL +"CLLogin\">here</a></p>");
	} else {
	    String maleNames[] = req.getParameterValues("maleName");
	    String femaleNames[] = req.getParameterValues("femaleName");
	    
	    database.insertContingentNames(males,females,maleNames,femaleNames,college);
	    out.println("<p>The information has been entered in the MI database. This information will be used when providing rooms. Thankyou</p>");
	}
	OutputGenerator.genHTMLEnd(out);
    }
}








