package bin.nsethi;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

public class CheckOut extends HttpServlet {
    
    private Database database;
    private Config config;
    private boolean flag;
    public void init() {
	try {
	    database = new Database();
	    config = new Config();
	    flag = true;
	} catch(Exception e) {
	    System.out.println(e);
	    database = null;
	    config = null;
	    flag = false;
	}
    }
    
    public void doGet(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	
	if(flag == false) init();
	if(flag == false) {
	    res.setContentType("text/html");
	    PrintWriter out = res.getWriter();
	    out.println("<html><head><title>Network Error</title></head>");
	    out.println("<h1> Network resources unavailable please try again later</h1>");
	    out.println("<p> Page generated by servlet CheckOut </p>");
	    out.println("</body></html>");
	    return;
	}
	/* 
	   To be implemented
	   Authenticator.authenticate(req,res,false)
	   
	   This authenticates the request by checking is session exists, If it does it gets the
	   login,passwd and type(CG,cordi) and checks if that person is in manages list
	   
	   the rest here procedes only if above is OK else a error page is generated
	*/

	
	if(Authenticator.isCorrect(req,res,Authenticator.ASSISTANCE)) {
	    
	    String temp = req.getParameter("flag");
	    if(temp == null)
		defaultAction(req,res);
	    else if(temp.equals("seeAllottedHostels"))
		seeAllottedHostels(req,res);
	    else if(temp.equals("seeAllottedDetails"))
		seeAllottedDetails(req,res);
	    else if(temp.equals("deleteRoom"))
		deleteRooms(req,res);
	} else {
	    res.setContentType("text/html");
	    PrintWriter out = res.getWriter();
	    OutputGenerator.genHTMLHead(out);
	    out.println("Access Denied");
	    OutputGenerator.genHTMLEnd(out);
	}
	
    }
    
    private void deleteRooms(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	String college = req.getParameter("college");
	String hostel = req.getParameter("hostel");
	String fineReceipt = req.getParameter("fineReceipt");
	String amount = req.getParameter("amount");
	String note = req.getParameter("comment");
	if(database.deleteRooms(college,hostel,fineReceipt,amount,note))
	    out.println("<p>Done! cleared all rooms allotted to " + college + " in " + hostel + ".</p>" +
			"<p><a href=\"" + config.servletURL + "CheckOut\">Return</a> to main checkout page</p>");
	else
	    out.println("<p>Error! Could not delete rooms allotted to " + college + " in " + hostel + ". Please try again.</p>" +
			"<p><a href=\"" + config.servletURL + "CheckOut\">Return</a> to main checkout page</p>");
	OutputGenerator.genHTMLEnd(out);
    }
    
    
    private void seeAllottedDetails(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	String college = req.getParameter("college");
	String hostel = req.getParameter("hostel");
	
	ArrayList receipt[] = database.getReceiptDetails(hostel,college);
	/*
	  receipt[1] = receipt Number(s)
	  receipt[2] = Amount
	  receipt[3] = Balance
	*/
	
	ArrayList materials[];
	materials = database.getMaterialsList(hostel,college);
	/*
	  material[0] = name of material
	  material[1] = amount allotted to hostel,college
	*/
	
	ArrayList occupiedRooms = database.getOccupiedRooms(college,hostel);
	
	out.print("<p>Room No: ");
	int x = occupiedRooms.size();
	for(int i=0;i<x;i++)
	    out.print((String) occupiedRooms.get(i) + ", ");
	out.println(" in " + hostel + " to " + college + "</p>");
	
	out.println("<table cellpadding=5 border=3 cellspacing=3>");
	x = materials[0].size();
	for(int i=0;i<x;i++) 
	    out.println("<tr><td>" + materials[0].get(i) + "</td><td>" + materials[1].get(i) + "</td><tr>");
	
	x = receipt[0].size();
	out.print("</table><br /><br /><h2>Receipt Details</h2>" +
		    "<table><tr><td><b>Receipt Nos:</b></td><td>");
	for(int i=0;i<x;i++)
	    out.print(receipt[0].get(i) + ", "); 
	out.print("</td></tr><tr><td><b>Amount:</b></td><td>");
	for(int i=0;i<x;i++)
	    out.print(receipt[1].get(i) + ", "); 
	out.print("</td></tr><tr><td><b>Balance:</b></td><td>");
	for(int i=0;i<x;i++)
	    out.print(receipt[2].get(i) + ", "); 
	out.println("</d></tr></table>" +
		    "<p>Click on the button below to free this room</p>" +
		    "<form action=\"" + config.servletURL + "CheckOut\" method=GET>" +
		    "<input type=hidden name=college value=\"" + college +"\">" +
		    "<input type=hidden name=hostel value=\"" + hostel +"\">" +
		    "<input type=hidden name=flag value=deleteRoom>" +
		    "<h2>Fine Details</h2><p>Please fill the following if any fine is to be imposed. Otherwise enter 0 <b><i>all</i></b> the fields blank.</p>" +
		    "<table><tr><td><b>Fine Receipt Number: </b></td><td>" +
		    "<input type=text name=fineReceipt maxlength=10 size=10 value=0></td></tr>" +
		    "<tr><td><b>Amount:</td><td><input type=text name=amount size=10 value=0></td></tr>" +
		    "<tr><td><b>Comment:</b></td><td><input type=text name=comment size=20 maxlength=100 value=0></td></tr></table>" +
		    "<input type=submit value=\"Check Out\"></form>");
	OutputGenerator.genHTMLEnd(out);
    }
    

    
    private void seeAllottedHostels(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	String college = req.getParameter("college"); 
	ArrayList rooms[] = database.getAllottedRooms(college);
	/*
	  room[0] place
	  room[1] number of rooms available
	*/
	out.println("<p>Allotted to College : " + college + "</p>");
	out.println("<center><form action=\"" + config.servletURL + "CheckOut\" method=GET>" +
		    "<table><tr><th></th><th>Place</th><th>Number of Rooms</th></tr>" +
		    "<input type=hidden name=flag value=seeAllottedDetails>" +
		    "<input type=hidden name=college value=\"" + college + "\">");
	int x = rooms[0].size();
	for(int i=0;i<x;i++) 
	    out.println("<tr><td><input type=radio name=hostel value=\"" + (String)rooms[0].get(i) + "\"></td><td>" +  (String)rooms[0].get(i) + "</td><td>" + (String)rooms[1].get(i) + "</td></tr>");
	out.println("</table><input type=submit value=next></form></center>");
	OutputGenerator.genHTMLEnd(out);
    }


    private void defaultAction(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	out.println("<p>Choose the college</p>" +
		    "<center><form action=\"" + config.servletURL + "CheckOut\" method=\"GET\">" +
		    "<input type=hidden name=flag value=seeAllottedHostels>");
	ArrayList colleges = database.getColleges();
	out.println("<table><tr><td>College Name: </td><td><select name=college size=1>");
	
	int x = colleges.size();
	for(int i=0;i<x;i++)
	    out.println("<option>" + (String)colleges.get(i) + "</option>");
	out.println("</select></td></tr></table>" +
		    "<input type=submit value=next></form></center>");
	OutputGenerator.genHTMLEnd(out);
    }
}
    

