package bin.nsethi;
import java.sql.*;
import java.io.*;
import java.util.*;

public class Database {
    
    private Config config;
    private Connection conn;
    private Statement stmt;
    private PreparedStatement pstmt1;
    private PreparedStatement pstmt2;
    private PreparedStatement pstmt3;
    private PreparedStatement pstmt4;
    private PreparedStatement pstmt5;
    private PreparedStatement pstmt6;
    private PreparedStatement pstmt7;
    private PreparedStatement pstmt8;
    private PreparedStatement pstmt9;
    private PreparedStatement pstmt10;
    private PreparedStatement pstmt11;
    private PreparedStatement pstmt12;
    private PreparedStatement pstmt13;
    private PreparedStatement pstmt14;
    private PreparedStatement pstmt15;
    private PreparedStatement pstmt16;
    private PreparedStatement pstmt17;
    private PreparedStatement pstmt18;
    private PreparedStatement pstmt19;
    private PreparedStatement pstmt20;
    private PreparedStatement pstmt21;
    private PreparedStatement pstmt22;
    private PreparedStatement pstmt23;
    private PreparedStatement pstmt24;
    private PreparedStatement pstmt25;
    private PreparedStatement pstmt26;
    private PreparedStatement pstmt27;
    private PreparedStatement pstmt28;
    private PreparedStatement pstmt29;
    private PreparedStatement pstmt30;
    private PreparedStatement pstmt31;
    private PreparedStatement pstmt32;
    private PreparedStatement pstmt33;
    private PreparedStatement pstmt34;
    private PreparedStatement pstmt35;
    private PreparedStatement pstmt36;

    
    private ResultSet rs;
    
    public Database()
	throws Exception {
	config = new Config();
	DriverManager.registerDriver(new  oracle.jdbc.driver.OracleDriver());
	conn = DriverManager.getConnection(config.dbURL,config.dbLogin,config.dbPasswd);
	stmt = conn.createStatement();
	pstmt1 = conn.prepareStatement("select COLLEGE_ACCOMMODATION.COLLEGE_NAME, COLLEGE_DEPOSIT.RECEIPT,AMOUNT_PAID,BALANCE from COLLEGE_ACCOMMODATION, COLLEGE_DEPOSIT where COLLEGE_ACCOMMODATION.RECEIPT = COLLEGE_DEPOSIT.RECEIPT and PLACE = ? and ROOM_NO = ?");
	pstmt2 = conn.prepareStatement("select MATERIAL_NAME,sum(AMOUNT) from ACCOMMODATION_MATERIAL where PLACE = ? and COLLEGE_NAME = ? group by MATERIAL_NAME");
	pstmt3 = conn.prepareStatement("select COLLEGE_NAME from COLLEGE_ACCOMMODATION where PLACE = ? and ROOM_NO = ?");
	pstmt4 = conn.prepareStatement("insert into ROOM_FINE values (?,?,?,?,?)");
	pstmt5 = conn.prepareStatement("select CL_ID from COLLEGE where CL_ID = ? and COLLEGE_NAME = ?");
	pstmt6 = conn.prepareStatement("select USER_ID from USERS where USER_ID = ? and PASSWD = ?");
	pstmt7 = conn.prepareStatement("update college set COLLEGE_NUM_MALES = ? , COLLEGE_NUM_FEMALES = ? where COLLEGE_NAME = ?");
	pstmt8 = conn.prepareStatement("insert into CONTINGENT_NAMES values (?,?,?)");
	pstmt9 = conn.prepareStatement("delete from contingent_names where COLLEGE_NAME = ?");
	pstmt10 = conn.prepareStatement("select COLLEGE_NUM_MALES,COLLEGE_NUM_FEMALES from COLLEGE where COLLEGE_NAME = ?");
	pstmt11 = conn.prepareStatement("select NAME from CONTINGENT_NAMES where COLLEGE_NAME = ? and GENDER = ?");
	pstmt12 = conn.prepareStatement("select ROOM_NO from VACANT_ROOMS where PLACE = ?");
	pstmt13 = conn.prepareStatement("select PLACE, count(ROOM_NO) from VACANT_ROOMS group by PLACE");
	pstmt14 = conn.prepareStatement("insert into COLLEGE_DEPOSIT values(?,?,?,?)");
	pstmt15 = conn.prepareStatement("insert into COLLEGE_ACCOMMODATION values(?,?,?,?)");
	pstmt16 = conn.prepareStatement("insert into ACCOMMODATION_MATERIAL values ( ?, ?, ?, ?)");
	pstmt17 = conn.prepareStatement("delete from VACANT_ROOMS where PLACE = ? and ROOM_NO = ?");
	pstmt18 = conn.prepareStatement("update INVENTORY set FREE = FREE - ?, ALLOTTED = ALLOTTED + ? where PLACE = ? and NAME = ?");
	pstmt19 = conn.prepareStatement("select PLACE, count(ROOM_NO) from COLLEGE_ACCOMMODATION where COLLEGE_NAME = ? group by PLACE");
	pstmt20 = conn.prepareStatement("select unique(COLLEGE_DEPOSIT.RECEIPT),COLLEGE_DEPOSIT.AMOUNT_PAID,COLLEGE_DEPOSIT.BALANCE from COLLEGE_DEPOSIT,COLLEGE_ACCOMMODATION where COLLEGE_DEPOSIT.RECEIPT = COLLEGE_ACCOMMODATION.RECEIPT and COLLEGE_DEPOSIT.COLLEGE_NAME = COLLEGE_ACCOMMODATION.COLLEGE_NAME and COLLEGE_DEPOSIT.COLLEGE_NAME = ? and COLLEGE_ACCOMMODATION.PLACE = ?");
	pstmt21 = conn.prepareStatement("insert into ROOM_FINE values (?,?,?,?,?)");
	pstmt22 = conn.prepareStatement("insert into VACANT_ROOMS values (?,?)");
	pstmt23 = conn.prepareStatement("delete from COLLEGE_ACCOMMODATION where COLLEGE_NAME = ? and PLACE = ?");
	pstmt24 = conn.prepareStatement("update INVENTORY set FREE = FREE + ?, ALLOTTED = ALLOTTED - ? where PLACE = ? and NAME = ?");
	pstmt25 = conn.prepareStatement("delete from ACCOMMODATION_MATERIAL where PLACE = ? and COLLEGE_NAME = ?");
	pstmt26 = conn.prepareStatement("select ROOM_NO from COLLEGE_ACCOMMODATION where COLLEGE_NAME = ? and PLACE = ?");
	pstmt27 = conn.prepareStatement("select * from MI_TEAM where MI_ID = ? and MI_PASSWD = ?");
	pstmt28 = conn.prepareStatement("select * from DEPT_MI_TEAM where MI_ID = ? and DEPT_NAME = \'assistance\'");    
	pstmt29 = conn.prepareStatement("insert into INVENTORY values (?,?,?,?)");
	pstmt30 = conn.prepareStatement("select unique(NAME) from INVENTORY");
	pstmt31 = conn.prepareStatement("select unique(PLACE) from INVENTORY");
	pstmt32 = conn.prepareStatement("insert into VACANT_ROOMS values (?,?)");
	pstmt33 = conn.prepareStatement("select PLACE as Place, COLLEGE_NAME as College, ROOM_NO as Room from COLLEGE_ACCOMMODATION order by PLACE,COLLEGE_NAME,ROOM_NO");
	pstmt34 = conn.prepareStatement("select COLLEGE_NAME as College, ROOM_NO as Room from COLLEGE_ACCOMMODATION where PLACE = ? order by COLLEGE_NAME,ROOM_NO");
	pstmt35 = conn.prepareStatement("select PLACE as Place, ROOM_NO as Room from COLLEGE_ACCOMMODATION where COLLEGE_NAME = ? order by PLACE,ROOM_NO");
	pstmt36 = conn.prepareStatement("select ROOM_NO as Room from COLLEGE_ACCOMMODATION where COLLEGE_NAME = ? and PLACE = ? order by ROOM_NO");
	
    }
    
    public synchronized ArrayList getEvents() {
	try {
	    String query = "select EVENT_NAME from EVENT where PASSES=1";
	    System.out.println(query);
	    ResultSet rs = stmt.executeQuery(query);
	    //String buff[] = new String[100];
	    //int i=0;
	    ArrayList events = new ArrayList();
	    while(rs.next()) {
		System.out.println("DEBUG: " + rs.getString(1)); 
		events.add(rs.getString(1));
		//i++;
	    }
	    
	    //String events[] = new String[i];
	    //for(int x=0;x<i;x++)
	    //events[x] = buff[x];
	    return events;
	} catch (Exception e) {
	    System.out.println(e);
	}
	return null;
	
    }

    public synchronized ArrayList getColleges() {
	
	try {
	   	    
	    String query = "select COLLEGE_NAME from COLLEGE";
	    System.out.println(query);
	    ResultSet rs = stmt.executeQuery(query);
	    //String buff[] = new String[100];
	    //int i=0;
	    ArrayList hostels = new ArrayList();
	    while(rs.next()) {
		System.out.println("DEBUG: " + rs.getString(1)); 
		hostels.add(rs.getString(1));
		//buff[i] = rs.getString(1);
		//i++;
	    }
	    //String events[] = new String[i];
	    //for(int x=0;x<i;x++)
	    //	events[x] = buff[x];
	    return hostels;
	} catch (Exception e) {
	    System.out.println(e);
	}
	return null;
	
    }
    
    public synchronized ArrayList[] getVacant() {
	
	try {
	   	    
	    String query = "select PLACE,ROOM_NO from VACANT_ROOMS";
	    System.out.println(query);
	    ResultSet rs = stmt.executeQuery(query);
	    //String buff[] = new String[100];
	    //int i=0;
	    ArrayList[] vacant = new ArrayList[2];
	    vacant[0] = new ArrayList();
	    vacant[1] = new ArrayList();
	    while(rs.next()) {
		vacant[0].add(rs.getString(1));
		vacant[1].add(rs.getString(2));
		//buff[i] = rs.getString(1);
		//i++;
	    }
	    //String events[] = new String[i];
	    //for(int x=0;x<i;x++)
	    //	events[x] = buff[x];
	    return vacant;
	} catch (Exception e) {
	    System.out.println(e);
	}
	return null;
	
    }

    
    public synchronized ArrayList[] getOccupied() {
	try {
	    String query = "select PLACE,ROOM_NO from COLLEGE_ACCOMMODATION";
	    ResultSet rs = stmt.executeQuery(query);
	    ArrayList[] vacant = new ArrayList[2];
	    vacant[0] = new ArrayList();
	    vacant[1] = new ArrayList();
	    while(rs.next()) {
		vacant[0].add(rs.getString(1));
		vacant[1].add(rs.getString(2));
	    }
	    return vacant;
	} catch (Exception e) {
	    System.out.println(e);
	}
	return null;
	
    }

    public synchronized String[] getCollegeDetails(String hostel, String roomNo) {
	try {
	    /*
	      pstmt1 = conn.prepareStatement("select COLLEGE_ACCOMMODATION.COLLEGE_NAME, COLLEGE_DEPOSIT.RECEIPT,AMOUNT_PAID,BALANCE from COLLEGE_ACCOMMODATION, COLLEGE_DEPOSIT where COLLEGE_ACCOMMODATION.RECEIPT = COLLEGE_DEPOSIT.RECEIPT and PLACE = ? and ROOM_NO = ?");
	      
	      pstmt3 = conn.prepareStatement("select COLLEGE_NAME from COLLEGE_ACCOMMODATION where PLACE = ? and ROOM_NO = ?");
	    */
	    String cdet[] = new String[4];
	    pstmt1.setString(1,hostel);
	    pstmt1.setString(2,roomNo);
	    rs = pstmt1.executeQuery();
	    if (rs.next()) {
		cdet[0] = rs.getString(1);
		cdet[1] = rs.getString(2);
		cdet[2] = rs.getString(3);
		cdet[3] = rs.getString(4);
	    } else {
		pstmt3.setString(1,hostel);
		pstmt3.setString(2,roomNo);
		rs = pstmt3.executeQuery();
		rs.next();
		cdet[0] = rs.getString(1);
		cdet[1] = null;
		cdet[2] = null;
		cdet[3] = null;
	    }
	    return cdet;
	} catch (Exception e) {
	    System.out.println(e);
	}
	return null;
	
    }

    public synchronized ArrayList[] getMaterialsList(String hostel, String college) {
	try {
	    /*
	      pstmt2 = conn.prepareStatement("select MATERIAL_NAME,sum(AMOUNT) from ACCOMMODATION_MATERIAL where PLACE = ? and COLLEGE_NAME = ? group by Material_name");
	    */
	    pstmt2.setString(1,hostel);
	    pstmt2.setString(2,college);
	    ResultSet rs = pstmt2.executeQuery();
	    ArrayList materials[] = new ArrayList[2];
	    materials[0] = new ArrayList();
	    materials[1] = new ArrayList();
	    while(rs.next()) {
		materials[0].add(rs.getString(1));
		materials[1].add(rs.getString(2));
	    }
	    return materials;
	}catch(Exception e) {
	    System.out.println("Database.getMaterialsList: " + e);
	}
	return null;
    }
    


    public synchronized boolean insertPassFor(String college, String student, String event) {
	
	try {
	   	    
	    // String query = "select EVENT_ID from EVENT where EVENT_NAME=\'" + event + "\'";
	    //ResultSet rs = stmt.executeQuery(query);
	    //rs.next(); 
	    //String eventID = rs.getString(1);
	    String insert = "insert into PASSES_FOR values (\'" + college + "\' , \'" +
		student + "\', \'" + event + "\')";
	    stmt.executeUpdate(insert);
	    return true;
	} catch (Exception e) {
	    System.out.println(e);
	}
	return false;
	
    }	

    public synchronized boolean isValid(String college, String student, String event) {
	
	try {
	    
	    //String query = "select EVENT_ID from EVENT where EVENT_NAME=" + event;
	    //ResultSet rs = stmt.executeQuery(query);
	    //rs.next(); 
	    //String eventID = rs.getString(1);
	    
	    //String query1 = "select * from SPECTATOR_LIST where COLLEGE_NAME=\'" + college + 
	    //	"\' and STUDENT_ID=\'" + student +"\'";
	    //System.out.println(query1);
	    String query2 = "select * from PASSES_FOR where COLLEGE_NAME=\'" + college +
		"\' and STUDENT_ID=\'" + student + "\' and EVENT_NAME=\'" + event + "\'";
	    System.out.println(query2);
	    ResultSet rs1 = stmt.executeQuery(query2);
	    
	    if(!rs1.next()){
		return true;
	    }
	} catch (Exception e) {
	    System.out.println(e);
	}
	return false;
	
    }	

    protected synchronized void genSummaryTable(PrintWriter out) {
	
	try {
	   
	    out.println("<h2>Distribution of passes by college</h2>");
	    String query = "select COLLEGE_NAME as College, count(STUDENT_ID) as Passes from PASSES_FOR group by COLLEGE_NAME order by COLLEGE_NAME";
	    ResultSet rs = stmt.executeQuery(query);
	    OutputGenerator.genTable(rs,out);
	    
	    out.println("<h2>Distribution of passes by Event</h2>");
	    query = "select EVENT_NAME as Event, count(STUDENT_ID) as Passes from PASSES_FOR group by EVENT_NAME order by EVENT_NAME";
	    rs = stmt.executeQuery(query);
	    OutputGenerator.genTable(rs,out);

	    out.println("<h2>Distribution of passes by Event and College</h2>");
	    query = "select EVENT_NAME as Event,COLLEGE_NAME as College,count(STUDENT_ID) as Passes from PASSES_FOR group by EVENT_NAME,COLLEGE_NAME order by EVENT_NAME,COLLEGE_NAME";
	    rs = stmt.executeQuery(query);
	    OutputGenerator.genTable(rs,out);
	} catch (Exception e) {
	    System.out.println(e);
	}
    }
  

    public synchronized ArrayList[] getMaterialsList(String hostel) {
	
	try {
	   	    
	    String query = "select NAME,sum(FREE) from INVENTORY where PLACE=\'" + hostel +"\' group by NAME";
	    System.out.println(query);
	    ResultSet rs = stmt.executeQuery(query);
	    ArrayList[] materials = new ArrayList[2];
	    materials[0] = new ArrayList();
	    materials[1] = new ArrayList();
	    while(rs.next()) {
		materials[0].add(rs.getString(1));
		materials[1].add(rs.getString(2));
	    }
	    return materials;
	} catch (Exception e) {
	    System.out.println(e);
	}
	return null;
	
    }
    
    public  synchronized boolean allotRoom(int[] materialAllotted,ArrayList material, String college,
					   String hostel,String roomNo[],
					   String receiptNo,int amount,int balance) {
	try {
	    /*
	      All transactions Have to be Atomic.
	      pstmt14 = conn.prepareStatement("insert into COLLEGE_DEPOSIT values(?,?,?,?)");
	      pstmt15 = conm.prepareStatement("insert into COLLEGE_ACCOMMODATION values(?,?,?,?)");
	      pstmt16 = conn.prepareStatement("insert into ACCOMMODATION_MATERIAL values ( ?, ?, ?, ?)");
	      pstmt17 = conn.prepareStatement("delete from VACANT_ROOMS where PLACE = ? and ROOM_NO = ?");
	      pstmt18 = conn.prepareStatement("update INVENTORY set FREE = FREE - ?, ALLOTTED = ALLOTTED + ? where PLACE = ? and NAME = ?");
	    */
	    
	    conn.commit();
	    conn.setAutoCommit(false);
	    if(!receiptNo.equals("0")) {
		/* note that it is not necessary that there is a deposit with each room*/ 
		pstmt14.setString(1,receiptNo);
		pstmt14.setInt(2,amount);
		pstmt14.setInt(3,balance);
		pstmt14.setString(4,college);
		pstmt14.executeUpdate();
	    }
	    /**/System.out.println("Debug database.allotRoom: " + 1);
	    pstmt15.setString(1,receiptNo);
	    pstmt15.setString(2,college);
	    pstmt15.setString(3,hostel);
	    for(int i=0;i<roomNo.length;i++) {
		pstmt15.setString(4,roomNo[i]);
		pstmt15.executeUpdate();
	    }
	    /**/System.out.println("Debug database.allotRoom: " + 2);
	    pstmt16.setString(1,hostel);
	    pstmt16.setString(2,college);
	    for(int i=0;i<materialAllotted.length;i++) {
		pstmt16.setString(3,(String)material.get(i));
		pstmt16.setInt(4,materialAllotted[i]);
		pstmt16.executeUpdate();
	    }
	    /**/System.out.println("Debug database.allotRoom: " + 3);    
	    pstmt17.setString(1,hostel);
	    for(int i=0;i<roomNo.length;i++) {
		pstmt17.setString(2,roomNo[i]);
		pstmt17.executeUpdate();
	    }
	    /**/System.out.println("Debug database.allotRoom: " + 4);
	    for(int i=0;i<materialAllotted.length;i++) {
		pstmt18.setInt(1,materialAllotted[i]);
		pstmt18.setInt(2,materialAllotted[i]);
		pstmt18.setString(3,hostel);
		pstmt18.setString(4,(String)material.get(i));
		pstmt18.executeUpdate();
	    }
	    
	    conn.commit();
	    conn.setAutoCommit(true);
	    return true;
	} catch (Exception e) {
	    try {
		System.out.println("Class Database: method allotRoom\n" + e);
		conn.rollback();
		conn.setAutoCommit(true);
		return false;
	    } catch (SQLException se) {
		System.out.println("Class Database: method allotRoom\n" + se);
		return false;
	    }
	}
    }
    
    private synchronized boolean insertRoomFine(String hostel,String roomNo,String college,
						String receipt, String amount,String note) {
	/*
	  pstmt4 = conn.prepareStatement("insert into ROOM_FINE values (?,?,?,?,?)");
	*/
	try {
	    pstmt4.setString(1,receipt);
	    pstmt4.setString(2,amount);
	    pstmt4.setString(3,college);
	    pstmt4.setString(4,hostel);
	    pstmt4.setString(5,roomNo);
	    pstmt4.setString(6,note);
	    pstmt4.executeUpdate();
	    return true;
	}catch(Exception e) {
	    System.out.println("Class Database method insert RoomFine: " + e);
	}
	return false;
    }
    
    public synchronized boolean isCorrect(String login, String passwd, String college) {//CL authentication
	/*
	  pstmt5 = conn.prepareStatement("select CL_ID from COLLEGE where CL_ID = ? and COLLEGE_NAME = ?");
	  pstmt6 = conn.prepareStatement("select USER_ID from USERS where USER_ID = ? and PASSWD = ?");
	*/
	try {
	    pstmt5.setString(1,login);
	    pstmt5.setString(2,college);
	    rs = pstmt5.executeQuery();
	    if(rs.next()) {//ie above query was successful
		pstmt6.setString(1,login);
		pstmt6.setString(2,passwd);
		rs = pstmt6.executeQuery();
		if(rs.next())
		    return true;
	    }
	}catch(SQLException e) {
	    System.out.println(e);
	}
	return false;
    }


    public synchronized boolean isAssistanceCorrect(String login, String passwd) {//Assistance authentication
	/*
	  pstmt27 = conn.prepareStatement("select * from MI_TEAM where MI_ID = ? and MI_PASSWD = ?");
	  pstmt28 = conn.prepareStatement("select * from DEPT_MI_TEAM where MI_ID = ? and DEPT_NAME = \'assistance\'");
	*/
	try {
	    pstmt27.setString(1,login);
	    pstmt27.setString(2,passwd);
	    rs = pstmt27.executeQuery();
	    if(rs.next()) {//ie above query was successful
		pstmt28.setString(1,login);
		rs = pstmt28.executeQuery();
		if(rs.next())
		    return true;
	    }
	}catch(SQLException e) {
	    System.out.println(e);
	}
	return false;
    }



    public  synchronized boolean insertContingentNames(int males, int females, String[] maleNames, String[] femaleNames, String college) {
	
	/*
	  pstmt7 = conn.prepareStatement("update college set COLLEGE_NUM_MALES = ? , COLLEGE_NUM_FEMALES = ? where COLLEGE_NAME = ?");
	  pstmt8 = conn.prepareStatement("insert into CONTINGENT_NAMES values (?,?,?)");
	  pstmt9 = conn.prepareStatement("delete from contingent_names where COLLEGE_NAME = ?");
	*/
	try {
	    conn.commit();
	    conn.setAutoCommit(false);
	    pstmt9.setString(1,college);
	    pstmt9.executeUpdate();
	    System.out.println("Database.insertContingentNames  0");
	    pstmt7.setInt(1,males);
	    pstmt7.setInt(2,females);
	    pstmt7.setString(3,college);
	    pstmt7.executeUpdate();
	    System.out.println("Database.insertContingentNames  1");
	    for(int i=0;i<maleNames.length;i++) {
		pstmt8.setString(1,college);
		pstmt8.setString(2,maleNames[i]);
		pstmt8.setString(3,"M");
		pstmt8.executeUpdate();
	    }
	    System.out.println("Database.insertContingentNames  2");
	    for(int i=0;i<femaleNames.length;i++) {
		pstmt8.setString(1,college);
		pstmt8.setString(2,femaleNames[i]);
		pstmt8.setString(3,"F");
		pstmt8.executeUpdate();
	    }
	    conn.commit();
	    conn.setAutoCommit(true);
	    return true;
	} catch (SQLException e) {
	    System.out.println(e);
	    try {
		conn.rollback();
		conn.setAutoCommit(true);
	    } catch (Exception ee) {
		System.out.println(e);
	    }
	} finally {
	    try {
		conn.setAutoCommit(true);
	    }catch(Exception e) {
		System.out.println("You are possiblly major time fuckedup GOOD LUCK!! " + e);
	    }
	}
	return false;
    }

    public synchronized String[] getContingentStat(String college) {
	/*
	  pstmt10 = conn.prepareStatement("select COLLEGE_NUM_MALES,COLLEGE_NUM_FEMALES from COLLEGE where COLLEGE_NAME = ?");
	*/
	try {
	    pstmt10.setString(1,college);
	    
	    rs = pstmt10.executeQuery();
	    rs.next();
	    String num[] = new String[2];
	    num[0] = rs.getString(1);
	    num[1] = rs.getString(2);
	    return num;
	} catch(SQLException e) {
	    System.out.println("Database.getContingentStat:  " + e);
	}
	return null;
    }

    public synchronized ArrayList getContingentNames(String college, String gender) {
	/*
	  pstmt11 = conn.prepareStatement("select NAME from CONTINGENT_NAMES where COLLEGE_NAME = ? and GENDER = ?");
	*/
	try {
	    pstmt11.setString(1,college);
	    pstmt11.setString(2,gender);
	    rs = pstmt11.executeQuery();
	    ArrayList names = new ArrayList();
	    while(rs.next())
		names.add(rs.getString(1));
	    return names;
	} catch (SQLException e) {
	    System.out.println("Database.getContingentNames  :" +e );
	}
	return null;
    }

    public synchronized ArrayList getRoomList(String hostel) {
	
	try {
	    /*
	      pstmt12 = conn.prepareStatement("select ROOM_NO from VACANT_ROOMS where PLACE = ?");
	    */
	    pstmt12.setString(1,hostel);
	    rs = pstmt12.executeQuery();
	    ArrayList vacant = new ArrayList();
	    while(rs.next()) 
		vacant.add(rs.getString(1));
	    return vacant;
	} catch (Exception e) {
	    System.out.println("Database.getRoomList  " + e);
	}
	return null;
	
    }

    public synchronized ArrayList[] getFreeRooms() {
	
	try {
	    
	    /*
	      pstmt13 = conn.prepareStatement("select PLACE, count(ROOM_NO) from VACANT_ROOMS group by PLACE");
	    */
	    
	    rs = pstmt13.executeQuery();
	    
	    ArrayList[] vacant = new ArrayList[2];
	    vacant[0] = new ArrayList();
	    vacant[1] = new ArrayList();
	    while(rs.next()) {
		vacant[0].add(rs.getString(1));
		vacant[1].add(rs.getString(2));
	    }
	    return vacant;
	} catch (Exception e) {
	    System.out.println(e);
	}
	return null;
    }
    
    public synchronized ArrayList[] getAllottedRooms(String college) {
	
	try {
	    
	    /*
	      pstmt19 = conn.prepareStatement("select PLACE, count(ROOM_NO) from COLLEGE_ACCOMMODATION where COLLEGE_NAME = ? group by PLACE");
	    */
	    pstmt19.setString(1,college);
	    rs = pstmt19.executeQuery();
	    
	    ArrayList[] vacant = new ArrayList[2];
	    vacant[0] = new ArrayList();
	    vacant[1] = new ArrayList();
	    while(rs.next()) {
		vacant[0].add(rs.getString(1));
		vacant[1].add(rs.getString(2));
	    }
	    return vacant;
	} catch (Exception e) {
	    System.out.println(e);
	}
	return null;
    }
    
    public synchronized ArrayList[] getReceiptDetails(String hostel,String college) {
	try {
	    /*
	      pstmt20 = conn.prepareStatement("select unique(COLLEGE_DEPOSIT.RECEIPT),COLLEGE_DEPOSIT.AMOUNT_PAID,COLLEGE_DEPOSIT.BALANCE from COLLEGE_DEPOSIT,COLLEGE_ACCOMMODATION where COLLEGE_DEPOSIT.RECEIPT = COLLEGE_ACCOMMODATION.RECEIPT and COLLEGE_DEPOSIT.COLLEGE_NAME = COLLEGE_ACCOMMODATION.COLLEGE_NAME and COLLEGE_DEPOSIT.COLLEGE_NAME = ? and COLLEGE_ACCOMMODATION.PLACE = ?");
	    */
	    pstmt20.setString(1,college);
	    pstmt20.setString(2,hostel);
	    rs = pstmt20.executeQuery();
	    ArrayList receipt[] = new ArrayList[3];
	    receipt[0] = new ArrayList();
	    receipt[1] = new ArrayList();
	    receipt[2] = new ArrayList();
	    while(rs.next()) {
		receipt[0].add(rs.getString(1));
		receipt[1].add(rs.getString(2));
		receipt[2].add(rs.getString(3));
	    }
	    
	    return receipt;
	} catch (Exception e) {
	    System.out.println("Database.getReceiptDetails: " + e);
	}
	return null;
    }
    
    public synchronized ArrayList getOccupiedRooms(String college, String hostel) {
	try {
	    /*
	      pstmt26 = conn.prepareStatement("select ROOM_NO from COLLEGE_ACCOMMODATION where COLLEGE_NAME = ? and PLACE = ?")
	    */
	    pstmt26.setString(1,college);
	    pstmt26.setString(2,hostel);
	    rs = pstmt26.executeQuery();
	    ArrayList rooms = new ArrayList();
	    while(rs.next())
		rooms.add(rs.getString(1));
	    return rooms;
	} catch (Exception e) {
	    System.out.println("Database.getOccupiedRooms: " + e);
	}
	return null;
    }
    
    public synchronized boolean deleteRooms(String college,String hostel,String fineReceipt,String amount,String note) {
	
	/*
	  pstmt21 = conn.prepareStatement("insert into ROOM_FINE values (?,?,?,?,?)");
	  pstmt22 = conn.prepareStatement("insert into VACANT_ROOMS values (?,?)");
	  pstmt23 = conn.prepareStatement("delete from COLLEGE_ACCOMMODATION where COLLEGE_NAME = ? and PLACE = ?")
	  pstmt24 = conn.prepareStatement("update INVENTORY set FREE = FREE + ?, ALLOTTED = ALLOTTED - ? where PLACE = ? and NAME = ?");
	  pstmt25 = conn.prepareStatement("delete from ACCOMMODATION_MATERIAL where PLACE = ? and COLLEGE_NAME = ?");
	*/
	
	try {
	    conn.commit();
	    conn.setAutoCommit(false);
	    if(!fineReceipt.equals("0")) {
		pstmt21.setString(1,fineReceipt);
		pstmt21.setInt(2,Integer.parseInt(amount));
		pstmt21.setString(3,college);
		pstmt21.setString(4,hostel);
		pstmt21.setString(5,note);
		pstmt21.executeUpdate();
	    }
	    
	    ArrayList rooms = getOccupiedRooms(college,hostel);
	    int x = rooms.size();
	    for(int i=0;i<x;i++) {
		pstmt22.setString(1,hostel);
		pstmt22.setString(2,(String)rooms.get(i));
		pstmt22.executeUpdate();
	    }
	    
	    pstmt23.setString(1,college);
	    pstmt23.setString(2,hostel);
	    pstmt23.executeUpdate();
	    
	    ArrayList materials[] = getMaterialsList(hostel,college);
	    x = materials[0].size();
	    pstmt24.setString(3,hostel);
	    for(int i=0;i<x;i++) {
		pstmt24.setInt(1,Integer.parseInt((String) materials[1].get(i)));
		pstmt24.setInt(2,Integer.parseInt((String) materials[1].get(i)));
		pstmt24.setString(4,(String) materials[0].get(i));
		pstmt24.executeUpdate();
	    }

	    pstmt25.setString(1,hostel);
	    pstmt25.setString(2,college);
	    pstmt25.executeUpdate();
	    
	    conn.commit();
	    conn.setAutoCommit(true);
	    return true;
	} catch (Exception e) {
	    try {
		System.out.println("Class Database: method allotRoom\n" + e);
		conn.rollback();
		conn.setAutoCommit(true);
		return false;
	    } catch (SQLException se) {
		System.out.println("Class Database: method allotRoom\n" + se);
		return false;
	    }
	}
    }

    public synchronized boolean addMaterial(String material, int amount, String hostel, boolean addNew) {
	/*
	  pstmt24 = conn.prepareStatement("update INVENTORY set FREE = FREE + ?, ALLOTTED = ALLOTTED - ? where PLACE = ? and NAME = ?");    
	  pstmt29 = conn.prepareStatement("insert into INVENTORY values (?,?,?,?)");
	*/
	
	try {
	    if(addNew) {
		pstmt29.setString(1,material);
		pstmt29.setString(2,hostel);
		pstmt29.setInt(3,amount);
		pstmt29.setInt(4,0);
		pstmt29.executeUpdate();
	    } else {
		pstmt24.setString(4,material);
		pstmt24.setString(3,hostel);
		pstmt24.setInt(1,amount);
		pstmt24.setInt(2,0);
		pstmt24.executeUpdate();		
	    }
	    return true;
	} catch (Exception e) {
	    System.out.println("Database.insertMaterial: " + e);
	}
	return false;
    }
    
    public synchronized ArrayList getMaterialNames() {
	/*
	  pstmt30 = conn.prepareStatement("select unique(NAME) from INVENTORY");
	*/
	
	try {
	    rs = pstmt30.executeQuery();
	    ArrayList mat = new ArrayList();
	    while(rs.next()) {
		mat.add(rs.getString(1));
	    }
	    return mat;
	} catch (Exception e) {
	    System.out.println("Database.getMaterialNames: " + e);
	}
	return null;
    }
    
    public synchronized ArrayList getHostels() {
	/*
	  pstmt31 = conn.prepareStatement("select unique(PLACE) from INVENTORY");
	*/
	
	try {
	    rs = pstmt31.executeQuery();
	    ArrayList mat = new ArrayList();
	    while(rs.next()) {
		mat.add(rs.getString(1));
	    }
	    return mat;
	} catch (Exception e) {
	    System.out.println("Database.getMaterialNames: " + e);
	}
	return null;
      }

    public synchronized boolean addRoom(String hostel,String roomNo) {
	/*
	  pstmt32 = conn.prepareStatement("insert into VACANT_ROOMS values (?,?)");
	*/
	
	
	
	try {
	    try {
		ArrayList mat = getMaterialNames();
		int x = mat.size();
		pstmt29.setString(2,hostel);
		pstmt29.setInt(3,0);
		pstmt29.setInt(4,0);
		for(int i=0;i<x;i++) {
		    pstmt29.setString(1,(String) mat.get(i));
		    pstmt29.executeUpdate();
		}
	    } catch (SQLException e) {
		System.out.println("Happens dont worry :  " + e);
	    }
	    
	    
	    pstmt32.setString(1,hostel);
	    pstmt32.setString(2,roomNo);
	    pstmt32.executeUpdate();
	    return true;
	} catch (Exception e) {
	    System.out.println("Database.addRoom: " + e);
	}
	return false;
    }
    
    public synchronized void queryRooms(String hostel, String college, PrintWriter out) {
	/*
	  pstmt33 = conn.prepareStatement("select PLACE as Place, COLLEGE_NAME as College, ROOM_NO as Room from COLLEGE_ACCOMMODATION order by PLACE,COLLEGE_NAME,ROOM_NO");
	  pstmt34 = conn.prepareStatement("select COLLEGE_NAME as College, ROOM_NO as Room from COLLEGE_ACCOMMODATION where PLACE = ? order by OLLEGE_NAME,ROOM_NO");
	  pstmt35 = conn.prepareStatement("select PLACE as Place, ROOM_NO as Room from COLLEGE_ACCOMMODATION where COLLEGE_NAME = ? order by PLACE,ROOM_NO");
	  pstmt36 = conn.prepareStatement("select ROOM_NO as Room from COLLEGE_ACCOMMODATION where COLLEGE_NAME = ? and PLACE = ? order by ROOM_NO");
	*/
	
	try {
	    if(hostel.equals("--Any--") && college.equals("--Any--"))
		rs = pstmt33.executeQuery();
	    else if(!hostel.equals("--Any--") && college.equals("--Any--")) {
		pstmt34.setString(1,hostel);
		rs = pstmt34.executeQuery();
	    } else if(hostel.equals("--Any--") && !college.equals("--Any--")) {
		pstmt35.setString(1,college);
		rs = pstmt35.executeQuery();
	    } else if(!hostel.equals("--Any--") && !college.equals("--Any--")) {
		pstmt36.setString(1,college);
		pstmt36.setString(2,hostel);
		rs = pstmt36.executeQuery();
	    }
	    OutputGenerator.genTable(rs,out);
	} catch (Exception e) {
	    System.out.println("Database.queryRooms: " + e);
	}
    }
    
}
