package bin.nsethi;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

public class MiscFeatures extends HttpServlet {
    
    private Database database;
    private Config config;
    private boolean flag;
    public void init() {
	try {
	    database = new Database();
	    config = new Config();
	    flag = true;
	} catch(Exception e) {
	    System.out.println(e);
	    database = null;
	    config = null;
	    flag = false;
	}
    }
    
    /** 
	doGet fuctions generates the page which gives the option to:
	o Add Materials
	o Delete materials
	o Add Rooms
    **/
    
    
    public void doGet(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	
	if(flag == false) init();
	if(flag == false) {
	    res.setContentType("text/html");
	    PrintWriter out = res.getWriter();
	    out.println("<html><head><title>Network Error</title></head>");
	    out.println("<h1> Network resources unavailable please try again later</h1>");
	    out.println("<p> Page generated by servlet MiscFeatures </p>");
	    out.println("</body></html>");
	    return;
	}
	/* 
	   To be implemented
	   Authenticator.authenticate(req,res,false)
	   
	   This authenticates the request by checking is session exists, If it does it gets the
	   login,passwd and type(CG,cordi) and checks if that person is in manages list
	   
	   the rest here procedes only if above is OK else a error page is generated
	*/


	if(Authenticator.isCorrect(req,res,Authenticator.ASSISTANCE)) {
	    
	    String temp = req.getParameter("flag");
	    if(temp.equals("addMaterials"))
		addMaterials(req,res);
	    else if(temp.equals("insertMaterial"))
		insertMaterials(req,res);
	    else if(temp.equals("addRooms"))
		addRooms(req,res);
	    else if(temp.equals("insertRooms"))
		insertRooms(req,res);
	    else if(temp.equals("viewAllottedRooms"))
		viewAllottedRooms(req,res);
	    else if(temp.equals("queryRooms"))
		queryRooms(req,res);
	    
	} else {
	    res.setContentType("text/html");
	    PrintWriter out = res.getWriter();
	    OutputGenerator.genHTMLHead(out);
	    out.println("Access Denied");
	    OutputGenerator.genHTMLEnd(out);
	}
	
    }

    
    private void queryRooms(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	String hostel = req.getParameter("hostel");
	String college = req.getParameter("college");
	out.println("<p>College: " + college + "</p><p>Hostel: " + hostel + "</p>");
	database.queryRooms(hostel,college,out);
	OutputGenerator.genHTMLEnd(out);
    }
    
    
    private void viewAllottedRooms(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	
	ArrayList colleges = database.getColleges();
	ArrayList hostels = database.getHostels();
	out.println("<p>Fill in the following</p>");
	out.println("<center><form action=\"" + config.servletURL + "MiscFeatures\" method=GET>" +
		    "<table><tr><td>College Name: </td><td><select name=college size=1>");
	int x = colleges.size();
	for(int i=0;i<x;i++)
	    out.println("<option>" + (String)colleges.get(i) + "</option>");
	out.println("<option>--Any--</option></select></td></tr>" +
		    "<tr><td>Place: </td><td><select name=hostel size=1>");
	x = hostels.size();
	for(int i=0;i<x;i++)
	    out.println("<option>" + (String)hostels.get(i) + "</option>");
	out.println("<option>--Any--</option></select></td></tr>" +
		    "</table><input type=hidden name=flag value=queryRooms>" +
		    "<input type=submit value=\"Show Allotted Rooms\"></form></center>");
	OutputGenerator.genHTMLEnd(out);
    }


    private void insertRooms(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	String hostel = req.getParameter("hostel");
	if(hostel.equals("--Other--")) {
	    hostel = req.getParameter("otherHostel");
	}
	String roomNo = req.getParameter("roomNo");
	
	if(database.addRoom(hostel,roomNo))
	    out.println("<p>Done!</p>");
	else
	    out.println("<p>Error! Please try again later.</p>");
	OutputGenerator.genHTMLEnd(out);
    }

    private void addRooms(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	
	ArrayList hostels = database.getHostels();
	out.println("<p>Please fill in the following form:</p>");
	out.println("<center><form action=\"" + config.servletURL + "MiscFeatures\" method=GET>" +
		    "<table><tr><td>Hostel Name: </td><td><select name=hostel size=1>");
	int x = hostels.size();
	for(int i=0;i<x;i++)
	    out.println("<option>" + (String)hostels.get(i) + "</option>");
	out.println("<option>--Other--</option>" +
		    "</select></td><td><input type=text name=otherHostel size=10</td></tr>" +
		    "<tr><td>Room No : </td><td><input type=text size=10 name=roomNo></td></tr></table>" +
		    "<input type=hidden name=flag value=insertRooms>" +
		    "<input type=submit value=Add></form></center>");
	OutputGenerator.genHTMLEnd(out);
    }




    
    private void insertMaterials(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	String material = req.getParameter("material");
	boolean addNew = false;
	if(material.equals("--Other--")) {
	    addNew = true;
	    material = req.getParameter("otherMaterial");
	}
	String hostel = req.getParameter("hostel");
	int amount;
	try {
	    amount = Integer.parseInt(req.getParameter("amount"));
	} catch (NumberFormatException e) {
	    out.println("Amount should be an Integer.");
	    OutputGenerator.genHTMLEnd(out);
	    return;
	}
	if(database.addMaterial(material,amount,hostel,addNew))
	    out.println("<p>Done!</p>");
	else
	    out.println("<p>Error! Please try again later.</p>");
	OutputGenerator.genHTMLEnd(out);
    }
    
    private void addMaterials(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	
	ArrayList materialNames = database.getMaterialNames();
	ArrayList hostels = database.getHostels();
	out.println("<p>If you want to remove a material then enter negative number in amount.</p>");
	out.println("<center><form action=\"" + config.servletURL + "MiscFeatures\" method=GET>" +
		    "<table><tr><td>Material Name: </td><td><select name=material size=1>");
	int x = materialNames.size();
	for(int i=0;i<x;i++)
	    out.println("<option>" + (String)materialNames.get(i) + "</option>");
	out.println("<option>--Other--</option></select></td><td>" +
		    "<input type=text size=10 name=otherMaterial></td></tr>" +
		    "<tr><td>Place: </td><td><select name=hostel size=1>");
	x = hostels.size();
	for(int i=0;i<x;i++)
	    out.println("<option>" + (String)hostels.get(i) + "</option>");
	out.println("</select></td></tr><tr><td>Amount to be added: </td><td>" +
		    "<input type=text size=10 name=amount></td></tr></table>" +
		    "<input type=hidden name=flag value=insertMaterial>" +
		    "<input type=submit value=Add></form></center>");
	OutputGenerator.genHTMLEnd(out);
    }
}
