package bin.nsethi;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

public class PassAllotment extends HttpServlet {

    private Database database;
    private Config config;
    private boolean flag;
    public void init() {
	try {
	    database = new Database();
	    config = new Config();
	    flag = true;
	} catch(Exception e) {
	    System.out.println(e);
	    database = null;
	    config = null;
	    flag = false;
	}
    }
    
 
    public void doGet(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {

	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	
	if(flag == false) init();
	if(flag == false) {
	    out.println("<h1> Network resources unavailable please try again later</h1>");
	    out.println("<p> Page generated by servlet PassAllotment </p>");
	    OutputGenerator.genHTMLEnd(out);
	    return;
	    
	}
	
	/* To be implemented
	   Authenticator.authenticate(req,res,false)
	   
	   This authenticates the request by checking is session exists, If it does it gets the
	   login,passwd and type(CG,cordi) and checks if that person is in manages list
	   
	   the rest here procedes only if above is OK else a error page is generated
	*/
	
	String temp = req.getParameter("flag");
	if(temp == null) {
	    if(Authenticator.isCorrect(req,res,Authenticator.ASSISTANCE)) {
		
		out.print("<h2> Please enter the following information </h2>");
		
		ArrayList events = database.getEvents();
		ArrayList colleges = database.getColleges();
		out.print("<center><form action=\"" + config.servletURL + "PassAllotment\" method=\"GET\">" + 
			  "<table><tr><td><b><i>College</b></i> :</td><td><select name=\"college\" size=1>");
		int x = colleges.size();
		for(int i=0;i<x;i++)
		    out.println("<option>" + (String)colleges.get(i) + "</option>");
		out.print("</select></td></tr>" +
			  "<tr><td><b><i>Event:</i></b></td><td><select name=\"event\" size=1>");
		
		x = events.size();
		for(int i=0;i<x;i++)
		    out.println("<option>" + (String)events.get(i) + "</option>");
		out.print("</select></td></tr>" +
			  "<tr><td><b><i>Student Id</i></b> :</td><td><input type=text name=\"student\" size=10></td></tr></table>" +
			  "<input type=hidden name=flag value=allotPass>" +
			  "<input type=submit value=Check></form><br /><br /><br />" +
			  "<form action=\"" + config.servletURL + "PassAllotment\" method=\"GET\">" +
			  "<input type=hidden name=flag value=genSummary>" +
			  "<input type=submit value=\"Show Summary\"></form></center>");
		OutputGenerator.genHTMLEnd(out);
	    } else {
		out.println("Access Denied");
		OutputGenerator.genHTMLEnd(out);
	    }
	} else if (temp.equals("allotPass")) {
	    allotPass(req,res);
	} else if (temp.equals("genSummary")) {
	    genSummary(req,res);
	}
    }
    
    public void allotPass(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	if(Authenticator.isCorrect(req,res,Authenticator.ASSISTANCE)) {
	    String college = req.getParameter("college");
	    String student = req.getParameter("student");
	    String event = req.getParameter("event");
	    /**/System.out.println(college + "\t" + student + "\t" + event);
	    
	    if (database.isValid(college,student,event)) {
		if (!(database.insertPassFor(college,student,event))) {
		    res.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,"Server encountered an internal error. please contact Nikhil Sethi at nsethi@cse.iitb.ac.in");
		    return;
		}
		out.print("<h2>Completed!!</h2>" +
			  "<h2> Following were Given pass:</h2>" +
			  "<b><i>College</i></b>: " + college + "<br />" +
			  "<b><i>Student ID</i></b>: " + student +"<br />" +
			  "<b><I>Event</B></i>: " + event + " <br />" +
			  "<a href=\"" + config.servletURL + "PassAllotment\">back</a>");
	    } else {
		out.print("<h2>Not Done!!</h2>" +
			  "<h2> Following could not be Given pass:</h2>" +
			  "<b><i>College</i></b>: " + college + "<br />" +
			  "<b><i>Student ID</i></b>: " + student +"<br />" +
			  "<b><I>Event</B></i>: " + event + "<br />" +
			  "<h3> This can be either because the above person has already taken a pass or their name does not appear in the college lists</h3>" +
			  "<a href=\"" + config.servletURL + "PassAllotment\">back</a>");
	    }
	} else {
	    out.println("Access Denied");
	}
	
	OutputGenerator.genHTMLEnd(out);
    }
    
    protected void genSummary(HttpServletRequest req, HttpServletResponse res) 
	throws ServletException, IOException {
	
	PrintWriter out = res.getWriter();
	Config config = new Config();
	out.print("<h1>Pass Distribution by College and Event</h1>" +
		  "<a href=\"" + config.servletURL + "PassAllotment\">back</a>");
	database.genSummaryTable(out);
	OutputGenerator.genHTMLEnd(out);
    }
}




