package bin.nsethi;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

public class RoomAllotment extends HttpServlet {
    
    private Database database;
    private Config config;
    private boolean flag;
    public void init() {
	try {
	    database = new Database();
	    config = new Config();
	    flag = true;
	} catch(Exception e) {
	    System.out.println(e);
	    database = null;
	    config = null;
	    flag = false;
	}
    }
    
    /** 
	doGet fuctions generates the page which gives the option to:
	o Allot rooms to Contingents
	
	
	The Room Allotment is Handeled by servlet VacantRoom
	Checking out is done by this servlet itself
    **/
    
    
    public void doGet(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	
	if(flag == false) init();
	if(flag == false) {
	    res.setContentType("text/html");
	    PrintWriter out = res.getWriter();
	    out.println("<html><head><title>Network Error</title></head>");
	    out.println("<h1> Network resources unavailable please try again later</h1>");
	    out.println("<p> Page generated by servlet RoomAllotment </p>");
	    out.println("</body></html>");
	    return;
	}
	/* 
	   To be implemented
	   Authenticator.authenticate(req,res,false)
	   
	   This authenticates the request by checking is session exists, If it does it gets the
	   login,passwd and type(CG,cordi) and checks if that person is in manages list
	   
	   the rest here procedes only if above is OK else a error page is generated
	*/
	
	if(Authenticator.isCorrect(req,res,Authenticator.ASSISTANCE)) {
	    
	    String temp = req.getParameter("flag");
	    if(temp == null)
		defaultAction(req,res);
	    else if(temp.equals("collegeDetail"))
		collegeDetails(req,res);
	    else if(temp.equals("showHostels"))
		showHostel(req,res);
	    else if(temp.equals("allotHostel"))
		allotHostel(req,res);
	    else if(temp.equals("allotRooms"))
		allotRooms(req,res);
	    else if(temp.equals("finalRoomAllot"))
		finalRoomAllot(req,res);
	} else {
	    res.setContentType("text/html");
	    PrintWriter out = res.getWriter();
	    OutputGenerator.genHTMLHead(out);
	    out.println("Access Denied");
	    OutputGenerator.genHTMLEnd(out);
	}
    }
    

    protected void finalRoomAllot(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException {
	
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	String hostel = req.getParameter("hostel");
	String roomNo[] = req.getParameterValues("roomNo");
	String college = req.getParameter("college");
	ArrayList materials[] = new ArrayList[2];
	/* 
	   materials[0] = name;
	   materials[1] = amount available free in this hostel.
	*/
	materials = database.getMaterialsList(hostel);
	
	int x = materials[0].size();
	int materialAllotted[] = new int[x];
	
	try {
	    for(int i=0;i<x;i++)
		materialAllotted[i] = Integer.parseInt(req.getParameter((String)materials[0].get(i)));
	}catch(NumberFormatException e) {
	    out.println("<h1>Materials allotted fields should not be left empty and should be integer values only</h1>");
	    OutputGenerator.genHTMLEnd(out);
	    return;
	}
	String receiptNo = req.getParameter("receiptNo");
	int amount = Integer.parseInt(req.getParameter("amount"));
	int balance = Integer.parseInt(req.getParameter("balance"));
	boolean isValid = true;
	for(int i=0;i<x;i++)
	    isValid = isValid && 
		(materialAllotted[i] <= Integer.parseInt((String)materials[1].get(i)));
	if (!isValid) {
	    out.println("<h1>Materials allotted fields should not be left empty and amount allotted should be less than or equal to amount available.</h1>");
	    OutputGenerator.genHTMLEnd(out);
	    return;
	}
	
	/*
	  If all is OK then insert materialAlloted,materials[0],college,roomNo,hostel,
	  reciptNo, recipt amount into the Database and in is it is successful Display
	  success page
	*/
	if(database.allotRoom(materialAllotted, materials[0],college,hostel,roomNo,receiptNo,amount,balance)) {
	    /* 
	       The room has been allotted and database updated.
	       Display the summary of things.
	    */
	    out.println("<h1>Success! The following information was inserted into the database:</h1>" +
			"<table>" +
			"<tr><td><b>College</b></td><td>" + college + "</td></tr>" +
			"<tr><td><b>Hostel</b></td><td>" + hostel + "</td></tr>" +
			"<tr><td><b>Room No.</b></td><td>");
	    for(int i=0;i<roomNo.length;i++)
		out.println(roomNo[i] + ", ");
	    out.println("</td></tr></table>" +
			"<br /><BR /><h2>List of Materials</h2><table>" +
			"<tr><th>Material Name</th><th>Amount</th></tr>");
	    for(int i=0;i<x;i++) 
		out.println("<tr><td><b>" + materials[0].get(i) + "</b></td><td> " + 
			    materialAllotted[i] + "</td></tr>");
	    out.println("</Table></h2>Amount Received</h2><table>" +
			"<tr><td><b>Recipt Number</b></td><td>" + receiptNo + "</td></tr>" +
			"<tr><td><b>Amount</b></td><td>" + amount + "</td></tr>" +
			"<tr><td><b>Balance</b></td><td>" + balance + "</td></tr>" +
			"</table><br />" +
			"<p><a href=\"" + config.servletURL + "RoomAllotment\">Back</a></p>");
	} else {
	    out.println("<h1>Not Done!!</h1><p>There was some error in processing your request at this time. Please try again in a few minutes. If the problem persists then contact your system Administrator.</p>");
	}
	OutputGenerator.genHTMLEnd(out);
	
    }
    

    
    


    private void allotRooms(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	String college = req.getParameter("college"); 
	String hostel = req.getParameter("hostel");
	String rooms[] = req.getParameterValues("roomNo");
	
	ArrayList materials[] = new ArrayList[2];
	materials = database.getMaterialsList(hostel);
	
	out.println("<p>Fill in the following details</p>" +
		    "<table><tr><th>College: </th><td>" + college +"</td></tr>" +
		    "<tr><th>Place: </th><td>" + hostel + "</td></tr>" +
		    "</table><center><form action=\"" + config.servletURL + "RoomAllotment\" method=GET>");
	
	out.println("<table border=3 cellpadding=5 cellspacing=3>" +
		    "<tr><th>Material Name</th><th>Amount Available</th><th>Amount Allotted</th></tr>");
	
	int x = materials[0].size();
	for(int i=0;i<x;i++) 
	    out.println("<tr><td>" + materials[0].get(i) + "</td><td>" + materials[1].get(i) + "</td><td><input type=text size=10 name=\"" + materials[0].get(i) + "\" value=0></td></tr>");
	out.println("</table><br /><br /><h2>Receipt Details</h2>" +
		    "<p>Keep Receipt number as 0 if no receipt is issued</p><table>" + 
		    "<tr><td>Receipt number</td><td><input type=text size=10 maxlength=10 name=receiptNo value=0></td></tr>" +
		    "<tr><td>Amount</td><td><input type=text size=10 name=amount value=0></td></tr>" +
		    "<tr><td>Balance</td><td><input type=text size=10 maxlength=10 name=balance value=0></td></tr></table>");
	for(int i=0;i<rooms.length;i++)
	    out.println("<input type=hidden name=roomNo value=\"" + rooms[i] + "\">");
	out.println("<input type=hidden name=college value=\"" + college + "\">" +
		    "<input type=hidden name=hostel value=\"" + hostel + "\">" +
		    "<input type=hidden name=flag value=finalRoomAllot>" +
		    "<input type=submit name=\"Allot Room\"/></form></table>");
	OutputGenerator.genHTMLEnd(out);
    }
    
    
    private void allotHostel(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	String college = req.getParameter("college"); 
	String hostel = req.getParameter("hostel");
	ArrayList rooms = database.getRoomList(hostel);
	out.println("<h2>Please select the rooms</h>" +
		    "<p>Allotting rooms in " + hostel + " to " + college + "</p>" +
		    "<center><form action=\"" + config.servletURL + "RoomAllotment\" action=GET>" +
		    "<input type=hidden name=flag value=allotRooms>" +
		    "<input type=hidden name=college value=\"" + college + "\">" +
		    "<input type=hidden name=hostel value=\"" + hostel + "\"><table>");
	
	int x = rooms.size();
	for(int i=0;i<x;i++) 
	    out.println("<tr><td><input type=checkbox name=roomNo value=\"" + (String)rooms.get(i) + "\"></td><td>" +  (String)rooms.get(i) + "</td></tr>");
	out.println("</table><input type=submit value=next></form></center>");
	OutputGenerator.genHTMLEnd(out);
	
    }
    


    private void showHostel(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	String college = req.getParameter("college"); 
	ArrayList rooms[] = database.getFreeRooms();
	/*
	  room[0] place
	  room[1] number of rooms available
	*/
	out.println("<p>Allotting to College : " + college + "</p>");
	out.println("<center><form action=\"" + config.servletURL + "RoomAllotment\" method=GET>" +
		    "<table border=3 cellpadding=10><tr><th></th><th>Place</th><th>Number of Rooms</th></tr>" +
		    "<input type=hidden name=flag value=allotHostel>" +
		    "<input type=hidden name=college value=\"" + college + "\">");
	int x = rooms[0].size();
	for(int i=0;i<x;i++) 
	    out.println("<tr><td><input type=radio name=hostel value=\"" + (String)rooms[0].get(i) + "\"></td><td>" +  (String)rooms[0].get(i) + "</td><td>" + (String)rooms[1].get(i) + "</td></tr>");
	out.println("</table><input type=submit value=next></form></center>");
	OutputGenerator.genHTMLEnd(out);
    }
    
    
    private void collegeDetails(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	String college = req.getParameter("college"); 
	String num[] = database.getContingentStat(college);
	ArrayList maleNames = database.getContingentNames(college,"M");
	ArrayList femaleNames = database.getContingentNames(college,"F");
	out.println("<h2>College : " + college + "</h2>");
	out.println("<center><table><tr><th>Total males: " + num[0] + "</th><th>Total Females: " + num[1] + "</th></tr>");
	out.println("<tr><td><ol>");
	int x = maleNames.size();
	for(int i=0;i<x;i++)
	    out.println("<li>" + (String)maleNames.get(i) + "</li>");
	out.println("</ol></td><td><ol>");
	x = femaleNames.size();
	for(int i=0;i<x;i++)
	    out.println("<li>" + femaleNames.get(i) + "</li>");
	out.println("</ol></td></tr></table><form action=\"" + config.servletURL + "RoomAllotment\" method=GET>" +
		    "<input type=hidden name=flag value=showHostels>" +
		    "<input type=hidden name=college value=\"" + college + "\">" +
		    "<input type=submit value=next></form></center>");
	OutputGenerator.genHTMLEnd(out);
	
    }
    

    private void defaultAction(HttpServletRequest req,HttpServletResponse res)
	throws ServletException, IOException {
	res.setContentType("text/html");
	PrintWriter out = res.getWriter();
	OutputGenerator.genHTMLHead(out);
	out.println("<p>Choose the college</p>" +
		    "<center><form action=\"" + config.servletURL + "RoomAllotment\" method=\"GET\">" +
		    "<input type=hidden name=flag value=collegeDetail>");
	ArrayList colleges = database.getColleges();
	out.println("<table><tr><td>College Name: </td><td><select name=college size=1>");
	
	int x = colleges.size();
	for(int i=0;i<x;i++)
	    out.println("<option>" + (String)colleges.get(i) + "</option>");
	out.println("</select></td></tr></table>" +
		    "<input type=submit value=next></form></center>");
	OutputGenerator.genHTMLEnd(out);
    }
}










