/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.management.transport;

import com.adventnet.management.transport.SessionTransportProvider;
import com.adventnet.management.transport.TransportException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class TcpSessionTransportImpl
implements SessionTransportProvider {
    Socket socket = null;
    DataOutputStream out = null;
    DataInputStream in = null;
    private String hostName = null;

    public TcpSessionTransportImpl(Socket socket) {
        this.socket = socket;
        this.hostName = socket.getInetAddress().getHostName();
        try {
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        }
        catch (IOException iOException) {}
    }

    public int close() throws TransportException {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return -1;
            }
            this.socket = null;
        }
        return 0;
    }

    public InetAddress getAddress() {
        return this.socket.getInetAddress();
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    public int open(String[] stringArray) throws TransportException {
        return 0;
    }

    public byte[] read() throws TransportException {
        int n = 0;
        byte[] byArray = null;
        try {
            int n2 = this.in.available();
            while ((n2 = this.in.available()) == 0) {
                Thread.sleep(10L);
            }
            n = this.in.readInt();
            byArray = new byte[n];
            this.in.readFully(byArray, 0, n);
        }
        catch (IOException iOException) {
            throw new TransportException(iOException.toString());
        }
        catch (InterruptedException interruptedException) {}
        return byArray;
    }

    public int write(byte[] byArray, int n) throws TransportException {
        try {
            this.out.writeInt(n);
            this.out.write(byArray, 0, n);
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new TransportException(iOException.toString());
        }
        return 0;
    }
}

