/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.beans;

import com.adventnet.utils.SnmpUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public class ErrorMessages {
    static Hashtable errString = new Hashtable();
    public static final int SNMP_ERR_NOERROR = 0;
    public static final int SNMP_ERR_TOOBIG = 1;
    public static final int SNMP_ERR_NOSUCHNAME = 2;
    public static final int SNMP_ERR_BADVALUE = 3;
    public static final int SNMP_ERR_READONLY = 4;
    public static final int SNMP_ERR_GENERR = 5;
    public static final int SNMP_ERR_NOACCESS = 6;
    public static final int SNMP_ERR_WRONGTYPE = 7;
    public static final int SNMP_ERR_WRONGLENGTH = 8;
    public static final int SNMP_ERR_WRONGENCODING = 9;
    public static final int SNMP_ERR_WRONGVALUE = 10;
    public static final int SNMP_ERR_NOCREATION = 11;
    public static final int SNMP_ERR_INCONSISTENTVALUE = 12;
    public static final int SNMP_ERR_RESOURCEUNAVAILABLE = 13;
    public static final int SNMP_ERR_COMMITFAILED = 14;
    public static final int SNMP_ERR_UNDOFAILED = 15;
    public static final int SNMP_ERR_AUTHORIZATIONERROR = 16;
    public static final int SNMP_ERR_NOTWRITABLE = 17;
    public static final int SNMP_ERR_INCONSISTENTNAME = 18;
    public static final int SNMP_NOT_INIT = 19;
    public static final int INVALID_VERSION = 20;
    public static final int OID_NOT_SPECIFIED = 21;
    public static final int REQ_TIMEDOUT = 22;
    public static final int INVALID_V1_REQ = 23;
    public static final int EMPTY_VAR_BIND = 24;
    public static final int INVALID_NON_REP = 25;
    public static final int EMPTY_DATA = 26;
    public static final int VAR_BIND_OUT_OF_RANGE = 27;
    public static final int EMPTY_VARIABLE = 28;
    public static final int INVALID_NUMERIC_VAL = 29;
    public static final int MIB_NODE_UNAVAIL = 30;
    public static final int OID_NOT_LEAF = 31;
    public static final int ERR_CREATING_VARIABLE = 32;
    public static final int ILLEGAL_ARG = 33;
    public static final int INVALID_GENERIC_TYPE = 34;
    public static final int IP_ADDR_NOT_SPECIFIED = 35;
    public static final int SESSION_REMOTE_HOST_UNKNOWN = 36;
    public static final int SECURITYEXP_CONNECTING_REMOTE_HOST = 37;
    public static final int IO_ERROR = 38;
    public static final int INVALID_TABLE_OID = 39;
    public static final int EXT_INDEX_UNAVAIL = 40;
    public static final int UNKNOWN_ERR = 43;
    public static final int ASN1_ERROR_ERR = 50;
    public static final int NOSUCHOBJECTEXP = 128;
    public static final int NOSUCHINSTANCEEXP = 129;
    public static final int ENDOFMIBVIEWEXP = 130;
    public static final int NO_ERR_REGISTERED = -1;

    static {
        ErrorMessages.initialize();
    }

    public ErrorMessages() {
        ErrorMessages.initialize();
    }

    static int addNewErrorString(String string) {
        errString.put(new Integer(errString.size()), string);
        return errString.size() - 1;
    }

    public static String getErrorString(int n) {
        if (n == -1) {
            return SnmpUtils.getString("No Error code registered");
        }
        return (String)errString.get(new Integer(n));
    }

    private static void initialize() {
        errString.put(new Integer(0), SnmpUtils.getString("No error"));
        errString.put(new Integer(1), SnmpUtils.getString("Response message too large"));
        errString.put(new Integer(2), SnmpUtils.getString("There is no such variable name in this mib."));
        errString.put(new Integer(3), SnmpUtils.getString("The value given has wrong type or length."));
        errString.put(new Integer(4), SnmpUtils.getString("The variable is read only"));
        errString.put(new Integer(5), SnmpUtils.getString("A general failure occured"));
        errString.put(new Integer(6), SnmpUtils.getString("A no access error occured"));
        errString.put(new Integer(7), SnmpUtils.getString("A wrong type error occured"));
        errString.put(new Integer(8), SnmpUtils.getString("A wrong length error occured."));
        errString.put(new Integer(9), SnmpUtils.getString("A wrong encoding error occured."));
        errString.put(new Integer(10), SnmpUtils.getString("A wrong value error occured."));
        errString.put(new Integer(11), SnmpUtils.getString("A no creation error occured."));
        errString.put(new Integer(12), SnmpUtils.getString("An inconsistent value error occured."));
        errString.put(new Integer(13), SnmpUtils.getString("A resource unavailable error occured."));
        errString.put(new Integer(14), SnmpUtils.getString("A commit failed error occured."));
        errString.put(new Integer(15), SnmpUtils.getString("A undo failed error occured."));
        errString.put(new Integer(16), SnmpUtils.getString("A authorization failed error occured."));
        errString.put(new Integer(17), SnmpUtils.getString("A not writable error occured."));
        errString.put(new Integer(18), SnmpUtils.getString("An inconsistent name error occured."));
        errString.put(new Integer(19), SnmpUtils.getString("Error: SNMP not initialized"));
        errString.put(new Integer(20), SnmpUtils.getString("Error: Invalid Version"));
        errString.put(new Integer(21), SnmpUtils.getString("Error: OID Not Specified"));
        errString.put(new Integer(22), String.valueOf(SnmpUtils.getString("Error: Request Timed Out ")) + " ");
        errString.put(new Integer(23), SnmpUtils.getString("Error: Invalid Request for V1"));
        errString.put(new Integer(24), SnmpUtils.getString("Error: Agent Returned Empty Varbind(s)"));
        errString.put(new Integer(25), SnmpUtils.getString("Error: Invalid Non-repeaters Value"));
        errString.put(new Integer(26), SnmpUtils.getString("Error: Agent Returned Empty Data"));
        errString.put(new Integer(27), SnmpUtils.getString("Error: VariableBindings Index out of Range"));
        errString.put(new Integer(28), SnmpUtils.getString("Error: Agent Returned Empty Variable"));
        errString.put(new Integer(29), SnmpUtils.getString("Error: Agent Returned Non-Numeric Value"));
        errString.put(new Integer(30), SnmpUtils.getString("Error: MIB node unavailable for OID."));
        errString.put(new Integer(31), SnmpUtils.getString("Error: OID not a leaf node."));
        errString.put(new Integer(32), SnmpUtils.getString("Error: Error creating variable."));
        errString.put(new Integer(33), SnmpUtils.getString("Error: Illegal Argument(s)"));
        errString.put(new Integer(34), SnmpUtils.getString("Error: Invalid generic type for trap"));
        errString.put(new Integer(35), SnmpUtils.getString("Error: IP address Not specified."));
        errString.put(new Integer(36), SnmpUtils.getString("Error: Session Remote Host Unknown."));
        errString.put(new Integer(37), SnmpUtils.getString("Error: Security Exception connecting to remote host"));
        errString.put(new Integer(38), SnmpUtils.getString("Error: IO Error"));
        errString.put(new Integer(39), SnmpUtils.getString("Error: Invalid Table OID"));
        errString.put(new Integer(40), SnmpUtils.getString("Error: External Index for table not found"));
        errString.put(new Integer(43), SnmpUtils.getString("Unknown Error"));
        errString.put(new Integer(50), SnmpUtils.getString("SNMP ASN1Error encountered due to Illegal SNMP packet received"));
        errString.put(new Integer(128), SnmpUtils.getString("There is no such object in this MIB."));
        errString.put(new Integer(129), SnmpUtils.getString("There is no such instance in this MIB."));
        errString.put(new Integer(130), SnmpUtils.getString("This is a end of Mib View."));
    }

    static void modifyExistingString(String string, int n) {
    }

    public static void printToFile(String string) {
        File file = new File(string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < errString.size()) {
                stringBuffer.append(String.valueOf(n) + "\t\t" + errString.get(new Integer(n)) + "\n");
                ++n;
            }
            byte[] byArray = stringBuffer.toString().getBytes();
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error writing to: ")) + " " + string + " : " + iOException);
        }
    }
}

