/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.beans;

import com.adventnet.snmp.beans.ObjectIDEditor;
import com.adventnet.snmp.beans.ObjectIDHelper;
import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.utils.FileUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyEditorSupport;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class MibNamesEditor
extends PropertyEditorSupport {
    String mibName = "";
    private static ObjectIDHelper objidHelper = null;
    private static ObjectIDEditor editor = new ObjectIDEditor();
    JTextArea tarea;

    static /* synthetic */ ObjectIDEditor access$0() {
        return editor;
    }

    public Component getCustomEditor() {
        if (objidHelper == null) {
            JPanel jPanel = editor.getBrowserPanel();
            JPanel jPanel2 = new JPanel();
            JButton jButton = new JButton("    OK    ");
            jButton.setActionCommand("ok");
            JButton jButton2 = new JButton("CANCEL");
            jButton2.setActionCommand("cancel");
            jPanel2.add(jButton);
            jPanel2.add(jButton2);
            final JFrame jFrame = new JFrame("MibBrowser");
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add("Center", jPanel);
            jFrame.getContentPane().add("South", jPanel2);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equals("ok")) {
                        String string = "";
                        MibModule[] mibModuleArray = null;
                        try {
                            if (ObjectIDEditor.treeComp.getSelectedModules() != null) {
                                mibModuleArray = ObjectIDEditor.treeComp.getSelectedModules();
                                int n = 0;
                                while (n < mibModuleArray.length) {
                                    String string2;
                                    string = mibModuleArray[n].getFileName();
                                    string.trim();
                                    if (string.endsWith(".cmi") || string.endsWith(".CMI")) {
                                        string = string.substring(0, string.length() - 4);
                                    }
                                    if (string.indexOf(" ") >= 0) {
                                        // empty if block
                                    }
                                    if ((string2 = FileUtils.getRelativePath(System.getProperty("user.dir"), string, null)).indexOf(32) != -1) {
                                        string2 = "\"" + string2 + "\"";
                                    }
                                    mibName = string2.charAt(0) == '\\' ? String.valueOf(mibName) + "." + string2 + " " : String.valueOf(mibName) + string2 + " ";
                                    ++n;
                                }
                                this.setValue(mibName);
                                mibModuleArray = null;
                                mibName = "";
                                ((Component)jFrame).setVisible(false);
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            this.setValue("");
                            ((Component)jFrame).setVisible(false);
                        }
                    } else if (actionEvent.getActionCommand().equals("cancel")) {
                        ((Component)jFrame).setVisible(false);
                    }
                }
            };
            jButton.addActionListener(actionListener);
            jButton2.addActionListener(actionListener);
            WindowAdapter windowAdapter = new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ((Component)jFrame).setVisible(false);
                    jFrame.removeWindowListener(this);
                }
            };
            jFrame.addWindowListener(windowAdapter);
            jFrame.postEvent(new Event(jFrame, 204, "maximize"));
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            return jFrame;
        }
        objidHelper.setCurrentEditor(this);
        return objidHelper.getCustomEditor();
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = null;
        string = (String)this.getValue();
        if (string == null) {
            string = "Click to edit ...";
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, 0, rectangle.height - n);
    }

    public static void setObjectIDHelper(ObjectIDHelper objectIDHelper) {
        objidHelper = objectIDHelper;
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

