/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.beans;

import com.adventnet.snmp.beans.ObjectIDHelper;
import com.adventnet.snmp.ui.MibTreeComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyEditorSupport;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ObjectIDEditor
extends PropertyEditorSupport {
    private static ObjectIDHelper objidHelper = null;
    static MibTreeComponent treeComp = null;
    JPanel browserPanel = null;
    JTextArea tarea;

    JPanel getBrowserPanel() {
        this.browserPanel = null;
        this.browserPanel = new BrowserPanel();
        return this.browserPanel;
    }

    public Component getCustomEditor() {
        if (objidHelper == null) {
            JPanel jPanel = this.getBrowserPanel();
            JPanel jPanel2 = new JPanel();
            JButton jButton = new JButton("   OK   ");
            jButton.setActionCommand("ok");
            JButton jButton2 = new JButton("CANCEL");
            jButton2.setActionCommand("cancel");
            jPanel2.add(jButton);
            jPanel2.add(jButton2);
            final JFrame jFrame = new JFrame("MibBrowser");
            BorderLayout borderLayout = new BorderLayout();
            jFrame.getContentPane().setLayout(borderLayout);
            jFrame.getContentPane().add((Component)jPanel, "Center");
            jFrame.getContentPane().add((Component)jPanel2, "South");
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equals("ok")) {
                        this.setValue(treeComp.getNumericObjectID());
                        ((Component)jFrame).setVisible(false);
                    } else if (actionEvent.getActionCommand().equals("cancel")) {
                        ((Component)jFrame).setVisible(false);
                    }
                }
            };
            jButton.addActionListener(actionListener);
            jButton2.addActionListener(actionListener);
            WindowAdapter windowAdapter = new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ((Component)jFrame).setVisible(false);
                    jFrame.removeWindowListener(this);
                }
            };
            jFrame.addWindowListener(windowAdapter);
            jFrame.postEvent(new Event(jFrame, 204, "maximize"));
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            return jFrame;
        }
        objidHelper.setCurrentEditor(this);
        return objidHelper.getCustomEditor();
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = (String)this.getValue();
        if (string == null) {
            string = "Click to edit ...";
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, 0, rectangle.height - n);
    }

    public static void setObjectIDHelper(ObjectIDHelper objectIDHelper) {
        objidHelper = objectIDHelper;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    class BrowserPanel
    extends JPanel {
        BrowserPanel() {
            this.setLayout(new BorderLayout());
            if (treeComp == null) {
                treeComp = new MibTreeComponent("");
            }
            this.add("Center", treeComp);
            ObjectIDEditor.treeComp.getTree().tree.expandRow(0);
        }
    }
}

