/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.beans;

import com.adventnet.snmp.beans.ObjectIDHelper;
import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.ui.MibTreeComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyEditorSupport;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ObjectIDEditorList
extends PropertyEditorSupport {
    private static ObjectIDHelper objidHelper = null;
    static MibTreeComponent treeComp = null;
    JPanel browserPanel = null;
    DefaultListModel listmodel = null;
    Vector oid = null;
    Vector strtemp = null;
    Vector numtemp = null;

    JPanel getBrowserPanel() {
        this.browserPanel = null;
        this.browserPanel = new BrowserPanel();
        return this.browserPanel;
    }

    public Component getCustomEditor() {
        if (objidHelper == null) {
            JPanel jPanel = this.getBrowserPanel();
            jPanel.setPreferredSize(new Dimension(700, 300));
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel3.setLayout(gridBagLayout);
            JButton jButton = new JButton("ADD");
            jButton.setActionCommand("add");
            final JButton jButton2 = new JButton("DELETE");
            jButton2.setActionCommand("del");
            jButton2.setEnabled(false);
            JButton jButton3 = new JButton("   OK   ");
            jButton3.setActionCommand("ok");
            JButton jButton4 = new JButton("CANCEL");
            jButton4.setActionCommand("cancel");
            if (this.oid == null) {
                this.oid = new Vector();
            }
            if (this.listmodel == null) {
                this.listmodel = new DefaultListModel();
            }
            final JList jList = new JList(this.listmodel);
            JScrollPane jScrollPane = new JScrollPane(jList, 22, 30);
            jPanel2.add(jButton3);
            jPanel2.add(jButton4);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.insets = new Insets(3, 5, 3, 5);
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            jPanel3.add(jScrollPane);
            gridBagConstraints.insets = new Insets(4, 5, 0, 5);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.15;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            jPanel3.add(jButton);
            gridBagConstraints.insets = new Insets(2, 5, 0, 5);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(jButton2, gridBagConstraints);
            jPanel3.add(jButton2);
            jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
            jPanel3.setPreferredSize(new Dimension(700, 100));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)jPanel3, "North");
            jPanel4.add((Component)jPanel2, "South");
            final JFrame jFrame = new JFrame("MibBrowser");
            BorderLayout borderLayout = new BorderLayout();
            jFrame.getContentPane().setLayout(borderLayout);
            jFrame.getContentPane().add((Component)jPanel, "Center");
            jFrame.getContentPane().add((Component)jPanel4, "South");
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equals("add")) {
                        String string = treeComp.getNumericObjectID();
                        String string2 = null;
                        MibOperations mibOperations = new MibOperations();
                        MibModule mibModule = treeComp.getSelectedModule();
                        if (mibModule != null) {
                            try {
                                mibOperations.loadMibModule(mibModule.getFileName());
                            }
                            catch (Exception exception) {
                                System.out.println("ERROR: " + exception);
                            }
                            SnmpOID snmpOID = new SnmpOID(string);
                            String string3 = mibOperations.getInstanceString(snmpOID);
                            if (string3 != null) {
                                String string4 = string.substring(0, string.length() - string3.length());
                                String string5 = mibModule.translateToNames(string4);
                                string2 = String.valueOf(string5) + string3;
                            } else {
                                string2 = string;
                            }
                        } else {
                            string2 = string;
                        }
                        if (string2 != null) {
                            listmodel.addElement(string2);
                            oid.addElement(string);
                        }
                    } else if (actionEvent.getActionCommand().equals("del")) {
                        int n = jList.getSelectedIndex();
                        listmodel.removeElementAt(n);
                        oid.removeElementAt(n);
                        int n2 = listmodel.getSize();
                        if (n != 0) {
                            jList.setSelectedIndex(--n);
                        } else if (n == 0 && n2 != 0) {
                            jList.setSelectedIndex(n2 - 1);
                        }
                        if (n2 == 0) {
                            jButton2.setEnabled(false);
                        }
                    } else if (actionEvent.getActionCommand().equals("ok")) {
                        strtemp = new Vector();
                        numtemp = new Vector();
                        int n = 0;
                        while (n < oid.size()) {
                            strtemp.addElement(listmodel.elementAt(n));
                            numtemp.addElement(oid.elementAt(n));
                            ++n;
                        }
                        int n3 = oid.size();
                        Object[] objectArray = new String[n3];
                        oid.copyInto(objectArray);
                        this.setValue(objectArray);
                        ((Component)jFrame).setVisible(false);
                    } else if (actionEvent.getActionCommand().equals("cancel")) {
                        listmodel.clear();
                        oid.clear();
                        if (strtemp != null) {
                            int n = 0;
                            while (n < strtemp.size()) {
                                listmodel.addElement(strtemp.elementAt(n));
                                oid.addElement(numtemp.elementAt(n));
                                ++n;
                            }
                        }
                        ((Component)jFrame).setVisible(false);
                    }
                }
            };
            jList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    jButton2.setEnabled(true);
                }
            });
            jButton.addActionListener(actionListener);
            jButton2.addActionListener(actionListener);
            jButton3.addActionListener(actionListener);
            jButton4.addActionListener(actionListener);
            WindowAdapter windowAdapter = new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ((Component)jFrame).setVisible(false);
                    jFrame.removeWindowListener(this);
                }
            };
            jFrame.addWindowListener(windowAdapter);
            jFrame.postEvent(new Event(jFrame, 204, "maximize"));
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            return jFrame;
        }
        objidHelper.setCurrentEditor(this);
        return objidHelper.getCustomEditor();
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String[] stringArray = (String[])this.getValue();
        String string = null;
        string = stringArray == null ? "Click to edit ..." : " { ... }";
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, 0, rectangle.height - n);
    }

    public static void setObjectIDHelper(ObjectIDHelper objectIDHelper) {
        objidHelper = objectIDHelper;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    class BrowserPanel
    extends JPanel {
        BrowserPanel() {
            this.setLayout(new BorderLayout());
            if (treeComp == null) {
                treeComp = new MibTreeComponent("");
            }
            this.add("Center", treeComp);
            ObjectIDEditorList.treeComp.getTree().tree.expandRow(0);
        }
    }
}

