/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.beans;

import com.adventnet.snmp.beans.TrapEvent;
import com.adventnet.snmp.snmp2.SnmpTimeticks;
import com.adventnet.utils.SnmpUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;

public class ParsedTrapEvent
extends EventObject {
    public int id;
    public String text;
    public String category;
    public String domain;
    public String network;
    public String node;
    public String entity;
    public int severity;
    public String eoid;
    public int specificType;
    public int trapType;
    public int remotePort = 0;
    long time;
    public String source;
    public String helpURL;
    public Date date;
    public String color = "-1";
    public Color rowColor;
    Frame f = null;

    public ParsedTrapEvent(TrapEvent trapEvent) {
        super(trapEvent);
        this.time = trapEvent.getUpTime();
        this.date = new Date();
    }

    void closeWD() {
        if (this.f != null) {
            this.f.setCursor(0);
        }
    }

    public String dateString() {
        return this.dateToStr(this.date);
    }

    String dateToStr(Date date) {
        if (date == null) {
            return "Invalid Date";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String string = String.valueOf(calendar.get(2) + 1) + "/" + calendar.get(5) + "/" + calendar.get(1) + " " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13);
        return string;
    }

    public void decodeObj(byte[] byArray) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        this.id = dataInputStream.readInt();
        this.text = dataInputStream.readUTF();
        if (this.text.equals("")) {
            this.text = "";
        }
        if ((this.category = dataInputStream.readUTF()).equals("")) {
            this.category = null;
        }
        if ((this.domain = dataInputStream.readUTF()).equals("")) {
            this.domain = null;
        }
        if ((this.network = dataInputStream.readUTF()).equals("")) {
            this.network = null;
        }
        if ((this.node = dataInputStream.readUTF()).equals("")) {
            this.node = null;
        }
        if ((this.entity = dataInputStream.readUTF()).equals("")) {
            this.entity = null;
        }
        this.severity = dataInputStream.readInt();
        this.time = dataInputStream.readLong();
        this.source = dataInputStream.readUTF();
        if (this.source.equals("")) {
            this.source = null;
        }
        if ((this.helpURL = dataInputStream.readUTF()).equals("")) {
            this.helpURL = null;
        }
    }

    public byte[] encodeObj() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.id);
            if (this.text != null) {
                dataOutputStream.writeUTF(this.text);
            } else {
                dataOutputStream.writeUTF("");
            }
            if (this.category != null) {
                dataOutputStream.writeUTF(this.category);
            } else {
                dataOutputStream.writeUTF("");
            }
            if (this.domain != null) {
                dataOutputStream.writeUTF(this.domain);
            } else {
                dataOutputStream.writeUTF("");
            }
            if (this.network != null) {
                dataOutputStream.writeUTF(this.network);
            } else {
                dataOutputStream.writeUTF("");
            }
            if (this.node != null) {
                dataOutputStream.writeUTF(this.node);
            } else {
                dataOutputStream.writeUTF("");
            }
            if (this.entity != null) {
                dataOutputStream.writeUTF(this.entity);
            } else {
                dataOutputStream.writeUTF("");
            }
            dataOutputStream.writeInt(this.severity);
            dataOutputStream.writeLong(this.time);
            if (this.source != null) {
                dataOutputStream.writeUTF(this.source);
            } else {
                dataOutputStream.writeUTF("");
            }
            if (this.helpURL != null) {
                dataOutputStream.writeUTF(this.helpURL);
            } else {
                dataOutputStream.writeUTF("");
            }
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf(SnmpUtils.getString("Error encoding EventManager")) + " : " + iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static String fmt(int n) {
        String string = String.valueOf(n);
        if (string.length() < 2) {
            string = "0" + string;
        }
        return string;
    }

    public Color getColor() {
        if (this.color == null) {
            return Color.white;
        }
        int n = Integer.valueOf(this.color);
        Color color = new Color(n);
        return color;
    }

    Frame getFrame(Component component) {
        if (component instanceof Frame) {
            return (Frame)component;
        }
        Container container = component.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public static long getParsedTime(Date date) {
        return date.getTime();
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getStr(String string) {
        String string2 = this.text;
        if (string.equals("category")) {
            string2 = this.category;
        } else if (string.equals("remoteport")) {
            string2 = String.valueOf(this.remotePort);
        } else if (string.equals("text")) {
            string2 = this.text;
        } else if (string.equals("domain")) {
            string2 = this.domain;
        } else if (string.equals("network")) {
            string2 = this.network;
        } else if (string.equals("node")) {
            string2 = this.node;
        } else if (string.equals("entity")) {
            string2 = this.entity;
        } else if (string.equals("source")) {
            string2 = this.source;
        } else if (string.equals("ST")) {
            string2 = String.valueOf(this.specificType);
        } else if (string.equals("GT")) {
            string2 = String.valueOf(this.trapType);
        } else if (string.equals("helpURL")) {
            string2 = this.helpURL;
        } else if (string.equals("enterprise")) {
            string2 = this.eoid;
        } else if (string.equals("severity")) {
            string2 = this.severity == 0 ? "" : ParsedTrapEvent.severityStr(this.severity);
        } else if (string.equals("timeStamp")) {
            string2 = this.date != null ? this.getTimeStamp() : "";
        } else if (string.equals("timeReceived")) {
            string2 = this.date != null ? this.dateString() : "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public String getTimeStamp() {
        return new SnmpTimeticks(this.time).toString();
    }

    public String getTrapSource() {
        return this.source;
    }

    public long getUpTime() {
        return this.time;
    }

    String logStr(String string) {
        if (string == null) {
            return "null";
        }
        if (string.trim().equals("")) {
            return "null";
        }
        int n = -1;
        String string2 = string;
        string = "";
        while ((n = string2.indexOf(":")) != -1) {
            string = String.valueOf(string) + string2.substring(0, n) + "\\:";
            string2 = string2.substring(n + 1);
        }
        string = String.valueOf(string) + string2;
        return string;
    }

    void openWD(Component component) {
        if (this.f == null) {
            this.f = this.getFrame(component);
        }
        if (this.f != null) {
            this.f.setCursor(3);
        }
    }

    public static int severityInt(String string) {
        if (string.equals("") || string.equals("0")) {
            return 0;
        }
        if (string.equals("All") || string.equals("1")) {
            return 1;
        }
        if (string.equals("Critical") || string.equals("2")) {
            return 2;
        }
        if (string.equals("Major") || string.equals("3")) {
            return 3;
        }
        if (string.equals("Minor") || string.equals("4")) {
            return 4;
        }
        if (string.equals("Warning") || string.equals("5")) {
            return 5;
        }
        if (string.equals("Clear") || string.equals("6")) {
            return 6;
        }
        return 7;
    }

    public String severityStr() {
        return ParsedTrapEvent.severityStr(this.severity);
    }

    public static String severityStr(int n) {
        if (n == 0) {
            return new String("");
        }
        if (n == 1) {
            return "All";
        }
        if (n == 2) {
            return "Critical";
        }
        if (n == 3) {
            return "Major";
        }
        if (n == 4) {
            return "Minor";
        }
        if (n == 5) {
            return "Warning";
        }
        if (n == 6) {
            return "Clear";
        }
        return "Info";
    }

    public String toLogString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(":" + this.id);
        stringBuffer.append(":" + this.severity);
        stringBuffer.append(":" + this.time);
        stringBuffer.append(":" + this.logStr(this.source));
        stringBuffer.append(":" + this.logStr(this.helpURL));
        stringBuffer.append(":" + this.logStr(this.category));
        stringBuffer.append(":" + this.logStr(this.domain));
        stringBuffer.append(":" + this.logStr(this.network));
        stringBuffer.append(":" + this.logStr(this.node));
        stringBuffer.append(":" + this.logStr(this.entity));
        stringBuffer.append(":" + this.logStr(this.text) + "\n");
        return stringBuffer.toString();
    }

    public String toString() {
        return new String(this.text);
    }
}

