/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.beans;

import com.adventnet.snmp.beans.DataException;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.snmp.snmp2.SnmpVarBind;
import com.adventnet.utils.SnmpUtils;
import java.util.EventObject;
import java.util.Vector;

public class ResultEvent
extends EventObject {
    MibOperations mibOps = null;
    int failedreqid = -1;
    Object response;
    String error;

    public ResultEvent(Object object) {
        super(object);
    }

    public ResultEvent(Object object, Object object2) {
        super(object);
        this.response = object2;
    }

    public ResultEvent(Object object, Object object2, MibOperations mibOperations) {
        super(object);
        this.response = object2;
        this.mibOps = mibOperations;
    }

    public ResultEvent(Object object, Object object2, String string) {
        super(object);
        this.response = object2;
        this.error = string;
    }

    public ResultEvent(Object object, Object object2, String string, int n) {
        super(object);
        this.response = object2;
        this.error = string;
        this.failedreqid = n;
    }

    public ResultEvent(Object object, Object object2, String string, MibOperations mibOperations) {
        super(object);
        this.response = object2;
        this.error = string;
        this.mibOps = mibOperations;
    }

    public String getErrorString() {
        return this.error;
    }

    public int getFailedRequestID() {
        if (this.response == null) {
            return this.failedreqid;
        }
        return -1;
    }

    public long getNumericValue() throws DataException {
        return this.getNumericValue(0);
    }

    public long getNumericValue(int n) throws DataException {
        if (this.response == null || !(this.response instanceof SnmpPDU)) {
            throw new DataException(SnmpUtils.getString("Error: Agent Returned Empty Data"));
        }
        Vector vector = ((SnmpPDU)this.response).getVariableBindings();
        if (vector == null) {
            throw new DataException(SnmpUtils.getString("Error: Agent Returned Empty Varbind(s)"));
        }
        if (vector.size() < n + 1) {
            throw new DataException(SnmpUtils.getString("VariableBindings Index out of Range"));
        }
        if (((SnmpVarBind)vector.elementAt(n)).getVariable() == null) {
            throw new DataException(SnmpUtils.getString("Error:Agent Returned Empty Variable"));
        }
        Object object = ((SnmpVarBind)vector.elementAt(n)).getVariable().toValue();
        if (object == null) {
            throw new DataException(SnmpUtils.getString("Error: Agent Returned Empty Data"));
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        throw new DataException(SnmpUtils.getString("Error: Agent Returned a Non-Numeric Value"));
    }

    public long[] getNumericValues() throws DataException {
        if (this.response == null || !(this.response instanceof SnmpPDU)) {
            throw new DataException(SnmpUtils.getString("Error: Agent Returned Empty Data"));
        }
        SnmpPDU snmpPDU = (SnmpPDU)this.response;
        if (snmpPDU.getVariableBindings() == null || snmpPDU.getVariableBindings().size() <= 0) {
            throw new DataException(SnmpUtils.getString("Error: Agent Returned Empty Varbind(s"));
        }
        long[] lArray = new long[snmpPDU.getVariableBindings().size()];
        int n = 0;
        while (n < lArray.length) {
            if (snmpPDU.getVariable(n) != null) {
                Object object = snmpPDU.getVariable(n).toValue();
                lArray[n] = object == null ? -1L : (object instanceof Integer ? (long)((Integer)object).intValue() : (object instanceof Long ? (Long)object : -1L));
            }
            ++n;
        }
        return lArray;
    }

    public int getRequestID() {
        if (this.response instanceof SnmpPDU) {
            SnmpPDU snmpPDU = (SnmpPDU)this.response;
            return snmpPDU.getReqid();
        }
        return -1;
    }

    public Object getResponse() {
        return this.response;
    }

    public String getStringValue() throws DataException {
        return this.getStringValue(0);
    }

    public String getStringValue(int n) throws DataException {
        if (this.response == null || !(this.response instanceof SnmpPDU)) {
            throw new DataException(SnmpUtils.getString("Error: Agent Returned Empty Data"));
        }
        Vector vector = ((SnmpPDU)this.response).getVariableBindings();
        if (vector == null) {
            throw new DataException(SnmpUtils.getString("Error: Agent Returned Empty Varbind(s)"));
        }
        if (vector.size() < n + 1) {
            throw new DataException(SnmpUtils.getString("VariableBindings Index out of Range"));
        }
        if (((SnmpVarBind)vector.elementAt(n)).getVariable() == null) {
            throw new DataException(SnmpUtils.getString("Error:Agent Returned Empty Variable"));
        }
        if (this.mibOps != null) {
            return this.mibOps.toString((SnmpVarBind)vector.elementAt(n));
        }
        return ((SnmpVarBind)vector.elementAt(n)).getVariable().toString();
    }

    public String[] getStringValues() throws DataException {
        if (this.response == null || !(this.response instanceof SnmpPDU)) {
            throw new DataException(SnmpUtils.getString("Error: Agent Returned Empty Data"));
        }
        SnmpPDU snmpPDU = (SnmpPDU)this.response;
        if (snmpPDU.getVariableBindings() == null || snmpPDU.getVariableBindings().size() <= 0) {
            throw new DataException(SnmpUtils.getString("Error: Agent Returned Empty Varbind(s)"));
        }
        String[] stringArray = new String[snmpPDU.getVariableBindings().size()];
        int n = 0;
        while (n < stringArray.length) {
            SnmpVar snmpVar = snmpPDU.getVariable(n);
            stringArray[n] = snmpVar == null ? null : snmpVar.toString();
            ++n;
        }
        return stringArray;
    }

    public String getValue(int n) throws DataException {
        if (this.response == null || !(this.response instanceof SnmpPDU)) {
            throw new DataException(SnmpUtils.getString("Error: Agent Returned Empty Data"));
        }
        Vector vector = ((SnmpPDU)this.response).getVariableBindings();
        if (vector == null) {
            throw new DataException(SnmpUtils.getString("Error: Agent Returned Empty Varbind(s)"));
        }
        if (vector.size() < n + 1) {
            throw new DataException(SnmpUtils.getString("VariableBindings Index out of Range"));
        }
        if (((SnmpVarBind)vector.elementAt(n)).getVariable() == null) {
            throw new DataException(SnmpUtils.getString("Error:Agent Returned Empty Variable"));
        }
        return ((SnmpVarBind)vector.elementAt(n)).getVariable().toString();
    }

    public String[] getValues() throws DataException {
        return this.getStringValues();
    }

    public boolean isSuccess() {
        return this.error == null;
    }
}

