/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.beans;

import com.adventnet.snmp.beans.ResultEvent;
import com.adventnet.snmp.beans.ResultListener;
import com.adventnet.snmp.beans.SnmpTarget;
import com.adventnet.snmp.snmp2.ProtocolOptions;
import com.adventnet.snmp.snmp2.SnmpCounter;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.snmp.snmp2.SnmpVarBind;
import com.adventnet.utils.Scheduler;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.util.Date;
import java.util.Enumeration;

public class SnmpPoller
extends SnmpTarget
implements Runnable {
    private static Scheduler sch = null;
    boolean pollingStopped = false;
    boolean pollingPaused = false;
    boolean isAutoActive = true;
    boolean absoluteCounters = false;
    long lastCounterValue = -1L;

    public SnmpPoller() {
        this.initScheduler(null);
    }

    public SnmpPoller(int n, ProtocolOptions protocolOptions) {
        super(n, protocolOptions);
        this.initScheduler(null);
    }

    public SnmpPoller(Applet applet) {
        super(applet);
        this.initScheduler(applet);
    }

    public void addResultListener(ResultListener resultListener) {
        super.addResultListener(resultListener);
        if (this.listeners.size() == 1 && this.isAutoActive) {
            this.restartPolling();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void genEvent(SnmpPDU snmpPDU) {
        Object object = null;
        String string = null;
        SnmpVar snmpVar = null;
        SnmpOID snmpOID = null;
        if (this.listeners.size() == 0) {
            return;
        }
        if (snmpPDU == null) {
            return;
        }
        SnmpVarBind snmpVarBind = snmpPDU.getVariableBinding(0);
        if (snmpVarBind != null && snmpVarBind.getVariable() != null) {
            snmpVar = snmpVarBind.getVariable();
            object = snmpVar.toValue();
            snmpOID = snmpVarBind.getObjectID();
        }
        long l = this.lastCounterValue;
        long l2 = 0L;
        if (object instanceof Long) {
            l2 = (Long)object;
            if (snmpPDU.getVariable(0) instanceof SnmpCounter) {
                this.lastCounterValue = l2;
                if (l == -1L) {
                    return;
                }
                if (!this.absoluteCounters) {
                    l2 -= l;
                }
            }
        }
        ResultEvent resultEvent = new ResultEvent(this, snmpPDU);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ResultListener resultListener = (ResultListener)enumeration.nextElement();
            resultListener.setResult(resultEvent);
            if (snmpPDU.getVariableBindings().size() != 1 || object == null) continue;
            if (object instanceof Integer) {
                resultListener.setNumericResult(((Integer)object).intValue());
                continue;
            }
            if (object instanceof Long) {
                resultListener.setNumericResult(l2);
                continue;
            }
            string = this.mibOps.toString(snmpVar, snmpOID);
            resultListener.setStringResult(string);
        }
    }

    public boolean getAbsoluteCounters() {
        return this.absoluteCounters;
    }

    public int getPollInterval() {
        return this.pollInterval / 1000;
    }

    public boolean getPollingStatus() {
        if (this.pollingStopped) {
            return false;
        }
        return this.pollingPaused ^ true;
    }

    private void initScheduler(Applet applet) {
        if (sch == null || !sch.isAlive()) {
            sch = applet == null ? Scheduler.createScheduler("superpoller") : Scheduler.createScheduler(applet, "superpoller");
            sch.start();
        }
        sch.scheduleTask(this, new Date());
    }

    public boolean isAutoActive() {
        return this.isAutoActive;
    }

    public void pausePolling() {
        this.pollingPaused = true;
    }

    private void performTask() {
        if (this.oidList != null) {
            this.snmpGetList();
        }
        if (this.pollInterval < 1) {
            return;
        }
        sch.removeTask(this);
        sch.scheduleTask(this, new Date(System.currentTimeMillis() + (long)this.pollInterval));
    }

    public void removeResultListener(ResultListener resultListener) {
        super.removeResultListener(resultListener);
        if (this.listeners.size() == 0) {
            this.stopPolling();
        }
    }

    public void restartPolling() {
        this.pollingStopped = false;
        this.pollingPaused = false;
        this.setAutoActive(true);
        sch.removeTask(this);
        sch.scheduleTask(this, new Date());
    }

    public void run() {
        try {
            if (!this.isAutoActive) {
                return;
            }
            if (this.pollingStopped) {
                return;
            }
            if (!this.pollingPaused) {
                if (this.protocol == 1) {
                    if (this.targetHost != null && !this.targetHost.trim().equals("")) {
                        this.performTask();
                    }
                } else if (this.options != null) {
                    this.performTask();
                }
            }
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(SnmpUtils.getString("Error in SnmpPoller Bean : ")) + " " + exception);
            exception.printStackTrace();
        }
    }

    public void setAbsoluteCounters(boolean bl) {
        this.absoluteCounters = bl;
    }

    public void setAutoActive(boolean bl) {
        this.isAutoActive = bl;
    }

    public void setPollInterval(int n) {
        if (this.pollInterval < 1 && n > 0 && this.isAutoActive) {
            this.restartPolling();
        }
        this.pollInterval = n * 1000;
    }

    public void stopPolling() {
        this.pollingStopped = true;
        sch.removeTask(this);
    }
}

