/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.beans;

import com.adventnet.snmp.beans.DataException;
import com.adventnet.snmp.beans.ErrorMessages;
import com.adventnet.snmp.beans.RequestEvent;
import com.adventnet.snmp.beans.RequestListener;
import com.adventnet.snmp.beans.ResultEvent;
import com.adventnet.snmp.beans.ResultListener;
import com.adventnet.snmp.beans.SnmpPropertyChangeEvent;
import com.adventnet.snmp.beans.SnmpPropertyListener;
import com.adventnet.snmp.beans.SnmpServer;
import com.adventnet.snmp.mibs.MibException;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.snmp2.ProtocolOptions;
import com.adventnet.snmp.snmp2.SnmpClient;
import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.snmp2.SnmpSession;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.snmp.snmp2.SnmpVarBind;
import com.adventnet.utils.LogInterface;
import com.adventnet.utils.LogManager;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;

public class SnmpRequestServer
extends SnmpServer
implements RequestListener,
SnmpClient,
VetoableChangeListener {
    int logID = 0;
    String mibModules = "";
    int[] prevoid = null;
    Hashtable requests = new Hashtable();
    Hashtable destinations = new Hashtable();

    public SnmpRequestServer() {
    }

    public SnmpRequestServer(int n, ProtocolOptions protocolOptions) {
        super(n, protocolOptions);
    }

    public SnmpRequestServer(int n, String string) {
        super(n, string);
    }

    public SnmpRequestServer(Applet applet) {
        super(applet);
    }

    public SnmpRequestServer(Applet applet, int n, String string) {
        super(applet, n, string);
    }

    public void addLogClient(LogInterface logInterface) {
        this.logID = LogManager.addLogClient(logInterface);
    }

    public int addObjectID(String string) {
        if (this.oidList == null) {
            this.oidList = new SnmpOID[1];
            this.oidList[0] = this.mibOps.getSnmpOID(string);
        } else {
            SnmpOID[] snmpOIDArray = this.oidList;
            this.oidList = new SnmpOID[snmpOIDArray.length + 1];
            System.arraycopy(snmpOIDArray, 0, this.oidList, 0, snmpOIDArray.length);
            this.oidList[snmpOIDArray.length] = this.mibOps.getSnmpOID(string);
        }
        return this.oidList.length - 1;
    }

    public int addRequest(RequestEvent requestEvent) {
        int n = -1;
        this.reqid = requestEvent.reqid;
        try {
            if (requestEvent.objectNames != null) {
                this.setObjectIDList(requestEvent.objectNames);
            }
            if (requestEvent.requestType == -96) {
                n = this.sendGetRequestList();
            }
            if (requestEvent.requestType == -95) {
                n = this.sendGetNextRequestList();
            }
            if (requestEvent.requestType == -93) {
                n = requestEvent.vars != null ? this.sendSetRequestVariables(requestEvent.vars) : this.sendSetRequestList(requestEvent.values);
            }
            if (requestEvent.dest != null && n != -1) {
                this.destinations.put(String.valueOf(n), requestEvent.dest);
            }
        }
        catch (DataException dataException) {
            System.err.println(String.valueOf(SnmpUtils.getString("Request failed: ")) + " " + dataException);
        }
        return n;
    }

    public void addResultListener(ResultListener resultListener) {
        this.listeners.addElement(resultListener);
        if (!(this.listeners.size() != 1 || this.session == null || this.session.getSnmpClients() != null && this.session.getSnmpClients().contains(this))) {
            this.clientID = this.session.addSnmpClientWithID(this);
            this.session.setCallbackthread(true);
        }
    }

    public int addSnmpOID(SnmpOID snmpOID) {
        if (this.oidList == null) {
            this.oidList = new SnmpOID[1];
            this.oidList[0] = snmpOID;
        } else {
            SnmpOID[] snmpOIDArray = this.oidList;
            this.oidList = new SnmpOID[snmpOIDArray.length + 1];
            System.arraycopy(snmpOIDArray, 0, this.oidList, 0, snmpOIDArray.length);
            this.oidList[snmpOIDArray.length] = snmpOID;
        }
        return this.oidList.length - 1;
    }

    public void addSnmpPropertyListener(SnmpPropertyListener snmpPropertyListener) {
        this.propertylisteners.addElement(snmpPropertyListener);
    }

    public boolean authenticate(SnmpPDU snmpPDU, String string) {
        return true;
    }

    public boolean callback(SnmpSession snmpSession, SnmpPDU snmpPDU, int n) {
        String string;
        SnmpPDU snmpPDU2 = (SnmpPDU)this.requests.get(String.valueOf(n));
        boolean bl = false;
        if (snmpPDU2 == null) {
            return false;
        }
        InetAddress inetAddress = snmpPDU2.getAddress();
        if (!(inetAddress == null || (string = inetAddress.getHostAddress()).endsWith("255") || (string.startsWith("1") || string.startsWith("0")) && string.endsWith("0"))) {
            this.requests.remove(String.valueOf(n));
            bl = true;
        }
        if (snmpPDU != null) {
            this.genEvent(snmpPDU);
        } else {
            if (!bl) {
                this.requests.remove(String.valueOf(n));
            }
            this.errorCode = 22;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            this.genTimeoutEvent(snmpPDU2);
        }
        return true;
    }

    public void debugPrint(String string) {
        if (this.logID != 0) {
            LogManager.logMessage(string, this.logID);
        } else {
            System.err.println(string);
        }
    }

    protected void genEvent(SnmpPDU snmpPDU) {
        Serializable serializable;
        ResultListener resultListener = (ResultListener)this.destinations.get(String.valueOf(snmpPDU.getReqid()));
        if (resultListener == null) {
            super.genEvent(snmpPDU);
            return;
        }
        Object object = null;
        SnmpVar snmpVar = null;
        SnmpOID snmpOID = null;
        String string = null;
        if (this.listeners.size() == 0) {
            return;
        }
        if (snmpPDU != null && (serializable = snmpPDU.getVariableBinding(0)) != null && ((SnmpVarBind)serializable).getVariable() != null) {
            snmpVar = ((SnmpVarBind)serializable).getVariable();
            object = snmpVar.toValue();
            snmpOID = ((SnmpVarBind)serializable).getObjectID();
        }
        serializable = new ResultEvent(this, snmpPDU);
        resultListener.setResult((ResultEvent)serializable);
        if (object != null) {
            if (object instanceof Integer) {
                resultListener.setNumericResult(((Integer)object).intValue());
            } else if (object instanceof Long) {
                resultListener.setNumericResult((int)((Long)object).longValue());
            } else {
                string = this.mibOps.toString(snmpVar, snmpOID);
                resultListener.setStringResult(string);
            }
        }
    }

    protected void genTimeoutEvent(SnmpPDU snmpPDU) {
        ResultListener resultListener = (ResultListener)this.destinations.get(String.valueOf(snmpPDU.getReqid()));
        if (resultListener == null) {
            super.genTimeoutEvent(snmpPDU);
            return;
        }
        if (!this.sendTimeoutEvents) {
            return;
        }
        if (this.error == null) {
            this.errorCode = 22;
            this.error = ErrorMessages.getErrorString(this.errorCode);
        }
        ResultEvent resultEvent = new ResultEvent((Object)this, (Object)snmpPDU, this.error);
        resultListener.setResult(resultEvent);
    }

    public boolean getAttemptPartial() {
        return this.attemptPartialData;
    }

    public String getCommunity() {
        return this.community;
    }

    public boolean getDebug() {
        return this.api.getDebug();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorResultString(SnmpPDU snmpPDU) {
        this.error = null;
        if (snmpPDU.getCommand() != -94) {
            this.errorCode = 22;
            this.error = String.valueOf(ErrorMessages.getErrorString(this.errorCode)) + " " + SnmpUtils.getString("to") + " " + snmpPDU.getRemoteHost();
            return this.error;
        }
        if (snmpPDU == null) {
            this.errorCode = 22;
            this.error = String.valueOf(ErrorMessages.getErrorString(this.errorCode)) + " " + SnmpUtils.getString("to") + " " + this.targetHost;
            return this.error;
        }
        this.error = String.valueOf(this.getPDUCommand(snmpPDU.getCommand())) + " " + SnmpUtils.getString("PDU received from ") + " " + snmpPDU.getRemoteHost();
        if (snmpPDU.getVersion() == 0) {
            if (snmpPDU.getErrstat() != 0) {
                this.errorCode = snmpPDU.getErrstat();
                this.error = String.valueOf(this.error) + "\n" + SnmpUtils.getString("Error Indication in response:") + " " + ErrorMessages.getErrorString(this.errorCode) + "\n" + SnmpUtils.getString("Errindex:") + " " + snmpPDU.getErrindex();
                return this.error;
            }
        } else {
            this.errorCode = 20;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            return this.error;
        }
        return null;
    }

    public String getErrorString() {
        return this.error;
    }

    public String getMibModules() {
        String string = new String();
        Enumeration enumeration = this.getMibOperations().getMibModuleNames();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + " " + enumeration.nextElement();
        }
        return string;
    }

    public MibOperations getMibOperations() {
        return this.mibOps;
    }

    public String getObjectID() {
        if (this.oidList == null) {
            System.out.println(SnmpUtils.getString("Error : OID not specified"));
            return "";
        }
        if (this.isName) {
            return this.mibOps.toString(this.oidList[0]);
        }
        return this.oidList[0].toString();
    }

    public String getObjectID(int n) {
        if (this.oidList == null) {
            System.out.println(SnmpUtils.getString("Error : OID not specified"));
            return null;
        }
        if (n > this.oidList.length) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error : No OID set in the index ")) + " " + n);
            return null;
        }
        return this.mibOps.toString(this.oidList[n]);
    }

    public String[] getObjectIDList() {
        if (this.oidList == null) {
            System.out.println(SnmpUtils.getString("Error : OID not specified"));
            return null;
        }
        String[] stringArray = new String[this.oidList.length];
        int n = 0;
        while (n < this.oidList.length) {
            stringArray[n] = this.mibOps.toString(this.oidList[n]);
            ++n;
        }
        return stringArray;
    }

    private String getPDUCommand(byte by) {
        String string = "";
        switch (by) {
            case -96: {
                string = "Get Request";
                break;
            }
            case -95: {
                string = "GetNext Request";
                break;
            }
            case -94: {
                string = "Get Response";
                break;
            }
            case -93: {
                string = "Set Request";
                break;
            }
            case -92: {
                string = "v1 Trap Request";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public int getRetries() {
        return this.retries;
    }

    public boolean getSendTimeoutEvents() {
        return this.sendTimeoutEvents;
    }

    public SnmpOID getSnmpOID() {
        if (this.oidList == null) {
            System.out.println(SnmpUtils.getString("Error : OID not specified"));
            return null;
        }
        return this.oidList[0];
    }

    public SnmpOID[] getSnmpOIDList() {
        if (this.oidList == null) {
            System.out.println(SnmpUtils.getString("Error : OID not specified"));
            return null;
        }
        return this.oidList;
    }

    public String getTargetHost() {
        return this.targetHost;
    }

    public int getTargetPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout / 1000;
    }

    public String getWriteCommunity() {
        return this.writeCommunity;
    }

    public void loadMibs(String string) throws MibException, IOException, FileNotFoundException {
        super.loadMibs(string);
    }

    public void removeResultListener(ResultListener resultListener) {
        this.listeners.removeElement(resultListener);
        if (this.listeners.size() == 0 && this.session != null) {
            this.session.removeSnmpClientWithID(this.clientID);
        }
    }

    public void removeSnmpPropertyListener(SnmpPropertyListener snmpPropertyListener) {
        this.propertylisteners.removeElement(snmpPropertyListener);
    }

    public int sendGetNextRequest() {
        if (this.oidList != null && this.oidList.length > 0) {
            return this.sendSNMPRequest((byte)-95);
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return -1;
    }

    public int sendGetNextRequest(SnmpOID snmpOID) {
        if (snmpOID != null) {
            SnmpOID[] snmpOIDArray = new SnmpOID[]{snmpOID};
            return this.sendSNMPRequest(snmpOIDArray, null, (byte)-95);
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return -1;
    }

    public int sendGetNextRequestList() {
        if (this.oidList != null && this.oidList.length > 0) {
            return this.sendSNMPRequest((byte)-95);
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return -1;
    }

    public int sendGetNextRequestList(SnmpOID[] snmpOIDArray) {
        if (snmpOIDArray != null && snmpOIDArray.length > 0) {
            return this.sendSNMPRequest(snmpOIDArray, null, (byte)-95);
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return -1;
    }

    public int sendGetRequest() {
        if (this.oidList != null && this.oidList.length > 0) {
            return this.sendSNMPRequest((byte)-96);
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return -1;
    }

    public int sendGetRequest(SnmpOID snmpOID) {
        if (snmpOID != null) {
            SnmpOID[] snmpOIDArray = new SnmpOID[]{snmpOID};
            return this.sendSNMPRequest(snmpOIDArray, null, (byte)-96);
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return -1;
    }

    public int sendGetRequestList() {
        if (this.oidList != null && this.oidList.length > 0) {
            return this.sendSNMPRequest((byte)-96);
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return -1;
    }

    public int sendGetRequestList(SnmpOID[] snmpOIDArray) {
        if (snmpOIDArray != null && snmpOIDArray.length > 0) {
            return this.sendSNMPRequest(snmpOIDArray, null, (byte)-96);
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return -1;
    }

    int sendSNMPRequest(SnmpPDU snmpPDU) {
        int n = -1;
        Hashtable hashtable = this.requests;
        synchronized (hashtable) {
            n = super.sendSNMPRequest(snmpPDU);
            if (n != -1) {
                this.requests.put(String.valueOf(n), snmpPDU);
            }
        }
        return n;
    }

    public int sendSetRequest(String string) throws DataException {
        if (this.oidList == null || this.oidList[0] == null) {
            this.errorCode = 21;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            throw new DataException(SnmpUtils.getString("Error : OID not specified"));
        }
        MibNode mibNode = this.mibOps.getMibNode(this.oidList[0]);
        if (mibNode == null) {
            this.errorCode = 30;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            throw new DataException(SnmpUtils.getString("Error : MIB node unavailable for OID."));
        }
        if (mibNode.getSyntax() == null) {
            this.errorCode = 31;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            throw new DataException(SnmpUtils.getString("Error : OID not a leaf node."));
        }
        try {
            SnmpVar snmpVar = mibNode.getSyntax().createVariable(string);
            return this.sendSetRequestVariable(snmpVar);
        }
        catch (SnmpException snmpException) {
            this.errorCode = 32;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            throw new DataException(SnmpUtils.getString("Error : Creating variable."));
        }
    }

    public int sendSetRequest(String string, byte by) throws DataException {
        try {
            return this.sendSetRequestVariable(SnmpVar.createVariable(string, by));
        }
        catch (SnmpException snmpException) {
            this.errorCode = 32;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            throw new DataException(SnmpUtils.getString("Error : Creating variable."));
        }
    }

    public int sendSetRequestList(String[] stringArray) throws DataException {
        if (stringArray == null) {
            this.errorCode = 33;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            throw new DataException(SnmpUtils.getString("Error : Illegal Argument(s)"));
        }
        SnmpVar[] snmpVarArray = new SnmpVar[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            if (this.oidList == null || this.oidList[n] == null) {
                this.errorCode = 21;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                throw new DataException(SnmpUtils.getString("Error : OID not specified."));
            }
            MibNode mibNode = this.mibOps.getMibNode(this.oidList[n]);
            if (mibNode == null) {
                this.errorCode = 30;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                throw new DataException(String.valueOf(SnmpUtils.getString("Error : MIB node unavailable for OID.")) + this.oidList[n]);
            }
            if (mibNode.getSyntax() == null) {
                this.errorCode = 31;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                throw new DataException(String.valueOf(SnmpUtils.getString("Error : OID not a leaf node.")) + this.oidList[n]);
            }
            try {
                SnmpVar snmpVar;
                snmpVarArray[n] = snmpVar = mibNode.getSyntax().createVariable(stringArray[n]);
            }
            catch (SnmpException snmpException) {
                this.errorCode = 32;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                throw new DataException(SnmpUtils.getString("Error : Creating variable."));
            }
            ++n;
        }
        return this.sendSetRequestVariables(snmpVarArray);
    }

    public int sendSetRequestVariable(SnmpVar snmpVar) throws DataException {
        if (this.oidList != null && this.oidList.length > 0) {
            if (this.varList == null) {
                this.varList = new SnmpVar[1];
            }
            this.varList[0] = snmpVar;
            return this.sendSNMPRequest((byte)-93);
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return -1;
    }

    public int sendSetRequestVariables(SnmpVar[] snmpVarArray) throws DataException {
        this.varList = snmpVarArray;
        if (this.oidList != null && this.oidList.length > 0) {
            return this.sendSNMPRequest((byte)-93);
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return -1;
    }

    public void sendTrap(SnmpOID snmpOID, String string, int n, int n2, long l, SnmpVar[] snmpVarArray) throws DataException {
        SnmpPDU snmpPDU = new SnmpPDU();
        snmpPDU.setCommand((byte)-92);
        snmpPDU.setEnterprise(snmpOID);
        try {
            snmpPDU.setAgentAddress(InetAddress.getByName(string));
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(SnmpUtils.getString("Cannot set agent address in trap. ")) + " " + exception);
        }
        snmpPDU.setTrapType(n);
        snmpPDU.setSpecificType(n2);
        snmpPDU.setUpTime(l);
        if (this.oidList != null && this.oidList.length > 0 && snmpVarArray != null && snmpVarArray.length > 0) {
            int n3 = 0;
            while (n3 < this.oidList.length) {
                if (snmpVarArray.length <= n3) break;
                snmpPDU.addNull(this.oidList[n3]);
                snmpPDU.setVariable(n3, snmpVarArray[n3]);
                ++n3;
            }
        }
        this.sendSNMPRequest(snmpPDU);
    }

    public void sendTrap(String string, String string2, int n, int n2, long l, String[] stringArray) throws DataException {
        SnmpVar[] snmpVarArray = null;
        if (stringArray != null) {
            snmpVarArray = new SnmpVar[stringArray.length];
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (this.oidList == null || this.oidList[n3] == null) {
                    this.errorCode = 21;
                    this.error = ErrorMessages.getErrorString(this.errorCode);
                    throw new DataException(SnmpUtils.getString("Error : OID not specified."));
                }
                MibNode mibNode = this.mibOps.getMibNode(this.oidList[n3]);
                if (mibNode == null) {
                    this.errorCode = 30;
                    this.error = ErrorMessages.getErrorString(this.errorCode);
                    throw new DataException(String.valueOf(SnmpUtils.getString("Error : MIB node unavailable for OID.")) + this.oidList[n3]);
                }
                if (mibNode.getSyntax() == null) {
                    this.errorCode = 31;
                    this.error = ErrorMessages.getErrorString(this.errorCode);
                    throw new DataException(String.valueOf(SnmpUtils.getString("Error : OID not a leaf node.")) + this.oidList[n3]);
                }
                try {
                    SnmpVar snmpVar;
                    snmpVarArray[n3] = snmpVar = mibNode.getSyntax().createVariable(stringArray[n3]);
                }
                catch (SnmpException snmpException) {
                    this.errorCode = 32;
                    this.error = ErrorMessages.getErrorString(this.errorCode);
                    throw new DataException(SnmpUtils.getString("Error : Creating variable."));
                }
                ++n3;
            }
        }
        this.sendTrap(this.mibOps.getSnmpOID(string), string2, n, n2, l, snmpVarArray);
    }

    public void setAttemptPartial(boolean bl) {
        this.attemptPartialData = bl;
    }

    public void setCommunity(String string) {
        if (this.community != null && this.community.equals(string)) {
            return;
        }
        this.community = string;
        SnmpPropertyChangeEvent snmpPropertyChangeEvent = new SnmpPropertyChangeEvent(this, SnmpPropertyChangeEvent.COMMUNITY, this.community);
        Enumeration enumeration = this.propertylisteners.elements();
        while (enumeration.hasMoreElements()) {
            SnmpPropertyListener snmpPropertyListener = (SnmpPropertyListener)enumeration.nextElement();
            snmpPropertyListener.snmpPropertyChanged(snmpPropertyChangeEvent);
        }
    }

    public void setDebug(boolean bl) {
        this.api.setDebug(bl);
    }

    public void setMibModules(String string) {
        this.mibModules = string;
        this.updateMibs();
    }

    public void setObjectID(int n, String string) {
        if (this.oidList != null && n < this.oidList.length) {
            this.oidList[n] = this.mibOps.getSnmpOID(string);
        }
    }

    public void setObjectID(String string) {
        SnmpOID snmpOID = this.mibOps.getSnmpOID(string);
        if (snmpOID != null) {
            this.isName = snmpOID.toString().indexOf(string) == -1;
        }
        if (this.oidList != null && this.oidList.length == 1 && this.oidList[0] != null && this.oidList[0].equals(snmpOID)) {
            return;
        }
        this.oidList = new SnmpOID[1];
        this.oidList[0] = snmpOID;
        SnmpPropertyChangeEvent snmpPropertyChangeEvent = new SnmpPropertyChangeEvent(this, SnmpPropertyChangeEvent.OBJECTID, this.oidList[0]);
        Enumeration enumeration = this.propertylisteners.elements();
        while (enumeration.hasMoreElements()) {
            SnmpPropertyListener snmpPropertyListener = (SnmpPropertyListener)enumeration.nextElement();
            snmpPropertyListener.snmpPropertyChanged(snmpPropertyChangeEvent);
        }
    }

    public void setObjectIDList(String[] stringArray) {
        if (stringArray == null) {
            this.oidList = null;
            return;
        }
        this.oidList = new SnmpOID[stringArray.length];
        int n = 0;
        while (n < this.oidList.length) {
            this.oidList[n] = this.mibOps.getSnmpOID(stringArray[n]);
            ++n;
        }
    }

    public void setParams(String string, String string2, String string3, String string4, String string5) {
        if (string != null) {
            this.setTargetHost(string);
        }
        if (string2 != null) {
            this.setTargetPort(Integer.parseInt(string2));
        }
        if (string3 != null) {
            this.setCommunity(string3);
        }
        if (string4 != null) {
            this.setMibModules(string4);
        }
        if (string5 != null) {
            this.setObjectID(string5);
        }
    }

    public void setParams(String string, String string2, String string3, String string4, String[] stringArray) {
        if (string != null) {
            this.setTargetHost(string);
        }
        if (string2 != null) {
            this.setTargetPort(Integer.parseInt(string2));
        }
        if (string3 != null) {
            this.setCommunity(string3);
        }
        if (string4 != null) {
            this.setMibModules(string4);
        }
        if (stringArray != null) {
            this.setObjectIDList(stringArray);
        }
    }

    public void setRetries(int n) {
        if (this.retries == n) {
            return;
        }
        this.retries = n;
        SnmpPropertyChangeEvent snmpPropertyChangeEvent = new SnmpPropertyChangeEvent(this, SnmpPropertyChangeEvent.RETRIES, new Integer(this.retries));
        Enumeration enumeration = this.propertylisteners.elements();
        while (enumeration.hasMoreElements()) {
            SnmpPropertyListener snmpPropertyListener = (SnmpPropertyListener)enumeration.nextElement();
            snmpPropertyListener.snmpPropertyChanged(snmpPropertyChangeEvent);
        }
    }

    public void setSendTimeoutEvents(boolean bl) {
        this.sendTimeoutEvents = bl;
    }

    public void setSnmpOID(SnmpOID snmpOID) {
        this.oidList = new SnmpOID[1];
        this.oidList[0] = snmpOID;
    }

    public void setSnmpOIDList(SnmpOID[] snmpOIDArray) {
        this.oidList = snmpOIDArray;
    }

    public void setTargetHost(String string) {
        if (this.targetHost != null && this.targetHost.equals(string)) {
            return;
        }
        this.targetHost = string;
        SnmpPropertyChangeEvent snmpPropertyChangeEvent = new SnmpPropertyChangeEvent(this, SnmpPropertyChangeEvent.HOSTNAME, this.targetHost);
        Enumeration enumeration = this.propertylisteners.elements();
        while (enumeration.hasMoreElements()) {
            SnmpPropertyListener snmpPropertyListener = (SnmpPropertyListener)enumeration.nextElement();
            snmpPropertyListener.snmpPropertyChanged(snmpPropertyChangeEvent);
        }
    }

    public void setTargetPort(int n) {
        if (this.port == n) {
            return;
        }
        this.port = n;
        SnmpPropertyChangeEvent snmpPropertyChangeEvent = new SnmpPropertyChangeEvent(this, SnmpPropertyChangeEvent.PORT, new Integer(this.port));
        Enumeration enumeration = this.propertylisteners.elements();
        while (enumeration.hasMoreElements()) {
            SnmpPropertyListener snmpPropertyListener = (SnmpPropertyListener)enumeration.nextElement();
            snmpPropertyListener.snmpPropertyChanged(snmpPropertyChangeEvent);
        }
    }

    public void setTimeout(int n) {
        if (this.timeout == n * 1000) {
            return;
        }
        this.timeout = n * 1000;
        SnmpPropertyChangeEvent snmpPropertyChangeEvent = new SnmpPropertyChangeEvent(this, SnmpPropertyChangeEvent.TIMEOUT, new Integer(n));
        Enumeration enumeration = this.propertylisteners.elements();
        while (enumeration.hasMoreElements()) {
            SnmpPropertyListener snmpPropertyListener = (SnmpPropertyListener)enumeration.nextElement();
            snmpPropertyListener.snmpPropertyChanged(snmpPropertyChangeEvent);
        }
    }

    public void setWriteCommunity(String string) {
        if (this.writeCommunity != null && this.writeCommunity.equals(string)) {
            return;
        }
        this.writeCommunity = string;
        SnmpPropertyChangeEvent snmpPropertyChangeEvent = new SnmpPropertyChangeEvent(this, SnmpPropertyChangeEvent.WRITECOMMUNITY, this.writeCommunity);
        Enumeration enumeration = this.propertylisteners.elements();
        while (enumeration.hasMoreElements()) {
            SnmpPropertyListener snmpPropertyListener = (SnmpPropertyListener)enumeration.nextElement();
            snmpPropertyListener.snmpPropertyChanged(snmpPropertyChangeEvent);
        }
    }

    void updateMibs() {
        try {
            this.loadMibs(this.mibModules);
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(SnmpUtils.getString("MIB loading failed: ")) + " " + exception);
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        String string = (String)propertyChangeEvent.getOldValue();
        Hashtable hashtable = (Hashtable)propertyChangeEvent.getNewValue();
        if (string.equals("OLD INSTANCE")) {
            int n;
            String string2 = (String)hashtable.get("HOST");
            if (!string2.equals("")) {
                this.setTargetHost(string2);
            }
            if ((n = Integer.parseInt((String)hashtable.get("PORT"))) != -999) {
                this.setTargetPort(n);
            }
            if ((n = Integer.parseInt((String)hashtable.get("RETRIES"))) != -999) {
                this.setRetries(n);
            }
            if ((n = Integer.parseInt((String)hashtable.get("TIMEOUT"))) != -999) {
                this.setTimeout(n);
            }
        }
    }
}

