/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.beans;

import com.adventnet.snmp.beans.DataException;
import com.adventnet.snmp.beans.ErrorMessages;
import com.adventnet.snmp.beans.ResultEvent;
import com.adventnet.snmp.beans.ResultListener;
import com.adventnet.snmp.mibs.MibException;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.snmp2.ProtocolOptions;
import com.adventnet.snmp.snmp2.SASClient;
import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.snmp.snmp2.SnmpGroup;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.snmp2.SnmpSession;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.snmp.snmp2.SnmpVarBind;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.io.ByteToCharConverter;

public class SnmpServer
implements Serializable {
    int reqid = 0;
    int clientID = 0;
    int protocol = 1;
    ProtocolOptions options = null;
    static boolean finalize_called = false;
    boolean isSendPDUByGroup = false;
    boolean isNotSet = true;
    int count;
    int sentreqid = 0;
    Hashtable matchtable = null;
    Vector matchServ = null;
    String[] group_oidList = null;
    static Hashtable snmpStore;
    transient Vector targets;
    transient Vector session_port_targets;
    transient Vector session_targets;
    transient Vector port_targets;
    transient Vector nullsession_targets;
    transient Vector pollertargets;
    transient SnmpAPI api = null;
    transient SnmpSession session = null;
    transient SnmpGroup group = null;
    transient MibOperations mibOps;
    Vector propertylisteners = new Vector();
    Vector listeners = new Vector();
    boolean sendTimeoutEvents = false;
    String targetHost = "localhost";
    int port = 161;
    String community = "public";
    String writeCommunity = null;
    public SnmpOID[] oidList = null;
    SnmpVar[] varList = null;
    int timeout = 5000;
    int retries = 0;
    int maxRepetitions = 50;
    int nonRepeaters = 0;
    int MAX_NUM_ROWS = 1000;
    int version = 0;
    boolean isName = false;
    int localPort = 0;
    String sessionName = null;
    int pollInterval = 1000;
    static Applet applet;
    boolean attemptPartialData = false;
    boolean attemptCompleteData = false;
    int varbinds_per_request = 0;
    private boolean isResourcesAllocated = false;
    String error = SnmpUtils.getString("No error");
    int errorCode = -1;
    int errorIndex = 0;
    public static final byte SNMPGET = -96;
    public static final byte SNMPGETNEXT = -95;
    public static final byte SNMPRESPONSE = -94;
    public static final byte SNMPSET = -93;
    public static final byte SNMPTRAP = -92;
    String enc = "ISO8859_1";

    static {
        applet = null;
    }

    SnmpServer() {
        this.initSnmpStore(this);
    }

    SnmpServer(int n, ProtocolOptions protocolOptions) {
        this.protocol = n;
        this.options = protocolOptions;
        this.initSnmpStore(this);
    }

    SnmpServer(int n, String string) {
        this.localPort = n;
        this.sessionName = string;
        this.initSnmpStore(this);
    }

    SnmpServer(Applet applet) {
        SnmpServer.applet = applet;
        this.initSnmpStore(this);
    }

    SnmpServer(Applet applet, int n, String string) {
        SnmpServer.applet = applet;
        this.localPort = n;
        this.sessionName = string;
        this.initSnmpStore(this);
    }

    protected void finalize() throws Throwable {
        finalize_called = true;
        this.releaseResources();
        super.finalize();
        finalize_called = false;
    }

    protected void genEvent(SnmpPDU snmpPDU) {
        Serializable serializable;
        Object object = null;
        String string = null;
        SnmpVar snmpVar = null;
        SnmpOID snmpOID = null;
        if (this.listeners.size() == 0) {
            return;
        }
        if (snmpPDU != null && (serializable = snmpPDU.getVariableBinding(0)) != null && ((SnmpVarBind)serializable).getVariable() != null) {
            snmpVar = ((SnmpVarBind)serializable).getVariable();
            object = snmpVar.toValue();
            snmpOID = ((SnmpVarBind)serializable).getObjectID();
        }
        serializable = null;
        serializable = this.mibOps != null ? new ResultEvent((Object)this, (Object)snmpPDU, this.mibOps) : new ResultEvent(this, snmpPDU);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ResultListener resultListener = (ResultListener)enumeration.nextElement();
            resultListener.setResult((ResultEvent)serializable);
            if (object == null) continue;
            if (object instanceof Integer) {
                resultListener.setNumericResult(((Integer)object).intValue());
                continue;
            }
            if (object instanceof Long) {
                resultListener.setNumericResult((int)((Long)object).longValue());
                continue;
            }
            string = this.mibOps.toString(snmpVar, snmpOID);
            resultListener.setStringResult(string);
        }
    }

    protected void genEvent(SnmpPDU snmpPDU, SnmpServer snmpServer) {
        Serializable serializable;
        Object object = null;
        String string = null;
        SnmpVar snmpVar = null;
        SnmpOID snmpOID = null;
        if (this.listeners.size() == 0) {
            return;
        }
        if (snmpPDU != null && (serializable = snmpPDU.getVariableBinding(0)) != null && ((SnmpVarBind)serializable).getVariable() != null) {
            snmpVar = ((SnmpVarBind)serializable).getVariable();
            object = snmpVar.toValue();
            snmpOID = ((SnmpVarBind)serializable).getObjectID();
        }
        serializable = new ResultEvent(this, snmpPDU);
        Enumeration enumeration = snmpServer.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ResultListener resultListener = (ResultListener)enumeration.nextElement();
            resultListener.setResult((ResultEvent)serializable);
            if (object == null) continue;
            if (object instanceof Integer) {
                resultListener.setNumericResult(((Integer)object).intValue());
                continue;
            }
            if (object instanceof Long) {
                resultListener.setNumericResult((int)((Long)object).longValue());
                continue;
            }
            string = this.mibOps.toString(snmpVar, snmpOID);
            resultListener.setStringResult(string);
        }
    }

    protected void genTimeoutEvent(SnmpPDU snmpPDU) {
        if (!this.sendTimeoutEvents) {
            return;
        }
        if (this.error == null) {
            this.errorCode = 22;
            this.error = ErrorMessages.getErrorString(this.errorCode);
        }
        ResultEvent resultEvent = new ResultEvent((Object)this, (Object)snmpPDU, this.error, this.sentreqid);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ResultListener resultListener = (ResultListener)enumeration.nextElement();
            resultListener.setResult(resultEvent);
        }
    }

    public String getCharacterEncoding() {
        if (this.enc == null) {
            return ByteToCharConverter.getDefault().toString();
        }
        return this.enc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SnmpPDU getCompletePDU(SnmpPDU snmpPDU) {
        Object object;
        SnmpPDU snmpPDU2;
        int n;
        Serializable serializable;
        int n2 = snmpPDU.getVariableBindings().size();
        int n3 = 0;
        boolean bl = false;
        long l = 0L;
        SnmpPDU snmpPDU3 = null;
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n5 = 5;
        if (this.varbinds_per_request != 0) {
            n4 = this.varbinds_per_request;
        } else {
            n4 = n2;
            snmpPDU3 = new SnmpPDU();
            snmpPDU3.setVersion(snmpPDU.getVersion());
            snmpPDU3.setRemoteHost(snmpPDU.getRemoteHost());
            snmpPDU3.setRemotePort(snmpPDU.getRemotePort());
            snmpPDU3.setTimeout(snmpPDU.getTimeout());
            snmpPDU3.setCommunity(snmpPDU.getCommunity());
            snmpPDU3.setCommand((byte)-96);
            snmpPDU3.addNull(new SnmpOID(".1.3.6.1.2.1.11.31.0"));
            serializable = null;
            try {
                snmpPDU3.setClientID(this.clientID);
                serializable = this.session.syncSend(snmpPDU3);
            }
            catch (SnmpException snmpException) {
                return null;
            }
            if (serializable == null) {
                return null;
            }
            int n6 = ((SnmpPDU)serializable).getVersion();
            if (n6 == 0 && ((SnmpPDU)serializable).getErrstat() == 0) {
                bl = true;
                l = (Long)((SnmpPDU)serializable).getVariable(0).toValue();
            }
        }
        serializable = snmpPDU.getVariableBindings();
        Vector<SnmpVarBind> vector = new Vector<SnmpVarBind>();
        while (true) {
            SnmpPDU snmpPDU4 = new SnmpPDU();
            snmpPDU4.setRemoteHost(snmpPDU.getRemoteHost());
            snmpPDU4.setRemotePort(snmpPDU.getRemotePort());
            snmpPDU4.setRetries(snmpPDU.getRetries());
            snmpPDU4.setTimeout(snmpPDU.getTimeout());
            snmpPDU4.setVersion(snmpPDU.getVersion());
            snmpPDU4.setCommunity(snmpPDU.getCommunity());
            snmpPDU4.setCommand(snmpPDU.getCommand());
            snmpPDU4.setReqid(snmpPDU.getReqid());
            snmpPDU4.setErrstat(snmpPDU.getErrstat());
            snmpPDU4.setErrindex(snmpPDU.getErrindex());
            if (bl2) {
                bl2 = false;
                n4 = Math.round((float)n4 / 2.0f);
            }
            if ((n = n3 + n4) > n2) {
                n = n2;
            }
            int n7 = n3;
            while (n7 < n) {
                snmpPDU4.addVariableBinding((SnmpVarBind)((Vector)serializable).elementAt(n7));
                ++n7;
            }
            snmpPDU2 = null;
            try {
                snmpPDU4.setClientID(this.clientID);
                snmpPDU2 = this.session.syncSend(snmpPDU4);
            }
            catch (SnmpException snmpException) {
                if (snmpException.toString().indexOf("Trying to allocate a VERY BIG PDU") < 0) {
                    String string = snmpException.getMessage();
                    this.errorCode = string.equals(SnmpUtils.getString("No remote IP address specified.")) ? 35 : (string.equals(SnmpUtils.getString("Session Remote Host Unknown.")) ? 36 : (string.equals(SnmpUtils.getString("Security Exception connecting to remote host")) ? 37 : 43));
                    this.error = String.valueOf(SnmpUtils.getString("Sending PDU: ")) + " " + string;
                    return null;
                }
                bl2 = true;
                bl3 = true;
                continue;
            }
            if (bl3 && snmpPDU2 == null) {
                bl2 = true;
                continue;
            }
            if (snmpPDU2 == null) {
                int n8;
                if (!bl) return null;
                object = null;
                try {
                    snmpPDU3.setClientID(this.clientID);
                    object = this.session.syncSend(snmpPDU3);
                }
                catch (SnmpException snmpException) {
                    return null;
                }
                if (object == null) return null;
                if (this.varbinds_per_request == 0 && n4 > 5) {
                    this.varbinds_per_request = 5;
                    n4 = 5;
                }
                if ((n8 = ((SnmpPDU)object).getVersion()) != 0) return null;
                if (((SnmpPDU)object).getErrstat() == 0 && l < (Long)snmpPDU3.getVariable(0).toValue()) {
                    continue;
                }
            }
            if ((byte)snmpPDU2.getErrstat() == 1) {
                if (snmpPDU2.getVariableBindings().size() == 1) {
                    object = snmpPDU.copy();
                    ((SnmpPDU)object).setRemoteHost(snmpPDU2.getRemoteHost());
                    ((SnmpPDU)object).setRemotePort(snmpPDU2.getRemotePort());
                    ((SnmpPDU)object).setCommand(snmpPDU2.getCommand());
                    ((SnmpPDU)object).setErrstat(snmpPDU2.getErrstat());
                    ((SnmpPDU)object).setErrindex(snmpPDU2.getErrindex());
                    return object;
                }
                bl2 = true;
                continue;
            }
            if (snmpPDU2.getErrstat() == 0) {
                n3 = n;
                bl2 = false;
                object = snmpPDU2.getVariableBindings().elements();
                while (object.hasMoreElements()) {
                    vector.addElement((SnmpVarBind)object.nextElement());
                }
            } else if (this.version == 0) {
                snmpPDU.setCommand(snmpPDU2.getCommand());
                snmpPDU.setErrstat(snmpPDU2.getErrstat());
                snmpPDU.setErrindex(n3 + snmpPDU2.getErrindex());
                return snmpPDU;
            }
            if (vector.size() == snmpPDU.getVariableBindings().size()) break;
        }
        object = new SnmpPDU();
        ((SnmpPDU)object).setRemoteHost(snmpPDU2.getRemoteHost());
        ((SnmpPDU)object).setRemotePort(snmpPDU2.getRemotePort());
        ((SnmpPDU)object).setRetries(snmpPDU2.getRetries());
        ((SnmpPDU)object).setTimeout(snmpPDU2.getTimeout());
        ((SnmpPDU)object).setVersion(snmpPDU2.getVersion());
        ((SnmpPDU)object).setCommunity(snmpPDU2.getCommunity());
        ((SnmpPDU)object).setCommand(snmpPDU2.getCommand());
        ((SnmpPDU)object).setReqid(snmpPDU2.getReqid());
        ((SnmpPDU)object).setErrstat(snmpPDU2.getErrstat());
        if (n == n2) {
            ((SnmpPDU)object).setErrindex(snmpPDU2.getErrindex());
        } else {
            ((SnmpPDU)object).setErrindex(n3 + snmpPDU2.getErrindex());
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((SnmpPDU)object).addVariableBinding((SnmpVarBind)enumeration.nextElement());
        }
        return object;
    }

    void getGROUPSNMPResponse(SnmpPDU snmpPDU) {
        SnmpPDU snmpPDU2 = null;
        try {
            if (this.attemptCompleteData && snmpPDU.getCommand() != -93) {
                snmpPDU2 = this.getCompletePDU(snmpPDU);
            } else {
                snmpPDU.setClientID(this.clientID);
                snmpPDU2 = this.session.syncSend(snmpPDU);
            }
            this.sentreqid = snmpPDU.getReqid();
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error in SyncSend :")) + " " + exception.toString());
        }
        if (snmpPDU2 == null) {
            return;
        }
        if (snmpPDU2.getErrstat() != 0) {
            snmpPDU2 = this.getPartialPDUData(snmpPDU, snmpPDU2, this.session);
        }
        if (snmpPDU2 == null) {
            return;
        }
        int n = 0;
        while (n < this.matchServ.size()) {
            SnmpServer snmpServer = (SnmpServer)this.matchServ.elementAt(n);
            boolean bl = true;
            Vector vector = snmpPDU2.getVariableBindings();
            SnmpPDU snmpPDU3 = new SnmpPDU();
            int n2 = 0;
            while (n2 < vector.size()) {
                int n3 = 0;
                while (n3 < snmpServer.oidList.length) {
                    if (snmpServer.oidList[n3].toString().equals(((SnmpVarBind)vector.elementAt(n2)).getObjectID().toString())) {
                        snmpPDU3.addVariableBinding(snmpPDU2.getVariableBinding(n2));
                        bl = false;
                    }
                    ++n3;
                }
                ++n2;
            }
            if (bl) {
                this.genEvent(null, snmpServer);
            } else {
                snmpPDU3.setCommand(snmpPDU2.getCommand());
                snmpPDU3.setAgentAddress(snmpPDU2.getAgentAddress());
                snmpPDU3.setCommunity(snmpPDU2.getCommunity());
                snmpPDU3.setData(snmpPDU2.getData());
                snmpPDU3.setEnterprise(snmpPDU2.getEnterprise());
                snmpPDU3.setErrindex(snmpPDU2.getErrindex());
                snmpPDU3.setMaxRepetitions(snmpPDU2.getMaxRepetitions());
                snmpPDU3.setNonRepeaters(snmpPDU2.getNonRepeaters());
                snmpPDU3.setWriteCommunity(snmpPDU2.getWriteCommunity());
                snmpPDU3.setVersion(snmpPDU2.getVersion());
                snmpPDU3.setUpTime(snmpPDU2.getUpTime());
                snmpPDU3.setTimeout(snmpPDU2.getTimeout());
                snmpPDU3.setRetries(snmpPDU2.getRetries());
                snmpPDU3.setReqid(snmpPDU2.getReqid());
                snmpPDU3.setRemoteHost(snmpPDU2.getRemoteHost());
                snmpPDU3.setRemotePort(snmpPDU2.getRemotePort());
                this.genEvent(snmpPDU3, snmpServer);
            }
            ++n;
        }
    }

    public String getHostAddress(String string) {
        SASClient sASClient = this.session.getSASClient();
        if (sASClient == null) {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
                return inetAddress.getHostAddress();
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            return sASClient.getHostAddress(string, 2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean getIgnoreSpecificControlCodes() {
        return this.mibOps.getIgnoreSpecificControlCodes();
    }

    public String getMibPath() {
        return this.mibOps.getMibPath();
    }

    public boolean getOverwriteCMI() {
        return this.mibOps.getOverwriteCMI();
    }

    SnmpPDU getPartialPDUData(SnmpPDU snmpPDU, SnmpPDU snmpPDU2, SnmpSession snmpSession) {
        if (snmpPDU2.getErrstat() != 0 && snmpPDU2.getVariableBindings().size() > 1) {
            int n = snmpPDU2.getErrindex();
            SnmpVarBind snmpVarBind = snmpPDU2.getVariableBinding(n - 1);
            if (snmpPDU2.getVariableBindings().size() <= 1 || snmpPDU2.getErrindex() == 0) {
                this.errorCode = snmpPDU2.getErrstat();
                this.error = ErrorMessages.getErrorString(this.errorCode);
                return null;
            }
            snmpPDU.setErrindex(snmpPDU2.getErrindex());
            snmpPDU.fix();
            try {
                snmpPDU.setClientID(this.clientID);
                snmpPDU2 = snmpSession.syncSend(snmpPDU);
                this.sentreqid = snmpPDU.getReqid();
                if (snmpPDU2 == null) {
                    return null;
                }
            }
            catch (SnmpException snmpException) {
                String string = snmpException.getMessage();
                this.errorCode = string.equals(SnmpUtils.getString("No remote IP address specified.")) ? 35 : (string.equals(SnmpUtils.getString("Session Remote Host Unknown.")) ? 36 : (string.equals(SnmpUtils.getString("Security Exception connecting to remote host")) ? 37 : 43));
                this.error = String.valueOf(SnmpUtils.getString("Sending PDU: ")) + " " + string;
                return null;
            }
            snmpPDU2 = this.getPartialPDUData(snmpPDU, snmpPDU2, snmpSession);
            if (snmpPDU2 == null) {
                return null;
            }
            snmpPDU2.getVariableBindings().insertElementAt(snmpVarBind, n - 1);
        }
        snmpPDU.setErrstat(0);
        snmpPDU.setErrindex(0);
        return snmpPDU2;
    }

    SnmpPDU getSNMPResponse(byte by) {
        if (this.api == null) {
            this.errorCode = 19;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            return null;
        }
        if (this.isSendPDUByGroup) {
            int n;
            Object object;
            Serializable serializable;
            Vector vector = (Vector)this.pollertargets.clone();
            Vector<SnmpServer> vector2 = new Vector<SnmpServer>();
            int n2 = 0;
            while (n2 < vector.size()) {
                if (((SnmpServer)vector.elementAt((int)n2)).listeners.size() > 0) {
                    vector2.addElement((SnmpServer)vector.elementAt(n2));
                } else {
                    this.pollertargets.removeElement((SnmpServer)vector.elementAt(n2));
                }
                ++n2;
            }
            this.matchtable = new Hashtable();
            String string = null;
            int n3 = 0;
            while (n3 < vector2.size()) {
                serializable = (SnmpServer)vector2.elementAt(n3);
                String string2 = "";
                string2 = String.valueOf(((SnmpServer)serializable).targetHost) + ((SnmpServer)serializable).port + ((SnmpServer)serializable).retries + ((SnmpServer)serializable).timeout + this.pollInterval;
                if (((SnmpServer)serializable).count == this.count) {
                    string = string2;
                }
                if (this.matchtable.get(string2) != null) {
                    object = (Vector)this.matchtable.get(string2);
                    ((Vector)object).addElement(serializable);
                    this.matchtable.put(string2, object);
                } else {
                    object = new Vector();
                    ((Vector)object).addElement(serializable);
                    this.matchtable.put(string2, object);
                }
                ++n3;
            }
            if (string != null) {
                this.matchServ = (Vector)this.matchtable.get(string);
                serializable = new Vector();
                n = 0;
                while (n < this.matchServ.size()) {
                    object = ((SnmpServer)this.matchServ.elementAt((int)n)).oidList;
                    SnmpServer snmpServer = (SnmpServer)this.matchServ.elementAt(n);
                    int n4 = 0;
                    while (n4 < ((SnmpOID[])object).length) {
                        if (((Vector)serializable).indexOf(((SnmpOID)object[n4]).toString()) == -1) {
                            ((Vector)serializable).addElement(((SnmpOID)object[n4]).toString());
                        }
                        ++n4;
                    }
                    ++n;
                }
                this.group_oidList = new String[((Vector)serializable).size()];
                int n5 = 0;
                while (n5 < ((Vector)serializable).size()) {
                    this.group_oidList[n5] = ((Vector)serializable).elementAt(n5).toString();
                    ++n5;
                }
            } else {
                return null;
            }
            serializable = new SnmpPDU();
            ((SnmpPDU)serializable).setCommand(by);
            n = 0;
            while (n < this.group_oidList.length) {
                ((SnmpPDU)serializable).addNull(this.mibOps.getSnmpOID(this.group_oidList[n]));
                ++n;
            }
            if (((SnmpServer)this.matchServ.elementAt((int)0)).count == this.count) {
                this.getGROUPSNMPResponse((SnmpPDU)serializable);
            }
            return null;
        }
        SnmpPDU snmpPDU = new SnmpPDU();
        snmpPDU.setCommand(by);
        int n = 0;
        while (n < this.oidList.length) {
            snmpPDU.addNull(this.oidList[n]);
            if ((by == -93 || by == -92) && this.varList != null && this.varList.length > n) {
                snmpPDU.getVariableBinding(n).setVariable(this.varList[n]);
            }
            ++n;
        }
        return this.getSNMPResponse(snmpPDU);
    }

    SnmpPDU getSNMPResponse(SnmpPDU snmpPDU) {
        SnmpPDU snmpPDU2 = null;
        this.errorCode = -1;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        long l = 0L;
        long l2 = 0L;
        try {
            snmpPDU.setRemoteHost(this.targetHost);
            snmpPDU.setCommunity(this.community);
            if (snmpPDU.getCommand() == -93 && this.writeCommunity != null) {
                snmpPDU.setWriteCommunity(this.writeCommunity);
            }
            snmpPDU.setRemotePort(this.port);
            snmpPDU.setVersion(this.version);
            snmpPDU.setRetries(this.retries);
            snmpPDU.setTimeout(this.timeout);
            if (snmpPDU.getCommand() == -96 || snmpPDU.getCommand() == -93 || snmpPDU.getCommand() == -95) {
                if (this.group != null) {
                    l = this.group.getSnmpInASNParseErrs();
                }
                if (this.attemptCompleteData && snmpPDU.getCommand() != -93) {
                    snmpPDU2 = this.getCompletePDU(snmpPDU);
                } else {
                    snmpPDU.setClientID(this.clientID);
                    snmpPDU2 = this.session.syncSend(snmpPDU);
                }
            } else {
                snmpPDU.setClientID(this.clientID);
                this.session.send(snmpPDU);
                return null;
            }
            this.sentreqid = snmpPDU.getReqid();
        }
        catch (SnmpException snmpException) {
            this.error = String.valueOf(SnmpUtils.getString("Error Sending PDU")) + " " + snmpException.getMessage();
            this.genTimeoutEvent(snmpPDU);
            return null;
        }
        if (snmpPDU2 == null) {
            if (this.group != null) {
                l2 = this.group.getSnmpInASNParseErrs();
            }
            if (l2 != l) {
                this.errorCode = 50;
                this.error = String.valueOf(ErrorMessages.getErrorString(this.errorCode)) + " " + SnmpUtils.getString("from") + " " + this.targetHost;
            } else {
                this.errorCode = 22;
                this.error = String.valueOf(ErrorMessages.getErrorString(this.errorCode)) + SnmpUtils.getString("to") + " " + this.targetHost;
            }
            this.genTimeoutEvent(snmpPDU2);
            return null;
        }
        String string = "";
        string = snmpPDU.getAddress() != null ? snmpPDU.getAddress().getHostAddress() : snmpPDU.getRemoteHost();
        this.error = String.valueOf(SnmpUtils.getString("Response PDU received from ")) + " " + string;
        if (snmpPDU2.getVersion() == 0) {
            if (snmpPDU2.getErrstat() != 0) {
                this.errorCode = snmpPDU2.getErrstat();
                this.error = String.valueOf(this.error) + "\n" + SnmpUtils.getString("Error Indication in response:") + " \n" + ErrorMessages.getErrorString(this.errorCode) + "\n" + SnmpUtils.getString("Errindex:") + " " + snmpPDU2.getErrindex();
                this.errorIndex = snmpPDU2.getErrindex();
                if (this.attemptPartialData && snmpPDU2.getErrindex() != 0) {
                    return this.getPartialPDUData(snmpPDU, snmpPDU2, this.session);
                }
                this.genTimeoutEvent(snmpPDU2);
                return null;
            }
        } else {
            this.errorCode = 20;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            this.genTimeoutEvent(snmpPDU2);
            return null;
        }
        return snmpPDU2;
    }

    SnmpPDU getSNMPResponse(SnmpOID[] snmpOIDArray, SnmpVar[] snmpVarArray, byte by) {
        if (this.api == null) {
            this.errorCode = 19;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            return null;
        }
        SnmpPDU snmpPDU = new SnmpPDU();
        snmpPDU.setCommand(by);
        int n = 0;
        while (n < snmpOIDArray.length) {
            snmpPDU.addNull(snmpOIDArray[n]);
            if (snmpVarArray != null && snmpVarArray.length > n) {
                snmpPDU.setVariable(n, snmpVarArray[n]);
            }
            ++n;
        }
        return this.getSNMPResponse(snmpPDU);
    }

    public String getSerializedMibFileName() {
        return this.mibOps.getSerializedMibFileName();
    }

    public int getTimeToWait() {
        if (this.session != null) {
            return this.session.getTimeToWait();
        }
        return 0;
    }

    private static byte[] gethexValue(String string) {
        byte[] byArray = new byte[string.length() / 2 - 1];
        String string2 = string.substring(2);
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            byte by;
            String string3 = string2.substring(n2, n2 + 2);
            byArray[n2 / 2] = by = (byte)Integer.parseInt(string3, 16);
            n2 += 2;
        }
        return byArray;
    }

    public void initJdbcParams(String string, String string2, String string3, String string4) throws SQLException, ClassNotFoundException {
        this.api.initJdbcParams(string, string2, string3, string4);
    }

    synchronized void initSnmpStore(SnmpServer snmpServer) {
        while (finalize_called) {
        }
        if (snmpStore == null) {
            snmpStore = new Hashtable();
        }
        String[] stringArray = snmpStore;
        synchronized (stringArray) {
            this.mibOps = (MibOperations)snmpStore.get("MIBS");
            if (this.mibOps == null) {
                this.mibOps = new MibOperations();
                snmpStore.put("MIBS", this.mibOps);
            }
            this.pollertargets = (Vector)snmpStore.get("POLLERTARGETS");
            if (this.pollertargets == null) {
                this.pollertargets = new Vector();
                snmpStore.put("POLLERTARGETS", this.pollertargets);
            }
            this.targets = (Vector)snmpStore.get("TARGETS");
            if (this.targets == null) {
                this.targets = new Vector();
                snmpStore.put("TARGETS", this.targets);
            }
            if (this.sessionName != null && this.localPort != 0) {
                this.session = (SnmpSession)snmpStore.get("SESSION" + this.sessionName + this.localPort);
                if (this.session != null) {
                    this.session_port_targets = (Vector)snmpStore.get("SESSION" + this.sessionName + this.localPort + "_TARGETS");
                    if (this.session_port_targets != null) {
                        this.session_port_targets.addElement("");
                        snmpStore.put("SESSION" + this.sessionName + this.localPort + "_TARGETS", this.session_port_targets);
                    }
                }
            } else if (this.sessionName != null) {
                this.session = (SnmpSession)snmpStore.get("SESSION" + this.sessionName);
                if (this.session != null) {
                    this.session_targets = (Vector)snmpStore.get("SESSION" + this.sessionName + this.localPort + "_TARGETS");
                    if (this.session_targets != null) {
                        this.session_targets.addElement("");
                        snmpStore.put("SESSION" + this.sessionName + "_TARGETS", this.session_targets);
                    }
                }
            } else if (this.localPort != 0) {
                this.session = (SnmpSession)snmpStore.get("SESSION" + this.localPort);
                if (this.session != null) {
                    this.port_targets = (Vector)snmpStore.get("SESSION" + this.sessionName + this.localPort + "_TARGETS");
                    if (this.port_targets != null) {
                        this.port_targets.addElement("");
                        snmpStore.put("SESSION" + this.localPort + "_TARGETS", this.port_targets);
                    }
                }
            } else if (this.sessionName == null) {
                this.session = (SnmpSession)snmpStore.get("SESSION");
                if (this.session != null) {
                    this.nullsession_targets = (Vector)snmpStore.get("SESSION_TARGETS");
                    if (this.nullsession_targets != null) {
                        this.nullsession_targets.addElement("");
                        snmpStore.put("SESSION_TARGETS", this.nullsession_targets);
                    }
                }
            }
            this.api = (SnmpAPI)snmpStore.get("API");
            if (this.api != null && !this.api.isAlive()) {
                this.api = null;
            }
            if (this.session != null && !this.session.isAlive()) {
                this.session = null;
            }
            if (this.api == null) {
                this.api = new SnmpAPI();
                snmpStore.put("API", this.api);
                this.api.start();
            }
            if (this.session == null) {
                try {
                    this.session = new SnmpSession(this.api);
                    if (this.localPort != 0) {
                        this.session.setLocalPort(this.localPort);
                    }
                    if (applet != null) {
                        this.session.open(applet);
                    } else {
                        if (this.protocol == 2) {
                            this.session.setProtocol(2);
                            this.session.setProtocolOptions(this.options);
                        }
                        this.session.open();
                    }
                    this.session.setCommunity(null);
                    if (this.sessionName != null && this.localPort != 0) {
                        this.session_port_targets = (Vector)snmpStore.get("SESSION" + this.sessionName + this.localPort + "_TARGETS");
                        if (this.session_port_targets == null) {
                            this.session_port_targets = new Vector();
                            snmpStore.put("SESSION" + this.sessionName + this.localPort + "_TARGETS", this.session_port_targets);
                        }
                        snmpStore.put("SESSION" + this.sessionName + this.localPort, this.session);
                        this.session_port_targets.addElement("");
                    } else if (this.sessionName != null) {
                        this.session_targets = (Vector)snmpStore.get("SESSION" + this.sessionName + "_TARGETS");
                        if (this.session_targets == null) {
                            this.session_targets = new Vector();
                            snmpStore.put("SESSION" + this.sessionName + "_TARGETS", this.session_targets);
                        }
                        snmpStore.put("SESSION" + this.sessionName, this.session);
                        this.session_targets.addElement("");
                    } else if (this.localPort != 0) {
                        this.port_targets = (Vector)snmpStore.get("SESSION" + this.localPort + "_TARGETS");
                        if (this.port_targets == null) {
                            this.port_targets = new Vector();
                            snmpStore.put("SESSION" + this.localPort + "_TARGETS", this.port_targets);
                        }
                        snmpStore.put("SESSION" + this.localPort, this.session);
                        this.port_targets.addElement("");
                    } else if (this.sessionName == null) {
                        this.nullsession_targets = (Vector)snmpStore.get("SESSION_TARGETS");
                        if (this.nullsession_targets == null) {
                            this.nullsession_targets = new Vector();
                            snmpStore.put("SESSION_TARGETS", this.nullsession_targets);
                        }
                        snmpStore.put("SESSION", this.session);
                        this.nullsession_targets.addElement("");
                    }
                }
                catch (SnmpException snmpException) {
                    this.errorCode = ErrorMessages.addNewErrorString(snmpException.getMessage());
                    snmpException.printStackTrace();
                }
            }
            this.targets.addElement("");
            this.count = this.targets.size();
            this.isResourcesAllocated = true;
        }
        stringArray = this.session.getLocalAddresses();
        int n = this.session.getLocalPort();
        this.group = this.api.getSnmpGroup(stringArray[stringArray.length - 1], n);
    }

    public boolean isLoadFromCompiledMibs() {
        return this.mibOps.isLoadFromCompiledMibs();
    }

    public boolean isLoadFromSerializedMibs() {
        return this.mibOps.isLoadFromSerializedMibs();
    }

    public boolean isLoadMibsFromDatabase() {
        return this.mibOps.isLoadFromDatabase();
    }

    public boolean isOverwriteMibsInDatabase() {
        return this.mibOps.isOverwriteDatabase();
    }

    public boolean isReadDesc() {
        return this.mibOps.isReadDesc();
    }

    public boolean isSendPDUByGroup() {
        return this.isSendPDUByGroup;
    }

    public boolean isSerializeMibs() {
        return this.mibOps.isSerializeMibs();
    }

    void loadMibs(String string) throws MibException, IOException, FileNotFoundException {
        if (applet != null) {
            this.mibOps.loadMibModules(applet, string);
        } else {
            this.mibOps.loadMibModules(string);
        }
    }

    public void releaseResources() {
        if (!this.isResourcesAllocated) {
            return;
        }
        this.isResourcesAllocated = false;
        Object var1_1 = null;
        if (this.targets != null) {
            this.targets.removeElement("");
            if (this.targets.size() == 0) {
                snmpStore.remove("MIBS");
                MibOperations.jdbc = false;
                this.mibOps = null;
            }
        }
        if (this.sessionName != null && this.localPort != 0) {
            if (this.session_port_targets.size() == 1) {
                this.session = (SnmpSession)snmpStore.remove("SESSION" + this.sessionName + this.localPort);
                if (this.session != null) {
                    this.session.close();
                }
                this.session = null;
            }
            this.session_port_targets.removeElement("");
        } else if (this.sessionName != null) {
            if (this.session_targets.size() == 1) {
                this.session = (SnmpSession)snmpStore.remove("SESSION" + this.sessionName);
                if (this.session != null) {
                    this.session.close();
                }
                this.session = null;
            }
            this.session_targets.removeElement("");
        } else if (this.localPort != 0) {
            if (this.port_targets.size() == 1) {
                this.session = (SnmpSession)snmpStore.remove("SESSION" + this.localPort);
                if (this.session != null) {
                    this.session.close();
                }
                this.session = null;
            }
            this.port_targets.removeElement("");
        } else if (this.sessionName == null) {
            if (this.nullsession_targets.size() == 1) {
                this.session = (SnmpSession)snmpStore.remove("SESSION");
                if (this.session != null) {
                    this.session.close();
                }
                this.session = null;
            }
            this.nullsession_targets.removeElement("");
        }
        if (this.targets.size() == 0) {
            this.api = (SnmpAPI)snmpStore.remove("API");
            if (this.api != null) {
                this.api.close();
            }
            this.api = null;
        }
    }

    int sendSNMPRequest(byte by) {
        if (this.api == null) {
            this.errorCode = 19;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            return -1;
        }
        SnmpPDU snmpPDU = new SnmpPDU();
        snmpPDU.setCommand(by);
        if (this.reqid != 0) {
            snmpPDU.setReqid(this.reqid);
        }
        int n = 0;
        while (n < this.oidList.length) {
            snmpPDU.addNull(this.oidList[n]);
            if ((by == -93 || by == -92) && this.varList != null && this.varList.length > n) {
                snmpPDU.getVariableBinding(n).setVariable(this.varList[n]);
            }
            ++n;
        }
        return this.sendSNMPRequest(snmpPDU);
    }

    int sendSNMPRequest(SnmpPDU snmpPDU) {
        int n = -1;
        this.errorCode = -1;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        try {
            snmpPDU.setRemoteHost(this.targetHost);
            snmpPDU.setCommunity(this.community);
            if (snmpPDU.getCommand() == -93 && this.writeCommunity != null) {
                snmpPDU.setWriteCommunity(this.writeCommunity);
            }
            snmpPDU.setRemotePort(this.port);
            snmpPDU.setTimeout(this.timeout);
            snmpPDU.setRetries(this.retries);
            snmpPDU.setClientID(this.clientID);
            n = this.session.send(snmpPDU);
        }
        catch (SnmpException snmpException) {
            String string = snmpException.getMessage();
            if (string.compareTo(SnmpUtils.getString("Session Remote Host Unknown.")) == 0) {
                this.errorCode = 36;
            } else if (string.compareTo(SnmpUtils.getString("Security Exception connecting to remote host")) == 0) {
                this.errorCode = 37;
            } else if (string.compareTo(SnmpUtils.getString("IO error sending PDU.")) == 0) {
                this.errorCode = 38;
            }
            this.error = String.valueOf(SnmpUtils.getString("Error Sending PDU.")) + " " + string;
            return -1;
        }
        return n;
    }

    int sendSNMPRequest(SnmpOID[] snmpOIDArray, SnmpVar[] snmpVarArray, byte by) {
        if (this.api == null) {
            this.errorCode = 19;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            return -1;
        }
        SnmpPDU snmpPDU = new SnmpPDU();
        snmpPDU.setCommand(by);
        if (this.reqid != 0) {
            snmpPDU.setReqid(this.reqid);
        }
        int n = 0;
        while (n < snmpOIDArray.length) {
            snmpPDU.addNull(snmpOIDArray[n]);
            if (snmpVarArray != null && snmpVarArray.length > n) {
                snmpPDU.setVariable(n, snmpVarArray[n]);
            }
            ++n;
        }
        return this.sendSNMPRequest(snmpPDU);
    }

    int sendSetRequestList(String[] stringArray) throws DataException {
        if (stringArray == null) {
            this.errorCode = 33;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            throw new DataException(SnmpUtils.getString("Illegal Argument Exception"));
        }
        SnmpVar[] snmpVarArray = new SnmpVar[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            if (this.oidList == null || this.oidList[n] == null) {
                this.errorCode = 21;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                throw new DataException(SnmpUtils.getString("OID Not Specified"));
            }
            MibNode mibNode = this.mibOps.getMibNode(this.oidList[n]);
            if (mibNode == null) {
                this.errorCode = 30;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                throw new DataException(String.valueOf(SnmpUtils.getString("Error : MIB node unavailable for OID.")) + this.oidList[n]);
            }
            if (mibNode.getSyntax() == null) {
                this.errorCode = 31;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                throw new DataException(String.valueOf(SnmpUtils.getString("Error : OID not a leaf node.")) + this.oidList[n]);
            }
            try {
                SnmpVar snmpVar;
                snmpVarArray[n] = snmpVar = mibNode.getSyntax().createVariable(stringArray[n]);
            }
            catch (SnmpException snmpException) {
                this.errorCode = 32;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                throw new DataException(SnmpUtils.getString("Error : Creating variable."));
            }
            ++n;
        }
        this.varList = snmpVarArray;
        if (this.oidList != null && this.oidList.length > 0) {
            return this.sendSNMPRequest((byte)-93);
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return -1;
    }

    public void setCharacterEncoding(String string) {
        this.enc = string;
        this.api.setCharacterEncoding(string);
    }

    public void setIgnoreSpecificControlCodes(boolean bl) {
        this.mibOps.setIgnoreSpecificControlCodes(bl);
    }

    public void setLoadFromCompiledMibs(boolean bl) {
        this.mibOps.setLoadFromCompiledMibs(bl);
    }

    public void setLoadFromSerializedMibs(boolean bl) {
        this.mibOps.setLoadFromSerializedMibs(bl);
    }

    public void setLoadMibsFromDatabase(boolean bl) {
        this.mibOps.setLoadFromDatabase(bl);
    }

    public void setMibOperations(MibOperations mibOperations) {
        this.mibOps = mibOperations;
        snmpStore.put("MIBS", this.mibOps);
    }

    public void setMibPath(String string) {
        this.mibOps.setMibPath(string);
    }

    public void setOverwriteCMI(boolean bl) {
        this.mibOps.setOverwriteCMI(bl);
    }

    public void setOverwriteMibsInDatabase(boolean bl) {
        this.mibOps.setOverwriteDatabase(bl);
    }

    void setPduParams(SnmpPDU snmpPDU) throws Exception {
        snmpPDU.setRemoteHost(this.targetHost);
        snmpPDU.setCommunity(this.community);
        snmpPDU.setTimeout(this.timeout);
        snmpPDU.setRetries(this.retries);
        snmpPDU.setRemotePort(this.port);
        if (snmpPDU.getCommand() == -93 && this.writeCommunity != null) {
            snmpPDU.setWriteCommunity(this.writeCommunity);
        }
    }

    public void setReadDesc(boolean bl) {
        this.mibOps.setReadDesc(bl);
    }

    public void setSendPDUByGroup(boolean bl) {
        if (this.pollertargets == null) {
            return;
        }
        if (bl) {
            if (this.isNotSet) {
                this.isNotSet = false;
                this.pollertargets.addElement(this);
                this.isSendPDUByGroup = true;
            }
        } else if (!this.isNotSet) {
            this.isNotSet = true;
            this.pollertargets.removeElement(this);
            this.isSendPDUByGroup = false;
        }
    }

    public void setSerializeMibs(boolean bl) {
        this.mibOps.setSerializeMibs(bl);
    }

    public void setSerializedMibFileName(String string) {
        this.mibOps.setSerializedMibFileName(string);
    }

    public void setTimeToWait(int n) {
        if (this.session != null) {
            this.session.setTimeToWait(n);
        }
    }
}

