/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.beans;

import com.adventnet.snmp.beans.DataException;
import com.adventnet.snmp.beans.ErrorMessages;
import com.adventnet.snmp.beans.SnmpTableEvent;
import com.adventnet.snmp.beans.SnmpTableListener;
import com.adventnet.snmp.beans.SnmpTarget;
import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.snmp2.ProtocolOptions;
import com.adventnet.snmp.snmp2.SnmpIpAddress;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.snmp2.SnmpString;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.snmp.snmp2.SnmpVarBind;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpTable
extends SnmpTarget
implements Runnable {
    boolean isEntryStatus = false;
    boolean isRowAddAndDel = false;
    String[][] sb = null;
    Vector cnam = new Vector();
    int value = 0;
    int holesCount = 0;
    int hole = 0;
    int[] holes = null;
    int check = 0;
    int ADDandDELcol = 0;
    Vector tableData = new Vector();
    boolean[] editable = null;
    Class[] columnClass = null;
    String[] columnNames = null;
    transient Thread thisThread;
    int pollInterval = 0;
    boolean performSets = true;
    Vector tableListeners = new Vector();
    SnmpOID tableOID = null;
    Vector columns = null;
    Vector nodes;
    int DATA_TYPE = 1;
    boolean RETRIEVAL_MODE = true;
    Vector columnsPolled = null;
    int[] rootoid = null;
    Vector colOIDs = null;
    public static final int STRING_DATA = 1;
    public static final int SNMP_VARIABLE_DATA = 2;
    public static final int SNMP_VARIABLE_BINDING_DATA = 3;

    public SnmpTable() {
    }

    public SnmpTable(int n, ProtocolOptions protocolOptions) {
        super(n, protocolOptions);
    }

    public SnmpTable(int n, String string) {
        super(n, string);
    }

    public SnmpTable(Applet applet) {
        super(applet);
    }

    public void addRow(boolean bl, String[] stringArray, String[] stringArray2) throws DataException {
        this.setSuperObjectIDList(stringArray);
        super.snmpSetList(stringArray2);
        if (bl) {
            int n = 0;
            while (n < stringArray.length) {
                MibNode mibNode = this.getColumnMibNode(n);
                String string = mibNode.getSyntax().toString();
                if (string.equals("EntryStatus")) {
                    this.setObjectID(stringArray[n]);
                    break;
                }
                ++n;
            }
            super.snmpSet("1");
        }
    }

    public void addSnmpTableListener(SnmpTableListener snmpTableListener) {
        this.tableListeners.addElement(snmpTableListener);
    }

    private void adjustColumns() {
        int n = 0;
        while (n < this.columnsPolled.size()) {
            if ((Integer)this.columnsPolled.elementAt(n) > this.columns.size()) {
                System.out.println(String.valueOf(SnmpUtils.getString("Error : Index")) + " " + this.columnsPolled.elementAt(n) + " " + SnmpUtils.getString("not found in Table"));
                return;
            }
            if ((Integer)this.columnsPolled.elementAt(n) >= this.columns.size()) {
                this.columnsPolled.removeElementAt(n);
            }
            ++n;
        }
        Vector vector = new Vector();
        int n2 = 0;
        while (n2 < this.columnsPolled.size()) {
            vector.addElement(this.columns.elementAt((Integer)this.columnsPolled.elementAt(n2)));
            ++n2;
        }
        this.columns = vector;
    }

    private void adjustOidList() {
        int n = 0;
        while (n < this.columnsPolled.size()) {
            if ((Integer)this.columnsPolled.elementAt(n) >= this.oidList.length) {
                this.columnsPolled.removeElementAt(n);
            }
            ++n;
        }
        SnmpOID[] snmpOIDArray = new SnmpOID[this.columnsPolled.size()];
        int n2 = 0;
        while (n2 < this.columnsPolled.size()) {
            snmpOIDArray[n2] = this.oidList[(Integer)this.columnsPolled.elementAt(n2)];
            ++n2;
        }
        this.oidList = snmpOIDArray;
    }

    protected void checkDifferences(Vector vector) {
        block11: {
            block10: {
                block13: {
                    block12: {
                        if (vector != null && vector.size() > 0) break block10;
                        if (this.tableData == null || this.tableData.size() <= 0) break block11;
                        if (this.DATA_TYPE != 1) break block12;
                        String[][] stringArray = new String[this.tableData.size()][this.getRowFromArray(0).length];
                        int n = 0;
                        while (n < this.tableData.size()) {
                            int n2 = 0;
                            while (n2 < this.getRowFromArray(n).length) {
                                SnmpVar snmpVar = this.getRowFromArray(n)[n2].getVariable();
                                stringArray[n][n2] = snmpVar == null ? null : snmpVar.toString();
                                ++n2;
                            }
                            ++n;
                        }
                        this.genTableEvent(new SnmpTableEvent(this, stringArray, 0, this.tableData.size() - 1, -1, 1));
                        break block11;
                    }
                    if (this.DATA_TYPE != 2) break block13;
                    SnmpVar[][] snmpVarArray = new SnmpVar[this.tableData.size()][this.getRowFromArray(0).length];
                    int n = 0;
                    while (n < this.tableData.size()) {
                        int n3 = 0;
                        while (n3 < this.getRowFromArray(n).length) {
                            snmpVarArray[n][n3] = this.getRowFromArray(n)[n3].getVariable();
                            ++n3;
                        }
                        ++n;
                    }
                    this.genTableEvent(new SnmpTableEvent(this, snmpVarArray, 0, this.tableData.size() - 1, -1, 1));
                    break block11;
                }
                if (this.DATA_TYPE != 3) break block11;
                this.genTableEvent(new SnmpTableEvent(this, this.tableData, 0, this.tableData.size() - 1, -1, 1));
                break block11;
            }
            if (this.tableData == null || this.tableData.size() <= 0) {
                this.genTableEvent(new SnmpTableEvent(this, null, 0, vector.size() - 1, -1, 2));
            } else {
                if (vector.size() < this.tableData.size()) {
                    this.genTableEvent(new SnmpTableEvent(this, null, vector.size(), this.tableData.size() - 1, -1, 1));
                } else if (vector.size() > this.tableData.size()) {
                    this.genTableEvent(new SnmpTableEvent(this, null, this.tableData.size(), vector.size() - 1, -1, 2));
                }
                int n = 0;
                while (n < vector.size() && n < this.tableData.size()) {
                    this.compareRow(n, vector);
                    ++n;
                }
            }
        }
    }

    protected void compareRow(int n, Vector vector) {
        int n2 = 0;
        while (n2 < this.getRowFromArray(0).length) {
            if (this.getRowFromArray(n)[n2] == null) {
                if (this.getRow(n, vector)[n2] != null) {
                    this.genTableEvent(new SnmpTableEvent(this, null, this.tableData.size(), vector.size() - 1, -1, 3));
                }
            } else if (this.getRow(n, vector)[n2] == null || this.getRow(n, vector)[n2].toTagString().equals(this.getRowFromArray(n)[n2].toTagString())) {
                this.genTableEvent(new SnmpTableEvent(this, null, this.tableData.size(), vector.size() - 1, -1, 3));
            }
            ++n2;
        }
    }

    public void deleteRow(String string) {
        this.setObjectID(string);
        String string2 = new String("6");
        if (this.isEntryStatus) {
            string2 = new String("4");
        }
        try {
            String string3 = this.snmpSet(string2);
            if (string3 == null) {
                System.out.println(String.valueOf(SnmpUtils.getString("Error :")) + " " + this.getErrorString());
            }
        }
        catch (Exception exception) {}
    }

    private void doGetNotAccessibleIndex(SnmpVarBind snmpVarBind) {
        int n = 0;
        this.sb = new String[1001][100];
        SnmpOID snmpOID = snmpVarBind.getObjectID();
        MibNode mibNode = this.mibOps.getMibNode(snmpOID);
        String string = this.mibOps.getInstanceString(snmpOID);
        Vector vector = mibNode.getIndexes(this.mibOps);
        Vector vector2 = mibNode.getSyntax().decodeInstanceString(string, vector);
        int n2 = 0;
        while (n2 < vector2.size()) {
            MibNode mibNode2 = (MibNode)vector.elementAt(n2);
            SnmpVar snmpVar = (SnmpVar)vector2.elementAt(n2);
            String string2 = this.mibOps.toString(snmpVar, this.mibOps.getSnmpOID(mibNode2.getLabel()));
            if (snmpVar instanceof SnmpString && mibNode2.getLabel().indexOf("Address") != -1) {
                string2 = new SnmpIpAddress(snmpVar.toBytes()).toString();
            }
            this.sb[n][n2] = string2;
            ++n2;
        }
        ++n;
    }

    protected void finalize() throws Throwable {
        this.thisThread.stop();
        super.finalize();
    }

    protected void genTableEvent(SnmpTableEvent snmpTableEvent) {
        Object var2_2 = null;
        if (this.tableListeners.size() == 0) {
            return;
        }
        Enumeration enumeration = this.tableListeners.elements();
        while (enumeration.hasMoreElements()) {
            SnmpTableListener snmpTableListener = (SnmpTableListener)enumeration.nextElement();
            snmpTableListener.tableChanged(snmpTableEvent);
        }
    }

    public Object getCellValue(String string, int n, int n2) {
        try {
            this.setTableOIDWoStart(string);
        }
        catch (DataException dataException) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error :")) + " " + dataException);
        }
        if (this.columns == null) {
            return null;
        }
        SnmpVarBind[] snmpVarBindArray = this.getRow(n);
        if (n2 < 0 || n2 > this.columns.size()) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error : Column index")) + " " + n2 + " " + SnmpUtils.getString("not found in Table"));
            return null;
        }
        if (snmpVarBindArray != null && snmpVarBindArray.length > n2 && snmpVarBindArray[n2] != null) {
            if (this.DATA_TYPE == 1) {
                SnmpVar snmpVar = this.getRow(n)[n2].getVariable();
                if (snmpVar == null) {
                    return null;
                }
                return this.mibOps.toString(snmpVar, this.getRow(n)[n2].getObjectID());
            }
            if (this.DATA_TYPE == 2) {
                return this.getRow(n)[n2].getVariable();
            }
            if (this.DATA_TYPE == 3) {
                return this.getRow(n)[n2];
            }
        }
        return null;
    }

    public String[] getColumn(int n) {
        if (this.columns == null) {
            return null;
        }
        if (n < 0 || n > this.columns.size()) {
            System.out.println(String.valueOf(SnmpUtils.getString("ColumnIndex ")) + " " + n + " " + SnmpUtils.getString("not found in table"));
            return null;
        }
        String string = (String)this.columns.elementAt(n);
        SnmpOID snmpOID = this.mibOps.getSnmpOID(string);
        MibNode mibNode = this.mibOps.getMibNode(snmpOID);
        this.setSnmpOID(snmpOID);
        String[][] stringArray = this.snmpGetAllList();
        if (stringArray != null) {
            String[] stringArray2 = new String[stringArray.length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray2[n2] = stringArray[n2][0];
                ++n2;
            }
            return stringArray2;
        }
        return null;
    }

    public String[] getColumn(String string) {
        SnmpOID snmpOID = this.mibOps.getSnmpOID(string);
        if (snmpOID == null) {
            return null;
        }
        MibNode mibNode = this.mibOps.getMibNode(snmpOID);
        this.setSnmpOID(snmpOID);
        String[][] stringArray = this.snmpGetAllList();
        if (stringArray != null) {
            String[] stringArray2 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = stringArray[n][0];
                ++n;
            }
            return stringArray2;
        }
        return null;
    }

    public Class getColumnClass(int n) {
        if (n < 0 || n > this.columns.size()) {
            System.out.println(SnmpUtils.getString("Error : No such column Index"));
            return null;
        }
        try {
            if (this.columnClass == null) {
                return Class.forName("java.awt.TextField");
            }
            return this.columnClass[n];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getColumnCount() {
        if (this.tableOID == null && this.columns == null) {
            System.out.println(SnmpUtils.getString("Error : Table OID not specified"));
            return 0;
        }
        if (this.columns != null && this.columns.size() > 0) {
            return this.columns.size();
        }
        if (this.tableData == null || this.tableData.size() <= 0) {
            return 0;
        }
        return this.getRowFromArray(0).length;
    }

    public MibNode getColumnMibNode(int n) {
        if (n > this.columns.size()) {
            System.out.println(SnmpUtils.getString("Error : No such column"));
            return null;
        }
        if (n < 0) {
            System.out.println(SnmpUtils.getString("Error : Column Index cannot be negative"));
            return null;
        }
        if (this.nodes == null) {
            return null;
        }
        if (n >= this.nodes.size()) {
            return null;
        }
        return (MibNode)this.nodes.elementAt(n);
    }

    public String getColumnName(int n) {
        if (n < 0) {
            System.out.println(SnmpUtils.getString("Error : Column Index cannot be negative"));
            return null;
        }
        if (n > this.columns.size()) {
            System.out.println(SnmpUtils.getString("Error : No such column exists"));
            return null;
        }
        if (this.columnNames == null) {
            return "unset";
        }
        return this.columnNames[n];
    }

    public int getDataType() {
        return this.DATA_TYPE;
    }

    public int[] getHoles() {
        int[] nArray = new int[this.holesCount];
        int n = 0;
        while (n < this.holesCount) {
            nArray[n] = this.holes[n];
            ++n;
        }
        return nArray;
    }

    public String[][] getIndices() {
        String[][] stringArray;
        if (this.columns == null) {
            return null;
        }
        String string = (String)this.columns.elementAt(0);
        SnmpOID snmpOID = this.mibOps.getSnmpOID(string);
        MibNode mibNode = this.mibOps.getMibNode(snmpOID);
        this.setSnmpOID(snmpOID);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Vector<String> vector = new Vector<String>();
        while (n++ < this.getMaxNumRows()) {
            stringArray = this.snmpGetNextVariableBinding();
            if (stringArray == null || !SnmpTarget.isInSubTree(snmpOID, this.getSnmpOIDList()[0])) break;
            SnmpOID snmpOID2 = stringArray.getObjectID();
            String string2 = this.mibOps.getInstanceString(snmpOID2);
            Vector vector2 = mibNode.getIndexes(this.mibOps);
            Vector vector3 = mibNode.getSyntax().decodeInstanceString(string2, vector2);
            n3 = 0;
            while (n3 < vector3.size()) {
                MibNode mibNode2 = (MibNode)vector2.elementAt(n3);
                SnmpVar snmpVar = (SnmpVar)vector3.elementAt(n3);
                String string3 = this.mibOps.toString(snmpVar, this.mibOps.getSnmpOID(mibNode2.getLabel()));
                if (snmpVar instanceof SnmpString && mibNode2.getLabel().indexOf("Address") != -1) {
                    string3 = new SnmpIpAddress(snmpVar.toBytes()).toString();
                }
                vector.addElement(string3);
                ++n3;
            }
            ++n2;
        }
        stringArray = new String[n2][n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < n3) {
                stringArray[n5][n6] = (String)vector.elementAt(n4);
                ++n4;
                ++n6;
            }
            ++n5;
        }
        return stringArray;
    }

    public String[][] getNotAccessibleIndex() {
        int n = 0;
        if (this.sb == null) {
            return null;
        }
        if (this.sb != null) {
            int n2 = 0;
            while (n2 < this.sb.length) {
                if (this.sb[n2][0] != null) {
                    ++n;
                }
                ++n2;
            }
        }
        String[][] stringArray = new String[n][this.cnam.size()];
        int n3 = 0;
        while (n3 < stringArray.length) {
            int n4 = 0;
            while (n4 < stringArray[0].length) {
                if (this.sb[n3][n4] != null) {
                    stringArray[n3][n4] = this.sb[n3][n4];
                }
                ++n4;
            }
            ++n3;
        }
        return stringArray;
    }

    public String[] getNotAccessibleIndexColumns() {
        String[] stringArray = new String[this.cnam.size()];
        int n = 0;
        while (n < this.cnam.size()) {
            stringArray[n] = (String)this.cnam.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public boolean getPerformSets() {
        return this.performSets;
    }

    public void getPerformSets(boolean bl) {
        this.performSets = bl;
    }

    public int getPollInterval() {
        return this.pollInterval / 1000;
    }

    public boolean getRetrievalMode() {
        return this.RETRIEVAL_MODE;
    }

    public SnmpVarBind[] getRow(int n) {
        if (n < 0) {
            System.out.println(SnmpUtils.getString("No Such Row Exists"));
            return null;
        }
        String string = (String)this.columns.elementAt(0);
        SnmpOID snmpOID = this.mibOps.getSnmpOID(string);
        MibNode mibNode = this.mibOps.getMibNode(snmpOID);
        this.setSnmpOID(snmpOID);
        String string2 = new String();
        boolean bl = false;
        SnmpVarBind snmpVarBind = null;
        for (int i = 0; i <= n; ++i) {
            snmpVarBind = this.snmpGetNextVariableBinding();
            if (snmpVarBind != null && SnmpTarget.isInSubTree(snmpOID, this.getSnmpOIDList()[0])) continue;
            bl = true;
            break;
        }
        if (bl) {
            return null;
        }
        SnmpOID snmpOID2 = snmpVarBind.getObjectID();
        string2 = this.mibOps.getInstanceString(snmpOID2);
        String[] stringArray = new String[this.columns.size()];
        if (this.columns != null) {
            int n2 = 0;
            while (n2 < this.columns.size()) {
                stringArray[n2] = String.valueOf((String)this.columns.elementAt(n2)) + "." + string2;
                ++n2;
            }
        }
        this.setSuperObjectIDList(stringArray);
        return this.snmpGetVariableBindings();
    }

    SnmpVarBind[] getRow(int n, Vector vector) {
        if (n < 0 || n >= vector.size()) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error : Index")) + " " + n + " " + SnmpUtils.getString("not found in table"));
            return null;
        }
        return (SnmpVarBind[])vector.elementAt(n);
    }

    public String[] getRow(String string, String string2) {
        try {
            this.setTableOIDWoStart(string);
        }
        catch (DataException dataException) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error :")) + " " + dataException);
        }
        if (this.columns != null) {
            String[] stringArray = new String[this.columns.size()];
            int n = 0;
            while (n < this.columns.size()) {
                stringArray[n] = String.valueOf((String)this.columns.elementAt(n)) + "." + string2;
                ++n;
            }
            this.setSuperObjectIDList(stringArray);
            String[] stringArray2 = this.snmpGetList();
            if (stringArray2 != null) {
                return stringArray2;
            }
        }
        return null;
    }

    SnmpVarBind getRowCol(int n, int n2) {
        return ((SnmpVarBind[])this.tableData.elementAt(n))[n2];
    }

    public int getRowCount() {
        if (this.tableData == null || this.tableData.size() <= 0) {
            return 0;
        }
        return this.tableData.size();
    }

    SnmpVarBind[] getRowFromArray(int n) {
        if (n < 0 || n >= this.tableData.size()) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error : Index ")) + " " + n + " " + SnmpUtils.getString("not found in table"));
            return null;
        }
        return (SnmpVarBind[])this.tableData.elementAt(n);
    }

    public String getTableOID() {
        if (this.tableOID != null) {
            if (this.isName) {
                return this.tableOID.toString();
            }
            return this.mibOps.toString(this.tableOID);
        }
        System.out.println(SnmpUtils.getString("Error : Table OID not specified"));
        return "";
    }

    public Object getValueAt(int n, int n2) {
        SnmpVarBind[] snmpVarBindArray = this.getRowFromArray(n);
        if (n2 < 0 || n2 > this.columns.size()) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error : Column index")) + " " + n2 + " " + SnmpUtils.getString("not found in Table"));
            return null;
        }
        if (snmpVarBindArray != null && snmpVarBindArray.length > n2 && snmpVarBindArray[n2] != null) {
            if (this.DATA_TYPE == 1) {
                SnmpVar snmpVar = this.getRowFromArray(n)[n2].getVariable();
                if (snmpVar == null) {
                    return null;
                }
                return this.mibOps.toString(snmpVar, this.getRowFromArray(n)[n2].getObjectID());
            }
            if (this.DATA_TYPE == 2) {
                return this.getRowFromArray(n)[n2].getVariable();
            }
            if (this.DATA_TYPE == 3) {
                return this.getRowFromArray(n)[n2];
            }
        }
        return null;
    }

    boolean isAllInSubTree() {
        if (this.colOIDs != null && this.hole == 0 && this.colOIDs.size() == this.oidList.length) {
            this.holes = new int[this.colOIDs.size()];
            int n = 0;
            while (n < this.colOIDs.size()) {
                if (!SnmpTarget.isInSubTree((int[])this.colOIDs.elementAt(n), this.oidList[n])) {
                    this.holes[this.holesCount++] = n;
                } else {
                    this.value = n;
                }
                ++n;
            }
        }
        ++this.hole;
        return SnmpTarget.isInSubTree((int[])this.colOIDs.elementAt(this.value), this.oidList[this.value]);
    }

    boolean isAllInSubTree(SnmpVarBind[] snmpVarBindArray) {
        if (this.colOIDs != null && this.hole == 0 && this.colOIDs.size() == this.oidList.length) {
            this.holes = new int[this.colOIDs.size()];
            int n = 0;
            while (n < this.colOIDs.size()) {
                if (!SnmpTarget.isInSubTree((int[])this.colOIDs.elementAt(n), snmpVarBindArray[n].getObjectID())) {
                    this.holes[this.holesCount++] = n;
                } else {
                    this.value = n;
                }
                ++n;
            }
        }
        ++this.hole;
        return SnmpTarget.isInSubTree((int[])this.colOIDs.elementAt(this.value), snmpVarBindArray[this.value].getObjectID());
    }

    public boolean isCellEditable(int n, int n2) {
        if (n < 0 || n2 < 0) {
            System.out.println(SnmpUtils.getString("Error : Index cannot be negative"));
            return false;
        }
        if (n > this.tableData.size()) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error : Row index ")) + " " + n + " " + SnmpUtils.getString(" not found in Table"));
            return false;
        }
        if (n2 > this.columns.size()) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error : Column index")) + " " + n2 + " " + SnmpUtils.getString("not found in Table"));
            return false;
        }
        if (this.editable == null) {
            return false;
        }
        return this.editable[n2];
    }

    private void performOperations() {
        SnmpVar snmpVar = null;
        int n = -1;
        int[] nArray = (int[])this.oidList[0].toValue();
        this.colOIDs = new Vector();
        int n2 = 0;
        while (n2 < this.nodes.size()) {
            this.colOIDs.addElement(((MibNode)this.nodes.elementAt(n2)).getOID());
            ++n2;
        }
        while (n++ < this.MAX_NUM_ROWS) {
            SnmpVarBind[] snmpVarBindArray = this.snmpGetNextVariableBindings();
            if (snmpVarBindArray == null || !this.isAllInSubTree()) break;
            int n3 = 0;
            while (n3 < this.oidList.length) {
                if (n - 1 < this.MAX_NUM_ROWS) {
                    boolean bl = false;
                    if (this.holesCount != 0) {
                        int n4 = 0;
                        while (n4 < this.getHoles().length) {
                            if (this.getHoles()[n4] == n3) {
                                bl = true;
                            }
                            ++n4;
                        }
                    }
                    if (bl) {
                        try {
                            snmpVar = SnmpVar.createVariable(" ", (byte)4);
                        }
                        catch (Exception exception) {
                            System.out.println(String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception);
                        }
                        snmpVarBindArray[n3].setVariable(snmpVar);
                    }
                }
                ++n3;
            }
            if (this.check > 0) {
                this.doGetNotAccessibleIndex(snmpVarBindArray[0]);
            }
            if (this.tableData != null && this.tableData.size() > n) {
                this.tableData.removeElementAt(n);
                this.tableData.insertElementAt(snmpVarBindArray, n);
                this.genTableEvent(new SnmpTableEvent(this, snmpVarBindArray, n, n, -1, 3));
                continue;
            }
            this.tableData.addElement(snmpVarBindArray);
            this.genTableEvent(new SnmpTableEvent(this, snmpVarBindArray, n, n, -1, 1));
        }
        int n5 = this.tableData.size() - n;
        while (n5 > 0) {
            --n5;
            this.tableData.removeElementAt(n);
            this.genTableEvent(new SnmpTableEvent(this, null, n, n, -1, 2));
        }
    }

    public void refreshTable() {
        try {
            this.setTableOID(this.getTableOID());
        }
        catch (DataException dataException) {}
        this.startPollingTable();
    }

    public void removeSnmpTableListener(SnmpTableListener snmpTableListener) {
        if (!this.tableListeners.contains(snmpTableListener)) {
            System.out.println(SnmpUtils.getString("Error :No such Listener available"));
        }
        int n = 0;
        while (n < this.tableListeners.size()) {
            this.tableListeners.removeElement(snmpTableListener);
            ++n;
        }
    }

    public void run() {
        this.value = 0;
        this.holesCount = 0;
        this.hole = 0;
        if (this.oidList == null) {
            return;
        }
        SnmpOID[] snmpOIDArray = (SnmpOID[])this.oidList.clone();
        while (true) {
            try {
                while (true) {
                    Vector vector = null;
                    if (this.tableData != null) {
                        vector = (Vector)this.tableData.clone();
                    }
                    if (this.protocol == 1) {
                        if (this.targetHost != null && !this.targetHost.trim().equals("") && this.oidList != null && this.oidList[0] != null && this.nodes.size() != 0) {
                            this.performOperations();
                        }
                    } else if (this.options != null) {
                        this.performOperations();
                    }
                    this.genTableEvent(new SnmpTableEvent(this, null, -1, -1, -1, 3, true));
                    this.oidList = snmpOIDArray;
                    if (this.pollInterval <= 0) {
                        return;
                    }
                    Thread.sleep(this.pollInterval);
                }
            }
            catch (Exception exception) {
                System.err.println(String.valueOf(SnmpUtils.getString("Error in SnmpTable Bean :")) + " " + exception);
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void setCellValue(String string, Object object, int n, int n2) {
        try {
            this.setTableOIDWoStart(string);
        }
        catch (DataException dataException) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error :")) + " " + dataException);
        }
        if (this.columns == null) {
            return;
        }
        if (n2 < 0 || n2 > this.columns.size()) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error : ColumnIndex")) + " " + n2 + " " + SnmpUtils.getString("not found in Table"));
            return;
        }
        MibNode mibNode = (MibNode)this.nodes.elementAt(n2);
        if (mibNode.getSyntax().isEnumerated()) {
            if (!mibNode.getSyntax().getName().equals("BITS")) {
                if (object instanceof String && ((String)object).indexOf(40) != -1) {
                    object = ((String)object).substring(((String)object).indexOf(40) + 1, ((String)object).indexOf(41));
                }
            } else if (object instanceof String && ((String)object).indexOf(40) != -1) {
                object = ((String)object).substring(0, ((String)object).indexOf(40));
            }
        }
        try {
            Serializable serializable;
            SnmpVarBind[] snmpVarBindArray = this.getRow(n);
            if (snmpVarBindArray == null) {
                return;
            }
            if (object instanceof SnmpVarBind) {
                snmpVarBindArray[n2] = (SnmpVarBind)object;
            } else if (object instanceof SnmpVar) {
                snmpVarBindArray[n2].setVariable((SnmpVar)object);
            } else if (object instanceof String) {
                serializable = (MibNode)this.nodes.elementAt(n2);
                SnmpVar snmpVar = null;
                if (((MibNode)serializable).getSyntax().getType() == 6) {
                    MibNode mibNode2 = this.mibOps.getMibNode(this.mibOps.getSnmpOID((String)object));
                    if (mibNode2 == null) {
                        System.err.println(String.valueOf(SnmpUtils.getString("MibNode not available for the oid :")) + " " + object);
                        return;
                    }
                    String string2 = mibNode2.getNumberedOIDString();
                    if (string2 == null) {
                        System.err.println(String.valueOf(SnmpUtils.getString("Invalid data for table :")) + " " + object);
                        return;
                    }
                    snmpVar = ((MibNode)serializable).getSyntax().createVariable(string2);
                } else {
                    snmpVar = ((MibNode)serializable).getSyntax().createVariable((String)object);
                }
                if (snmpVar == null) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Invalid data for table :")) + " " + object);
                    return;
                }
                snmpVarBindArray[n2].setVariable(snmpVar);
            } else {
                System.err.println(String.valueOf(SnmpUtils.getString("Invalid data for table :")) + " " + object);
                return;
            }
            if (!this.performSets) {
                return;
            }
            serializable = new SnmpPDU();
            ((SnmpPDU)serializable).addVariableBinding(snmpVarBindArray[n2]);
            ((SnmpPDU)serializable).setCommand((byte)-93);
            serializable = this.getSNMPResponse((SnmpPDU)serializable);
            if (serializable == null) {
                System.err.println(String.valueOf(SnmpUtils.getString("Failed.")) + " " + this.getErrorString());
            } else if (((SnmpPDU)serializable).getVariable(0) == null || !((SnmpPDU)serializable).getVariable(0).toString().equals(snmpVarBindArray[n2].getVariable().toString())) {
                System.err.println(String.valueOf(SnmpUtils.getString("Set Failed.")) + " " + ((SnmpPDU)serializable).getVariable(0).toString());
            }
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(SnmpUtils.getString("Invalid data :")) + " " + object + ": " + exception);
        }
    }

    public void setColumnsPolled(Vector vector) {
        this.columnsPolled = vector;
    }

    public void setDataType(int n) {
        if (n < 0) {
            System.out.println(SnmpUtils.getString("Error : DataType cannot be negative"));
        } else if (n > 3) {
            System.out.println(SnmpUtils.getString("Error : No such DataType"));
        } else {
            this.DATA_TYPE = n;
        }
    }

    public void setObjectIDList(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.columns = new Vector();
        this.nodes = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            this.columns.addElement(stringArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.columns.size()) {
            this.nodes.addElement(this.mibOps.getMibNode(this.mibOps.getSnmpOID((String)this.columns.elementAt(n2))));
            ++n2;
        }
        MibNode mibNode = null;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        int n3 = 0;
        while (n3 < this.columns.size()) {
            mibNode = (MibNode)this.nodes.elementAt(n3);
            if (mibNode != null) {
                vector.addElement(this.columns.elementAt(n3));
                vector2.addElement(this.nodes.elementAt(n3));
            } else {
                System.out.println(SnmpUtils.getString("Error : Invalid Column OID"));
            }
            ++n3;
        }
        this.columns = vector;
        this.nodes = vector2;
        if (this.nodes.size() != 0) {
            while (this.columns.size() > 0) {
                mibNode = (MibNode)this.nodes.firstElement();
                if (mibNode.getAccess() == 43690 || mibNode.getAccess() == 43706) break;
                System.err.println(String.valueOf(SnmpUtils.getString("Column inaccessible.  Drop :")) + " " + mibNode);
                this.columns.removeElementAt(0);
                this.nodes.removeElementAt(0);
            }
            MibNode mibNode2 = null;
            this.columnNames = new String[this.columns.size()];
            this.editable = new boolean[this.columns.size()];
            int n4 = 0;
            while (n4 < this.columnNames.length) {
                this.columnNames[n4] = (String)this.columns.elementAt(n4);
                mibNode2 = (MibNode)this.nodes.elementAt(n4);
                if (mibNode2 == null) break;
                if (mibNode2.isWriteable()) {
                    this.editable[n4] = true;
                }
                ++n4;
            }
            if (mibNode2 != null) {
                super.setObjectIDList(this.columnNames);
                this.startPollingTable();
            }
        }
    }

    public void setParams(String string, String string2, String string3) {
        block4: {
            if (string != null) {
                this.setTargetHost(string);
            }
            if (string2 != null) {
                this.setMibModules(string2);
            }
            if (string3 == null) break block4;
            try {
                this.setTableOIDWoStart(string3);
            }
            catch (DataException dataException) {
                System.out.println(dataException);
            }
        }
    }

    public void setPollInterval(int n) {
        if (n < 0) {
            System.out.println(SnmpUtils.getString("Error : Polling interval cannot be negative"));
            return;
        }
        this.pollInterval = n * 1000;
    }

    public void setRetrievalMode(boolean bl) {
        this.RETRIEVAL_MODE = bl;
    }

    void setSuperObjectIDList(String[] stringArray) {
        super.setObjectIDList(stringArray);
    }

    public void setTableOID(String string) throws DataException {
        this.holesCount = 0;
        this.setTableOIDWoStart(string);
        super.setObjectIDList(this.columnNames);
        this.startPollingTable();
    }

    public void setTableOIDWoStart(String string) throws DataException {
        this.value = 0;
        MibModule mibModule = null;
        MibNode mibNode = null;
        Enumeration enumeration = this.getMibOperations().getMibModules();
        while (enumeration.hasMoreElements()) {
            mibModule = (MibModule)enumeration.nextElement();
            mibNode = mibModule.getMibNode(mibModule.getSnmpOID(string));
            if (mibNode != null && !mibNode.isImportedNode()) break;
        }
        if (mibModule != null) {
            this.tableOID = mibModule.getSnmpOID(string);
            if (this.tableOID == null) {
                return;
            }
            this.isName = this.mibOps.toString(this.tableOID).indexOf(string) == -1;
        }
        if (mibNode == null) {
            this.errorCode = 30;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            throw new DataException(SnmpUtils.getString("Error : MIB node unavailable for OID."));
        }
        this.columns = mibNode.getTableItems();
        if (this.columnsPolled != null) {
            this.adjustColumns();
        }
        if (this.columns == null || this.columns.size() == 0) {
            this.errorCode = 39;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            throw new DataException(String.valueOf(SnmpUtils.getString("Error: Invalid Table OID")) + " " + string);
        }
        Vector<MibNode> vector = new Vector<MibNode>();
        int n = 0;
        while (n < this.columns.size()) {
            vector.addElement(mibModule.getMibNodeByName((String)this.columns.elementAt(n)));
            ++n;
        }
        this.nodes = (Vector)vector.clone();
        vector = null;
        while (this.columns.size() > 0) {
            MibNode mibNode2 = (MibNode)this.nodes.firstElement();
            if (mibNode2.getAccess() == 43690 || mibNode2.getAccess() == 43706) break;
            System.err.println(String.valueOf(SnmpUtils.getString("Column inaccessible.  Drop :")) + " " + mibNode2);
            this.cnam.addElement(this.columns.elementAt(0));
            this.columns.removeElementAt(0);
            this.nodes.removeElementAt(0);
            ++this.check;
        }
        this.columnNames = new String[this.columns.size()];
        this.editable = new boolean[this.columns.size()];
        int n2 = 0;
        while (n2 < this.columnNames.length) {
            this.columnNames[n2] = (String)this.columns.elementAt(n2);
            MibNode mibNode3 = (MibNode)this.nodes.elementAt(n2);
            if (mibNode3 != null && mibNode3.isWriteable()) {
                this.editable[n2] = true;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.nodes.size()) {
            String string2;
            if (this.nodes.elementAt(n3) != null && ((string2 = ((MibNode)this.nodes.elementAt(n3)).getSyntax().toString()).equals("RowStatus") || string2.equals("EntryStatus"))) {
                if (string2.equals("EntryStatus")) {
                    this.isEntryStatus = true;
                }
                this.isRowAddAndDel = true;
                this.ADDandDELcol = n3;
            }
            ++n3;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        MibNode mibNode = (MibNode)this.nodes.elementAt(n2);
        if (mibNode.getSyntax().isEnumerated()) {
            if (!mibNode.getSyntax().getName().equals("BITS")) {
                if (object instanceof String && ((String)object).indexOf(40) != -1) {
                    object = ((String)object).substring(((String)object).indexOf(40) + 1, ((String)object).indexOf(41));
                }
            } else if (object instanceof String && ((String)object).indexOf(40) != -1) {
                object = ((String)object).substring(0, ((String)object).indexOf(40));
            }
        }
        try {
            Serializable serializable;
            if (object instanceof SnmpVarBind) {
                this.getRowFromArray((int)n)[n2] = (SnmpVarBind)object;
            } else if (object instanceof SnmpVar) {
                this.getRowFromArray(n)[n2].setVariable((SnmpVar)object);
            } else if (object instanceof String) {
                serializable = (MibNode)this.nodes.elementAt(n2);
                SnmpVar snmpVar = null;
                if (((MibNode)serializable).getSyntax().getType() == 6) {
                    MibNode mibNode2 = this.mibOps.getMibNode(this.mibOps.getSnmpOID((String)object));
                    if (mibNode2 == null) {
                        System.err.println(String.valueOf(SnmpUtils.getString("MibNode not available for the oid :")) + " " + object);
                        return;
                    }
                    String string = mibNode2.getNumberedOIDString();
                    if (string == null) {
                        System.err.println(String.valueOf(SnmpUtils.getString("Invalid data for table :")) + " " + object);
                        return;
                    }
                    snmpVar = ((MibNode)serializable).getSyntax().createVariable(string);
                } else {
                    snmpVar = ((MibNode)serializable).getSyntax().createVariable((String)object);
                }
                if (snmpVar == null) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Invalid data for table :")) + " " + object);
                    return;
                }
                this.getRowFromArray(n)[n2].setVariable(snmpVar);
            } else {
                System.err.println(String.valueOf(SnmpUtils.getString("Invalid data for table :")) + " " + object);
                return;
            }
            if (!this.performSets) {
                return;
            }
            serializable = new SnmpPDU();
            ((SnmpPDU)serializable).addVariableBinding(this.getRowFromArray(n)[n2]);
            ((SnmpPDU)serializable).setCommand((byte)-93);
            serializable = this.getSNMPResponse((SnmpPDU)serializable);
            if (serializable == null) {
                this.showErrorMessage(String.valueOf(SnmpUtils.getString("Failed.")) + " " + this.getErrorString());
            } else if (((SnmpPDU)serializable).getVariable(0) == null || !((SnmpPDU)serializable).getVariable(0).toString().equals(this.getRowFromArray(n)[n2].getVariable().toString())) {
                this.showErrorMessage(String.valueOf(SnmpUtils.getString("Set Failed.")) + " " + ((SnmpPDU)serializable).getVariable(0).toString());
            }
        }
        catch (Exception exception) {
            this.showErrorMessage(String.valueOf(SnmpUtils.getString("Invalid data :")) + " " + object + ": " + exception);
        }
    }

    protected void showErrorMessage(String string) {
        System.err.println(string);
    }

    public void startPollingTable() {
        if (this.thisThread != null && this.thisThread.isAlive()) {
            this.thisThread.stop();
        }
        this.thisThread = null;
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void stopPollingTable() {
        this.setPollInterval(0);
        try {
            if (this.thisThread != null) {
                this.thisThread.stop();
                this.thisThread = null;
            }
        }
        catch (Exception exception) {}
    }
}

