/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.beans;

import com.adventnet.snmp.beans.DataException;
import com.adventnet.snmp.beans.ErrorMessages;
import com.adventnet.snmp.beans.ResultListener;
import com.adventnet.snmp.beans.SnmpPropertyChangeEvent;
import com.adventnet.snmp.beans.SnmpPropertyListener;
import com.adventnet.snmp.beans.SnmpServer;
import com.adventnet.snmp.mibs.MibException;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.snmp2.ProtocolOptions;
import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.snmp.snmp2.SnmpVarBind;
import com.adventnet.utils.LogInterface;
import com.adventnet.utils.LogManager;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SnmpTarget
extends SnmpServer
implements VetoableChangeListener {
    String mibModules = "";
    Vector debugListeners;
    public static final byte SNMPGET = -96;
    public static final byte SNMPGETNEXT = -95;
    public static final byte SNMPRESPONSE = -94;
    public static final byte SNMPSET = -93;
    public static final byte SNMPTRAP = -92;
    public static final int VERSION1 = 0;

    public SnmpTarget() {
    }

    public SnmpTarget(int n, ProtocolOptions protocolOptions) {
        super(n, protocolOptions);
    }

    public SnmpTarget(int n, String string) {
        super(n, string);
    }

    public SnmpTarget(Applet applet) {
        super(applet);
    }

    public SnmpTarget(Applet applet, int n, String string) {
        super(applet, n, string);
    }

    public void addLogClient(LogInterface logInterface) {
        this.clientID = LogManager.addLogClient(logInterface);
    }

    public int addObjectID(String string) {
        if (this.oidList == null) {
            this.oidList = new SnmpOID[1];
            this.oidList[0] = this.mibOps.getSnmpOID(string);
        } else {
            SnmpOID[] snmpOIDArray = this.oidList;
            this.oidList = new SnmpOID[snmpOIDArray.length + 1];
            System.arraycopy(snmpOIDArray, 0, this.oidList, 0, snmpOIDArray.length);
            this.oidList[snmpOIDArray.length] = this.mibOps.getSnmpOID(string);
        }
        return this.oidList.length - 1;
    }

    public void addResultListener(ResultListener resultListener) {
        this.listeners.addElement(resultListener);
    }

    public int addSnmpOID(SnmpOID snmpOID) {
        if (this.oidList == null) {
            this.oidList = new SnmpOID[1];
            this.oidList[0] = snmpOID;
        } else {
            SnmpOID[] snmpOIDArray = this.oidList;
            this.oidList = new SnmpOID[snmpOIDArray.length + 1];
            System.arraycopy(snmpOIDArray, 0, this.oidList, 0, snmpOIDArray.length);
            this.oidList[snmpOIDArray.length] = snmpOID;
        }
        return this.oidList.length - 1;
    }

    public void addSnmpPropertyListener(SnmpPropertyListener snmpPropertyListener) {
        this.propertylisteners.addElement(snmpPropertyListener);
    }

    protected void genEvent(SnmpPDU snmpPDU) {
        super.genEvent(snmpPDU);
    }

    protected void genTimeoutEvent(SnmpPDU snmpPDU) {
        super.genTimeoutEvent(snmpPDU);
    }

    public boolean getAttemptComplete() {
        return this.attemptCompleteData;
    }

    public boolean getAttemptPartial() {
        return this.attemptPartialData;
    }

    public String getCommunity() {
        return this.community;
    }

    public boolean getDebug() {
        return this.api.getDebug();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getErrorIndex() {
        return this.errorIndex;
    }

    public String getErrorString() {
        return this.error;
    }

    public boolean getIgnoreSpecificControlCodes() {
        return this.mibOps.getIgnoreSpecificControlCodes();
    }

    public int getMaxNumRows() {
        return this.MAX_NUM_ROWS;
    }

    public String getMibModules() {
        String string = new String();
        Enumeration enumeration = this.getMibOperations().getMibModuleNames();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + " " + enumeration.nextElement();
        }
        return string;
    }

    public MibOperations getMibOperations() {
        return this.mibOps;
    }

    public String getObjectID() {
        if (this.oidList == null) {
            return null;
        }
        if (this.isName) {
            return this.mibOps.toString(this.oidList[0]);
        }
        return this.oidList[0].toString();
    }

    public String getObjectID(int n) {
        if (n < 0 || n > this.oidList.length) {
            System.out.println(SnmpUtils.getString("Error : No such index exists"));
            return null;
        }
        if (this.oidList == null) {
            return null;
        }
        return this.mibOps.toString(this.oidList[n]);
    }

    public String[] getObjectIDList() {
        if (this.oidList == null) {
            return null;
        }
        String[] stringArray = new String[this.oidList.length];
        int n = 0;
        while (n < this.oidList.length) {
            stringArray[n] = this.isName ? this.mibOps.toString(this.oidList[n]) : this.oidList[n].toString();
            ++n;
        }
        return stringArray;
    }

    public int getRetries() {
        return this.retries;
    }

    public boolean getSendTimeoutEvents() {
        return this.sendTimeoutEvents;
    }

    public SnmpOID getSnmpOID() {
        if (this.oidList == null) {
            return null;
        }
        return this.oidList[0];
    }

    public SnmpOID[] getSnmpOIDList() {
        if (this.oidList == null) {
            return null;
        }
        return this.oidList;
    }

    SnmpVar[] getSnmpVariables(String[] stringArray) throws DataException {
        SnmpVar[] snmpVarArray = null;
        if (stringArray != null) {
            snmpVarArray = new SnmpVar[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                if (this.oidList == null || this.oidList[n] == null) {
                    this.errorCode = 21;
                    this.error = ErrorMessages.getErrorString(this.errorCode);
                    throw new DataException(SnmpUtils.getString("Error : OID not specified"));
                }
                MibNode mibNode = this.mibOps.getMibNode(this.oidList[n]);
                if (mibNode == null) {
                    this.errorCode = 30;
                    this.error = ErrorMessages.getErrorString(this.errorCode);
                    throw new DataException(String.valueOf(SnmpUtils.getString("Error : MIB node unavailable for OID.")) + this.oidList[n]);
                }
                if (mibNode.getSyntax() == null) {
                    this.errorCode = 31;
                    this.error = ErrorMessages.getErrorString(this.errorCode);
                    throw new DataException(String.valueOf(SnmpUtils.getString("Error : OID not a leaf node.")) + this.oidList[n]);
                }
                try {
                    SnmpVar snmpVar;
                    snmpVarArray[n] = snmpVar = mibNode.getSyntax().createVariable(stringArray[n]);
                }
                catch (SnmpException snmpException) {
                    this.errorCode = 32;
                    this.error = ErrorMessages.getErrorString(this.errorCode);
                    throw new DataException(SnmpUtils.getString("Error : Creating variable."));
                }
                ++n;
            }
        }
        return snmpVarArray;
    }

    public String getTargetHost() {
        return this.targetHost;
    }

    public int getTargetPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout / 1000;
    }

    public int getVarBindCount() {
        return this.varbinds_per_request;
    }

    public String getWriteCommunity() {
        return this.writeCommunity;
    }

    public static boolean isInSubTree(SnmpOID snmpOID, SnmpOID snmpOID2) {
        int[] nArray = (int[])snmpOID.toValue();
        return SnmpTarget.isInSubTree(nArray, snmpOID2);
    }

    static boolean isInSubTree(int[] nArray, SnmpOID snmpOID) {
        int[] nArray2 = (int[])snmpOID.toValue();
        if (nArray2 == null) {
            return false;
        }
        if (nArray2.length < nArray.length) {
            return false;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray2[n] != nArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void loadMibs(String string) throws MibException, IOException, FileNotFoundException {
        if (SnmpServer.applet != null) {
            this.mibOps.loadMibModules(SnmpServer.applet, string);
        } else {
            this.mibOps.loadMibModules(string);
        }
        this.mibModules = string;
    }

    public void removeResultListener(ResultListener resultListener) {
        int n = 0;
        while (n < this.listeners.size()) {
            if (this.listeners.elementAt(n) == resultListener) {
                this.listeners.removeElement(resultListener);
            } else {
                System.out.println(SnmpUtils.getString("Error :No such Listener available"));
            }
            ++n;
        }
    }

    public void removeSnmpPropertyListener(SnmpPropertyListener snmpPropertyListener) {
        int n = 0;
        while (n < this.propertylisteners.size()) {
            if (this.propertylisteners.elementAt(n) == snmpPropertyListener) {
                this.propertylisteners.removeElement(snmpPropertyListener);
            } else {
                System.out.println(SnmpUtils.getString("Error :No such Listener available"));
            }
            ++n;
        }
    }

    public void setAttemptComplete(boolean bl) {
        this.attemptCompleteData = bl;
    }

    public void setAttemptPartial(boolean bl) {
        this.attemptPartialData = bl;
    }

    public void setCommunity(String string) {
        if (this.community != null && this.community.equals(string)) {
            return;
        }
        this.community = string;
        SnmpPropertyChangeEvent snmpPropertyChangeEvent = new SnmpPropertyChangeEvent(this, SnmpPropertyChangeEvent.COMMUNITY, this.community);
        Enumeration enumeration = this.propertylisteners.elements();
        while (enumeration.hasMoreElements()) {
            SnmpPropertyListener snmpPropertyListener = (SnmpPropertyListener)enumeration.nextElement();
            snmpPropertyListener.snmpPropertyChanged(snmpPropertyChangeEvent);
        }
    }

    public void setDebug(boolean bl) {
        this.api.setDebug(bl);
    }

    public void setIgnoreSpecificControlCodes(boolean bl) {
        this.mibOps.setIgnoreSpecificControlCodes(bl);
    }

    public void setMaxNumRows(int n) {
        this.MAX_NUM_ROWS = n;
    }

    public void setMibModules(String string) {
        this.mibModules = string;
        this.updateMibs();
    }

    public void setObjectID(int n, String string) {
        if (this.oidList != null && n < this.oidList.length) {
            this.oidList[n] = this.mibOps.getSnmpOID(string);
        }
    }

    public void setObjectID(String string) {
        SnmpOID snmpOID = this.mibOps.getSnmpOID(string);
        if (snmpOID != null) {
            this.isName = snmpOID.toString().indexOf(string) == -1;
        }
        if (this.oidList != null && this.oidList.length == 1 && this.oidList[0] != null && this.oidList[0].equals(snmpOID)) {
            return;
        }
        this.oidList = snmpOID == null ? null : new SnmpOID[]{snmpOID};
        if (this.oidList != null) {
            SnmpPropertyChangeEvent snmpPropertyChangeEvent = new SnmpPropertyChangeEvent(this, SnmpPropertyChangeEvent.OBJECTID, this.oidList[0]);
            Enumeration enumeration = this.propertylisteners.elements();
            while (enumeration.hasMoreElements()) {
                SnmpPropertyListener snmpPropertyListener = (SnmpPropertyListener)enumeration.nextElement();
                snmpPropertyListener.snmpPropertyChanged(snmpPropertyChangeEvent);
            }
        }
    }

    public void setObjectIDList(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.oidList = null;
            return;
        }
        this.oidList = new SnmpOID[stringArray.length];
        int n = 0;
        while (n < this.oidList.length) {
            SnmpOID snmpOID = this.mibOps.getSnmpOID(stringArray[n]);
            if (snmpOID != null) {
                this.isName = snmpOID.toString().indexOf(stringArray[n]) == -1;
            }
            this.oidList[n] = snmpOID;
            ++n;
        }
    }

    public void setParams(String string, String string2, String string3, String string4, String string5) {
        if (string != null) {
            this.setTargetHost(string);
        }
        if (string2 != null) {
            this.setTargetPort(Integer.parseInt(string2));
        }
        if (string3 != null) {
            this.setCommunity(string3);
        }
        if (string4 != null) {
            this.setMibModules(string4);
        }
        if (string5 != null) {
            this.setObjectID(string5);
        }
    }

    public void setParams(String string, String string2, String string3, String string4, String[] stringArray) {
        if (string != null) {
            this.setTargetHost(string);
        }
        if (string2 != null) {
            this.setTargetPort(Integer.parseInt(string2));
        }
        if (string3 != null) {
            this.setCommunity(string3);
        }
        if (string4 != null) {
            this.setMibModules(string4);
        }
        if (stringArray != null) {
            this.setObjectIDList(stringArray);
        }
    }

    public void setRetries(int n) {
        if (this.retries == n) {
            return;
        }
        this.retries = n;
        SnmpPropertyChangeEvent snmpPropertyChangeEvent = new SnmpPropertyChangeEvent(this, SnmpPropertyChangeEvent.RETRIES, new Integer(this.retries));
        Enumeration enumeration = this.propertylisteners.elements();
        while (enumeration.hasMoreElements()) {
            SnmpPropertyListener snmpPropertyListener = (SnmpPropertyListener)enumeration.nextElement();
            snmpPropertyListener.snmpPropertyChanged(snmpPropertyChangeEvent);
        }
    }

    public void setSendTimeoutEvents(boolean bl) {
        this.sendTimeoutEvents = bl;
    }

    public void setSnmpOID(SnmpOID snmpOID) {
        this.oidList = new SnmpOID[1];
        this.oidList[0] = snmpOID;
    }

    public void setSnmpOIDList(SnmpOID[] snmpOIDArray) {
        this.oidList = snmpOIDArray == null || snmpOIDArray.length == 0 ? null : snmpOIDArray;
    }

    public void setTargetHost(String string) {
        if (this.targetHost != null && this.targetHost.equals(string)) {
            return;
        }
        this.targetHost = string;
        SnmpPropertyChangeEvent snmpPropertyChangeEvent = new SnmpPropertyChangeEvent(this, SnmpPropertyChangeEvent.HOSTNAME, this.targetHost);
        Enumeration enumeration = this.propertylisteners.elements();
        while (enumeration.hasMoreElements()) {
            SnmpPropertyListener snmpPropertyListener = (SnmpPropertyListener)enumeration.nextElement();
            snmpPropertyListener.snmpPropertyChanged(snmpPropertyChangeEvent);
        }
    }

    public void setTargetPort(int n) {
        if (this.port == n) {
            return;
        }
        this.port = n;
        SnmpPropertyChangeEvent snmpPropertyChangeEvent = new SnmpPropertyChangeEvent(this, SnmpPropertyChangeEvent.PORT, new Integer(this.port));
        Enumeration enumeration = this.propertylisteners.elements();
        while (enumeration.hasMoreElements()) {
            SnmpPropertyListener snmpPropertyListener = (SnmpPropertyListener)enumeration.nextElement();
            snmpPropertyListener.snmpPropertyChanged(snmpPropertyChangeEvent);
        }
    }

    public void setTimeout(int n) {
        if (this.timeout == n * 1000) {
            return;
        }
        this.timeout = n * 1000;
        SnmpPropertyChangeEvent snmpPropertyChangeEvent = new SnmpPropertyChangeEvent(this, SnmpPropertyChangeEvent.TIMEOUT, new Integer(n));
        Enumeration enumeration = this.propertylisteners.elements();
        while (enumeration.hasMoreElements()) {
            SnmpPropertyListener snmpPropertyListener = (SnmpPropertyListener)enumeration.nextElement();
            snmpPropertyListener.snmpPropertyChanged(snmpPropertyChangeEvent);
        }
    }

    public void setVarBindCount(int n) {
        this.varbinds_per_request = n;
    }

    public void setWriteCommunity(String string) {
        if (this.writeCommunity != null && this.writeCommunity.equals(string)) {
            return;
        }
        this.writeCommunity = string;
        SnmpPropertyChangeEvent snmpPropertyChangeEvent = new SnmpPropertyChangeEvent(this, SnmpPropertyChangeEvent.WRITECOMMUNITY, this.writeCommunity);
        Enumeration enumeration = this.propertylisteners.elements();
        while (enumeration.hasMoreElements()) {
            SnmpPropertyListener snmpPropertyListener = (SnmpPropertyListener)enumeration.nextElement();
            snmpPropertyListener.snmpPropertyChanged(snmpPropertyChangeEvent);
        }
    }

    public String snmpGet() {
        SnmpVarBind snmpVarBind = this.snmpGetVariableBinding();
        if (snmpVarBind == null) {
            return null;
        }
        SnmpVar snmpVar = snmpVarBind.getVariable();
        if (snmpVar != null) {
            return this.mibOps.toString(snmpVar, snmpVarBind.getObjectID());
        }
        return null;
    }

    public SnmpVar snmpGet(SnmpOID snmpOID) {
        if (snmpOID != null) {
            SnmpOID[] snmpOIDArray = new SnmpOID[]{snmpOID};
            SnmpPDU snmpPDU = this.getSNMPResponse(snmpOIDArray, null, (byte)-96);
            if (snmpPDU == null) {
                return null;
            }
            if (snmpPDU.getVariableBindings().size() <= 0) {
                this.errorCode = 24;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                return null;
            }
            SnmpVarBind snmpVarBind = snmpPDU.getVariableBinding(0);
            SnmpVar snmpVar = snmpVarBind.getVariable();
            this.genEvent(snmpPDU);
            return snmpVar;
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return null;
    }

    public String[][] snmpGetAllList() {
        SnmpVarBind[][] snmpVarBindArray = this.snmpGetAllVariableBindings();
        if (snmpVarBindArray == null) {
            return null;
        }
        String[][] stringArray = new String[snmpVarBindArray.length][snmpVarBindArray[0].length];
        int n = 0;
        while (n < snmpVarBindArray.length) {
            SnmpVarBind[] snmpVarBindArray2 = snmpVarBindArray[n];
            if (snmpVarBindArray2 != null) {
                stringArray[n] = new String[snmpVarBindArray2.length];
                int n2 = 0;
                while (n2 < snmpVarBindArray2.length) {
                    if (snmpVarBindArray2[n2] != null) {
                        stringArray[n][n2] = this.mibOps.toString(snmpVarBindArray2[n2].getVariable(), snmpVarBindArray2[n2].getObjectID());
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return stringArray;
    }

    /*
     * Unable to fully structure code
     */
    public SnmpVarBind[][] snmpGetAllVariableBindings() {
        block13: {
            block12: {
                if (this.oidList == null || this.oidList.length <= 0) break block13;
                var1_1 = new SnmpOID[this.oidList.length];
                var2_2 = 0;
                while (var2_2 < this.oidList.length) {
                    var1_1[var2_2] = this.oidList[var2_2];
                    ++var2_2;
                }
                var3_3 = null;
                try {
                    var3_3 = SnmpVar.createVariable("", (byte)4);
                }
                catch (Exception v0) {}
                var4_4 = 0;
                if (this.oidList[0] == null) break block13;
                var5_5 = (int[])this.oidList[0].toValue();
                var6_6 = new Vector<SnmpVarBind[]>();
                if (this.MAX_NUM_ROWS != 1000) ** GOTO lbl39
                while (var4_4++ < this.MAX_NUM_ROWS) {
                    var7_7 = this.snmpGetNextVariableBindings();
                    if (var7_7 != null && SnmpTarget.isInSubTree(var5_5, this.oidList[0])) {
                        var8_8 = 0;
                        while (var8_8 < var7_7.length) {
                            if (!SnmpTarget.isInSubTree(var1_1[var8_8], this.oidList[var8_8])) {
                                var7_7[var8_8].setVariable(var3_3);
                            }
                            ++var8_8;
                        }
                        var6_6.addElement(var7_7);
                        continue;
                    }
                    break block12;
                }
                break block12;
                while ((var7_7 = this.snmpGetNextVariableBindings()) != null && SnmpTarget.isInSubTree(var5_5, this.oidList[0])) {
                    var8_8 = 0;
                    while (var8_8 < var7_7.length) {
                        if (!SnmpTarget.isInSubTree(var1_1[var8_8], this.oidList[var8_8])) {
                            var7_7[var8_8].setVariable(var3_3);
                        }
                        ++var8_8;
                    }
                    var6_6.addElement(var7_7);
lbl39:
                    // 2 sources

                    if (var4_4++ < this.MAX_NUM_ROWS) continue;
                }
            }
            if (var6_6.size() == 0) {
                return null;
            }
            var7_7 = new SnmpVarBind[var6_6.size()][];
            var8_8 = 0;
            while (var8_8 < var6_6.size()) {
                var7_7[var8_8] = (SnmpVarBind[])var6_6.elementAt(var8_8);
                ++var8_8;
            }
            return var7_7;
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return null;
    }

    public SnmpVar[][] snmpGetAllVariables() {
        SnmpVarBind[][] snmpVarBindArray = this.snmpGetAllVariableBindings();
        if (snmpVarBindArray == null) {
            return null;
        }
        SnmpVar[][] snmpVarArray = new SnmpVar[snmpVarBindArray.length][snmpVarBindArray[0].length];
        int n = 0;
        while (n < snmpVarBindArray.length) {
            SnmpVarBind[] snmpVarBindArray2 = snmpVarBindArray[n];
            if (snmpVarBindArray2 != null) {
                snmpVarArray[n] = new SnmpVar[snmpVarBindArray2.length];
                int n2 = 0;
                while (n2 < snmpVarBindArray2.length) {
                    snmpVarArray[n][n2] = snmpVarBindArray2[n2] == null ? null : snmpVarBindArray2[n2].getVariable();
                    ++n2;
                }
            }
            ++n;
        }
        return snmpVarArray;
    }

    public String[] snmpGetList() {
        SnmpVarBind[] snmpVarBindArray = this.snmpGetVariableBindings();
        if (snmpVarBindArray != null) {
            String[] stringArray = new String[snmpVarBindArray.length];
            int n = 0;
            while (n < snmpVarBindArray.length) {
                SnmpVar snmpVar;
                if (snmpVarBindArray[n] != null && (snmpVar = snmpVarBindArray[n].getVariable()) != null) {
                    stringArray[n] = this.mibOps.toString(snmpVar, snmpVarBindArray[n].getObjectID());
                }
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public SnmpVar[] snmpGetList(SnmpOID[] snmpOIDArray) {
        if (snmpOIDArray != null && snmpOIDArray.length > 0) {
            SnmpPDU snmpPDU = this.getSNMPResponse(snmpOIDArray, null, (byte)-96);
            if (snmpPDU == null) {
                return null;
            }
            if (snmpPDU.getVariableBindings().size() <= 0) {
                this.errorCode = 24;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                return null;
            }
            SnmpVar[] snmpVarArray = new SnmpVar[snmpPDU.getVariableBindings().size()];
            SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[snmpVarArray.length];
            int n = 0;
            Enumeration enumeration = snmpPDU.getVariableBindings().elements();
            while (enumeration.hasMoreElements()) {
                snmpVarBindArray[n] = (SnmpVarBind)enumeration.nextElement();
                snmpVarArray[n] = snmpVarBindArray[n] == null ? null : snmpVarBindArray[n].getVariable();
                ++n;
            }
            this.genEvent(snmpPDU);
            return snmpVarArray;
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return null;
    }

    public String snmpGetNext() {
        SnmpVarBind snmpVarBind = this.snmpGetNextVariableBinding();
        if (snmpVarBind == null) {
            return null;
        }
        SnmpVar snmpVar = snmpVarBind.getVariable();
        if (snmpVar != null) {
            return this.mibOps.toString(snmpVar, snmpVarBind.getObjectID());
        }
        return null;
    }

    public SnmpVar snmpGetNext(SnmpOID snmpOID) {
        if (snmpOID != null) {
            SnmpOID[] snmpOIDArray = new SnmpOID[]{snmpOID};
            SnmpPDU snmpPDU = this.getSNMPResponse(snmpOIDArray, null, (byte)-95);
            if (snmpPDU == null) {
                return null;
            }
            if (snmpPDU.getVariableBindings().size() <= 0) {
                this.errorCode = 24;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                return null;
            }
            SnmpVarBind snmpVarBind = snmpPDU.getVariableBinding(0);
            SnmpVar snmpVar = snmpVarBind.getVariable();
            this.genEvent(snmpPDU);
            return snmpVar;
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return null;
    }

    public String[] snmpGetNextList() {
        SnmpVarBind[] snmpVarBindArray = this.snmpGetNextVariableBindings();
        if (snmpVarBindArray != null) {
            String[] stringArray = new String[snmpVarBindArray.length];
            int n = 0;
            while (n < snmpVarBindArray.length) {
                SnmpVar snmpVar;
                if (snmpVarBindArray[n] != null && (snmpVar = snmpVarBindArray[n].getVariable()) != null) {
                    stringArray[n] = this.mibOps.toString(snmpVar, snmpVarBindArray[n].getObjectID());
                }
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public SnmpVar[] snmpGetNextList(SnmpOID[] snmpOIDArray) {
        if (snmpOIDArray != null && snmpOIDArray.length > 0) {
            SnmpPDU snmpPDU = this.getSNMPResponse(snmpOIDArray, null, (byte)-95);
            if (snmpPDU == null) {
                return null;
            }
            if (snmpPDU.getVariableBindings().size() <= 0) {
                this.errorCode = 24;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                return null;
            }
            SnmpVar[] snmpVarArray = new SnmpVar[snmpPDU.getVariableBindings().size()];
            SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[snmpVarArray.length];
            int n = 0;
            Enumeration enumeration = snmpPDU.getVariableBindings().elements();
            while (enumeration.hasMoreElements()) {
                snmpVarBindArray[n] = (SnmpVarBind)enumeration.nextElement();
                snmpVarArray[n] = snmpVarBindArray[n] == null ? null : snmpVarBindArray[n].getVariable();
                ++n;
            }
            this.genEvent(snmpPDU);
            return snmpVarArray;
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return null;
    }

    public SnmpVar snmpGetNextVariable() {
        SnmpVarBind snmpVarBind = this.snmpGetNextVariableBinding();
        if (snmpVarBind != null) {
            return snmpVarBind.getVariable();
        }
        return null;
    }

    public SnmpVarBind snmpGetNextVariableBinding() {
        if (this.oidList != null && this.oidList.length > 0) {
            SnmpPDU snmpPDU = this.getSNMPResponse((byte)-95);
            if (snmpPDU == null) {
                return null;
            }
            if (snmpPDU.getVariableBindings().size() <= 0) {
                this.errorCode = 24;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                return null;
            }
            SnmpVarBind snmpVarBind = snmpPDU.getVariableBinding(0);
            this.oidList[0] = snmpVarBind.getObjectID();
            if (this.varList == null) {
                this.varList = new SnmpVar[1];
            }
            this.varList[0] = snmpVarBind.getVariable();
            this.genEvent(snmpPDU);
            return snmpVarBind;
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return null;
    }

    public SnmpVarBind[] snmpGetNextVariableBindings() {
        if (this.oidList != null && this.oidList.length > 0) {
            SnmpPDU snmpPDU = this.getSNMPResponse((byte)-95);
            if (snmpPDU == null) {
                return null;
            }
            int n = snmpPDU.getVariableBindings().size();
            if (n <= 0) {
                this.errorCode = 24;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                return null;
            }
            SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n];
            this.oidList = new SnmpOID[n];
            this.varList = new SnmpVar[n];
            int n2 = 0;
            Enumeration enumeration = snmpPDU.getVariableBindings().elements();
            while (enumeration.hasMoreElements()) {
                snmpVarBindArray[n2] = (SnmpVarBind)enumeration.nextElement();
                this.oidList[n2] = snmpVarBindArray[n2].getObjectID();
                this.varList[n2] = snmpVarBindArray[n2].getVariable();
                ++n2;
            }
            this.genEvent(snmpPDU);
            return snmpVarBindArray;
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return null;
    }

    public SnmpVar[] snmpGetNextVariables() {
        SnmpVarBind[] snmpVarBindArray = this.snmpGetNextVariableBindings();
        if (snmpVarBindArray != null) {
            SnmpVar[] snmpVarArray = new SnmpVar[snmpVarBindArray.length];
            int n = 0;
            while (n < snmpVarBindArray.length) {
                snmpVarArray[n] = snmpVarBindArray[n] == null ? null : snmpVarBindArray[n].getVariable();
                ++n;
            }
            return snmpVarArray;
        }
        return null;
    }

    public SnmpVar snmpGetVariable() {
        SnmpVarBind snmpVarBind = this.snmpGetVariableBinding();
        if (snmpVarBind != null) {
            return snmpVarBind.getVariable();
        }
        return null;
    }

    public SnmpVarBind snmpGetVariableBinding() {
        if (this.oidList != null && this.oidList.length > 0) {
            SnmpPDU snmpPDU = this.getSNMPResponse((byte)-96);
            if (snmpPDU == null) {
                return null;
            }
            if (snmpPDU.getVariableBindings().size() <= 0) {
                this.errorCode = 24;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                return null;
            }
            SnmpVarBind snmpVarBind = snmpPDU.getVariableBinding(0);
            if (this.varList == null) {
                this.varList = new SnmpVar[1];
            }
            this.varList[0] = snmpVarBind.getVariable();
            this.genEvent(snmpPDU);
            return snmpVarBind;
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return null;
    }

    public SnmpVarBind[] snmpGetVariableBindings() {
        if (this.oidList != null && this.oidList.length > 0) {
            SnmpPDU snmpPDU = this.getSNMPResponse((byte)-96);
            if (snmpPDU == null) {
                return null;
            }
            if (snmpPDU.getVariableBindings().size() <= 0) {
                this.errorCode = 24;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                return null;
            }
            SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[snmpPDU.getVariableBindings().size()];
            this.varList = new SnmpVar[snmpPDU.getVariableBindings().size()];
            int n = 0;
            Enumeration enumeration = snmpPDU.getVariableBindings().elements();
            while (enumeration.hasMoreElements()) {
                snmpVarBindArray[n] = (SnmpVarBind)enumeration.nextElement();
                this.oidList[n] = snmpVarBindArray[n].getObjectID();
                this.varList[n] = snmpVarBindArray[n].getVariable();
                ++n;
            }
            this.genEvent(snmpPDU);
            return snmpVarBindArray;
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return null;
    }

    public SnmpVar[] snmpGetVariables() {
        SnmpVarBind[] snmpVarBindArray = this.snmpGetVariableBindings();
        if (snmpVarBindArray != null) {
            SnmpVar[] snmpVarArray = new SnmpVar[snmpVarBindArray.length];
            int n = 0;
            while (n < snmpVarBindArray.length) {
                snmpVarArray[n] = snmpVarBindArray[n] == null ? null : snmpVarBindArray[n].getVariable();
                ++n;
            }
            return snmpVarArray;
        }
        return null;
    }

    public void snmpSendTrap(SnmpOID snmpOID, String string, int n, int n2, long l, SnmpVar[] snmpVarArray) throws DataException {
        int n3 = 0;
        SnmpPDU snmpPDU = new SnmpPDU();
        snmpPDU.setCommand((byte)-92);
        snmpPDU.setEnterprise(snmpOID);
        try {
            snmpPDU.setAgentAddress(InetAddress.getByName(string));
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(SnmpUtils.getString("Cannot set agent address in trap. ")) + " " + exception);
        }
        snmpPDU.setTrapType(n);
        snmpPDU.setSpecificType(n2);
        snmpPDU.setUpTime(l);
        if (this.oidList != null && this.oidList.length > 0 && snmpVarArray != null && snmpVarArray.length > 0) {
            int n4 = 0;
            while (n4 < this.oidList.length) {
                if (snmpVarArray.length <= n4) break;
                snmpPDU.addNull(this.oidList[n4]);
                snmpPDU.setVariable(n4 + n3, snmpVarArray[n4]);
                ++n4;
            }
        }
        this.getSNMPResponse(snmpPDU);
    }

    public void snmpSendTrap(String string, String string2, int n, int n2, long l, String[] stringArray) throws DataException {
        SnmpVar[] snmpVarArray = this.getSnmpVariables(stringArray);
        this.snmpSendTrap(this.mibOps.getSnmpOID(string), string2, n, n2, l, snmpVarArray);
    }

    public String snmpSet(String string) throws DataException {
        if (this.oidList == null || this.oidList[0] == null) {
            this.errorCode = 21;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            throw new DataException(SnmpUtils.getString("Error : OID not specified"));
        }
        MibNode mibNode = this.mibOps.getMibNode(this.oidList[0]);
        if (mibNode == null) {
            this.errorCode = 30;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            throw new DataException(SnmpUtils.getString("Error : MIB node unavailable for OID."));
        }
        if (mibNode.getSyntax() == null) {
            this.errorCode = 31;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            throw new DataException(SnmpUtils.getString("Error : OID not a leaf node "));
        }
        try {
            SnmpVar snmpVar = mibNode.getSyntax().createVariable(string);
            snmpVar = this.snmpSetVariable(snmpVar);
            if (snmpVar != null) {
                return this.mibOps.toString(snmpVar, this.oidList[0]);
            }
        }
        catch (SnmpException snmpException) {
            this.errorCode = 32;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            throw new DataException(SnmpUtils.getString("Error : Creating variable."));
        }
        return null;
    }

    public String snmpSet(String string, byte by) throws DataException {
        try {
            SnmpVar snmpVar = this.snmpSetVariable(SnmpVar.createVariable(string, by));
            if (snmpVar != null) {
                return this.mibOps.toString(snmpVar, this.oidList[0]);
            }
        }
        catch (SnmpException snmpException) {
            this.errorCode = 32;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            throw new DataException(SnmpUtils.getString("Error : Creating variable."));
        }
        return null;
    }

    public String[] snmpSetList(String[] stringArray) throws DataException {
        if (stringArray == null) {
            this.errorCode = 33;
            this.error = ErrorMessages.getErrorString(this.errorCode);
            throw new DataException(SnmpUtils.getString("Error : Illegal Argument(s)"));
        }
        SnmpVar[] snmpVarArray = new SnmpVar[stringArray.length];
        if (this.oidList != null) {
            Object object;
            int n = 0;
            while (n < stringArray.length) {
                if (this.oidList == null || this.oidList[n] == null) {
                    this.errorCode = 21;
                    this.error = ErrorMessages.getErrorString(this.errorCode);
                    throw new DataException(String.valueOf(SnmpUtils.getString("Error : OID not specified")) + this.oidList[n]);
                }
                object = this.mibOps.getMibNode(this.oidList[n]);
                if (object == null) {
                    this.errorCode = 30;
                    this.error = ErrorMessages.getErrorString(this.errorCode);
                    throw new DataException(String.valueOf(SnmpUtils.getString("Error : MIB node unavailable for OID.")) + this.oidList[n]);
                }
                if (object.getSyntax() == null) {
                    this.errorCode = 31;
                    this.error = ErrorMessages.getErrorString(this.errorCode);
                    throw new DataException(String.valueOf(SnmpUtils.getString("Error : OID not a leaf node.")) + this.oidList[n]);
                }
                try {
                    SnmpVar snmpVar;
                    snmpVarArray[n] = snmpVar = object.getSyntax().createVariable(stringArray[n]);
                }
                catch (SnmpException snmpException) {
                    this.errorCode = 32;
                    this.error = ErrorMessages.getErrorString(this.errorCode);
                    throw new DataException(SnmpUtils.getString("Error : Creating variable."));
                }
                ++n;
            }
            if ((snmpVarArray = this.snmpSetVariables(snmpVarArray)) != null) {
                object = new String[snmpVarArray.length];
                int n2 = 0;
                while (n2 < snmpVarArray.length) {
                    if (snmpVarArray[n2] != null && snmpVarArray[n2] != null) {
                        object[n2] = this.mibOps.toString(snmpVarArray[n2], this.oidList[n2]);
                    }
                    ++n2;
                }
                return object;
            }
        } else {
            System.out.println(SnmpUtils.getString("Error : OidList not specified"));
        }
        return null;
    }

    public SnmpVar snmpSetVariable(SnmpVar snmpVar) throws DataException {
        if (this.oidList != null && this.oidList.length > 0) {
            if (this.varList == null) {
                this.varList = new SnmpVar[1];
            }
            this.varList[0] = snmpVar;
            SnmpPDU snmpPDU = this.getSNMPResponse((byte)-93);
            if (snmpPDU == null) {
                return null;
            }
            if (snmpPDU.getVariableBindings().size() <= 0) {
                this.errorCode = 24;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                return null;
            }
            SnmpVarBind snmpVarBind = snmpPDU.getVariableBinding(0);
            this.genEvent(snmpPDU);
            return snmpVarBind.getVariable();
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return null;
    }

    public SnmpVar[] snmpSetVariables(SnmpVar[] snmpVarArray) throws DataException {
        this.varList = snmpVarArray;
        if (this.oidList != null && this.oidList.length > 0) {
            SnmpPDU snmpPDU = this.getSNMPResponse((byte)-93);
            if (snmpPDU == null) {
                return null;
            }
            int n = snmpPDU.getVariableBindings().size();
            if (n <= 0) {
                this.errorCode = 24;
                this.error = ErrorMessages.getErrorString(this.errorCode);
                return null;
            }
            SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n];
            SnmpVar[] snmpVarArray2 = new SnmpVar[n];
            int n2 = 0;
            Enumeration enumeration = snmpPDU.getVariableBindings().elements();
            while (enumeration.hasMoreElements()) {
                snmpVarBindArray[n2] = (SnmpVarBind)enumeration.nextElement();
                snmpVarArray2[n2] = snmpVarBindArray[n2].getVariable();
                ++n2;
            }
            this.genEvent(snmpPDU);
            return snmpVarArray2;
        }
        this.errorCode = 21;
        this.error = ErrorMessages.getErrorString(this.errorCode);
        return null;
    }

    void updateMibs() {
        try {
            this.loadMibs(this.mibModules);
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(SnmpUtils.getString("MIB loading failed: ")) + " " + exception);
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        String string = (String)propertyChangeEvent.getOldValue();
        Hashtable hashtable = (Hashtable)propertyChangeEvent.getNewValue();
        if (string.equals("OLD INSTANCE")) {
            int n;
            String string2 = (String)hashtable.get("HOST");
            if (!string2.equals("")) {
                this.setTargetHost(string2);
            }
            if ((n = Integer.parseInt((String)hashtable.get("PORT"))) != -999) {
                this.setTargetPort(n);
            }
            if ((n = Integer.parseInt((String)hashtable.get("RETRIES"))) != -999) {
                this.setRetries(n);
            }
            if ((n = Integer.parseInt((String)hashtable.get("TIMEOUT"))) != -999) {
                this.setTimeout(n);
            }
        }
    }
}

