/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.beans;

import com.adventnet.management.transport.TransportException;
import com.adventnet.snmp.beans.SnmpServer;
import com.adventnet.snmp.beans.TrapEvent;
import com.adventnet.snmp.beans.TrapListener;
import com.adventnet.snmp.mibs.MibException;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.snmp2.ProtocolOptions;
import com.adventnet.snmp.snmp2.SASClient;
import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.snmp2.SnmpClient;
import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.snmp2.SnmpSession;
import com.adventnet.utils.LogInterface;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SnmpTrapReceiver
implements SnmpClient,
Serializable {
    int protocol = 1;
    ProtocolOptions options = null;
    LogInterface logClient = null;
    String mibModules = "";
    private boolean isResourcesAllocated = false;
    private boolean isReceiverStopped = true;
    Vector targets;
    SnmpAPI api = null;
    SnmpSession session = null;
    MibOperations mibOps;
    Vector listeners = new Vector();
    String[] localAddresses = null;
    int port = 0;
    String community = "public";
    int version = 0;
    boolean isCallbackthreadEnabled = true;
    static Applet applet = null;
    String error = SnmpUtils.getString("No error");

    public SnmpTrapReceiver() {
        this(null);
    }

    public SnmpTrapReceiver(int n, ProtocolOptions protocolOptions) {
        this.protocol = n;
        this.options = protocolOptions;
        applet = null;
        this.initSnmpStore(this);
        try {
            this.initSnmp();
        }
        catch (SnmpException snmpException) {}
    }

    public SnmpTrapReceiver(Applet applet) {
        SnmpTrapReceiver.applet = applet;
        this.initSnmpStore(this);
    }

    public void addLogClient(LogInterface logInterface) {
        this.logClient = logInterface;
    }

    public void addTrapListener(TrapListener trapListener) {
        this.listeners.addElement(trapListener);
        if (!(this.listeners.size() != 1 || this.session == null || this.session.getSnmpClients() != null && this.session.getSnmpClients().contains(this))) {
            this.session.addSnmpClient(this);
        }
    }

    public boolean authenticate(SnmpPDU snmpPDU, String string) {
        if (snmpPDU == null) {
            return true;
        }
        if (snmpPDU.getCommand() == -92) {
            if (this.community != null) {
                return this.community.equals(snmpPDU.getCommunity());
            }
        } else {
            if (this.community != null) {
                return this.community.equals(snmpPDU.getCommunity());
            }
            if (this.api.getDebug()) {
                System.err.println(SnmpUtils.getString("Dropping .... Not a Trap PDU"));
            }
        }
        return false;
    }

    public boolean callback(SnmpSession snmpSession, SnmpPDU snmpPDU, int n) {
        if (snmpPDU.getCommand() == -92) {
            this.genEvent(snmpPDU);
        }
        return false;
    }

    public void cleanup() {
        this.stop();
    }

    public void debugPrint(String string) {
        if (this.logClient != null) {
            this.logClient.dbg(string);
        } else {
            System.err.println(string);
        }
    }

    protected void finalize() throws Throwable {
        this.releaseResources();
    }

    void genEvent(SnmpPDU snmpPDU) {
        if (this.listeners.size() == 0) {
            return;
        }
        TrapEvent trapEvent = new TrapEvent(this, snmpPDU);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            TrapListener trapListener = (TrapListener)enumeration.nextElement();
            trapListener.receivedTrap(trapEvent);
        }
    }

    public String getCharacterEncoding() {
        return this.api.getCharacterEncoding();
    }

    public String getCommunity() {
        return this.community;
    }

    public String[] getLocalAddresses() {
        return this.localAddresses;
    }

    public String getMibModules() {
        return this.mibModules;
    }

    public MibOperations getMibOperations() {
        return this.mibOps;
    }

    public String getMibPath() {
        return this.mibOps.getMibPath();
    }

    public int getPort() {
        return this.port;
    }

    public int getPortWithExceptionMsg() {
        return this.port;
    }

    public void initJdbcParams(String string, String string2, String string3, String string4) {
        try {
            this.mibOps.initJdbcParams(string, string2, string3, string4);
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error :")) + " " + exception);
        }
    }

    private void initSnmp() throws SnmpException {
        Hashtable hashtable = SnmpServer.snmpStore;
        synchronized (hashtable) {
            if (this.api == null || !this.api.isAlive()) {
                this.api = (SnmpAPI)SnmpServer.snmpStore.get("API");
                if (this.api == null || !this.api.isAlive()) {
                    this.api = new SnmpAPI();
                    this.api.start();
                    SnmpServer.snmpStore.put("API", this.api);
                    SnmpServer.snmpStore.put("API_TARGETS", new Integer(1));
                }
            }
            this.session = (SnmpSession)SnmpServer.snmpStore.get("SESSION" + this.port);
            if (this.session != null && this.session.isAlive()) {
                Integer n = (Integer)SnmpServer.snmpStore.get("SESSION" + this.port + "_TARGETS");
                if (n != null) {
                    SnmpServer.snmpStore.put("SESSION" + this.port + "_TARGETS", new Integer(n + 1));
                }
            } else {
                try {
                    this.openSession();
                    SnmpServer.snmpStore.put("SESSION" + this.port, this.session);
                    SnmpServer.snmpStore.put("SESSION" + this.port + "_TARGETS", new Integer(1));
                }
                catch (SnmpException snmpException) {
                    throw new SnmpException(snmpException.toString());
                }
            }
            this.updateParams(this.session);
            this.isResourcesAllocated = true;
            this.isReceiverStopped = false;
        }
    }

    synchronized void initSnmpStore(SnmpTrapReceiver snmpTrapReceiver) {
        if (SnmpServer.snmpStore == null) {
            SnmpServer.snmpStore = new Hashtable();
        }
        Hashtable hashtable = SnmpServer.snmpStore;
        synchronized (hashtable) {
            this.mibOps = (MibOperations)SnmpServer.snmpStore.get("MIBS");
            if (this.mibOps == null) {
                this.mibOps = new MibOperations();
                SnmpServer.snmpStore.put("MIBS", this.mibOps);
            }
            this.targets = (Vector)SnmpServer.snmpStore.get("TARGETS");
            if (this.targets == null) {
                this.targets = new Vector();
                SnmpServer.snmpStore.put("TARGETS", this.targets);
            }
            this.targets.addElement("");
            this.api = (SnmpAPI)SnmpServer.snmpStore.get("API");
            if (this.api != null && this.api.isAlive()) {
                Integer n = (Integer)SnmpServer.snmpStore.get("API_TARGETS");
                if (n != null) {
                    SnmpServer.snmpStore.put("API_TARGETS", new Integer(n + 1));
                }
            } else {
                this.api = new SnmpAPI();
                this.api.start();
                SnmpServer.snmpStore.put("API", this.api);
                SnmpServer.snmpStore.put("API_TARGETS", new Integer(1));
            }
            this.isResourcesAllocated = true;
        }
    }

    public boolean isLoadMibsFromDatabase() {
        return this.mibOps.isLoadFromDatabase();
    }

    public boolean isOverwriteMibsInDatabase() {
        return this.mibOps.isOverwriteDatabase();
    }

    public void loadMibs(String string) throws MibException, IOException, FileNotFoundException {
        if (applet != null) {
            this.mibOps.loadMibModules(applet, string);
            this.mibModules = string;
        } else {
            this.mibOps.loadMibModules(string);
            this.mibModules = string;
        }
    }

    void openSession() throws SnmpException {
        if (this.session != null) {
            this.session.close();
            SnmpServer.snmpStore.remove(this.session);
        }
        this.session = new SnmpSession(this.api);
        if (this.community != null) {
            this.session.setCommunity(this.community);
        }
        if (this.localAddresses != null) {
            this.session.setLocalAddresses(this.localAddresses);
        }
        if (this.port != 0 || this.protocol == 2) {
            if (applet != null) {
                this.session.open(applet);
                SASClient sASClient = this.session.getSASClient();
                if (sASClient != null) {
                    try {
                        sASClient.reqTraps(this.port);
                    }
                    catch (IOException iOException) {
                        throw new SnmpException(String.valueOf(SnmpUtils.getString("Error sending req for Traps ")) + " " + iOException);
                    }
                    catch (TransportException transportException) {
                        throw new SnmpException(String.valueOf(SnmpUtils.getString("Error sending req for Traps ")) + " " + transportException);
                    }
                } else {
                    this.session.close();
                    while (this.session.isAlive()) {
                        try {
                            Thread.sleep(25L);
                        }
                        catch (Exception exception) {
                            System.err.println(String.valueOf(SnmpUtils.getString("Error : ")) + " " + exception.getMessage());
                        }
                    }
                    this.session = new SnmpSession(this.api);
                    this.session.setLocalPort(this.port);
                    this.session.open(applet);
                }
            } else {
                if (this.protocol == 1) {
                    this.session.setLocalPort(this.port);
                } else {
                    this.session.setProtocol(2);
                    this.session.setProtocolOptions(this.options);
                }
                this.session.open();
            }
        } else {
            throw new SnmpException(SnmpUtils.getString("Port 0 cannot be used for receiving traps."));
        }
    }

    public void releaseResources() {
        int n = 0;
        int n2 = 0;
        if (!this.isResourcesAllocated) {
            return;
        }
        Hashtable hashtable = SnmpServer.snmpStore;
        synchronized (hashtable) {
            if (this.targets != null) {
                this.targets.removeElement("");
                if (this.targets.size() == 0) {
                    SnmpServer.snmpStore.remove("MIBS");
                }
            }
            if (!this.isReceiverStopped) {
                n = (Integer)SnmpServer.snmpStore.remove("SESSION" + this.port + "_TARGETS");
                if (n == 1) {
                    this.session = (SnmpSession)SnmpServer.snmpStore.remove("SESSION" + this.port);
                } else {
                    SnmpServer.snmpStore.put("SESSION" + this.port + "_TARGETS", new Integer(n - 1));
                }
            }
            if ((n2 = ((Integer)SnmpServer.snmpStore.remove("API_TARGETS")).intValue()) == 1) {
                this.api = (SnmpAPI)SnmpServer.snmpStore.remove("API");
            } else {
                SnmpServer.snmpStore.put("API_TARGETS", new Integer(n2 - 1));
            }
            if (n == 1 && this.session != null) {
                this.session.close();
                this.session = null;
            }
            if (n2 == 1 && this.api != null) {
                this.api.close();
                this.api = null;
            }
            this.isResourcesAllocated = false;
            this.isReceiverStopped = true;
        }
    }

    public void removeTrapListener(TrapListener trapListener) {
        this.listeners.removeElement(trapListener);
        if (this.listeners.size() == 0 && this.session != null) {
            this.session.removeSnmpClient(this);
        }
    }

    public void setCallbackthread(boolean bl) {
        this.isCallbackthreadEnabled = bl;
    }

    public void setCharacterEncoding(String string) {
        this.api.setCharacterEncoding(string);
    }

    public void setCommunity(String string) {
        this.community = string;
    }

    public void setDebug(boolean bl) {
        this.api.setDebug(bl);
    }

    public void setLoadMibsFromDatabase(boolean bl) {
        this.mibOps.setLoadFromDatabase(bl);
    }

    public void setLocalAddresses(String[] stringArray) {
        this.localAddresses = stringArray;
    }

    public void setMibModules(String string) {
        this.mibModules = string;
        this.updateMibs();
    }

    public void setMibPath(String string) {
        this.mibOps.setMibPath(string);
    }

    public void setOverwriteMibsInDatabase(boolean bl) {
        this.mibOps.setOverwriteDatabase(bl);
    }

    public void setPort(int n) {
        block2: {
            if (this.port == n) break block2;
            this.stop();
            this.port = n;
            try {
                this.initSnmp();
            }
            catch (Exception exception) {
                this.port = 0;
                System.err.println(String.valueOf(SnmpUtils.getString("Error : ")) + " " + exception.getMessage());
            }
        }
    }

    public void setPortWithExceptionMsg(int n) throws SnmpException {
        if (this.port != n) {
            this.stop();
            this.port = n;
            try {
                this.initSnmp();
            }
            catch (Exception exception) {
                this.port = 0;
                throw new SnmpException(exception.toString());
            }
        }
    }

    public void stop() {
        int n = 0;
        if (this.isReceiverStopped) {
            return;
        }
        Hashtable hashtable = SnmpServer.snmpStore;
        synchronized (hashtable) {
            Integer n2 = (Integer)SnmpServer.snmpStore.remove("SESSION" + this.port + "_TARGETS");
            if (n2 == null) {
                Object var3_4 = null;
                return;
            }
            n = n2;
            if (n == 1) {
                this.session = (SnmpSession)SnmpServer.snmpStore.remove("SESSION" + this.port);
            } else {
                SnmpServer.snmpStore.put("SESSION" + this.port + "_TARGETS", new Integer(n - 1));
            }
            this.port = 0;
            if (n == 1 && this.session != null) {
                this.session.close();
                this.session = null;
            }
            this.isReceiverStopped = true;
        }
    }

    void updateMibs() {
        try {
            this.loadMibs(this.mibModules);
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(SnmpUtils.getString("MIB loading failed: ")) + " " + exception);
        }
    }

    private void updateParams(SnmpSession snmpSession) {
        if (!(this.listeners.size() <= 0 || snmpSession.getSnmpClients() != null && snmpSession.getSnmpClients().contains(this))) {
            snmpSession.addSnmpClient(this);
        }
        snmpSession.setCallbackthread(this.isCallbackthreadEnabled);
    }
}

