/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.beans;

import com.adventnet.snmp.beans.SnmpTrapReceiver;
import com.adventnet.snmp.mibs.MibTrap;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.snmp2.SnmpVar;
import java.net.InetAddress;
import java.util.EventObject;

public class TrapEvent
extends EventObject {
    SnmpPDU pdu;
    String error;

    public TrapEvent(Object object) {
        super(object);
    }

    public TrapEvent(Object object, SnmpPDU snmpPDU) {
        super(object);
        this.pdu = snmpPDU;
    }

    public TrapEvent(Object object, SnmpPDU snmpPDU, String string) {
        super(object);
        this.pdu = snmpPDU;
        this.error = string;
    }

    public String getAgentAddress() {
        if (this.pdu == null) {
            return null;
        }
        String string = this.pdu.getAgentAddr();
        if (string != null) {
            return string;
        }
        return this.getRemoteHost();
    }

    public String getCommunity() {
        if (this.pdu == null) {
            return null;
        }
        return this.pdu.getCommunity();
    }

    public String getEnterprise() {
        SnmpTrapReceiver snmpTrapReceiver;
        if (this.pdu == null) {
            return null;
        }
        SnmpOID snmpOID = this.pdu.getEnterprise();
        if (this.getSource() instanceof SnmpTrapReceiver && (snmpTrapReceiver = (SnmpTrapReceiver)this.getSource()) != null) {
            return snmpTrapReceiver.getMibOperations().toString(this.pdu.getEnterprise());
        }
        return snmpOID.toString();
    }

    public String getObjectID(int n) {
        SnmpTrapReceiver snmpTrapReceiver;
        if (this.pdu == null) {
            return null;
        }
        SnmpOID snmpOID = this.pdu.getObjectID(n);
        if (snmpOID == null) {
            return null;
        }
        if (this.getSource() instanceof SnmpTrapReceiver && (snmpTrapReceiver = (SnmpTrapReceiver)this.getSource()) != null) {
            return snmpTrapReceiver.getMibOperations().toString(snmpOID);
        }
        return snmpOID.toString();
    }

    public String getRemoteHost() {
        if (this.pdu == null) {
            return null;
        }
        String string = this.pdu.getRemoteHost();
        if (string != null) {
            return string;
        }
        InetAddress inetAddress = this.pdu.getAddress();
        if (inetAddress != null) {
            return inetAddress.getHostAddress();
        }
        return null;
    }

    public int getRemotePort() {
        if (this.pdu == null) {
            return -1;
        }
        return this.pdu.getRemotePort();
    }

    public int getReqid() {
        if (this.pdu == null) {
            return -1;
        }
        return this.pdu.getReqid();
    }

    public int getSpecificType() {
        if (this.pdu == null) {
            return -1;
        }
        return this.pdu.getSpecificType();
    }

    public MibTrap getTrapDefinition() {
        if (this.getSource() instanceof SnmpTrapReceiver) {
            SnmpTrapReceiver snmpTrapReceiver = (SnmpTrapReceiver)this.getSource();
            if (snmpTrapReceiver == null) {
                return null;
            }
            return snmpTrapReceiver.getMibOperations().getMibTrap(this.pdu.getEnterprise(), this.pdu.getTrapType(), this.pdu.getSpecificType());
        }
        return null;
    }

    public SnmpPDU getTrapPDU() {
        return this.pdu;
    }

    public int getTrapType() {
        if (this.pdu == null) {
            return -1;
        }
        return this.pdu.getTrapType();
    }

    public long getUpTime() {
        if (this.pdu == null) {
            return -1L;
        }
        return this.pdu.getUpTime();
    }

    public String getVariable(int n) {
        SnmpTrapReceiver snmpTrapReceiver;
        if (this.pdu == null) {
            return null;
        }
        SnmpVar snmpVar = this.pdu.getVariable(n);
        if (snmpVar == null) {
            return null;
        }
        if (this.getSource() instanceof SnmpTrapReceiver && (snmpTrapReceiver = (SnmpTrapReceiver)this.getSource()) != null) {
            return snmpTrapReceiver.getMibOperations().toString(this.pdu.getVariable(n), this.pdu.getObjectID(n));
        }
        return snmpVar.toString();
    }

    public int getVersion() {
        if (this.pdu == null) {
            return -1;
        }
        return this.pdu.getVersion();
    }
}

