/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs;

import com.adventnet.snmp.mibs.MibException;
import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibOperations;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class ImportResolver
implements Serializable {
    MibOperations mibOps;

    private ImportResolver() {
    }

    ImportResolver(MibOperations mibOperations) {
        this.mibOps = mibOperations;
    }

    public void performResolution() throws MibException {
        Hashtable hashtable = this.mibOps.globalImports;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Vector vector;
            String string = (String)enumeration.nextElement();
            MibModule mibModule = this.mibOps.getMibModule(string);
            if (mibModule == null) {
                mibModule = this.mibOps.getModuleFromGlobalImports(string);
            }
            if (mibModule == null || (vector = (Vector)hashtable.get(string)) == null) continue;
            int n = 0;
            while (n < vector.size()) {
                ((MibModule)vector.elementAt(n)).performResolution(mibModule);
                ++n;
            }
        }
    }

    public void performResolution(MibModule mibModule) throws MibException {
        if (mibModule == null) {
            return;
        }
        Hashtable hashtable = this.mibOps.globalImports;
        Vector vector = (Vector)hashtable.get(mibModule.getName());
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            ((MibModule)vector.elementAt(n)).performResolution(mibModule);
            ++n;
        }
    }
}

