/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs;

import com.adventnet.snmp.mibs.JdbcMibOperations;
import com.adventnet.snmp.mibs.LeafSyntax;
import com.adventnet.snmp.mibs.mibparser.MIBConstants;
import com.adventnet.snmp.mibs.mibparser.MIBParser;
import com.adventnet.snmp.mibs.mibparser.SyntaxTextualConvention;
import com.adventnet.utils.SnmpUtils;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class JdbcLeafSyntax
extends LeafSyntax
implements Serializable,
MIBConstants,
Cloneable {
    byte[] alphaType = new byte[]{4, 64, 68, 64, 3, 5};
    byte[] numericType = new byte[]{2, 71, 66, 66, 66, 65, 65, 70, 67};
    Hashtable enumTable = new Hashtable();
    ResultSet rs = null;
    String queryString = null;
    String moduleName = null;
    String oid = null;
    String name = null;
    String tableName = "";
    Vector labelVect = null;
    byte type = 0;
    JdbcMibOperations jMibOps = null;

    JdbcLeafSyntax() {
    }

    JdbcLeafSyntax(String string, String string2, JdbcMibOperations jdbcMibOperations) {
        this.moduleName = string;
        this.oid = string2;
        this.jMibOps = jdbcMibOperations;
        this.tableName = this.jMibOps.getTableName(this.moduleName);
        this.getEnumTable();
    }

    boolean IsConstrained() {
        if (this.moduleName.equals("") && JdbcMibOperations.rangeTable.containsKey(this.oid)) {
            return true;
        }
        try {
            StringTokenizer stringTokenizer;
            this.queryString = "SELECT RANGE FROM " + this.tableName + "RANGELISTTABLE WHERE OID='" + this.oid + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next() && (stringTokenizer = new StringTokenizer(this.rs.getString("RANGE"), ",[ ]")).hasMoreTokens()) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return false;
    }

    public boolean checkValue(int n) {
        String string = new Integer(n).toString();
        String[] stringArray = this.getRangeItems();
        String string2 = null;
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                string2 = stringArray[n2];
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "| ");
                String string3 = "";
                long l = 0L;
                long l2 = 0L;
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ".. ");
                    while (stringTokenizer2.hasMoreTokens()) {
                        l = Long.parseLong(stringTokenizer2.nextToken());
                        l2 = stringTokenizer2.hasMoreTokens() ? Long.parseLong(stringTokenizer2.nextToken()) : l;
                    }
                    if ((long)n < l || (long)n > l2) continue;
                    return true;
                }
                ++n2;
            }
        }
        if (this.isEnumerated()) {
            return this.enumTable.contains(string);
        }
        return n >= new Long(this.getMin()).intValue() && n <= new Long(this.getMax()).intValue();
    }

    public boolean checkValue(String string) {
        try {
            int n = new Long(string).intValue();
            return this.checkValue(n);
        }
        catch (NumberFormatException numberFormatException) {
            if (this.isEnumerated()) {
                return this.enumTable.containsKey(string);
            }
            return true;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return new JdbcLeafSyntax(this.moduleName, this.oid, this.jMibOps);
    }

    boolean getBITSRange(String string) {
        if (this.isEnumerated()) {
            int n;
            int n2;
            int n3 = 0;
            int n4 = string.length();
            if (n4 <= n2 + (8 - ((n = (n2 = this.getEnumlabels().length) % 8) == 0 ? 8 : n))) {
                int n5 = 0;
                while (n5 < n4) {
                    char c = string.charAt(n5);
                    if (c == '0' || c == '1') {
                        if (c == '1') {
                            n3 = n5 + 1;
                        }
                    } else {
                        return false;
                    }
                    ++n5;
                }
                if (n3 <= n2) {
                    return true;
                }
            }
        }
        return false;
    }

    public String getDescription() {
        String string = this.getName();
        if (this.moduleName.equals("")) {
            return string;
        }
        int n = 0;
        String string2 = "( ";
        if (this.IsConstrained()) {
            String[] stringArray = this.getRangeItems();
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                string2 = String.valueOf(string2) + stringArray[n2] + "|";
                ++n2;
            }
            string2 = string2.substring(0, string2.length() - 1);
            if (this.getType() == 4) {
                return String.valueOf(string) + " ( " + SnmpUtils.getString("SIZE") + string2 + " ) )";
            }
            return String.valueOf(string) + string2 + " )";
        }
        if (this.isEnumerated()) {
            String string3 = null;
            Object var5_7 = null;
            int n3 = 0;
            while (n3 < this.labelVect.size()) {
                string3 = (String)this.labelVect.elementAt(n3);
                string2 = String.valueOf(string2) + string3 + "(" + this.enumTable.get(string3) + ") ,";
                ++n3;
            }
        } else {
            return string;
        }
        string2 = "{ " + string2.substring(1, string2.length() - 1) + " }";
        return String.valueOf(string) + string2;
    }

    void getEnumTable() {
        try {
            Object object;
            boolean bl = false;
            Object var2_3 = null;
            String string = null;
            String string2 = null;
            if (!this.moduleName.equals("")) {
                this.queryString = "SELECT ENUM FROM " + this.tableName + "RANGELISTTABLE WHERE OID='" + this.oid + "'";
                this.rs = this.jMibOps.executeQuery(this.queryString);
                if (this.rs.next()) {
                    string2 = this.rs.getString("ENUM");
                } else {
                    object = this.getName();
                    if (JdbcMibOperations.enumTable.containsKey(object)) {
                        string2 = (String)JdbcMibOperations.enumTable.get(object);
                    } else {
                        this.queryString = "SELECT ENUM FROM " + this.tableName + "RANGELISTTABLE WHERE OID='" + (String)object + "'";
                        this.rs = this.jMibOps.executeQuery(this.queryString);
                        if (this.rs.next()) {
                            string2 = this.rs.getString("ENUM");
                        } else {
                            return;
                        }
                    }
                    if (string2 == null) {
                        return;
                    }
                }
            } else {
                if (JdbcMibOperations.enumTable.containsKey(this.oid)) {
                    string2 = (String)JdbcMibOperations.enumTable.get(this.oid);
                }
                if (string2 == null) {
                    return;
                }
            }
            object = new StringTokenizer(string2, ",[ ]");
            String[] stringArray = new String[((StringTokenizer)object).countTokens() / 2 + 1];
            this.labelVect = new Vector();
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                if (((StringTokenizer)object).hasMoreTokens()) {
                    string = ((StringTokenizer)object).nextToken();
                    this.labelVect.addElement(string3);
                }
                this.enumTable.put(string3, string);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public int[] getEnumint() {
        if (this.labelVect == null || this.labelVect.size() == 0) {
            return null;
        }
        int n = this.labelVect.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = Integer.parseInt((String)this.enumTable.get((String)this.labelVect.elementAt(n2)));
            ++n2;
        }
        return nArray;
    }

    public String[] getEnumlabels() {
        int n = this.enumTable.size();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < this.labelVect.size()) {
            stringArray[n2] = (String)this.labelVect.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public int getInt(String string) {
        if (string == null || string.equals("")) {
            return -1;
        }
        String string2 = (String)this.enumTable.get(string);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return -1;
    }

    public String getLabel(int n) {
        String string = new Integer(n).toString();
        Enumeration enumeration = this.enumTable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.enumTable.get(string2).equals(string)) continue;
            return string2;
        }
        return null;
    }

    public long getMax() {
        long l = 0xFFFFFFFFL;
        long l2 = 0L;
        String[] stringArray = this.getRangeItems();
        if (stringArray != null) {
            long l3 = 0L;
            int n = 0;
            while (n < stringArray.length) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], ".. ");
                while (stringTokenizer.hasMoreTokens()) {
                    l2 = Long.parseLong(stringTokenizer.nextToken());
                    if (l2 <= l3) continue;
                    l3 = l2;
                }
                ++n;
            }
            return l3;
        }
        if (this.isEnumerated()) {
            int[] nArray = this.getEnumint();
            l = nArray[0];
            int n = 1;
            while (n < nArray.length) {
                if ((long)nArray[n] > l) {
                    l = nArray[n];
                }
                ++n;
            }
        }
        if (this.getType() == 6) {
            return Integer.MAX_VALUE;
        }
        return l;
    }

    public long getMin() {
        long l = 0L;
        String[] stringArray = this.getRangeItems();
        if (stringArray != null) {
            long l2 = 0L;
            long l3 = 0L;
            int n = 0;
            while (n < stringArray.length) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], " ..");
                while (stringTokenizer.hasMoreTokens()) {
                    l3 = Long.parseLong(stringTokenizer.nextToken());
                    if (l3 >= l2) continue;
                    l2 = l3;
                }
                ++n;
            }
            l = l2;
        }
        if (this.isEnumerated()) {
            int[] nArray = this.getEnumint();
            l = nArray[0];
            int n = 1;
            while (n < nArray.length) {
                if ((long)nArray[n] < l) {
                    l = nArray[n];
                }
                ++n;
            }
        }
        if (this.getType() == 6) {
            return Integer.MIN_VALUE;
        }
        return l;
    }

    public String getName() {
        if (this.moduleName.equals("")) {
            return this.oid;
        }
        try {
            this.queryString = !this.oid.startsWith(".") ? "SELECT TYPE FROM " + this.tableName + "TCTABLE  WHERE MODULETCNAME ='" + this.oid + "'" : "SELECT SYNT FROM " + this.tableName + "OBJECTTYPETABLE WHERE OID='" + this.oid + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next()) {
                if (!this.oid.startsWith(".")) {
                    return this.rs.getString("TYPE");
                }
                return this.rs.getString("SYNT");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        if (!this.oid.startsWith(".")) {
            return this.oid;
        }
        return "";
    }

    public String[] getRangeItems() {
        Object object;
        if (this.isEnumerated()) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.moduleName.equals("")) {
            if (JdbcMibOperations.rangeTable.containsKey(this.oid)) {
                string3 = (String)JdbcMibOperations.rangeTable.get(this.oid);
            }
            if (string3 == null) {
                return null;
            }
        } else {
            try {
                this.queryString = "SELECT RANGE FROM " + this.tableName + "RANGELISTTABLE WHERE OID='" + this.oid + "'";
                this.rs = this.jMibOps.executeQuery(this.queryString);
                if (this.rs.next()) {
                    string3 = this.rs.getString("RANGE");
                } else {
                    object = this.getName();
                    if (JdbcMibOperations.rangeTable.containsKey(object)) {
                        string3 = (String)JdbcMibOperations.rangeTable.get(object);
                    } else {
                        this.queryString = "SELECT RANGE FROM " + this.tableName + "RANGELISTTABLE WHERE OID='" + (String)object + "'";
                        this.rs = this.jMibOps.executeQuery(this.queryString);
                        if (this.rs.next()) {
                            string3 = this.rs.getString("RANGE");
                        } else if (!JdbcMibOperations.typeHashtable.containsKey(object)) {
                            return new JdbcLeafSyntax(this.moduleName, (String)object, this.jMibOps).getRangeItems();
                        }
                    }
                    if (string3 == null) {
                        return null;
                    }
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        if (string3 != null) {
            object = new StringTokenizer(string3, ",[ ]");
            int n = ((StringTokenizer)object).countTokens();
            String[] stringArray = new String[n / 2];
            int n2 = 0;
            while (n2 < n / 2) {
                string = ((StringTokenizer)object).nextToken();
                stringArray[n2] = string.equals(string2 = ((StringTokenizer)object).nextToken()) ? string : String.valueOf(string) + ".." + string2;
                ++n2;
            }
            return stringArray;
        }
        return null;
    }

    public LeafSyntax getSyntax() {
        String string = this.getName();
        if (this.isTC(string) && !string.equals("")) {
            return new JdbcLeafSyntax(this.moduleName, string, this.jMibOps);
        }
        return this;
    }

    String getTCDefinedMIB(String string, String string2) {
        if (string == null) {
            return null;
        }
        try {
            ResultSet resultSet = null;
            String string3 = "SELECT MODULETCNAME FROM" + this.jMibOps.getTableName(string) + " TCTABLE WHERE MODULETCNAME='" + string2 + "'";
            resultSet = this.jMibOps.executeQuery(string3);
            if (resultSet.next()) {
                return string;
            }
            String string4 = "SELECT DEPENDANTMODULENAME FROM " + this.jMibOps.getTableName(string) + "DEPENDANCYTABLE WHERE IMPORTEDNODES LIKE '%|" + string2 + "|%'";
            ResultSet resultSet2 = null;
            resultSet2 = this.jMibOps.executeQuery(string4);
            if (resultSet2.next()) {
                string = resultSet2.getString("DEPENDANTMODULENAME");
                return resultSet2.getString("DEPENDANTMODULENAME");
            }
        }
        catch (SQLException sQLException) {}
        return null;
    }

    byte getTCType(String string, String string2) {
        block5: {
            if (string == null) break block5;
            try {
                String string3 = "SELECT TYPE FROM " + this.jMibOps.getTableName(string) + "TCTABLE WHERE MODULETCNAME='" + string2 + "'";
                this.rs = this.jMibOps.executeQuery(string3);
                if (this.rs.next()) {
                    string2 = this.rs.getString("TYPE");
                    if (JdbcMibOperations.typeHashtable.containsKey(string2)) {
                        return Byte.decode((String)JdbcMibOperations.typeHashtable.get(string2));
                    }
                    if (MIBParser.wellKnownTCs.containsKey(string2)) {
                        return new Integer(((SyntaxTextualConvention)MIBParser.wellKnownTCs.get(string2)).getType()).byteValue();
                    }
                    string = this.getTCDefinedMIB(string, string2);
                    return this.getTCType(string, string2);
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        return -1;
    }

    public byte getType() {
        String string = this.getName();
        if (JdbcMibOperations.typeHashtable.containsKey(string)) {
            return Byte.decode((String)JdbcMibOperations.typeHashtable.get(string));
        }
        if (MIBParser.wellKnownTCs.containsKey(string)) {
            return new Integer(((SyntaxTextualConvention)MIBParser.wellKnownTCs.get(string)).getType()).byteValue();
        }
        return this.getTCType(this.moduleName, string);
    }

    public boolean isConstrained() {
        if (this.isEnumerated()) {
            return true;
        }
        if (this.moduleName.equals("") && JdbcMibOperations.rangeTable.containsKey(this.oid)) {
            return true;
        }
        try {
            StringTokenizer stringTokenizer;
            this.queryString = "SELECT RANGE FROM " + this.tableName + "RANGELISTTABLE WHERE OID='" + this.oid + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next() && (stringTokenizer = new StringTokenizer(this.rs.getString("RANGE"), ",[ ]")).hasMoreTokens()) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return false;
    }

    public boolean isEnumerated() {
        return this.enumTable.size() > 0;
    }

    public boolean isRanged() {
        return this.enumTable.size() == 0 && this.getRangeItems() != null;
    }

    boolean isTC(String string) {
        try {
            this.queryString = "SELECT MODULETCNAME FROM " + this.tableName + "TCTABLE WHERE MODULETCNAME='" + string + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next()) {
                return true;
            }
            if (string != null && !string.startsWith(".") && MIBParser.wellKnownTCs.containsKey(string)) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public String toTagString() {
        return String.valueOf(SnmpUtils.getString("SYNTAX:")) + " " + this.getDescription();
    }
}

