/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs;

import com.adventnet.snmp.mibs.JdbcMibNode;
import com.adventnet.snmp.mibs.JdbcMibOperations;
import com.adventnet.snmp.mibs.JdbcMibTC;
import com.adventnet.snmp.mibs.JdbcMibTrap;
import com.adventnet.snmp.mibs.LeafSyntax;
import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibTC;
import com.adventnet.snmp.mibs.MibTrap;
import com.adventnet.snmp.mibs.mibparser.MIBConstants;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.utils.SnmpUtils;
import java.io.File;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class JdbcMibModule
extends MibModule
implements MIBConstants,
Serializable {
    String moduleName = null;
    String queryString = null;
    String tableName = "";
    ResultSet rs = null;
    JdbcMibOperations jMibOps = null;

    JdbcMibModule() {
    }

    JdbcMibModule(String string, JdbcMibOperations jdbcMibOperations) {
        this.moduleName = string;
        this.jMibOps = jdbcMibOperations;
        this.tableName = this.jMibOps.getTableName(this.moduleName);
    }

    public Enumeration getDefinedNodes() {
        Vector<JdbcMibNode> vector = new Vector<JdbcMibNode>();
        try {
            this.queryString = "SELECT  NODENAME , OID , MACROTYPE FROM " + this.tableName + "NODETABLE";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            while (this.rs.next()) {
                vector.addElement(new JdbcMibNode(this.moduleName, this.rs.getString("NODENAME"), this.rs.getString("OID"), this.rs.getString("MACROTYPE"), this.jMibOps));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return vector.elements();
    }

    public Enumeration getDefinedTCs() {
        String string = this.moduleName;
        Vector<JdbcMibTC> vector = new Vector<JdbcMibTC>();
        try {
            this.queryString = "SELECT MODULETCNAME FROM " + this.tableName + "TCTABLE";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            while (this.rs.next()) {
                String string2 = this.rs.getString("MODULETCNAME");
                vector.addElement(new JdbcMibTC(this.moduleName, string2, this.jMibOps));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return vector.elements();
    }

    public Enumeration getDefinedTraps() {
        String string = this.moduleName;
        String string2 = "";
        Vector<JdbcMibTrap> vector = new Vector<JdbcMibTrap>();
        try {
            this.queryString = "SELECT MODULETRAPNAME FROM " + this.tableName + "TRAPTABLE ";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            while (this.rs.next()) {
                string2 = this.rs.getString("MODULETRAPNAME");
                vector.addElement(new JdbcMibTrap(string, string2, this.jMibOps));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return vector.elements();
    }

    public String getFileName() {
        String string = (String)this.jMibOps.allModules.get(this.moduleName);
        if (string != null) {
            return string.replace('/', File.separatorChar);
        }
        return string;
    }

    public String getFilename() {
        String string = (String)this.jMibOps.allModules.get(this.moduleName);
        if (string != null) {
            return string.replace('/', File.separatorChar);
        }
        return string;
    }

    public Hashtable getImports() {
        ResultSet resultSet = null;
        Hashtable hashtable = new Hashtable();
        this.queryString = "SELECT * FROM " + this.tableName + "DEPENDANCYTABLE";
        try {
            resultSet = this.jMibOps.executeQuery(this.queryString);
            String string = "";
            String string2 = "";
            String string3 = "";
            MibNode mibNode = null;
            while (resultSet.next()) {
                string = resultSet.getString("DEPENDANTMODULENAME");
                string2 = resultSet.getString("IMPORTEDNODES");
                string3 = "";
                mibNode = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "| ");
                Vector<String> vector = new Vector<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    mibNode = JdbcMibNode.getAugmentNode(this.moduleName, string3, this.jMibOps);
                    if ((mibNode == null || !mibNode.isImportedNode() && !mibNode.isTableEntry() && !mibNode.isIndex()) && (!Character.isUpperCase(string3.charAt(0)) || JdbcMibOperations.typeHashtable.containsKey(string3) || this.getMibTC(string3) != null)) continue;
                    vector.addElement(string3);
                }
                if (vector.size() > 0) {
                    hashtable.put(string, vector);
                }
                vector = new Vector();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return hashtable;
    }

    String getInstance(String string, String string2) {
        int n;
        StringTokenizer stringTokenizer;
        block9: {
            String string3;
            boolean bl = false;
            stringTokenizer = new StringTokenizer(string, ".");
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
            n = stringTokenizer2.countTokens();
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                try {
                    Long.parseLong(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                    break;
                }
            }
            if (bl) {
                string3 = "";
                String string4 = "";
                int n2 = 0;
                while ((n2 = string.lastIndexOf(".")) != -1) {
                    string4 = string.substring(n2 + 1, string.length());
                    string = string.substring(0, n2);
                    try {
                        Long.parseLong(string4);
                        string3 = "." + string4 + string3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        string = String.valueOf(this.getMibNode(String.valueOf(string) + "." + string4).getNumberedOIDString()) + string3;
                        break block9;
                    }
                }
                string = String.valueOf(this.getMibNode(string).getNumberedOIDString()) + string3;
            }
        }
        stringTokenizer = new StringTokenizer(string, ".");
        int n3 = stringTokenizer.countTokens();
        int n4 = n3 - n;
        String string5 = "";
        int n5 = 0;
        while (n5 < n4) {
            int n6 = string.lastIndexOf(".");
            if (n6 != -1) {
                string5 = "." + string.substring(n6 + 1, string.length()) + string5;
                string = string.substring(0, n6);
            }
            ++n5;
        }
        return string5;
    }

    public LeafSyntax getLeafSyntax(SnmpOID snmpOID) {
        if (snmpOID == null) {
            return null;
        }
        MibNode mibNode = this.getMibNode(snmpOID);
        if (mibNode != null) {
            return mibNode.getSyntax();
        }
        return null;
    }

    public MibNode getMibNode(SnmpOID snmpOID) {
        if (snmpOID == null || snmpOID.toString() == null) {
            return null;
        }
        String string = snmpOID.toString();
        MibNode mibNode = this.getMibnode(string);
        if (mibNode == null) {
            Object object;
            Object object2;
            Vector vector = this.jMibOps.getDependentFileNames(this.moduleName);
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                object2 = (String)vector.elementAt(n2);
                object = new JdbcMibModule((String)object2, this.jMibOps).getMibnode(string);
                if (object != null) {
                    return object;
                }
                ++n2;
            }
            object2 = this.getnearestnode(new SnmpOID(string));
            if (object2 != null && !((String)(object = ((MibNode)object2).getMacroType().trim())).equals("OBJECT IDENTIFIER") && !((String)object).equals("OBJECT-IDENTITY")) {
                return object2;
            }
        }
        return mibNode;
    }

    public MibNode getMibNode(String string) {
        if (string == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return this.getMibNode(vector);
    }

    public MibNode getMibNode(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return null;
        }
        String string = "";
        String string2 = null;
        int n = 0;
        while (n < vector.size()) {
            try {
                string2 = (String)vector.elementAt(n);
                Long.parseLong(string2);
                string = String.valueOf(string) + "." + string2;
            }
            catch (NumberFormatException numberFormatException) {
                MibNode mibNode = JdbcMibNode.getAugmentNode(this.moduleName, string2, this.jMibOps);
                if (mibNode != null) {
                    string = mibNode.getNumberedOIDString();
                }
                return null;
            }
            ++n;
        }
        return this.getMibNode(new SnmpOID(string));
    }

    public MibNode getMibNode(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            stringBuffer.append(".");
            stringBuffer.append(new Integer(nArray[n]).toString());
            ++n;
        }
        return this.getMibNode(stringBuffer.toString());
    }

    public MibNode getMibNodeByName(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            this.queryString = "SELECT OID , MACROTYPE FROM " + this.tableName + "NODETABLE WHERE NODENAME='" + string + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next()) {
                return new JdbcMibNode(this.moduleName, string, this.rs.getString("OID"), this.rs.getString("MACROTYPE"), this.jMibOps);
            }
            if (JdbcMibOperations.stdNodeOID.containsKey(string)) {
                return new JdbcMibNode(this.moduleName, string, (String)JdbcMibOperations.stdNodeOID.get(string), "OID", this.jMibOps);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    public MibTC getMibTC(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            this.queryString = "SELECT MODULETCNAME FROM " + this.tableName + "TCTABLE";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next()) {
                return new JdbcMibTC(this.moduleName, string, this.jMibOps);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    public MibTrap getMibTrap(String string) {
        String string2 = this.moduleName;
        try {
            this.queryString = "SELECT MODULETRAPNAME FROM " + this.tableName + "TRAPTABLE ";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next()) {
                return new JdbcMibTrap(string2, string, this.jMibOps);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    MibNode getMibnode(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            this.queryString = "SELECT NODENAME , MACROTYPE  FROM " + this.tableName + "NODETABLE WHERE OID='" + string + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next()) {
                return new JdbcMibNode(this.moduleName, this.rs.getString("NODENAME"), string, this.rs.getString("MACROTYPE"), this.jMibOps);
            }
            if (string != null && JdbcMibOperations.stdNode.containsKey(string)) {
                return new JdbcMibNode(this.moduleName, (String)JdbcMibOperations.stdNode.get(string), string, "OID", this.jMibOps);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    public String getName() {
        return this.moduleName;
    }

    public MibNode getNearestNode(int[] nArray) {
        return this.getnearestnode(new SnmpOID(nArray));
    }

    String getNodeName(String string, String string2) {
        try {
            String string3 = "SELECT NODENAME FROM " + this.tableName + "NODETABLE WHERE OID='" + string2 + "'";
            this.rs = this.jMibOps.executeQuery(string3);
            if (this.rs.next()) {
                return this.rs.getString("NODENAME");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    public MibNode getRootNode() {
        Vector vector = this.getRootNodes();
        if (vector.size() == 1) {
            MibNode mibNode = (MibNode)vector.elementAt(0);
            return mibNode;
        }
        return null;
    }

    Vector getRootNodeVect(Vector vector) {
        Vector<MibNode> vector2 = new Vector<MibNode>();
        if (vector.size() == 1) {
            return vector;
        }
        int n = 0;
        while (n < vector.size() - 1) {
            MibNode mibNode = ((MibNode)vector.elementAt(n)).getCommonAncestorWith((MibNode)vector.elementAt(n + 1));
            if (mibNode != null) {
                if (!vector2.contains(mibNode)) {
                    vector2.addElement(mibNode);
                }
            } else {
                return vector;
            }
            ++n;
        }
        return vector2;
    }

    public Vector getRootNodes() {
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        try {
            this.queryString = "SELECT OTHERROOTNODES FROM MODULETABLE WHERE MODULENAME ='" + this.moduleName + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next()) {
                vector = new Vector();
                object2 = null;
                StringTokenizer stringTokenizer = new StringTokenizer(this.rs.getString("OTHERROOTNODES"), "| ");
                while (stringTokenizer.hasMoreTokens()) {
                    object2 = stringTokenizer.nextToken();
                    if (((String)object2).equals("null")) {
                        return vector;
                    }
                    object = (JdbcMibNode)JdbcMibNode.getAugmentNode(this.moduleName, (String)object2, this.jMibOps);
                    if (object != null) {
                        ((JdbcMibNode)object).setMibModuleName(this.moduleName);
                    }
                    vector.addElement(object);
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        object2 = new Vector();
        int n = vector.size();
        object = new String[n];
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            object[n2] = ((MibNode)vector.elementAt(n2)).getNumberedOIDString();
            ++n2;
        }
        Vector vector2 = (Vector)vector.clone();
        int n3 = 0;
        while (n3 < n - 1) {
            int n4 = n3 + 1;
            while (n4 < vector.size()) {
                if (object[n3].length() < object[n4].length()) {
                    if (object[n4].startsWith(object[n3])) {
                        vector2.removeElement((MibNode)vector.elementAt(n4));
                    }
                } else if (object[n3].startsWith(object[n4])) {
                    vector2.removeElement((MibNode)vector.elementAt(n3));
                }
                ++n4;
            }
            ++n3;
        }
        return this.getRootNodeVect(vector2);
    }

    public SnmpOID getSnmpOID(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                string3 = stringTokenizer.nextToken();
                Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
        }
        if (!bl) {
            return new SnmpOID(string);
        }
        MibNode mibNode = this.getMibNode(string);
        if (mibNode != null) {
            String string4;
            long l = 0L;
            int n = 0;
            String string5 = mibNode.getNumberedOIDString();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string5, ".");
            int[] nArray = new int[stringTokenizer2.countTokens()];
            while (stringTokenizer2.hasMoreTokens()) {
                try {
                    string4 = stringTokenizer2.nextToken();
                    l = Long.parseLong(string4);
                    if (l > 0xFFFFFFFFL) {
                        System.err.println(String.valueOf(SnmpUtils.getString("subID value should be less than 4294967295:")) + " " + string);
                        return null;
                    }
                    nArray[n++] = (int)(l & 0xFFFFFFFFL);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Invalid OID format:")) + " " + string);
                    return null;
                }
            }
            string4 = this.getInstance(string, string5);
            return new SnmpOID(String.valueOf(string5) + string4);
        }
        return null;
    }

    String getinstance(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = new String();
        string2 = string;
        String string3 = "";
        int n = stringTokenizer.countTokens();
        int n2 = n - 1;
        while (n2 > 0) {
            int n3 = string2.lastIndexOf(".");
            String string4 = string2.substring(n3 + 1, string2.length());
            string3 = "." + string4 + string3;
            MibNode mibNode = this.getMibnode(string2 = string2.substring(0, n3));
            if (mibNode != null) {
                return string3;
            }
            --n2;
        }
        return null;
    }

    MibNode getnearestnode(SnmpOID snmpOID) {
        if (snmpOID == null) {
            return null;
        }
        MibNode mibNode = this.getMibnode(snmpOID.toString());
        if (mibNode == null) {
            Object var3_3 = null;
            String string = snmpOID.toString();
            int n = string.lastIndexOf(".");
            if (n > 1 && (mibNode = this.getMibnode(string = string.substring(0, n))) == null) {
                Vector vector = this.jMibOps.getDependentFileNames(this.moduleName);
                int n2 = 0;
                while (n2 < vector.size()) {
                    String string2 = (String)vector.elementAt(n2);
                    MibNode mibNode2 = new JdbcMibModule(string2, this.jMibOps).getMibnode(string);
                    if (mibNode2 != null) {
                        return mibNode2;
                    }
                    ++n2;
                }
                return this.getnearestnode(new SnmpOID(string));
            }
        }
        return mibNode;
    }

    public String toString() {
        return this.moduleName;
    }

    public String translateToNames(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        String string2 = "";
        String string3 = null;
        String string4 = "";
        String string5 = "";
        MibNode mibNode = this.getMibNode(string);
        if (mibNode == null) {
            return null;
        }
        string5 = mibNode.getNumberedOIDString();
        String string6 = this.getInstance(string, string5);
        string4 = string = string5;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < n) {
            String string7 = this.getNodeName(this.moduleName, string4);
            if (string7 != null) {
                string3 = string7;
            } else {
                string3 = (String)JdbcMibOperations.stdNode.get(string4);
                if (string3 == null) {
                    Vector vector = this.jMibOps.getDependentFileNames(this.moduleName);
                    int n3 = 0;
                    while (n3 < vector.size()) {
                        string3 = this.getNodeName((String)vector.elementAt(n3), string4);
                        if (string3 != null) break;
                        ++n3;
                    }
                }
            }
            string2 = "." + string3 + string2;
            string4 = string4.substring(0, string4.lastIndexOf("."));
            ++n2;
        }
        return String.valueOf(string2) + string6;
    }

    public String translateToNumbers(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        MibNode mibNode = this.getMibNode(string);
        if (mibNode != null) {
            String string2 = mibNode.getNumberedOIDString();
            return String.valueOf(string2) + this.getInstance(string, string2);
        }
        return null;
    }
}

