/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs;

import com.adventnet.snmp.mibs.JdbcLeafSyntax;
import com.adventnet.snmp.mibs.JdbcMibModule;
import com.adventnet.snmp.mibs.JdbcMibModuleIdentity;
import com.adventnet.snmp.mibs.JdbcMibNotification;
import com.adventnet.snmp.mibs.JdbcMibOperations;
import com.adventnet.snmp.mibs.JdbcObjectGroup;
import com.adventnet.snmp.mibs.LeafSyntax;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.mibparser.MIBConstants;
import com.adventnet.utils.SnmpUtils;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class JdbcMibNode
extends MibNode
implements Serializable,
MIBConstants {
    String moduleName = null;
    String nodeName = null;
    String macroType = null;
    String oid = null;
    String isImportedNode = null;
    String reference = null;
    String description = null;
    String defval = null;
    String queryString = null;
    String keyName = "";
    String tableName = "";
    ResultSet rs = null;
    int subID = 0;
    Vector childVector = null;
    JdbcMibOperations jMibOps = null;

    JdbcMibNode(String string, String string2, String string3, String string4, JdbcMibOperations jdbcMibOperations) {
        this.nodeName = string2;
        this.moduleName = string;
        this.oid = string3;
        this.macroType = string4.trim();
        this.jMibOps = jdbcMibOperations;
        this.tableName = this.jMibOps.getTableName(this.moduleName);
    }

    public int getAccess() {
        String string = this.printAccess();
        if (string != null && JdbcMibOperations.accessTable.containsKey(string)) {
            return (Integer)JdbcMibOperations.accessTable.get(string);
        }
        return 0;
    }

    static MibNode getAugmentNode(String string, String string2, JdbcMibOperations jdbcMibOperations) {
        try {
            String string3;
            String string4;
            String string5 = "SELECT OID,MACROTYPE FROM " + jdbcMibOperations.getTableName(string) + "NODETABLE WHERE NODENAME='" + string2 + "'";
            ResultSet resultSet = null;
            resultSet = jdbcMibOperations.executeQuery(string5);
            if (resultSet.next()) {
                return new JdbcMibNode(string, string2, resultSet.getString("OID"), resultSet.getString("MACROTYPE"), jdbcMibOperations);
            }
            if (JdbcMibOperations.stdNodeOID.containsKey(string2)) {
                return new JdbcMibNode(string, string2, (String)JdbcMibOperations.stdNodeOID.get(string2), "OID", jdbcMibOperations);
            }
            String string6 = "SELECT DEPENDANTMODULENAME FROM " + jdbcMibOperations.getTableName(string) + "DEPENDANCYTABLE WHERE IMPORTEDNODES LIKE '%" + string2 + "%'";
            resultSet = jdbcMibOperations.executeQuery(string6);
            if (resultSet.next() && (resultSet = jdbcMibOperations.executeQuery(string4 = "SELECT OID,MACROTYPE FROM " + jdbcMibOperations.getTableName(string3 = resultSet.getString("DEPENDANTMODULENAME")) + "NODETABLE WHERE NODENAME='" + string2 + "'")).next()) {
                return new JdbcMibNode(string3, string2, resultSet.getString("OID"), resultSet.getString("MACROTYPE"), jdbcMibOperations);
            }
        }
        catch (SQLException sQLException) {}
        return null;
    }

    public MibNode getChild(int n) {
        try {
            this.oid = String.valueOf(this.oid) + "." + new Integer(n).toString();
            this.queryString = "SELECT NODENAME , MACROTYPE FROM " + this.tableName + "NODETABLE WHERE OID='" + this.oid + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next()) {
                return new JdbcMibNode(this.moduleName, this.rs.getString("NODENAME"), this.oid, this.rs.getString("MACROTYPE"), this.jMibOps);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    public Vector getChildList() {
        this.keyName = String.valueOf(this.moduleName) + this.nodeName;
        if (this.jMibOps.cache.containsKey(this.keyName)) {
            return (Vector)this.jMibOps.cache.get(this.keyName);
        }
        Vector vector = new Vector();
        try {
            this.queryString = "SELECT *  FROM " + this.tableName + "NODETABLE WHERE OID LIKE  '" + this.oid + ".%'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".");
            StringTokenizer stringTokenizer2 = null;
            int n = stringTokenizer.countTokens();
            int n2 = 0;
            String string = "";
            while (this.rs.next()) {
                string = this.rs.getString("OID");
                stringTokenizer2 = new StringTokenizer(string, ".");
                n2 = stringTokenizer2.countTokens();
                if (n2 != n + 1) continue;
                vector.addElement(new JdbcMibNode(this.moduleName, this.rs.getString("NODENAME"), string, this.rs.getString("MACROTYPE"), this.jMibOps));
            }
            if (vector.isEmpty()) {
                vector = this.getStdNode(vector);
                int n3 = 0;
                while (n3 < vector.size()) {
                    MibNode mibNode = (MibNode)vector.elementAt(n3);
                    if (mibNode.getChildList().size() == 0) {
                        vector.removeElement(mibNode);
                        n3 = 0;
                    }
                    ++n3;
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        if (vector.size() > 1) {
            vector = this.sort(vector);
        }
        if (vector.size() > 0) {
            this.jMibOps.cache.put(this.keyName, vector);
        }
        return vector;
    }

    public MibNode getCommonAncestorWith(MibNode mibNode) {
        int n;
        Vector<String> vector = new Vector<String>();
        String string = this.oid;
        String string2 = mibNode.getNumberedOIDString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        int n2 = stringTokenizer.countTokens();
        int n3 = n2 < (n = stringTokenizer2.countTokens()) ? n2 : n;
        int n4 = 0;
        String string3 = null;
        while (n4 < n3) {
            string3 = stringTokenizer.nextToken();
            if (!string3.equals(stringTokenizer2.nextToken())) break;
            vector.addElement(string3);
            ++n4;
        }
        return new JdbcMibModule(this.moduleName, this.jMibOps).getMibNode(vector);
    }

    public String getDefval() {
        if (this.defval == null) {
            try {
                String string;
                this.queryString = "SELECT DEFVAL FROM " + this.tableName + "OBJECTTYPETABLE WHERE OID='" + this.oid + "'";
                this.rs = this.jMibOps.executeQuery(this.queryString);
                if (this.rs.next() && !(string = this.rs.getString("DEFVAL")).equals("null")) {
                    string = string.replace('\u0096', '#');
                    string = string.replace('\u00c8', '\'');
                    return string;
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            return "";
        }
        if (this.defval.startsWith("\"") && this.defval.endsWith("\"")) {
            this.defval = this.defval.substring(1, this.defval.length() - 1);
        }
        return this.defval;
    }

    public String getDescription() {
        if (this.macroType.equals("MODIDTY")) {
            return new JdbcMibModuleIdentity(this.moduleName, this.nodeName, this.jMibOps).getDescription();
        }
        try {
            String string;
            String string2 = "OBJECTTYPETABLE";
            if (this.macroType.equals("AC") || this.macroType.equals("MC")) {
                string2 = "ACMCTABLE";
            }
            if (this.macroType.equals("OG")) {
                string2 = "OGNGNTTABLE";
            }
            this.queryString = "SELECT DESCR FROM " + this.tableName + string2 + " WHERE OID='" + this.oid + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next() && !(string = this.rs.getString("DESCR")).equals("null")) {
                string = string.replace('\u0096', '#');
                string = string.replace('\u00c8', '\'');
                return string;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return "";
    }

    public String getImpliedNode() {
        try {
            String string;
            this.queryString = "SELECT DEFVAL FROM " + this.tableName + "OBJECTTYPETABLE WHERE OID='" + this.oid + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next() && (string = this.rs.getString("DEFVAL")).indexOf("IMPLIED") != -1) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "[ ],");
                int n = stringTokenizer.countTokens();
                int n2 = 0;
                while (n2 < n - 1) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.equals("IMPLIED")) {
                        return stringTokenizer.nextToken();
                    }
                    ++n2;
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    public Vector getIndexNames() {
        Vector<String> vector = null;
        if (!this.macroType.equals("OTR")) {
            return vector;
        }
        try {
            this.queryString = "SELECT DEFVAL FROM " + this.tableName + "OBJECTTYPETABLE WHERE OID='" + this.oid + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next()) {
                vector = new Vector<String>();
                String string = this.rs.getString("DEFVAL");
                int n = string.length();
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1, n - 3), "[, ]");
                if (string.charAt(n - 2) == '1') {
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (string2.equals("IMPLIED")) continue;
                        vector.addElement(string2);
                    }
                } else if (string.charAt(n - 2) == '2') {
                    MibNode mibNode;
                    if (stringTokenizer.hasMoreTokens()) {
                        string = stringTokenizer.nextToken();
                    }
                    if ((mibNode = JdbcMibNode.getAugmentNode(this.moduleName, string, this.jMibOps)) != null) {
                        return mibNode.getIndexNames();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        if (vector != null && vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public String getLabel() {
        return this.nodeName;
    }

    public String getMacroType() {
        return (String)JdbcMibOperations.macroTable.get(this.macroType);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getNumberedOIDString() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".");
        String string = "";
        while (stringTokenizer.hasMoreTokens()) {
            string = String.valueOf(string) + "." + new Long((long)new Long(stringTokenizer.nextToken()).intValue() & 0xFFFFFFFFL).toString();
        }
        return string;
    }

    public int[] getOID() {
        int n = 0;
        String string = this.getNumberedOIDString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int[] nArray = new int[stringTokenizer.countTokens()];
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n++] = new Long(stringTokenizer.nextToken()).intValue();
        }
        return nArray;
    }

    public String getOIDString() {
        return new JdbcMibModule(this.moduleName, this.jMibOps).translateToNames(this.oid);
    }

    public Vector getOIDVector() {
        Vector<String> vector = new Vector<String>();
        String string = new JdbcMibModule(this.moduleName, this.jMibOps).translateToNames(this.oid);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ". ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }

    public Vector getOIDVectorIds() {
        Vector<Integer> vector = new Vector<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ". ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(new Integer(stringTokenizer.nextToken()));
        }
        return vector;
    }

    public Vector getObjects() {
        if (this.macroType.equals("OG")) {
            return new JdbcObjectGroup(this.moduleName, this.oid, this.jMibOps).getObjects();
        }
        if (this.macroType.equals("NT")) {
            return new JdbcMibNotification(this.moduleName, this.nodeName, this.oid, this.jMibOps).getObjects();
        }
        return null;
    }

    public MibNode getParent() {
        try {
            String string = this.oid.substring(0, this.oid.lastIndexOf("."));
            this.queryString = "SELECT NODENAME,MACROTYPE FROM " + this.tableName + "NODETABLE WHERE OID='" + string + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next()) {
                return new JdbcMibNode(this.moduleName, this.rs.getString("NODENAME"), string, this.rs.getString("MACROTYPE"), this.jMibOps);
            }
            if (JdbcMibOperations.stdNode.containsKey(string)) {
                return new JdbcMibNode(this.moduleName, (String)JdbcMibOperations.stdNode.get(string), string, "OID", this.jMibOps);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    public String getReference() {
        try {
            String string;
            this.queryString = this.macroType.equals("AC") || this.macroType.equals("MC") ? "SELECT REF FROM " + this.tableName + "ACMCTABLE WHERE OID='" + this.oid + "'" : "SELECT REF FROM " + this.tableName + "OBJECTTYPETABLE WHERE OID='" + this.oid + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next() && !(string = this.rs.getString("REF")).equals("null")) {
                return "\"" + string + "\"";
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return "";
    }

    public Vector getRevisionDescriptions() {
        if (this.macroType.equals("MODIDTY")) {
            Vector<String> vector = new Vector<String>();
            Hashtable hashtable = new JdbcMibModuleIdentity(this.moduleName, this.nodeName, this.jMibOps).getRevisionItems();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement((String)enumeration.nextElement());
            }
            return vector;
        }
        return null;
    }

    public Vector getRevisions() {
        if (this.macroType.equals("MODIDTY")) {
            Vector<String> vector = new Vector<String>();
            Hashtable hashtable = new JdbcMibModuleIdentity(this.moduleName, this.nodeName, this.jMibOps).getRevisionItems();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                vector.addElement((String)enumeration.nextElement());
            }
            return vector;
        }
        return null;
    }

    public String getRowName() {
        try {
            if (this.macroType.equals("OTT")) {
                this.queryString = "SELECT SYNT FROM " + this.tableName + "OBJECTTYPETABLE WHERE OID='" + this.oid + "'";
                this.rs = this.jMibOps.executeQuery(this.queryString);
                if (this.rs.next()) {
                    return this.rs.getString("SYNT");
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    public String getStatus() {
        try {
            String string = "";
            string = this.macroType.equals("AC") || this.macroType.equals("MC") ? "ACMCTABLE " : (this.macroType.equals("OG") || this.macroType.equals("NG") || this.macroType.equals("NT") ? "OGNGNTTABLE" : "OBJECTTYPETABLE");
            this.queryString = "SELECT STAT FROM " + this.tableName + string + "  WHERE OID='" + this.oid + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next()) {
                return this.rs.getString("STAT");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    Vector getStdNode(Vector vector) {
        String string = (String)JdbcMibOperations.stdNode.get(this.oid);
        StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".");
        int n = stringTokenizer.countTokens();
        if (string != null) {
            Enumeration enumeration = JdbcMibOperations.stdNode.keys();
            while (enumeration.hasMoreElements()) {
                StringTokenizer stringTokenizer2;
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(this.oid) || (stringTokenizer2 = new StringTokenizer(string2, ".")).countTokens() != n + 1) continue;
                vector.addElement(new JdbcMibNode(this.moduleName, (String)JdbcMibOperations.stdNode.get(string2), string2, "OID", this.jMibOps));
            }
        }
        return vector;
    }

    long getSubID() {
        return new Long(this.oid.substring(this.oid.lastIndexOf(".") + 1, this.oid.length()));
    }

    public int getSubid() {
        return new Long(this.oid.substring(this.oid.lastIndexOf(".") + 1, this.oid.length())).intValue();
    }

    public LeafSyntax getSyntax() {
        try {
            if (!this.macroType.equals("OTT") && !this.macroType.equals("OTR")) {
                String string = "SELECT SYNT FROM " + this.tableName + "OBJECTTYPETABLE WHERE OID ='" + this.oid + "'";
                this.rs = this.jMibOps.executeQuery(string);
                if (this.rs.next() && !this.rs.getString("SYNT").equals("null")) {
                    return new JdbcLeafSyntax(this.moduleName, this.oid, this.jMibOps);
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    public Vector getTableItems() {
        Vector<String> vector = null;
        if (!this.macroType.equals("OTT")) {
            return null;
        }
        String string = this.getTableSequence();
        try {
            if (string != null) {
                this.queryString = "SELECT SEQVAL FROM " + this.tableName + "SEQTABLE WHERE SEQID='" + this.getTableSequence() + "'";
                this.rs = this.jMibOps.executeQuery(this.queryString);
                if (this.rs.next()) {
                    vector = new Vector<String>();
                    StringTokenizer stringTokenizer = new StringTokenizer(this.rs.getString("SEQVAL"), "|");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        vector.addElement(string2.substring(0, string2.indexOf("+")));
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return vector;
    }

    public String getTableSequence() {
        try {
            if (this.macroType.equals("OTT")) {
                this.queryString = "SELECT SYNT FROM " + this.tableName + "OBJECTTYPETABLE WHERE OID='" + this.oid + "'";
                this.rs = this.jMibOps.executeQuery(this.queryString);
                if (this.rs.next()) {
                    return this.rs.getString("SYNT");
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    public boolean isAncestorOf(JdbcMibNode jdbcMibNode) {
        return this.oid.startsWith(jdbcMibNode.oid);
    }

    public boolean isDescendentOf(JdbcMibNode jdbcMibNode) {
        return jdbcMibNode.oid.startsWith(this.oid);
    }

    public boolean isImplied() {
        try {
            String string;
            this.queryString = "SELECT DEFVAL FROM " + this.tableName + "OBJECTTYPETABLE WHERE OID='" + this.oid + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next() && (string = this.rs.getString("DEFVAL")).indexOf("IMPLIED") != -1) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return false;
    }

    public boolean isImportedNode() {
        try {
            this.queryString = "SELECT DEPENDANTMODULENAME  FROM " + this.tableName + "DEPENDANCYTABLE WHERE IMPORTEDNODES LIKE '%|" + this.nodeName + "|%'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next()) {
                return true;
            }
        }
        catch (SQLException sQLException) {}
        return false;
    }

    public boolean isInCurrentTable(String string) {
        Vector vector = this.getTableItems();
        if (vector != null) {
            return this.getTableItems().contains(string);
        }
        return false;
    }

    public boolean isLeaf() {
        return this.getSyntax() != null;
    }

    public boolean isReadable() {
        try {
            this.queryString = "SELECT ACCSS FROM " + this.tableName + "OBJECTTYPETABLE WHERE OID='" + this.oid + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            String string = "";
            if (this.rs.next()) {
                string = this.rs.getString("ACCSS");
            }
            if (string.equals("read-only") || string.equals("read-create") || string.equals("read-write")) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return false;
    }

    public boolean isScalar() {
        return this.macroType.equals("OT") && !this.isTableColumn();
    }

    public boolean isTable() {
        return this.macroType.equals("OTT");
    }

    public boolean isTableColumn() {
        MibNode mibNode = this.getParent();
        if (mibNode == null) {
            return false;
        }
        Vector vector = mibNode.getIndexNames();
        return vector != null;
    }

    public boolean isTableEntry() {
        return this.macroType.equals("OTR");
    }

    public boolean isWriteable() {
        try {
            String string;
            this.queryString = "SELECT ACCSS FROM " + this.tableName + "OBJECTTYPETABLE WHERE OID='" + this.oid + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next() && ((string = this.rs.getString("ACCSS")).equals("write-only") || string.equals("read-write") || string.equals("read-create"))) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return false;
    }

    public String printAccess() {
        try {
            String string;
            this.queryString = "SELECT ACCSS FROM " + this.tableName + "OBJECTTYPETABLE WHERE OID='" + this.oid + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next() && !(string = this.rs.getString("ACCSS")).equals("null")) {
                return string;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    public String printDescription() {
        try {
            String string;
            this.queryString = this.macroType.equals("AC") || this.macroType.equals("MC") ? "SELECT DESCR FROM " + this.tableName + "OGNGNTTABLE WHERE OID='" + this.oid + "'" : "SELECT DESCR FROM " + this.tableName + "OGNGNTTABLE WHERE OID='" + this.oid + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next() && !(string = this.rs.getString("DESCR")).equals("null")) {
                string = string.replace('\u0096', '#');
                string = string.replace('\u00c8', '\'');
                return string;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return this.getDescription();
    }

    public Vector printIndex() {
        return this.getIndexNames();
    }

    public String printReference() {
        try {
            String string;
            this.queryString = this.macroType.equals("AC") || this.macroType.equals("MC") ? "SELECT REF FROM " + this.tableName + "ACMCTABLE WHERE OID='" + this.oid + "'" : "SELECT REF FROM " + this.tableName + "OGNGNTTABLE WHERE OID='" + this.oid + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next() && !(string = this.rs.getString("REF")).equals("null")) {
                return "\"" + string + "\"";
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return this.getReference();
    }

    public String printStatus() {
        try {
            this.queryString = "SELECT STAT FROM " + this.tableName + "OGNGNTTABLE WHERE OID='" + this.oid + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next()) {
                return this.rs.getString("STAT");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return this.getStatus();
    }

    public void setDefval(String string) {
        this.defval = string;
    }

    void setMibModuleName(String string) {
        this.moduleName = string;
    }

    Vector sort(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n - 1) {
            int n3 = 0;
            while (n3 < n - 1 - n2) {
                JdbcMibNode jdbcMibNode = (JdbcMibNode)vector.elementAt(n3);
                JdbcMibNode jdbcMibNode2 = (JdbcMibNode)vector.elementAt(n3 + 1);
                if (jdbcMibNode2.getSubID() < jdbcMibNode.getSubID()) {
                    vector.set(n3, jdbcMibNode2);
                    vector.set(n3 + 1, jdbcMibNode);
                }
                ++n3;
            }
            ++n2;
        }
        return vector;
    }

    public String toString() {
        return this.nodeName;
    }

    public String toTagString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(SnmpUtils.getString("Node OID:")) + " " + this.getOIDString());
        stringBuffer.append("\n" + SnmpUtils.getString("Syntax:") + " " + this.getSyntax());
        stringBuffer.append(", " + SnmpUtils.getString("Access:") + " " + this.printAccess());
        stringBuffer.append(", " + SnmpUtils.getString("Status:") + " " + this.getStatus());
        stringBuffer.append("\n" + SnmpUtils.getString("Description:") + " " + this.getDescription() + "\n");
        stringBuffer.append(String.valueOf(SnmpUtils.getString("Reference:")) + " " + this.getReference());
        stringBuffer.append(", " + SnmpUtils.getString("Index:") + " " + this.getIndexNames());
        stringBuffer.append("\n" + SnmpUtils.getString("TableItems:") + " ");
        if (this.tableItems != null) {
            Enumeration enumeration = this.getTableItems().elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(" " + (String)enumeration.nextElement());
            }
        }
        return stringBuffer.toString();
    }
}

