/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs;

import com.adventnet.snmp.mibs.JdbcLeafSyntax;
import com.adventnet.snmp.mibs.JdbcMibModule;
import com.adventnet.snmp.mibs.JdbcMibNode;
import com.adventnet.snmp.mibs.JdbcMibTC;
import com.adventnet.snmp.mibs.JdbcMibTrap;
import com.adventnet.snmp.mibs.LeafSyntax;
import com.adventnet.snmp.mibs.MibException;
import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.mibs.MibTrap;
import com.adventnet.snmp.mibs.mibparser.MIBConstants;
import com.adventnet.snmp.mibs.mibparser.MIBParser;
import com.adventnet.snmp.snmp2.SASClient;
import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.utils.SnmpUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class JdbcMibOperations
extends MibOperations
implements Serializable,
MIBConstants {
    Connection con = null;
    String queryString = null;
    String moduleName = null;
    ResultSet rs = null;
    Statement stmt = null;
    Statement stmt1 = null;
    Vector moduleVector = new Vector();
    Vector fileNameVector = new Vector();
    Vector revisionModuleNames = new Vector();
    Hashtable allModules = new Hashtable();
    static Hashtable stdNode = new Hashtable();
    static Hashtable stdNodeOID = new Hashtable();
    static Hashtable macroTable = new Hashtable();
    static Hashtable typeHashtable = new Hashtable();
    static Hashtable accessTable = new Hashtable();
    static Hashtable enumTable = new Hashtable();
    static Hashtable rangeTable = new Hashtable();
    static String[] OIDTable = new String[]{"NODETABLE", "OBJECTTYPETABLE", "OGNGNTTABLE", "RANGELISTTABLE", "ACMCTABLE", "MODULEIDTYTABLE", "UNITTABLE"};
    Hashtable cache = new Hashtable();
    Hashtable tableHash = new Hashtable();
    SASClient sas = null;
    String multipleRevision = "";
    MibOperations mibOps = null;
    boolean moduleNotExist = false;
    int maxConnection = 0;
    Vector stmts = new Vector();

    JdbcMibOperations(MibOperations mibOperations) {
        this.initializeStdNodes();
    }

    JdbcMibOperations(String string, String string2, String string3, String string4, MibOperations mibOperations) throws MibException {
        try {
            this.sas = SnmpAPI.getSASClient();
            if (this.sas != null) {
                this.sas.connectDB(string, string2, string3, string4);
            } else {
                Class.forName(string);
                this.con = DriverManager.getConnection(string2, string3, string4);
                System.out.println(SnmpUtils.getString("connection established:"));
                this.stmt = this.con.createStatement();
                this.stmt1 = this.con.createStatement();
            }
            this.mibOps = mibOperations;
            this.initializeStdNodes();
        }
        catch (Exception exception) {
            throw new MibException(exception.toString());
        }
    }

    boolean allModulesResolved(String string) {
        Vector vector = this.getDependentFileNames(string);
        vector.addElement(string);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            string = (String)vector.elementAt(n2);
            if (!this.isResolved(string)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    boolean checkRootNode(String string) {
        try {
            String string2 = "SELECT NODENAME FROM " + this.getTableName(this.moduleName) + "NODETABLE WHERE NODENAME ='" + string + "'";
            ResultSet resultSet = this.executeQuery(string2);
            if (resultSet.next()) {
                return true;
            }
        }
        catch (SQLException sQLException) {}
        return false;
    }

    void deleteMultipleModule() {
        Vector vector = this.getMultipleRevisionModuleNames();
        int n = vector.size();
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            try {
                string = (String)vector.elementAt(n2);
                MIBParser.delete(string, this.mibOps);
            }
            catch (Exception exception) {}
            ++n2;
        }
        try {
            this.queryString = "SELECT MODULENAME FROM MODULETABLE WHERE MODULENAME LIKE '%REVISION%'";
            this.rs = this.executeQuery(this.queryString);
            while (this.rs.next()) {
                string = this.rs.getString("MODULENAME");
                MIBParser.delete(string, this.mibOps);
            }
        }
        catch (SQLException sQLException) {}
    }

    synchronized ResultSet executeQuery(String string) throws SQLException {
        ResultSet resultSet = null;
        Statement statement = null;
        this.sas = SnmpAPI.getSASClient();
        if (this.sas == null) {
            statement = this.maxConnection();
            resultSet = statement.executeQuery(string);
        } else {
            resultSet = this.sas.queryDB(string);
        }
        return resultSet;
    }

    synchronized void executeUpdate(String string) throws SQLException {
        this.sas = SnmpAPI.getSASClient();
        if (this.sas == null) {
            Statement statement = this.maxConnection();
            statement.executeUpdate(string);
        } else {
            this.sas.updateDB(string);
        }
    }

    void getAllDependents(String string) {
        int n = this.moduleVector.indexOf(string);
        try {
            if (!this.moduleVector.contains(string)) {
                this.moduleVector.addElement(string);
            }
            this.queryString = "SELECT DEPENDANTMODULENAME FROM " + this.getTableName(string) + "DEPENDANCYTABLE";
            this.rs = this.executeQuery(this.queryString);
            String string2 = "";
            while (this.rs.next()) {
                string2 = this.rs.getString("DEPENDANTMODULENAME");
                if (this.moduleVector.contains(string2)) continue;
                this.moduleVector.addElement(string2);
            }
            if (n++ < this.moduleVector.size() - 1) {
                this.getAllDependents((String)this.moduleVector.elementAt(n));
            }
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    Vector getDependentFileNames(String string) {
        Vector<String> vector = new Vector<String>();
        ResultSet resultSet = null;
        try {
            String string2 = "SELECT DEPENDANTMODULENAME FROM " + this.getTableName(string) + "DEPENDANCYTABLE";
            resultSet = this.executeQuery(string2);
            while (resultSet.next()) {
                String string3 = resultSet.getString("DEPENDANTMODULENAME");
                ResultSet resultSet2 = null;
                String string4 = "SELECT * FROM " + this.getTableName(string3) + "NODETABLE";
                try {
                    resultSet2 = this.executeQuery(string4);
                }
                catch (SQLException sQLException) {
                    continue;
                }
                vector.addElement(string3);
            }
        }
        catch (SQLException sQLException) {}
        return vector;
    }

    public MibModule getMibModule(JdbcMibNode jdbcMibNode) {
        return new JdbcMibModule(jdbcMibNode.moduleName, this);
    }

    public MibModule getMibModule(String string) {
        try {
            this.queryString = "SELECT MODULENAME FROM MODULETABLE WHERE MODULENAME = '" + string + "'";
            this.rs = this.executeQuery(this.queryString);
            if (this.rs.next()) {
                return new JdbcMibModule(string, this);
            }
        }
        catch (SQLException sQLException) {}
        return null;
    }

    public Enumeration getMibModuleNames() {
        Vector<String> vector = new Vector<String>();
        int n = this.moduleVector.size();
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = (String)this.moduleVector.elementAt(n2);
            vector.addElement(string);
            ++n2;
        }
        return vector.elements();
    }

    public Enumeration getMibModules() {
        Vector<JdbcMibModule> vector = new Vector<JdbcMibModule>();
        int n = this.moduleVector.size();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(new JdbcMibModule((String)this.moduleVector.elementAt(n2), this));
            ++n2;
        }
        return vector.elements();
    }

    public MibNode getMibNode(SnmpOID snmpOID) {
        int n = this.moduleVector.size();
        String string = null;
        int n2 = 0;
        while (n2 < n) {
            string = (String)this.moduleVector.elementAt(n2);
            MibNode mibNode = new JdbcMibModule(string, this).getMibNode(snmpOID);
            if (mibNode != null) {
                return mibNode;
            }
            ++n2;
        }
        return null;
    }

    public MibNode getMibNode(String string) {
        int n = 0;
        while (n < this.moduleVector.size()) {
            String string2 = (String)this.moduleVector.elementAt(n);
            MibNode mibNode = new JdbcMibModule(string2, this).getMibNode(string);
            if (mibNode != null) {
                return mibNode;
            }
            ++n;
        }
        return null;
    }

    public MibNode getMibNode(String string, String string2) {
        return new JdbcMibModule(string2, this).getMibNode(string);
    }

    public MibNode getMibNode(Vector vector) {
        int n = this.moduleVector.size();
        String string = null;
        int n2 = 0;
        while (n2 < this.moduleVector.size()) {
            string = (String)this.moduleVector.elementAt(n2);
            MibNode mibNode = new JdbcMibModule(string, this).getMibNode(vector);
            if (mibNode != null) {
                return mibNode;
            }
            ++n2;
        }
        return null;
    }

    public MibTrap getMibTrap(SnmpOID snmpOID, int n, int n2) {
        String string = this.getMibNode(snmpOID.toString()).getLabel();
        int n3 = n;
        if (n == 6) {
            n3 = n2;
        }
        try {
            this.queryString = "SELECT MODULETRAPNAME FROM " + this.getTableName(this.moduleName) + "TRAPTABLE WHERE  ENTERPRISES='" + string + "' AND TRAPTYPE='" + n3 + "'";
            this.rs = this.executeQuery(this.queryString);
            if (this.rs.next()) {
                String string2 = this.rs.getString("MODULETRAPNAME");
                return new JdbcMibTrap(this.moduleName, string2, this);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    public int getModuleSize() {
        return this.moduleVector.size();
    }

    public String getMultipleRevision() {
        return this.multipleRevision;
    }

    Vector getMultipleRevisionModuleNames() {
        if (this.isMultipleRevision()) {
            if (this.revisionModuleNames.size() > 0) {
                return this.revisionModuleNames;
            }
            String string = this.getMultipleRevision();
            String string2 = "";
            String string3 = "";
            Vector vector = new Vector();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " |");
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                try {
                    string2 = this.getModuleNameDefinition(string3);
                    if (this.revisionModuleNames.contains(string2)) continue;
                    this.revisionModuleNames.addElement(string2);
                }
                catch (Exception exception) {}
            }
        }
        return this.revisionModuleNames;
    }

    public MibNode getNearestNode(SnmpOID snmpOID) {
        if (snmpOID == null) {
            return null;
        }
        MibNode mibNode = this.getMibNode(snmpOID);
        if (mibNode == null) {
            SnmpOID snmpOID2 = null;
            String string = snmpOID.toString();
            int n = string.lastIndexOf(".");
            if (n > 1) {
                string = string.substring(0, n);
                try {
                    snmpOID2 = new SnmpOID(string);
                }
                catch (Exception exception) {
                    return null;
                }
                return this.getNearestNode(snmpOID2);
            }
        }
        return mibNode;
    }

    public Vector getNodesFromNames(Vector vector) {
        int n = vector.size();
        Vector<MibNode> vector2 = new Vector<MibNode>();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)vector.elementAt(n2);
            MibNode mibNode = this.getMibNode(string);
            if (mibNode != null) {
                vector2.addElement(mibNode);
            }
            ++n2;
        }
        return vector2;
    }

    public Vector getNodesFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        Vector<MibNode> vector = new Vector<MibNode>();
        int n2 = 0;
        while (n2 < n) {
            MibNode mibNode = this.getMibNode(stringTokenizer.nextToken());
            if (mibNode != null) {
                vector.addElement(mibNode);
            }
            ++n2;
        }
        return null;
    }

    void getRevisionModule(String string) {
        String string2 = (String)this.allModules.get(string);
        if (this.fileNameVector.contains(string2)) {
            this.moduleVector.removeElement(string);
            this.revertBack();
            return;
        }
        if (this.checkMultipleRevision(string2)) {
            this.fileNameVector.addElement(string2);
            this.moduleVector.removeElement(string);
            String string3 = this.getRevisionModuleName(string);
            if (string3 != null) {
                this.moduleVector.addElement(string3);
                this.allModules.remove(string);
                this.allModules.put(string3, string2);
                this.tableHash.remove(string);
                this.updateModuleRevisionName(string, string3);
            }
        }
        this.revertBack();
    }

    public SnmpOID getSnmpOID(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        if (!string.startsWith(".")) {
            string = ".1.3.6.1.2.1." + string;
        }
        String string2 = null;
        SnmpOID snmpOID = null;
        int n = 0;
        while (n < this.moduleVector.size()) {
            string2 = (String)this.moduleVector.elementAt(n);
            snmpOID = new JdbcMibModule(string2, this).getSnmpOID(string);
            if (snmpOID != null && snmpOID.toString() != null) {
                return snmpOID;
            }
            ++n;
        }
        if (this.moduleVector.size() == 0 && (snmpOID = new SnmpOID(string)) != null && snmpOID.toString() != null) {
            return snmpOID;
        }
        String string3 = "";
        String string4 = "";
        int n2 = 0;
        while ((n2 = string.lastIndexOf(".")) != -1) {
            string4 = string.substring(n2 + 1, string.length());
            string = string.substring(0, n2);
            try {
                Long.parseLong(string4);
                string3 = "." + string4 + string3;
            }
            catch (NumberFormatException numberFormatException) {
                MibNode mibNode = this.getMibNode(String.valueOf(string) + "." + string4);
                if (mibNode != null) {
                    return new SnmpOID(String.valueOf(mibNode.getNumberedOIDString()) + string3);
                }
                return null;
            }
        }
        return null;
    }

    public LeafSyntax getSyntaxByName(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        int n = this.moduleVector.size();
        String string2 = null;
        if (MIBParser.wellKnownTCs.containsKey(string) || !typeHashtable.containsKey(string)) {
            int n2 = 0;
            while (n2 < n) {
                string2 = (String)this.moduleVector.elementAt(n2);
                try {
                    this.queryString = "SELECT OID FROM " + this.getTableName(string2) + "OBJECTTYPETABLE WHERE SYNT='" + string + "'";
                    this.rs = this.executeQuery(this.queryString);
                    if (this.rs.next()) {
                        return new JdbcLeafSyntax(string2, this.rs.getString("OID"), this);
                    }
                    this.queryString = "SELECT MODULETCNAME FROM " + this.getTableName(string2) + "TCTABLE WHERE MODULETCNAME='" + string + "'";
                    this.rs = this.executeQuery(this.queryString);
                    if (this.rs.next()) {
                        return new JdbcMibTC(string2, string, this);
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                ++n2;
            }
        } else if (typeHashtable.containsKey(string)) {
            return new JdbcLeafSyntax("", string, this);
        }
        return null;
    }

    synchronized String getTableName(String string) {
        if (this.tableHash.containsKey(string)) {
            return (String)this.tableHash.get(string);
        }
        String string2 = "SELECT TABLENAME FROM MODULETABLE WHERE MODULENAME='" + string + "'";
        ResultSet resultSet = null;
        String string3 = "";
        try {
            resultSet = this.executeQuery(string2);
            if (resultSet.next()) {
                string3 = resultSet.getString("TABLENAME");
            }
        }
        catch (SQLException sQLException) {}
        if (!string3.equals("") || !string3.equals("null")) {
            this.tableHash.put(string, string3);
        }
        return string3;
    }

    void initializeStdNodes() {
        stdNodeOID.put("ccitt", ".0");
        stdNodeOID.put("iso", ".1");
        stdNodeOID.put("joint-ccitt-iso", ".2");
        stdNodeOID.put("org", ".1.3");
        stdNodeOID.put("dod", ".1.3.6");
        stdNodeOID.put("internet", ".1.3.6.1");
        stdNodeOID.put("directory", ".1.3.6.1.1");
        stdNodeOID.put("mgmt", ".1.3.6.1.2");
        stdNodeOID.put("experimental", ".1.3.6.1.3");
        stdNodeOID.put("private", ".1.3.6.1.4");
        stdNodeOID.put("snmpV2", ".1.3.6.1.6");
        stdNodeOID.put("enterprises", ".1.3.6.1.4.1");
        stdNodeOID.put("mib-2", ".1.3.6.1.2.1");
        stdNodeOID.put("snmpDomains", ".1.3.6.1.6.1");
        stdNodeOID.put("snmpProxys", ".1.3.6.1.6.2");
        stdNodeOID.put("snmpModules", ".1.3.6.1.6.3");
        stdNodeOID.put("security", ".1.3.6.1.5");
        stdNodeOID.put("transmission", ".1.3.6.1.2.1.10");
        stdNodeOID.put("zeroDotZero", ".0.0");
        stdNode.put(".0", "ccitt");
        stdNode.put(".1", "iso");
        stdNode.put(".2", "joint-iso-ccitt");
        stdNode.put(".1.3", "org");
        stdNode.put(".1.3.6", "dod");
        stdNode.put(".1.3.6.1", "internet");
        stdNode.put(".1.3.6.1.1", "directory");
        stdNode.put(".1.3.6.1.2", "mgmt");
        stdNode.put(".1.3.6.1.3", "experimental");
        stdNode.put(".1.3.6.1.4", "private");
        stdNode.put(".1.3.6.1.6", "snmpV2");
        stdNode.put(".1.3.6.1.4.1", "enterprises");
        stdNode.put(".1.3.6.1.2.1", "mib-2");
        stdNode.put(".1.3.6.1.6.1", "snmpDomains");
        stdNode.put(".1.3.6.1.6.2", "snmpProxys");
        stdNode.put(".1.3.6.1.6.3", "snmpModules");
        stdNode.put(".1.3.6.1.5", "security");
        stdNode.put(".1.3.6.1.2.1.10", "transmission");
        stdNode.put(".0.0", "zeroDotZero");
        accessTable.put("not-accessible", new Integer(0));
        accessTable.put("read-only", new Integer(43690));
        accessTable.put("read-write", new Integer(43706));
        accessTable.put("write-only", new Integer(43691));
        accessTable.put("read-create", new Integer(43708));
        accessTable.put("accessible-for-notify", new Integer(1));
        macroTable.put("OT", "OBJECT-TYPE");
        macroTable.put("OTT", "OBJECT-TYPE");
        macroTable.put("OTR", "OBJECT-TYPE");
        macroTable.put("MC", "MODULE-COMPLIANCE");
        macroTable.put("NG", "NOTIFICATION-GROUP");
        macroTable.put("OG", "OBJECT-GROUP");
        macroTable.put("OIDTY", "OBJECT-IDENTITY");
        macroTable.put("MODIDTY", "MODULE-IDENTITY");
        macroTable.put("OID", "OBJECT IDENTIFIER");
        macroTable.put("AC", "AGENT-CAPABILITIES");
        macroTable.put("NT", "NOTIFICATION-TYPE");
        typeHashtable.put("OCTET STRING", "0x04");
        typeHashtable.put("IpAddress", "0x40");
        typeHashtable.put("Opaque", "0x44");
        typeHashtable.put("NetworkAddress", "0x40");
        typeHashtable.put("BIT STRING", "0x03");
        typeHashtable.put("BITS", "0x04");
        typeHashtable.put("INTEGER", "0x02");
        typeHashtable.put("Integer32", "0x02");
        typeHashtable.put("Unsigned32", "0x42");
        typeHashtable.put("Gauge", "0x42");
        typeHashtable.put("Gauge32", "0x42");
        typeHashtable.put("Counter", "0x41");
        typeHashtable.put("Counter32", "0x41");
        typeHashtable.put("TimeTicks", "0x43");
        typeHashtable.put("Counter64", "0x46");
        typeHashtable.put("OBJECT IDENTIFIER", "0x06");
        typeHashtable.put("TimeStamp", "0x43");
        typeHashtable.put("TimeInterval", "0x02");
        typeHashtable.put("DisplayString", "0x04");
        typeHashtable.put("PhysAddress", "0x04");
        typeHashtable.put("MacAddress", "0x04");
        typeHashtable.put("DateAndTime", "0x04");
        typeHashtable.put("RowStatus", "0x02");
        typeHashtable.put("StorageType", "0x02");
        typeHashtable.put("TruthValue", "0x02");
        typeHashtable.put("TestAndIncr", "0x02");
        typeHashtable.put("AutonomousType", "0x06");
        typeHashtable.put("VariablePointer", "0x06");
        typeHashtable.put("RowPointer", "0x06");
        typeHashtable.put("TDomain", "0x06");
        typeHashtable.put("ObjectName", "0x06");
        typeHashtable.put("ObjectSyntax", "0x06");
        typeHashtable.put("TAddress", "0x04");
        enumTable.put("RowStatus", "active,1,notInService,2,notReady,3,createAndGo,4, createAndWait,5,destroy,6");
        enumTable.put("StorageType", "other,1,volatile,2,nonVolatile,3,permanent,4,readOnly,5");
        enumTable.put("TruthValue", "true,1,false,2");
        rangeTable.put("DisplayString", "0,255");
        rangeTable.put("MacAddress", "6,6");
        rangeTable.put("DateAndTime", "8,8,11,11");
        rangeTable.put("TAddress", "1,255");
        rangeTable.put("INTEGER", "-2147483648,2147483647");
        rangeTable.put("Integer32", "-2147483648,2147483647");
        rangeTable.put("Unsigned32", "0,4294967295");
        rangeTable.put("Gauge", "0,4294967295");
        rangeTable.put("Gauge32", "0,4294967295");
        rangeTable.put("Counter", "0,4294967295");
        rangeTable.put("Counter32", "0,4294967295");
        rangeTable.put("TimeTicks", "0,4294967295");
        rangeTable.put("Counter64", "0,9223372036854775807");
    }

    boolean isExist(String string) {
        try {
            String string2 = "SELECT MODULENAME FROM MODULETABLE WHERE MODULENAME='" + string + "'";
            this.rs = this.executeQuery(string2);
            if (this.rs.next()) {
                return true;
            }
        }
        catch (SQLException sQLException) {}
        return false;
    }

    boolean isResolved(String string) {
        String string2 = "SELECT RESOLVED FROM MODULETABLE WHERE MODULENAME='" + string + "'";
        try {
            this.rs = this.executeQuery(string2);
            if (this.rs.next()) {
                if (this.rs.getString("RESOLVED").trim().equals("true")) {
                    return true;
                }
            } else {
                this.moduleNotExist = true;
            }
        }
        catch (SQLException sQLException) {}
        return false;
    }

    public void loadJdbcMibModules(String string) throws MibException, IOException, FileNotFoundException {
        this.moduleName = string;
        this.unloadMibModule(this.moduleName);
        if (!this.moduleVector.contains(this.moduleName)) {
            this.moduleVector.addElement(this.moduleName);
        }
        this.getAllDependents(this.moduleName);
        int n = this.moduleVector.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)this.moduleVector.elementAt(n2);
            if (!this.isResolved(string2)) {
                try {
                    this.resolveRootNodes(string2);
                }
                catch (SQLException sQLException) {}
            } else if (this.moduleNotExist) {
                this.moduleVector.removeElement(string2);
                --n;
                --n2;
                this.moduleNotExist = false;
            }
            ++n2;
        }
        if (this.isMultipleRevision() && this.allModulesResolved(this.moduleName)) {
            this.getRevisionModule(this.moduleName);
        }
    }

    Statement maxConnection() {
        try {
            this.maxConnection = this.stmts.size();
            if (this.maxConnection > 500) {
                int n = 0;
                while (n < this.maxConnection - 400) {
                    try {
                        Statement statement = (Statement)this.stmts.elementAt(n);
                        statement.close();
                        this.stmts.remove(statement);
                        statement = null;
                    }
                    catch (Exception exception) {}
                    ++n;
                }
                this.maxConnection -= 400;
            }
            this.stmt = this.con.createStatement();
            this.stmts.addElement(this.stmt);
        }
        catch (SQLException sQLException) {}
        return this.stmt;
    }

    void put(String string, String string2) {
        this.allModules.put(string, string2);
    }

    void resolveRootNodes(String string) throws SQLException {
        Object var2_2 = null;
        String string2 = null;
        String string3 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        String string4 = null;
        String string5 = null;
        int n = -1;
        if (string == null) {
            return;
        }
        String string6 = "SELECT OTHERROOTNODES FROM MODULETABLE WHERE MODULENAME='" + string + "'";
        this.rs = this.executeQuery(string6);
        if (this.rs.next()) {
            string3 = this.rs.getString("OTHERROOTNODES");
            StringTokenizer stringTokenizer = new StringTokenizer(this.rs.getString("OTHERROOTNODES"), "|");
            while (stringTokenizer.hasMoreTokens()) {
                ResultSet resultSet;
                String string7;
                string2 = stringTokenizer.nextToken();
                string5 = (String)stdNodeOID.get(string2);
                if (string5 != null) {
                    this.updateOID(string, string5, new Integer(n--).toString());
                    this.updateImportOID(string, string5, string2);
                    continue;
                }
                String string8 = "SELECT DEPENDANTMODULENAME FROM " + this.getTableName(string) + "DEPENDANCYTABLE WHERE IMPORTEDNODES LIKE '%|" + string2 + "|%'";
                ResultSet resultSet2 = this.executeQuery(string8);
                if (resultSet2.next()) {
                    String string9 = resultSet2.getString("DEPENDANTMODULENAME");
                    string7 = "SELECT OID FROM " + this.getTableName(string9) + "NODETABLE WHERE NODENAME='" + string2 + "'";
                    resultSet = this.executeQuery(string7);
                    if (!resultSet.next()) continue;
                    string4 = resultSet.getString("OID");
                    if (string4.indexOf("-") != -1) {
                        this.resolveRootNodes(string9);
                        this.resolveRootNodes(string);
                    }
                    this.updateOID(string, string4, new Integer(n--).toString());
                    this.updateImportOID(string, string4, string2);
                    continue;
                }
                string7 = "SELECT OID FROM " + this.getTableName(string) + "NODETABLE WHERE NODENAME='" + string2 + "'";
                resultSet = this.executeQuery(string7);
                if (!resultSet.next()) continue;
                String string10 = resultSet.getString("OID");
                this.updateOID(string, string10, new Integer(n--).toString());
            }
        }
        this.setResolved(string);
    }

    public void setMultipleRevision(String string) {
        this.multipleRevision = string;
        this.revisionModuleNames.removeAllElements();
        this.deleteMultipleModule();
    }

    void setResolved(String string) throws SQLException {
        String string2 = "SELECT * FROM " + this.getTableName(string) + "NODETABLE WHERE OID LIKE '-%'";
        ResultSet resultSet = this.executeQuery(string2);
        if (resultSet.next()) {
            this.resolveRootNodes(string);
        }
        String string3 = "UPDATE MODULETABLE SET RESOLVED='true' WHERE MODULENAME='" + string + "'";
        this.executeUpdate(string3);
    }

    public void unloadAllMibModules() {
        this.cache.clear();
        this.moduleVector.clear();
        this.tableHash.clear();
    }

    public boolean unloadMibModule(MibModule mibModule) {
        String string = "";
        String string2 = mibModule.getName();
        Enumeration enumeration = this.cache.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.indexOf(string2) == -1) continue;
            this.cache.remove(string);
        }
        String string3 = mibModule.getName();
        this.tableHash.remove(string3);
        return this.moduleVector.removeElement(string3);
    }

    public MibModule unloadMibModule(String string) {
        String string2 = "";
        Enumeration enumeration = this.cache.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (string2.indexOf(string) == -1) continue;
            this.cache.remove(string2);
        }
        this.tableHash.remove(string);
        this.moduleVector.removeElement(string);
        return new JdbcMibModule(string, this);
    }

    void updateImportOID(String string, String string2, String string3) {
        String string4 = this.getTableName(string);
        if (this.checkRootNode(string3)) {
            return;
        }
        if (string3.equals("iso")) {
            return;
        }
        try {
            String string5 = "SELECT OID FROM " + string4 + "NODETABLE WHERE OID='" + string2 + "'";
            ResultSet resultSet = this.executeQuery(string5);
            if (!resultSet.next()) {
                String string6 = "INSERT INTO " + string4 + "NODETABLE  VALUES ('" + string2 + "','" + string3 + "' , 'OID')";
                if (this.sas != null) {
                    this.sas.updateDB(string6);
                } else {
                    this.executeUpdate(string6);
                }
            }
            string2 = string2.substring(0, string2.lastIndexOf("."));
            while (string3 != null && !stdNodeOID.containsKey(string3) && !string2.equals(".0")) {
                int n = 0;
                while (n < this.moduleVector.size()) {
                    String string7 = (String)this.moduleVector.elementAt(n);
                    String string8 = "SELECT NODENAME, OID FROM " + this.getTableName(string7) + "NODETABLE WHERE OID='" + string2 + "'";
                    resultSet = this.executeQuery(string8);
                    if (resultSet.next() && (string3 = resultSet.getString("NODENAME")) != null) {
                        String string9 = "INSERT INTO " + this.getTableName(string) + "NODETABLE  VALUES ('" + string2 + "','" + string3 + "' , 'OID' )";
                        this.executeUpdate(string9);
                        this.updateOtherRootNodes(string, string3);
                        break;
                    }
                    ++n;
                }
                int n2 = string2.lastIndexOf(".");
                if (n2 == -1) {
                    return;
                }
                string2 = string2.substring(0, string2.lastIndexOf("."));
            }
        }
        catch (SQLException sQLException) {}
    }

    void updateModuleRevisionName(String string, String string2) {
        String string3 = "UPDATE MODULETABLE  SET MODULENAME ='" + string2 + "' WHERE MODULENAME='" + string + "'";
        try {
            this.executeUpdate(string3);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    void updateOID(String string, String string2, String string3) {
        String string4 = "";
        int n = 0;
        while (n < OIDTable.length) {
            string4 = String.valueOf(this.getTableName(string)) + OIDTable[n];
            String string5 = "SELECT OID FROM " + string4 + " WHERE OID LIKE '." + string3 + "%'";
            if (OIDTable[n].equals("MODULEIDTYTABLE") || OIDTable[n].equals("UNITTABLE")) {
                string5 = "SELECT OID FROM " + string4 + " WHERE OID LIKE '." + string3 + "%'";
            }
            ResultSet resultSet = null;
            try {
                resultSet = this.executeQuery(string5);
                while (resultSet.next()) {
                    String string6 = resultSet.getString("OID");
                    StringBuffer stringBuffer = new StringBuffer(string6.substring(string3.length() + 1));
                    stringBuffer.insert(0, string2.toString());
                    String string7 = "UPDATE " + string4 + " SET OID='" + stringBuffer.toString() + "' WHERE OID='" + string6 + "'";
                    this.executeUpdate(string7);
                }
            }
            catch (SQLException sQLException) {}
            ++n;
        }
    }

    void updateOtherRootNodes(String string, String string2) {
        ResultSet resultSet = null;
        try {
            String string3 = "SELECT OTHERROOTNODES FROM MODULETABLE WHERE MODULENAME='" + string + "'";
            resultSet = this.executeQuery(string3);
            if (resultSet.next()) {
                String string4 = String.valueOf(resultSet.getString("OTHERROOTNODES")) + "|" + string2 + "|";
                String string5 = "UPDATE MODULETABLE SET OTHERROOTNODES ='" + string4 + "' WHERE MODULENAME='" + string + "'";
                this.executeUpdate(string5);
            }
        }
        catch (SQLException sQLException) {}
    }
}

