/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs;

import com.adventnet.snmp.mibs.JdbcMibModule;
import com.adventnet.snmp.mibs.JdbcMibOperations;
import com.adventnet.snmp.mibs.MibTrap;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.utils.SnmpUtils;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;

class JdbcMibTrap
extends MibTrap
implements Serializable {
    String moduleName = null;
    String name = null;
    String enterprise = null;
    String description = null;
    String reference = null;
    Vector variables = null;
    int value;
    String queryString = null;
    ResultSet rs = null;
    String tableName = "";
    JdbcMibOperations jMibOps = null;

    public JdbcMibTrap() {
    }

    JdbcMibTrap(String string, String string2, JdbcMibOperations jdbcMibOperations) {
        this.moduleName = string;
        this.name = string2;
        this.jMibOps = jdbcMibOperations;
        this.tableName = this.jMibOps.getTableName(this.moduleName);
    }

    public String getDescription() {
        try {
            String string;
            this.queryString = "SELECT DESCR FROM " + this.tableName + "TRAPTABLE WHERE MODULETRAPNAME='" + this.name + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next() && !(string = this.rs.getString("DESCR")).equals("null")) {
                string = string.replace('\u0096', '#');
                string = string.replace('\u00c8', '\'');
                return "\"" + string + "\"";
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return "";
    }

    public SnmpOID getEnterprise() {
        return new SnmpOID(new JdbcMibModule(this.moduleName, this.jMibOps).getMibNodeByName(this.getEnterpriseString()).getNumberedOIDString());
    }

    public String getEnterpriseString() {
        try {
            this.queryString = "SELECT ENTERPRISES FROM " + this.tableName + "TRAPTABLE WHERE MODULETRAPNAME = '" + this.name + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next()) {
                return this.rs.getString("ENTERPRISES");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return null;
    }

    public String getModuleName() {
        return this.moduleName.replace('_', '-');
    }

    public String getName() {
        return this.name;
    }

    public String getReference() {
        try {
            String string;
            this.queryString = "SELECT REF FROM " + this.tableName + "TRAPTABLE WHERE MODULETRAPNAME='" + this.name + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next() && !(string = this.rs.getString("REF")).equals("null")) {
                return "\"" + string + "\"";
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return "";
    }

    public int getValue() {
        try {
            this.queryString = "SELECT TRAPTYPE FROM " + this.tableName + "TRAPTABLE WHERE MODULETRAPNAME='" + this.name + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next()) {
                return Integer.parseInt(this.rs.getString("TRAPTYPE"));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return -1;
    }

    public Vector getVariables() {
        Vector<String> vector = new Vector<String>();
        try {
            this.queryString = "SELECT VARIABLES FROM " + this.tableName + "TRAPTABLE WHERE MODULETRAPNAME ='" + this.name + "'";
            this.rs = this.jMibOps.executeQuery(this.queryString);
            if (this.rs.next()) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.rs.getString("VARIABLES"), "[, ]");
                int n = stringTokenizer.countTokens();
                if (n == 0) {
                    return vector;
                }
                int n2 = 0;
                while (n2 < n) {
                    vector.addElement(stringTokenizer.nextToken());
                    ++n2;
                }
                return vector;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return vector;
    }

    public String toString() {
        return this.name;
    }

    public String toTagString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getVariables().toString();
        string = "{" + string.substring(1, string.length() - 1) + "}";
        String string2 = String.valueOf(this.name) + " " + SnmpUtils.getString("TRAP-TYPE") + "\n\t" + SnmpUtils.getString("ENTERPRISE") + "\t" + this.getEnterpriseString() + "\n\t" + SnmpUtils.getString("VARIABLES") + "\t" + string + "\n\t" + SnmpUtils.getString("DESCRIPTION") + "\t" + this.getDescription() + "\n\t" + SnmpUtils.getString("REFERENCE") + "\t" + this.getReference() + "\n\t::=\t" + this.getValue();
        return string2;
    }
}

