/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs;

import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.mibs.MibTC;
import com.adventnet.snmp.mibs.RangeList;
import com.adventnet.snmp.mibs.SnmpDateAndTime;
import com.adventnet.snmp.mibs.mibparser.BaseSyntax;
import com.adventnet.snmp.mibs.mibparser.MIBConstants;
import com.adventnet.snmp.mibs.mibparser.SyntaxTextualConvention;
import com.adventnet.snmp.snmp2.SnmpCounter;
import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.snmp.snmp2.SnmpGauge;
import com.adventnet.snmp.snmp2.SnmpInt;
import com.adventnet.snmp.snmp2.SnmpIpAddress;
import com.adventnet.snmp.snmp2.SnmpNetworkAddress;
import com.adventnet.snmp.snmp2.SnmpNull;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpOpaque;
import com.adventnet.snmp.snmp2.SnmpString;
import com.adventnet.snmp.snmp2.SnmpTimeticks;
import com.adventnet.snmp.snmp2.SnmpUnsignedInt;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.utils.SnmpUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class LeafSyntax
implements Serializable,
MIBConstants,
Cloneable {
    String name = null;
    byte type;
    String equivName;
    int size = Integer.MAX_VALUE;
    long MIN = Integer.MIN_VALUE;
    long MAX = Integer.MAX_VALUE;
    LeafSyntax syntax = this;
    RangeList range = null;
    int node_type;

    LeafSyntax() {
    }

    LeafSyntax(byte by, String string, RangeList rangeList) {
        this(string, by);
        this.range = rangeList;
        this.type = by;
    }

    LeafSyntax(int n, String string, RangeList rangeList) {
        this(string, LeafSyntax.getSnmpType(n));
        this.range = rangeList;
        this.node_type = n;
    }

    LeafSyntax(String string, byte by) {
        this.name = string;
        this.type = by;
        if (by == 64) {
            this.size = 4;
        } else if (by == 66) {
            this.MIN = 0L;
            this.MAX = 0xFFFFFFFFL;
        } else if (by == 65) {
            this.MIN = 0L;
            this.MAX = 0xFFFFFFFFL;
        } else if (by == 67) {
            this.MIN = 0L;
            this.MAX = 0xFFFFFFFFL;
        } else if (by == 4) {
            this.MIN = 0L;
        }
    }

    public boolean checkValue(int n) {
        if (this.range != null) {
            return this.range.isValid(n);
        }
        if (n < new Long(this.getMin()).intValue()) {
            return false;
        }
        return n <= new Long(this.getMax()).intValue();
    }

    public boolean checkValue(String string) {
        if (this.range != null) {
            return this.range.isValid(string);
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        LeafSyntax leafSyntax = (LeafSyntax)super.clone();
        if (this instanceof MibTC) {
            RangeList rangeList = this.getSyntax().range;
            if (rangeList != null) {
                leafSyntax.range = (RangeList)rangeList.clone();
            }
            leafSyntax.type = leafSyntax.getType();
            return leafSyntax;
        }
        if (this.range != null) {
            leafSyntax.range = (RangeList)this.range.clone();
        }
        return leafSyntax;
    }

    public SnmpVar createVariable(String string) throws SnmpException {
        return this.createVariable(string, null);
    }

    public SnmpVar createVariable(String string, String string2) throws SnmpException {
        if (this.type == 0) {
            this.getType();
        }
        if (MibOperations.jdbc) {
            this.type = this.getType();
        }
        if (this.type == 4) {
            int n;
            Object object;
            String string3 = this.getName();
            if (string3.equals("DateAndTime")) {
                try {
                    SnmpDateAndTime snmpDateAndTime = new SnmpDateAndTime(string);
                    if (snmpDateAndTime != null) {
                        object = snmpDateAndTime.byteValue();
                        string = "";
                        n = 0;
                        while (n < ((Object)object).length) {
                            int n2 = object[n] & 0xFF;
                            string = String.valueOf(string) + Integer.toHexString(n2) + ":";
                            ++n;
                        }
                        string = "'" + string.substring(0, string.length() - 1) + "'";
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
            }
            if (string3.equals("MacAddress")) {
                int n3 = 0;
                object = new StringTokenizer(string, ":");
                if (((StringTokenizer)object).countTokens() != 6) {
                    throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid format for:")) + " " + string);
                }
                byte[] byArray = new byte[6];
                while (((StringTokenizer)object).hasMoreTokens()) {
                    try {
                        n = Integer.parseInt(((StringTokenizer)object).nextToken(), 16);
                        if (n > 255) {
                            throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid format for:")) + " " + string);
                        }
                        byArray[n3++] = (byte)(n & 0xFF);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SnmpException(String.valueOf(numberFormatException.getMessage()) + ":" + string);
                    }
                }
                return new SnmpString(byArray);
            }
            return new SnmpString(string, string2);
        }
        if (this.type == 64) {
            if (MibOperations.jdbc && this.getName().equals("NetworkAddress") || this.node_type == 99) {
                return new SnmpNetworkAddress(string);
            }
            return new SnmpIpAddress(string);
        }
        if (this.type == 5) {
            return new SnmpNull();
        }
        if (this.type == 68) {
            return new SnmpOpaque(string);
        }
        if (this.type == 6) {
            return new SnmpOID(string);
        }
        if (this.type == 2) {
            int n;
            block37: {
                n = 0;
                try {
                    if (this.isEnumerated()) {
                        string = string.indexOf("(") != -1 ? string.substring(0, string.indexOf("(")).trim() : string.trim();
                        n = this.getInt(string);
                        if (n == -1 && this.getLabel(n = Integer.parseInt(string)) == null) {
                            throw new Exception();
                        }
                        break block37;
                    }
                    try {
                        String string4 = this.parseHexFormat(string);
                        n = string4 != null ? Integer.parseInt(string4) : Integer.parseInt(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid format for :")) + " " + string);
                    }
                }
                catch (Exception exception) {
                    throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid format for :")) + " " + string);
                }
            }
            return new SnmpInt(n);
        }
        if (this.type == 67) {
            long l;
            try {
                String string5 = this.parseHexFormat(string);
                l = string5 != null ? new Long(string5).longValue() : new Long(string).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid format for :")) + " " + string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid format for :")) + " " + string);
            }
            return new SnmpTimeticks(l);
        }
        if (this.type == 65) {
            long l;
            try {
                String string6 = this.parseHexFormat(string);
                l = string6 != null ? new Long(string6).longValue() : new Long(string).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid format for :")) + " " + string);
            }
            return new SnmpCounter(l);
        }
        if (this.type == 66) {
            long l;
            try {
                String string7 = this.parseHexFormat(string);
                l = string7 != null ? new Long(string7).longValue() : new Long(string).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid format for :")) + " " + string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid format for :")) + " " + string);
            }
            return new SnmpGauge(l);
        }
        return null;
    }

    public Vector decodeInstanceString(String string, Vector vector) throws NumberFormatException {
        long[] lArray = LeafSyntax.stringToArray(string);
        int n = 0;
        Vector<Object> vector2 = new Vector<Object>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                Object object;
                Object object2;
                if (n == lArray.length) {
                    object2 = "";
                    if (enumeration.hasMoreElements()) {
                        object2 = ((MibNode)enumeration.nextElement()).getLabel();
                    }
                    System.err.println(SnmpUtils.getString("The instance value is absent for the index mib node :" + (String)object2));
                    return null;
                }
                object2 = new SnmpNull();
                MibNode mibNode = (MibNode)enumeration.nextElement();
                if (mibNode == null || mibNode.getSyntax() == null) {
                    if (MibOperations.errMsg) {
                        System.err.println(String.valueOf(SnmpUtils.getString("Missing MIB node or leaf node.")) + " \n" + mibNode);
                    }
                    return null;
                }
                LeafSyntax leafSyntax = mibNode.getSyntax();
                if (leafSyntax.getType() == 66 || leafSyntax.getType() == 66 || leafSyntax.getType() == 65 || leafSyntax.getType() == 2 || leafSyntax.getType() == 67) {
                    object2 = leafSyntax.createVariable(String.valueOf(lArray[n++]));
                }
                if (leafSyntax.getType() == 6) {
                    boolean bl = mibNode.label.startsWith("IMPLIED");
                    if (mibNode.isImplied()) {
                        bl = true;
                    }
                    int n2 = lArray.length - n;
                    if (!bl) {
                        n2 = (int)lArray[n++];
                    }
                    object = new int[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        object[n3] = (int)lArray[n++];
                        ++n3;
                    }
                    object2 = new SnmpOID((int[])object);
                }
                if (leafSyntax.getType() == 64) {
                    String string2 = leafSyntax.name;
                    if (MibOperations.jdbc) {
                        string2 = leafSyntax.getName();
                    }
                    if (string2.equals("NetworkAddress")) {
                        ++n;
                    }
                    byte[] byArray = new byte[4];
                    int n4 = 0;
                    while (n4 < 4) {
                        byArray[n4] = (byte)lArray[n++];
                        ++n4;
                    }
                    object2 = string2.equals("NetworkAddress") ? new SnmpNetworkAddress(byArray) : new SnmpIpAddress(byArray);
                }
                if (leafSyntax.getType() == 4 || leafSyntax.getType() == 68) {
                    boolean bl = mibNode.label.startsWith("IMPLIED");
                    if (mibNode.isImplied()) {
                        bl = true;
                    }
                    int n5 = lArray.length - n;
                    object = (MibNode)vector.elementAt(0);
                    String string3 = leafSyntax.name;
                    if (MibOperations.jdbc) {
                        string3 = leafSyntax.getName();
                    }
                    if (!string3.equals("MacAddress") && !((MibNode)object).getParent().isImplied) {
                        n5 = (int)lArray[n++];
                    }
                    byte[] byArray = new byte[n5];
                    int n6 = 0;
                    while (n6 < n5) {
                        byArray[n6] = (byte)lArray[n++];
                        ++n6;
                    }
                    object2 = new SnmpString(byArray);
                }
                vector2.addElement(object2);
            }
            catch (Exception exception) {
                if (MibOperations.errMsg) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Cannot decode instance:")) + " " + string + " : " + exception);
                }
                exception.printStackTrace();
            }
        }
        return vector2;
    }

    public int[] encodeInstanceString(Vector vector, Vector vector2) throws NumberFormatException {
        Object object;
        int[] nArray = new int[127];
        int n = 0;
        int n2 = 0;
        if (vector.isEmpty()) {
            return null;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (MibNode)vector2.elementAt(n2);
            SnmpVar snmpVar = (SnmpVar)enumeration.nextElement();
            if (snmpVar instanceof SnmpUnsignedInt) {
                nArray[n++] = (int)((SnmpUnsignedInt)snmpVar).longValue();
            } else if (snmpVar instanceof SnmpInt) {
                nArray[n++] = ((SnmpInt)snmpVar).intValue();
            } else {
                int n3;
                if (snmpVar instanceof SnmpNetworkAddress) {
                    nArray[n++] = 1;
                }
                if (snmpVar instanceof SnmpString) {
                    int n4;
                    boolean bl = false;
                    byte[] byArray = snmpVar.toBytes();
                    n3 = byArray.length;
                    if (!(snmpVar instanceof SnmpIpAddress)) {
                        if (object == null) {
                            if (MibOperations.errMsg) {
                                System.err.println(String.valueOf(SnmpUtils.getString("Can't find node for this String index in vector :")) + " " + ((MibNode)object).label);
                            }
                        } else {
                            n4 = ((MibNode)object).getSyntax().type;
                            if (MibOperations.jdbc) {
                                n4 = ((MibNode)object).getSyntax().getType();
                            }
                            if (n4 != 4) {
                                if (MibOperations.errMsg) {
                                    System.err.println(String.valueOf(SnmpUtils.getString("Node syntax not String type")) + " " + ((MibNode)object).label);
                                }
                            } else {
                                boolean bl2 = ((MibNode)object).label.startsWith("IMPLIED");
                                if (((MibNode)object).getParent().isImplied()) {
                                    bl2 = true;
                                }
                                if (((MibNode)object).getSyntax().getMin() != ((MibNode)object).getSyntax().getMax() && !bl2) {
                                    nArray[n++] = n3;
                                } else if (!bl2 && ((MibNode)object).getSyntax().getMin() == 0L) {
                                    nArray[n++] = n3;
                                }
                            }
                        }
                    }
                    n4 = 0;
                    while (n4 < n3) {
                        nArray[n++] = byArray[n4] & 0xFF;
                        ++n4;
                    }
                } else if (snmpVar instanceof SnmpOID) {
                    int[] nArray2 = (int[])((SnmpOID)snmpVar).toValue();
                    if (object == null) {
                        if (MibOperations.errMsg) {
                            System.err.println(String.valueOf(SnmpUtils.getString("Can't find node for this OID index in vector :")) + " " + ((MibNode)object).label);
                        }
                    } else {
                        byte by = ((MibNode)object).getSyntax().type;
                        if (MibOperations.jdbc) {
                            by = ((MibNode)object).getSyntax().getType();
                        }
                        if (by != 6) {
                            if (MibOperations.errMsg) {
                                System.err.println(String.valueOf(SnmpUtils.getString("Node syntax not OID type")) + " " + ((MibNode)object).label);
                            }
                        } else {
                            n3 = ((MibNode)object).label.startsWith("IMPLIED") ? 1 : 0;
                            if (((MibNode)object).isImplied()) {
                                n3 = 1;
                            }
                            if (n3 == 0) {
                                nArray[n++] = nArray2.length;
                            }
                        }
                    }
                    int n5 = 0;
                    while (n5 < nArray2.length) {
                        nArray[n++] = nArray2[n5];
                        ++n5;
                    }
                }
            }
            ++n2;
        }
        object = new int[n];
        int n6 = 0;
        while (n6 < n) {
            object[n6] = nArray[n6];
            ++n6;
        }
        return object;
    }

    boolean getBITSRange(String string) {
        return false;
    }

    public String getDescription() {
        if (this.range != null && !this.range.preDefinedRange) {
            return String.valueOf(this.getName()) + " " + this.range.toString();
        }
        return this.getName();
    }

    public int[] getEnumint() {
        if (this.range != null) {
            return this.range.getEnumint();
        }
        return null;
    }

    public String[] getEnumlabels() {
        if (this.range != null) {
            return this.range.getEnumlabels();
        }
        return null;
    }

    public String getEquivname() {
        byte by = this.getType();
        if (by == 64) {
            return this.getName();
        }
        if (by == 4 && this.isEnumerated()) {
            return "BITS";
        }
        return (String)MibOperations.equivName.get(new Byte(by));
    }

    public int getInt(String string) {
        if (this.range != null) {
            return this.range.getEnumInt(string);
        }
        return -1;
    }

    public String getLabel(int n) {
        if (this.range != null) {
            return this.range.getLabel(n);
        }
        return null;
    }

    public long getMax() {
        if (this.range == null) {
            return this.MAX;
        }
        if (this.isRanged()) {
            long l = this.range.max[0];
            int n = 0;
            while (n < this.range.rangecount) {
                if (this.range.max[n] > l) {
                    l = this.range.max[n];
                }
                ++n;
            }
            return l;
        }
        long l = this.range.values[0];
        int n = 0;
        while (n < this.range.values.length) {
            if (this.range.values[n] > l) {
                l = this.range.values[n];
            }
            ++n;
        }
        return l;
    }

    public long getMin() {
        if (this.range == null) {
            return this.MIN;
        }
        if (this.isRanged()) {
            long l = this.range.min[0];
            int n = 0;
            while (n < this.range.rangecount) {
                if (this.range.min[n] < l) {
                    l = this.range.min[n];
                }
                ++n;
            }
            return l;
        }
        long l = this.range.values[0];
        int n = 0;
        while (n < this.range.values.length) {
            if (this.range.values[n] < l) {
                l = this.range.values[n];
            }
            ++n;
        }
        return l;
    }

    public String getName() {
        return this.name;
    }

    RangeList getRange() {
        return this.range;
    }

    public String[] getRangeItems() {
        if (this.range != null) {
            String[] stringArray = null;
            if (this.isRanged()) {
                stringArray = new String[this.range.rangecount];
                int n = 0;
                while (n < this.range.rangecount) {
                    stringArray[n] = this.range.rangetype[n] ? String.valueOf(this.range.min[n]) + " .. " + this.range.max[n] : String.valueOf(this.range.max[n]) + " ";
                    ++n;
                }
                return stringArray;
            }
        }
        return null;
    }

    public int getSize() {
        this.type = this.getType();
        if (this.type == 4 || this.type == 68) {
            if (MibOperations.jdbc && this.getRangeItems() != null) {
                return new Long(this.getMax()).intValue();
            }
            if (this.range != null || MibOperations.jdbc && this.isEnumerated()) {
                this.size = new Long(this.getMax()).intValue();
            }
        } else if (this.type == 2 || this.type == 71) {
            this.size = 4;
        } else if (this.type == 66 || this.type == 66 || this.type == 65 || this.type == 67) {
            this.size = 8;
        }
        return this.size;
    }

    static byte getSnmpType(int n) {
        switch (n) {
            case 64: {
                return 2;
            }
            case 67: {
                return 66;
            }
            case 69: {
                return 65;
            }
            case 71: {
                return 67;
            }
            case 96: {
                return 4;
            }
            case 97: 
            case 99: {
                return 64;
            }
            case 98: {
                return 68;
            }
            case 1: {
                return 6;
            }
            case 101: {
                return 5;
            }
        }
        return -1;
    }

    public LeafSyntax getSyntax() {
        if (this.syntax != this) {
            return this.syntax.getSyntax();
        }
        return this;
    }

    public byte getType() {
        this.type = this.getSyntax().type;
        if (this.type == 0) {
            return this.syntax.type;
        }
        return this.type;
    }

    static String getTypeStr(int n) {
        if ((n & 0xF0) == 64) {
            return MIBConstants.numericStr[n & 0xF];
        }
        if ((n & 0xF0) == 96) {
            return MIBConstants.alphaStr[n & 0xF];
        }
        if (n == 1) {
            return "OBJECT IDENTIFIER";
        }
        if (MibOperations.errMsg) {
            System.err.println(String.valueOf(SnmpUtils.getString("ASSERT:Wrong type:")) + n + SnmpUtils.getString(". Verify code."));
        }
        return null;
    }

    void initializeMINandMAXvalues() {
        if ((this.type == 66 || this.type == 66 || this.type == 2 || this.type == 71 || this.type == 67) && this.range != null) {
            this.range.addSizeTag = false;
        }
    }

    public boolean isConstrained() {
        if (this.range != null) {
            return this.range.preDefinedRange ^ true;
        }
        return false;
    }

    public boolean isEnumerated() {
        if (this.range != null) {
            return this.range.isEnumerated();
        }
        return false;
    }

    public boolean isRanged() {
        if (this.range != null) {
            return this.range.isRanged();
        }
        return false;
    }

    private String parseHexFormat(String string) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string2.startsWith("'") || string2.startsWith("`")) {
            int n = string2.length() - 2;
            if (n > 0) {
                if (string2.charAt(n) == '\'' || string2.charAt(n) == '`') {
                    String string3 = null;
                    char c = string2.charAt(string2.length() - 1);
                    string3 = string2.substring(1, n);
                    switch (c) {
                        case 'B': 
                        case 'b': {
                            string2 = Long.toString(Long.parseLong(string3, 2));
                            return string2;
                        }
                        case 'H': 
                        case 'h': {
                            string2 = Long.toString(Long.parseLong(string3, 16));
                            return string2;
                        }
                    }
                    throw new IllegalArgumentException();
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }
        return null;
    }

    long power(int n) {
        long l = 1L;
        int n2 = 0;
        while (n2 < n) {
            l *= 2L;
            ++n2;
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LeafSyntax readType(BaseSyntax baseSyntax, Object object, MibModule mibModule) {
        boolean bl;
        boolean bl2;
        LeafSyntax leafSyntax;
        RangeList rangeList;
        boolean bl3;
        block28: {
            MibTC mibTC;
            block31: {
                String string;
                boolean bl4;
                block29: {
                    block30: {
                        int n = baseSyntax.getType();
                        MibOperations cfr_ignored_0 = mibModule.mibOps;
                        MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Parent Object class :")) + object.getClass() + " : " + object, 0);
                        MibOperations cfr_ignored_1 = mibModule.mibOps;
                        MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("SYNTAX :")) + " " + LeafSyntax.getTypeStr(n), 0);
                        bl4 = baseSyntax instanceof SyntaxTextualConvention;
                        string = null;
                        if (bl4) {
                            string = ((SyntaxTextualConvention)baseSyntax).getName();
                            MibOperations cfr_ignored_2 = mibModule.mibOps;
                            MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Using Textual Convention :")) + string, 0);
                        }
                        bl3 = baseSyntax.getRange() != null;
                        rangeList = null;
                        leafSyntax = null;
                        if (LeafSyntax.getTypeStr(n) != null) {
                            leafSyntax = (LeafSyntax)mibModule.mibOps.genericTcList.get(LeafSyntax.getTypeStr(n));
                        }
                        bl2 = object instanceof MibTC;
                        bl = false;
                        if (leafSyntax != null) break block29;
                        if (n != 2) {
                            MibOperations cfr_ignored_3 = mibModule.mibOps;
                            MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Funny results: Examine this case :")) + " " + object, 3);
                            return null;
                        }
                        if (bl4) break block30;
                        MibOperations cfr_ignored_4 = mibModule.mibOps;
                        MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("This is not a TC strangely .. for object ")) + object, 3);
                        break block28;
                    }
                    mibTC = mibModule.getMibTC(string);
                    if (mibTC == null) {
                        MibOperations cfr_ignored_5 = mibModule.mibOps;
                        MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Found a link to an unresolved TC :")) + " " + string + SnmpUtils.getString(".. for node") + " " + object, 3);
                        Vector<Object> vector = (Vector<Object>)mibModule.unResolvedTCList.get(string);
                        if (vector == null) {
                            vector = new Vector<Object>();
                            mibModule.unResolvedTCList.put(string, vector);
                        }
                        vector.addElement(object);
                        leafSyntax = new LeafSyntax();
                        bl = true;
                        leafSyntax.equivName = leafSyntax.name = string;
                        break block28;
                    } else {
                        leafSyntax = mibTC;
                        if (bl2) {
                            ((MibTC)object).range = leafSyntax.range;
                        }
                    }
                    break block28;
                }
                if (!bl4) break block31;
                mibTC = mibModule.getMibTC(string);
                if (mibTC == null) {
                    try {
                        leafSyntax = (LeafSyntax)leafSyntax.clone();
                        leafSyntax.equivName = leafSyntax.name;
                        leafSyntax.name = string;
                        if (leafSyntax.range != null) {
                            leafSyntax.range.preDefinedRange = true;
                        }
                        if (bl2) {
                            MibTC mibTC2 = (MibTC)object;
                            mibTC2.range = leafSyntax.getRange();
                            mibTC2.type = leafSyntax.getType();
                        }
                        if (mibModule.mibOps.genericTcList.get(string) == null) {
                            mibModule.mibOps.genericTcList.put(string, leafSyntax);
                        }
                        break block28;
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        MibOperations cfr_ignored_6 = mibModule.mibOps;
                        MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Error cloning syntax :")) + " " + cloneNotSupportedException, 3);
                    }
                    break block28;
                } else {
                    byte by = leafSyntax.getType();
                    try {
                        leafSyntax = (LeafSyntax)((LeafSyntax)mibTC).clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        cloneNotSupportedException.printStackTrace();
                    }
                    ((LeafSyntax)mibTC).syntax.type = by;
                    mibTC.type = by;
                    leafSyntax.syntax.type = by;
                    if (bl2) {
                        ((MibTC)object).range = leafSyntax.getRange();
                    }
                    if (!bl3 && leafSyntax.getRange() != null) {
                        leafSyntax.getRange().preDefinedRange = true;
                    }
                    bl = true;
                }
                break block28;
            }
            if (bl2) {
                mibTC = (MibTC)object;
                mibTC.range = leafSyntax.getRange();
                mibTC.type = leafSyntax.getType();
            }
        }
        boolean bl5 = false;
        if (bl3) {
            rangeList = RangeList.getInstance(baseSyntax.getRange(), leafSyntax.getRange());
            bl5 = true;
            if (bl2) {
                ((MibTC)object).range = rangeList;
            }
        }
        if (!bl) {
            try {
                leafSyntax = (LeafSyntax)leafSyntax.clone();
                if (bl3) {
                    leafSyntax.range = (RangeList)rangeList.clone();
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                MibOperations cfr_ignored_7 = mibModule.mibOps;
                MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Error cloning syntax :")) + " " + cloneNotSupportedException, 3);
            }
            leafSyntax.initializeMINandMAXvalues();
            return leafSyntax;
        }
        try {
            if (leafSyntax != null && rangeList != null) {
                leafSyntax.range = (RangeList)rangeList.clone();
            }
            leafSyntax.initializeMINandMAXvalues();
            return leafSyntax;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return leafSyntax;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LeafSyntax readType(DataInputStream dataInputStream, Object object, MibModule mibModule) throws IOException {
        boolean bl;
        boolean bl2;
        LeafSyntax leafSyntax;
        RangeList rangeList;
        boolean bl3;
        block27: {
            MibTC mibTC;
            block30: {
                String string;
                boolean bl4;
                block28: {
                    block29: {
                        int n = dataInputStream.readInt();
                        MibOperations cfr_ignored_0 = mibModule.mibOps;
                        MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Parent Object class :")) + object.getClass() + " : " + object, 0);
                        MibOperations cfr_ignored_1 = mibModule.mibOps;
                        MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("SYNTAX :")) + " " + LeafSyntax.getTypeStr(n), 0);
                        bl4 = dataInputStream.readBoolean();
                        string = null;
                        if (bl4) {
                            string = dataInputStream.readUTF();
                            MibOperations cfr_ignored_2 = mibModule.mibOps;
                            MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Using Textual Convention :")) + string, 0);
                        }
                        bl3 = dataInputStream.readBoolean();
                        rangeList = null;
                        leafSyntax = null;
                        if (LeafSyntax.getTypeStr(n) != null) {
                            leafSyntax = (LeafSyntax)mibModule.mibOps.genericTcList.get(LeafSyntax.getTypeStr(n));
                        }
                        bl2 = object instanceof MibTC;
                        bl = false;
                        if (leafSyntax != null) break block28;
                        if (n != 2) {
                            MibOperations cfr_ignored_3 = mibModule.mibOps;
                            MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Funny results: Examine this case :")) + " " + object, 3);
                            return null;
                        }
                        if (bl4) break block29;
                        MibOperations cfr_ignored_4 = mibModule.mibOps;
                        MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("This is not a TC strangely .. for object")) + " " + object, 3);
                        break block27;
                    }
                    mibTC = mibModule.getMibTC(string);
                    if (mibTC == null) {
                        MibOperations cfr_ignored_5 = mibModule.mibOps;
                        MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Found a link to an unresolved TC : ")) + string + SnmpUtils.getString(".. for node") + " " + object, 3);
                        Vector<Object> vector = (Vector<Object>)mibModule.unResolvedTCList.get(string);
                        if (vector == null) {
                            vector = new Vector<Object>();
                            mibModule.unResolvedTCList.put(string, vector);
                        }
                        vector.addElement(object);
                        leafSyntax = new LeafSyntax();
                        bl = true;
                        leafSyntax.equivName = leafSyntax.name = string;
                        break block27;
                    } else {
                        leafSyntax = mibTC;
                        if (bl2) {
                            ((MibTC)object).range = leafSyntax.range;
                        }
                    }
                    break block27;
                }
                if (!bl4) break block30;
                mibTC = mibModule.getMibTC(string);
                if (mibTC == null) {
                    try {
                        leafSyntax = (LeafSyntax)leafSyntax.clone();
                        leafSyntax.equivName = leafSyntax.name;
                        leafSyntax.name = string;
                        if (leafSyntax.range != null) {
                            leafSyntax.range.preDefinedRange = true;
                        }
                        if (bl2) {
                            MibTC mibTC2 = (MibTC)object;
                            mibTC2.range = leafSyntax.getRange();
                            mibTC2.type = leafSyntax.getType();
                        }
                        if (mibModule.mibOps.genericTcList.get(string) == null) {
                            mibModule.mibOps.genericTcList.put(string, leafSyntax);
                        }
                        break block27;
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        MibOperations cfr_ignored_6 = mibModule.mibOps;
                        MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Error cloning syntax :")) + " " + cloneNotSupportedException, 3);
                    }
                    break block27;
                } else {
                    byte by = leafSyntax.getType();
                    try {
                        leafSyntax = (LeafSyntax)((LeafSyntax)mibTC).clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        cloneNotSupportedException.printStackTrace();
                    }
                    ((LeafSyntax)mibTC).syntax.type = by;
                    mibTC.type = by;
                    leafSyntax.syntax.type = by;
                    leafSyntax.type = by;
                    if (bl2) {
                        ((MibTC)object).range = leafSyntax.getRange();
                    }
                    if (!bl3 && leafSyntax.getRange() != null) {
                        leafSyntax.getRange().preDefinedRange = true;
                    }
                    bl = true;
                }
                break block27;
            }
            if (bl2) {
                mibTC = (MibTC)object;
                mibTC.range = leafSyntax.getRange();
                mibTC.type = leafSyntax.getType();
            }
        }
        boolean bl5 = false;
        if (bl3) {
            rangeList = RangeList.getInstance(dataInputStream, leafSyntax.getRange());
            bl5 = true;
            if (bl2) {
                ((MibTC)object).range = rangeList;
            }
        }
        if (!bl) {
            try {
                leafSyntax = (LeafSyntax)leafSyntax.clone();
                if (bl3) {
                    leafSyntax.range = (RangeList)rangeList.clone();
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                MibOperations cfr_ignored_7 = mibModule.mibOps;
                MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Error cloning syntax :")) + " " + cloneNotSupportedException, 3);
            }
            leafSyntax.initializeMINandMAXvalues();
            return leafSyntax;
        }
        try {
            if (leafSyntax == null) return leafSyntax;
            if (rangeList == null) return leafSyntax;
            leafSyntax.range = (RangeList)rangeList.clone();
            leafSyntax.initializeMINandMAXvalues();
            return leafSyntax;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return leafSyntax;
    }

    void setEquivname(String string) {
        this.equivName = string;
    }

    void setMax(long l) {
        this.MAX = l;
    }

    void setMin(long l) {
        this.MIN = l;
    }

    void setName(String string) {
        this.name = string;
    }

    void setRange(RangeList rangeList) {
        this.range = rangeList;
    }

    void setSize(int n) {
        this.size = n;
    }

    void setSyntax(LeafSyntax leafSyntax) {
        this.syntax = leafSyntax;
    }

    void setType(byte by) {
        this.type = by;
    }

    static long[] stringToArray(String string) {
        long[] lArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        lArray = new long[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            lArray[n] = Long.parseLong(stringTokenizer.nextToken("."));
            ++n;
        }
        return lArray;
    }

    public String toString() {
        return this.name;
    }

    public String toTagString() {
        return this.getDescription();
    }
}

