/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs;

import com.adventnet.snmp.mibs.LeafSyntax;
import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.Sequence;
import com.adventnet.snmp.mibs.mibparser.CommentClass;
import com.adventnet.snmp.mibs.mibparser.MIBConstants;
import com.adventnet.snmp.mibs.mibparser.SyntaxOID;
import com.adventnet.snmp.mibs.mibparser.SyntaxObjectType;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

class MibMacro
implements Serializable,
MIBConstants {
    MibMacro() {
    }

    static void readElements(SyntaxOID syntaxOID, int n, MibNode mibNode, MibModule mibModule) {
        switch (syntaxOID.getType()) {
            case 32: {
                MibMacro.readObjectTypeSyntax((SyntaxObjectType)syntaxOID, mibNode, mibModule);
                break;
            }
            case 1: {
                MibMacro.readOBIDComments(syntaxOID, mibNode, mibModule);
                return;
            }
            default: {
                return;
            }
        }
    }

    static void readElements(DataInputStream dataInputStream, int n, MibNode mibNode, MibModule mibModule) throws IOException {
        switch (n) {
            case 32: {
                MibMacro.readObjectTypeSyntax(dataInputStream, mibNode, mibModule);
                break;
            }
            case 1: {
                MibMacro.readOBIDComments(dataInputStream, mibNode, mibModule);
                return;
            }
            default: {
                return;
            }
        }
    }

    static void readOBIDComments(SyntaxOID syntaxOID, MibNode mibNode, MibModule mibModule) {
        mibNode.commentObj = new CommentClass();
        mibNode.commentObj.node = syntaxOID.commentObj.node;
        mibNode.commentObj.commentStr = syntaxOID.commentObj.commentStr;
    }

    static void readOBIDComments(DataInputStream dataInputStream, MibNode mibNode, MibModule mibModule) throws IOException {
        mibNode.commentObj = new CommentClass();
        mibNode.commentObj.node = mibModule.readNextDesc();
        mibNode.commentObj.commentStr = mibModule.readNextDesc();
    }

    static void readObjectTypeSyntax(SyntaxObjectType syntaxObjectType, MibNode mibNode, MibModule mibModule) {
        mibNode.node_status = syntaxObjectType.getStatus();
        mibModule.debugPrint("Reading OBJECT_TYPE");
        mibNode.status = MibModule.getStatus(mibNode.node_status);
        mibModule.debugPrint("Node status " + mibNode.getStatus());
        mibNode.node_access = syntaxObjectType.getAccess();
        mibNode.access = MibModule.getAccess(mibNode.node_access);
        mibModule.debugPrint("Node access " + mibNode.getNodeAccessStr());
        mibNode.description = syntaxObjectType.getDescription();
        mibModule.debugPrint("Description " + mibNode.description);
        mibNode.reference = syntaxObjectType.getReference();
        mibModule.debugPrint("Reference " + mibNode.reference);
        mibNode.defval = syntaxObjectType.getDefVal();
        mibModule.debugPrint("Defval " + mibNode.defval);
        boolean bl = syntaxObjectType.getSequence() != null;
        mibModule.debugPrint("sequence ? " + bl);
        if (bl) {
            mibNode.tableSequence = syntaxObjectType.getSequence();
            Sequence sequence = (Sequence)mibModule.seqList.get(mibNode.tableSequence);
            mibNode.tableItems = sequence.getElements();
        } else {
            boolean bl2 = syntaxObjectType.getIndices().size() > 0;
            mibModule.debugPrint("Is it indexed ? " + bl2);
            if (bl2) {
                boolean bl3;
                if (mibNode.parent != null) {
                    mibNode.rowName = mibNode.parent.tableSequence;
                }
                mibNode.isImplied = bl3 = syntaxObjectType.isImplied();
                mibNode.impliedNode = syntaxObjectType.getImpliedNode();
                int n = syntaxObjectType.getIndices().size();
                if (mibNode.indexNames == null) {
                    mibNode.indexNames = new Vector();
                }
                int n2 = 0;
                while (n2 < n) {
                    mibNode.indexNames.addElement(syntaxObjectType.getIndices().elementAt(n2));
                    ++n2;
                }
            } else {
                mibNode.syntax = LeafSyntax.readType(syntaxObjectType.getSyntax(), (Object)mibNode, mibModule);
            }
        }
        mibNode.commentObj = syntaxObjectType.commentObj;
    }

    static void readObjectTypeSyntax(DataInputStream dataInputStream, MibNode mibNode, MibModule mibModule) throws IOException {
        mibNode.node_status = dataInputStream.readInt();
        mibModule.debugPrint("Reading OBJECT_TYPE");
        mibNode.status = MibModule.getStatus(mibNode.node_status);
        mibModule.debugPrint("Node status " + mibNode.getStatus());
        mibNode.node_access = dataInputStream.readInt();
        mibNode.access = MibModule.getAccess(mibNode.node_access);
        mibModule.debugPrint("Node access " + mibNode.getNodeAccessStr());
        mibNode.description = mibModule.readNextDesc();
        mibModule.debugPrint("Description " + mibNode.description);
        mibNode.reference = mibModule.readNextDesc();
        mibModule.debugPrint("Reference " + mibNode.reference);
        dataInputStream.readUTF();
        mibNode.defval = dataInputStream.readUTF();
        mibModule.debugPrint("Defval " + mibNode.defval);
        boolean bl = dataInputStream.readBoolean();
        mibModule.debugPrint("sequence ? " + bl);
        if (bl) {
            mibNode.tableSequence = dataInputStream.readUTF();
            Sequence sequence = (Sequence)mibModule.seqList.get(mibNode.tableSequence);
            mibNode.tableItems = sequence.getElements();
        } else {
            boolean bl2 = dataInputStream.readBoolean();
            mibModule.debugPrint("Is it indexed ? " + bl2);
            if (bl2) {
                boolean bl3;
                if (mibNode.parent != null) {
                    mibNode.rowName = mibNode.parent.tableSequence;
                }
                dataInputStream.readBoolean();
                mibNode.isImplied = bl3 = dataInputStream.readBoolean();
                if (bl3) {
                    mibNode.impliedNode = dataInputStream.readUTF();
                }
                int n = dataInputStream.readInt();
                if (mibNode.indexNames == null) {
                    mibNode.indexNames = new Vector();
                }
                int n2 = 0;
                while (n2 < n) {
                    mibNode.indexNames.addElement(dataInputStream.readUTF());
                    ++n2;
                }
            } else {
                mibNode.syntax = LeafSyntax.readType(dataInputStream, (Object)mibNode, mibModule);
            }
        }
        mibNode.commentObj = new CommentClass();
        mibNode.commentObj.node = mibModule.readNextDesc();
        mibNode.commentObj.objType = mibModule.readNextDesc();
        mibNode.commentObj.syntax = mibModule.readNextDesc();
        mibModule.readNextDesc();
        mibNode.commentObj.access = mibModule.readNextDesc();
        mibNode.commentObj.status = mibModule.readNextDesc();
        mibNode.commentObj.description = mibModule.readNextDesc();
        mibNode.commentObj.reference = mibModule.readNextDesc();
        mibNode.commentObj.defval = mibModule.readNextDesc();
        mibNode.commentObj.commentStr = mibModule.readNextDesc();
    }
}

