/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs;

import com.adventnet.snmp.mibs.LeafSyntax;
import com.adventnet.snmp.mibs.MibException;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.mibs.MibTC;
import com.adventnet.snmp.mibs.MibTrap;
import com.adventnet.snmp.mibs.Sequence;
import com.adventnet.snmp.mibs.mibparser.MIBConstants;
import com.adventnet.snmp.mibs.mibparser.MIBParser;
import com.adventnet.snmp.mibs.mibparser.ParseException;
import com.adventnet.snmp.mibs.mibparser.SyntaxOID;
import com.adventnet.snmp.mibs.mibparser.SyntaxSequence;
import com.adventnet.snmp.mibs.mibparser.SyntaxTextualConvention;
import com.adventnet.snmp.mibs.mibparser.SyntaxTrapType;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.utils.SnmpUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MibModule
implements MIBConstants,
Serializable {
    String name = null;
    MibNode root = null;
    Hashtable nodeList = new Hashtable(50);
    Hashtable trapList = new Hashtable(1);
    String filename;
    MibOperations mibOps = null;
    String preModuleComments = "";
    String importedModules = "";
    Vector importsVector = new Vector();
    Hashtable imports = new Hashtable(1);
    String importsString = null;
    DataInputStream inp;
    DataInputStream descInp;
    static final int ALL_MESSAGES = 0;
    static final int WARNING_MESSAGES = 1;
    static final int SERIOUS_MESSAGES = 2;
    static final int CRITICAL_MESSAGES = 3;
    String mibModules = null;
    private int line = 1;
    Hashtable seqList = new Hashtable(1);
    Vector rootNodes = new Vector();
    Hashtable unResolvedNodes = new Hashtable(1);
    Hashtable unResolvedTCList = new Hashtable(1);
    Hashtable tcList = new Hashtable(2);

    MibModule() {
    }

    MibModule(InputStream inputStream, MibOperations mibOperations) throws IOException, MibException {
        this.mibOps = mibOperations;
        try {
            MIBParser.parseMibModule(inputStream, mibOperations.userLabel, mibOperations);
        }
        catch (ParseException parseException) {
            inputStream.close();
            mibOperations.globalImports = null;
            throw new MibException(String.valueOf(SnmpUtils.getString("Could not parse the file")) + " " + mibOperations.mibFileName + " " + parseException.getMessage());
        }
        try {
            this.readFromHashtables();
        }
        catch (MibException mibException) {
            mibOperations.globalImports = null;
            MIBParser.free();
            inputStream.close();
            throw new MibException(mibException.getMessage());
        }
        MIBParser.free();
        if (this.isResolved()) {
            mibOperations.registerModule(this);
        }
        boolean bl = false;
        while (MIBParser.containsMultipleModules()) {
            MibModule mibModule = new MibModule(inputStream, mibOperations);
            mibModule.filename = mibOperations.mibFileName;
            bl = true;
        }
        inputStream.close();
        if (bl) {
            mibOperations.resolver.performResolution();
        }
    }

    MibModule(String string) {
    }

    MibModule(String string, DataInputStream dataInputStream, DataInputStream dataInputStream2, MibOperations mibOperations) throws IOException, MibException {
        this.inp = dataInputStream;
        this.descInp = dataInputStream2;
        this.mibOps = mibOperations;
        this.name = string;
        try {
            this.readFile();
        }
        catch (MibException mibException) {
            this.mibOps.globalImports = null;
            dataInputStream.close();
            if (this.mibOps.isReadDesc()) {
                dataInputStream2.close();
            }
            this.inp = null;
            this.descInp = null;
            throw new MibException(mibException.getMessage());
        }
        dataInputStream.close();
        if (this.mibOps.isReadDesc()) {
            dataInputStream2.close();
        }
        this.inp = null;
        this.descInp = null;
        if (this.isResolved()) {
            this.mibOps.registerModule(this);
        }
        if (this.mibModules != null && !this.mibModules.trim().equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.mibModules, " [],");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (this.mibOps.modules.get(string2) != null || this.mibOps.getModuleFromGlobalImports(string2) != null) continue;
                if (this.mibOps.applet == null) {
                    if (this.mibOps.isLoadedFromApplURL) {
                        MibModule mibModule;
                        FileInputStream fileInputStream = null;
                        FileInputStream fileInputStream2 = null;
                        String string3 = "." + File.separator + "tmp" + File.separator;
                        fileInputStream = new FileInputStream(String.valueOf(string3) + string2 + ".cmi");
                        if (this.mibOps.isReadDesc()) {
                            fileInputStream2 = new FileInputStream(String.valueOf(string3) + string2 + ".cds");
                        }
                        if ((mibModule = this.mibOps.loadModule(fileInputStream, fileInputStream2, "")) != null) {
                            if (mibModule.isResolved()) {
                                this.mibOps.registerModule(mibModule);
                            }
                            mibModule.filename = this.mibOps.mibFileName;
                        }
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        if (fileInputStream2 == null) continue;
                        fileInputStream2.close();
                        continue;
                    }
                    this.mibOps.loadMibModules(String.valueOf(this.mibOps.mibFileDir) + string2 + ".cmi&#$*@");
                    continue;
                }
                this.mibOps.loadMibModules(this.mibOps.applet, String.valueOf(this.mibOps.mibFileDir) + string2 + ".cmi&#$*@");
            }
        }
    }

    private void addToModule(MibNode mibNode) {
        this.nodeList.put(mibNode.getLabel(), mibNode);
    }

    static int byteToInt(byte by) {
        return by & 0xFF;
    }

    private int[] calcOID(MibNode mibNode) {
        Vector<Integer> vector = new Vector<Integer>();
        while (mibNode != null) {
            vector.insertElementAt(new Integer(mibNode.subid), 0);
            mibNode = mibNode.parent;
        }
        int[] nArray = new int[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            nArray[n++] = (Integer)enumeration.nextElement();
        }
        return nArray;
    }

    private boolean checkParents(Vector vector, int n, MibNode mibNode) {
        int n2 = vector.size();
        if (n2 - 1 < n) {
            return true;
        }
        MibNode mibNode2 = mibNode.getParent();
        if (mibNode2 == null) {
            return false;
        }
        if (n == -1) {
            return true;
        }
        int n3 = n;
        while (n3 >= 0) {
            String string = (String)vector.elementAt(n3);
            if (Character.isDigit(string.charAt(0))) {
                int n4;
                try {
                    n4 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.mibOps.debugPrint(String.valueOf(SnmpUtils.getString("Error in label")) + " " + string + " " + numberFormatException);
                    return false;
                }
                if (n4 != mibNode2.getSubid()) {
                    return false;
                }
            } else if (!mibNode2.getLabel().equals(string)) {
                return false;
            }
            mibNode2 = mibNode2.getParent();
            if (n3 == 0) {
                return mibNode2 == null;
            }
            if (mibNode2 == null) {
                return false;
            }
            --n3;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void copyChildren(MibNode var1_1, MibNode var2_2) {
        block15: {
            block14: {
                var3_3 = var1_1;
                var1_1.moduleName = this.name;
                var4_4 = var1_1.parent;
                var5_5 = null;
                if (var4_4 == null) break block14;
                var5_5 = this.getMibNodeByName(var4_4.getLabel());
                if (var5_5 == null) ** GOTO lbl37
                var5_5.addChild(var1_1);
                var1_1.parent = var5_5;
                var1_1.childList = new Vector<E>();
                if (var2_2.hasChildren()) {
                    try {
                        var1_1.merge(var2_2);
                    }
                    catch (Exception var6_6) {
                        var6_6.printStackTrace();
                    }
                    this.rootNodes.removeElement(var2_2);
                    this.rootNodes.addElement(var1_1);
                } else {
                    this.rootNodes.removeElement(var2_2);
                    this.rootNodes.addElement(var1_1);
                }
                break block15;
                while (var4_4 != null) {
                    if ((var4_4 = var4_4.getParent()) == null) {
                        var6_7 = var1_1;
                        while (var6_7 != null) {
                            var6_7.moduleName = this.name;
                            this.nodeList.put(var6_7.getLabel(), var6_7);
                            var6_7 = var6_7.getParent();
                        }
                        break;
                    }
                    var5_5 = this.getMibNodeByName(var4_4.getLabel());
lbl37:
                    // 2 sources

                    if (var5_5 == null) continue;
                }
                if (var5_5 != null) {
                    var6_7 = var1_1;
                    while (!var6_7.getParent().getLabel().equals(var5_5.getLabel())) {
                        if ((var6_7 = var6_7.getParent()) == null) break;
                    }
                    if (this.mibOps.showImportedIndex || !var3_3.isTableColumn() && !var3_3.isTableEntry()) {
                        var5_5.addChild(var6_7);
                        var6_7.parent = var5_5;
                    }
                    var7_8 = var1_1;
                    while (!var7_8.getLabel().equals(var6_7.getLabel())) {
                        if ((var7_8 = var7_8.getParent()) == null) break;
                        var7_8.moduleName = this.name;
                        this.nodeList.put(var7_8.getLabel(), var7_8);
                    }
                    try {
                        var1_1.childList = new Vector<E>();
                        var1_1.merge(var2_2);
                    }
                    catch (Exception var8_9) {
                        var8_9.printStackTrace();
                    }
                    this.upDateRootsChildren(var6_7, var1_1);
                    this.rootNodes.removeElement(var2_2);
                    this.rootNodes.addElement(var1_1);
                }
                var1_1.moduleName = this.name;
                this.nodeList.put(var1_1.getLabel(), var1_1);
                break block15;
            }
            this.rootNodes.removeElement(var2_2);
            this.rootNodes.addElement(var1_1);
        }
        this.unResolvedNodes.remove(var2_2.getLabel());
        if (var1_1 != null) {
            var1_1.moduleName = this.name;
            this.nodeList.put(var1_1.getLabel(), var1_1);
        }
    }

    void debugPrint(String string) {
        MibOperations.debugPrint(string, 2);
    }

    static int getAccess(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 0;
                return n2;
            }
            case 1: {
                n2 = 43690;
                return n2;
            }
            case 2: {
                n2 = 43706;
                return n2;
            }
            case 3: {
                n2 = 43691;
                return n2;
            }
        }
        return n2;
    }

    static String getAccessStr(int n) {
        return MIBConstants.accessStr[n];
    }

    private Vector getAllRoots() {
        return (Vector)this.rootNodes.clone();
    }

    private MibNode getCorrectOID(MibNode mibNode) {
        while (mibNode.parent != null) {
            mibNode = mibNode.parent;
        }
        MibModule mibModule = (MibModule)this.mibOps.modules.get(mibNode.moduleName);
        if (mibModule == null) {
            mibModule = this.mibOps.getModuleFromGlobalImports(mibNode.moduleName);
        }
        String string = null;
        Enumeration enumeration = mibModule.imports.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            ImportsClass importsClass = (ImportsClass)mibModule.imports.get(string);
            Vector vector = importsClass.importOids;
            int n = 0;
            n = 0;
            while (n < vector.size()) {
                ImportOid importOid = (ImportOid)vector.elementAt(n);
                if (importOid.oidName.equals(mibNode.label)) break;
                ++n;
            }
            if (n != vector.size()) break;
        }
        mibNode.moduleName = string;
        return mibNode;
    }

    MibNode getCurrentRoot() {
        int n = this.rootNodes.size();
        Vector vector = this.rootNodes;
        if (n == 0) {
            return null;
        }
        MibNode mibNode = (MibNode)vector.elementAt(0);
        if (n == 1) {
            return mibNode;
        }
        int n2 = 1;
        while (n2 < vector.size()) {
            if (mibNode == null) {
                return null;
            }
            MibNode mibNode2 = (MibNode)vector.elementAt(n2);
            boolean bl = mibNode.getModuleName().equals(this.getName());
            if (mibNode.isAncestorOf(mibNode2)) {
                if (bl) {
                    vector.removeElementAt(n2);
                    --n2;
                }
            } else if (mibNode.isDescendentOf(mibNode2)) {
                if (bl) {
                    vector.removeElementAt(n2);
                    --n2;
                }
                mibNode = mibNode2;
            } else if (mibNode != mibNode2) {
                if (this.isBaseNode(mibNode)) {
                    return mibNode;
                }
                mibNode = mibNode.getCommonAncestorWith(mibNode2);
            }
            ++n2;
        }
        return mibNode;
    }

    public Enumeration getDefinedNodes() {
        return this.nodeList.elements();
    }

    public Enumeration getDefinedTCs() {
        return this.tcList.elements();
    }

    public Enumeration getDefinedTraps() {
        return this.trapList.elements();
    }

    public String getFileName() {
        String string = this.filename.replace('/', File.separatorChar);
        return string;
    }

    public String getFilename() {
        return this.filename;
    }

    String getImportedModules() {
        return this.importedModules;
    }

    public Hashtable getImports() {
        Hashtable hashtable = null;
        Vector<String> vector = null;
        String string = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this.importsString, "\n\t\r ,");
        if (stringTokenizer.countTokens() > 0) {
            hashtable = new Hashtable();
            vector = new Vector<String>();
            MibNode mibNode = null;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (!string.equals("FROM")) {
                    mibNode = this.getMibNode(string);
                    if ((mibNode == null || !mibNode.isImportedNode()) && (!Character.isUpperCase(string.charAt(0)) || MIBParser.wellKnownTCs.containsKey(string) || this.getMibTC(string) != null)) continue;
                    vector.addElement(string);
                    continue;
                }
                string = stringTokenizer.nextToken();
                if (vector.size() > 0) {
                    hashtable.put(string, vector);
                }
                vector = new Vector();
            }
        }
        return hashtable;
    }

    private ImportsClass getImportsClass(String string) {
        MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Retrieving imports object for")) + string, 0);
        ImportsClass importsClass = (ImportsClass)this.imports.get(string);
        if (importsClass == null) {
            importsClass = new ImportsClass();
            importsClass.moduleName = string;
            this.imports.put(string, importsClass);
            this.mibOps.registerImport(string, this);
            this.importedModules = String.valueOf(this.importedModules) + string + " ";
            this.importsVector.addElement(importsClass);
        }
        return importsClass;
    }

    private ImportsClass getImportsClassForResolution(String string) {
        ImportsClass importsClass = (ImportsClass)this.imports.get(string);
        return importsClass;
    }

    public LeafSyntax getLeafSyntax(SnmpOID snmpOID) {
        MibNode mibNode = this.getMibNode(snmpOID);
        if (mibNode != null) {
            return mibNode.syntax;
        }
        return null;
    }

    public MibNode getMibNode(SnmpOID snmpOID) {
        if (snmpOID == null) {
            return null;
        }
        return this.getMibNode((int[])snmpOID.toValue());
    }

    public MibNode getMibNode(String string) {
        if (string == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "., \t\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return this.getMibNode(vector);
    }

    public MibNode getMibNode(Vector vector) {
        Object object;
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        Object var2_2 = null;
        Object var3_3 = null;
        boolean bl = false;
        Vector<Serializable> vector2 = new Vector<Serializable>();
        for (int i = vector.size() - 1; i >= 0; --i) {
            Serializable serializable;
            object = (String)vector.elementAt(i);
            if (MibOperations.errMsg) {
                System.err.println(String.valueOf(SnmpUtils.getString("Checkin ... oid elem")) + " " + (String)object);
            }
            if (Character.isDigit(((String)object).charAt(0))) {
                serializable = null;
                try {
                    serializable = new Integer((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    this.debugPrint(String.valueOf(SnmpUtils.getString("Invalid OID label :")) + numberFormatException);
                    return null;
                }
                vector2.addElement(serializable);
                continue;
            }
            if (MibOperations.errMsg) {
                System.err.println(String.valueOf(SnmpUtils.getString("Searchin ... oid elem")) + " " + (String)object);
            }
            if ((serializable = (MibNode)this.nodeList.get(object)) == null) {
                if (MibOperations.errMsg) {
                    System.err.println(SnmpUtils.getString("Lookin..0"));
                }
                this.mibOps.debugPrint(String.valueOf(SnmpUtils.getString("Failed search for node:")) + (String)object + " " + SnmpUtils.getString("in mib") + " " + this.name);
                return null;
            }
            boolean bl2 = false;
            if (((MibNode)serializable).isLeaf()) {
                if (MibOperations.errMsg) {
                    System.err.println(SnmpUtils.getString("Lookin..1"));
                }
                if (!this.checkParents(vector, i - 1, (MibNode)serializable)) {
                    this.mibOps.debugPrint("Parent nodes did not match after finding node " + serializable);
                    this.mibOps.debugPrint(String.valueOf(SnmpUtils.getString("Parent nodes did not match after")) + " " + SnmpUtils.getString("finding node") + " " + serializable);
                    return null;
                }
                return serializable;
            }
            if (MibOperations.errMsg) {
                System.err.println(SnmpUtils.getString("Lookin..2"));
            }
            if (!this.checkParents(vector, i - 1, (MibNode)serializable)) {
                if (MibOperations.errMsg) {
                    System.err.println(SnmpUtils.getString("Lookin..3"));
                }
                this.mibOps.debugPrint(String.valueOf(SnmpUtils.getString("Parent nodes did not match after")) + "  " + SnmpUtils.getString("finding node") + serializable);
                return null;
            }
            return this.getNodeFromStack((MibNode)serializable, vector2);
        }
        object = new int[vector2.size()];
        int n = vector2.size() - 1;
        int n2 = 0;
        while (n >= 0) {
            object[n2] = (Integer)vector2.elementAt(n);
            --n;
            ++n2;
        }
        MibNode mibNode = this.mibOps.getMibNode(new SnmpOID((int[])object));
        return mibNode;
    }

    public MibNode getMibNode(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = 0;
        MibNode mibNode = this.getRootNode();
        Vector vector = new Vector();
        if (mibNode == null) {
            vector = this.getAllRoots();
        } else {
            vector.addElement(mibNode);
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            mibNode = (MibNode)vector.elementAt(n2);
            int[] nArray2 = mibNode.getOID();
            if (nArray.length >= nArray2.length) {
                n = 0;
                while (n < nArray2.length) {
                    if (nArray[n] != nArray2[n]) break;
                    ++n;
                }
                if (n >= nArray2.length) {
                    MibNode mibNode2 = mibNode;
                    while (n < nArray.length) {
                        if (mibNode2 != null) {
                            if (mibNode2.syntax != null) {
                                return mibNode2;
                            }
                            Enumeration enumeration = mibNode2.childList.elements();
                            while (enumeration.hasMoreElements()) {
                                mibNode2 = (MibNode)enumeration.nextElement();
                                if (nArray[n] == mibNode2.subid) break;
                                mibNode2 = null;
                            }
                        }
                        ++n;
                    }
                    if (mibNode2 != null && (mibNode2.getOID().length >= nArray.length || mibNode2.syntax != null)) {
                        return mibNode2;
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    public MibNode getMibNodeByName(String string) {
        MibNode mibNode = (MibNode)this.nodeList.get(string);
        return mibNode;
    }

    public MibTC getMibTC(String string) {
        if (this.tcList != null) {
            return (MibTC)this.tcList.get(string);
        }
        return null;
    }

    public MibTrap getMibTrap(String string) {
        return (MibTrap)this.trapList.get(string);
    }

    public String getName() {
        return this.name;
    }

    public MibNode getNearestNode(int[] nArray) {
        int n = 0;
        MibNode mibNode = this.getRootNode();
        Vector vector = new Vector();
        if (mibNode == null) {
            vector = this.getAllRoots();
        } else {
            vector.addElement(mibNode);
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            mibNode = (MibNode)vector.elementAt(n2);
            int[] nArray2 = mibNode.getOID();
            if (nArray.length >= nArray2.length) {
                n = 0;
                while (n < nArray2.length) {
                    if (nArray[n] != nArray2[n]) break;
                    ++n;
                }
                if (n >= nArray2.length) {
                    MibNode mibNode2 = mibNode;
                    MibNode mibNode3 = null;
                    while (n < nArray.length) {
                        mibNode3 = mibNode2;
                        if (mibNode2.syntax != null) {
                            return mibNode2;
                        }
                        Enumeration enumeration = mibNode2.childList.elements();
                        while (enumeration.hasMoreElements()) {
                            mibNode2 = (MibNode)enumeration.nextElement();
                            if (nArray[n] == mibNode2.subid) break;
                            if (enumeration.hasMoreElements()) continue;
                            return mibNode3;
                        }
                        ++n;
                    }
                    return mibNode2;
                }
            }
            ++n2;
        }
        return null;
    }

    private MibNode getNodeFromStack(MibNode mibNode, Vector vector) {
        int n = vector.size();
        if (MibOperations.errMsg) {
            System.err.println(String.valueOf(SnmpUtils.getString("Stack size :")) + " " + n);
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            int n3 = (Integer)vector.elementAt(n2);
            if (MibOperations.errMsg) {
                System.err.println(String.valueOf(SnmpUtils.getString("Node data printin...")) + mibNode.getLabel() + mibNode.toTagString());
            }
            if ((mibNode = mibNode.getChild(n3)) == null) {
                if (MibOperations.errMsg) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Node data printin.1..")) + "null");
                }
                return null;
            }
            if (mibNode.isLeaf()) {
                return mibNode;
            }
            --n2;
        }
        return mibNode;
    }

    String getPreModuleComments() {
        return this.preModuleComments;
    }

    public MibNode getRootNode() {
        try {
            MibNode mibNode;
            if (this.root == null) {
                this.root = this.getCurrentRoot();
            }
            if ((mibNode = this.root) == null) {
                if (MibOperations.errMsg) {
                    System.err.println(SnmpUtils.getString("No Root node is available"));
                }
            } else if (MibOperations.errMsg) {
                System.err.println(String.valueOf(SnmpUtils.getString("Root node is")) + " " + mibNode.getLabel() + "\n" + mibNode.toTagString());
            }
            return mibNode;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Vector getRootNodes() {
        MibNode mibNode = this.getRootNode();
        Vector vector = new Vector(1);
        if (mibNode != null) {
            vector.addElement(mibNode);
        } else {
            vector = this.getAllRoots();
        }
        return vector;
    }

    public SnmpOID getSnmpOID(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        String string2 = null;
        long l = 0L;
        MibNode mibNode = null;
        int[] nArray = null;
        Vector vector = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        if (!Character.isDigit(((String)vector.firstElement()).charAt(0)) && (mibNode = (MibNode)this.nodeList.get(object = (String)vector.firstElement())) != null) {
            if (mibNode.syntax == null && vector.size() > 1) {
                mibNode = null;
            } else {
                Vector vector2 = mibNode.getOIDVector();
                int n = 1;
                while (n < vector.size()) {
                    vector2.addElement((String)vector.elementAt(n));
                    ++n;
                }
                vector = vector2;
            }
        }
        if (mibNode == null) {
            vector = this.mibOps.toVector(string);
            mibNode = this.getMibNode(vector);
        }
        if (mibNode == null) {
            return this.mibOps.getNumericOID(string);
        }
        object = mibNode.getOID();
        nArray = new int[vector.size()];
        System.arraycopy(object, 0, nArray, 0, ((Object)object).length);
        int n = ((Object)object).length;
        while (n < nArray.length) {
            try {
                string2 = (String)vector.elementAt(n);
                nArray[n] = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    l = new Long(string2);
                    if (l <= 0xFFFFFFFFL) {
                        nArray[n] = (int)(l & 0xFFFFFFFFL);
                    }
                    System.err.println(String.valueOf(SnmpUtils.getString("subID value should be less than 4294967295:")) + " " + string);
                    return null;
                }
                catch (NumberFormatException numberFormatException2) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Invalid OID format:")) + " " + string);
                    return null;
                }
            }
            ++n;
        }
        return new SnmpOID(nArray);
    }

    static String getStatus(int n) {
        if (n < 5 && n >= 0) {
            return MIBConstants.statusStr[n];
        }
        if (MibOperations.errMsg) {
            System.err.println(SnmpUtils.getString("ASSERT:Invalid Status value"));
        }
        return null;
    }

    static String getSyntaxType(int n) {
        if ((n & 0xF0) == 64) {
            return MIBConstants.numericStr[n & 0xF];
        }
        if ((n & 0xF0) == 96) {
            return MIBConstants.alphaStr[n & 0xF];
        }
        if ((n & 0xF0) == 32) {
            return MIBConstants.macroStr[n & 0xF];
        }
        if (MibOperations.errMsg) {
            System.err.println(SnmpUtils.getString("ASSERT:Invalid type"));
        }
        return null;
    }

    boolean isBaseNode(MibNode mibNode) {
        return this.mibOps.isStarterNode(mibNode);
    }

    boolean isResolved() {
        if (MibOperations.errMsg) {
            System.err.println(String.valueOf(SnmpUtils.getString("Checking if imports pending")) + " " + (this.imports.size() != 0));
        }
        return this.imports.size() == 0;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void performResolution(MibModule var1_1) throws MibException {
        block33: {
            var2_2 = this.getImportsClassForResolution(var1_1.getName());
            var3_3 = false;
            if (var1_1 == this) {
                this.mibOps.debugPrint(String.valueOf(SnmpUtils.getString("Called for resolution using self.")) + 3);
                var3_3 = true;
            }
            var4_4 = var2_2.importOids;
            var5_5 = var4_4.size();
            var6_6 = null;
            var7_7 = 0;
            while (var7_7 < var5_5) {
                var8_8 = (ImportOid)var4_4.elementAt(var7_7);
                var9_9 = var8_8.getOidName();
                var10_10 = var1_1.getMibNodeByName((String)var9_9);
                if (var10_10 == null) {
                    this.mibOps.globalImports = null;
                    throw new MibException(String.valueOf(SnmpUtils.getString("import mib")) + " " + var1_1.getName() + " " + SnmpUtils.getString("does not contain") + (String)var9_9);
                }
                var11_12 = (MibNode)this.unResolvedNodes.get(var9_9);
                if (var11_12 == null) {
                    if (MibOperations.errMsg) {
                        System.err.println(String.valueOf(SnmpUtils.getString("no unresolved stuff for")) + " " + (String)var9_9);
                    }
                } else {
                    var6_6 = var3_3 == false ? var10_10.cloneNode() : var10_10;
                    if (var6_6.getNumberedOIDString().startsWith(".-1")) {
                        var12_14 = (MibModule)this.mibOps.modules.get(var10_10.moduleName);
                        if (var12_14 == null) {
                            var12_14 = this.mibOps.getModuleFromGlobalImports(var10_10.moduleName);
                        }
                        var13_16 = new MibNode();
                        var13_16 = var6_6;
                        var13_16 = this.getCorrectOID((MibNode)var13_16);
                        var14_17 = var13_16.moduleName;
                        var15_18 = (MibModule)this.mibOps.modules.get(var14_17);
                        if (var15_18 == null) {
                            var15_18 = this.mibOps.getModuleFromGlobalImports((String)var14_17);
                        }
                        var16_22 = var15_18.getMibNodeByName(var13_16.label);
                        var16_22.oid_array = this.calcOID((MibNode)var16_22);
                        var17_24 /* !! */  = var16_22.getNumberedOIDString();
                        var18_25 = var16_22.parent.label;
                        var19_26 = var16_22.moduleName;
                        while (var17_24 /* !! */ .startsWith(".-1")) {
                            var20_27 = (MibModule)this.mibOps.modules.get(var19_26);
                            if (var20_27 == null) {
                                var20_27 = this.mibOps.getModuleFromGlobalImports(var19_26);
                            }
                            var21_28 = (MibNode)var20_27.unResolvedNodes.get(var18_25);
                            var22_29 /* !! */  = new MibNode();
                            var22_29 /* !! */  = var16_22;
                            var22_29 /* !! */  = this.getCorrectOID(var22_29 /* !! */ );
                            var23_30 = var22_29 /* !! */ .moduleName;
                            var24_31 = (MibModule)this.mibOps.modules.get(var23_30);
                            if (var24_31 == null) {
                                var24_31 = this.mibOps.getModuleFromGlobalImports(var23_30);
                            }
                            if ((var25_32 = var24_31.getMibNodeByName(var22_29 /* !! */ .label)) == null) {
                                throw new MibException(String.valueOf(SnmpUtils.getString("IMPORTS failed : import MIB")) + " " + var24_31 + SnmpUtils.getString("does not contain") + " " + var22_29 /* !! */ );
                            }
                            var25_32.oid_array = this.calcOID(var25_32);
                            if (var25_32.getNumberedOIDString().startsWith("-1")) {
                                var17_24 /* !! */  = var25_32.getNumberedOIDString();
                                var18_25 = var25_32.parent.label;
                                var19_26 = var25_32.moduleName;
                                continue;
                            }
                            var25_32.oid_array = this.calcOID(var25_32);
                            var22_29 /* !! */ .parent = var3_3 == false ? var25_32.parent.cloneNode() : var25_32.parent;
                            var22_29 /* !! */ .moduleName = var1_1.name;
                            var22_29 /* !! */ .subid = var25_32.subid;
                            break;
                        }
                        var16_22.oid_array = this.calcOID((MibNode)var16_22);
                        var13_16.parent = var3_3 == false ? var16_22.parent.cloneNode() : var16_22.parent;
                        var13_16.moduleName = var1_1.name;
                        var13_16.subid = var16_22.subid;
                        var6_6.oid_array = this.calcOID(var6_6);
                    }
                    if (!var3_3) {
                        this.copyChildren(var6_6, var11_12);
                    }
                }
                ++var7_7;
            }
            var8_8 = var2_2.tcList;
            var9_9 = (Vector)var2_2.tcList.clone();
            var5_5 = var8_8.size();
            var10_11 = true;
            var11_13 = 0;
            while (var11_13 < var5_5) {
                var12_14 = (String)var8_8.elementAt(var11_13);
                var13_16 = (LeafSyntax)var1_1.tcList.get(var12_14);
                if (var13_16 == null) {
                    this.mibOps.globalImports = null;
                    throw new MibException(String.valueOf(SnmpUtils.getString("import mib")) + " " + var1_1.getName() + " " + SnmpUtils.getString("does not contain") + " " + (String)var12_14);
                }
                var14_17 = (Vector)this.unResolvedTCList.get(var12_14);
                if (var14_17 == null) {
                    var9_9.removeElement(var12_14);
                    this.tcList.put(var12_14, var13_16);
                } else {
                    var15_20 = var14_17.size();
                    var16_23 = 0;
                    while (var16_23 < var15_20) {
                        var17_24 /* !! */  = var14_17.elementAt(var16_23);
                        if (var17_24 /* !! */  instanceof MibNode) {
                            if (var13_16.getType() == 0) {
                                var10_11 = false;
                                break;
                            }
                            ((MibNode)var17_24 /* !! */ ).updateSyntax((LeafSyntax)var13_16);
                        } else if (var17_24 /* !! */  instanceof MibTC) {
                            ((MibTC)var17_24 /* !! */ ).updateSyntax((LeafSyntax)var13_16);
                        } else {
                            this.mibOps.debugPrint(String.valueOf(SnmpUtils.getString("Examine this case of LeafSyntax not being a proper TC :")) + var17_24 /* !! */ );
                        }
                        ++var16_23;
                    }
                    if (var10_11) {
                        this.unResolvedTCList.remove(var12_14);
                        var9_9.removeElement(var12_14);
                    } else {
                        var2_2.importOids.removeAllElements();
                    }
                }
                ++var11_13;
            }
            var2_2.tcList = var9_9;
            if (var9_9.isEmpty()) {
                this.removeImportsClass(var1_1.getName());
            }
            if (!this.isResolved()) break block33;
            var12_15 = true;
            var13_16 = null;
            var14_17 = this.tcList.keys();
            while (var14_17.hasMoreElements()) {
                var15_21 = (String)var14_17.nextElement();
                var16_22 = (MibTC)this.tcList.get(var15_21);
                try {
                    var13_16 = (MibTC)var16_22.clone();
                }
                catch (Exception v0) {}
                if (var13_16.getType() == 0) ** GOTO lbl135
                continue;
lbl-1000:
                // 1 sources

                {
                    if ((var13_16 = (MibTC)this.tcList.get(var13_16.getSyntax().toString())) != null) continue;
                    var12_15 = false;
                    break;
lbl135:
                    // 2 sources

                    ** while (var13_16.getType() == 0)
                }
lbl136:
                // 2 sources

                if (var12_15) {
                    var16_22.syntax.type = var13_16.getType();
                }
                this.tcList.put(var15_21, var16_22);
            }
            this.mibOps.registerModule(this);
        }
    }

    String printOctets(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 20;
        if (byArray.length < n) {
            n = byArray.length;
        }
        int n4 = 0;
        while (n4 < n) {
            String string;
            if (n2++ > 19) {
                n2 = 1;
                stringBuffer.append("\n");
            }
            if ((string = Integer.toString(MibModule.byteToInt(byArray[n4]), 16)).length() < 2) {
                string = "0" + string;
            }
            stringBuffer.append(String.valueOf(string) + " ");
            ++n4;
        }
        return stringBuffer.toString();
    }

    void readFile() throws MibException, IOException {
        try {
            this.skipToEol();
            this.preModuleComments = this.readNextDesc();
            this.importsString = this.readNextDesc();
            this.readImportedOid();
            this.readImportedTC();
            this.readTCs();
            this.readTraps();
            this.readSequences();
            int n = this.inp.readInt();
            this.debugPrint(String.valueOf(SnmpUtils.getString("Primary OID Table size :")) + " " + n);
            this.skipToEol();
            int n2 = 0;
            while (n2 < n) {
                MibNode mibNode = new MibNode();
                String string = (mibNode = mibNode.readElements(this.inp, null, this)).getLabel();
                if (this.nodeList.get(string) == null) {
                    this.nodeList.put(mibNode.getLabel(), mibNode);
                }
                if (!this.mibOps.isStarterNode(mibNode)) {
                    this.rootNodes.addElement(mibNode);
                }
                ++n2;
            }
            boolean bl = this.inp.readBoolean();
            if (bl) {
                this.mibModules = this.inp.readUTF();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MibException(String.valueOf(SnmpUtils.getString("Compiled Mib")) + " " + this.mibOps.mibFileName + " " + SnmpUtils.getString("is corrupted"));
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            throw new MibException(String.valueOf(SnmpUtils.getString("Compiled Mib")) + " " + this.mibOps.mibFileName + SnmpUtils.getString("is corrupted"));
        }
        catch (IOException iOException) {
            if (MibOperations.errMsg) {
                System.err.println(String.valueOf(SnmpUtils.getString("IOException :")) + " " + iOException);
                System.err.println(String.valueOf(SnmpUtils.getString("Aborting at line :")) + " " + this.line + " " + iOException);
                byte[] byArray = new byte[10];
                try {
                    this.inp.read(byArray);
                }
                catch (IOException iOException2) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Error generating Debug dump")) + iOException2);
                }
                this.debugPrint(SnmpUtils.getString("Next 10 octets :"));
                this.debugPrint(this.printOctets(byArray, byArray.length));
            }
            throw new IOException(SnmpUtils.getString("Aborting ..."));
        }
    }

    void readFromHashtables() throws MibException, IOException {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        Hashtable hashtable3 = null;
        Hashtable hashtable4 = null;
        Hashtable hashtable5 = null;
        Hashtable hashtable6 = null;
        hashtable = MIBParser.getImportedOidTable();
        hashtable2 = MIBParser.getImportedTCTable();
        hashtable3 = MIBParser.getOIDTable();
        hashtable4 = MIBParser.getTCTable();
        hashtable5 = MIBParser.getTrapTable();
        hashtable6 = MIBParser.getSequenceTable();
        this.name = MIBParser.moduleName;
        this.preModuleComments = MIBParser.preModuleComments;
        this.importsString = MIBParser.getImportAsInMIB();
        Hashtable<String, Object> hashtable7 = new Hashtable<String, Object>(10);
        SyntaxOID syntaxOID = (SyntaxOID)hashtable3.get("iso");
        SyntaxOID syntaxOID2 = (SyntaxOID)hashtable3.get("ccitt");
        SyntaxOID syntaxOID3 = (SyntaxOID)hashtable3.get("joint-iso-ccitt");
        if (syntaxOID != null) {
            hashtable7.put("iso", syntaxOID);
        }
        if (syntaxOID2 != null) {
            hashtable7.put("ccitt", syntaxOID2);
        }
        if (syntaxOID3 != null) {
            hashtable7.put("joint-iso-ccitt", syntaxOID3);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object7 = (String)enumeration.nextElement();
            object6 = this.getImportsClass((String)object7);
            object5 = (Vector)hashtable.get(object7);
            object4 = ((Vector)object5).elements();
            while (object4.hasMoreElements()) {
                object3 = (SyntaxOID)object4.nextElement();
                object2 = new ImportOid(((SyntaxOID)object3).getName());
                hashtable7.put(((SyntaxOID)object3).getName(), object3);
                object = ((SyntaxOID)object3).childOIDList.elements();
                while (object.hasMoreElements()) {
                    ((ImportOid)object2).addChild(((SyntaxOID)object.nextElement()).getName());
                }
                ((ImportsClass)object6).addOidElement((ImportOid)object2);
            }
        }
        object7 = hashtable2.keys();
        while (object7.hasMoreElements()) {
            object6 = (String)object7.nextElement();
            object5 = this.getImportsClass((String)object6);
            object4 = (Vector)hashtable2.get(object6);
            object3 = ((Vector)object4).elements();
            while (object3.hasMoreElements()) {
                object2 = (SyntaxTextualConvention)object3.nextElement();
                if (object2 == null) continue;
                ((ImportsClass)object5).addTCElement(((SyntaxTextualConvention)object2).getName());
            }
        }
        object6 = hashtable4.keys();
        while (object6.hasMoreElements()) {
            object5 = (SyntaxTextualConvention)hashtable4.get((String)object6.nextElement());
            object4 = new MibTC();
            ((MibTC)object4).readElements((SyntaxTextualConvention)object5, this);
            this.tcList.put(((MibTC)object4).getName(), object4);
        }
        object5 = hashtable5.keys();
        while (object5.hasMoreElements()) {
            object4 = (SyntaxTrapType)hashtable5.get((String)object5.nextElement());
            object3 = new MibTrap();
            ((MibTrap)object3).readElements((SyntaxTrapType)object4, this);
            this.trapList.put(((MibTrap)object3).getName(), object3);
        }
        object4 = hashtable6.keys();
        while (object4.hasMoreElements()) {
            object3 = (SyntaxSequence)hashtable6.get((String)object4.nextElement());
            object2 = new Sequence(((SyntaxSequence)object3).getName());
            int n = 0;
            while (n < ((SyntaxSequence)object3).getSequence().size()) {
                string = (String)((SyntaxSequence)object3).getSequence().elementAt(n);
                int n2 = (Integer)((SyntaxSequence)object3).getSequence().elementAt(++n);
                ((Sequence)object2).addElement(string, n2);
                ++n;
            }
            this.seqList.put(((Sequence)object2).getName(), object2);
        }
        object3 = hashtable7.keys();
        while (object3.hasMoreElements()) {
            object2 = (SyntaxOID)hashtable7.get(object3.nextElement());
            object = new MibNode().readElements((SyntaxOID)object2, null, this);
            string = ((MibNode)object).getLabel();
            if (this.nodeList.get(string) == null) {
                this.nodeList.put(string, object);
            }
            if (this.mibOps.isStarterNode((MibNode)object)) continue;
            this.rootNodes.addElement(object);
        }
    }

    void readImportedOid() throws IOException {
        int n = this.inp.readInt();
        this.debugPrint(String.valueOf(SnmpUtils.getString("Count of Imported Oids:")) + n);
        this.skipToEol();
        int n2 = 0;
        while (n2 < n) {
            String string = this.inp.readUTF();
            this.debugPrint("\t" + n2 + ". :" + string);
            ImportsClass importsClass = this.getImportsClass(string);
            int n3 = this.inp.readInt();
            this.debugPrint("\t" + n2 + SnmpUtils.getString("Number of :") + n3);
            int n4 = 0;
            while (n4 < n3) {
                ImportOid importOid = new ImportOid(this.inp.readUTF());
                int n5 = this.inp.readInt();
                int n6 = 0;
                while (n6 < n5) {
                    importOid.addChild(this.inp.readUTF());
                    ++n6;
                }
                importsClass.addOidElement(importOid);
                ++n4;
            }
            this.skipToEol();
            ++n2;
        }
    }

    void readImportedTC() throws IOException {
        int n = this.inp.readInt();
        this.debugPrint(String.valueOf(SnmpUtils.getString("Count of Modules:")) + n);
        this.skipToEol();
        int n2 = 0;
        while (n2 < n) {
            ImportsClass importsClass = this.getImportsClass(this.inp.readUTF());
            int n3 = this.inp.readInt();
            int n4 = 0;
            while (n4 < n3) {
                String string = this.inp.readUTF();
                importsClass.addTCElement(string);
                ++n4;
            }
            this.skipToEol();
            ++n2;
        }
    }

    String readNextDesc() throws IOException {
        if (this.mibOps.isReadDesc() && this.descInp != null) {
            String string = this.descInp.readUTF();
            MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("cds read in :")) + " " + string, 0);
            return string;
        }
        return null;
    }

    Sequence readSequence() throws IOException {
        Sequence sequence = new Sequence(this.inp.readUTF());
        this.debugPrint(String.valueOf(SnmpUtils.getString("Reading Sequence")) + " " + sequence.getName());
        int n = this.inp.readInt();
        this.debugPrint(String.valueOf(SnmpUtils.getString("Number of Elements")) + " " + n);
        int n2 = 0;
        while (n2 < n) {
            String string = this.inp.readUTF();
            this.debugPrint("\n\t" + n2 + "." + string);
            int n3 = this.inp.readInt();
            this.debugPrint("\t" + SnmpUtils.getString("Type :") + " " + n3 + ":" + LeafSyntax.getTypeStr(n3));
            sequence.addElement(string, n3);
            ++n2;
        }
        this.debugPrint("\n");
        return sequence;
    }

    void readSequences() throws IOException {
        int n = this.inp.readInt();
        this.debugPrint(String.valueOf(SnmpUtils.getString("Sequence List Count :")) + " " + n);
        this.skipToEol();
        int n2 = 0;
        while (n2 < n) {
            Sequence sequence = this.readSequence();
            this.skipToEol();
            this.seqList.put(sequence.getName(), sequence);
            ++n2;
        }
    }

    void readTCs() throws IOException {
        int n = this.inp.readInt();
        this.skipToEol();
        this.debugPrint(String.valueOf(SnmpUtils.getString("Number of TCs to be added :")) + " " + n);
        int n2 = 0;
        while (n2 < n) {
            MibTC mibTC = new MibTC();
            mibTC.readElements(this.inp, this.descInp, this);
            this.tcList.put(mibTC.getName(), mibTC);
            this.debugPrint(String.valueOf(SnmpUtils.getString("Adding TC Element")) + " " + mibTC.getName());
            this.skipToEol();
            ++n2;
        }
    }

    void readTraps() throws IOException {
        int n = this.inp.readInt();
        this.skipToEol();
        this.debugPrint(String.valueOf(SnmpUtils.getString("Reading traps. Count :")) + " " + n);
        int n2 = 0;
        while (n2 < n) {
            MibTrap mibTrap = new MibTrap();
            mibTrap.readElements(this.inp, this);
            this.trapList.put(mibTrap.getName(), mibTrap);
            this.skipToEol();
            ++n2;
        }
    }

    private void removeImportsClass(String string) {
        this.imports.remove(string);
        this.mibOps.deregisterImport(string, this);
    }

    void skipToEol() throws IOException {
        ++this.line;
        int n = 115;
        int n2 = -1;
        while (n != 10) {
            n = this.inp.readByte();
            ++n2;
        }
        this.debugPrint(String.valueOf(SnmpUtils.getString("Skipped")) + " " + n2 + SnmpUtils.getString("additional bytes"));
    }

    public String toString() {
        return this.name;
    }

    public String translateToNames(String string) {
        if (string == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "., \t\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        MibNode mibNode = this.getMibNode(vector);
        if (mibNode == null) {
            return null;
        }
        return this.mibOps.toString(new SnmpOID(string), mibNode);
    }

    public String translateToNumbers(String string) {
        if (string == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "., \t\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        MibNode mibNode = this.getMibNode(vector);
        if (mibNode == null) {
            return null;
        }
        Vector vector2 = mibNode.getOIDVectorIds();
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("." + enumeration.nextElement());
        }
        int n = vector2.size();
        while (n < vector.size()) {
            stringBuffer.append("." + vector.elementAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    void upDateRootsChildren(MibNode mibNode, MibNode mibNode2) {
        if (mibNode.label.equals(mibNode2.label) || mibNode2.label.equals("ccitt")) {
            this.root = mibNode2;
            return;
        }
        MibNode mibNode3 = mibNode2.parent;
        while (!mibNode3.label.equals(mibNode.label)) {
            this.update(mibNode3, mibNode2);
            mibNode2 = mibNode3;
            mibNode3 = mibNode3.parent;
            if (mibNode3 != null) continue;
            return;
        }
        this.update(mibNode3, mibNode2);
    }

    void update(MibNode mibNode, MibNode mibNode2) {
        if (mibNode == null) {
            return;
        }
        mibNode.childList = new Vector();
        mibNode.addChild(mibNode2);
    }

    class ImportsClass
    implements Serializable {
        Vector importOids = new Vector();
        Vector tcList = new Vector();
        String moduleName;

        ImportsClass() {
        }

        public void addOidElement(ImportOid importOid) {
            this.importOids.addElement(importOid);
        }

        public void addTCElement(String string) {
            this.tcList.addElement(string);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n\t");
            int n = 0;
            while (n < this.importOids.size() - 1) {
                stringBuffer.append(String.valueOf(((ImportOid)this.importOids.elementAt(n)).getOidName()) + ", ");
                ++n;
            }
            if (this.tcList.size() > 0) {
                if (this.importOids.size() > 0) {
                    stringBuffer.append(String.valueOf(((ImportOid)this.importOids.elementAt(n)).getOidName()) + ", ");
                }
                int n2 = 0;
                while (n2 < this.tcList.size() - 1) {
                    stringBuffer.append(String.valueOf((String)this.tcList.elementAt(n2)) + ", ");
                    ++n2;
                }
                if (n2 >= 0) {
                    stringBuffer.append(String.valueOf((String)this.tcList.elementAt(n2)) + "\n\t");
                }
            } else if (this.importOids.size() > 0) {
                stringBuffer.append(String.valueOf(((ImportOid)this.importOids.elementAt(n)).getOidName()) + "\n\t");
            }
            stringBuffer.append("\t" + SnmpUtils.getString("FROM") + " " + this.moduleName);
            return stringBuffer.toString();
        }
    }

    class ImportOid
    implements Serializable {
        Vector childList = new Vector();
        String oidName;

        private ImportOid() {
        }

        public ImportOid(String string) {
            this.oidName = string;
        }

        public void addChild(String string) {
            this.childList.addElement(string);
        }

        public Vector getChildList() {
            return this.childList;
        }

        public String getOidName() {
            return this.oidName;
        }

        public boolean hasChildren() {
            return this.childList.size() != 0;
        }
    }
}

