/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs;

import com.adventnet.snmp.mibs.LeafSyntax;
import com.adventnet.snmp.mibs.MibException;
import com.adventnet.snmp.mibs.MibMacro;
import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.mibs.mibparser.CommentClass;
import com.adventnet.snmp.mibs.mibparser.MIBConstants;
import com.adventnet.snmp.mibs.mibparser.SyntaxOID;
import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.snmp.snmp2.SnmpVarBind;
import com.adventnet.utils.SnmpUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class MibNode
implements Serializable,
MIBConstants {
    String impliedNode = null;
    Object userObj = null;
    CommentClass commentObj = null;
    boolean isImported = false;
    int subid = -1;
    Vector childList = new Vector();
    int[] oid_array = null;
    String oid_string = null;
    boolean isImplied = false;
    MibNode nextNode = null;
    boolean addedForResolving = false;
    int m_type = -1;
    static String odd = "OBJECT IDENTIFIER";
    MibNode remoteParent = null;
    String moduleName = null;
    String macroType = null;
    String label = null;
    MibNode parent;
    LeafSyntax syntax;
    int access;
    String status;
    int node_status = -1;
    int node_access = -1;
    String description;
    String reference;
    Vector indexNames;
    String defval;
    String tableSequence;
    String rowName;
    Vector tableItems = null;

    MibNode() {
    }

    MibNode addChild(MibNode mibNode) {
        if (MibOperations.errMsg) {
            System.err.println(String.valueOf(SnmpUtils.getString("Node :")) + " " + this.getLabel() + "\n" + this.toTagString());
            System.err.println(String.valueOf(SnmpUtils.getString("Node :")) + " " + mibNode.getLabel() + "\n" + mibNode.toTagString());
        }
        if (mibNode.moduleName == null) {
            return this.addChild(mibNode, this.getModuleName());
        }
        return this.addChild(mibNode, mibNode.getModuleName());
    }

    MibNode addChild(MibNode mibNode, String string) {
        if (this.oid_array != null) {
            mibNode.updateOID(this.oid_array);
        }
        if (this.oid_string != null) {
            mibNode.updateOID(this.oid_string);
        }
        boolean bl = false;
        if (!string.equals(this.getModuleName()) && this.getModuleName() != null) {
            bl = true;
        }
        int n = this.childList.size();
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            MibNode mibNode2 = (MibNode)this.childList.elementAt(n2);
            int n3 = mibNode.getSubid();
            if (n3 != -1) {
                if (n3 < mibNode2.getSubid()) {
                    this.childList.insertElementAt(mibNode, n2);
                    if (bl) {
                        mibNode.setParent(this);
                        break;
                    }
                    mibNode.setParent(this);
                    break;
                }
            } else if (MibOperations.errMsg) {
                System.err.println(String.valueOf(SnmpUtils.getString("Critical error in adding child")) + " " + mibNode.getLabel() + "\n" + mibNode.toTagString());
            }
            ++n2;
        }
        if (n2 == n) {
            this.childList.addElement(mibNode);
            if (bl) {
                mibNode.setParent(this);
            } else {
                mibNode.setParent(this);
            }
        }
        return mibNode;
    }

    void addToNodeList(MibModule mibModule) {
        if (mibModule.getName().equals(this.getModuleName())) {
            mibModule.nodeList.put(this.label, this);
        }
        Enumeration enumeration = this.childList.elements();
        while (enumeration.hasMoreElements()) {
            MibNode mibNode = (MibNode)enumeration.nextElement();
            mibNode.addToNodeList(mibModule);
        }
    }

    MibNode cloneNode() {
        MibNode mibNode = new MibNode();
        mibNode.isImported = true;
        if (this.moduleName != null) {
            mibNode.moduleName = new String(this.moduleName);
        }
        mibNode.m_type = this.m_type;
        if (this.macroType != null) {
            mibNode.macroType = new String(this.macroType);
        }
        mibNode.label = new String(this.label);
        mibNode.subid = this.subid;
        mibNode.parent = this.parent != null ? this.parent.cloneNode() : null;
        mibNode.childList = (Vector)this.childList.clone();
        try {
            if (this.syntax != null) {
                mibNode.syntax = (LeafSyntax)this.syntax.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println(cloneNotSupportedException.getMessage());
        }
        mibNode.access = this.access;
        if (this.status != null) {
            mibNode.status = new String(this.status);
        }
        if (this.description != null) {
            mibNode.description = new String(this.description);
        }
        if (this.reference != null) {
            mibNode.reference = new String(this.reference);
        }
        if (this.indexNames != null) {
            mibNode.indexNames = (Vector)this.indexNames.clone();
        }
        if (this.tableItems != null) {
            mibNode.tableItems = (Vector)this.tableItems.clone();
        }
        return mibNode;
    }

    int compare(int[] nArray, int[] nArray2, int n) {
        if (nArray2.length < n) {
            n = nArray2.length;
        }
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] < nArray2[n2]) {
                return 1;
            }
            if (nArray[n2] > nArray2[n2]) {
                return -1;
            }
            ++n2;
        }
        return 0;
    }

    public SnmpVarBind createSnmpVarBind(Vector vector, SnmpVar snmpVar, Vector vector2) {
        int[] nArray = this.syntax.encodeInstanceString(vector, vector2);
        int[] nArray2 = this.getOID();
        int[] nArray3 = new int[nArray.length + nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            nArray3[n] = nArray2[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray3[n++] = nArray[n2];
            ++n2;
        }
        SnmpOID snmpOID = new SnmpOID(nArray3);
        if (nArray3.length > 128 && MibOperations.errMsg) {
            System.err.println(String.valueOf(SnmpUtils.getString("Warning : OID Sub-Identifiers exceed 128")) + " ");
        }
        SnmpVarBind snmpVarBind = new SnmpVarBind(snmpOID, snmpVar);
        return snmpVarBind;
    }

    public SnmpVar decodeDefval() throws MibException, SnmpException {
        byte by;
        String string = this.getDefval();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).equals("{") || string.equals("}")) {
            return null;
        }
        if (string.startsWith("{")) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith("}")) {
            string = string.substring(0, string.length() - 1);
        }
        if (MibOperations.jdbc) {
            this.syntax = this.getSyntax();
            by = this.syntax.getType();
        } else {
            by = this.syntax.type;
        }
        switch (by) {
            case 2: 
            case 65: 
            case 66: 
            case 67: {
                if (string.equals("")) {
                    return null;
                }
                return this.syntax.createVariable(string);
            }
            case 4: {
                if (string.startsWith("'") || string.startsWith("`")) {
                    String string2 = null;
                    char c = string.charAt(string.length() - 1);
                    string2 = string.substring(1, string.length() - 2);
                    switch (c) {
                        case 'B': 
                        case 'b': {
                            char[] cArray = string2.length() % 8 == 0 ? new char[string2.length() / 8] : new char[string2.length() / 8 + 1];
                            int n = 0;
                            while (n < cArray.length) {
                                String string3 = n * 8 + 4 <= string2.length() ? string2.substring(n * 8, n * 8 + 4) : string2.substring(n * 8);
                                cArray[n] = (char)Integer.parseInt(string3, 2);
                                ++n;
                            }
                            string = new String(cArray);
                            return this.syntax.createVariable(string);
                        }
                        case 'H': 
                        case 'h': {
                            char[] cArray = string2.length() % 2 == 0 ? new char[string2.length() / 2] : new char[string2.length() / 2 + 1];
                            int n = 0;
                            while (n < cArray.length) {
                                String string4 = n * 2 + 2 <= string2.length() ? string2.substring(n * 2, n * 2 + 2) : string2.substring(n * 2);
                                cArray[n] = (char)Integer.parseInt(string4, 16);
                                ++n;
                            }
                            string = new String(cArray);
                            return this.syntax.createVariable(string);
                        }
                    }
                    throw new MibException(String.valueOf(SnmpUtils.getString("Exception in parsing OCTET STRING defval:")) + " " + c + "\n");
                }
                return this.syntax.createVariable(string);
            }
            case 64: {
                if (string.startsWith("'") || string.startsWith("`")) {
                    String string5 = null;
                    StringBuffer stringBuffer = new StringBuffer();
                    char c = string.charAt(string.length() - 1);
                    string = string.substring(1, string.length() - 2);
                    switch (c) {
                        case 'B': 
                        case 'b': {
                            throw new MibException(String.valueOf(SnmpUtils.getString("Ipaddress can't be represented in binary format in DEFVAL clause")) + "\n");
                        }
                        case 'H': 
                        case 'h': {
                            if (string.length() != 8) {
                                throw new MibException(String.valueOf(SnmpUtils.getString("Some problem in decoding IPADDRESS defval:")) + " " + string + "+\n");
                            }
                            int n = 0;
                            while (n < 4) {
                                string5 = string.substring(2 * n, 2 * n + 2);
                                if (n != 0) {
                                    stringBuffer.append(".");
                                }
                                stringBuffer.append(Long.toString(Long.parseLong(string5, 16)));
                                ++n;
                            }
                            return this.syntax.createVariable(stringBuffer.toString());
                        }
                    }
                    throw new MibException(String.valueOf(SnmpUtils.getString("Exception in parsing defval:")) + " " + c + "\n");
                }
                return this.syntax.createVariable(string);
            }
            case 6: {
                string = string.trim();
                if (!string.startsWith("{")) {
                    return null;
                }
                string = string.substring(1, string.length());
                if (string.endsWith("}")) {
                    string = string.substring(0, string.length() - 1);
                }
                String string6 = ".";
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    string6 = String.valueOf(string6) + stringTokenizer.nextToken() + ".";
                }
                return this.syntax.createVariable(string6);
            }
            case 5: {
                return this.syntax.createVariable(string);
            }
        }
        throw new MibException(String.valueOf(SnmpUtils.getString("Could not recognize syntax type:")) + " " + this.syntax.type + SnmpUtils.getString("in DEFVAL"));
    }

    public int getAccess() {
        return this.access;
    }

    public MibNode getChild(int n) {
        MibNode mibNode = null;
        int n2 = this.childList.size();
        int n3 = 0;
        while (n3 < n2) {
            mibNode = (MibNode)this.childList.elementAt(n3);
            if (mibNode.getSubid() == n) {
                return mibNode;
            }
            ++n3;
        }
        return null;
    }

    public Vector getChildList() {
        return this.childList;
    }

    CommentClass getCommentObject() {
        return this.commentObj;
    }

    public MibNode getCommonAncestorWith(MibNode mibNode) {
        if (mibNode.getLabel().equals(this.label)) {
            return mibNode;
        }
        if (mibNode.isAncestorOf(this)) {
            return mibNode;
        }
        if (mibNode.isDescendentOf(this)) {
            return this;
        }
        MibNode mibNode2 = this.getParent();
        while (mibNode2 != null) {
            if (mibNode.getOIDVector().contains(mibNode2.label)) {
                return mibNode2;
            }
            mibNode2 = mibNode2.getParent();
        }
        return mibNode2;
    }

    public String getDefval() {
        if (this.defval != null && this.defval.startsWith("\"") && this.defval.endsWith("\"")) {
            String string = this.defval.substring(1, this.defval.length() - 1);
            return string;
        }
        return this.defval;
    }

    public String getDescription() {
        if (this.description != null && this.description.startsWith("\"") && this.description.endsWith("\"")) {
            this.description = this.description.substring(1, this.description.length() - 1);
        }
        return this.description;
    }

    public Vector getExternalIndices() {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        if (this.isTableEntry()) {
            if (MibOperations.jdbc) {
                vector = this.getParent().getTableItems();
                vector2 = (Vector)vector.clone();
                vector3 = this.getIndexNames();
                vector3.remove("IMPLIED");
            } else {
                vector = (Vector)this.parent.tableItems.clone();
                vector2 = (Vector)vector.clone();
                vector3 = (Vector)this.indexNames.clone();
            }
            int n = vector3.size();
            String string = "";
            int n2 = 0;
            while (n2 < n) {
                string = (String)vector3.elementAt(n2);
                if (!vector.contains(string)) {
                    vector.addElement(string);
                }
                ++n2;
            }
            String string2 = null;
            String string3 = null;
            int n3 = vector2.size();
            int n4 = 0;
            while (n4 < n3) {
                string2 = (String)vector2.elementAt(n4);
                int n5 = 0;
                while (n5 < vector.size()) {
                    string3 = (String)vector.elementAt(n5);
                    if (string3 != null && string2 != null && string3.equals(string2)) {
                        vector.removeElement(string3);
                    }
                    ++n5;
                }
                ++n4;
            }
        }
        return vector;
    }

    public String getImpliedNode() {
        return this.impliedNode;
    }

    public Vector getIndexNames() {
        return this.indexNames;
    }

    public Vector getIndexes(MibOperations mibOperations) {
        MibNode mibNode;
        if (MibOperations.jdbc) {
            this.parent = this.getParent();
        }
        if (this.parent == null || !this.parent.isTableEntry()) {
            return null;
        }
        Vector<MibNode> vector = new Vector<MibNode>();
        String string = null;
        Enumeration enumeration = null;
        enumeration = MibOperations.jdbc ? this.parent.getIndexNames().elements() : this.parent.indexNames.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            mibNode = mibOperations.getMibNode(string);
            if (mibNode == null) continue;
            vector.addElement(mibNode);
        }
        if (string.startsWith("IMPLIED")) {
            string = string.substring(7);
        }
        if ((mibNode = mibOperations.getMibNode(string = string.trim())) != null) {
            vector.setElementAt(mibNode, vector.size() - 1);
        }
        return vector;
    }

    public String getLabel() {
        return this.label;
    }

    public String getMacroType() {
        if (this.m_type == -1) {
            return this.macroType;
        }
        return this.getMacroTypeStr();
    }

    int getMacroTypeInt() {
        return this.m_type;
    }

    String getMacroTypeStr() {
        if (this.m_type == 1) {
            return odd;
        }
        return MIBConstants.macroStr[this.m_type & 0xF];
    }

    public String getModuleName() {
        if (this.moduleName == null) {
            if (MibOperations.errMsg) {
                System.err.println(String.valueOf(SnmpUtils.getString("Module name not found in")) + " " + this.getLabel());
            }
            if (this.parent == null) {
                return null;
            }
            return this.parent.getModuleName();
        }
        if (MibOperations.errMsg) {
            System.err.println(String.valueOf(SnmpUtils.getString("Found module Name in ")) + this.getLabel());
        }
        return this.moduleName;
    }

    public MibNode getNextLeafNode() {
        MibNode mibNode = this;
        do {
            MibNode mibNode2;
            if (mibNode.getChildList().size() != 0) {
                mibNode = (MibNode)mibNode.getChildList().firstElement();
                continue;
            }
            do {
                if ((mibNode2 = mibNode.getParent()) == null) {
                    return null;
                }
                Enumeration enumeration = mibNode2.getChildList().elements();
                while (enumeration.hasMoreElements()) {
                    if (((MibNode)enumeration.nextElement()).getLabel().equals(mibNode.getLabel())) break;
                }
                if (enumeration.hasMoreElements()) {
                    mibNode = (MibNode)enumeration.nextElement();
                    continue;
                }
                mibNode = mibNode2;
                mibNode2 = null;
            } while (mibNode2 == null);
        } while (mibNode.getSyntax() == null);
        return mibNode;
    }

    MibNode getNextNode() {
        return this.nextNode;
    }

    int getNodeAccess() {
        return this.node_access;
    }

    String getNodeAccessStr() {
        if (this.node_access == -1) {
            if (MibOperations.errMsg) {
                System.err.println(SnmpUtils.getString("Access is -1. Verify why. A simple reason could be that this IS AN OBJECT-IDENTIFIER"));
            }
            return null;
        }
        return MIBConstants.accessStr[this.node_access];
    }

    int getNodeStatus() {
        return this.node_status;
    }

    public String getNumberedOIDString() {
        if (this.oid_array == null) {
            this.getOID();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("." + this.oid_array[0]);
        int n = 1;
        while (n < this.oid_array.length) {
            stringBuffer.append("." + ((long)this.oid_array[n] & 0xFFFFFFFFL));
            ++n;
        }
        if (MibOperations.errMsg) {
            System.err.println(String.valueOf(SnmpUtils.getString("++++++returning numbered oid :")) + stringBuffer);
        }
        return stringBuffer.toString();
    }

    public int[] getOID() {
        if (this.oid_array != null) {
            return (int[])this.oid_array.clone();
        }
        Vector<Integer> vector = new Vector<Integer>();
        MibNode mibNode = this;
        while (mibNode != null) {
            vector.insertElementAt(new Integer(mibNode.subid), 0);
            mibNode = mibNode.parent;
        }
        int[] nArray = new int[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            nArray[n++] = (Integer)enumeration.nextElement();
        }
        this.oid_array = (int[])nArray.clone();
        return nArray;
    }

    public String getOIDString() {
        if (this.oid_string != null) {
            return this.oid_string;
        }
        if (this.parent != null) {
            return String.valueOf(this.parent.getOIDString()) + "." + this.label;
        }
        return "." + this.label;
    }

    public Vector getOIDVector() {
        Vector<String> vector = new Vector<String>();
        MibNode mibNode = this;
        StringTokenizer stringTokenizer = new StringTokenizer(this.getOIDString(), ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            vector.addElement(string);
        }
        return vector;
    }

    public Vector getOIDVectorIds() {
        Vector<Integer> vector = new Vector<Integer>();
        MibNode mibNode = this;
        while (mibNode != null) {
            vector.insertElementAt(new Integer(mibNode.subid), 0);
            mibNode = mibNode.getParent();
        }
        return vector;
    }

    public MibNode getParent() {
        return this.parent;
    }

    public String getReference() {
        return this.reference;
    }

    public String getRowName() {
        return this.rowName;
    }

    public String getStatus() {
        return this.status;
    }

    public int getSubid() {
        return this.subid;
    }

    public LeafSyntax getSyntax() {
        return this.syntax;
    }

    public Vector getTableItems() {
        if (this.tableItems != null) {
            return (Vector)this.tableItems.clone();
        }
        return null;
    }

    public String getTableSequence() {
        return this.tableSequence;
    }

    Object getUserObject() {
        return this.userObj;
    }

    boolean hasChildren() {
        return this.childList.size() > 0;
    }

    public boolean isAncestorOf(MibNode mibNode) {
        int[] nArray;
        int[] nArray2 = this.getOID();
        int n = this.compare(nArray2, nArray = mibNode.getOID(), nArray2.length);
        if (n == 0) {
            if (nArray2.length == nArray.length) {
                return false;
            }
            return nArray2.length < nArray.length;
        }
        return false;
    }

    public boolean isDescendentOf(MibNode mibNode) {
        return mibNode.isAncestorOf(this);
    }

    public boolean isImplied() {
        return this.isImplied;
    }

    public boolean isImportedNode() {
        return this.isImported;
    }

    public boolean isInCurrentTable(String string) {
        Vector vector = this.getTableItems();
        return vector.contains(string);
    }

    public boolean isIndex() {
        Vector vector;
        MibNode mibNode = this.getParent();
        if (mibNode != null && (vector = mibNode.getIndexNames()) != null) {
            return vector.contains(this.getLabel());
        }
        return false;
    }

    public boolean isLeaf() {
        return this.getSyntax() != null;
    }

    public boolean isReadable() {
        if (this.syntax != null) {
            return this.node_access == 1 || this.node_access == 2;
        }
        return false;
    }

    public boolean isScalar() {
        if (this.getSyntax() == null) {
            return false;
        }
        return this.isTableColumn() ^ true;
    }

    public boolean isTable() {
        Vector vector = this.getTableItems();
        return vector != null && vector.size() != 0;
    }

    public boolean isTableColumn() {
        if (this.parent == null) {
            return false;
        }
        Vector vector = this.parent.getIndexNames();
        return vector != null && vector.size() != 0;
    }

    public boolean isTableEntry() {
        Vector vector = this.getIndexNames();
        return vector != null && vector.size() != 0;
    }

    public boolean isWriteable() {
        if (this.syntax != null) {
            return this.node_access == 2 || this.node_access == 3;
        }
        return false;
    }

    void merge(MibNode mibNode) throws MibException {
        Vector vector = mibNode.getChildList();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.addChild((MibNode)vector.elementAt(n2));
            ++n2;
        }
    }

    public String printAccess() {
        return this.getNodeAccessStr();
    }

    public String printDescription() {
        return this.description;
    }

    public Vector printIndex() {
        return this.indexNames;
    }

    String printNodeProperties() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(SnmpUtils.getString("Node:")) + " " + this.label + "\n");
        stringBuffer.append(String.valueOf(SnmpUtils.getString("macroType =")) + " " + this.getMacroTypeInt() + " " + this.getMacroTypeStr() + "\n");
        return stringBuffer.toString();
    }

    public String printReference() {
        return this.reference;
    }

    public String printStatus() {
        return MIBConstants.statusStr[this.getNodeStatus()];
    }

    MibNode readElements(SyntaxOID syntaxOID, MibNode mibNode, MibModule mibModule) {
        int n;
        MibNode mibNode2 = this;
        mibNode2.label = syntaxOID.getName();
        mibNode2.subid = syntaxOID.getValue();
        mibNode2.moduleName = mibModule.name;
        if (mibNode2.label.equals("org") && mibNode2.subid == -5555) {
            n = MibOperations.standardNodes.indexOf(mibNode2.label);
            this.addedForResolving = true;
            mibNode2.subid = MibOperations.oidNums[n];
        } else {
            this.addedForResolving = false;
        }
        if (mibNode2.subid < -1) {
            if (MibOperations.standardNodes.contains(mibNode2.label)) {
                n = MibOperations.standardNodes.indexOf(mibNode2.label);
                mibNode2.subid = MibOperations.oidNums[n];
                mibModule.rootNodes.addElement(mibNode2);
            }
        } else if (mibNode2.subid == -1) {
            mibNode2.moduleName = mibModule.getName();
            MibOperations cfr_ignored_0 = mibModule.mibOps;
            MibOperations cfr_ignored_1 = mibModule.mibOps;
            MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Set the module Name for")) + " " + mibNode2.getLabel() + SnmpUtils.getString("to") + " " + mibNode2.moduleName, 0);
            mibModule.mibOps.debugPrint(String.valueOf(SnmpUtils.getString("Should have resolved or atleast fixed import by now.")) + mibNode2.label);
            mibModule.unResolvedNodes.put(mibNode2.getLabel(), mibNode2);
        }
        n = syntaxOID.getType();
        mibNode2.setMacroTypeInt(n);
        if (mibNode != null) {
            if (mibModule.isBaseNode(mibNode) && !this.addedForResolving) {
                mibNode2.moduleName = mibModule.getName();
                mibModule.rootNodes.addElement(mibNode2);
            }
            mibNode.addChild(mibNode2);
            mibNode2.parent = mibNode;
            mibModule.debugPrint("parent : " + mibNode.getLabel());
        } else if (mibNode2.subid != -1) {
            mibModule.debugPrint(String.valueOf(SnmpUtils.getString("Why is parent null for this")) + " " + this.label);
            mibModule.mibOps.debugPrint(String.valueOf(SnmpUtils.getString("Assuming this is a root element such as iso.. :")) + this.label);
            if (!mibModule.isBaseNode(mibNode2)) {
                MibOperations cfr_ignored_2 = mibModule.mibOps;
                MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Failed. This is not the root of class iso..:")) + this.label, 2);
                MibOperations cfr_ignored_3 = mibModule.mibOps;
                MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Performing recovery..")) + "\n" + SnmpUtils.getString("some behaviour could be unexpected.."), 2);
                mibNode2 = this;
            }
        }
        mibModule.debugPrint(String.valueOf(SnmpUtils.getString("Macro Type is")) + " " + this.getMacroTypeStr());
        MibMacro.readElements(syntaxOID, n, mibNode2, mibModule);
        int n2 = syntaxOID.childOIDList.size();
        mibModule.debugPrint(String.valueOf(SnmpUtils.getString("No. of kids :")) + " " + n2);
        int n3 = 0;
        while (n3 < syntaxOID.childOIDList.size()) {
            if (n2 > 0) {
                MibNode mibNode3 = new MibNode().readElements((SyntaxOID)syntaxOID.childOIDList.elementAt(n3), mibNode2, mibModule);
                mibModule.nodeList.put(mibNode3.getLabel(), mibNode3);
            }
            ++n3;
        }
        return mibNode2;
    }

    MibNode readElements(DataInputStream dataInputStream, MibNode mibNode, MibModule mibModule) throws IOException {
        int n;
        MibNode mibNode2 = this;
        mibNode2.label = dataInputStream.readUTF();
        mibModule.debugPrint(String.valueOf(SnmpUtils.getString("Reading OID :")) + " " + mibNode2.label);
        mibNode2.subid = dataInputStream.readInt();
        mibNode2.moduleName = mibModule.name;
        mibModule.mibOps.debugPrint(String.valueOf(SnmpUtils.getString("Sub-Id :")) + " " + mibNode2.subid);
        if (mibNode2.label.equals("org") && mibNode2.subid == -5555) {
            n = MibOperations.standardNodes.indexOf(mibNode2.label);
            this.addedForResolving = true;
            mibNode2.subid = MibOperations.oidNums[n];
        } else {
            this.addedForResolving = false;
        }
        if (mibNode2.subid < -1) {
            if (MibOperations.standardNodes.contains(mibNode2.label)) {
                n = MibOperations.standardNodes.indexOf(mibNode2.label);
                mibNode2.subid = MibOperations.oidNums[n];
                mibModule.rootNodes.addElement(mibNode2);
            }
        } else if (mibNode2.subid == -1) {
            mibNode2.moduleName = mibModule.getName();
            MibOperations cfr_ignored_0 = mibModule.mibOps;
            MibOperations cfr_ignored_1 = mibModule.mibOps;
            MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Set the module Name for")) + " " + mibNode2.getLabel() + " " + SnmpUtils.getString("to") + " " + mibNode2.moduleName, 0);
            mibModule.mibOps.debugPrint(String.valueOf(SnmpUtils.getString("Should have resolved or atleast fixed import by now.")) + mibNode2.label);
            mibModule.unResolvedNodes.put(mibNode2.getLabel(), mibNode2);
        }
        n = dataInputStream.readInt();
        mibNode2.setMacroTypeInt(n);
        if (mibNode != null) {
            if (mibModule.isBaseNode(mibNode) && !this.addedForResolving) {
                mibNode2.moduleName = mibModule.getName();
                mibModule.rootNodes.addElement(mibNode2);
            }
            mibNode2 = mibNode.addChild(mibNode2);
            mibNode2.parent = mibNode;
            mibModule.debugPrint("parent : " + mibNode.getLabel());
        } else if (mibNode2.subid != -1) {
            mibModule.debugPrint(String.valueOf(SnmpUtils.getString("Why is parent null for this")) + " " + this.label);
            mibModule.mibOps.debugPrint(String.valueOf(SnmpUtils.getString("Assuming this is a root element such as iso.. :")) + this.label);
            if (!mibModule.isBaseNode(mibNode2)) {
                MibOperations cfr_ignored_2 = mibModule.mibOps;
                MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Failed. This is not the root of class iso..:")) + this.label, 2);
                MibOperations cfr_ignored_3 = mibModule.mibOps;
                MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Performing recovery..")) + "\n" + SnmpUtils.getString("some behaviour could be unexpected.."), 2);
                mibNode2 = this;
            }
        }
        mibModule.debugPrint(String.valueOf(SnmpUtils.getString("Macro Type is")) + " " + this.getMacroTypeStr());
        MibMacro.readElements(dataInputStream, n, mibNode2, mibModule);
        mibModule.skipToEol();
        int n2 = dataInputStream.readInt();
        mibModule.debugPrint(String.valueOf(SnmpUtils.getString("No. of kids :")) + " " + n2);
        mibModule.skipToEol();
        int n3 = 0;
        while (n3 < n2) {
            if (n2 > 0) {
                MibNode mibNode3 = new MibNode().readElements(dataInputStream, mibNode2, mibModule);
                mibModule.nodeList.put(mibNode3.getLabel(), mibNode3);
            }
            ++n3;
        }
        return mibNode2;
    }

    void setCommentObject(CommentClass commentClass) {
        this.commentObj = commentClass;
    }

    public void setDefval(String string) {
        this.defval = string;
    }

    void setMacroTypeInt(int n) {
        this.m_type = n;
    }

    void setParent(MibNode mibNode) {
        this.parent = mibNode;
    }

    void setRemoteParent(MibNode mibNode) {
        this.remoteParent = mibNode;
    }

    void setUserObject(Object object) {
        this.userObj = object;
    }

    public String toString() {
        return this.label;
    }

    public String toTagString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(SnmpUtils.getString("Node OID:")) + " " + this.getOIDString());
        stringBuffer.append("\n" + SnmpUtils.getString("Syntax:") + " " + this.syntax);
        stringBuffer.append(", " + SnmpUtils.getString("Access:") + " " + this.printAccess());
        stringBuffer.append(", " + SnmpUtils.getString("Status:") + " " + this.getStatus());
        stringBuffer.append("\n" + SnmpUtils.getString("Description:") + " " + this.description + "\n");
        stringBuffer.append(String.valueOf(SnmpUtils.getString("Reference:")) + " " + this.reference);
        stringBuffer.append(", " + SnmpUtils.getString("Index:") + " " + this.indexNames);
        stringBuffer.append("\n" + SnmpUtils.getString("TableItems:") + " ");
        if (this.tableItems != null) {
            Enumeration enumeration = this.tableItems.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(" " + (String)enumeration.nextElement());
            }
        }
        return stringBuffer.toString();
    }

    void updateOID(String string) {
        if (this.oid_string != null) {
            return;
        }
        this.oid_string = String.valueOf(string) + "." + this.label;
        int n = this.childList.size();
        int n2 = 0;
        while (n2 < n) {
            ((MibNode)this.childList.elementAt(n2)).updateOID(this.oid_string);
            ++n2;
        }
    }

    void updateOID(int[] nArray) {
        if (this.oid_array != null) {
            return;
        }
        this.oid_array = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, this.oid_array, 0, nArray.length);
        this.oid_array[nArray.length] = this.getSubid();
        int n = this.childList.size();
        int n2 = 0;
        while (n2 < n) {
            ((MibNode)this.childList.elementAt(n2)).updateOID(this.oid_array);
            ++n2;
        }
    }

    void updateSyntax(LeafSyntax leafSyntax) {
        block11: {
            MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Updating syntax for")) + " " + this.getLabel() + " to use " + leafSyntax, 3);
            if (this.syntax == null) {
                this.syntax = leafSyntax;
                this.syntax.type = this.syntax.getType();
                return;
            }
            if (this.syntax.range != null) {
                LeafSyntax leafSyntax2;
                block10: {
                    leafSyntax2 = null;
                    try {
                        leafSyntax2 = (LeafSyntax)leafSyntax.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        if (!MibOperations.errMsg) break block10;
                        System.err.println(String.valueOf(SnmpUtils.getString("Error cloning in updateSyntax of MibNode :")) + this.getLabel());
                    }
                }
                if (leafSyntax2 != null) {
                    leafSyntax2.range = this.syntax.range;
                    this.syntax = leafSyntax2;
                } else {
                    this.syntax = leafSyntax;
                }
            } else {
                try {
                    this.syntax = (LeafSyntax)leafSyntax.clone();
                    if (this.syntax.range != null) {
                        this.syntax.range.preDefinedRange = true;
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    if (!MibOperations.errMsg) break block11;
                    System.err.println(String.valueOf(SnmpUtils.getString("Error cloning in updateSyntax of MibNode :")) + this.getLabel());
                }
            }
        }
        this.syntax.type = this.syntax.getType();
        this.syntax.initializeMINandMAXvalues();
    }
}

