/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs;

import com.adventnet.snmp.mibs.ImportResolver;
import com.adventnet.snmp.mibs.JdbcMibOperations;
import com.adventnet.snmp.mibs.LeafSyntax;
import com.adventnet.snmp.mibs.MibException;
import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibTrap;
import com.adventnet.snmp.mibs.RangeList;
import com.adventnet.snmp.mibs.SnmpDateAndTime;
import com.adventnet.snmp.mibs.mibparser.MIBConstants;
import com.adventnet.snmp.mibs.mibparser.MIBParser;
import com.adventnet.snmp.mibs.mibparser.ParseException;
import com.adventnet.snmp.snmp2.SASClient;
import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.snmp.snmp2.SnmpInt;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.snmp2.SnmpString;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.snmp.snmp2.SnmpVarBind;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MibOperations
implements Serializable,
MIBConstants {
    String extensionNames = "mib,txt,my";
    boolean extFlag = false;
    String[] extensionName = null;
    boolean throwFileNotFound = false;
    Vector userLabel = null;
    static boolean errMsg = false;
    static Hashtable equivName = new Hashtable();
    MibNode[] starters = new MibNode[3];
    boolean serializeMibs = false;
    boolean loadFromSerializedMibs = false;
    String sfName = "";
    String serializedFileName = "";
    ImportResolver resolver;
    boolean justParse = true;
    boolean overWrite = false;
    boolean overWriteCMI = false;
    boolean isLoadedFromApplURL = false;
    String mibFileName = null;
    String searchPath = null;
    static Vector standardNodes = null;
    static int[] oidNums = new int[]{3, 6, 1, 1, 2, 3, 4, 6, 1, 1, 1, 2, 3, 10};
    boolean calledFromMibModule = false;
    String mibFileDir = null;
    Applet applet = null;
    private boolean searching = false;
    private byte[] writerVer = new byte[2];
    static final byte[] readerVer;
    Hashtable modules = new Hashtable(5);
    public static final int ALL_MESSAGES = 0;
    public static final int WARNING_MESSAGES = 1;
    public static final int SERIOUS_MESSAGES = 2;
    public static final int CRITICAL_MESSAGES = 3;
    public static final byte MYSQL = 1;
    public static final byte ORACLE = 2;
    static int allowedLevel;
    boolean toBytes = false;
    private boolean ignoreSpecificControlCodes = true;
    boolean isDescRead = true;
    Hashtable globalImports = null;
    Hashtable genericTcList = new Hashtable(10);
    public static boolean jdbc;
    JdbcMibOperations jMibOps = null;
    public static Statement stmt;
    boolean database = false;
    public static boolean overWriteDataBase;
    byte dbType = 1;
    public String multipleRevision = "";
    Vector revisionFileNames = new Vector();
    Vector multipleRevisionModuleNames = new Vector();
    boolean showImportedIndex = false;
    static /* synthetic */ Class class$com$adventnet$snmp$snmp2$SnmpString;

    static {
        byte[] byArray = new byte[2];
        byArray[1] = 1;
        readerVer = byArray;
        allowedLevel = 2;
        jdbc = false;
        stmt = null;
        overWriteDataBase = false;
    }

    public MibOperations() {
        if (standardNodes == null) {
            MibOperations.stdNodes();
        }
        MibOperations.initialiseEquivname();
        this.initialiseRoots();
        this.initialiseSyntaxes();
        this.resolver = new ImportResolver(this);
    }

    public void addLabel(String string) {
        if (this.userLabel != null) {
            this.userLabel.addElement(string);
        } else {
            this.userLabel = new Vector();
            this.userLabel.addElement(string);
        }
    }

    void changeModuleName() {
        Vector vector = jdbc ? this.jMibOps.getMultipleRevisionModuleNames() : this.getMultipleRevisionModuleNames();
        Enumeration enumeration = this.getMibModuleNames();
        String string = "";
        String string2 = "";
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!vector.contains(string)) continue;
            string2 = String.valueOf(string) + "!##$##!";
            if (jdbc) {
                this.jMibOps.updateModuleRevisionName(string, string2);
                this.jMibOps.moduleVector.removeElement(string);
                this.jMibOps.moduleVector.addElement(string2);
                continue;
            }
            this.modules.put(string2, (MibModule)this.modules.get(string));
            this.modules.remove(string);
        }
    }

    boolean checkMultipleRevision(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        string = string.replace('\\', '/');
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(this.getMultipleRevision(), " |");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            if ((string2 = string2.replace('\\', '/')).startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (!string2.equals(string.trim()) || this.revisionFileNames.contains(string2)) continue;
            this.revisionFileNames.addElement(string2);
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void createCompiledMibs(String string) throws MibException, IOException, FileNotFoundException {
        if (string == null) {
            return;
        }
        if ((string = string.trim()).equals("")) {
            return;
        }
        String string2 = "\" \t\n\r|";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < n) {
            block17: {
                Object object;
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("\"")) {
                    try {
                        string3 = "";
                        object = stringTokenizer.nextToken();
                        ++n2;
                        if (((String)object).equals("\"")) break block17;
                        do {
                            string3 = String.valueOf(string3) + (String)object;
                            object = stringTokenizer.nextToken();
                            ++n2;
                        } while (!((String)object).equals("\""));
                    }
                    catch (Exception exception) {
                        this.globalImports = null;
                        throw new FileNotFoundException(String.valueOf(SnmpUtils.getString("Error parsing quoted filename :")) + " " + exception);
                    }
                }
                if (string2.indexOf(string3) < 0) {
                    try {
                        if (string3.endsWith("\\") || string3.endsWith("/")) {
                            string3 = string3.substring(0, string3.length() - 1);
                        }
                        if (((File)(object = new File(string3))).isDirectory()) {
                            String string4 = ((File)object).getPath();
                            String[] stringArray = ((File)object).list();
                            int n3 = 0;
                            while (n3 < stringArray.length) {
                                String string5 = String.valueOf(string4) + "/" + stringArray[n3];
                                if (!(string5.endsWith(".cmi") || string5.endsWith(".CMI") || string5.endsWith(".cds") || string5.endsWith(".CDS"))) {
                                    MIBParser.parseMibModule(string5, this.userLabel, true);
                                }
                                ++n3;
                            }
                        } else {
                            if (string3.endsWith(".cmi") || string3.endsWith(".CMI")) {
                                throw new MibException(SnmpUtils.getString("cmi file cannot be compiled"));
                            }
                            if (string3.endsWith(".cds") || string3.endsWith(".CDS")) {
                                throw new MibException(SnmpUtils.getString("cds file cannot be compiled"));
                            }
                            MIBParser.parseMibModule(string3, this.userLabel, true);
                        }
                    }
                    catch (ParseException parseException) {
                        this.globalImports = null;
                        throw new MibException(parseException.getMessage());
                    }
                }
            }
            ++n2;
        }
    }

    public SnmpVarBind createVariableBinding(String string, String[] stringArray, String string2) throws IllegalArgumentException, SnmpException {
        Serializable serializable;
        MibNode mibNode = null;
        if (!Character.isDigit(string.charAt(0)) && !Character.isDigit(string.charAt(1))) {
            mibNode = this.getMibNode(string);
        } else {
            serializable = new SnmpOID(string);
            mibNode = this.getMibNode((SnmpOID)serializable);
        }
        if (mibNode == null) {
            throw new IllegalArgumentException(String.valueOf(SnmpUtils.getString("MIB not loaded or not a valid OID.  Cannot find MIB node. OID:")) + " " + string);
        }
        serializable = mibNode.getIndexes(this);
        if (mibNode.getSyntax() == null) {
            throw new IllegalArgumentException(String.valueOf(SnmpUtils.getString("Not a leaf node. OID:")) + " " + string);
        }
        Vector<SnmpVar> vector = new Vector<SnmpVar>();
        if (serializable != null) {
            if (stringArray == null || stringArray.length != ((Vector)serializable).size()) {
                throw new IllegalArgumentException(String.valueOf(SnmpUtils.getString("Incorrect number of Index values. OID:")) + " " + string);
            }
            int n = 0;
            while (n < stringArray.length) {
                MibNode mibNode2 = (MibNode)((Vector)serializable).elementAt(n);
                SnmpVar snmpVar = mibNode2.getSyntax().createVariable(stringArray[n]);
                vector.addElement(snmpVar);
                ++n;
            }
        } else if (mibNode.isScalar()) {
            SnmpOID snmpOID = new SnmpOID(String.valueOf(mibNode.getNumberedOIDString()) + ".0");
            SnmpVar snmpVar = mibNode.getSyntax().createVariable(string2);
            return new SnmpVarBind(snmpOID, snmpVar);
        }
        SnmpVar snmpVar = null;
        if (string2 != null) {
            snmpVar = mibNode.getSyntax().createVariable(string2);
        }
        return mibNode.createSnmpVarBind(vector, snmpVar, (Vector)serializable);
    }

    void debugPrint(String string) {
        if (errMsg) {
            MibOperations.debugPrint(string, 0);
        }
    }

    static void debugPrint(String string, int n) {
        if (n >= allowedLevel && errMsg) {
            System.out.println(string);
        }
    }

    void deregisterImport(String string, MibModule mibModule) {
        Vector vector = (Vector)this.globalImports.get(string);
        vector.removeElement(mibModule);
        if (vector.size() == 0) {
            this.globalImports.remove(string);
        }
    }

    private MibModule deserialize(InputStream inputStream) throws MibException {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            MibModule mibModule = (MibModule)objectInputStream.readObject();
            Enumeration enumeration = mibModule.mibOps.modules.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (this.modules.containsKey(string)) continue;
                this.modules.put(string, mibModule.mibOps.modules.get(string));
            }
            return mibModule;
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw new MibException(String.valueOf(SnmpUtils.getString("Stream Corrupted")) + " ");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MibException(String.valueOf(SnmpUtils.getString("Class Not found")) + " ");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MibException(SnmpUtils.getString("File not found"));
        }
        catch (Exception exception) {
            throw new MibException(exception.toString());
        }
    }

    public String encodeInstanceString(Vector vector, Vector vector2) throws NumberFormatException {
        Object object;
        int[] nArray = new int[127];
        Object var4_4 = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        byte by = 0;
        String string2 = null;
        if (vector.size() == 0) {
            return null;
        }
        int n3 = vector2.size();
        int n4 = 0;
        while (n4 < n3) {
            string2 = (String)vector.elementAt(n4);
            object = (MibNode)vector2.elementAt(n4);
            by = ((MibNode)object).getSyntax().getType();
            string = ((MibNode)object).getImpliedNode();
            if (string == null) {
                string = "";
            }
            if (((MibNode)object).getParent().isImplied() && string.equals(((MibNode)object).getLabel())) {
                bl2 = true;
            }
            if (by != 4 && by != 64 && by != 64 && by != 6) {
                nArray[n++] = new Long(string2).intValue();
            } else {
                if (by == 64) {
                    nArray[n++] = 1;
                    bl2 = true;
                }
                if (by == 64 || by == 64 || by == 6) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
                    n2 = stringTokenizer.countTokens();
                    if (!bl2) {
                        nArray[n++] = n2;
                    }
                    int n5 = 0;
                    while (n5 < n2) {
                        nArray[n++] = new Long(stringTokenizer.nextToken()).intValue();
                        ++n5;
                    }
                }
                if (by == 4) {
                    int n6 = 0;
                    byte[] byArray = string2.getBytes();
                    int n7 = byArray.length;
                    if (!bl2) {
                        nArray[n++] = n7;
                    }
                    int n8 = 0;
                    while (n8 < n7) {
                        nArray[n++] = byArray[n6++] & 0xFF;
                        ++n8;
                    }
                }
            }
            ++n4;
        }
        object = "";
        int n9 = 0;
        while (n9 < n) {
            object = String.valueOf(object) + new Integer(nArray[n9]).toString() + ".";
            ++n9;
        }
        return ((String)object).substring(0, ((String)object).length() - 1);
    }

    private boolean findCorrectNode(MibNode mibNode, Vector vector, int n) {
        MibNode mibNode2 = mibNode.getParent();
        if (vector != null && !mibNode.getLabel().equals("iso") && !mibNode.getLabel().equals("ccitt")) {
            int n2 = n - 1;
            while (n2 >= 0) {
                if (!mibNode2.getLabel().equals((String)vector.elementAt(n2))) {
                    return true;
                }
                mibNode2 = mibNode2.getParent();
                --n2;
            }
        }
        return false;
    }

    String findFile(String string) {
        int n;
        if (string == null || string.equals("")) {
            return "";
        }
        if ((string = string.replace('\\', '/')).startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if ((n = string.lastIndexOf("/")) != -1) {
            string = string.substring(n + 1, string.length());
        }
        String string2 = "";
        String string3 = "";
        if (this.searchPath != null) {
            this.searchPath = "./|" + this.searchPath;
            StringTokenizer stringTokenizer = new StringTokenizer(this.searchPath, "|");
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                string3 = string3.trim().replace('\\', '/');
                int n2 = 0;
                while (n2 < this.extensionName.length) {
                    try {
                        string2 = String.valueOf(string3) + "/" + string + this.extensionName[n2];
                        this.getmodulenamedefinition(string2);
                        return string2;
                    }
                    catch (Exception exception) {
                        try {
                            string2 = String.valueOf(string3) + "/" + string.toLowerCase() + this.extensionName[n2];
                            this.getmodulenamedefinition(string2);
                            return string2;
                        }
                        catch (Exception exception2) {
                            ++n2;
                        }
                    }
                }
            }
        }
        return "";
    }

    String findFileName(String string) {
        String string2 = null;
        String string3 = null;
        if (string == null || string.equals("")) {
            return null;
        }
        string2 = this.findFileNameFromSearchPath(string = string.replace('\\', '/'));
        if (string2 == null && this.searchPath != null) {
            this.searchPath = "./|" + this.searchPath;
            StringTokenizer stringTokenizer = new StringTokenizer(this.searchPath, "|");
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken().trim();
                string3.replace('\\', '/');
                if (!string3.endsWith("/")) {
                    string3 = String.valueOf(string3) + "/";
                }
                if (string.startsWith("./")) {
                    string = string.substring(2);
                }
                if ((string2 = this.findFileNameFromSearchPath(String.valueOf(string3) + string)) == null) continue;
                return string2;
            }
        }
        return string2;
    }

    String findFileNameFromSearchPath(String string) {
        block7: {
            String string2 = " ";
            try {
                int n = string.lastIndexOf("/");
                string2 = n != -1 ? string.substring(0, n) : ".";
                String string3 = string.substring(n + 1, string.length());
                File file = new File(string2);
                if (!file.isDirectory()) break block7;
                String string4 = null;
                String string5 = file.getPath();
                String[] stringArray = file.list();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    int n3;
                    File file2;
                    String string6 = stringArray[n2];
                    if (!string6.endsWith(".cmi") && !string6.endsWith(".cds") && string6.toUpperCase().startsWith(string3.toUpperCase()) && !(file2 = new File(String.valueOf(string5) + "/" + string6)).isDirectory() && ((string4 = (n3 = string6.indexOf(".")) != -1 ? string6.substring(0, n3) : string6).equals(string3) || string4.toUpperCase().equals(string3))) {
                        String string7 = String.valueOf(string5) + "/" + string6;
                        try {
                            if (this.getModuleNameDefinition(string7) != null) {
                                return string7;
                            }
                        }
                        catch (Exception exception) {}
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public byte getDatabaseName() {
        return this.dbType;
    }

    public String getErrorString(SnmpPDU snmpPDU) {
        StringBuffer stringBuffer = new StringBuffer();
        if (snmpPDU.getErrstat() != 0) {
            stringBuffer.append("Error Status: " + SnmpException.exceptionString((byte)snmpPDU.getErrstat()) + "\n");
            stringBuffer.append("Error Index: " + snmpPDU.getErrindex() + "\n");
            if (snmpPDU.getErrindex() > 0) {
                stringBuffer.append(String.valueOf(SnmpUtils.getString("Errored Object ID:")) + " " + this.toString(snmpPDU.getObjectID(snmpPDU.getErrindex() - 1)) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public boolean getIgnoreSpecificControlCodes() {
        return this.ignoreSpecificControlCodes;
    }

    public String getInstanceString(SnmpOID snmpOID) {
        MibNode mibNode = this.getMibNode(snmpOID);
        if (mibNode == null) {
            return null;
        }
        return this.getInstanceString(snmpOID, mibNode);
    }

    public String getInstanceString(SnmpOID snmpOID, MibNode mibNode) {
        if (mibNode == null) {
            return null;
        }
        String string = mibNode.getNumberedOIDString();
        String string2 = snmpOID.toString();
        if (string2.length() < string.length()) {
            return null;
        }
        return string2.substring(string.length());
    }

    public LeafSyntax getLeafSyntax(SnmpOID snmpOID) {
        MibNode mibNode = this.getMibNode(snmpOID);
        if (mibNode != null) {
            return mibNode.getSyntax();
        }
        return null;
    }

    public MibModule getMibModule(MibNode mibNode) {
        if (mibNode == null) {
            return null;
        }
        if (jdbc) {
            return this.jMibOps.getMibModule(mibNode.getModuleName());
        }
        return this.getMibModule(mibNode.getModuleName());
    }

    public MibModule getMibModule(String string) {
        if (jdbc) {
            return this.jMibOps.getMibModule(string);
        }
        if (string == null) {
            return null;
        }
        MibModule mibModule = (MibModule)this.modules.get(string);
        if (mibModule != null && mibModule.isResolved()) {
            return mibModule;
        }
        return null;
    }

    public Enumeration getMibModuleNames() {
        if (jdbc) {
            return this.jMibOps.getMibModuleNames();
        }
        return this.modules.keys();
    }

    public Enumeration getMibModules() {
        if (jdbc) {
            return this.jMibOps.getMibModules();
        }
        return this.modules.elements();
    }

    Vector getMibModules(MibNode mibNode) {
        if (jdbc) {
            return this.jMibOps.getMibModules(mibNode);
        }
        MibModule mibModule = this.getMibModule(mibNode);
        return new Vector();
    }

    public MibNode getMibNode(SnmpOID snmpOID) {
        if (snmpOID == null) {
            return null;
        }
        if (jdbc) {
            return this.jMibOps.getMibNode(snmpOID);
        }
        MibNode mibNode = null;
        MibNode mibNode2 = null;
        int n = 0;
        int[] nArray = (int[])snmpOID.toValue();
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            mibNode = ((MibModule)enumeration.nextElement()).getMibNode(nArray);
            if (mibNode == null || mibNode == null) continue;
            int n2 = mibNode.getOID().length;
            if (n2 < nArray.length) {
                if (mibNode.syntax == null) {
                    if (n2 > n) {
                        mibNode2 = mibNode;
                        n = n2;
                    }
                    mibNode = null;
                    continue;
                }
                mibNode2 = mibNode;
                break;
            }
            mibNode2 = mibNode;
            break;
        }
        mibNode = mibNode2;
        return mibNode2;
    }

    public MibNode getMibNode(String string) {
        if (string == null) {
            return null;
        }
        if (jdbc) {
            return this.jMibOps.getMibNode(string);
        }
        MibNode mibNode = this.getMibNode(string, null, 0);
        if (mibNode != null) {
            return mibNode;
        }
        return mibNode;
    }

    public MibNode getMibNode(String string, String string2) {
        MibModule mibModule = this.getMibModule(string2);
        if (mibModule != null) {
            return mibModule.getMibNodeByName(string);
        }
        return null;
    }

    private MibNode getMibNode(String string, Vector vector, int n) {
        if (string == null) {
            return null;
        }
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            MibNode mibNode;
            MibModule mibModule = (MibModule)enumeration.nextElement();
            if (errMsg) {
                System.err.println(String.valueOf(SnmpUtils.getString("Searching in module")) + " " + mibModule.getName() + " " + SnmpUtils.getString("for") + " " + string);
            }
            if ((mibNode = (MibNode)mibModule.nodeList.get(string)) == null || this.findCorrectNode(mibNode, vector, n)) continue;
            if (errMsg) {
                System.err.println(String.valueOf(SnmpUtils.getString("Found node")) + " " + mibNode.toTagString());
            }
            return mibNode;
        }
        if (errMsg) {
            System.err.println(SnmpUtils.getString("Couldn't find it"));
        }
        return null;
    }

    public MibNode getMibNode(Vector vector) {
        if (vector == null) {
            return null;
        }
        if (jdbc) {
            return this.jMibOps.getMibNode(vector);
        }
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            MibNode mibNode = mibModule.getMibNode(vector);
            if (mibNode == null) continue;
            return mibNode;
        }
        return null;
    }

    public String getMibPath() {
        return this.searchPath;
    }

    public MibTrap getMibTrap(SnmpOID snmpOID, int n, int n2) {
        if (jdbc) {
            return this.jMibOps.getMibTrap(snmpOID, n, n2);
        }
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            Enumeration enumeration2 = mibModule.trapList.elements();
            while (enumeration2.hasMoreElements()) {
                MibTrap mibTrap = (MibTrap)enumeration2.nextElement();
                if (snmpOID == null) continue;
                if (snmpOID.toString().equals(new SnmpOID("11").toString()) && mibTrap.getEnterprise().toString().equals(".1.3.6.1.2.1.11") && mibTrap.getValue() == n) {
                    return mibTrap;
                }
                if (!snmpOID.toString().equals(mibTrap.getEnterprise().toString()) || mibTrap.getEnterprise().toString().equals(".1.3.6.1.2.1.11") || n != 6 || n2 != mibTrap.getValue()) continue;
                return mibTrap;
            }
        }
        return null;
    }

    MibModule getModuleFromGlobalImports(String string) {
        if (this.globalImports != null) {
            Enumeration enumeration = this.globalImports.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2.equals(string)) continue;
                Vector vector = (Vector)this.globalImports.get(string2);
                int n = 0;
                while (n < vector.size()) {
                    MibModule mibModule = (MibModule)vector.elementAt(n);
                    if (mibModule.getName().equals(string)) {
                        return mibModule;
                    }
                    ++n;
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getModuleNameDefinition(String string) throws MibException, IOException, FileNotFoundException {
        Object object;
        int n;
        if (string == null) return null;
        if (string.equals("")) {
            return null;
        }
        boolean bl = false;
        string = string.replace('\\', '/');
        if (jdbc && !overWriteDataBase && string.indexOf("/") == -1 && string.indexOf("\\") == -1 && string.indexOf(".") == -1) {
            return string;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        String string2 = new String(string);
        String string3 = new String(string);
        if (!string2.endsWith(".cmi")) {
            string2 = String.valueOf(string2) + ".cmi";
        }
        if ((n = string.lastIndexOf("/")) != -1) {
            string3 = string.substring(n + 1, string.length());
        }
        if ((n = string3.indexOf(".")) != -1) {
            string3 = string3.substring(0, n);
        }
        InputStream inputStream = null;
        HttpURLConnection httpURLConnection = null;
        URL uRL = null;
        if (string.indexOf("http://") >= 0) {
            if (!this.justParse && !this.overWriteCMI) {
                try {
                    uRL = new URL(string2);
                    if (uRL != null) {
                        return string3;
                    }
                }
                catch (Exception exception) {}
            }
            if ((uRL = new URL(string)).getProtocol().equalsIgnoreCase("http")) {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                if (!this.validateUrl(httpURLConnection)) throw new FileNotFoundException(string);
                inputStream = httpURLConnection.getInputStream();
            } else {
                inputStream = uRL.openStream();
            }
        } else {
            object = null;
            try {
                if (!this.justParse && !this.overWriteCMI) {
                    try {
                        object = this.getClass().getClassLoader().getResource(string2);
                        if (object != null) {
                            return string3;
                        }
                    }
                    catch (Exception exception) {}
                }
                object = this.getClass().getClassLoader().getResource(string);
            }
            catch (NullPointerException nullPointerException) {
                if (!this.justParse && !this.overWriteCMI) {
                    try {
                        object = ClassLoader.getSystemResource(string2);
                        if (object != null) {
                            return string3;
                        }
                    }
                    catch (Exception exception) {}
                }
                object = ClassLoader.getSystemResource(string);
            }
            if (object != null) {
                inputStream = ((URL)object).openStream();
            }
            if (inputStream == null) {
                try {
                    if (!this.justParse && !this.overWriteCMI) {
                        try {
                            inputStream = new FileInputStream(string2);
                            return string3;
                        }
                        catch (Exception exception) {}
                    }
                    inputStream = new FileInputStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new FileNotFoundException(string);
                }
            }
        }
        object = null;
        if (string.endsWith(".cmi") || string.endsWith(".CMI")) {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            if (!this.isVersionOk(dataInputStream, null)) {
                return null;
            }
            object = this.readInitialisers(dataInputStream);
            dataInputStream.close();
            return object;
        }
        if (string.endsWith(".cds")) return null;
        if (string.endsWith(".CDS")) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string4 = null;
        String string5 = "";
        boolean bl2 = false;
        while ((string4 = bufferedReader.readLine()) != null) {
            if ((string4 = string4.trim()).equals("") || string4.startsWith("--")) continue;
            string5 = String.valueOf(string5) + string4 + " ";
            if (string4.indexOf("DEFINITIONS") == -1) continue;
            bl = true;
            break;
        }
        bufferedReader.close();
        StringTokenizer stringTokenizer = new StringTokenizer(string5, " ,\t\r\n\f");
        if (!stringTokenizer.hasMoreTokens()) return null;
        if (!bl) return null;
        return stringTokenizer.nextToken();
    }

    private String getModuleNameFromPath(String string) {
        String string2 = null;
        string = string.replace('\\', '/');
        int n = string.lastIndexOf("/");
        int n2 = string.indexOf(".cmi");
        if (n2 == -1) {
            n2 = string.indexOf(".CMI");
        }
        string2 = n != -1 ? (n2 != -1 ? string.substring(++n, n2) : string.substring(++n)) : (n2 != -1 ? string.substring(0, n2) : string);
        if (string2 != null && (string2 = string2.trim()).endsWith("\"")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public int getModuleSize() {
        if (jdbc) {
            return this.jMibOps.getModuleSize();
        }
        return this.modules.size();
    }

    public String getMultipleRevision() {
        if (jdbc) {
            return this.jMibOps.getMultipleRevision();
        }
        return this.multipleRevision;
    }

    Vector getMultipleRevisionModuleNames() {
        if (this.multipleRevisionModuleNames.size() > 0) {
            return this.multipleRevisionModuleNames;
        }
        String string = this.getMultipleRevision();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " |");
        String string2 = "";
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            try {
                string3 = this.getModuleNameDefinition(string2);
                this.multipleRevisionModuleNames.addElement(string3);
            }
            catch (Exception exception) {}
        }
        return this.multipleRevisionModuleNames;
    }

    public MibNode getNearestNode(SnmpOID snmpOID) {
        if (jdbc) {
            return this.jMibOps.getNearestNode(snmpOID);
        }
        MibNode mibNode = null;
        int n = 0;
        MibNode mibNode2 = null;
        int[] nArray = (int[])snmpOID.toValue();
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            mibNode2 = ((MibModule)enumeration.nextElement()).getNearestNode(nArray);
            if (mibNode2 == null || mibNode2 == null) continue;
            int n2 = mibNode2.getOID().length;
            if (n2 < nArray.length) {
                if (mibNode2.syntax == null) {
                    if (n2 > n) {
                        mibNode = mibNode2;
                        n = n2;
                    }
                    mibNode2 = null;
                    continue;
                }
                mibNode = mibNode2;
                break;
            }
            mibNode = mibNode2;
            break;
        }
        mibNode2 = mibNode;
        return mibNode;
    }

    public Vector getNodesFromNames(Vector vector) {
        Vector<MibNode> vector2 = new Vector<MibNode>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.startsWith("IMPLIED")) {
                string = string.substring(7);
            }
            string = string.trim();
            MibNode mibNode = this.getMibNode(string);
            vector2.addElement(mibNode);
        }
        return vector2;
    }

    public Vector getNodesFromString(String string) {
        if (string == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,\n\r\t");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return this.getNodesFromNames(vector);
    }

    SnmpOID getNumericOID(String string) {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        SnmpOID snmpOID = new SnmpOID(string);
        if (snmpOID.toValue() == null) {
            return null;
        }
        return snmpOID;
    }

    public boolean getOverwriteCMI() {
        return this.overWrite;
    }

    MibModule getRevisionModule(MibModule mibModule) {
        if (this.checkMultipleRevision(mibModule.filename)) {
            this.modules.remove(mibModule.name);
            String string = this.getRevisionModuleName(mibModule.name);
            if (string != null) {
                mibModule.name = string;
                this.modules.put(string, mibModule);
                Enumeration enumeration = mibModule.nodeList.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    MibNode mibNode = (MibNode)mibModule.nodeList.get(string2);
                    mibNode.moduleName = string;
                    mibModule.nodeList.put(string2, mibNode);
                }
            }
        } else if (this.revisionFileNames.contains(mibModule.filename)) {
            this.modules.remove(mibModule.getName());
        }
        this.revertBack();
        return mibModule;
    }

    String getRevisionModuleName(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        Enumeration enumeration = this.getMibModuleNames();
        String string2 = "";
        int n = 0;
        String string3 = "";
        int n2 = 0;
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            n = string2.lastIndexOf("-");
            if (n != -1) {
                string3 = string2.substring(n + 1, string2.length());
            }
            if ((string2 = string2.substring(0, string2.lastIndexOf("-") + 1)).indexOf(string) == -1 || !string2.endsWith("-REVISION-")) continue;
            try {
                if (string3.equals("") || (n2 = Integer.parseInt(string3)) <= n3) continue;
                n3 = n2;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String string4 = String.valueOf(string) + "-REVISION-" + ++n3;
        return string4;
    }

    public String getSerializedMibFileName() {
        return this.sfName;
    }

    public SnmpOID getSnmpOID(String string) {
        Object object;
        if (string == null || string.equals("")) {
            return null;
        }
        if (jdbc) {
            return this.jMibOps.getSnmpOID(string);
        }
        Vector vector = null;
        int n = 0;
        MibNode mibNode = null;
        int[] nArray = null;
        vector = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        if (!Character.isDigit(((String)vector.firstElement()).charAt(0)) && (mibNode = this.getMibNode((String)(object = (String)vector.firstElement()), vector, n)) != null) {
            Object object2;
            if (mibNode.syntax == null && vector.size() > 1) {
                while (++n < vector.size()) {
                    MibNode mibNode2;
                    object2 = (String)vector.elementAt(n);
                    if (!Character.isDigit(((String)object2).charAt(0)) && (mibNode2 = this.getMibNode((String)object2, vector, n)) != null) {
                        mibNode = mibNode2;
                        continue;
                    }
                    break;
                }
            } else {
                n = 1;
            }
            object2 = mibNode.getOIDVector();
            int n2 = n;
            while (n2 < vector.size()) {
                ((Vector)object2).addElement((String)vector.elementAt(n2));
                ++n2;
            }
            vector = object2;
        }
        if (mibNode == null) {
            vector = this.toVector(string);
            object = this.modules.elements();
            while (object.hasMoreElements()) {
                mibNode = ((MibModule)object.nextElement()).getMibNode(vector);
                if (mibNode == null) continue;
                int n3 = mibNode.getOID().length;
                if (n3 >= vector.size()) break;
                try {
                    if (Character.isDigit(((String)vector.elementAt(n3)).charAt(0))) break;
                    mibNode = null;
                }
                catch (Exception exception) {
                    System.out.println(String.valueOf(SnmpUtils.getString("Exception:")) + exception);
                }
            }
        }
        if (mibNode == null) {
            return this.getNumericOID(string);
        }
        object = null;
        long l = 0L;
        int[] nArray2 = mibNode.getOID();
        nArray = new int[vector.size()];
        System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
        int n4 = nArray2.length;
        while (n4 < nArray.length) {
            try {
                object = (String)vector.elementAt(n4);
                nArray[n4] = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    l = new Long((String)object);
                    if (l <= 0xFFFFFFFFL) {
                        nArray[n4] = (int)(l & 0xFFFFFFFFL);
                    }
                    System.err.println(String.valueOf(SnmpUtils.getString("subID value should be less than 4294967295:")) + " " + string);
                    return null;
                }
                catch (NumberFormatException numberFormatException2) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Invalid OID format:")) + " " + string);
                    return null;
                }
            }
            ++n4;
        }
        return new SnmpOID(nArray);
    }

    MibNode getStarterNode(int n) {
        if (n > 2 || n < 0) {
            return null;
        }
        return this.starters[n];
    }

    MibNode getStarterNode(String string) {
        if (string.equals("iso")) {
            return this.starters[1];
        }
        if (string.equals("ccitt")) {
            return this.starters[0];
        }
        if (string.equals("joint-iso-ccitt")) {
            return this.starters[2];
        }
        return null;
    }

    private String getString(SnmpString snmpString, boolean bl) {
        if (this.toBytes) {
            return snmpString.toByteString();
        }
        boolean bl2 = true;
        byte[] byArray = snmpString.toBytes();
        if (bl) {
            return snmpString.toByteString();
        }
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!(byArray[n2] >= 32 && byArray[n2] < 127 || (byArray[n2] == 10 || byArray[n2] == 9 || byArray[n2] == 13) && this.ignoreSpecificControlCodes)) {
                bl2 = false;
                break;
            }
            ++n2;
        }
        if (bl2) {
            return snmpString.toString();
        }
        return snmpString.toByteString();
    }

    public LeafSyntax getSyntaxByName(String string) {
        if (jdbc) {
            return this.jMibOps.getSyntaxByName(string);
        }
        LeafSyntax leafSyntax = (LeafSyntax)this.genericTcList.get(string);
        if (leafSyntax != null) {
            return leafSyntax;
        }
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            LeafSyntax leafSyntax2 = (LeafSyntax)mibModule.tcList.get(string);
            if (leafSyntax2 == null) continue;
            return leafSyntax2;
        }
        return null;
    }

    public boolean getThrowFileNotFound() {
        return this.throwFileNotFound;
    }

    private String getVarString(SnmpVar snmpVar, boolean bl) {
        if (snmpVar.getClass() == (class$com$adventnet$snmp$snmp2$SnmpString != null ? class$com$adventnet$snmp$snmp2$SnmpString : (class$com$adventnet$snmp$snmp2$SnmpString = MibOperations.class$("com.adventnet.snmp.snmp2.SnmpString")))) {
            return this.getString((SnmpString)snmpVar, bl);
        }
        return snmpVar.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void getmodulenamedefinition(String string) throws MibException, IOException, FileNotFoundException {
        Object object;
        if (string == null || string.equals("")) {
            throw new IOException();
        }
        string = string.replace('\\', '/');
        InputStream inputStream = null;
        HttpURLConnection httpURLConnection = null;
        URL uRL = null;
        if (string.indexOf("http://") >= 0) {
            uRL = new URL(string);
            if (uRL.getProtocol().equalsIgnoreCase("http")) {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                if (!this.validateUrl(httpURLConnection)) throw new FileNotFoundException(string);
                inputStream = httpURLConnection.getInputStream();
            } else {
                inputStream = uRL.openStream();
            }
        } else {
            object = null;
            try {
                object = this.getClass().getClassLoader().getResource(string);
            }
            catch (NullPointerException nullPointerException) {
                object = ClassLoader.getSystemResource(string);
            }
            if (object != null) {
                inputStream = ((URL)object).openStream();
            }
            if (inputStream == null) {
                try {
                    inputStream = new FileInputStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new FileNotFoundException(string);
                }
            }
        }
        if (!string.endsWith(".cmi") && !string.endsWith(".CMI")) return;
        object = new DataInputStream(inputStream);
    }

    public void initJdbcParams(String string, String string2, String string3, String string4) throws MibException {
        this.jMibOps = new JdbcMibOperations(string, string2, string3, string4, this);
        stmt = this.jMibOps.stmt;
        if (this.isMultipleRevision()) {
            this.jMibOps.setMultipleRevision(this.getMultipleRevision());
        }
    }

    static void initialiseEquivname() {
        equivName.put(new Byte(2), "INTEGER");
        equivName.put(new Byte(6), "OBJECT IDENTIFIER");
        equivName.put(new Byte(64), "NetworkAddress");
        equivName.put(new Byte(67), "TimeTicks");
        equivName.put(new Byte(66), "Gauge");
        equivName.put(new Byte(65), "Counter");
        equivName.put(new Byte(4), "OCTET STRING");
    }

    private void initialiseRoots() {
        MibNode mibNode = new MibNode();
        mibNode.subid = 0;
        mibNode.label = "ccitt";
        int[] nArray = new int[1];
        mibNode.oid_array = nArray;
        mibNode.oid_string = ".ccitt";
        this.starters[0] = mibNode;
        mibNode = new MibNode();
        mibNode.subid = 1;
        mibNode.label = "iso";
        int[] nArray2 = new int[]{1};
        mibNode.oid_array = nArray2;
        mibNode.oid_string = ".iso";
        this.starters[1] = mibNode;
        mibNode = new MibNode();
        mibNode.subid = 2;
        mibNode.label = "joint-iso-ccitt";
        int[] nArray3 = new int[]{2};
        mibNode.oid_array = nArray3;
        mibNode.oid_string = ".joint-iso-ccitt";
        this.starters[2] = mibNode;
    }

    void initialiseSyntaxes() {
        LeafSyntax leafSyntax;
        RangeList rangeList = new RangeList(1, false);
        rangeList.preDefinedRange = true;
        rangeList.addRange(Integer.MAX_VALUE, Integer.MIN_VALUE);
        RangeList rangeList2 = new RangeList(1, false);
        rangeList2.addRange(0xFFFFFFFFL, 0L);
        rangeList2.preDefinedRange = true;
        LeafSyntax leafSyntax2 = new LeafSyntax(64, MIBConstants.numericStr[0], rangeList);
        this.genericTcList.put(leafSyntax2.getName(), leafSyntax2);
        leafSyntax2 = new LeafSyntax(67, MIBConstants.numericStr[3], rangeList2);
        this.genericTcList.put(leafSyntax2.getName(), leafSyntax2);
        leafSyntax2 = new LeafSyntax(69, MIBConstants.numericStr[5], rangeList2);
        this.genericTcList.put(leafSyntax2.getName(), leafSyntax2);
        leafSyntax2 = new LeafSyntax(71, MIBConstants.numericStr[7], rangeList2);
        this.genericTcList.put(leafSyntax2.getName(), leafSyntax2);
        int n = 0;
        while (n < 4) {
            leafSyntax = new LeafSyntax(n | 0x60, MIBConstants.alphaStr[n], null);
            this.genericTcList.put(leafSyntax.getName(), leafSyntax);
            ++n;
        }
        leafSyntax = new LeafSyntax(1, "OBJECT IDENTIFIER", null);
        this.genericTcList.put(leafSyntax.getName(), leafSyntax);
        LeafSyntax leafSyntax3 = new LeafSyntax(101, "NULL", null);
        this.genericTcList.put(leafSyntax3.getName(), leafSyntax3);
    }

    public boolean isLoadFromCompiledMibs() {
        return this.justParse ^ true;
    }

    public boolean isLoadFromDatabase() {
        return this.database;
    }

    public boolean isLoadFromSerializedMibs() {
        return this.loadFromSerializedMibs;
    }

    public boolean isMultipleRevision() {
        return this.getMultipleRevision().equals("") ^ true;
    }

    public boolean isOverwriteDatabase() {
        return overWriteDataBase;
    }

    public boolean isReadDesc() {
        return this.isDescRead;
    }

    public boolean isSerializeMibs() {
        return this.serializeMibs;
    }

    public boolean isShowImportedIndex() {
        return this.showImportedIndex;
    }

    boolean isStarterNode(MibNode mibNode) {
        return mibNode.getLabel().equals(this.starters[0].getLabel()) || mibNode.getLabel().equals(this.starters[1].getLabel()) || mibNode.getLabel().equals(this.starters[2].getLabel());
    }

    boolean isVersionOk(DataInputStream dataInputStream, DataInputStream dataInputStream2) throws IOException {
        dataInputStream.read(this.writerVer);
        if (this.writerVer[0] != readerVer[0] || this.writerVer[1] != readerVer[1]) {
            this.debugPrint(String.valueOf(SnmpUtils.getString("Writer version :")) + this.writerVer[0] + "." + this.writerVer[1]);
            this.debugPrint(String.valueOf(SnmpUtils.getString("Reader version :")) + readerVer[0] + "." + readerVer[1]);
            this.debugPrint(SnmpUtils.getString("Writer version doesn't match reader version \nContinuing anyway..."));
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    synchronized void loadMibModule(Applet var1_1, String var2_2) throws MibException, IOException, FileNotFoundException {
        block193: {
            block189: {
                block190: {
                    block191: {
                        if (var2_2 == null) {
                            return;
                        }
                        if (MibOperations.jdbc) {
                            this.jMibOps.tableHash.clear();
                        }
                        var3_3 = null;
                        var4_4 = null;
                        var5_5 = null;
                        var6_6 = null;
                        var7_7 = null;
                        var8_8 = null;
                        var9_9 = true;
                        if (var2_2.endsWith("@*$#&")) {
                            var2_2 = var2_2.substring(0, var2_2.length() - 5);
                        } else if (var2_2.endsWith("&#$*@")) {
                            var2_2 = var2_2.substring(0, var2_2.length() - 5);
                            var7_7 = this.getModuleNameFromPath(var2_2);
                        } else {
                            this.globalImports = new Hashtable<K, V>(1);
                        }
                        this.mibFileName = var2_2 = var2_2.replace('\\', '/');
                        var10_10 = var2_2.endsWith(".cmi") != false || var2_2.endsWith(".CMI") != false;
                        var11_11 = false;
                        var12_12 = null;
                        var13_13 = null;
                        var14_14 = null;
                        this.setExtensionName();
                        if (this.isMultipleRevision()) {
                            this.changeModuleName();
                        }
                        if (this.searchPath == null) break block191;
                        if (this.searchPath.indexOf("./|") < 0) {
                            this.searchPath = "./|" + this.searchPath;
                        }
                        this.searching = true;
                        var15_15 = null;
                        var16_26 = new StringTokenizer(this.searchPath, "|");
                        while (var16_26.hasMoreTokens()) {
                            try {
                                block187: {
                                    block188: {
                                        var15_15 = var16_26.nextToken();
                                        var15_15 = var15_15.replace('\\', '/');
                                        if (!var15_15.endsWith("/")) {
                                            var15_15 = String.valueOf(var15_15) + "/";
                                        }
                                        var15_15 = var15_15.trim();
                                        var15_15 = String.valueOf(var15_15) + var2_2;
                                        this.mibFileDir = var15_15.substring(0, var15_15.lastIndexOf("/") + 1);
                                        try {
                                            if (this.loadFromSerializedMibs) {
                                                var12_12 = new URL(var15_15);
                                                var5_5 = var12_12.openStream();
                                                this.deserialize(var5_5);
                                                var5_5.close();
                                                break block187;
                                            }
                                            if (this.justParse) {
                                                var17_35 = 0;
                                                while (var17_35 < this.extensionName.length) {
                                                    try {
                                                        var12_12 = new URL(String.valueOf(var15_15) + this.extensionName[var17_35]);
                                                        break;
                                                    }
                                                    catch (Exception v0) {
                                                        try {
                                                            var12_12 = new URL(String.valueOf(var15_15.toLowerCase()) + this.extensionName[var17_35]);
                                                            break;
                                                        }
                                                        catch (Exception v1) {
                                                            var12_12 = null;
                                                            ++var17_35;
                                                        }
                                                    }
                                                }
                                                if (var12_12 == null) {
                                                    throw new Exception();
                                                }
                                                if (MibOperations.jdbc) {
                                                    var18_52 = this.getModuleNameDefinition(var12_12.toString());
                                                    if (!MibOperations.overWriteDataBase && this.jMibOps.isExist((String)var18_52)) {
                                                        this.jMibOps.put((String)var18_52, var12_12.toString());
                                                        this.jMibOps.loadJdbcMibModules((String)var18_52);
                                                        MIBParser.reInitialize();
                                                        return;
                                                    }
                                                }
                                                var5_5 = var12_12.openStream();
                                                break block187;
                                            }
                                            try {
                                                var14_14 = var10_10 == false ? new URL(String.valueOf(var15_15) + ".cmi") : new URL(var15_15);
                                                var5_5 = var14_14.openStream();
                                            }
                                            catch (Exception v2) {
                                                var12_12 = new URL(var15_15);
                                                var5_5 = var12_12.openStream();
                                                var8_8 = this.getModuleNameDefinition(var12_12.toString());
                                                var14_14 = new URL(String.valueOf(var15_15.toString().substring(0, var15_15.lastIndexOf("/") + 1)) + var8_8 + ".cmi");
                                                var5_5 = var14_14.openStream();
                                                var9_9 = false;
                                            }
                                            if (this.isReadDesc()) {
                                                var17_36 = var14_14.toString();
                                                var17_36 = var17_36.substring(0, var17_36.length() - 3);
                                                var17_36 = String.valueOf(var17_36) + "cds";
                                                var13_13 = new URL(var17_36);
                                                var6_6 = var13_13.openStream();
                                            }
                                            break block187;
                                        }
                                        catch (Exception v3) {
                                            var11_11 = false;
                                            try {
                                                if (this.loadFromSerializedMibs) {
                                                    var12_12 = var1_1.getClass().getResource(var15_15);
                                                    var5_5 = var12_12.openStream();
                                                    this.deserialize(var5_5);
                                                    var5_5.close();
                                                } else if (this.justParse) {
                                                    var17_37 = 0;
                                                    while (var17_37 < this.extensionName.length) {
                                                        try {
                                                            var12_12 = var1_1.getClass().getResource(String.valueOf(var15_15) + this.extensionName[var17_37]);
                                                            if (var12_12 != null) break;
                                                            throw new Exception();
                                                        }
                                                        catch (Exception v4) {
                                                            try {
                                                                var12_12 = var1_1.getClass().getResource(String.valueOf(var15_15.toLowerCase()) + this.extensionName[var17_37]);
                                                                if (var12_12 != null) break;
                                                                throw new Exception();
                                                            }
                                                            catch (Exception v5) {
                                                                var12_12 = null;
                                                                ++var17_37;
                                                            }
                                                        }
                                                    }
                                                    if (var12_12 == null) {
                                                        throw new Exception();
                                                    }
                                                    if (MibOperations.jdbc) {
                                                        var18_52 = this.getModuleNameDefinition(var12_12.toString());
                                                        if (!MibOperations.overWriteDataBase && this.jMibOps.isExist((String)var18_52)) {
                                                            this.jMibOps.put((String)var18_52, var12_12.toString());
                                                            this.jMibOps.loadJdbcMibModules((String)var18_52);
                                                            MIBParser.reInitialize();
                                                            return;
                                                        }
                                                    }
                                                    var5_5 = var12_12.openStream();
                                                } else {
                                                    var14_14 = var10_10 == false ? var1_1.getClass().getResource(String.valueOf(var15_15) + ".cmi") : var1_1.getClass().getResource(var15_15);
                                                    if (var14_14 == null) {
                                                        var12_12 = var1_1.getClass().getResource(var15_15);
                                                        var4_4 = var12_12.openStream();
                                                        var8_8 = this.getModuleNameDefinition(var12_12.toString());
                                                        var14_14 = var1_1.getClass().getResource(String.valueOf(var15_15.toString().substring(0, var15_15.toString().lastIndexOf("/") + 1)) + var8_8 + ".cmi");
                                                        if (var14_14 != null) {
                                                            var9_9 = false;
                                                        }
                                                    }
                                                    var5_5 = var14_14.openStream();
                                                    if (this.isReadDesc()) {
                                                        var17_38 = var14_14.toString();
                                                        var17_38 = var17_38.substring(0, var17_38.length() - 3);
                                                        var17_38 = String.valueOf(var17_38) + "cds";
                                                        var13_13 = var1_1.getClass().getResource(var17_38);
                                                        var6_6 = var13_13.openStream();
                                                    }
                                                }
                                                if (var15_15.indexOf("/") == -1) {
                                                    this.mibFileDir = "";
                                                    var11_11 = true;
                                                }
                                                break block187;
                                            }
                                            catch (Exception v6) {
                                                var4_4 = null;
                                                var11_11 = false;
                                                try {
                                                    block192: {
                                                        var17_39 = null;
                                                        var17_39 = var2_2;
                                                        var18_52 = var1_1.getDocumentBase().getProtocol();
                                                        if (var18_52 != null && var18_52.equalsIgnoreCase("http") && !var15_15.startsWith("/")) {
                                                            var17_39 = "/" + var15_15;
                                                        }
                                                        if (this.loadFromSerializedMibs) {
                                                            var12_12 = new URL(var1_1.getDocumentBase().getProtocol(), var1_1.getDocumentBase().getHost(), var1_1.getDocumentBase().getPort(), var17_39);
                                                            var5_5 = var12_12.openStream();
                                                            this.deserialize(var5_5);
                                                            var5_5.close();
                                                            break block187;
                                                        }
                                                        if (!this.justParse) break block192;
                                                        var19_59 = 0;
                                                        while (var19_59 < this.extensionName.length) {
                                                            try {
                                                                var12_12 = new URL(var1_1.getDocumentBase().getProtocol(), var1_1.getDocumentBase().getHost(), var1_1.getDocumentBase().getPort(), String.valueOf(var17_39) + this.extensionName[var19_59]);
                                                                break;
                                                            }
                                                            catch (Exception v7) {
                                                                try {
                                                                    var12_12 = new URL(var1_1.getDocumentBase().getProtocol(), var1_1.getDocumentBase().getHost(), var1_1.getDocumentBase().getPort(), String.valueOf(var17_39.toLowerCase()) + this.extensionName[var19_59]);
                                                                    break;
                                                                }
                                                                catch (Exception v8) {
                                                                    var12_12 = null;
                                                                    ++var19_59;
                                                                }
                                                            }
                                                        }
                                                        if (var12_12 == null) {
                                                            throw new Exception();
                                                        }
                                                        if (!var12_12.getProtocol().equalsIgnoreCase("http")) ** GOTO lbl189
                                                        var20_67 = (HttpURLConnection)var12_12.openConnection();
                                                        if (this.validateUrl((HttpURLConnection)var20_67)) {
                                                            var5_5 = var20_67.getInputStream();
                                                        } else {
                                                            throw new FileNotFoundException(var12_12.toString());
lbl189:
                                                            // 1 sources

                                                            if (MibOperations.jdbc) {
                                                                var20_67 = this.getModuleNameDefinition(var12_12.toString());
                                                                if (!MibOperations.overWriteDataBase && this.jMibOps.isExist((String)var20_67)) {
                                                                    this.jMibOps.put((String)var20_67, var12_12.toString());
                                                                    this.jMibOps.loadJdbcMibModules((String)var20_67);
                                                                    MIBParser.reInitialize();
                                                                    return;
                                                                }
                                                            }
                                                            var5_5 = var12_12.openStream();
                                                        }
                                                        break block187;
                                                    }
                                                    var14_14 = var17_39.endsWith(".cmi") == false && var17_39.endsWith(".CMI") == false ? new URL(var1_1.getDocumentBase().getProtocol(), var1_1.getDocumentBase().getHost(), var1_1.getDocumentBase().getPort(), String.valueOf(var17_39) + ".cmi") : new URL(var1_1.getDocumentBase().getProtocol(), var1_1.getDocumentBase().getHost(), var1_1.getDocumentBase().getPort(), var17_39);
                                                    try {
                                                        var5_5 = var14_14.openStream();
                                                    }
                                                    catch (Exception v9) {
                                                        var12_12 = new URL(var1_1.getDocumentBase().getProtocol(), var1_1.getDocumentBase().getHost(), var1_1.getDocumentBase().getPort(), var17_39);
                                                        var4_4 = var12_12.openStream();
                                                        var8_8 = this.getModuleNameDefinition(var12_12.toString());
                                                        var14_14 = new URL(var1_1.getDocumentBase().getProtocol(), var1_1.getDocumentBase().getHost(), var1_1.getDocumentBase().getPort(), String.valueOf(var17_39.substring(0, var17_39.lastIndexOf("/") + 1)) + var8_8 + ".cmi");
                                                        var5_5 = var14_14.openStream();
                                                        var9_9 = false;
                                                    }
                                                    if (this.isReadDesc()) {
                                                        var19_60 = var14_14.toString();
                                                        var19_60 = var19_60.substring(0, var19_60.length() - 3);
                                                        var19_60 = String.valueOf(var19_60) + "cds";
                                                        var13_13 = new URL(var19_60);
                                                        var6_6 = var13_13.openStream();
                                                    }
                                                    break block187;
                                                }
                                                catch (Exception v10) {
                                                    var4_4 = null;
                                                    if (this.loadFromSerializedMibs) {
                                                        var12_12 = new URL(var1_1.getDocumentBase(), var15_15);
                                                        var5_5 = var12_12.openStream();
                                                        this.deserialize(var5_5);
                                                        var5_5.close();
                                                        break block187;
                                                    }
                                                    if (!this.justParse) break block188;
                                                    var17_40 = 0;
                                                    ** while (var17_40 < this.extensionName.length)
                                                }
                                            }
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            try {
                                                var12_12 = new URL(var1_1.getDocumentBase(), String.valueOf(var15_15) + this.extensionName[var17_40]);
                                                break;
                                            }
                                            catch (Exception v11) {
                                                try {
                                                    var12_12 = new URL(var1_1.getDocumentBase(), String.valueOf(var15_15.toLowerCase()) + this.extensionName[var17_40]);
                                                    break;
                                                }
                                                catch (Exception v12) {
                                                    var12_12 = null;
                                                    ++var17_40;
                                                }
                                            }
                                            continue;
                                        }
lbl240:
                                        // 3 sources

                                        if (var12_12 == null) {
                                            throw new Exception();
                                        }
                                        if (!var12_12.getProtocol().equalsIgnoreCase("http")) ** GOTO lbl248
                                        var18_52 = (HttpURLConnection)var12_12.openConnection();
                                        if (this.validateUrl((HttpURLConnection)var18_52)) {
                                            var5_5 = var18_52.getInputStream();
                                        } else {
                                            throw new FileNotFoundException(var12_12.toString());
lbl248:
                                            // 1 sources

                                            if (MibOperations.jdbc) {
                                                var18_52 = this.getModuleNameDefinition(var12_12.toString());
                                                if (!MibOperations.overWriteDataBase && this.jMibOps.isExist((String)var18_52)) {
                                                    this.jMibOps.put((String)var18_52, var12_12.toString());
                                                    this.jMibOps.loadJdbcMibModules((String)var18_52);
                                                    MIBParser.reInitialize();
                                                    return;
                                                }
                                            }
                                            var5_5 = var12_12.openStream();
                                        }
                                        break block187;
                                    }
                                    try {
                                        var14_14 = var10_10 == false ? new URL(var1_1.getDocumentBase(), String.valueOf(var15_15) + ".cmi") : new URL(var1_1.getDocumentBase(), var15_15);
                                        var5_5 = var14_14.openStream();
                                    }
                                    catch (Exception v13) {
                                        var12_12 = new URL(var1_1.getDocumentBase(), var15_15);
                                        var4_4 = var12_12.openStream();
                                        var8_8 = this.getModuleNameDefinition(var12_12.toString());
                                        var14_14 = new URL(var1_1.getDocumentBase(), String.valueOf(var15_15.toString().substring(0, var15_15.toString().lastIndexOf("/") + 1)) + var8_8 + ".cmi");
                                        var5_5 = var14_14.openStream();
                                        var9_9 = false;
                                    }
                                    if (this.isReadDesc()) {
                                        var17_41 = var14_14.toString();
                                        var17_41 = var17_41.substring(0, var17_41.length() - 3);
                                        var17_41 = String.valueOf(var17_41) + "cds";
                                        var13_13 = new URL(var17_41);
                                        var6_6 = var13_13.openStream();
                                    }
                                }
                                if (!var11_11) {
                                    if (this.justParse) {
                                        var17_42 = var12_12.toString();
                                        if (MibOperations.jdbc) {
                                            var18_52 = this.getModuleNameDefinition(var17_42);
                                            if (!MibOperations.overWriteDataBase && this.jMibOps.isExist((String)var18_52)) {
                                                this.jMibOps.put((String)var18_52, var17_42);
                                                this.jMibOps.loadJdbcMibModules((String)var18_52);
                                                MIBParser.reInitialize();
                                                return;
                                            }
                                        }
                                        var18_53 = var17_42.lastIndexOf("/");
                                        this.mibFileDir = var17_42 = var17_42.substring(0, var18_53 + 1);
                                    } else {
                                        var17_43 = var14_14.toString();
                                        var18_54 = var17_43.lastIndexOf("/");
                                        this.mibFileDir = var17_43 = var17_43.substring(0, var18_54 + 1);
                                    }
                                }
                                this.searching = false;
                                break;
                            }
                            catch (Exception var17_34) {
                                if (!(var17_34 instanceof MibException)) continue;
                                throw new MibException(var17_34.getMessage());
                            }
                        }
                        this.mibFileDir = "";
                        if (this.searching) {
                            throw new FileNotFoundException(String.valueOf(SnmpUtils.getString("Couldn't find file in search path specified:")) + " " + var2_2);
                        }
                        var17_44 = var1_1.getParameter("MIBS_DIR");
                        if (var17_44 != null) {
                            this.mibFileDir = var17_44;
                            if (!this.mibFileDir.endsWith("/")) {
                                this.mibFileDir = String.valueOf(this.mibFileDir) + "/";
                            }
                        }
                        if (this.justParse) {
                            if (var5_5 == null) {
                                throw new FileNotFoundException(var2_2);
                            }
                            var3_3 = new MibModule(var5_5, this);
                            var3_3.filename = var2_2;
                        } else {
                            if (var5_5 == null) {
                                throw new FileNotFoundException(var14_14.toString());
                            }
                            if (this.isReadDesc() && var6_6 == null) {
                                throw new FileNotFoundException(var13_13.toString());
                            }
                            var3_3 = this.loadModule(var5_5, var6_6, var7_7);
                            var3_3.filename = var2_2;
                            if (this.isReadDesc()) {
                                var6_6.close();
                                var6_6 = null;
                            }
                        }
                        var5_5.close();
                        var5_5 = null;
                        if (var7_7 != null && !var3_3.getName().equals(var7_7)) {
                            throw new MibException(String.valueOf(SnmpUtils.getString("imported file name")) + " " + var7_7 + SnmpUtils.getString("and module name") + " " + var3_3.getName() + SnmpUtils.getString("mismatch !"));
                        }
                        var18_55 = this.globalImports.keys();
                        while (var18_55.hasMoreElements()) {
                            var19_61 = (String)var18_55.nextElement();
                            try {
                                if (this.modules.get(var19_61) != null || this.getModuleFromGlobalImports(var19_61) != null) continue;
                                if (this.mibFileDir.indexOf(" ") != -1) {
                                    this.loadMibModule(var1_1, "\"" + this.mibFileDir + var19_61 + "\"" + "&#$*@");
                                    continue;
                                }
                                this.loadMibModule(var1_1, String.valueOf(this.mibFileDir) + var19_61 + "&#$*@");
                            }
                            catch (FileNotFoundException var20_68) {
                                this.globalImports = null;
                                var21_70 = var20_68.getMessage();
                                if (var21_70.indexOf("IMPORTS failed:") == -1) {
                                    var21_70 = String.valueOf(SnmpUtils.getString("IMPORTS failed:")) + " " + var21_70;
                                }
                                throw new FileNotFoundException(var21_70);
                            }
                            catch (MibException var20_69) {
                                this.globalImports = null;
                                var21_71 = var20_69.getMessage();
                                if (var21_71.indexOf("IMPORTS failed:") == -1) {
                                    var21_71 = String.valueOf(SnmpUtils.getString("IMPORTS failed:")) + " " + var21_71;
                                }
                                throw new MibException(var21_71);
                            }
                        }
                        if (MibOperations.jdbc && this.jMibOps.isExist(var19_62 = this.getModuleNameDefinition(var2_2))) {
                            this.jMibOps.put(var19_62, var2_2);
                            this.jMibOps.loadJdbcMibModules(var19_62);
                            MIBParser.reInitialize();
                            var3_3 = null;
                            return;
                        }
                        var19_63 = this.globalImports.keys();
                        while (var19_63.hasMoreElements()) {
                            var20_67 = (String)var19_63.nextElement();
                            var21_72 = (MibModule)this.modules.get(var20_67);
                            if (var21_72 != null) {
                                this.resolver.performResolution(var21_72);
                                continue;
                            }
                            var21_72 = this.getModuleFromGlobalImports((String)var20_67);
                            this.resolver.performResolution(var21_72);
                        }
                        if (var7_7 == null && !this.globalImports.isEmpty()) {
                            this.resolver.performResolution();
                        }
                        break block193;
                    }
                    try {
                        if (this.loadFromSerializedMibs) {
                            var12_12 = new URL(var2_2);
                            var5_5 = var12_12.openStream();
                            this.deserialize(var5_5);
                            var5_5.close();
                            break block189;
                        }
                        if (this.justParse) {
                            var15_16 = 0;
                            while (var15_16 < this.extensionName.length) {
                                try {
                                    var12_12 = new URL(String.valueOf(var2_2) + this.extensionName[var15_16]);
                                    break;
                                }
                                catch (Exception v14) {
                                    try {
                                        var12_12 = new URL(String.valueOf(var2_2.toLowerCase()) + this.extensionName[var15_16]);
                                        break;
                                    }
                                    catch (Exception v15) {
                                        var12_12 = null;
                                        ++var15_16;
                                    }
                                }
                            }
                            if (var12_12 == null) {
                                throw new Exception();
                            }
                            if (MibOperations.jdbc) {
                                var16_27 = this.getModuleNameDefinition(var12_12.toString());
                                if (!MibOperations.overWriteDataBase && this.jMibOps.isExist(var16_27)) {
                                    this.jMibOps.loadJdbcMibModules(var16_27);
                                    return;
                                }
                            }
                            var5_5 = var12_12.openStream();
                            break block189;
                        }
                        try {
                            var14_14 = var10_10 == false ? new URL(String.valueOf(var2_2) + ".cmi") : new URL(var2_2);
                            var5_5 = var14_14.openStream();
                        }
                        catch (Exception v16) {
                            var12_12 = new URL(var2_2);
                            var5_5 = var12_12.openStream();
                            var8_8 = this.getModuleNameDefinition(var12_12.toString());
                            var14_14 = new URL(String.valueOf(var2_2.toString().substring(0, var2_2.lastIndexOf("/") + 1)) + var8_8 + ".cmi");
                            var5_5 = var14_14.openStream();
                            var9_9 = false;
                        }
                        if (this.isReadDesc()) {
                            var15_17 = var14_14.toString();
                            var15_17 = var15_17.substring(0, var15_17.length() - 3);
                            var15_17 = String.valueOf(var15_17) + "cds";
                            var13_13 = new URL(var15_17);
                            var6_6 = var13_13.openStream();
                        }
                        break block189;
                    }
                    catch (Exception v17) {
                        var11_11 = false;
                        try {
                            if (this.loadFromSerializedMibs) {
                                var12_12 = var1_1.getClass().getResource(var2_2);
                                var5_5 = var12_12.openStream();
                                this.deserialize(var5_5);
                                var5_5.close();
                            } else if (this.justParse) {
                                var15_18 = 0;
                                while (var15_18 < this.extensionName.length) {
                                    try {
                                        var12_12 = var1_1.getClass().getResource(String.valueOf(var2_2) + this.extensionName[var15_18]);
                                        if (var12_12 != null) break;
                                        throw new Exception();
                                    }
                                    catch (Exception v18) {
                                        try {
                                            var12_12 = var1_1.getClass().getResource(String.valueOf(var2_2.toLowerCase()) + this.extensionName[var15_18]);
                                            if (var12_12 != null) break;
                                            throw new Exception();
                                        }
                                        catch (Exception v19) {
                                            var12_12 = null;
                                            ++var15_18;
                                        }
                                    }
                                }
                                if (var12_12 == null) {
                                    throw new Exception();
                                }
                                if (MibOperations.jdbc) {
                                    var16_28 = this.getModuleNameDefinition(var12_12.toString());
                                    if (!MibOperations.overWriteDataBase && this.jMibOps.isExist(var16_28)) {
                                        this.jMibOps.put(var16_28, var12_12.toString());
                                        this.jMibOps.loadJdbcMibModules(var16_28);
                                        MIBParser.reInitialize();
                                        return;
                                    }
                                }
                                var5_5 = var12_12.openStream();
                            } else {
                                var14_14 = var10_10 == false ? var1_1.getClass().getResource(String.valueOf(var2_2) + ".cmi") : var1_1.getClass().getResource(var2_2);
                                if (var14_14 == null) {
                                    var12_12 = var1_1.getClass().getResource(var2_2);
                                    var4_4 = var12_12.openStream();
                                    var8_8 = this.getModuleNameDefinition(var12_12.toString());
                                    var14_14 = var1_1.getClass().getResource(String.valueOf(var2_2.toString().substring(0, var2_2.toString().lastIndexOf("/") + 1)) + var8_8 + ".cmi");
                                    if (var14_14 != null) {
                                        var9_9 = false;
                                    }
                                }
                                var5_5 = var14_14.openStream();
                                if (this.isReadDesc()) {
                                    var15_19 = var14_14.toString();
                                    var15_19 = var15_19.substring(0, var15_19.length() - 3);
                                    var15_19 = String.valueOf(var15_19) + "cds";
                                    var13_13 = var1_1.getClass().getResource(var15_19);
                                    var6_6 = var13_13.openStream();
                                }
                            }
                            if (var2_2.indexOf("/") == -1) {
                                this.mibFileDir = "";
                                var11_11 = true;
                            }
                            break block189;
                        }
                        catch (Exception v20) {
                            var4_4 = null;
                            var11_11 = false;
                            try {
                                block194: {
                                    var15_20 = null;
                                    var15_20 = var2_2;
                                    var16_29 = var1_1.getDocumentBase().getProtocol();
                                    if (var16_29 != null && var16_29.equalsIgnoreCase("http") && !var2_2.startsWith("/")) {
                                        var15_20 = "/" + var2_2;
                                    }
                                    if (this.loadFromSerializedMibs) {
                                        var12_12 = new URL(var1_1.getDocumentBase().getProtocol(), var1_1.getDocumentBase().getHost(), var1_1.getDocumentBase().getPort(), var15_20);
                                        var5_5 = var12_12.openStream();
                                        this.deserialize(var5_5);
                                        var5_5.close();
                                        break block189;
                                    }
                                    if (!this.justParse) break block194;
                                    var17_45 = 0;
                                    while (var17_45 < this.extensionName.length) {
                                        try {
                                            var12_12 = new URL(var1_1.getDocumentBase().getProtocol(), var1_1.getDocumentBase().getHost(), var1_1.getDocumentBase().getPort(), String.valueOf(var15_20) + this.extensionName[var17_45]);
                                            break;
                                        }
                                        catch (Exception v21) {
                                            try {
                                                var12_12 = new URL(var1_1.getDocumentBase().getProtocol(), var1_1.getDocumentBase().getHost(), var1_1.getDocumentBase().getPort(), String.valueOf(var15_20.toLowerCase()) + this.extensionName[var17_45]);
                                                break;
                                            }
                                            catch (Exception v22) {
                                                var12_12 = null;
                                                ++var17_45;
                                            }
                                        }
                                    }
                                    if (var12_12 == null) {
                                        throw new Exception();
                                    }
                                    if (!var12_12.getProtocol().equalsIgnoreCase("http")) ** GOTO lbl509
                                    var18_56 = (HttpURLConnection)var12_12.openConnection();
                                    if (this.validateUrl((HttpURLConnection)var18_56)) {
                                        var5_5 = var18_56.getInputStream();
                                    } else {
                                        throw new FileNotFoundException(var12_12.toString());
lbl509:
                                        // 1 sources

                                        var5_5 = var12_12.openStream();
                                    }
                                    break block189;
                                }
                                var14_14 = var15_20.endsWith(".cmi") == false && var15_20.endsWith(".CMI") == false ? new URL(var1_1.getDocumentBase().getProtocol(), var1_1.getDocumentBase().getHost(), var1_1.getDocumentBase().getPort(), String.valueOf(var15_20) + ".cmi") : new URL(var1_1.getDocumentBase().getProtocol(), var1_1.getDocumentBase().getHost(), var1_1.getDocumentBase().getPort(), var15_20);
                                try {
                                    var5_5 = var14_14.openStream();
                                }
                                catch (Exception v23) {
                                    var12_12 = new URL(var1_1.getDocumentBase().getProtocol(), var1_1.getDocumentBase().getHost(), var1_1.getDocumentBase().getPort(), var15_20);
                                    var4_4 = var12_12.openStream();
                                    var8_8 = this.getModuleNameDefinition(var12_12.toString());
                                    var14_14 = new URL(var1_1.getDocumentBase().getProtocol(), var1_1.getDocumentBase().getHost(), var1_1.getDocumentBase().getPort(), String.valueOf(var15_20.substring(0, var15_20.lastIndexOf("/") + 1)) + var8_8 + ".cmi");
                                    var5_5 = var14_14.openStream();
                                    var9_9 = false;
                                }
                                if (this.isReadDesc()) {
                                    var17_46 = var14_14.toString();
                                    var17_46 = var17_46.substring(0, var17_46.length() - 3);
                                    var17_46 = String.valueOf(var17_46) + "cds";
                                    var13_13 = new URL(var17_46);
                                    var6_6 = var13_13.openStream();
                                }
                                break block189;
                            }
                            catch (Exception v24) {
                                var4_4 = null;
                                if (this.loadFromSerializedMibs) {
                                    var12_12 = new URL(var1_1.getDocumentBase(), var2_2);
                                    var5_5 = var12_12.openStream();
                                    this.deserialize(var5_5);
                                    var5_5.close();
                                    break block189;
                                }
                                if (!this.justParse) break block190;
                                var15_21 = null;
                                var16_30 = 0;
                                ** while (var16_30 < this.extensionName.length)
                            }
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var15_21 = new URL(var1_1.getDocumentBase(), String.valueOf(var2_2) + this.extensionName[var16_30]);
                            break;
                        }
                        catch (Exception v25) {
                            try {
                                var15_21 = new URL(var1_1.getDocumentBase(), String.valueOf(var2_2.toLowerCase()) + this.extensionName[var16_30]);
                                break;
                            }
                            catch (Exception v26) {
                                ++var16_30;
                            }
                        }
                        continue;
                    }
lbl553:
                    // 3 sources

                    var12_12 = var15_21;
                    if (var12_12 == null) {
                        throw new FileNotFoundException(var12_12.toString());
                    }
                    if (!var12_12.getProtocol().equalsIgnoreCase("http")) ** GOTO lbl562
                    var17_47 = (HttpURLConnection)var12_12.openConnection();
                    if (this.validateUrl(var17_47)) {
                        var5_5 = var17_47.getInputStream();
                    } else {
                        throw new FileNotFoundException(var12_12.toString());
lbl562:
                        // 1 sources

                        if (MibOperations.jdbc) {
                            var17_48 = this.getModuleNameDefinition(var12_12.toString());
                            if (!MibOperations.overWriteDataBase && this.jMibOps.isExist(var17_48)) {
                                this.jMibOps.put(var17_48, var12_12.toString());
                                this.jMibOps.loadJdbcMibModules(var17_48);
                                MIBParser.reInitialize();
                                return;
                            }
                        }
                        var5_5 = var12_12.openStream();
                    }
                    break block189;
                }
                try {
                    var14_14 = var10_10 == false ? new URL(var1_1.getDocumentBase(), String.valueOf(var2_2) + ".cmi") : new URL(var1_1.getDocumentBase(), var2_2);
                    var5_5 = var14_14.openStream();
                }
                catch (Exception v27) {
                    var12_12 = new URL(var1_1.getDocumentBase(), var2_2);
                    var4_4 = var12_12.openStream();
                    var8_8 = this.getModuleNameDefinition(var12_12.toString());
                    var14_14 = new URL(var1_1.getDocumentBase(), String.valueOf(var2_2.toString().substring(0, var2_2.toString().lastIndexOf("/") + 1)) + var8_8 + ".cmi");
                    var5_5 = var14_14.openStream();
                    var9_9 = false;
                }
                if (this.isReadDesc()) {
                    var15_22 = var14_14.toString();
                    var15_22 = var15_22.substring(0, var15_22.length() - 3);
                    var15_22 = String.valueOf(var15_22) + "cds";
                    var13_13 = new URL(var15_22);
                    var6_6 = var13_13.openStream();
                }
            }
            if (!var11_11) {
                if (this.justParse) {
                    var15_23 = var12_12.toString();
                    var16_31 = var15_23.lastIndexOf("/");
                    this.mibFileDir = var15_23 = var15_23.substring(0, var16_31 + 1);
                } else {
                    var15_24 = var14_14.toString();
                    var16_32 = var15_24.lastIndexOf("/");
                    this.mibFileDir = var15_24 = var15_24.substring(0, var16_32 + 1);
                }
            }
            if ((var15_25 = var1_1.getParameter("MIBS_DIR")) != null) {
                this.mibFileDir = var15_25;
                if (!this.mibFileDir.endsWith("/")) {
                    this.mibFileDir = String.valueOf(this.mibFileDir) + "/";
                }
            }
            if (this.justParse) {
                if (var5_5 == null) {
                    throw new FileNotFoundException(var2_2);
                }
                var3_3 = new MibModule(var5_5, this);
                var3_3.filename = var2_2;
            } else {
                if (var5_5 == null) {
                    throw new FileNotFoundException(var14_14.toString());
                }
                if (this.isReadDesc() && var6_6 == null) {
                    throw new FileNotFoundException(var13_13.toString());
                }
                var3_3 = this.loadModule(var5_5, var6_6, var7_7);
                var3_3.filename = var2_2;
                if (this.isReadDesc()) {
                    var6_6.close();
                    var6_6 = null;
                }
            }
            var5_5.close();
            var5_5 = null;
            if (var7_7 != null && !var3_3.getName().equals(var7_7)) {
                throw new MibException(String.valueOf(SnmpUtils.getString("imported file name")) + " " + var7_7 + SnmpUtils.getString("and module name") + " " + var3_3.getName() + " " + SnmpUtils.getString("mismatch !"));
            }
            var16_33 = this.globalImports.keys();
            while (var16_33.hasMoreElements()) {
                var17_49 = (String)var16_33.nextElement();
                try {
                    if (this.modules.get(var17_49) != null || this.getModuleFromGlobalImports(var17_49) != null) continue;
                    if (this.mibFileDir.indexOf(" ") != -1) {
                        this.loadMibModule(var1_1, "\"" + this.mibFileDir + var17_49 + "\"" + "&#$*@");
                        continue;
                    }
                    this.loadMibModule(var1_1, String.valueOf(this.mibFileDir) + var17_49 + "&#$*@");
                }
                catch (FileNotFoundException var18_57) {
                    this.globalImports = null;
                    var19_64 = var18_57.getMessage();
                    if (var19_64.indexOf("IMPORTS failed:") == -1) {
                        var19_64 = String.valueOf(SnmpUtils.getString("IMPORTS failed:")) + " " + var19_64;
                    }
                    throw new FileNotFoundException(var19_64);
                }
                catch (MibException var18_58) {
                    this.globalImports = null;
                    var19_65 = var18_58.getMessage();
                    if (var19_65.indexOf("IMPORTS failed:") == -1) {
                        var19_65 = String.valueOf(SnmpUtils.getString("IMPORTS failed:")) + " " + var19_65;
                    }
                    throw new MibException(var19_65);
                }
            }
            if (MibOperations.jdbc && this.jMibOps.isExist(var17_50 = this.getModuleNameDefinition(var12_12.toString()))) {
                this.jMibOps.put(var17_50, var12_12.toString());
                this.jMibOps.loadJdbcMibModules(var17_50);
                MIBParser.reInitialize();
                return;
            }
            var17_51 = this.globalImports.keys();
            while (var17_51.hasMoreElements()) {
                var18_56 = (String)var17_51.nextElement();
                var19_66 = (MibModule)this.modules.get(var18_56);
                if (var19_66 != null) {
                    this.resolver.performResolution(var19_66);
                    continue;
                }
                var19_66 = this.getModuleFromGlobalImports((String)var18_56);
                this.resolver.performResolution(var19_66);
            }
            if (var7_7 == null && !this.globalImports.isEmpty()) {
                this.resolver.performResolution();
            }
        }
    }

    public synchronized MibModule loadMibModule(Applet applet, URL uRL) throws MibException, IOException, FileNotFoundException {
        Object object;
        Object object2;
        String string;
        if (uRL == null) {
            return null;
        }
        String string2 = uRL.toString();
        if (!this.justParse && (string2.endsWith(".cds") || string2.endsWith(".CDS"))) {
            throw new MibException(SnmpUtils.getString("The .cds file could not be loaded."));
        }
        String string3 = null;
        this.setExtensionName();
        if (string2.endsWith("&#$*@")) {
            string2 = string2.substring(0, string2.length() - 5);
            uRL = this.justParse ? new URL(string2) : new URL(String.valueOf(string2) + ".cmi");
            string3 = this.getModuleNameFromPath(string2);
        } else {
            this.globalImports = new Hashtable(1);
        }
        InputStream inputStream = uRL.openStream();
        InputStream inputStream2 = null;
        if (!this.justParse) {
            this.mibFileName = string = uRL.toString();
            if (string.endsWith(".cmi") || string.endsWith(".CMI")) {
                string = string.substring(0, string.length() - 3);
                string = String.valueOf(string) + "cds";
            } else {
                string = String.valueOf(string) + ".cds";
            }
            if (this.isReadDesc()) {
                URL uRL2 = new URL(string);
                inputStream2 = uRL2.openStream();
            }
        }
        string = uRL.toString();
        int n = string.lastIndexOf("/");
        this.mibFileDir = string = string.substring(0, n + 1);
        MibModule mibModule = null;
        if (this.justParse) {
            this.mibFileName = uRL.toString();
            mibModule = new MibModule(inputStream, this);
        } else {
            mibModule = this.loadModule(inputStream, inputStream2, string3);
        }
        mibModule.filename = uRL.toString();
        inputStream.close();
        if (inputStream2 != null) {
            inputStream2.close();
        }
        if (string3 != null && !mibModule.getName().equals(string3)) {
            throw new MibException(String.valueOf(SnmpUtils.getString("imported file name")) + " " + string3 + SnmpUtils.getString("and module name") + " " + mibModule.getName() + SnmpUtils.getString("mismatch !"));
        }
        String string4 = applet.getParameter("MIBS_DIR");
        if (string4 != null) {
            this.mibFileDir = string4;
            if (!this.mibFileDir.endsWith("/")) {
                this.mibFileDir = String.valueOf(this.mibFileDir) + "/";
            }
        }
        Enumeration enumeration = this.globalImports.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            try {
                if (this.modules.get(object2) != null || this.getModuleFromGlobalImports((String)object2) != null) continue;
                object = new URL(applet.getDocumentBase(), String.valueOf(this.mibFileDir) + (String)object2 + "&#$*@");
                if (this.mibFileDir.indexOf(" ") != -1) {
                    this.loadMibModule(applet, new URL("\"" + ((URL)object).toString() + "\""));
                    continue;
                }
                this.loadMibModule(applet, (URL)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.globalImports = null;
                String string5 = fileNotFoundException.getMessage();
                if (string5.indexOf("IMPORTS failed:") == -1) {
                    string5 = String.valueOf(SnmpUtils.getString("IMPORTS failed:")) + " " + string5;
                }
                throw new FileNotFoundException(string5);
            }
            catch (MibException mibException) {
                this.globalImports = null;
                String string6 = mibException.getMessage();
                if (string6.indexOf("IMPORTS failed:") == -1) {
                    string6 = String.valueOf(SnmpUtils.getString("IMPORTS failed:")) + " " + string6;
                }
                throw new MibException(string6);
            }
        }
        if (jdbc && overWriteDataBase) {
            object2 = this.getModuleNameDefinition(string);
            this.jMibOps.unloadMibModule((String)object2);
        }
        if (jdbc && this.jMibOps.isExist((String)(object2 = this.getModuleNameDefinition(string)))) {
            this.jMibOps.put((String)object2, string);
            this.jMibOps.loadJdbcMibModules((String)object2);
            MIBParser.reInitialize();
            mibModule = null;
            return this.jMibOps.getMibModule((String)object2);
        }
        object2 = this.globalImports.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            MibModule mibModule2 = (MibModule)this.modules.get(object);
            if (mibModule2 != null) {
                this.resolver.performResolution(mibModule2);
                continue;
            }
            mibModule2 = this.getModuleFromGlobalImports((String)object);
            this.resolver.performResolution(mibModule2);
        }
        if (string3 == null && !this.globalImports.isEmpty()) {
            this.resolver.performResolution();
        }
        if (jdbc) {
            MIBParser.reInitialize();
            mibModule = null;
        }
        this.removeModules();
        if (this.isMultipleRevision()) {
            return this.getRevisionModule(mibModule);
        }
        return mibModule;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized MibModule loadMibModule(String var1_1) throws MibException, IOException, FileNotFoundException {
        block143: {
            block144: {
                block145: {
                    if (var1_1 == null) {
                        return null;
                    }
                    if ((var1_1 = var1_1.trim()).equals("")) {
                        return null;
                    }
                    if (this.overWriteCMI && (var1_1.endsWith(".cmi") || var1_1.endsWith(".CMI"))) {
                        throw new MibException(SnmpUtils.getString("Could not parse the .cmi File"));
                    }
                    if (!this.justParse && (var1_1.endsWith(".cds") || var1_1.endsWith(".CDS"))) {
                        throw new MibException(SnmpUtils.getString("The .cds file could not be loaded."));
                    }
                    if (MibOperations.jdbc) {
                        this.jMibOps.tableHash.clear();
                    }
                    var2_2 = null;
                    var3_3 = true;
                    var4_4 = null;
                    var5_5 = false;
                    this.setExtensionName();
                    if (this.isMultipleRevision()) {
                        this.changeModuleName();
                    }
                    if (this.loadFromSerializedMibs) {
                        if (var1_1.startsWith("\"") && var1_1.endsWith("\"")) {
                            var1_1 = var1_1.substring(1, var1_1.length() - 1);
                        }
                        var6_6 = new FileInputStream((String)var1_1);
                        var7_9 = this.deserialize(var6_6);
                        var6_6.close();
                        return var7_9;
                    }
                    if (var1_1.endsWith("@*$#&")) {
                        var1_1 = var1_1.substring(0, var1_1.length() - 5);
                    } else if (var1_1.endsWith("&#$*@")) {
                        var1_1 = var1_1.substring(0, var1_1.length() - 5);
                        var6_7 = this.findFileName((String)var1_1);
                        var4_4 = this.getModuleNameFromPath((String)var1_1);
                        if (var6_7 != null) {
                            var1_1 = var6_7;
                        }
                    } else {
                        var5_5 = true;
                        this.globalImports = new Hashtable<K, V>(1);
                    }
                    if (var1_1.startsWith("\"") && var1_1.endsWith("\"")) {
                        var1_1 = var1_1.substring(1, var1_1.length() - 1);
                    }
                    this.mibFileDir = (var6_8 = (var1_1 = var1_1.replace('\\', '/')).lastIndexOf("/")) != -1 ? var1_1.substring(0, var6_8 + 1) : "./";
                    var7_10 = "";
                    if (MibOperations.jdbc) {
                        if (this.searchPath != null) {
                            var8_11 = var1_1;
                            if ((var1_1 = this.findFile((String)var1_1)).equals("")) {
                                throw new FileNotFoundException(SnmpUtils.getString("The File is not found in the SearchPath specified :" + (String)var8_11));
                            }
                        }
                        var7_10 = this.getModuleNameDefinition((String)var1_1);
                        if (MibOperations.overWriteDataBase) {
                            this.jMibOps.unloadMibModule(var7_10);
                        }
                    }
                    var8_11 = null;
                    var9_12 = null;
                    var10_13 = null;
                    var11_14 = null;
                    var12_15 = var1_1.endsWith(".cmi") != false || var1_1.endsWith(".CMI") != false;
                    var13_16 = null;
                    var14_17 = false;
                    if (this.searchPath == null) break block145;
                    if (this.searchPath.indexOf("./|") < 0) {
                        this.searchPath = "./|" + this.searchPath;
                    }
                    this.searching = true;
                    var15_18 = null;
                    var16_20 = new StringTokenizer(this.searchPath, "|");
                    while (var16_20.hasMoreTokens()) {
                        try {
                            var15_18 = var16_20.nextToken();
                            var15_18 = var15_18.replace('\\', '/');
                            if (!var15_18.endsWith("/")) {
                                var15_18 = String.valueOf(var15_18) + "/";
                            }
                            var15_18 = var15_18.trim();
                            try {
                                this.getmodulenamedefinition((String)var1_1);
                                var15_18 = var1_1;
                            }
                            catch (Exception v0) {
                                var15_18 = String.valueOf(var15_18) + (String)var1_1;
                            }
                            this.mibFileDir = var15_18.substring(0, var15_18.lastIndexOf("/") + 1);
                            if (this.justParse) {
                                var17_32 = var15_18;
                                try {
                                    if (MibOperations.jdbc) {
                                        var18_44 = this.getModuleNameDefinition((String)var17_32);
                                        if (!MibOperations.overWriteDataBase && this.jMibOps.isExist((String)var18_44)) {
                                            this.jMibOps.put((String)var18_44, (String)var17_32);
                                            this.jMibOps.loadJdbcMibModules((String)var18_44);
                                            MIBParser.reInitialize();
                                            return this.jMibOps.getMibModule((String)var18_44);
                                        }
                                    }
                                    var8_11 = new FileInputStream((String)var15_18);
                                    var1_1 = var15_18;
                                }
                                catch (FileNotFoundException v1) {
                                    var17_32 = this.findFileName((String)var15_18);
                                    var8_11 = new FileInputStream((String)var17_32);
                                    var1_1 = var17_32;
                                }
                                this.mibFileName = var17_32;
                            } else {
                                var10_13 = var12_15 == false ? new File(String.valueOf(var15_18) + ".cmi") : new File((String)var15_18);
                                if (!var10_13.exists()) {
                                    var2_2 = String.valueOf(this.mibFileDir) + this.getModuleNameDefinition((String)var15_18);
                                    var10_13 = new File(String.valueOf(var2_2) + ".cmi");
                                    if (!var2_2.equals(var15_18)) {
                                        var3_3 = false;
                                    }
                                }
                                if (var10_13.exists() && !this.overWrite) {
                                    var8_11 = new FileInputStream(var10_13.toString());
                                } else if (!var12_15 && new File((String)var15_18).exists()) {
                                    var17_32 = null;
                                    try {
                                        var17_32 = MIBParser.parseMibModule((String)var15_18, this.userLabel);
                                        this.mibFileName = var15_18;
                                        var14_17 = true;
                                        var13_16 = String.valueOf(this.mibFileDir) + (String)var17_32 + ".cds";
                                    }
                                    catch (ParseException var18_45) {
                                        this.globalImports = null;
                                        throw new MibException(var18_45.getMessage());
                                    }
                                    var8_11 = new FileInputStream(String.valueOf(this.mibFileDir) + (String)var17_32 + ".cmi");
                                    var1_1 = String.valueOf(this.mibFileDir) + (String)var17_32 + ".cmi";
                                } else {
                                    throw new FileNotFoundException((String)var1_1);
                                }
                                if (this.isReadDesc()) {
                                    if (!var14_17) {
                                        if (var3_3) {
                                            if (var12_15) {
                                                var13_16 = var15_18.substring(0, var15_18.length() - 4);
                                                var13_16 = String.valueOf(var13_16) + ".cds";
                                            } else {
                                                var13_16 = String.valueOf(var15_18) + ".cds";
                                            }
                                        } else {
                                            var13_16 = String.valueOf(var2_2) + ".cds";
                                        }
                                    }
                                    var9_12 = new FileInputStream(var13_16);
                                }
                            }
                            this.searching = false;
                            break;
                        }
                        catch (Exception var17_31) {
                            if (!(var17_31 instanceof MibException)) continue;
                            throw new MibException(var17_31.getMessage());
                        }
                    }
                    this.mibFileDir = "";
                    if (this.searching) {
                        throw new FileNotFoundException(String.valueOf(SnmpUtils.getString("Couldn't find file in search path specified:")) + " " + (String)var1_1);
                    }
                    break block143;
                }
                try {
                    if (this.justParse) {
                        var15_18 = null;
                        var16_21 = 0;
                        while (var16_21 < this.extensionName.length) {
                            try {
                                var15_18 = this.getClass().getResource(String.valueOf(var1_1) + this.extensionName[var16_21]);
                                if (var15_18 != null) break;
                                throw new Exception();
                            }
                            catch (Exception v2) {
                                try {
                                    var15_18 = this.getClass().getResource(String.valueOf(var1_1.toLowerCase()) + this.extensionName[var16_21]);
                                    if (var15_18 != null) break;
                                    throw new Exception();
                                }
                                catch (Exception v3) {
                                    ++var16_21;
                                }
                            }
                        }
                        if (var15_18 == null) {
                            throw new Exception();
                        }
                        if (MibOperations.jdbc) {
                            var17_33 = this.getModuleNameDefinition(var15_18.toString());
                            if (!MibOperations.overWriteDataBase && this.jMibOps.isExist(var17_33)) {
                                this.jMibOps.put(var17_33, var15_18.toString());
                                this.jMibOps.loadJdbcMibModules(var17_33);
                                MIBParser.reInitialize();
                                return this.jMibOps.getMibModule(var17_33);
                            }
                        }
                        var8_11 = var15_18.openStream();
                        var17_34 = var1_1.lastIndexOf("/");
                        this.mibFileDir = var17_34 != -1 ? var1_1.substring(0, var17_34 + 1) : "";
                    } else {
                        var15_18 = null;
                        var15_18 = var12_15 == false ? this.getClass().getResource(String.valueOf(var1_1) + ".cmi") : this.getClass().getResource((String)var1_1);
                        if (var15_18 == null) {
                            var16_22 = this.getClass().getResource((String)var1_1);
                            var17_35 = var16_22.openStream();
                            var2_2 = String.valueOf(this.mibFileDir) + this.getModuleNameDefinition(var16_22.toString());
                            var15_18 = this.getClass().getResource(String.valueOf(var2_2) + ".cmi");
                            if (var15_18 != null) {
                                var3_3 = false;
                            }
                        }
                        var8_11 = var15_18.openStream();
                        var16_23 = var1_1.lastIndexOf("/");
                        this.mibFileDir = var16_23 != -1 ? var1_1.substring(0, var16_23 + 1) : "";
                        if (this.isReadDesc()) {
                            var17_35 = null;
                            var17_35 = var15_18.toString().substring(0, var15_18.toString().length() - 3);
                            var17_35 = String.valueOf(var17_35) + "cds";
                            var18_44 = this.getClass().getResource((String)var17_35);
                            var9_12 = var18_44.openStream();
                        }
                    }
                    break block143;
                }
                catch (Exception v4) {
                    try {
                        block146: {
                            if (!this.justParse) break block146;
                            var15_18 = new URL((String)var1_1);
                            if (!var15_18.getProtocol().equalsIgnoreCase("http")) ** GOTO lbl200
                            var16_24 = (HttpURLConnection)var15_18.openConnection();
                            if (this.validateUrl((HttpURLConnection)var16_24)) {
                                var8_11 = var16_24.getInputStream();
                            } else {
                                throw new FileNotFoundException(var15_18.toString());
lbl200:
                                // 1 sources

                                var8_11 = var15_18.openStream();
                            }
                            if (MibOperations.jdbc) {
                                var16_24 = this.getModuleNameDefinition(var15_18.toString());
                                if (!MibOperations.overWriteDataBase && this.jMibOps.isExist((String)var16_24)) {
                                    this.jMibOps.put((String)var16_24, var15_18.toString());
                                    this.jMibOps.loadJdbcMibModules((String)var16_24);
                                    MIBParser.reInitialize();
                                    return this.jMibOps.getMibModule((String)var16_24);
                                }
                            }
                            var16_24 = var15_18.toString();
                            this.mibFileDir = var16_24.substring(0, var16_24.lastIndexOf("/") + 1);
                            break block143;
                        }
                        var15_18 = null;
                        var15_18 = var12_15 == false ? new URL(String.valueOf(var1_1) + ".cmi") : new URL((String)var1_1);
                        try {
                            var8_11 = var15_18.openStream();
                        }
                        catch (IOException v5) {
                            var16_25 = new URL((String)var1_1);
                            var17_36 = var16_25.openStream();
                            var2_2 = String.valueOf(this.mibFileDir) + this.getModuleNameDefinition(var16_25.toString());
                            var15_18 = new URL(String.valueOf(var2_2) + ".cmi");
                            var8_11 = var15_18.openStream();
                        }
                        var16_25 = var15_18.toString();
                        this.mibFileDir = var16_25.substring(0, var16_25.lastIndexOf("/") + 1);
                        if (this.isReadDesc()) {
                            var17_36 = null;
                            var17_36 = var15_18.toString().substring(0, var15_18.toString().length() - 3);
                            var17_36 = String.valueOf(var17_36) + "cds";
                            var18_44 = new URL((String)var17_36);
                            var9_12 = var18_44.openStream();
                        }
                        break block143;
                    }
                    catch (Exception v6) {
                        try {
                            if (this.justParse) {
                                throw new Exception();
                            }
                            var15_18 = new URL((String)var1_1);
                            var16_26 = var15_18.openStream();
                            var16_26 = null;
                            var17_37 = MIBParser.parseMibModule((URL)var15_18, this.userLabel);
                            var18_44 = "./tmp/";
                            var8_11 = new FileInputStream(String.valueOf(var18_44) + var17_37 + ".cmi");
                            if (this.isReadDesc()) {
                                var9_12 = new FileInputStream(String.valueOf(var18_44) + var17_37 + ".cds");
                            }
                            var19_48 = var15_18.toString();
                            this.mibFileDir = var19_48.substring(0, var19_48.lastIndexOf("/") + 1);
                            this.isLoadedFromApplURL = true;
                            break block143;
                        }
                        catch (Exception v7) {
                            this.isLoadedFromApplURL = false;
                            this.mibFileDir = var1_1.indexOf("/") != -1 ? var1_1.substring(0, var1_1.lastIndexOf("/") + 1) : "./";
                            try {
                                if (this.justParse) {
                                    var15_18 = var1_1;
                                    try {
                                        var8_11 = new FileInputStream((String)var1_1);
                                    }
                                    catch (FileNotFoundException v8) {
                                        var15_18 = this.findFileName((String)var1_1);
                                        var8_11 = new FileInputStream(this.findFileName((String)var1_1));
                                    }
                                    this.mibFileName = var1_1;
                                    if (MibOperations.jdbc) {
                                        var16_27 = this.getModuleNameDefinition((String)var15_18);
                                        if (!MibOperations.overWriteDataBase && this.jMibOps.isExist(var16_27)) {
                                            this.jMibOps.put(var16_27, (String)var15_18);
                                            this.jMibOps.loadJdbcMibModules(var16_27);
                                            MIBParser.reInitialize();
                                            return this.jMibOps.getMibModule(var16_27);
                                        }
                                    }
                                    break block143;
                                }
                                var10_13 = var12_15 == false ? new File(String.valueOf(var1_1) + ".cmi") : new File((String)var1_1);
                                if (!var10_13.exists()) {
                                    var2_2 = String.valueOf(this.mibFileDir) + this.getModuleNameDefinition((String)var1_1);
                                    if (!var1_1.equals(var2_2)) {
                                        var3_3 = false;
                                    }
                                    var10_13 = new File(String.valueOf(var2_2) + ".cmi");
                                }
                                if (var10_13.exists() && !this.overWrite) {
                                    var8_11 = new FileInputStream(var10_13.toString());
                                } else if (!var12_15 && new File((String)var1_1).exists()) {
                                    var15_18 = null;
                                    try {
                                        var15_18 = MIBParser.parseMibModule((String)var1_1, this.userLabel);
                                        this.mibFileName = var1_1;
                                        var14_17 = true;
                                        var13_16 = String.valueOf(this.mibFileDir) + (String)var15_18 + ".cds";
                                    }
                                    catch (ParseException var16_28) {
                                        this.globalImports = null;
                                        throw new MibException(var16_28.getMessage());
                                    }
                                    var8_11 = new FileInputStream(String.valueOf(this.mibFileDir) + (String)var15_18 + ".cmi");
                                } else {
                                    if (!var10_13.exists()) {
                                        throw new FileNotFoundException((String)var1_1);
                                    }
                                    var8_11 = new FileInputStream(var10_13.toString());
                                }
                                if (this.isReadDesc()) {
                                    if (!var14_17) {
                                        if (var3_3) {
                                            if (var12_15) {
                                                var13_16 = var1_1.substring(0, var1_1.length() - 4);
                                                var13_16 = String.valueOf(var13_16) + ".cds";
                                            } else {
                                                var13_16 = String.valueOf(var1_1) + ".cds";
                                            }
                                        } else {
                                            var13_16 = String.valueOf(var2_2) + ".cds";
                                        }
                                    }
                                    var9_12 = new FileInputStream(var13_16);
                                }
                                break block143;
                            }
                            catch (Exception var15_19) {
                                if (var15_19 instanceof MibException) {
                                    throw new MibException(var15_19.getMessage());
                                }
                                if (!this.justParse) break block144;
                                var16_29 = null;
                                var17_38 = 0;
                                ** while (var17_38 < this.extensionName.length)
                            }
                        }
                    }
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        try {
                            var16_29 = this.getClass().getClassLoader().getResource(String.valueOf(var1_1) + this.extensionName[var17_38]);
                        }
                        catch (NullPointerException v9) {
                            var16_29 = ClassLoader.getSystemResource(String.valueOf(var1_1) + this.extensionName[var17_38]);
                        }
                        if (var16_29 != null) break;
                        throw new Exception();
                    }
                    catch (Exception v10) {
                        try {
                            try {
                                var16_29 = this.getClass().getClassLoader().getResource(String.valueOf(var1_1.toLowerCase()) + this.extensionName[var17_38]);
                            }
                            catch (NullPointerException v11) {
                                var16_29 = ClassLoader.getSystemResource(String.valueOf(var1_1.toLowerCase()) + this.extensionName[var17_38]);
                            }
                            if (var16_29 != null) break;
                            throw new Exception();
                        }
                        catch (Exception v12) {
                            ++var17_38;
                        }
                    }
                    continue;
                }
lbl333:
                // 3 sources

                if (var16_29 == null) {
                    this.globalImports = null;
                    throw new FileNotFoundException(String.valueOf(SnmpUtils.getString("Could not open file")) + " " + (String)var1_1);
                }
                if (MibOperations.jdbc) {
                    var18_44 = this.getModuleNameDefinition(var16_29.toString());
                    if (!MibOperations.overWriteDataBase && this.jMibOps.isExist((String)var18_44)) {
                        this.jMibOps.put((String)var18_44, var16_29.toString());
                        this.jMibOps.loadJdbcMibModules((String)var18_44);
                        MIBParser.reInitialize();
                        return this.jMibOps.getMibModule((String)var18_44);
                    }
                }
                var8_11 = var16_29.openStream();
                this.mibFileDir = var1_1.substring(0, var1_1.lastIndexOf("/") + 1);
                break block143;
            }
            var16_30 = null;
            var17_39 = null;
            if (!var12_15) {
                try {
                    var16_30 = this.getClass().getClassLoader().getResource(String.valueOf(var1_1) + ".cmi");
                }
                catch (NullPointerException v13) {
                    var16_30 = ClassLoader.getSystemResource(String.valueOf(var1_1) + ".cmi");
                }
            } else {
                try {
                    var16_30 = this.getClass().getClassLoader().getResource((String)var1_1);
                }
                catch (NullPointerException v14) {
                    var16_30 = ClassLoader.getSystemResource((String)var1_1);
                }
            }
            if (var16_30 == null) {
                MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Couldn't open stream for")) + " " + var10_13, 3);
                this.globalImports = null;
                throw new FileNotFoundException(String.valueOf(SnmpUtils.getString("Couldn't open stream for")) + " " + var10_13);
            }
            var8_11 = var16_30.openStream();
            this.mibFileDir = var1_1.substring(0, var1_1.lastIndexOf("/") + 1);
            if (this.isReadDesc()) {
                if (!var12_15) {
                    var13_16 = String.valueOf(var1_1) + ".cds";
                    try {
                        var17_39 = this.getClass().getClassLoader().getResource(var13_16);
                    }
                    catch (NullPointerException v15) {
                        var17_39 = ClassLoader.getSystemResource(var13_16);
                    }
                } else {
                    var13_16 = var1_1.substring(0, var1_1.length() - 3);
                    var13_16 = String.valueOf(var13_16) + "cds";
                    try {
                        var17_39 = this.getClass().getClassLoader().getResource(var13_16);
                    }
                    catch (NullPointerException v16) {
                        var17_39 = ClassLoader.getSystemResource(var13_16);
                    }
                }
                if (var17_39 == null) {
                    MibOperations.debugPrint(String.valueOf(SnmpUtils.getString("Could not open description file")) + " " + var13_16, 1);
                    this.globalImports = null;
                    throw new FileNotFoundException("Could not open description file " + var13_16);
                }
                var9_12 = var17_39.openStream();
            }
        }
        var15_18 = null;
        if (this.justParse) {
            var15_18 = new MibModule((InputStream)var8_11, this);
            var15_18.filename = var1_1;
        } else {
            var15_18 = this.loadModule((InputStream)var8_11, var9_12, var4_4);
            var15_18.filename = var1_1;
            if (this.isReadDesc()) {
                var9_12.close();
                var9_12 = null;
            }
        }
        var8_11.close();
        var8_11 = null;
        if (var4_4 != null && !var15_18.getName().equals(var4_4)) {
            throw new MibException(String.valueOf(SnmpUtils.getString("imported file name")) + " " + var4_4 + " " + SnmpUtils.getString("and module name") + " " + var15_18.getName() + " " + SnmpUtils.getString("mismatch !"));
        }
        var16_20 = this.globalImports.keys();
        while (var16_20.hasMoreElements()) {
            var17_41 = (String)var16_20.nextElement();
            try {
                if (this.modules.get(var17_41) != null || this.getModuleFromGlobalImports(var17_41) != null) continue;
                if (this.mibFileDir.indexOf(" ") != -1) {
                    this.loadMibModule("\"" + this.mibFileDir + var17_41 + "\"" + "&#$*@");
                    continue;
                }
                this.loadMibModule(String.valueOf(this.mibFileDir) + var17_41 + "&#$*@");
            }
            catch (FileNotFoundException var18_46) {
                this.globalImports = null;
                var19_48 = var18_46.getMessage();
                if (var19_48.indexOf("IMPORTS failed:") == -1) {
                    var19_48 = String.valueOf(SnmpUtils.getString("IMPORTS failed:")) + " " + (String)var19_48;
                }
                throw new FileNotFoundException((String)var19_48);
            }
            catch (MibException var18_47) {
                this.globalImports = null;
                var19_48 = var18_47.getMessage();
                if (var19_48.indexOf("IMPORTS failed:") == -1) {
                    var19_48 = String.valueOf(SnmpUtils.getString("IMPORTS failed:")) + " " + (String)var19_48;
                }
                throw new MibException((String)var19_48);
            }
        }
        if (MibOperations.jdbc) {
            var17_42 = "";
            var17_42 = this.searchPath != null ? var7_10 : this.getModuleNameDefinition((String)var1_1);
            if (this.jMibOps.isExist(var17_42)) {
                this.jMibOps.put(var17_42, (String)var1_1);
                this.jMibOps.loadJdbcMibModules(var17_42);
                MIBParser.reInitialize();
                var15_18 = null;
                return this.jMibOps.getMibModule(var17_42);
            }
        }
        var17_43 = this.globalImports.keys();
        while (var17_43.hasMoreElements()) {
            var18_44 = (String)var17_43.nextElement();
            var19_48 = (MibModule)this.modules.get(var18_44);
            if (var19_48 != null) {
                this.resolver.performResolution((MibModule)var19_48);
            } else {
                var19_48 = this.getModuleFromGlobalImports((String)var18_44);
                this.resolver.performResolution((MibModule)var19_48);
            }
            this.resolver.performResolution();
        }
        if (var4_4 == null && !this.globalImports.isEmpty()) {
            this.resolver.performResolution();
        }
        if (var5_5 && this.isSerializeMibs() && !this.isLoadFromSerializedMibs()) {
            this.processSerialization((MibModule)var15_18);
        }
        this.searching = false;
        this.removeModules();
        if (this.isMultipleRevision()) {
            return this.getRevisionModule((MibModule)var15_18);
        }
        return var15_18;
    }

    /*
     * Unable to fully structure code
     */
    public void loadMibModules(Applet var1_1, String var2_2) throws MibException, IOException, FileNotFoundException {
        if (var2_2 == null) {
            return;
        }
        if ((var2_2 = var2_2.trim()).equals("")) {
            return;
        }
        if (!this.justParse && (var2_2.endsWith(".cds") || var2_2.endsWith(".CDS"))) {
            throw new MibException(SnmpUtils.getString("The .cds file could not be loaded."));
        }
        if (this.overWriteCMI && (var2_2.endsWith(".cmi") || var2_2.endsWith(".CMI"))) {
            return;
        }
        if (MibOperations.jdbc) {
            this.jMibOps.tableHash.clear();
        }
        this.setExtensionName();
        var3_3 = null;
        if (var2_2.endsWith("&#$*@")) {
            var2_2 = var2_2.substring(0, var2_2.length() - 5);
            var3_3 = this.getModuleNameFromPath(var2_2);
        } else {
            this.globalImports = new Hashtable<K, V>(1);
        }
        var4_4 = null;
        this.applet = var1_1;
        var5_5 = "\" \t\n\r|";
        var6_6 = new StringTokenizer(var2_2, var5_5, true);
        var7_7 = var6_6.countTokens();
        var8_8 = 0;
        while (var8_8 < var7_7) {
            block18: {
                var9_9 = var6_6.nextToken();
                if (var9_9.equals("\"")) {
                    try {
                        var9_9 = "";
                        var10_10 = var6_6.nextToken();
                        ++var8_8;
                        if (var10_10.equals("\"")) break block18;
                        do {
                            var9_9 = String.valueOf(var9_9) + var10_10;
                            var10_10 = var6_6.nextToken();
                            ++var8_8;
                        } while (!var10_10.equals("\""));
                    }
                    catch (Exception var10_11) {
                        this.globalImports = null;
                        throw new FileNotFoundException(String.valueOf(SnmpUtils.getString("Error parsing quoted filename :")) + " " + var10_11);
                    }
                }
                if (MibOperations.jdbc && MibOperations.overWriteDataBase) {
                    var10_10 = this.getModuleNameDefinition(var9_9);
                    this.jMibOps.unloadMibModule(var10_10);
                }
                if (!MibOperations.jdbc || var9_9.indexOf(var9_9) >= 0) ** GOTO lbl-1000
                var10_10 = this.getModuleNameDefinition(var9_9);
                if (!MibOperations.overWriteDataBase && this.jMibOps.isExist(var10_10)) {
                    this.jMibOps.put(var10_10, var9_9);
                    this.jMibOps.loadJdbcMibModules(var10_10);
                    MIBParser.reInitialize();
                } else if (var5_5.indexOf(var9_9) < 0) {
                    if (var8_8 > 0) {
                        this.loadMibModule(var1_1, String.valueOf(var9_9) + "@*$#&");
                    } else {
                        this.loadMibModule(var1_1, var9_9);
                    }
                }
            }
            ++var8_8;
        }
        this.removeModules();
    }

    public void loadMibModules(String string) throws MibException, IOException, FileNotFoundException {
        if (string == null) {
            return;
        }
        if ((string = string.trim()).equals("")) {
            return;
        }
        if (this.overWriteCMI && (string.endsWith(".cmi") || string.endsWith(".CMI"))) {
            throw new MibException(SnmpUtils.getString("Could not parse the .cmi File"));
        }
        if (!this.justParse && (string.endsWith(".cds") || string.endsWith(".CDS"))) {
            throw new MibException(SnmpUtils.getString("The .cds file could not be loaded."));
        }
        if (jdbc) {
            this.jMibOps.tableHash.clear();
        }
        this.setExtensionName();
        String string2 = "\" \t\n\r|";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            block13: {
                String string3;
                block14: {
                    String string4;
                    block15: {
                        string3 = stringTokenizer.nextToken();
                        if (string3.equals("\"")) {
                            try {
                                string3 = "";
                                string4 = stringTokenizer.nextToken();
                                ++n3;
                                if (string4.equals("\"")) break block13;
                                do {
                                    string3 = String.valueOf(string3) + string4;
                                    string4 = stringTokenizer.nextToken();
                                    ++n3;
                                } while (!string4.equals("\""));
                            }
                            catch (Exception exception) {
                                this.globalImports = null;
                                throw new FileNotFoundException(String.valueOf(SnmpUtils.getString("Error parsing quoted filename :")) + " " + exception);
                            }
                        }
                        if (!jdbc || string2.indexOf(string3) > 0) break block14;
                        string4 = new String(string3);
                        if ((string3 = this.findFileName(string3)) == null) break block15;
                        String string5 = this.getModuleNameDefinition(string3);
                        if (overWriteDataBase || !this.jMibOps.isExist(string5)) break block14;
                        this.jMibOps.put(string5, string3);
                        this.jMibOps.loadJdbcMibModules(string5);
                        MIBParser.reInitialize();
                        break block13;
                    }
                    string3 = string4;
                }
                if (string2.indexOf(string3) < 0) {
                    this.mibFileName = string3;
                    if (n2 > 0) {
                        this.loadMibModule(String.valueOf(string3) + "@*$#&");
                    } else {
                        this.loadMibModule(string3);
                    }
                    ++n2;
                }
            }
            ++n3;
        }
        this.removeModules();
    }

    MibModule loadModule(InputStream inputStream, InputStream inputStream2, String string) throws IOException, MibException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(inputStream2);
        DataInputStream dataInputStream2 = new DataInputStream(bufferedInputStream2);
        if (!this.isVersionOk(dataInputStream, dataInputStream2)) {
            return null;
        }
        String string2 = this.readInitialisers(dataInputStream);
        if (string2 == null) {
            return null;
        }
        MibModule mibModule = (MibModule)this.modules.get(string2);
        if (mibModule == null) {
            this.debugPrint(String.valueOf(SnmpUtils.getString("Loading afresh..")) + string2);
            mibModule = new MibModule(string2, dataInputStream, dataInputStream2, this);
        } else if (string == null) {
            this.modules.remove(string2);
            this.debugPrint(String.valueOf(SnmpUtils.getString("ReLoading ..")) + string2);
            mibModule = new MibModule(string2, dataInputStream, dataInputStream2, this);
        }
        dataInputStream.close();
        dataInputStream = null;
        bufferedInputStream.close();
        bufferedInputStream = null;
        inputStream.close();
        if (this.isReadDesc()) {
            dataInputStream2.close();
            dataInputStream2 = null;
            bufferedInputStream2.close();
            bufferedInputStream2 = null;
            inputStream2.close();
        }
        return mibModule;
    }

    private void processSerialization(MibModule mibModule) throws MibException, IOException, FileNotFoundException {
        mibModule.mibOps = null;
        mibModule.mibOps = new MibOperations();
        mibModule.mibOps.modules = null;
        mibModule.mibOps.modules = new Hashtable();
        mibModule.mibOps.modules.put(mibModule.name, mibModule);
        this.serializImportedModules(mibModule.getImportedModules(), mibModule);
        String string = null;
        if (mibModule.filename != null) {
            string = mibModule.filename.substring(mibModule.filename.lastIndexOf("/") + 1);
            int n = string.indexOf(".");
            if (n != -1) {
                string = string.substring(0, n);
            }
            string = String.valueOf(string) + ".ser";
        }
        if (this.serializedFileName.trim().length() > 0) {
            string = this.serializedFileName;
        }
        if (string == null) {
            string = mibModule.name;
            string = String.valueOf(string) + ".ser";
        }
        this.sfName = string;
        String string2 = mibModule.filename;
        FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(this.mibFileDir) + string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(mibModule);
        objectOutputStream.flush();
        fileOutputStream.close();
        mibModule.filename = string2;
    }

    String readInitialisers(DataInputStream dataInputStream) throws IOException {
        return this.readMibModuleName(dataInputStream);
    }

    String readMibModuleName(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        this.debugPrint(String.valueOf(SnmpUtils.getString("Module Name :")) + string);
        return string;
    }

    void registerImport(String string, MibModule mibModule) {
        Vector<MibModule> vector;
        if (this.globalImports == null) {
            this.globalImports = new Hashtable(1);
        }
        if ((vector = (Vector<MibModule>)this.globalImports.get(string)) != null) {
            vector.addElement(mibModule);
        } else {
            vector = new Vector<MibModule>();
            vector.addElement(mibModule);
            this.globalImports.put(string, vector);
        }
    }

    void registerModule(MibModule mibModule) {
        this.modules.put(mibModule.getName(), mibModule);
    }

    private void removeFromNodeList(String string) {
        if (string == null) {
            return;
        }
        MibModule mibModule = (MibModule)this.modules.get(string);
        if (mibModule != null) {
            Enumeration enumeration = mibModule.nodeList.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                mibModule.nodeList.remove(string2);
            }
        }
    }

    void removeModules() {
        Enumeration enumeration = this.modules.keys();
        String string = "";
        MibModule mibModule = null;
        boolean bl = false;
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            mibModule = (MibModule)this.modules.get(string);
            vector = mibModule.getRootNodes();
            if (vector.size() == 0 && mibModule.getRootNode() == null) {
                bl = true;
            }
            if (!bl || !mibModule.tcList.isEmpty() || !mibModule.trapList.isEmpty()) continue;
            this.modules.remove(string);
        }
    }

    void revertBack() {
        Enumeration enumeration = this.getMibModuleNames();
        String string = "";
        String string2 = "";
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!string2.endsWith("!##$##!")) continue;
            string = string2.substring(0, string2.indexOf("!##$##!"));
            if (jdbc) {
                this.jMibOps.updateModuleRevisionName(string2, string);
                this.jMibOps.moduleVector.removeElement(string2);
                this.jMibOps.moduleVector.addElement(string);
                continue;
            }
            this.modules.put(string, (MibModule)this.modules.get(string2));
            this.modules.remove(string2);
        }
    }

    private void serializImportedModules(String string, MibModule mibModule) {
        try {
            if (string == null && string.trim().equals("")) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    String string2 = stringTokenizer.nextToken();
                    MibModule mibModule2 = (MibModule)this.modules.get(string2);
                    this.serializImportedModules(mibModule2.getImportedModules(), mibModule);
                    mibModule2.mibOps = null;
                    mibModule.mibOps.modules.put(string2, mibModule2);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
    }

    public void setDatabaseName(byte by) {
        if (by > 0 && by < 4) {
            this.dbType = by;
        } else {
            System.err.println("setting the wrong database ");
        }
    }

    public void setDebug(boolean bl) {
        errMsg = bl;
    }

    public static void setDebugMessageLevel(int n) {
        allowedLevel = n;
    }

    void setErrMsg(boolean bl) {
        errMsg = bl;
    }

    void setExtensionName() {
        if (this.extFlag) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.extensionNames, ",.", false);
        int n = 1;
        this.extensionName = new String[stringTokenizer.countTokens() + 1];
        this.extensionName[0] = "";
        while (stringTokenizer.hasMoreTokens()) {
            this.extensionName[n++] = "." + stringTokenizer.nextToken();
        }
        this.extFlag = false;
    }

    public void setIgnoreSpecificControlCodes(boolean bl) {
        this.ignoreSpecificControlCodes = bl;
    }

    public void setLoadFromCompiledMibs(boolean bl) {
        this.justParse = bl ^ true;
    }

    public void setLoadFromDatabase(boolean bl) {
        this.database = bl;
        jdbc = bl;
        SASClient sASClient = SnmpAPI.getSASClient();
        if (jdbc && sASClient != null) {
            if (this.jMibOps == null) {
                this.jMibOps = new JdbcMibOperations(this);
            }
        } else if (jdbc && this.jMibOps.stmt == null) {
            this.jMibOps.stmt = SnmpAPI.getStatement();
            stmt = this.jMibOps.stmt;
            if (stmt != null && this.jMibOps == null) {
                this.jMibOps = new JdbcMibOperations(this);
            } else {
                jdbc = false;
                this.database = false;
                System.out.println(SnmpUtils.getString("Connection not established"));
            }
        }
    }

    public void setLoadFromSerializedMibs(boolean bl) {
        this.loadFromSerializedMibs = bl;
    }

    public void setMibFileExtension(String string) {
        this.extensionNames = String.valueOf(string) + "," + this.extensionNames;
    }

    public void setMibPath(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.searchPath = "";
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            this.searchPath = String.valueOf(this.searchPath) + "|" + string2;
        }
    }

    public void setMultipleRevision(String string) {
        if (jdbc) {
            this.jMibOps.setMultipleRevision(string);
        } else {
            this.multipleRevision = string;
        }
    }

    public void setOverwriteCMI(boolean bl) {
        this.overWrite = bl;
        this.overWriteCMI = bl;
    }

    public void setOverwriteDatabase(boolean bl) {
        overWriteDataBase = bl;
    }

    public void setReadDesc(boolean bl) {
        this.isDescRead = bl;
    }

    public void setSerializeMibs(boolean bl) {
        this.serializeMibs = bl;
    }

    public void setSerializedMibFileName(String string) {
        this.serializedFileName = string;
        this.sfName = string;
    }

    public void setShowImportedIndex(boolean bl) {
        this.showImportedIndex = bl;
    }

    public void setThrowFileNotFound(boolean bl) {
        this.throwFileNotFound = bl;
    }

    private static void stdNodes() {
        standardNodes = new Vector(14);
        standardNodes.addElement("org");
        standardNodes.addElement("dod");
        standardNodes.addElement("internet");
        standardNodes.addElement("directory");
        standardNodes.addElement("mgmt");
        standardNodes.addElement("experimental");
        standardNodes.addElement("private");
        standardNodes.addElement("snmpV2");
        standardNodes.addElement("enterprises");
        standardNodes.addElement("mib-2");
        standardNodes.addElement("snmpDomains");
        standardNodes.addElement("snmpProxys");
        standardNodes.addElement("snmpModules");
        standardNodes.addElement("transmission");
    }

    String subidString(int n) {
        long l = (long)n & Integer.MAX_VALUE;
        if (n < 0) {
            l += 0x80000000L;
        }
        return Long.toString(l);
    }

    public String toByteString(SnmpPDU snmpPDU) {
        this.toBytes = true;
        return this.toString(snmpPDU);
    }

    public String toByteString(SnmpVar snmpVar, SnmpOID snmpOID) {
        this.toBytes = true;
        return this.toString(snmpVar, snmpOID);
    }

    public String toByteString(SnmpVarBind snmpVarBind) {
        this.toBytes = true;
        return this.toString(snmpVarBind);
    }

    public String toShortString(SnmpOID snmpOID) {
        return this.toShortString(snmpOID, this.getMibNode(snmpOID));
    }

    private String toShortString(SnmpOID snmpOID, MibNode mibNode) {
        if (snmpOID == null) {
            return null;
        }
        if (mibNode == null) {
            return snmpOID.toString();
        }
        return String.valueOf(mibNode.getLabel()) + this.getInstanceString(snmpOID, mibNode);
    }

    public String toString(SnmpOID snmpOID) {
        if (snmpOID == null) {
            return null;
        }
        MibNode mibNode = this.getNearestNode(snmpOID);
        return this.toString(snmpOID, mibNode);
    }

    String toString(SnmpOID snmpOID, MibNode mibNode) {
        if (mibNode == null) {
            return snmpOID.toString();
        }
        return String.valueOf(mibNode.getOIDString()) + this.getInstanceString(snmpOID, mibNode);
    }

    public String toString(SnmpPDU snmpPDU) {
        StringBuffer stringBuffer = new StringBuffer();
        if (snmpPDU.getCommand() == -96) {
            stringBuffer.append(String.valueOf(SnmpUtils.getString("SNMP Get Request PDU")) + "\n");
        } else if (snmpPDU.getCommand() == -95) {
            stringBuffer.append(String.valueOf(SnmpUtils.getString("SNMP Get Next Request PDU")) + "\n");
        } else if (snmpPDU.getCommand() == -94) {
            stringBuffer.append(String.valueOf(SnmpUtils.getString("SNMP Get Response PDU")) + "\n");
        } else if (snmpPDU.getCommand() == -93) {
            stringBuffer.append(String.valueOf(SnmpUtils.getString("SNMP Set Request PDU")) + "\n");
        } else if (snmpPDU.getCommand() == -92) {
            stringBuffer.append(String.valueOf(SnmpUtils.getString("SNMP Trap PDU")) + "\n");
        } else {
            stringBuffer.append(String.valueOf(SnmpUtils.getString("SNMP PDU (type unknown/unspecified)")) + "\n");
        }
        if (snmpPDU.getVersion() == 0) {
            stringBuffer.append(String.valueOf(SnmpUtils.getString("SNMP Version: Version 1")) + "\n");
        } else {
            stringBuffer.append(String.valueOf(SnmpUtils.getString("SNMP Version:")) + " " + snmpPDU.getVersion() + "\n");
        }
        if (snmpPDU.getRemoteHost() != null) {
            stringBuffer.append(String.valueOf(SnmpUtils.getString("Remote Host:")) + " " + snmpPDU.getRemoteHost() + "\n");
        } else if (snmpPDU.getAddress() != null) {
            stringBuffer.append(String.valueOf(SnmpUtils.getString("Remote Address:")) + " " + snmpPDU.getAddress() + "\n");
        }
        stringBuffer.append(String.valueOf(SnmpUtils.getString("Remote Port:")) + " " + snmpPDU.getRemotePort() + "\n");
        stringBuffer.append(String.valueOf(SnmpUtils.getString("Community:")) + " " + snmpPDU.getCommunity() + "\n");
        stringBuffer.append(String.valueOf(SnmpUtils.getString("Request ID:")) + " " + snmpPDU.getReqid() + "\n");
        stringBuffer.append(String.valueOf(SnmpUtils.getString("Timeout:")) + " " + snmpPDU.getTimeout() + "\n");
        stringBuffer.append("Retries: " + snmpPDU.getRetries() + "\n");
        if (snmpPDU.getCommand() == -92) {
            stringBuffer.append(String.valueOf(SnmpUtils.getString("Enterprise:")) + " " + snmpPDU.getEnterprise() + "\n");
            stringBuffer.append(String.valueOf(SnmpUtils.getString("Trap Type:")) + " " + snmpPDU.getTrapType() + "\n");
            stringBuffer.append(String.valueOf(SnmpUtils.getString("Specific Type:")) + " " + snmpPDU.getSpecificType() + "\n");
            stringBuffer.append(String.valueOf(SnmpUtils.getString("UpTime:")) + " " + snmpPDU.getUpTime() + "\n");
        }
        if (snmpPDU.getCommand() == -94) {
            stringBuffer.append(String.valueOf(SnmpUtils.getString("Round Trip Delay:")) + " " + snmpPDU.getRoundTripDelay() + " ms\n");
        }
        if (snmpPDU.getErrstat() == 0) {
            stringBuffer.append(String.valueOf(SnmpUtils.getString("Error Status: no error")) + "\n");
        } else {
            stringBuffer.append(String.valueOf(SnmpUtils.getString("Error Status:")) + " " + SnmpException.exceptionString((byte)snmpPDU.getErrstat()) + "\n");
            stringBuffer.append(String.valueOf(SnmpUtils.getString("Error Index:")) + " " + snmpPDU.getErrindex() + "\n");
        }
        stringBuffer.append(this.varBindsToString(snmpPDU));
        return stringBuffer.toString();
    }

    public String toString(SnmpVar snmpVar, SnmpOID snmpOID) {
        if (snmpVar == null) {
            return null;
        }
        return this.toString(snmpVar, snmpOID, null, true);
    }

    private String toString(SnmpVar snmpVar, SnmpOID snmpOID, MibNode mibNode, boolean bl) {
        if (snmpVar == null) {
            return null;
        }
        if (snmpVar instanceof SnmpOID) {
            return this.toString((SnmpOID)snmpVar);
        }
        if (mibNode == null && bl) {
            boolean bl2;
            boolean bl3 = bl2 = snmpVar instanceof SnmpInt || snmpVar.getType() == 4;
            if (bl2) {
                mibNode = this.getMibNode(snmpOID);
            }
        }
        if (mibNode == null) {
            return this.getVarString(snmpVar, false);
        }
        if (mibNode.isLeaf()) {
            int n;
            Object object;
            LeafSyntax leafSyntax = mibNode.getSyntax();
            if (snmpVar instanceof SnmpInt && leafSyntax.isEnumerated() && (object = leafSyntax.getLabel(n = ((SnmpInt)snmpVar).intValue())) != null) {
                return String.valueOf(object) + "(" + n + ")";
            }
            if (snmpVar.getType() == 4) {
                String string;
                if (leafSyntax.getEquivname().equals("BITS")) {
                    while (!leafSyntax.getName().equals("BITS")) {
                        leafSyntax = leafSyntax.getSyntax();
                    }
                }
                if ((string = leafSyntax.getName()).equals("BITS")) {
                    object = snmpVar.toBytes();
                    int n2 = ((Object)object).length;
                    Vector vector = new Vector();
                    int n3 = 0;
                    String string2 = "";
                    int n4 = 0;
                    while (n4 < n2) {
                        Object object2 = object[n4];
                        int n5 = 0;
                        while (n5 < 8) {
                            if ((object2 & 0x80) == 128) {
                                string2 = String.valueOf(string2) + leafSyntax.getLabel(n3) + "(" + n3 + ") , ";
                            }
                            object2 = (byte)(object2 << 1);
                            ++n3;
                            ++n5;
                        }
                        ++n4;
                    }
                    if (!string2.equals("")) {
                        return string2.substring(0, string2.length() - 3);
                    }
                }
                if (string.equals("DateAndTime")) {
                    object = null;
                    try {
                        object = new SnmpDateAndTime(new String(snmpVar.toBytes()));
                    }
                    catch (Exception exception) {
                        try {
                            object = new SnmpDateAndTime(snmpVar.toBytes());
                        }
                        catch (Exception exception2) {
                            return snmpVar.toString();
                        }
                    }
                    if (object != null) {
                        return ((SnmpDateAndTime)object).toString();
                    }
                    return snmpVar.toString();
                }
                if (string.equals("MacAddress")) {
                    return this.getVarString(snmpVar, true);
                }
                if (string.equals("DisplayString")) {
                    return snmpVar.toString();
                }
            }
        }
        return this.getVarString(snmpVar, false);
    }

    public String toString(SnmpVarBind snmpVarBind) {
        if (snmpVarBind == null) {
            return null;
        }
        SnmpVar snmpVar = snmpVarBind.getVariable();
        SnmpOID snmpOID = snmpVarBind.getObjectID();
        MibNode mibNode = this.getMibNode(snmpOID);
        return String.valueOf(this.toShortString(snmpOID, mibNode)) + ":" + this.toString(snmpVar, snmpOID, mibNode, false);
    }

    public String toTagString(SnmpVarBind snmpVarBind) {
        if (snmpVarBind == null) {
            return null;
        }
        SnmpVar snmpVar = snmpVarBind.getVariable();
        SnmpOID snmpOID = snmpVarBind.getObjectID();
        StringBuffer stringBuffer = new StringBuffer();
        MibNode mibNode = this.getNearestNode(snmpOID);
        stringBuffer.append(String.valueOf(SnmpUtils.getString("Object ID:")) + " " + this.toString(snmpOID, mibNode) + "\n");
        stringBuffer.append(String.valueOf(snmpVar.getTypeString()) + ": " + this.toString(snmpVar, snmpOID, mibNode, false) + "\n");
        return stringBuffer.toString();
    }

    Vector toVector(String string) {
        Vector<String> vector = new Vector<String>();
        if (string.charAt(0) != '.') {
            string = new String(String.valueOf(SnmpAPI.Standard_Prefix) + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }

    public void unloadAllMibModules() {
        if (jdbc) {
            this.jMibOps.unloadAllMibModules();
        }
        Enumeration enumeration = this.getMibModuleNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.removeFromNodeList(string);
            MibModule mibModule = (MibModule)this.modules.remove(string);
        }
        if (!jdbc) {
            this.revisionFileNames.removeAllElements();
        }
    }

    public boolean unloadMibModule(MibModule mibModule) {
        if (jdbc) {
            this.jMibOps.unloadMibModule(mibModule);
        }
        return this.unloadMibModule(mibModule.getName()) != null;
    }

    public MibModule unloadMibModule(String string) {
        if (jdbc) {
            return this.jMibOps.unloadMibModule(string);
        }
        this.removeFromNodeList(string);
        MibModule mibModule = (MibModule)this.modules.remove(string);
        if (mibModule != null && !jdbc) {
            this.revisionFileNames.removeElement(mibModule.filename);
        }
        return mibModule;
    }

    boolean validateUrl(HttpURLConnection httpURLConnection) throws IOException {
        return httpURLConnection.getResponseCode() == 200;
    }

    public String varBindsToString(SnmpPDU snmpPDU) {
        if (snmpPDU == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(SnmpUtils.getString("SNMP PDU Variable Bindings:")) + " \n");
        Enumeration enumeration = snmpPDU.getVariableBindings().elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(this.toTagString((SnmpVarBind)enumeration.nextElement()));
        }
        return stringBuffer.toString();
    }
}

