/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs;

import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.mibs.mibparser.CommentClass;
import com.adventnet.snmp.mibs.mibparser.SyntaxTrapType;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.utils.SnmpUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class MibTrap
implements Serializable {
    String moduleName = null;
    MibModule module = null;
    String name;
    int value;
    SnmpOID enterprise;
    String enterpriseString;
    Vector variables;
    String description;
    String reference;
    CommentClass commentObj = null;

    MibTrap() {
    }

    public String getDescription() {
        return this.description;
    }

    public SnmpOID getEnterprise() {
        if (this.enterprise != null) {
            return this.enterprise;
        }
        MibNode mibNode = this.module.getMibNodeByName(this.enterpriseString);
        if (mibNode != null) {
            this.enterprise = new SnmpOID(mibNode.getNumberedOIDString());
        }
        return this.enterprise;
    }

    public String getEnterpriseString() {
        return this.enterpriseString;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getName() {
        return this.name;
    }

    public String getReference() {
        return this.reference;
    }

    public byte getTrapType() {
        if (this.getEnterpriseString().trim().equals("snmp")) {
            return 0;
        }
        return 1;
    }

    public int getValue() {
        return this.value;
    }

    public Vector getVariables() {
        return this.variables;
    }

    void readElements(SyntaxTrapType syntaxTrapType, MibModule mibModule) {
        this.commentObj = new CommentClass();
        this.module = mibModule;
        this.moduleName = mibModule.getName();
        this.name = syntaxTrapType.getName();
        this.description = syntaxTrapType.getDescription();
        this.reference = syntaxTrapType.getReference();
        this.enterpriseString = syntaxTrapType.getEnterprise().getName();
        this.variables = syntaxTrapType.getVariables();
        this.value = syntaxTrapType.getNumber();
        this.commentObj.node = syntaxTrapType.commentObj.node;
        this.commentObj.objType = syntaxTrapType.commentObj.objType;
        this.commentObj.description = syntaxTrapType.commentObj.description;
        this.commentObj.reference = syntaxTrapType.commentObj.reference;
        this.commentObj.commentStr = syntaxTrapType.commentObj.commentStr;
    }

    void readElements(DataInputStream dataInputStream, MibModule mibModule) throws IOException {
        this.commentObj = new CommentClass();
        this.module = mibModule;
        this.moduleName = mibModule.getName();
        this.name = dataInputStream.readUTF();
        if (MibOperations.errMsg) {
            System.err.println(String.valueOf(SnmpUtils.getString("Read in trap name :")) + this.name);
        }
        this.description = mibModule.readNextDesc();
        this.reference = mibModule.readNextDesc();
        if (MibOperations.errMsg) {
            System.err.println(String.valueOf(SnmpUtils.getString("Read in trap description :")) + this.description);
            System.err.println(String.valueOf(SnmpUtils.getString("Read in trap reference :")) + this.reference);
        }
        this.enterpriseString = dataInputStream.readUTF();
        if (MibOperations.errMsg) {
            System.err.println(String.valueOf(SnmpUtils.getString("Read in trap enterprise :")) + this.enterpriseString);
        }
        int n = dataInputStream.readInt();
        if (this.variables == null) {
            this.variables = new Vector();
        }
        int n2 = 0;
        while (n2 < n) {
            if (MibOperations.errMsg) {
                System.err.println(String.valueOf(SnmpUtils.getString("Will read")) + " " + n + " " + SnmpUtils.getString("object variables"));
            }
            this.variables.addElement(dataInputStream.readUTF());
            ++n2;
        }
        this.value = dataInputStream.readInt();
        this.commentObj.node = mibModule.readNextDesc();
        this.commentObj.objType = mibModule.readNextDesc();
        this.commentObj.description = mibModule.readNextDesc();
        this.commentObj.reference = mibModule.readNextDesc();
        this.commentObj.commentStr = mibModule.readNextDesc();
    }

    public String toString() {
        return this.name;
    }

    public String toTagString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.name) + " " + SnmpUtils.getString("TRAP-TYPE"));
        if (this.enterprise != null) {
            stringBuffer.append("\n\t" + SnmpUtils.getString("ENTERPRISE") + "\t" + this.enterprise);
        } else if (this.enterpriseString != null) {
            stringBuffer.append("\n\t" + SnmpUtils.getString("ENTERPRISE") + "\t" + this.enterpriseString);
        }
        if (this.variables != null) {
            stringBuffer.append("\n\t" + SnmpUtils.getString("VARIABLES") + "\t{ ");
            Enumeration enumeration = this.variables.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(String.valueOf(String.valueOf(enumeration.nextElement())) + " ");
            }
            stringBuffer.append("}");
        }
        if (this.description != null) {
            stringBuffer.append("\n\t" + SnmpUtils.getString("DESCRIPTION") + "\t" + this.description);
        }
        if (this.reference != null) {
            stringBuffer.append("\n\t" + SnmpUtils.getString("REFERENCE") + "\t" + this.reference);
        }
        stringBuffer.append("\n\t::=\t" + this.value);
        return stringBuffer.toString();
    }
}

