/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs;

import com.adventnet.utils.SnmpUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;

class RangeList
implements Cloneable,
Serializable {
    boolean isRanged;
    long[] values;
    String[] labels;
    long[] max;
    long[] min;
    boolean[] rangetype;
    boolean preDefinedRange = false;
    boolean addSizeTag = true;
    int labelcount = 0;
    int rangecount = 0;

    public RangeList(int n, boolean bl) {
        this.isRanged = bl ^ true;
        if (this.isRanged) {
            this.max = new long[n];
            this.min = new long[n];
            this.rangetype = new boolean[n];
        } else {
            this.values = new long[n];
            this.labels = new String[n];
        }
    }

    public void addEnum(String string, long l) {
        this.labels[this.labelcount] = string;
        this.values[this.labelcount] = l;
        ++this.labelcount;
    }

    public void addRange(long l) {
        this.isRanged = true;
        this.max[this.rangecount] = l;
        this.min[this.rangecount] = l;
        this.rangetype[this.rangecount] = false;
        ++this.rangecount;
    }

    public void addRange(long l, long l2) {
        this.max[this.rangecount] = l;
        this.min[this.rangecount] = l2;
        this.rangetype[this.rangecount] = true;
        ++this.rangecount;
    }

    protected Object clone() throws CloneNotSupportedException {
        RangeList rangeList = (RangeList)super.clone();
        if (this.values != null) {
            rangeList.values = (long[])this.values.clone();
        }
        if (this.labels != null) {
            rangeList.labels = (String[])this.labels.clone();
        }
        if (this.max != null) {
            rangeList.max = (long[])this.max.clone();
        }
        if (this.min != null) {
            rangeList.min = (long[])this.min.clone();
        }
        if (this.rangetype != null) {
            rangeList.rangetype = (boolean[])this.rangetype.clone();
        }
        return rangeList;
    }

    public void expandSize(int n, boolean bl) {
        if (bl) {
            long[] lArray = new long[n];
            long[] lArray2 = new long[n];
            boolean[] blArray = new boolean[n];
            this.max = lArray;
            this.min = lArray2;
            this.rangetype = blArray;
        } else {
            long[] lArray = new long[n];
            String[] stringArray = new String[n];
            this.values = lArray;
            this.labels = stringArray;
        }
    }

    public int getEnumInt(String string) {
        if (this.isEnumerated()) {
            int n = 0;
            while (n < this.labelcount) {
                if (this.labels[n].equals(string)) {
                    return (int)this.values[n];
                }
                ++n;
            }
        }
        return -1;
    }

    public int[] getEnumint() {
        if (this.isEnumerated()) {
            int[] nArray = new int[this.values.length];
            int n = 0;
            while (n < this.values.length) {
                nArray[n] = (int)this.values[n];
                ++n;
            }
            return nArray;
        }
        return null;
    }

    public String[] getEnumlabels() {
        if (this.isEnumerated()) {
            return (String[])this.labels.clone();
        }
        return null;
    }

    public static RangeList getInstance(com.adventnet.snmp.mibs.mibparser.RangeList rangeList, RangeList rangeList2) {
        block5: {
            int n;
            boolean bl;
            boolean bl2;
            block4: {
                bl2 = rangeList.isRanged();
                bl = rangeList.isEnumerated();
                n = 0;
                if (!bl) break block4;
                n = rangeList.labelcount;
                rangeList2 = new RangeList(n, bl);
                rangeList2.preDefinedRange = rangeList.preDefinedRange;
                int n2 = 0;
                while (n2 < n) {
                    String string = rangeList.labels[n2];
                    long l = rangeList.values[n2];
                    rangeList2.addEnum(string, l);
                    ++n2;
                }
                break block5;
            }
            if (!bl2) break block5;
            n = rangeList.rangecount;
            rangeList2 = new RangeList(n, bl);
            rangeList2.preDefinedRange = rangeList.preDefinedRange;
            int n3 = 0;
            while (n3 < n) {
                boolean bl3 = rangeList.rangetype[n3];
                long l = rangeList.max[n3];
                long l2 = rangeList.min[n3];
                if (bl3) {
                    rangeList2.addRange(l, l2);
                } else {
                    rangeList2.addRange(l);
                }
                ++n3;
            }
        }
        return rangeList2;
    }

    static RangeList getInstance(DataInputStream dataInputStream) throws IOException {
        return RangeList.getInstance(dataInputStream, null);
    }

    public static RangeList getInstance(DataInputStream dataInputStream, RangeList rangeList) throws IOException {
        block5: {
            int n;
            boolean bl;
            block4: {
                boolean bl2 = dataInputStream.readBoolean();
                bl = dataInputStream.readBoolean();
                boolean bl3 = dataInputStream.readBoolean();
                n = dataInputStream.readInt();
                rangeList = new RangeList(n, bl3);
                rangeList.preDefinedRange = bl2;
                if (!bl3) break block4;
                int n2 = 0;
                while (n2 < n) {
                    String string = dataInputStream.readUTF();
                    long l = dataInputStream.readLong();
                    rangeList.addEnum(string, l);
                    ++n2;
                }
                break block5;
            }
            if (!bl) break block5;
            int n3 = 0;
            while (n3 < n) {
                boolean bl4 = dataInputStream.readBoolean();
                long l = dataInputStream.readLong();
                long l2 = dataInputStream.readLong();
                if (bl4) {
                    rangeList.addRange(l, l2);
                } else {
                    rangeList.addRange(l);
                }
                ++n3;
            }
        }
        return rangeList;
    }

    public String getLabel(long l) {
        if (this.isEnumerated()) {
            int n = 0;
            while (n < this.labelcount) {
                if (this.values[n] == l) {
                    return this.labels[n];
                }
                ++n;
            }
        }
        return null;
    }

    boolean getRange(String string) {
        if (this.isEnumerated()) {
            int n;
            int n2 = 0;
            int n3 = string.length();
            if (n3 <= this.labelcount + (8 - ((n = this.labelcount % 8) == 0 ? 8 : n))) {
                int n4 = 0;
                while (n4 < n3) {
                    char c = string.charAt(n4);
                    if (c == '0' || c == '1') {
                        if (c == '1') {
                            n2 = n4 + 1;
                        }
                    } else {
                        return false;
                    }
                    ++n4;
                }
                if (n2 <= this.labelcount) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isEnumerated() {
        return this.isRanged ^ true;
    }

    public boolean isRanged() {
        return this.isRanged;
    }

    public boolean isValid(long l) {
        block5: {
            block4: {
                if (!this.isEnumerated()) break block4;
                int n = 0;
                while (n < this.labelcount) {
                    if (this.values[n] == l) {
                        return true;
                    }
                    ++n;
                }
                break block5;
            }
            if (!this.isRanged()) break block5;
            int n = 0;
            while (n < this.rangecount) {
                if (this.rangetype[n] ? l <= this.max[n] && l >= this.min[n] : l == this.max[n]) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean isValid(String string) {
        if (this.isEnumerated()) {
            return this.getEnumInt(string) != -1;
        }
        return this.isValid(string.length());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isRanged()) {
            if (this.addSizeTag) {
                stringBuffer.append(" ( " + SnmpUtils.getString("SIZE") + " ( ");
            } else {
                stringBuffer.append(" ( ");
            }
            int n = 0;
            while (n < this.rangecount) {
                if (this.rangetype[n]) {
                    stringBuffer.append(String.valueOf(this.min[n]) + " .. " + this.max[n] + " ");
                } else {
                    stringBuffer.append(String.valueOf(this.max[n]) + " ");
                }
                if (++n >= this.rangecount) continue;
                stringBuffer.append("| ");
            }
            if (this.addSizeTag) {
                stringBuffer.append(" ) ) ");
            } else {
                stringBuffer.append(" ) ");
            }
            return stringBuffer.toString();
        }
        if (this.isEnumerated()) {
            stringBuffer.append(" { ");
            int n = 0;
            while (n < this.labelcount) {
                stringBuffer.append(String.valueOf(this.labels[n]) + " ( " + this.values[n] + " ) ");
                if (++n >= this.labelcount) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("} ");
            return stringBuffer.toString();
        }
        return "";
    }
}

