/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs;

import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.utils.SnmpUtils;
import java.io.Serializable;
import java.util.StringTokenizer;

class SnmpDateAndTime
implements Serializable {
    byte[] byteArr = null;
    String dateStr = null;

    public SnmpDateAndTime(String string) {
        if (string.startsWith("'") && string.endsWith("'") && string.indexOf(":") != -1) {
            String string2 = string.substring(1, string.length() - 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            byte[] byArray = new byte[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                byArray[n] = (byte)Integer.parseInt(string2, 16);
                ++n;
            }
            byte[] byArray2 = this.properArray(byArray);
            this.dateStr = this.convBytesToString(byArray2);
            int n2 = byArray2.length;
            this.byteArr = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.byteArr, 0, byArray.length);
        } else {
            this.dateStr = string;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            if (stringTokenizer.countTokens() < 2) {
                throw new IllegalArgumentException("Invalid DateAndTime value: the date, time and optional UTC direction values should be present in the DateAndTime value :" + string);
            }
            if (stringTokenizer.countTokens() > 3) {
                throw new IllegalArgumentException("Invalid DateAndTime value: only the date, time and utc direction values are allowed :" + string);
            }
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "-");
            if (stringTokenizer2.countTokens() != 3) {
                throw new IllegalArgumentException("Wrong number of Date arguments: The year, month and day values should be present in the DateAndTime value :" + string3);
            }
            int n = Integer.parseInt(stringTokenizer2.nextToken());
            this.isValidYear(n);
            String string4 = Integer.toHexString(n);
            StringBuffer stringBuffer = new StringBuffer(string4);
            int n3 = 0;
            while (n3 < 4 - string4.length()) {
                stringBuffer.insert(0, 0);
                ++n3;
            }
            string4 = stringBuffer.toString();
            int n4 = Integer.parseInt(stringTokenizer2.nextToken());
            this.isValidMonth(n4);
            String string5 = Integer.toHexString(n4);
            stringBuffer = new StringBuffer(string5);
            int n5 = 0;
            while (n5 < 2 - string5.length()) {
                stringBuffer.insert(0, 0);
                ++n5;
            }
            string5 = stringBuffer.toString();
            int n6 = Integer.parseInt(stringTokenizer2.nextToken());
            this.isValidDay(n6);
            String string6 = Integer.toHexString(n6);
            stringBuffer = new StringBuffer(string6);
            int n7 = 0;
            while (n7 < 2 - string6.length()) {
                stringBuffer.insert(0, 0);
                ++n7;
            }
            string6 = stringBuffer.toString();
            String string7 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer3 = new StringTokenizer(string7, ":.");
            if (stringTokenizer3.countTokens() != 4) {
                throw new IllegalArgumentException("Wrong number of Time arguments: the hour,minute,second and decisecond values should be present in the DateAndTime value :" + string7);
            }
            int n8 = Integer.parseInt(stringTokenizer3.nextToken());
            this.isValidHour(n8);
            String string8 = Integer.toHexString(n8);
            stringBuffer = new StringBuffer(string8);
            int n9 = 0;
            while (n9 < 2 - string8.length()) {
                stringBuffer.insert(0, 0);
                ++n9;
            }
            string8 = stringBuffer.toString();
            int n10 = Integer.parseInt(stringTokenizer3.nextToken());
            this.isValidMin(n10);
            String string9 = Integer.toHexString(n10);
            stringBuffer = new StringBuffer(string9);
            int n11 = 0;
            while (n11 < 2 - string9.length()) {
                stringBuffer.insert(0, 0);
                ++n11;
            }
            string9 = stringBuffer.toString();
            int n12 = Integer.parseInt(stringTokenizer3.nextToken());
            this.isValidSec(n12);
            String string10 = Integer.toHexString(n12);
            stringBuffer = new StringBuffer(string10);
            int n13 = 0;
            while (n13 < 2 - string10.length()) {
                stringBuffer.insert(0, 0);
                ++n13;
            }
            string10 = stringBuffer.toString();
            int n14 = Integer.parseInt(stringTokenizer3.nextToken());
            this.isValidDsec(n14);
            String string11 = Integer.toHexString(n14);
            stringBuffer = new StringBuffer(string11);
            int n15 = 0;
            while (n15 < 2 - string11.length()) {
                stringBuffer.insert(0, 0);
                ++n15;
            }
            string11 = stringBuffer.toString();
            String string12 = null;
            if (stringTokenizer.hasMoreTokens()) {
                String string13 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer4 = new StringTokenizer(string13, ":");
                if (stringTokenizer4.countTokens() != 2) {
                    throw new IllegalArgumentException("Wrong number of UTC arguments : the hour and minutes values should be present in the DateAndTime value :" + string13);
                }
                String string14 = null;
                int n16 = 32;
                if (string13.indexOf("+") != -1) {
                    string14 = "2b";
                    n16 = 43;
                } else if (string13.indexOf("-") != -1) {
                    string14 = "2d";
                    n16 = 45;
                }
                this.isValidDir((char)n16);
                string13 = string13.substring(1);
                StringTokenizer stringTokenizer5 = new StringTokenizer(string13, ":");
                int n17 = Integer.parseInt(stringTokenizer5.nextToken());
                this.isValidHutc(n17);
                String string15 = Integer.toHexString(n17);
                stringBuffer = new StringBuffer(string15);
                int n18 = 0;
                while (n18 < 2 - string15.length()) {
                    stringBuffer.insert(0, 0);
                    ++n18;
                }
                string15 = stringBuffer.toString();
                int n19 = Integer.parseInt(stringTokenizer5.nextToken());
                this.isValidMutc(n19);
                String string16 = Integer.toHexString(n19);
                stringBuffer = new StringBuffer(string16);
                int n20 = 0;
                while (n20 < 2 - string16.length()) {
                    stringBuffer.insert(0, 0);
                    ++n20;
                }
                string16 = stringBuffer.toString();
                this.byteArr = new byte[11];
                string12 = String.valueOf(string4) + string5 + string6 + string8 + string9 + string10 + string11 + string14 + string15 + string16;
            } else {
                this.byteArr = new byte[8];
                string12 = String.valueOf(string4) + string5 + string6 + string8 + string9 + string10 + string11;
            }
            int n21 = 0;
            while (n21 < string12.length() - 1) {
                this.byteArr[n21 / 2] = (byte)Integer.parseInt(string12.substring(n21, n21 + 2), 16);
                n21 += 2;
            }
        }
    }

    SnmpDateAndTime(byte[] byArray) {
        byte[] byArray2 = this.properArray(byArray);
        this.dateStr = this.convBytesToString(byArray2);
        int n = byArray.length;
        this.byteArr = new byte[n];
        System.arraycopy(byArray, 0, this.byteArr, 0, byArray.length);
    }

    byte[] byteValue() {
        return this.byteArr;
    }

    String convBytesToString(byte[] byArray) throws IllegalArgumentException {
        int n = byArray.length;
        if (n != 16 && n != 22) {
            new MibOperations().debugPrint(SnmpUtils.getString("Exception:SnmpDataAndTime:The byte [] length should be either 8 or 11"));
            throw new IllegalArgumentException(SnmpUtils.getString("The byte [] length should be either 8 or 11"));
        }
        String string = "";
        int n2 = byArray[0] * 4096 + byArray[1] * 256 + byArray[2] * 16 + byArray[3];
        this.isValidYear(n2);
        string = String.valueOf(string) + n2 + "-";
        int n3 = byArray[4] * 16 + byArray[5];
        this.isValidMonth(n3);
        string = String.valueOf(string) + n3 + "-";
        int n4 = byArray[6] * 16 + byArray[7];
        this.isValidDay(n4);
        string = String.valueOf(string) + n4 + ",";
        int n5 = byArray[8] * 16 + byArray[9];
        this.isValidHour(n5);
        string = String.valueOf(string) + n5 + ":";
        int n6 = byArray[10] * 16 + byArray[11];
        this.isValidMin(n6);
        string = String.valueOf(string) + n6 + ":";
        int n7 = byArray[12] * 16 + byArray[13];
        this.isValidSec(n7);
        string = String.valueOf(string) + n7 + ".";
        int n8 = byArray[14] * 16 + byArray[15];
        this.isValidDsec(n8);
        string = String.valueOf(string) + n8;
        if (n > 16 && n != 32) {
            string = String.valueOf(string) + ",";
            char c = (char)(byArray[16] * 16 + byArray[17]);
            this.isValidDir(c);
            string = String.valueOf(string) + c;
            int n9 = byArray[18] * 16 + byArray[19];
            this.isValidHutc(n9);
            string = String.valueOf(string) + n9 + ":";
            int n10 = byArray[20] * 16 + byArray[21];
            this.isValidMutc(n10);
            string = String.valueOf(string) + n10;
        }
        return string;
    }

    private void isValidDay(int n) throws IllegalArgumentException {
        if (n >= 1 && n <= 31) {
            return;
        }
        new MibOperations().debugPrint(SnmpUtils.getString("Exception: SnmpDataAndTime: Not a valid date"));
        throw new IllegalArgumentException(SnmpUtils.getString("Not a valid date"));
    }

    private void isValidDir(char c) throws IllegalArgumentException {
        if (c == '+' || c == '-') {
            return;
        }
        new MibOperations().debugPrint(SnmpUtils.getString("Exception: SnmpDataAndTime: Not a valid direction"));
        throw new IllegalArgumentException(SnmpUtils.getString("Not a valid direction"));
    }

    private void isValidDsec(int n) throws IllegalArgumentException {
        if (n >= 0 && n <= 9) {
            return;
        }
        new MibOperations().debugPrint(SnmpUtils.getString("Exception: SnmpDataAndTime: Not a valid deci second"));
        throw new IllegalArgumentException(SnmpUtils.getString("Not a valid deci second"));
    }

    private void isValidHour(int n) throws IllegalArgumentException {
        if (n >= 0 && n <= 23) {
            return;
        }
        new MibOperations().debugPrint(SnmpUtils.getString("Exception: SnmpDataAndTime: Not a valid hour"));
        throw new IllegalArgumentException(SnmpUtils.getString("Not a valid hour"));
    }

    private void isValidHutc(int n) throws IllegalArgumentException {
        if (n >= 0 && n <= 13) {
            return;
        }
        new MibOperations().debugPrint(SnmpUtils.getString("Exception: SnmpDataAndTime: Not a valid hour"));
        throw new IllegalArgumentException(SnmpUtils.getString("Not a valid hour"));
    }

    private void isValidMin(int n) throws IllegalArgumentException {
        if (n >= 0 && n <= 59) {
            return;
        }
        new MibOperations().debugPrint(SnmpUtils.getString("Exception: SnmpDataAndTime: Not a valid minute"));
        throw new IllegalArgumentException(SnmpUtils.getString("Not a valid minute"));
    }

    private void isValidMonth(int n) throws IllegalArgumentException {
        if (n >= 1 && n <= 12) {
            return;
        }
        new MibOperations().debugPrint(SnmpUtils.getString("Exception: SnmpDataAndTime: Not a valid month"));
        throw new IllegalArgumentException(SnmpUtils.getString("Not a valid month"));
    }

    private void isValidMutc(int n) throws IllegalArgumentException {
        if (n >= 0 && n <= 59) {
            return;
        }
        new MibOperations().debugPrint(SnmpUtils.getString("Exception: SnmpDataAndTime: Not a valid minute"));
        throw new IllegalArgumentException(SnmpUtils.getString("Not a valid minute"));
    }

    private void isValidSec(int n) throws IllegalArgumentException {
        if (n >= 0 && n <= 60) {
            return;
        }
        new MibOperations().debugPrint(SnmpUtils.getString("Exception: SnmpDataAndTime: Not a valid second"));
        throw new IllegalArgumentException(SnmpUtils.getString("Not a valid second"));
    }

    private void isValidYear(int n) throws IllegalArgumentException {
        if (n >= 0 && n <= 65536) {
            return;
        }
        new MibOperations().debugPrint(SnmpUtils.getString("Exception: SnmpDataAndTime: Not a valid year"));
        throw new IllegalArgumentException(SnmpUtils.getString("Not a valid year"));
    }

    byte[] properArray(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray2[n2] = (byte)(byArray[n3] >> 4 & 0xF);
            byArray2[++n2] = (byte)(byArray[n3] & 0xF);
            ++n2;
            ++n3;
        }
        return byArray2;
    }

    public String toString() {
        return this.dateStr;
    }
}

