/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs.mibparser;

import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.mibs.mibparser.ASCII_UCodeESC_CharStream;
import com.adventnet.snmp.mibs.mibparser.BaseSyntax;
import com.adventnet.snmp.mibs.mibparser.CommentClass;
import com.adventnet.snmp.mibs.mibparser.CreateDataBaseInsert;
import com.adventnet.snmp.mibs.mibparser.MIBConstants;
import com.adventnet.snmp.mibs.mibparser.MIBParserConstants;
import com.adventnet.snmp.mibs.mibparser.MIBParserTokenManager;
import com.adventnet.snmp.mibs.mibparser.MIBWriter;
import com.adventnet.snmp.mibs.mibparser.NameNumber;
import com.adventnet.snmp.mibs.mibparser.ParseException;
import com.adventnet.snmp.mibs.mibparser.ParserErrorMessage;
import com.adventnet.snmp.mibs.mibparser.RangeList;
import com.adventnet.snmp.mibs.mibparser.SyntaxNumber;
import com.adventnet.snmp.mibs.mibparser.SyntaxOID;
import com.adventnet.snmp.mibs.mibparser.SyntaxObjectType;
import com.adventnet.snmp.mibs.mibparser.SyntaxSequence;
import com.adventnet.snmp.mibs.mibparser.SyntaxString;
import com.adventnet.snmp.mibs.mibparser.SyntaxTextualConvention;
import com.adventnet.snmp.mibs.mibparser.SyntaxTrapType;
import com.adventnet.snmp.mibs.mibparser.Token;
import com.adventnet.utils.SnmpUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class MIBParser
implements BaseSyntax,
MIBConstants,
MIBParserConstants {
    static boolean JDBC = MibOperations.jdbc;
    static Stack argStack;
    static String ERR;
    static Hashtable oidList;
    static Hashtable invalidOidList;
    static Hashtable oidNumList;
    static Hashtable phantomOidList;
    static Hashtable phantomTCList;
    static Hashtable invalidTCList;
    static Hashtable tcList;
    static Hashtable trapList;
    static Hashtable importModules;
    static Hashtable sequenceList;
    static Hashtable invalidSequenceList;
    static Hashtable phantomSequenceList;
    static boolean flg;
    static Hashtable statusTable;
    public static Hashtable accessTable;
    public static Hashtable wellKnownTCs;
    public static Hashtable stdNodeOID;
    public static String otherRootNodes;
    public static String dependancyString;
    public static String importedNodeString;
    public static String trapString;
    public static String trapStr;
    public static String oidString;
    public static String ottString;
    public static String tcString;
    public static String tcStr;
    public static String mcModuleName;
    public static String mcString;
    public static String acVariationName;
    public static String acString;
    public static String acModuleString;
    public static String acModuleStr;
    public static String acStr;
    public static String ogString;
    public static String ngString;
    public static String nullStr;
    public static String moduleIdentityString;
    public static String moduleName;
    public static String nodeName;
    public static String oidtyString;
    public static String macroType;
    public static String revItemStr;
    public static String preModuleComments;
    public static String otString;
    public static String otrString;
    public static String seqString;
    public static String seqStr;
    public static String mcModuleString;
    public static String mcModuleStr;
    public static String grpObjString;
    public static String acVariationString;
    public static String acVariationStr;
    public static String ntString;
    public static String rangeString;
    public static String unitString;
    public static String syntaxName;
    public static String statusName;
    public static String accessName;
    public static Vector indOrAug;
    public static String refer;
    public static String descrip;
    public static String defStr;
    public static String rootNode;
    public static boolean rootFlag;
    public static boolean resolved;
    public static Vector enumVector;
    public static Vector rangeVector;
    static String acSyntaxName;
    static Hashtable importsOids;
    static Hashtable importsTCs;
    static Hashtable importSequences;
    static Vector modulesToBeParsed;
    static Vector parsedModules;
    static Vector imports;
    static String path;
    static String strOID;
    static String errCode;
    static String macroCode;
    static boolean setname;
    static String modToBeLoaded;
    static String filename;
    static Vector labelList;
    static StringBuffer importsString;
    static boolean multipleModules;
    static Vector standardNodes;
    static String[] parentNodes;
    static int[] oidNums;
    static boolean rootflag;
    static boolean writeinTMPdir;
    static CreateDataBaseInsert cdbi;
    static boolean firstTime;
    static int count;
    private static boolean jj_initialized_once;
    public static MIBParserTokenManager token_source;
    static ASCII_UCodeESC_CharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static Token jj_scanpos;
    private static Token jj_lastpos;
    private static int jj_la;
    public static boolean lookingAhead;
    private static boolean jj_semLA;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static final int[] jj_la1_0;
    private static final int[] jj_la1_1;
    private static final int[] jj_la1_2;
    private static final int[] jj_la1_3;
    private static final JJCalls[] jj_2_rtns;
    private static boolean jj_rescan;
    private static int jj_gc;
    private static Vector jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;
    private static int[] jj_lasttokens;
    private static int jj_endpos;

    static {
        ERR = "MIBParser Error : ";
        flg = true;
        statusTable = new Hashtable(5);
        accessTable = new Hashtable(7);
        wellKnownTCs = new Hashtable(15);
        stdNodeOID = new Hashtable();
        statusTable.put("mandatory", new Integer(0));
        statusTable.put("optional", new Integer(2));
        statusTable.put("deprecated", new Integer(3));
        statusTable.put("obsolete", new Integer(4));
        accessTable.put("not-accessible", new Integer(0));
        accessTable.put("read-only", new Integer(1));
        accessTable.put("read-write", new Integer(2));
        accessTable.put("write-only", new Integer(3));
        if (JDBC) {
            stdNodeOID.put("ccitt", ".0");
            stdNodeOID.put("iso", ".1");
            stdNodeOID.put("joint-ccitt-iso", ".2");
            stdNodeOID.put("org", ".1.3");
            stdNodeOID.put("dod", ".1.3.6");
            stdNodeOID.put("internet", ".1.3.6.1");
            stdNodeOID.put("directory", "1.3.6.1.1");
            stdNodeOID.put("mgmt", ".1.3.6.1.2");
            stdNodeOID.put("experimental", ".1.3.6.1.3");
            stdNodeOID.put("private", ".1.3.6.1.4");
            stdNodeOID.put("snmpV2", ".1.3.6.1.6");
            stdNodeOID.put("enterprises", ".1.3.6.1.4.1");
            stdNodeOID.put("mib-2", ".1.3.6.1.2.1");
            stdNodeOID.put("snmpDomains", ".1.3.6.1.6.1");
            stdNodeOID.put("snmpProxys", ".1.3.6.1.6.2");
            stdNodeOID.put("snmpModules", ".1.3.6.1.6.3");
            stdNodeOID.put("zeroDotZero", ".0.0");
        }
        MIBParser.initializeWellKnownTCs();
        otherRootNodes = "";
        dependancyString = "";
        importedNodeString = "|";
        trapString = "";
        trapStr = "";
        oidString = "";
        ottString = "";
        tcString = "";
        tcStr = "";
        mcModuleName = "";
        mcString = "";
        acVariationName = "";
        acString = "";
        acModuleString = "";
        acModuleStr = "";
        acStr = "";
        ogString = "";
        ngString = "";
        nullStr = null;
        moduleIdentityString = "";
        moduleName = null;
        nodeName = null;
        oidtyString = "";
        macroType = "";
        revItemStr = "";
        preModuleComments = "";
        otString = "";
        otrString = "";
        seqString = "";
        seqStr = "";
        mcModuleString = "";
        mcModuleStr = "";
        grpObjString = "";
        acVariationString = "";
        acVariationStr = "";
        ntString = "";
        rangeString = "";
        unitString = "";
        syntaxName = "";
        statusName = "";
        accessName = "";
        indOrAug = null;
        refer = null;
        descrip = null;
        defStr = null;
        rootNode = null;
        rootFlag = true;
        resolved = true;
        enumVector = new Vector();
        rangeVector = new Vector();
        acSyntaxName = "";
        modulesToBeParsed = null;
        parsedModules = null;
        path = null;
        strOID = "";
        errCode = "";
        macroCode = "";
        setname = false;
        modToBeLoaded = "";
        filename = null;
        labelList = null;
        importsString = null;
        multipleModules = false;
        standardNodes = null;
        parentNodes = new String[]{"iso", "org", "dod", "internet", "internet", "internet", "internet", "internet", "private", "mgmt", "snmpV2", "snmpV2", "snmpV2", "ccitt"};
        int[] nArray = new int[14];
        nArray[0] = 3;
        nArray[1] = 6;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 3;
        nArray[6] = 4;
        nArray[7] = 6;
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 2;
        nArray[12] = 3;
        oidNums = nArray;
        rootflag = false;
        writeinTMPdir = false;
        cdbi = null;
        firstTime = true;
        count = -1;
        jj_initialized_once = false;
        lookingAhead = false;
        jj_la1 = new int[88];
        int[] nArray2 = new int[88];
        nArray2[2] = 868832;
        nArray2[3] = 868832;
        nArray2[6] = 868848;
        nArray2[9] = 16;
        nArray2[10] = 868848;
        nArray2[11] = 327680;
        nArray2[12] = 327680;
        nArray2[13] = 16416;
        nArray2[14] = 16416;
        nArray2[15] = 524288;
        nArray2[16] = 327680;
        nArray2[17] = 16864;
        nArray2[18] = 868832;
        nArray2[26] = 65536;
        nArray2[27] = 0x3000000;
        nArray2[28] = 0x3000000;
        nArray2[38] = 868832;
        nArray2[51] = 65760;
        nArray2[68] = 868832;
        nArray2[69] = 868832;
        nArray2[72] = 868848;
        nArray2[74] = 868848;
        nArray2[76] = 868848;
        nArray2[78] = 881120;
        nArray2[79] = 881120;
        nArray2[83] = 16;
        nArray2[84] = 65568;
        nArray2[87] = 65568;
        jj_la1_0 = nArray2;
        int[] nArray3 = new int[88];
        nArray3[1] = 0x400000;
        nArray3[2] = 0x4100001;
        nArray3[3] = 0x4100001;
        nArray3[4] = 0x4100001;
        nArray3[5] = 0x4100000;
        nArray3[6] = 0x4100001;
        nArray3[10] = 0x4100001;
        nArray3[17] = 0x4000000;
        nArray3[18] = 0x4100001;
        nArray3[38] = 0x4000000;
        nArray3[39] = 5120;
        nArray3[40] = 5120;
        nArray3[43] = 4096;
        nArray3[46] = 4096;
        nArray3[47] = 0x100000;
        nArray3[49] = 2048;
        nArray3[51] = 0x4000800;
        nArray3[63] = 4;
        nArray3[65] = 4096;
        nArray3[68] = 0x4000000;
        nArray3[69] = 0x4000000;
        nArray3[72] = 0x4100001;
        nArray3[74] = 0x4100001;
        nArray3[76] = 0x4100001;
        nArray3[78] = 0x4000000;
        nArray3[79] = 0x4000000;
        nArray3[85] = 0x200000;
        jj_la1_1 = nArray3;
        int[] nArray4 = new int[88];
        nArray4[0] = 0x20000000;
        nArray4[2] = 65536;
        nArray4[3] = 65536;
        nArray4[4] = 32768;
        nArray4[5] = 32768;
        nArray4[6] = 4096;
        nArray4[7] = 0x2000000;
        nArray4[8] = 0x20000000;
        nArray4[9] = 4096;
        nArray4[10] = 4096;
        nArray4[19] = 0x8000000;
        nArray4[20] = 0x24000000;
        nArray4[21] = 0x8000000;
        nArray4[22] = 0x24000000;
        nArray4[23] = -2147454976;
        nArray4[24] = 28672;
        nArray4[25] = 0x8000000;
        nArray4[27] = -2147454976;
        nArray4[28] = -2147454976;
        nArray4[29] = 0x2000000;
        nArray4[31] = 4096;
        nArray4[33] = 4096;
        nArray4[35] = 4096;
        nArray4[39] = 8;
        nArray4[40] = 8;
        nArray4[42] = 8;
        nArray4[45] = 8;
        nArray4[48] = 0x2000000;
        nArray4[55] = 0x2000000;
        nArray4[57] = 2048;
        nArray4[58] = -2147459072;
        nArray4[60] = 0x20000000;
        nArray4[61] = 0x40000000;
        nArray4[62] = 0x2000000;
        nArray4[64] = 8;
        nArray4[66] = 0x2000000;
        nArray4[70] = 32;
        nArray4[71] = 32768;
        nArray4[72] = -67069696;
        nArray4[73] = 262144;
        nArray4[74] = -67069696;
        nArray4[75] = 131072;
        nArray4[76] = -67069696;
        nArray4[78] = 0x600000;
        nArray4[79] = 0x600000;
        nArray4[80] = 0x2000000;
        nArray4[81] = 0x180000;
        nArray4[82] = 0x180000;
        nArray4[84] = -67104766;
        nArray4[86] = -67076096;
        nArray4[87] = -67104766;
        jj_la1_2 = nArray4;
        int[] nArray5 = new int[88];
        nArray5[2] = 12;
        nArray5[3] = 12;
        nArray5[6] = 12;
        nArray5[10] = 12;
        nArray5[30] = 12;
        nArray5[32] = 12;
        nArray5[33] = 12;
        nArray5[34] = 12;
        nArray5[35] = 12;
        nArray5[36] = 4;
        nArray5[37] = 4;
        nArray5[38] = 4;
        nArray5[41] = 12;
        nArray5[44] = 12;
        nArray5[50] = 12;
        nArray5[51] = 12;
        nArray5[52] = 2;
        nArray5[53] = 2;
        nArray5[54] = 4;
        nArray5[56] = 12;
        nArray5[59] = 4;
        nArray5[67] = 12;
        nArray5[68] = 12;
        nArray5[69] = 12;
        nArray5[72] = 13;
        nArray5[74] = 13;
        nArray5[76] = 13;
        nArray5[77] = 8;
        nArray5[78] = 4;
        nArray5[79] = 4;
        nArray5[84] = 1;
        nArray5[86] = 1;
        nArray5[87] = 1;
        jj_la1_3 = nArray5;
        jj_2_rtns = new JJCalls[22];
        jj_rescan = false;
        jj_gc = 0;
        jj_expentries = new Vector();
        jj_kind = -1;
        jj_lasttokens = new int[100];
    }

    public MIBParser() {
    }

    public MIBParser(MIBParserTokenManager mIBParserTokenManager) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = mIBParserTokenManager;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int n = 0;
        while (n < 88) {
            MIBParser.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < jj_2_rtns.length) {
            MIBParser.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public MIBParser(InputStream inputStream) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new ASCII_UCodeESC_CharStream(inputStream, 1, 1);
        token_source = new MIBParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int n = 0;
        while (n < 88) {
            MIBParser.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < jj_2_rtns.length) {
            MIBParser.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public MIBParser(Reader reader) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new ASCII_UCodeESC_CharStream(reader, 1, 1);
        token_source = new MIBParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int n = 0;
        while (n < 88) {
            MIBParser.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < jj_2_rtns.length) {
            MIBParser.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public void ReInit(MIBParserTokenManager mIBParserTokenManager) {
        token_source = mIBParserTokenManager;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int n = 0;
        while (n < 88) {
            MIBParser.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < jj_2_rtns.length) {
            MIBParser.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public static void ReInit(InputStream inputStream) {
        jj_input_stream.ReInit(inputStream, 1, 1);
        MIBParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int n = 0;
        while (n < 88) {
            MIBParser.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < jj_2_rtns.length) {
            MIBParser.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public static void ReInit(Reader reader) {
        jj_input_stream.ReInit(reader, 1, 1);
        MIBParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        int n = 0;
        while (n < 88) {
            MIBParser.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < jj_2_rtns.length) {
            MIBParser.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    static void addOID(SyntaxOID syntaxOID, String string) {
        SyntaxOID syntaxOID2;
        if (phantomOidList.containsKey(string)) {
            syntaxOID2 = (SyntaxOID)phantomOidList.get(string);
            syntaxOID.merge(syntaxOID2);
        }
        if (invalidOidList.containsKey(string)) {
            syntaxOID2 = (SyntaxOID)invalidOidList.get(string);
            syntaxOID.merge(syntaxOID2);
        }
        phantomOidList.remove(string);
        invalidOidList.remove(string);
        oidList.put(string, syntaxOID);
        syntaxOID.setName(string);
    }

    static void addSequence(SyntaxSequence syntaxSequence, String string) {
        syntaxSequence.setName(string);
        SyntaxSequence syntaxSequence2 = null;
        if (phantomSequenceList.containsKey(string)) {
            syntaxSequence = syntaxSequence2 = (SyntaxSequence)phantomSequenceList.get(string);
        }
        if (invalidSequenceList.containsKey(string)) {
            syntaxSequence2 = (SyntaxSequence)invalidSequenceList.get(string);
        }
        if (syntaxSequence == null) {
            System.err.println(SnmpUtils.getString("exit:"));
            System.exit(1);
        }
        sequenceList.put(string, syntaxSequence);
        phantomSequenceList.remove(string);
        invalidSequenceList.remove(string);
    }

    static void addTC(SyntaxTextualConvention syntaxTextualConvention, String string) {
        syntaxTextualConvention.setName(string);
        SyntaxTextualConvention syntaxTextualConvention2 = null;
        if (phantomTCList.containsKey(string)) {
            syntaxTextualConvention2 = (SyntaxTextualConvention)phantomTCList.get(string);
            syntaxTextualConvention2.merge(syntaxTextualConvention);
            syntaxTextualConvention = syntaxTextualConvention2;
        }
        if (invalidTCList.containsKey(string)) {
            syntaxTextualConvention2 = (SyntaxTextualConvention)invalidTCList.get(string);
            syntaxTextualConvention2.merge(syntaxTextualConvention);
            syntaxTextualConvention = syntaxTextualConvention2;
        }
        if (syntaxTextualConvention == null) {
            System.err.println(SnmpUtils.getString("exit:"));
            System.exit(1);
        }
        tcList.put(string, syntaxTextualConvention);
        phantomTCList.remove(string);
        invalidTCList.remove(string);
    }

    public static final void anyInputs() throws ParseException {
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 99: {
                MIBParser.jj_consume_token(99);
                break;
            }
            case 98: {
                MIBParser.jj_consume_token(98);
                break;
            }
            case 75: {
                MIBParser.jj_consume_token(75);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 32: 
            case 52: 
            case 58: {
                MIBParser.definedElements();
                break;
            }
            case 79: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                MIBParser.terminalTokens();
                break;
            }
            case 4: {
                MIBParser.jj_consume_token(4);
                break;
            }
            case 72: {
                MIBParser.jj_consume_token(72);
                break;
            }
            case 76: {
                MIBParser.jj_consume_token(76);
                break;
            }
            default: {
                MIBParser.jj_la1[76] = jj_gen;
                MIBParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final int capAccess() throws ParseException {
        errCode = "ACCESS";
        if (!accessTable.containsKey(MIBParser.getToken((int)1).image)) {
            MIBParser.jj_consume_token(-1);
            throw new ParseException();
        }
        MIBParser.jj_consume_token(99);
        accessName = MIBParser.token.image;
        return (Integer)accessTable.get(MIBParser.token.image);
    }

    static void checkCyclicTCs() throws ParseException {
        Enumeration enumeration = tcList.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = MIBParser.findFinalValue(string, string);
            if (n != 0) continue;
            throw new ParseException(String.valueOf(SnmpUtils.getString("Cyclic TC")) + " " + string + " " + SnmpUtils.getString("encountered in") + " " + filename);
        }
    }

    public static final void choice() throws ParseException {
        MIBParser.jj_consume_token(79);
        MIBParser.jj_consume_token(57);
        MIBParser.jj_consume_token(93);
        block3: while (true) {
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                default: {
                    MIBParser.jj_la1[77] = jj_gen;
                    break block3;
                }
                case 99: {
                    MIBParser.choice1();
                    continue block3;
                }
            }
            break;
        }
        MIBParser.jj_consume_token(94);
    }

    public static final void choice1() throws ParseException {
        MIBParser.jj_consume_token(99);
        block0 : switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 58: 
            case 85: 
            case 86: 
            case 98: {
                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 14: 
                    case 16: 
                    case 18: 
                    case 19: 
                    case 58: {
                        MIBParser.snmpConstructOrTypeName();
                        break block0;
                    }
                    case 98: {
                        MIBParser.jj_consume_token(98);
                        break block0;
                    }
                    case 12: {
                        MIBParser.jj_consume_token(12);
                        break block0;
                    }
                    case 13: {
                        MIBParser.jj_consume_token(13);
                        break block0;
                    }
                    case 86: {
                        MIBParser.jj_consume_token(86);
                        break block0;
                    }
                    case 85: {
                        MIBParser.jj_consume_token(85);
                        break block0;
                    }
                }
                MIBParser.jj_la1[78] = jj_gen;
                MIBParser.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                MIBParser.jj_la1[79] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 89: {
                MIBParser.jj_consume_token(89);
                break;
            }
            default: {
                MIBParser.jj_la1[80] = jj_gen;
            }
        }
    }

    public static final String contactInfo() throws ParseException {
        String string = null;
        errCode = "contactInfo";
        string = MIBParser.quotedString();
        return string;
    }

    public static boolean containsMultipleModules() {
        return multipleModules;
    }

    static String convertSQLData(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace('#', '\u0096');
        if ((string = string.replace('\'', '\u00c8')).startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.trim().equals("")) {
            return null;
        }
        if (string.indexOf(40) != -1 || string.indexOf(41) != -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = stringBuffer.length();
            int n2 = 0;
            while (n2 < n) {
                char c = stringBuffer.charAt(n2);
                if (c == '(' || c == ')') {
                    stringBuffer.insert(n2++, '\\');
                    ++n;
                }
                ++n2;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    static void createCMIandCDS() throws IOException {
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        if (writeinTMPdir) {
            File file = new File("./tmp");
            file.mkdir();
            fileOutputStream = new FileOutputStream("./tmp/" + moduleName + ".cmi");
            fileOutputStream2 = new FileOutputStream("./tmp/" + moduleName + ".cds");
        } else {
            fileOutputStream = new FileOutputStream(String.valueOf(path) + moduleName + ".cmi");
            fileOutputStream2 = new FileOutputStream(String.valueOf(path) + moduleName + ".cds");
        }
        MIBParser.writeParams(fileOutputStream, fileOutputStream2);
        fileOutputStream.close();
        fileOutputStream2.close();
    }

    public static final void dataInputs() throws ParseException {
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 16: {
                MIBParser.jj_consume_token(16);
                break;
            }
            case 5: {
                MIBParser.jj_consume_token(5);
                break;
            }
            case 93: {
                MIBParser.jj_consume_token(93);
                break;
            }
            case 94: {
                MIBParser.jj_consume_token(94);
                break;
            }
            case 90: {
                MIBParser.jj_consume_token(90);
                break;
            }
            case 92: {
                MIBParser.jj_consume_token(92);
                break;
            }
            case 91: {
                MIBParser.jj_consume_token(91);
                break;
            }
            case 96: {
                MIBParser.jj_consume_token(96);
                break;
            }
            case 95: {
                MIBParser.jj_consume_token(95);
                break;
            }
            case 76: {
                MIBParser.jj_consume_token(76);
                break;
            }
            case 65: {
                MIBParser.jj_consume_token(65);
                break;
            }
            default: {
                MIBParser.jj_la1[87] = jj_gen;
                MIBParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void dataTypeDecl() throws ParseException {
        MIBParser.jj_consume_token(79);
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 4: {
                MIBParser.jj_consume_token(4);
                block3 : switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    case 83: 
                    case 84: {
                        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                            case 83: {
                                MIBParser.jj_consume_token(83);
                                break block3;
                            }
                            case 84: {
                                MIBParser.jj_consume_token(84);
                                break block3;
                            }
                        }
                        MIBParser.jj_la1[81] = jj_gen;
                        MIBParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        MIBParser.jj_la1[82] = jj_gen;
                    }
                }
                MIBParser.jj_consume_token(76);
                MIBParser.jj_consume_token(4);
                break;
            }
            default: {
                MIBParser.jj_la1[83] = jj_gen;
            }
        }
        block10 : switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 53: {
                MIBParser.jj_consume_token(53);
                while (true) {
                    switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                        default: {
                            MIBParser.jj_la1[84] = jj_gen;
                            break block10;
                        }
                        case 5: 
                        case 16: 
                        case 65: 
                        case 76: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                    }
                    MIBParser.dataInputs();
                }
            }
            default: {
                MIBParser.jj_la1[85] = jj_gen;
            }
        }
    }

    public static final void dataTypeDecl1() throws ParseException {
        if (!(MIBParser.getToken((int)0).image.equals("NsapAddress") | MIBParser.getToken((int)0).image.equals("UInteger32"))) {
            MIBParser.jj_consume_token(-1);
            throw new ParseException();
        }
        MIBParser.dataTypeDecl();
    }

    public static final void defVal(SyntaxObjectType syntaxObjectType) throws ParseException {
        errCode = "defVal";
        Vector vector = new Vector(5);
        Stack stack = new Stack();
        Token token = null;
        Token token2 = null;
        block0 : switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 75: {
                MIBParser.jj_consume_token(75);
                syntaxObjectType.setDefVal(MIBParser.token.image);
                break;
            }
            default: {
                MIBParser.jj_la1[57] = jj_gen;
                if (MIBParser.jj_2_16(4)) {
                    switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                        case 97: {
                            token = MIBParser.jj_consume_token(97);
                            break;
                        }
                        default: {
                            MIBParser.jj_la1[52] = jj_gen;
                        }
                    }
                    token2 = MIBParser.jj_consume_token(76);
                    block26: while (true) {
                        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                            default: {
                                MIBParser.jj_la1[53] = jj_gen;
                                break block26;
                            }
                            case 97: {
                                MIBParser.dottedOID();
                                continue block26;
                            }
                        }
                        break;
                    }
                    strOID = token != null ? String.valueOf(token.image) + token2.image + strOID : String.valueOf(token2.image) + strOID;
                    syntaxObjectType.setDefVal(strOID);
                    strOID = "";
                    break;
                }
                if (MIBParser.jj_2_17(2)) {
                    MIBParser.jj_consume_token(76);
                    syntaxObjectType.setDefVal(MIBParser.token.image);
                    break;
                }
                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    case 95: {
                        MIBParser.jj_consume_token(95);
                        MIBParser.jj_consume_token(76);
                        syntaxObjectType.setDefVal("-" + MIBParser.token.image);
                        break block0;
                    }
                    case 78: {
                        MIBParser.jj_consume_token(78);
                        syntaxObjectType.setDefVal(MIBParser.token.image);
                        break block0;
                    }
                    case 77: {
                        MIBParser.jj_consume_token(77);
                        syntaxObjectType.setDefVal(MIBParser.token.image);
                        break block0;
                    }
                }
                MIBParser.jj_la1[58] = jj_gen;
                if (MIBParser.jj_2_18(10)) {
                    SyntaxOID syntaxOID = MIBParser.oidValue();
                    syntaxObjectType.setDefVal(syntaxOID.toString());
                    break;
                }
                if (MIBParser.jj_2_19(3)) {
                    token = MIBParser.jj_consume_token(99);
                    MIBParser.jj_consume_token(97);
                    token2 = MIBParser.jj_consume_token(99);
                    syntaxObjectType.setDefVal(String.valueOf(token.image) + "." + token2.image);
                    break;
                }
                if (MIBParser.jj_2_20(2)) {
                    switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                        case 98: {
                            token = MIBParser.jj_consume_token(98);
                            MIBParser.jj_consume_token(97);
                            break;
                        }
                        default: {
                            MIBParser.jj_la1[54] = jj_gen;
                        }
                    }
                    token2 = MIBParser.jj_consume_token(99);
                    if (token != null) {
                        syntaxObjectType.setDefVal(String.valueOf(token.image) + token2.image);
                        break;
                    }
                    syntaxObjectType.setDefVal(token2.image);
                    if (!token2.image.equals("zeroDotZero") || oidList.containsKey("zeroDotZero")) break;
                    if (JDBC && oidString.indexOf("zeroDotZero") == -1) {
                        oidString = String.valueOf(oidString) + ".0.0#zeroDotZero#OID$";
                        break;
                    }
                    MIBParser.addOID(SyntaxOID.getInstance((SyntaxOID)oidList.get("ccitt"), "zeroDotZero", 0), "zeroDotZero");
                    break;
                }
                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    case 98: {
                        token = MIBParser.jj_consume_token(98);
                        syntaxObjectType.setDefVal(token.image);
                        break block0;
                    }
                }
                MIBParser.jj_la1[59] = jj_gen;
                if (MIBParser.jj_2_21(4)) {
                    MIBParser.jj_consume_token(93);
                    block20 : switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                        case 98: 
                        case 99: {
                            MIBParser.lcObject(vector);
                            while (true) {
                                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                                    default: {
                                        MIBParser.jj_la1[55] = jj_gen;
                                        break block20;
                                    }
                                    case 89: 
                                }
                                MIBParser.jj_consume_token(89);
                                MIBParser.lcObject(vector);
                            }
                        }
                        default: {
                            MIBParser.jj_la1[56] = jj_gen;
                        }
                    }
                    MIBParser.jj_consume_token(94);
                    StringBuffer stringBuffer = new StringBuffer();
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        stringBuffer.append((String)enumeration.nextElement());
                        stringBuffer.append(", ");
                    }
                    if (vector.size() > 0) {
                        stringBuffer.setLength(stringBuffer.length() - 2);
                    }
                    syntaxObjectType.setDefVal(stringBuffer.toString());
                    break;
                }
                MIBParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void definedElements() throws ParseException {
        errCode = "definedElements";
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 52: {
                MIBParser.jj_consume_token(52);
                break;
            }
            case 32: {
                MIBParser.jj_consume_token(32);
                break;
            }
            case 58: {
                MIBParser.jj_consume_token(58);
                break;
            }
            case 19: {
                MIBParser.jj_consume_token(19);
                break;
            }
            case 16: {
                MIBParser.jj_consume_token(16);
                break;
            }
            case 18: {
                MIBParser.jj_consume_token(18);
                break;
            }
            case 14: {
                MIBParser.jj_consume_token(14);
                break;
            }
            case 7: {
                MIBParser.jj_consume_token(7);
                break;
            }
            case 8: {
                MIBParser.jj_consume_token(8);
                break;
            }
            case 5: {
                MIBParser.jj_consume_token(5);
                break;
            }
            case 6: {
                MIBParser.jj_consume_token(6);
                break;
            }
            default: {
                MIBParser.jj_la1[18] = jj_gen;
                MIBParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void definitions() throws ParseException {
        errCode = "definitions";
        BaseSyntax baseSyntax = null;
        Token token = null;
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 80: {
                token = MIBParser.jj_consume_token(80);
                break;
            }
            case 99: {
                BaseSyntax baseSyntax2;
                token = MIBParser.jj_consume_token(99);
                baseSyntax = MIBParser.lcConstruct();
                nodeName = token.image;
                if (baseSyntax instanceof SyntaxOID) {
                    baseSyntax2 = (SyntaxOID)baseSyntax;
                    MIBParser.addOID((SyntaxOID)baseSyntax2, token.image);
                    if (JDBC) {
                        oidString = String.valueOf(oidString) + ((SyntaxOID)baseSyntax2).toString() + "#" + token.image + "#" + macroType + "$";
                    }
                    ((SyntaxOID)baseSyntax2).commentObj.node = MIBParser.extractComments(token.specialToken);
                }
                if (baseSyntax instanceof SyntaxTrapType) {
                    if (JDBC) {
                        trapString = String.valueOf(trapString) + nodeName + "#" + trapStr + "$";
                    }
                    baseSyntax2 = (SyntaxTrapType)baseSyntax;
                    ((SyntaxTrapType)baseSyntax2).setName(token.image);
                    trapList.put(token.image, baseSyntax2);
                }
                if (!(baseSyntax instanceof SyntaxSequence)) break;
                if (JDBC) {
                    macroType = "SEQ";
                }
                baseSyntax2 = (SyntaxSequence)baseSyntax;
                ((SyntaxSequence)baseSyntax2).setName(token.image);
                MIBParser.addSequence((SyntaxSequence)baseSyntax2, token.image);
                break;
            }
            case 98: {
                BaseSyntax baseSyntax3;
                token = MIBParser.jj_consume_token(98);
                baseSyntax = MIBParser.ucConstruct();
                if (baseSyntax instanceof SyntaxTextualConvention) {
                    if (JDBC) {
                        macroType = "TC";
                        tcString = String.valueOf(tcString) + token.image + "#" + tcStr + "$";
                        if (rangeVector.size() > 0 || enumVector.size() > 0) {
                            rangeString = String.valueOf(rangeString) + token.image + "#" + rangeVector.toString() + "#" + enumVector.toString() + "$";
                            rangeVector = new Vector();
                            enumVector = new Vector();
                        }
                    }
                    baseSyntax3 = (SyntaxTextualConvention)baseSyntax;
                    baseSyntax3.commentObj.node = String.valueOf(baseSyntax3.commentObj.node) + MIBParser.extractComments(token.specialToken);
                    MIBParser.addTC(baseSyntax3, token.image);
                }
                if (baseSyntax instanceof SyntaxSequence) {
                    baseSyntax3 = (SyntaxSequence)baseSyntax;
                    ((SyntaxSequence)baseSyntax3).setName(token.image);
                    MIBParser.addSequence((SyntaxSequence)baseSyntax3, token.image);
                    if (JDBC) {
                        seqString = String.valueOf(seqString) + token.image + "#" + seqStr + "$";
                        seqStr = "";
                    }
                }
                if (!(baseSyntax instanceof SyntaxOID)) break;
                baseSyntax3 = (SyntaxOID)baseSyntax;
                ((SyntaxOID)baseSyntax3).commentObj.node = MIBParser.extractComments(token.specialToken);
                MIBParser.addOID((SyntaxOID)baseSyntax3, token.image);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 32: 
            case 52: 
            case 58: {
                MIBParser.definedElements();
                String string = MIBParser.token.image;
                if (labelList != null && labelList.contains(MIBParser.token.image)) {
                    SyntaxTextualConvention syntaxTextualConvention = (SyntaxTextualConvention)MIBParser.textual_convention_construct();
                    syntaxTextualConvention.commentObj.node = String.valueOf(syntaxTextualConvention.commentObj.node) + MIBParser.extractComments(MIBParser.token.specialToken);
                    MIBParser.addTC(syntaxTextualConvention, string);
                    break;
                }
                try {
                    MIBParser.macroDefinitionOmission();
                    break;
                }
                catch (Exception exception) {
                    throw new ParseException("\n" + SnmpUtils.getString("Encountered a reserved word") + " \"" + MIBParser.token.image + "\" " + SnmpUtils.getString("at line") + " " + MIBParser.token.beginLine + ", " + SnmpUtils.getString("column:") + " " + MIBParser.token.beginColumn);
                }
            }
            default: {
                MIBParser.jj_la1[3] = jj_gen;
                MIBParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static void delete(String string, MibOperations mibOperations) {
        if (cdbi == null) {
            CreateDataBaseInsert createDataBaseInsert = new CreateDataBaseInsert(mibOperations);
            createDataBaseInsert.delete(string);
        } else {
            cdbi.delete(string);
        }
    }

    public static final String description() throws ParseException {
        String string = null;
        errCode = "description";
        string = MIBParser.quotedString();
        return string;
    }

    public static final void disable_tracing() {
    }

    public static final void dottedOID() throws ParseException {
        errCode = "dottedOID";
        Token token = null;
        Token token2 = null;
        token = MIBParser.jj_consume_token(97);
        token2 = MIBParser.jj_consume_token(76);
        strOID = String.valueOf(strOID) + token.image + token2.image;
    }

    public static final void enable_tracing() {
    }

    static String extractComments(Token token) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (token != null) {
            while (token.specialToken != null) {
                token = token.specialToken;
            }
            while (token != null) {
                stringBuffer.append(token.image);
                token = token.next;
            }
        }
        return stringBuffer.toString();
    }

    static SyntaxOID extractOID(Stack stack) {
        stack = MIBParser.invertStack(stack);
        SyntaxOID syntaxOID = new SyntaxOID();
        Object e = stack.pop();
        SyntaxOID syntaxOID2 = MIBParser.getObjSyntax(e, null);
        if (stack.isEmpty()) {
            System.err.println(String.valueOf(ERR) + " " + SnmpUtils.getString("Unexpected termination in OID Syntax parse"));
        }
        SyntaxOID syntaxOID3 = MIBParser.getObjSyntax(stack.pop(), syntaxOID2);
        while (!stack.isEmpty()) {
            syntaxOID2 = syntaxOID3;
            syntaxOID3 = MIBParser.getObjSyntax(stack.pop(), syntaxOID2);
        }
        return syntaxOID3;
    }

    static int findFinalValue(String string, String string2) {
        if ((string2 = MIBParser.getValue(string2)) != null && tcList.get(string2) != null) {
            if ((string2 = MIBParser.getValue(string2)) != null && string2.equals(string)) {
                return 0;
            }
            return MIBParser.findFinalValue(string, string2);
        }
        return 1;
    }

    public static final void firstItem(Stack stack) throws ParseException {
        errCode = "firstItem";
        NameNumber nameNumber = new NameNumber();
        Token token = null;
        Vector vector = new Vector(5);
        block0 : switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 76: {
                token = MIBParser.jj_consume_token(76);
                Long l = new Long(token.image);
                if (l <= 0xFFFFFFFFL) {
                    stack.push(new Integer(l.intValue()));
                    break;
                }
                throw new ParseException(SnmpUtils.getString("subOID value should not exceed 4294967295"));
            }
            default: {
                MIBParser.jj_la1[31] = jj_gen;
                if (MIBParser.jj_2_10(2)) {
                    MIBParser.nameNumber(vector);
                    stack.push(vector.elementAt(0));
                    break;
                }
                if (MIBParser.getToken((int)1).image.equals("iso") || MIBParser.getToken((int)1).image.equals("ccitt") || MIBParser.getToken((int)1).image.equals("joint-iso-ccitt")) {
                    MIBParser.wellKnownName(stack);
                    break;
                }
                if (oidList.containsKey(MIBParser.getToken((int)1).image) || phantomOidList.containsKey(MIBParser.getToken((int)1).image) || imports.contains(MIBParser.getToken((int)1).image)) {
                    MIBParser.itemWithOIDvalue(stack);
                    break;
                }
                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    case 98: 
                    case 99: {
                        MIBParser.itemWithOIDvalue(stack);
                        SyntaxOID syntaxOID = null;
                        Object e = stack.peek();
                        if (JDBC) {
                            syntaxOID = SyntaxOID.getInstance(null, (String)e, count--);
                            otherRootNodes = String.valueOf(otherRootNodes) + (String)e + "|";
                        } else {
                            syntaxOID = SyntaxOID.getInstance(null, (String)e, -1);
                        }
                        if (invalidOidList.get((String)e) != null) break block0;
                        invalidOidList.put(e, syntaxOID);
                        break block0;
                    }
                    default: {
                        MIBParser.jj_la1[32] = jj_gen;
                        MIBParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
        }
    }

    public static void free() {
        argStack = null;
        oidList = null;
        invalidOidList = null;
        oidNumList = null;
        phantomOidList = null;
        phantomTCList = null;
        invalidTCList = null;
        tcList = null;
        trapList = null;
        importModules = null;
        sequenceList = null;
        invalidSequenceList = null;
        phantomSequenceList = null;
        importsOids = null;
        importsTCs = null;
        importSequences = null;
        labelList = null;
        imports = null;
        importsString = null;
        modulesToBeParsed = null;
        parsedModules = null;
    }

    public static final ParseException generateParseException() {
        int n;
        jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[100];
        int n2 = 0;
        while (n2 < 100) {
            blArray[n2] = false;
            ++n2;
        }
        if (jj_kind >= 0) {
            blArray[MIBParser.jj_kind] = true;
            jj_kind = -1;
        }
        int n3 = 0;
        while (n3 < 88) {
            if (jj_la1[n3] == jj_gen) {
                n = 0;
                while (n < 32) {
                    if ((jj_la1_0[n3] & 1 << n) != 0) {
                        blArray[n] = true;
                    }
                    if ((jj_la1_1[n3] & 1 << n) != 0) {
                        blArray[32 + n] = true;
                    }
                    if ((jj_la1_2[n3] & 1 << n) != 0) {
                        blArray[64 + n] = true;
                    }
                    if ((jj_la1_3[n3] & 1 << n) != 0) {
                        blArray[96 + n] = true;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        n = 0;
        while (n < 100) {
            if (blArray[n]) {
                jj_expentry = new int[1];
                MIBParser.jj_expentry[0] = n;
                jj_expentries.addElement(jj_expentry);
            }
            ++n;
        }
        jj_endpos = 0;
        MIBParser.jj_rescan_token();
        MIBParser.jj_add_error_token(0, 0);
        int[][] nArray = new int[jj_expentries.size()][];
        int n4 = 0;
        while (n4 < jj_expentries.size()) {
            nArray[n4] = (int[])jj_expentries.elementAt(n4);
            ++n4;
        }
        return new ParseException(token, nArray, MIBParserConstants.tokenImage);
    }

    static String getConstructs(Hashtable hashtable) {
        String string = "{ ";
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = String.valueOf(string) + string2 + ", ";
        }
        string = String.valueOf(string.substring(0, string.length() - 2)) + " }";
        return string;
    }

    public static String getImportAsInMIB() {
        return importsString.toString();
    }

    static Hashtable getImportOids() {
        Hashtable hashtable = new Hashtable(1);
        Enumeration enumeration = importModules.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)importModules.get(string);
            Vector vector2 = new Vector(5);
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                if (!phantomOidList.containsKey(string2)) continue;
                vector2.addElement(phantomOidList.get(string2));
            }
            if (vector2.size() <= 0) continue;
            hashtable.put(string, vector2);
        }
        return hashtable;
    }

    static Hashtable getImportSequences() {
        Hashtable hashtable = new Hashtable(1);
        Enumeration enumeration = importModules.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)importModules.get(string);
            Vector vector2 = new Vector(5);
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                if (!phantomSequenceList.containsKey(string2)) continue;
                vector2.addElement(phantomSequenceList.get(string2));
            }
            if (vector2.size() <= 0) continue;
            hashtable.put(string, vector2);
        }
        return hashtable;
    }

    static Hashtable getImportTCs() {
        Hashtable hashtable = new Hashtable(1);
        Enumeration enumeration = importModules.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)importModules.get(string);
            Vector vector2 = new Vector(5);
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                if (!phantomTCList.containsKey(string2)) continue;
                vector2.addElement(phantomTCList.get(string2));
            }
            if (vector2.size() <= 0) continue;
            hashtable.put(string, vector2);
        }
        return hashtable;
    }

    public static Hashtable getImportedOidTable() {
        return MIBParser.getImportOids();
    }

    public static Hashtable getImportedSequenceTable() {
        return MIBParser.getImportSequences();
    }

    public static Hashtable getImportedTCTable() {
        return MIBParser.getImportTCs();
    }

    public String getName() {
        return "";
    }

    public static final Token getNextToken() {
        token = MIBParser.token.next != null ? MIBParser.token.next : (MIBParser.token.next = MIBParserTokenManager.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    static SyntaxOID getOID(String string) {
        SyntaxOID syntaxOID = null;
        if (phantomOidList.containsKey(string)) {
            syntaxOID = (SyntaxOID)phantomOidList.get(string);
        } else if (invalidOidList.containsKey(string)) {
            syntaxOID = (SyntaxOID)invalidOidList.get(string);
        } else if (oidList.containsKey(string)) {
            syntaxOID = (SyntaxOID)oidList.get(string);
        } else if (imports.contains(string)) {
            syntaxOID = new SyntaxOID();
            syntaxOID.setName(string);
            syntaxOID.setValue(-1);
            phantomOidList.put(string, syntaxOID);
        } else {
            syntaxOID = new SyntaxOID();
            syntaxOID.setName(string);
            syntaxOID.setValue(-1);
            invalidOidList.put(string, syntaxOID);
        }
        return syntaxOID;
    }

    public static Hashtable getOIDTable() {
        return oidList;
    }

    static SyntaxOID getObjSyntax(Object object, SyntaxOID syntaxOID) {
        if (object instanceof Integer) {
            String string = "Id";
            if (syntaxOID == null) {
                SyntaxOID syntaxOID2 = SyntaxOID.getInstance(syntaxOID, null, (Integer)object);
                return syntaxOID2;
            }
            if (!firstTime) {
                int n = 0;
                while (n < syntaxOID.oid_tree.length) {
                    string = String.valueOf(string) + syntaxOID.oid_tree[n];
                    ++n;
                }
            } else {
                firstTime = false;
                SyntaxOID syntaxOID3 = SyntaxOID.getInstance(syntaxOID, null, (Integer)object);
                return syntaxOID3;
            }
            syntaxOID.identity = string;
            SyntaxOID syntaxOID4 = SyntaxOID.getInstance(syntaxOID, string, (Integer)object);
            if (JDBC) {
                String string2 = syntaxOID4.toString();
                oidString = String.valueOf(oidString) + string2.substring(0, string2.lastIndexOf(".")) + "#" + string + "#" + "OID" + "$";
            }
            return syntaxOID4;
        }
        if (object instanceof NameNumber) {
            SyntaxOID syntaxOID5;
            firstTime = true;
            NameNumber nameNumber = (NameNumber)object;
            if (oidList.containsKey(nameNumber.name)) {
                return (SyntaxOID)oidList.get(nameNumber.name);
            }
            if (phantomOidList.containsKey(nameNumber.name)) {
                return (SyntaxOID)phantomOidList.get(nameNumber.name);
            }
            if (syntaxOID != null) {
                syntaxOID5 = syntaxOID.addChild((int)nameNumber.number);
                syntaxOID5.setName(nameNumber.name);
            } else {
                syntaxOID5 = SyntaxOID.getInstance(null, nameNumber.name, (int)nameNumber.number);
            }
            if (JDBC) {
                oidString = String.valueOf(oidString) + syntaxOID5.toString() + "#" + nameNumber.name + "#OID$";
            }
            oidList.put(nameNumber.name, syntaxOID5);
            oidNumList.put(new Integer((int)nameNumber.number), syntaxOID5);
            return syntaxOID5;
        }
        if (object instanceof String) {
            firstTime = true;
            if (oidList.containsKey(object)) {
                return (SyntaxOID)oidList.get(object);
            }
            if (phantomOidList.containsKey(object)) {
                return (SyntaxOID)phantomOidList.get(object);
            }
            if (invalidOidList.containsKey(object)) {
                return (SyntaxOID)invalidOidList.get(object);
            }
            if (imports.contains(object)) {
                SyntaxOID syntaxOID6 = null;
                if (JDBC) {
                    syntaxOID6 = SyntaxOID.getInstance(null, (String)object, count--);
                    resolved = false;
                    otherRootNodes = String.valueOf(otherRootNodes) + object + "|";
                } else {
                    syntaxOID6 = SyntaxOID.getInstance(null, (String)object, -1);
                }
                phantomOidList.put(object, syntaxOID6);
                return syntaxOID6;
            }
            SyntaxOID syntaxOID7 = null;
            if (JDBC) {
                syntaxOID7 = SyntaxOID.getInstance(null, (String)object, count--);
                resolved = false;
                otherRootNodes = String.valueOf(otherRootNodes) + object + "|";
            } else {
                syntaxOID7 = SyntaxOID.getInstance(null, (String)object, -1);
            }
            invalidOidList.put(object, syntaxOID7);
            return syntaxOID7;
        }
        return null;
    }

    public RangeList getRange() {
        return null;
    }

    public static Hashtable getSequenceTable() {
        return sequenceList;
    }

    public BaseSyntax getSyntax() {
        return new SyntaxOID();
    }

    public static Hashtable getTCTable() {
        return tcList;
    }

    public static final Token getToken(int n) {
        Token token = lookingAhead ? jj_scanpos : MIBParser.token;
        int n2 = 0;
        while (n2 < n) {
            token = token.next != null ? token.next : (token.next = MIBParserTokenManager.getNextToken());
            ++n2;
        }
        return token;
    }

    public static Hashtable getTrapTable() {
        return trapList;
    }

    public int getType() {
        return -1;
    }

    static String getValue(String string) {
        if (string == null) {
            return null;
        }
        SyntaxTextualConvention syntaxTextualConvention = (SyntaxTextualConvention)tcList.get(string);
        if (syntaxTextualConvention != null && syntaxTextualConvention.getParentSyntax() instanceof SyntaxTextualConvention) {
            BaseSyntax baseSyntax = syntaxTextualConvention.getParentSyntax();
            return ((SyntaxTextualConvention)baseSyntax).getName();
        }
        return null;
    }

    public static final void identification() throws ParseException {
        errCode = "identification";
        Token token = null;
        SyntaxOID syntaxOID = null;
        try {
            token = MIBParser.jj_consume_token(98);
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                case 93: {
                    syntaxOID = MIBParser.oidValue();
                    break;
                }
                default: {
                    MIBParser.jj_la1[0] = jj_gen;
                }
            }
            moduleName = token.image;
            preModuleComments = MIBParser.extractComments(token.specialToken);
        }
        catch (ParseException parseException) {
            String string = parseException.getMessage();
            int n = string.indexOf("Was expecting");
            if (n != -1) {
                string = string.substring(0, n);
            }
            string = String.valueOf(string) + "\n" + SnmpUtils.getString("Was expecting a ModuleName and that should be in upper case or atleast in proper case");
            throw new ParseException(string);
        }
    }

    public static final void imports() throws ParseException {
        errCode = "imports";
        MIBParser.jj_consume_token(54);
        block3: while (true) {
            MIBParser.importsFrom();
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 14: 
                case 16: 
                case 18: 
                case 19: 
                case 32: 
                case 52: 
                case 58: 
                case 76: 
                case 98: 
                case 99: {
                    continue block3;
                }
            }
            break;
        }
        MIBParser.jj_la1[6] = jj_gen;
        MIBParser.jj_consume_token(88);
    }

    public static final void importsFrom() throws ParseException {
        Object object;
        errCode = "importsFrom";
        Vector vector = new Vector(5);
        String string = null;
        MIBParser.importsName(vector);
        block3: while (true) {
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                default: {
                    MIBParser.jj_la1[7] = jj_gen;
                    break block3;
                }
                case 89: {
                    MIBParser.jj_consume_token(89);
                    MIBParser.importsName(vector);
                    continue block3;
                }
            }
            break;
        }
        MIBParser.jj_consume_token(68);
        string = MIBParser.moduleIdentifier();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            imports.addElement(object);
        }
        if (vector.size() > 0) {
            if (importModules.get(string) == null) {
                if (JDBC) {
                    if (!(string.equals("RFC1155-SMI") || string.equals("SNMPv2-SMI") || string.equals("SNMPv2-TC") || string.equals("SNMPv2-CONF"))) {
                        dependancyString = String.valueOf(dependancyString) + string + "#" + importedNodeString + "$";
                    }
                    importedNodeString = "|";
                }
                importModules.put(string, vector);
            } else {
                object = (Vector)importModules.get(string);
                int n = 0;
                while (n < vector.size()) {
                    ((Vector)object).addElement(vector.elementAt(n));
                    ++n;
                }
            }
        }
        object = importsString.toString();
        object = ((String)object).substring(0, ((String)object).length() - 2);
        importsString = new StringBuffer((String)object);
        importsString.append("\n\t\tFROM ");
        importsString.append(string);
        importsString.append("\n\t");
    }

    public static final void importsName(Vector vector) throws ParseException {
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 32: 
            case 52: 
            case 58: {
                MIBParser.definedElements();
                break;
            }
            case 99: {
                MIBParser.jj_consume_token(99);
                String string = MIBParser.getToken((int)0).image;
                importsString.append(string);
                importsString.append(", ");
                if (string.equals("PhysAddress") || string.equals("MacAddress") || string.equals("DisplayString")) break;
                vector.addElement(string);
                if (!JDBC) break;
                importedNodeString = String.valueOf(importedNodeString) + string + "|";
                break;
            }
            case 98: {
                MIBParser.jj_consume_token(98);
                String string = MIBParser.getToken((int)0).image;
                vector.addElement(string);
                importsString.append(string);
                importsString.append(", ");
                if (!JDBC) break;
                importedNodeString = String.valueOf(importedNodeString) + string + "|";
                break;
            }
            case 4: 
            case 76: {
                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    case 76: {
                        MIBParser.jj_consume_token(76);
                        break;
                    }
                    case 4: {
                        MIBParser.jj_consume_token(4);
                        break;
                    }
                    default: {
                        MIBParser.jj_la1[9] = jj_gen;
                        MIBParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                errCode = "importsName";
                break;
            }
            default: {
                MIBParser.jj_la1[10] = jj_gen;
                MIBParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void indexItem(Vector vector) throws ParseException {
        errCode = "indexItem";
        String string = null;
        Object var2_2 = null;
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Object var8_6 = null;
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 43: 
            case 98: 
            case 99: {
                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    case 43: {
                        token = MIBParser.jj_consume_token(43);
                        break;
                    }
                    default: {
                        MIBParser.jj_la1[49] = jj_gen;
                    }
                }
                if (MIBParser.jj_2_15(2)) {
                    token2 = MIBParser.jj_consume_token(98);
                    MIBParser.jj_consume_token(97);
                }
                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    case 99: {
                        token3 = MIBParser.jj_consume_token(99);
                        break;
                    }
                    case 98: {
                        token3 = MIBParser.jj_consume_token(98);
                        break;
                    }
                    default: {
                        MIBParser.jj_la1[50] = jj_gen;
                        MIBParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (token != null) {
                    vector.addElement("IMPLIED");
                }
                if (token2 != null) {
                    string = token2.image;
                }
                StringBuffer stringBuffer = new StringBuffer();
                if (string != null && !string.equals(moduleName)) {
                    stringBuffer.append(String.valueOf(string) + ".");
                }
                stringBuffer.append(token3.image);
                vector.addElement(stringBuffer.toString());
                break;
            }
            case 16: {
                MIBParser.jj_consume_token(16);
                vector.addElement(MIBParser.token.image);
                break;
            }
            case 5: {
                MIBParser.jj_consume_token(5);
                vector.addElement(MIBParser.token.image);
                break;
            }
            case 58: {
                MIBParser.jj_consume_token(58);
                vector.addElement(MIBParser.token.image);
                break;
            }
            case 7: {
                MIBParser.jj_consume_token(7);
                vector.addElement(MIBParser.token.image);
                break;
            }
            case 6: {
                MIBParser.jj_consume_token(6);
                vector.addElement(MIBParser.token.image);
                break;
            }
            default: {
                MIBParser.jj_la1[51] = jj_gen;
                MIBParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void indexOrAugments(SyntaxObjectType syntaxObjectType) throws ParseException {
        errCode = "indexOrAugments";
        Vector vector = new Vector(5);
        Token token = null;
        token = MIBParser.jj_consume_token(64);
        MIBParser.jj_consume_token(93);
        MIBParser.indexItem(vector);
        block3: while (true) {
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                default: {
                    MIBParser.jj_la1[48] = jj_gen;
                    break block3;
                }
                case 89: {
                    MIBParser.jj_consume_token(89);
                    MIBParser.indexItem(vector);
                    continue block3;
                }
            }
            break;
        }
        MIBParser.jj_consume_token(94);
        if (JDBC) {
            indOrAug = (Vector)vector.clone();
            indOrAug.addElement("1");
        }
        int n = vector.size();
        String string = null;
        int n2 = 0;
        while (n2 < n) {
            string = (String)vector.elementAt(n2);
            if (string.equals("IMPLIED")) {
                syntaxObjectType.isimplied = true;
                syntaxObjectType.impliedNode = (String)vector.elementAt(n2 + 1);
            } else {
                int n3 = invalidOidList.size();
                SyntaxOID syntaxOID = MIBParser.getOID(string);
                syntaxObjectType.addIndex(syntaxOID.identity);
                if (invalidOidList.size() > n3) {
                    if (tcList.containsKey(string)) {
                        invalidOidList.remove(string);
                    } else if (phantomTCList.containsKey(string)) {
                        invalidOidList.remove(string);
                    }
                }
            }
            ++n2;
        }
    }

    static void initializeWellKnownTCs() {
        SyntaxTextualConvention syntaxTextualConvention = null;
        Object var1_1 = null;
        SyntaxString syntaxString = null;
        RangeList rangeList = null;
        syntaxTextualConvention = new SyntaxTextualConvention();
        syntaxString = new SyntaxString();
        Vector<Boolean> vector = new Vector<Boolean>(1);
        vector.addElement(new Boolean(true));
        Vector<Long> vector2 = new Vector<Long>(2);
        vector2.addElement(new Long(0L));
        vector2.addElement(new Long(255L));
        rangeList = new RangeList(new Vector(1), vector2, vector);
        rangeList.preDefinedRange = true;
        syntaxString.setRange(rangeList);
        syntaxString.setType(96);
        syntaxTextualConvention.setSyntax(syntaxString);
        syntaxTextualConvention.setRange(rangeList);
        syntaxTextualConvention.setName("DisplayString");
        wellKnownTCs.put("DisplayString", syntaxTextualConvention);
        syntaxTextualConvention = new SyntaxTextualConvention();
        syntaxString = new SyntaxString();
        syntaxString.setType(96);
        syntaxTextualConvention.setSyntax(syntaxString);
        syntaxTextualConvention.setName("PhysAddress");
        wellKnownTCs.put("PhysAddress", syntaxTextualConvention);
        syntaxTextualConvention = new SyntaxTextualConvention();
        syntaxString = new SyntaxString();
        syntaxString.setType(96);
        vector = new Vector(1);
        vector.addElement(new Boolean(false));
        vector2 = new Vector(1);
        vector2.addElement(new Long(6L));
        rangeList = new RangeList(new Vector(1), vector2, vector);
        rangeList.preDefinedRange = true;
        syntaxString.setRange(rangeList);
        syntaxTextualConvention.setSyntax(syntaxString);
        syntaxTextualConvention.setRange(rangeList);
        syntaxTextualConvention.setName("MacAddress");
        wellKnownTCs.put("MacAddress", syntaxTextualConvention);
    }

    public static final SyntaxNumber integer_type() throws ParseException {
        errCode = "integer_type";
        SyntaxNumber syntaxNumber = new SyntaxNumber();
        Vector vector = new Vector(5);
        Vector vector2 = new Vector(5);
        Vector vector3 = new Vector(5);
        if (MIBParser.jj_2_7(2)) {
            MIBParser.jj_consume_token(16);
            MIBParser.jj_consume_token(93);
            MIBParser.named_list(vector);
            MIBParser.jj_consume_token(94);
            syntaxNumber.setType(64);
            RangeList rangeList = new RangeList(vector, vector2, vector3);
            syntaxNumber.setRange(rangeList);
            return syntaxNumber;
        }
        if (MIBParser.jj_2_8(2)) {
            MIBParser.jj_consume_token(16);
            MIBParser.jj_consume_token(90);
            MIBParser.range(vector2, vector3);
            block6: while (true) {
                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    default: {
                        MIBParser.jj_la1[25] = jj_gen;
                        break block6;
                    }
                    case 91: {
                        MIBParser.jj_consume_token(91);
                        MIBParser.range(vector2, vector3);
                        continue block6;
                    }
                }
                break;
            }
            MIBParser.jj_consume_token(92);
            syntaxNumber.setType(64);
            RangeList rangeList = new RangeList(vector, vector2, vector3);
            syntaxNumber.setRange(rangeList);
            return syntaxNumber;
        }
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 16: {
                MIBParser.jj_consume_token(16);
                syntaxNumber.setType(64);
                return syntaxNumber;
            }
        }
        MIBParser.jj_la1[26] = jj_gen;
        MIBParser.jj_consume_token(-1);
        throw new ParseException();
    }

    static Stack invertStack(Stack stack) {
        Stack stack2 = new Stack();
        while (!stack.isEmpty()) {
            stack2.push(stack.pop());
        }
        return stack2;
    }

    public static final void item(Stack stack) throws ParseException {
        errCode = "item";
        Token token = null;
        Vector vector = new Vector(5);
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 76: {
                token = MIBParser.jj_consume_token(76);
                Long l = new Long(token.image);
                if (l <= 0xFFFFFFFFL) {
                    stack.push(new Integer(l.intValue()));
                    break;
                }
                throw new ParseException(SnmpUtils.getString("subOID value should not exceed 4294967295"));
            }
            case 98: 
            case 99: {
                MIBParser.nameNumber(vector);
                stack.push(vector.elementAt(0));
                break;
            }
            default: {
                MIBParser.jj_la1[35] = jj_gen;
                MIBParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void itemWithOIDvalue(Stack stack) throws ParseException {
        errCode = "itemWithOIDvalue";
        Token token = null;
        Token token2 = null;
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 99: {
                token = MIBParser.jj_consume_token(99);
                break;
            }
            case 98: {
                token2 = MIBParser.jj_consume_token(98);
                break;
            }
            default: {
                MIBParser.jj_la1[34] = jj_gen;
                MIBParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (token != null) {
            stack.push(token.image);
        } else {
            stack.push(token2.image);
        }
    }

    public static final void items(Stack stack) throws ParseException {
        errCode = "items";
        block3: while (true) {
            MIBParser.item(stack);
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                case 76: 
                case 98: 
                case 99: {
                    continue block3;
                }
            }
            break;
        }
        MIBParser.jj_la1[33] = jj_gen;
    }

    private static final boolean jj_2_1(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_1() ^ true;
        MIBParser.jj_save(0, n);
        return bl;
    }

    private static final boolean jj_2_10(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_10() ^ true;
        MIBParser.jj_save(9, n);
        return bl;
    }

    private static final boolean jj_2_11(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_11() ^ true;
        MIBParser.jj_save(10, n);
        return bl;
    }

    private static final boolean jj_2_12(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_12() ^ true;
        MIBParser.jj_save(11, n);
        return bl;
    }

    private static final boolean jj_2_13(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_13() ^ true;
        MIBParser.jj_save(12, n);
        return bl;
    }

    private static final boolean jj_2_14(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_14() ^ true;
        MIBParser.jj_save(13, n);
        return bl;
    }

    private static final boolean jj_2_15(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_15() ^ true;
        MIBParser.jj_save(14, n);
        return bl;
    }

    private static final boolean jj_2_16(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_16() ^ true;
        MIBParser.jj_save(15, n);
        return bl;
    }

    private static final boolean jj_2_17(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_17() ^ true;
        MIBParser.jj_save(16, n);
        return bl;
    }

    private static final boolean jj_2_18(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_18() ^ true;
        MIBParser.jj_save(17, n);
        return bl;
    }

    private static final boolean jj_2_19(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_19() ^ true;
        MIBParser.jj_save(18, n);
        return bl;
    }

    private static final boolean jj_2_2(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_2() ^ true;
        MIBParser.jj_save(1, n);
        return bl;
    }

    private static final boolean jj_2_20(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_20() ^ true;
        MIBParser.jj_save(19, n);
        return bl;
    }

    private static final boolean jj_2_21(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_21() ^ true;
        MIBParser.jj_save(20, n);
        return bl;
    }

    private static final boolean jj_2_22(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_22() ^ true;
        MIBParser.jj_save(21, n);
        return bl;
    }

    private static final boolean jj_2_3(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_3() ^ true;
        MIBParser.jj_save(2, n);
        return bl;
    }

    private static final boolean jj_2_4(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_4() ^ true;
        MIBParser.jj_save(3, n);
        return bl;
    }

    private static final boolean jj_2_5(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_5() ^ true;
        MIBParser.jj_save(4, n);
        return bl;
    }

    private static final boolean jj_2_6(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_6() ^ true;
        MIBParser.jj_save(5, n);
        return bl;
    }

    private static final boolean jj_2_7(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_7() ^ true;
        MIBParser.jj_save(6, n);
        return bl;
    }

    private static final boolean jj_2_8(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_8() ^ true;
        MIBParser.jj_save(7, n);
        return bl;
    }

    private static final boolean jj_2_9(int n) {
        jj_la = n;
        jj_lastpos = jj_scanpos = token;
        boolean bl = MIBParser.jj_3_9() ^ true;
        MIBParser.jj_save(8, n);
        return bl;
    }

    private static final boolean jj_3R_100() {
        if (MIBParser.jj_scan_token(98)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_101() {
        if (MIBParser.jj_scan_token(76)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_102() {
        if (MIBParser.jj_3R_30()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_103() {
        if (MIBParser.jj_scan_token(77)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_104() {
        if (MIBParser.jj_scan_token(78)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_105() {
        if (MIBParser.jj_scan_token(76)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_106() {
        if (MIBParser.jj_scan_token(19)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_107() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_113()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_114()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_108() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_115()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_116()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_109() {
        if (MIBParser.jj_scan_token(58)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_110() {
        if (MIBParser.jj_scan_token(6)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_111() {
        if (MIBParser.jj_scan_token(7)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_112() {
        if (MIBParser.jj_scan_token(8)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_113() {
        if (MIBParser.jj_scan_token(16)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_114() {
        if (MIBParser.jj_scan_token(18)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_115() {
        if (MIBParser.jj_scan_token(5)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_116() {
        if (MIBParser.jj_scan_token(14)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_117() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3_9()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_121()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_118() {
        if (MIBParser.jj_scan_token(91)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_117()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_119() {
        if (MIBParser.jj_scan_token(91)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_117()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_120() {
        Token token;
        block3: {
            if (MIBParser.jj_3R_30()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            do {
                token = jj_scanpos;
                if (MIBParser.jj_3R_122()) break block3;
            } while (jj_la != 0 || jj_scanpos != jj_lastpos);
            return false;
        }
        jj_scanpos = token;
        return false;
    }

    private static final boolean jj_3R_121() {
        if (MIBParser.jj_3R_29()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_122() {
        if (MIBParser.jj_scan_token(89)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_30()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_20() {
        if (MIBParser.jj_scan_token(79)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(57)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_21() {
        Token token = jj_scanpos;
        lookingAhead = true;
        jj_semLA = MIBParser.getToken((int)0).image.equals("NsapAddress") | MIBParser.getToken((int)0).image.equals("UInteger32");
        lookingAhead = false;
        if (!jj_semLA || MIBParser.jj_3R_46()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_47()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_22() {
        if (MIBParser.jj_3R_48()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_31()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_23() {
        if (MIBParser.jj_scan_token(16)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_24() {
        if (MIBParser.jj_scan_token(18)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_25() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_49()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_50()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_26() {
        if (MIBParser.jj_scan_token(5)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_27() {
        if (MIBParser.jj_scan_token(14)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_28() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3_6()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_51()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_29() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_52()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_53()) {
                jj_scanpos = token;
                if (MIBParser.jj_3R_54()) {
                    return true;
                }
                if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                    return false;
                }
            } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_30() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_55()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_56()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(90)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_73()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(92)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_31() {
        if (MIBParser.jj_3R_57()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_32() {
        Token token = jj_scanpos;
        lookingAhead = true;
        jj_semLA = accessTable.containsKey(MIBParser.getToken((int)1).image);
        lookingAhead = false;
        if (!jj_semLA || MIBParser.jj_3R_58()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(99)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_33() {
        Token token = jj_scanpos;
        lookingAhead = true;
        jj_semLA = MIBParser.getToken((int)1).image.equals("mandatory") || MIBParser.getToken((int)1).image.equals("deprecated") || MIBParser.getToken((int)1).image.equals("obsolete") || MIBParser.getToken((int)1).image.equals("optional");
        lookingAhead = false;
        if (!jj_semLA || MIBParser.jj_3R_59()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(99)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_34() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_60()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_61()) {
                jj_scanpos = token;
                if (MIBParser.jj_3R_62()) {
                    return true;
                }
                if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                    return false;
                }
            } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_35() {
        if (MIBParser.jj_3R_48()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_43()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_36() {
        if (MIBParser.jj_scan_token(99)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_37() {
        if (MIBParser.jj_scan_token(98)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_38() {
        Token token = jj_scanpos;
        lookingAhead = true;
        jj_semLA = MIBParser.getToken((int)1).image.equals("not-accessible");
        lookingAhead = false;
        if (!jj_semLA || MIBParser.jj_3R_63()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(99)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_39() {
        if (MIBParser.jj_scan_token(67)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(75)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_40() {
        if (MIBParser.jj_scan_token(44)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(75)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_41() {
        if (MIBParser.jj_scan_token(97)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_42() {
        if (MIBParser.jj_3R_64()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_43() {
        if (MIBParser.jj_3R_65()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_66()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_67()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_68()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_44() {
        if (MIBParser.jj_scan_token(98)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(97)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_45() {
        Token token;
        block3: {
            if (MIBParser.jj_3R_69()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            do {
                token = jj_scanpos;
                if (MIBParser.jj_3R_70()) break block3;
            } while (jj_la != 0 || jj_scanpos != jj_lastpos);
            return false;
        }
        jj_scanpos = token;
        return false;
    }

    private static final boolean jj_3R_46() {
        return false;
    }

    private static final boolean jj_3R_47() {
        if (MIBParser.jj_scan_token(79)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_71()) {
            jj_scanpos = token;
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        token = jj_scanpos;
        if (MIBParser.jj_3R_72()) {
            jj_scanpos = token;
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_48() {
        if (MIBParser.jj_scan_token(79)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_49() {
        Token token;
        block7: {
            if (MIBParser.jj_scan_token(90)) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            if (MIBParser.jj_3R_117()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            do {
                token = jj_scanpos;
                if (MIBParser.jj_3R_119()) break block7;
            } while (jj_la != 0 || jj_scanpos != jj_lastpos);
            return false;
        }
        jj_scanpos = token;
        if (MIBParser.jj_scan_token(92)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_50() {
        if (MIBParser.jj_scan_token(93)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_120()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(94)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_51() {
        if (MIBParser.jj_3R_25()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_52() {
        if (MIBParser.jj_scan_token(24)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_53() {
        if (MIBParser.jj_scan_token(25)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_54() {
        if (MIBParser.jj_3R_73()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_55() {
        if (MIBParser.jj_scan_token(99)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_56() {
        if (MIBParser.jj_scan_token(98)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_57() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_74()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_75()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_58() {
        return false;
    }

    private static final boolean jj_3R_59() {
        return false;
    }

    private static final boolean jj_3R_60() {
        if (MIBParser.jj_scan_token(67)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(75)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_61() {
        if (MIBParser.jj_scan_token(44)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(75)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_62() {
        if (MIBParser.jj_scan_token(42)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        Token token = jj_scanpos;
        if (MIBParser.jj_3_12()) {
            jj_scanpos = token;
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_76()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        token = jj_scanpos;
        if (MIBParser.jj_3R_77()) {
            jj_scanpos = token;
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_63() {
        return false;
    }

    private static final boolean jj_3R_64() {
        if (MIBParser.jj_scan_token(97)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(76)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_65() {
        if (MIBParser.jj_scan_token(93)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_66() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_78()) {
            jj_scanpos = token;
            if (MIBParser.jj_3_10()) {
                jj_scanpos = token;
                lookingAhead = true;
                jj_semLA = MIBParser.getToken((int)1).image.equals("iso") || MIBParser.getToken((int)1).image.equals("ccitt") || MIBParser.getToken((int)1).image.equals("joint-iso-ccitt");
                lookingAhead = false;
                if (!jj_semLA || MIBParser.jj_3R_79()) {
                    jj_scanpos = token;
                    lookingAhead = true;
                    jj_semLA = oidList.containsKey(MIBParser.getToken((int)1).image) || phantomOidList.containsKey(MIBParser.getToken((int)1).image) || imports.contains(MIBParser.getToken((int)1).image);
                    lookingAhead = false;
                    if (!jj_semLA || MIBParser.jj_3R_80()) {
                        jj_scanpos = token;
                        if (MIBParser.jj_3R_81()) {
                            return true;
                        }
                        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                            return false;
                        }
                    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                        return false;
                    }
                } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                    return false;
                }
            } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_67() {
        Token token;
        block3: {
            if (MIBParser.jj_3R_82()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            do {
                token = jj_scanpos;
                if (MIBParser.jj_3R_82()) break block3;
            } while (jj_la != 0 || jj_scanpos != jj_lastpos);
            return false;
        }
        jj_scanpos = token;
        return false;
    }

    private static final boolean jj_3R_68() {
        if (MIBParser.jj_scan_token(94)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_69() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_83()) {
            jj_scanpos = token;
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(99)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_70() {
        if (MIBParser.jj_scan_token(89)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_69()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_71() {
        if (MIBParser.jj_scan_token(4)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_72() {
        if (MIBParser.jj_scan_token(53)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_73() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_84()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_85()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_74() {
        if (MIBParser.jj_3R_86()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_75() {
        if (MIBParser.jj_3R_87()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_76() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_88()) {
            jj_scanpos = token;
            if (MIBParser.jj_3_16()) {
                jj_scanpos = token;
                if (MIBParser.jj_3_17()) {
                    jj_scanpos = token;
                    if (MIBParser.jj_3R_89()) {
                        jj_scanpos = token;
                        if (MIBParser.jj_3R_90()) {
                            jj_scanpos = token;
                            if (MIBParser.jj_3R_91()) {
                                jj_scanpos = token;
                                if (MIBParser.jj_3_18()) {
                                    jj_scanpos = token;
                                    if (MIBParser.jj_3_19()) {
                                        jj_scanpos = token;
                                        if (MIBParser.jj_3_20()) {
                                            jj_scanpos = token;
                                            if (MIBParser.jj_3R_92()) {
                                                jj_scanpos = token;
                                                if (MIBParser.jj_3_21()) {
                                                    return true;
                                                }
                                                if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                                                return false;
                                            }
                                        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                                            return false;
                                        }
                                    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                                        return false;
                                    }
                                } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                                    return false;
                                }
                            } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                                return false;
                            }
                        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                            return false;
                        }
                    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                        return false;
                    }
                } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                    return false;
                }
            } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_77() {
        if (MIBParser.jj_scan_token(94)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_78() {
        if (MIBParser.jj_scan_token(76)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_79() {
        if (MIBParser.jj_3R_93()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_80() {
        if (MIBParser.jj_3R_94()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_81() {
        if (MIBParser.jj_3R_94()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_82() {
        if (MIBParser.jj_3R_95()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_83() {
        if (MIBParser.jj_scan_token(98)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(97)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_84() {
        if (MIBParser.jj_scan_token(95)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_96()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_85() {
        if (MIBParser.jj_3R_96()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_86() {
        if (MIBParser.jj_3R_97()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_87() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3_11()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_98()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_88() {
        if (MIBParser.jj_scan_token(75)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_89() {
        if (MIBParser.jj_scan_token(95)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(76)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_90() {
        if (MIBParser.jj_scan_token(78)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_91() {
        if (MIBParser.jj_scan_token(77)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_92() {
        if (MIBParser.jj_scan_token(98)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_93() {
        if (MIBParser.jj_scan_token(99)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_94() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_99()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_100()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_95() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_101()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_102()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_96() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_103()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_104()) {
                jj_scanpos = token;
                if (MIBParser.jj_3R_105()) {
                    return true;
                }
                if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                    return false;
                }
            } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_97() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_106()) {
            jj_scanpos = token;
            if (MIBParser.jj_3_4()) {
                jj_scanpos = token;
                if (MIBParser.jj_3R_107()) {
                    jj_scanpos = token;
                    if (MIBParser.jj_3_5()) {
                        jj_scanpos = token;
                        if (MIBParser.jj_3R_108()) {
                            jj_scanpos = token;
                            if (MIBParser.jj_3R_109()) {
                                jj_scanpos = token;
                                if (MIBParser.jj_3R_110()) {
                                    jj_scanpos = token;
                                    if (MIBParser.jj_3R_111()) {
                                        jj_scanpos = token;
                                        if (MIBParser.jj_3R_112()) {
                                            return true;
                                        }
                                        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                                            return false;
                                        }
                                    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                                        return false;
                                    }
                                } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                                    return false;
                                }
                            } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                                return false;
                            }
                        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                            return false;
                        }
                    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                        return false;
                    }
                } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                    return false;
                }
            } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_98() {
        if (MIBParser.jj_scan_token(98)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3R_99() {
        if (MIBParser.jj_scan_token(99)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_1() {
        if (MIBParser.jj_3R_20()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_10() {
        if (MIBParser.jj_3R_30()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_11() {
        if (MIBParser.jj_scan_token(98)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_28()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_12() {
        if (MIBParser.jj_scan_token(93)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_13() {
        Token token;
        block17: {
            if (MIBParser.jj_scan_token(52)) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            if (MIBParser.jj_scan_token(72)) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            if (MIBParser.jj_3R_31()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            if (MIBParser.jj_scan_token(22)) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            if (MIBParser.jj_3R_32()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            if (MIBParser.jj_scan_token(20)) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            if (MIBParser.jj_3R_33()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            do {
                token = jj_scanpos;
                if (MIBParser.jj_3R_34()) break block17;
            } while (jj_la != 0 || jj_scanpos != jj_lastpos);
            return false;
        }
        jj_scanpos = token;
        if (MIBParser.jj_3R_35()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_14() {
        if (MIBParser.jj_scan_token(52)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(72)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(56)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_36()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_37()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(22)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_38()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(20)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_33()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        token = jj_scanpos;
        if (MIBParser.jj_3R_39()) {
            jj_scanpos = token;
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        token = jj_scanpos;
        if (MIBParser.jj_3R_40()) {
            jj_scanpos = token;
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_35()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_15() {
        if (MIBParser.jj_scan_token(98)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(97)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_16() {
        Token token;
        block6: {
            token = jj_scanpos;
            if (MIBParser.jj_3R_41()) {
                jj_scanpos = token;
            } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            if (MIBParser.jj_scan_token(76)) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            do {
                token = jj_scanpos;
                if (MIBParser.jj_3R_42()) break block6;
            } while (jj_la != 0 || jj_scanpos != jj_lastpos);
            return false;
        }
        jj_scanpos = token;
        return false;
    }

    private static final boolean jj_3_17() {
        if (MIBParser.jj_scan_token(76)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_18() {
        if (MIBParser.jj_3R_43()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_19() {
        if (MIBParser.jj_scan_token(99)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(97)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(99)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_2() {
        if (MIBParser.jj_3R_21()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_20() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_44()) {
            jj_scanpos = token;
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(99)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_21() {
        if (MIBParser.jj_scan_token(93)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_45()) {
            jj_scanpos = token;
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(94)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_22() {
        if (MIBParser.jj_3R_20()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_3() {
        if (MIBParser.jj_3R_22()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_4() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_23()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_24()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_25()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_5() {
        Token token = jj_scanpos;
        if (MIBParser.jj_3R_26()) {
            jj_scanpos = token;
            if (MIBParser.jj_3R_27()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
        } else if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_28()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_6() {
        Token token;
        block13: {
            if (MIBParser.jj_scan_token(90)) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            if (MIBParser.jj_scan_token(65)) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            if (MIBParser.jj_scan_token(90)) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            if (MIBParser.jj_3R_117()) {
                return true;
            }
            if (jj_la == 0 && jj_scanpos == jj_lastpos) {
                return false;
            }
            do {
                token = jj_scanpos;
                if (MIBParser.jj_3R_118()) break block13;
            } while (jj_la != 0 || jj_scanpos != jj_lastpos);
            return false;
        }
        jj_scanpos = token;
        if (MIBParser.jj_scan_token(92)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(92)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_7() {
        if (MIBParser.jj_scan_token(16)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(93)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_8() {
        if (MIBParser.jj_scan_token(16)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(90)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static final boolean jj_3_9() {
        if (MIBParser.jj_3R_29()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_scan_token(96)) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        if (MIBParser.jj_3R_29()) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            return false;
        }
        return false;
    }

    private static void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == jj_endpos + 1) {
            MIBParser.jj_lasttokens[MIBParser.jj_endpos++] = n;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            int n3 = 0;
            while (n3 < jj_endpos) {
                MIBParser.jj_expentry[n3] = jj_lasttokens[n3];
                ++n3;
            }
            boolean bl = false;
            Enumeration enumeration = jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != jj_expentry.length) continue;
                bl = true;
                int n4 = 0;
                while (n4 < jj_expentry.length) {
                    if (nArray[n4] != jj_expentry[n4]) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
                if (bl) break;
            }
            if (!bl) {
                jj_expentries.addElement(jj_expentry);
            }
            if (n2 != 0) {
                jj_endpos = n2;
                MIBParser.jj_lasttokens[MIBParser.jj_endpos - 1] = n;
            }
        }
    }

    private static final Token jj_consume_token(int n) throws ParseException {
        Token token = MIBParser.token;
        MIBParser.token = token.next != null ? MIBParser.token.next : (MIBParser.token.next = MIBParserTokenManager.getNextToken());
        jj_ntk = -1;
        if (MIBParser.token.kind == n) {
            ++jj_gen;
            if (++jj_gc > 100) {
                jj_gc = 0;
                int n2 = 0;
                while (n2 < jj_2_rtns.length) {
                    JJCalls jJCalls = jj_2_rtns[n2];
                    while (jJCalls != null) {
                        if (jJCalls.gen < jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                    ++n2;
                }
            }
            return MIBParser.token;
        }
        MIBParser.token = token;
        jj_kind = n;
        throw MIBParser.generateParseException();
    }

    private static final int jj_ntk() {
        jj_nt = MIBParser.token.next;
        if (jj_nt == null) {
            MIBParser.token.next = MIBParserTokenManager.getNextToken();
            jj_ntk = MIBParser.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = MIBParser.jj_nt.kind;
        return jj_ntk;
    }

    private static final void jj_rescan_token() {
        jj_rescan = true;
        int n = 0;
        while (n < 22) {
            JJCalls jJCalls = jj_2_rtns[n];
            do {
                if (jJCalls.gen <= jj_gen) continue;
                jj_la = jJCalls.arg;
                jj_lastpos = jj_scanpos = jJCalls.first;
                switch (n) {
                    case 0: {
                        MIBParser.jj_3_1();
                        break;
                    }
                    case 1: {
                        MIBParser.jj_3_2();
                        break;
                    }
                    case 2: {
                        MIBParser.jj_3_3();
                        break;
                    }
                    case 3: {
                        MIBParser.jj_3_4();
                        break;
                    }
                    case 4: {
                        MIBParser.jj_3_5();
                        break;
                    }
                    case 5: {
                        MIBParser.jj_3_6();
                        break;
                    }
                    case 6: {
                        MIBParser.jj_3_7();
                        break;
                    }
                    case 7: {
                        MIBParser.jj_3_8();
                        break;
                    }
                    case 8: {
                        MIBParser.jj_3_9();
                        break;
                    }
                    case 9: {
                        MIBParser.jj_3_10();
                        break;
                    }
                    case 10: {
                        MIBParser.jj_3_11();
                        break;
                    }
                    case 11: {
                        MIBParser.jj_3_12();
                        break;
                    }
                    case 12: {
                        MIBParser.jj_3_13();
                        break;
                    }
                    case 13: {
                        MIBParser.jj_3_14();
                        break;
                    }
                    case 14: {
                        MIBParser.jj_3_15();
                        break;
                    }
                    case 15: {
                        MIBParser.jj_3_16();
                        break;
                    }
                    case 16: {
                        MIBParser.jj_3_17();
                        break;
                    }
                    case 17: {
                        MIBParser.jj_3_18();
                        break;
                    }
                    case 18: {
                        MIBParser.jj_3_19();
                        break;
                    }
                    case 19: {
                        MIBParser.jj_3_20();
                        break;
                    }
                    case 20: {
                        MIBParser.jj_3_21();
                        break;
                    }
                    case 21: {
                        MIBParser.jj_3_22();
                        break;
                    }
                }
            } while ((jJCalls = jJCalls.next) != null);
            ++n;
        }
        jj_rescan = false;
    }

    private static final void jj_save(int n, int n2) {
        JJCalls jJCalls = jj_2_rtns[n];
        while (jJCalls.gen > jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = jj_gen + n2 - jj_la;
        jJCalls.first = token;
        jJCalls.arg = n2;
    }

    private static final boolean jj_scan_token(int n) {
        if (jj_scanpos == jj_lastpos) {
            --jj_la;
            if (MIBParser.jj_scanpos.next == null) {
                jj_scanpos = MIBParser.jj_scanpos.next = MIBParserTokenManager.getNextToken();
                jj_lastpos = MIBParser.jj_scanpos.next;
            } else {
                jj_lastpos = jj_scanpos = MIBParser.jj_scanpos.next;
            }
        } else {
            jj_scanpos = MIBParser.jj_scanpos.next;
        }
        if (jj_rescan) {
            int n2 = 0;
            Token token = MIBParser.token;
            while (token != null && token != jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                MIBParser.jj_add_error_token(n, n2);
            }
        }
        return MIBParser.jj_scanpos.kind != n;
    }

    public static final String lastUpdated() throws ParseException {
        errCode = "lastUpdated";
        String string = MIBParser.quotedString();
        return string;
    }

    public static final BaseSyntax lcConstruct() throws ParseException {
        errCode = "lcConstruct";
        Object var0 = null;
        SyntaxOID syntaxOID = null;
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 52: {
                syntaxOID = MIBParser.object_type_construct();
                return syntaxOID;
            }
            case 58: {
                MIBParser.tokObjectIdentifier();
                syntaxOID = MIBParser.object_identifier_type();
                return syntaxOID;
            }
            case 32: {
                SyntaxTrapType syntaxTrapType = MIBParser.trap_type_construct();
                return syntaxTrapType;
            }
            case 79: {
                BaseSyntax baseSyntax = MIBParser.sequence_construct();
                return baseSyntax;
            }
        }
        MIBParser.jj_la1[4] = jj_gen;
        MIBParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final void lcObject(Vector vector) throws ParseException {
        errCode = errCode.equals("tokENTERPRISES") ? "entLcObject" : "lcObject";
        Token token = null;
        Token token2 = null;
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 98: {
                token = MIBParser.jj_consume_token(98);
                MIBParser.jj_consume_token(97);
                break;
            }
            default: {
                MIBParser.jj_la1[36] = jj_gen;
            }
        }
        token2 = MIBParser.jj_consume_token(99);
        StringBuffer stringBuffer = new StringBuffer(30);
        if (token != null && !token.image.equals(moduleName)) {
            stringBuffer.append(token.image);
            stringBuffer.append(".");
        }
        stringBuffer.append(token2.image);
        vector.addElement(stringBuffer.toString());
    }

    public static final void leftBrace() throws ParseException {
        errCode = "leftBrace";
        MIBParser.jj_consume_token(93);
    }

    public static final void macroDefinition() throws ParseException {
        Token token = MIBParser.jj_consume_token(69);
        MIBParser.jj_consume_token(79);
        MIBParser.jj_consume_token(73);
        block0 : switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 82: {
                Token token2 = MIBParser.jj_consume_token(82);
                MIBParser.jj_consume_token(79);
                while (true) {
                    switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                        default: {
                            MIBParser.jj_la1[72] = jj_gen;
                            break block0;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 14: 
                        case 16: 
                        case 18: 
                        case 19: 
                        case 32: 
                        case 52: 
                        case 58: 
                        case 72: 
                        case 75: 
                        case 76: 
                        case 79: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 98: 
                        case 99: 
                    }
                    MIBParser.anyInputs();
                }
            }
            default: {
                MIBParser.jj_la1[73] = jj_gen;
            }
        }
        block6 : switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 81: {
                Token token3 = MIBParser.jj_consume_token(81);
                MIBParser.jj_consume_token(79);
                while (true) {
                    switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                        default: {
                            MIBParser.jj_la1[74] = jj_gen;
                            break block6;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 14: 
                        case 16: 
                        case 18: 
                        case 19: 
                        case 32: 
                        case 52: 
                        case 58: 
                        case 72: 
                        case 75: 
                        case 76: 
                        case 79: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 98: 
                        case 99: 
                    }
                    MIBParser.anyInputs();
                }
            }
            default: {
                MIBParser.jj_la1[75] = jj_gen;
            }
        }
        MIBParser.jj_consume_token(74);
    }

    public static final void macroDefinitionOmission() throws ParseException {
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 69: {
                MIBParser.macroDefinition();
                return;
            }
        }
        MIBParser.jj_la1[70] = jj_gen;
        if (MIBParser.jj_2_22(2)) {
            MIBParser.choice();
            return;
        }
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 79: {
                MIBParser.dataTypeDecl();
                return;
            }
        }
        MIBParser.jj_la1[71] = jj_gen;
        MIBParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final String moduleIdentifier() throws ParseException {
        errCode = "moduleIdentifier";
        SyntaxOID syntaxOID = null;
        Token token = null;
        token = MIBParser.jj_consume_token(98);
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 93: {
                syntaxOID = MIBParser.oidValue();
                break;
            }
            default: {
                MIBParser.jj_la1[8] = jj_gen;
            }
        }
        return token.image;
    }

    public static final void nameNumber(Vector vector) throws ParseException {
        errCode = macroType.equals("OTR") ? "tokSEQUENCE" : "nameNumber";
        Token token = null;
        Token token2 = null;
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 99: {
                token = MIBParser.jj_consume_token(99);
                break;
            }
            case 98: {
                token2 = MIBParser.jj_consume_token(98);
                break;
            }
            default: {
                MIBParser.jj_la1[30] = jj_gen;
                MIBParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        MIBParser.jj_consume_token(90);
        long l = MIBParser.signed();
        MIBParser.jj_consume_token(92);
        if (token != null) {
            NameNumber nameNumber = new NameNumber(token.image, l);
            vector.addElement(nameNumber);
        } else {
            NameNumber nameNumber = new NameNumber(token2.image, l);
            vector.addElement(nameNumber);
        }
    }

    public static final void named_list(Vector vector) throws ParseException {
        errCode = "named_list";
        Vector vector2 = new Vector(5);
        MIBParser.nameNumber(vector2);
        block3: while (true) {
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                default: {
                    MIBParser.jj_la1[29] = jj_gen;
                    break block3;
                }
                case 89: {
                    MIBParser.jj_consume_token(89);
                    MIBParser.nameNumber(vector2);
                    continue block3;
                }
            }
            break;
        }
        int n = 0;
        while (n < vector2.size()) {
            String string = ((NameNumber)vector2.elementAt(n)).getName();
            long l = ((NameNumber)vector2.elementAt(n)).getNumber();
            vector.addElement(string);
            vector.addElement(new Long(l));
            ++n;
        }
        if (JDBC) {
            enumVector = (Vector)vector.clone();
            rangeVector = new Vector();
        }
    }

    public static final void noAccess() throws ParseException {
        if (!MIBParser.getToken((int)1).image.equals("not-accessible")) {
            MIBParser.jj_consume_token(-1);
            throw new ParseException();
        }
        MIBParser.jj_consume_token(99);
    }

    public static final long number() throws ParseException {
        errCode = "number";
        String string = null;
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 77: {
                MIBParser.jj_consume_token(77);
                string = MIBParser.token.image;
                int n = string.length();
                string = string.startsWith("'") && string.charAt(n - 2) == '\'' ? string.substring(1, n - 2) : string.substring(0, n - 1);
                return Long.parseLong(string, 16);
            }
            case 78: {
                MIBParser.jj_consume_token(78);
                string = MIBParser.token.image;
                string = string.substring(1, string.length() - 2);
                return Long.parseLong(string, 2);
            }
            case 76: {
                MIBParser.jj_consume_token(76);
                return Long.parseLong(MIBParser.token.image);
            }
        }
        MIBParser.jj_la1[24] = jj_gen;
        MIBParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final SyntaxOID object_identifier_construct() throws ParseException {
        errCode = "object_idenitifier_construct";
        MIBParser.jj_consume_token(58);
        SyntaxOID syntaxOID = MIBParser.object_identifier_type();
        return syntaxOID;
    }

    public static final SyntaxOID object_identifier_type() throws ParseException {
        errCode = "object_idenitifier_type";
        Token token = MIBParser.tokAssignment();
        SyntaxOID syntaxOID = MIBParser.oidValue();
        if (JDBC) {
            macroType = "OID";
        }
        syntaxOID.commentObj.commentStr = MIBParser.extractComments(token.specialToken);
        return syntaxOID;
    }

    public static final SyntaxOID object_type_construct() throws ParseException {
        errCode = "object_type_construct";
        SyntaxObjectType syntaxObjectType = new SyntaxObjectType();
        String string = BaseSyntax.NullString;
        String string2 = BaseSyntax.NullString;
        String string3 = null;
        String string4 = BaseSyntax.NullString;
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        Token token5 = null;
        Token token6 = null;
        Token token7 = null;
        Token token8 = null;
        Token token9 = null;
        Token token10 = null;
        Token token11 = null;
        Token token12 = null;
        Token token13 = null;
        Token token14 = null;
        if (MIBParser.jj_2_13(100)) {
            token9 = MIBParser.jj_consume_token(52);
            token8 = MIBParser.jj_consume_token(72);
            BaseSyntax baseSyntax = MIBParser.simpleEnumOrBit();
            token6 = MIBParser.jj_consume_token(22);
            int n = MIBParser.capAccess();
            token5 = MIBParser.jj_consume_token(20);
            int n2 = MIBParser.statusV1();
            block31: while (true) {
                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    default: {
                        MIBParser.jj_la1[39] = jj_gen;
                        break block31;
                    }
                    case 42: 
                    case 44: 
                    case 67: {
                        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                            case 67: {
                                token4 = MIBParser.jj_consume_token(67);
                                token11 = MIBParser.jj_consume_token(75);
                                continue block31;
                            }
                            case 44: {
                                token3 = MIBParser.jj_consume_token(44);
                                token10 = MIBParser.jj_consume_token(75);
                                continue block31;
                            }
                            case 42: {
                                token2 = MIBParser.jj_consume_token(42);
                                if (MIBParser.jj_2_12(2)) {
                                    token13 = MIBParser.jj_consume_token(93);
                                }
                                MIBParser.defVal(syntaxObjectType);
                                if (token13 == null) continue block31;
                                token14 = MIBParser.jj_consume_token(94);
                                continue block31;
                            }
                        }
                        MIBParser.jj_la1[40] = jj_gen;
                        MIBParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                break;
            }
            SyntaxOID syntaxOID = MIBParser.object_identifier_type();
            if (token12 != null) {
                string4 = token12.image;
                unitString = String.valueOf(unitString) + moduleName + "#" + syntaxOID.toString() + "#" + MIBParser.convertSQLData(string4) + "$";
            }
            if (token11 != null) {
                string = token11.image;
            }
            if (token10 != null) {
                string2 = token10.image;
            }
            syntaxObjectType.setStatus(n2);
            syntaxObjectType.setSyntax(baseSyntax);
            syntaxObjectType.setAccess(n);
            syntaxObjectType.setDescription(string);
            syntaxObjectType.setReference(string2);
            syntaxObjectType.assign(syntaxOID);
            syntaxOID.commentObj.objType = MIBParser.extractComments(token9.specialToken);
            syntaxOID.commentObj.syntax = MIBParser.extractComments(token8.specialToken);
            syntaxOID.commentObj.access = MIBParser.extractComments(token6.specialToken);
            syntaxOID.commentObj.status = MIBParser.extractComments(token5.specialToken);
            if (token4 != null) {
                syntaxOID.commentObj.description = MIBParser.extractComments(token4.specialToken);
            }
            if (token2 != null) {
                syntaxOID.commentObj.defval = MIBParser.extractComments(token2.specialToken);
            }
            if (token3 != null) {
                syntaxOID.commentObj.reference = MIBParser.extractComments(token3.specialToken);
            }
            if (JDBC) {
                refer = string2;
                descrip = string;
                if (string2.equals("")) {
                    refer = null;
                }
                if ((defStr = syntaxObjectType.getDefVal()).equals("")) {
                    defStr = null;
                }
                if (string.equals("")) {
                    descrip = null;
                }
                boolean bl = false;
                otString = String.valueOf(otString) + syntaxOID.toString() + "#" + syntaxName + "#" + accessName + "#" + statusName + "#" + MIBParser.convertSQLData(descrip) + "#" + MIBParser.convertSQLData(refer) + "#" + MIBParser.convertSQLData(defStr) + "$";
                if (rangeVector.size() > 0 || enumVector.size() > 0) {
                    rangeString = String.valueOf(rangeString) + syntaxOID.toString() + "#" + rangeVector.toString() + "#" + enumVector.toString() + "$";
                    rangeVector = new Vector();
                    enumVector = new Vector();
                }
                macroType = "OT";
                syntaxName = "";
                rangeVector = new Vector();
                enumVector = new Vector();
            }
            syntaxObjectType.commentObj = syntaxOID.commentObj;
            return syntaxObjectType;
        }
        if (MIBParser.jj_2_14(200)) {
            token9 = MIBParser.jj_consume_token(52);
            token8 = MIBParser.jj_consume_token(72);
            MIBParser.jj_consume_token(56);
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                case 99: {
                    token12 = MIBParser.jj_consume_token(99);
                    break;
                }
                case 98: {
                    token12 = MIBParser.jj_consume_token(98);
                    break;
                }
                default: {
                    MIBParser.jj_la1[41] = jj_gen;
                    MIBParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            token6 = MIBParser.jj_consume_token(22);
            MIBParser.noAccess();
            token5 = MIBParser.jj_consume_token(20);
            int n = MIBParser.statusV1();
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                case 67: {
                    token4 = MIBParser.jj_consume_token(67);
                    token11 = MIBParser.jj_consume_token(75);
                    break;
                }
                default: {
                    MIBParser.jj_la1[42] = jj_gen;
                }
            }
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                case 44: {
                    token3 = MIBParser.jj_consume_token(44);
                    token10 = MIBParser.jj_consume_token(75);
                    break;
                }
                default: {
                    MIBParser.jj_la1[43] = jj_gen;
                }
            }
            SyntaxOID syntaxOID = MIBParser.object_identifier_type();
            string3 = token12.image;
            if (token11 != null) {
                string = token11.image;
            }
            if (token10 != null) {
                string2 = token10.image;
            }
            syntaxObjectType.setStatus(n);
            syntaxObjectType.setAccess((Integer)accessTable.get("not-accessible"));
            syntaxObjectType.setDescription(string);
            syntaxObjectType.setReference(string2);
            syntaxObjectType.setSequence(string3);
            if (!sequenceList.containsKey(string3) && !invalidSequenceList.containsKey(string3)) {
                invalidSequenceList.put(string3, new SyntaxSequence());
            }
            syntaxObjectType.assign(syntaxOID);
            syntaxOID.commentObj.objType = MIBParser.extractComments(token9.specialToken);
            syntaxOID.commentObj.syntax = MIBParser.extractComments(token8.specialToken);
            syntaxOID.commentObj.access = MIBParser.extractComments(token6.specialToken);
            syntaxOID.commentObj.status = MIBParser.extractComments(token5.specialToken);
            if (token4 != null) {
                syntaxOID.commentObj.description = MIBParser.extractComments(token4.specialToken);
            }
            if (token2 != null) {
                syntaxOID.commentObj.defval = MIBParser.extractComments(token2.specialToken);
            }
            if (token3 != null) {
                syntaxOID.commentObj.reference = MIBParser.extractComments(token3.specialToken);
            }
            syntaxObjectType.commentObj = syntaxOID.commentObj;
            if (JDBC) {
                refer = string2;
                descrip = string;
                if (string2.equals("")) {
                    refer = null;
                }
                if (string.equals("")) {
                    descrip = null;
                }
                ottString = String.valueOf(ottString) + syntaxOID.toString() + "#" + string3 + "#" + "not-accessible" + "#" + statusName + "#" + MIBParser.convertSQLData(descrip) + "#" + MIBParser.convertSQLData(refer) + "#" + nullStr + "$";
                macroType = "OTT";
            }
            return syntaxObjectType;
        }
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 52: {
                token9 = MIBParser.jj_consume_token(52);
                token8 = MIBParser.jj_consume_token(72);
                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    case 99: {
                        token12 = MIBParser.jj_consume_token(99);
                        break;
                    }
                    case 98: {
                        token12 = MIBParser.jj_consume_token(98);
                        break;
                    }
                    default: {
                        MIBParser.jj_la1[44] = jj_gen;
                        MIBParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                token6 = MIBParser.jj_consume_token(22);
                MIBParser.noAccess();
                token5 = MIBParser.jj_consume_token(20);
                int n = MIBParser.statusV1();
                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    case 67: {
                        token4 = MIBParser.jj_consume_token(67);
                        token11 = MIBParser.jj_consume_token(75);
                        break;
                    }
                    default: {
                        MIBParser.jj_la1[45] = jj_gen;
                    }
                }
                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    case 44: {
                        token3 = MIBParser.jj_consume_token(44);
                        token10 = MIBParser.jj_consume_token(75);
                        break;
                    }
                    default: {
                        MIBParser.jj_la1[46] = jj_gen;
                    }
                }
                MIBParser.indexOrAugments(syntaxObjectType);
                SyntaxOID syntaxOID = MIBParser.object_identifier_type();
                string3 = token12.image;
                if (token11 != null) {
                    string = token11.image;
                }
                if (token10 != null) {
                    string2 = token10.image;
                }
                syntaxObjectType.setStatus(n);
                syntaxObjectType.setAccess((Integer)accessTable.get("not-accessible"));
                syntaxObjectType.setDescription(string);
                syntaxObjectType.setReference(string2);
                syntaxObjectType.setName(string3);
                syntaxObjectType.assign(syntaxOID);
                if (!sequenceList.containsKey(string3) && !invalidSequenceList.containsKey(string3)) {
                    invalidSequenceList.put(string3, new SyntaxSequence());
                }
                syntaxOID.commentObj.objType = MIBParser.extractComments(token9.specialToken);
                syntaxOID.commentObj.syntax = MIBParser.extractComments(token8.specialToken);
                syntaxOID.commentObj.access = MIBParser.extractComments(token6.specialToken);
                syntaxOID.commentObj.status = MIBParser.extractComments(token5.specialToken);
                if (token4 != null) {
                    syntaxOID.commentObj.description = MIBParser.extractComments(token4.specialToken);
                }
                if (token2 != null) {
                    syntaxOID.commentObj.defval = MIBParser.extractComments(token2.specialToken);
                }
                if (token3 != null) {
                    syntaxOID.commentObj.reference = MIBParser.extractComments(token3.specialToken);
                }
                syntaxObjectType.commentObj = syntaxOID.commentObj;
                if (JDBC) {
                    refer = string2;
                    descrip = string;
                    if (string2.equals("")) {
                        refer = null;
                    }
                    if (string.equals("")) {
                        descrip = null;
                    }
                    otrString = String.valueOf(otrString) + syntaxOID.toString() + "#" + string3 + "#" + "not-accessible" + "#" + statusName + "#" + MIBParser.convertSQLData(descrip) + "#" + MIBParser.convertSQLData(refer) + "#" + indOrAug.toString() + "$";
                    indOrAug = null;
                }
                macroType = "OTR";
                return syntaxObjectType;
            }
        }
        MIBParser.jj_la1[47] = jj_gen;
        MIBParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final SyntaxOID oidValue() throws ParseException {
        errCode = "oidValue";
        Stack stack = new Stack();
        MIBParser.leftBrace();
        MIBParser.firstItem(stack);
        MIBParser.items(stack);
        MIBParser.rightBrace();
        return MIBParser.extractOID(stack);
    }

    public static final String organization() throws ParseException {
        String string = null;
        errCode = "organization";
        string = MIBParser.quotedString();
        return string;
    }

    static void parseAndWrite() throws ParseException, IOException {
        MIBParser.identification();
        MIBParser.specification();
        MIBParser.resolvedResults();
        MIBParser.checkCyclicTCs();
        MIBParser.createCMIandCDS();
        parsedModules.addElement(moduleName);
        Enumeration enumeration = importModules.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (modulesToBeParsed.contains(string)) continue;
            modulesToBeParsed.addElement(string);
        }
    }

    public static synchronized void parseMibModule(InputStream inputStream, Vector vector, MibOperations mibOperations) throws ParseException, IOException {
        try {
            if (!multipleModules) {
                if (jj_input_stream == null) {
                    jj_input_stream = new ASCII_UCodeESC_CharStream(inputStream, 1, 1);
                }
                MIBParser.ReInit(inputStream);
            }
            labelList = vector;
            multipleModules = false;
            MIBParser.reInitialize();
            MIBParser.identification();
            MIBParser.specification();
            MIBParser.resolvedResults();
            MIBParser.checkCyclicTCs();
            if (!(!JDBC || oidString.equals("") && tcString.equals("") && trapString.equals(""))) {
                MIBParser.writeIntoDataBase(mibOperations);
            }
            if (MIBParser.getToken((int)1).kind != 0) {
                multipleModules = true;
            }
        }
        catch (ParseException parseException) {
            String string = parseException.getMessage();
            int n = string.indexOf("Was expecting one of");
            if (n != -1) {
                string = string.substring(0, n);
            }
            throw new ParseException(string);
        }
    }

    public static synchronized String parseMibModule(String string, Vector vector) throws FileNotFoundException, IOException, ParseException {
        return MIBParser.parseMibModule(string, vector, false);
    }

    public static synchronized String parseMibModule(String string, Vector vector, boolean bl) throws FileNotFoundException, IOException, ParseException {
        if (string == null) {
            return null;
        }
        if (string.trim().equals("")) {
            return null;
        }
        filename = string;
        string = string.replace('\\', '/');
        labelList = vector;
        int n = string.lastIndexOf("/");
        path = n != -1 ? string.substring(0, n + 1) : "./";
        FileInputStream fileInputStream = new FileInputStream(string);
        if (jj_input_stream == null) {
            jj_input_stream = new ASCII_UCodeESC_CharStream(fileInputStream, 1, 1);
        }
        MIBParser.ReInit(fileInputStream);
        setname = true;
        MIBParser.parseModule(bl);
        MIBParser.free();
        ((InputStream)fileInputStream).close();
        fileInputStream = null;
        return modToBeLoaded;
    }

    public static synchronized String parseMibModule(URL uRL, Vector vector) throws FileNotFoundException, IOException, ParseException {
        writeinTMPdir = true;
        if (uRL == null) {
            return null;
        }
        filename = uRL.toString();
        labelList = vector;
        int n = filename.lastIndexOf("/");
        path = n != -1 ? filename.substring(0, n + 1) : "./";
        InputStream inputStream = uRL.openStream();
        if (jj_input_stream == null) {
            jj_input_stream = new ASCII_UCodeESC_CharStream(inputStream, 1, 1);
        }
        MIBParser.ReInit(inputStream);
        setname = true;
        MIBParser.parseModule(false);
        MIBParser.free();
        inputStream.close();
        writeinTMPdir = false;
        return modToBeLoaded;
    }

    static void parseModule(boolean bl) throws ParseException, IOException {
        Object object;
        Vector<String> vector = null;
        try {
            MIBParser.reInitialize();
            MIBParser.parseAndWrite();
            if (setname) {
                modToBeLoaded = "";
                modToBeLoaded = moduleName;
                moduleName = null;
                setname = false;
            }
        }
        catch (ParseException parseException) {
            setname = false;
            String string = parseException.getMessage();
            int n = string.indexOf("Was expecting one of");
            if (n != -1) {
                string = string.substring(0, n);
            }
            throw new ParseException(String.valueOf(SnmpUtils.getString("Could not parse the file")) + " " + filename + " " + string);
        }
        while (MIBParser.getToken((int)1).kind != 0) {
            if (vector == null) {
                vector = new Vector<String>();
            }
            try {
                MIBParser.reInitialize();
                MIBParser.parseAndWrite();
                vector.addElement(moduleName);
            }
            catch (ParseException parseException) {
                setname = false;
                String string = parseException.getMessage();
                int n = string.indexOf("Was expecting one of");
                if (n != -1) {
                    string = string.substring(0, n);
                }
                throw new ParseException(String.valueOf(SnmpUtils.getString("Could not parse the file")) + " " + filename + " " + string);
            }
        }
        if (vector != null && !vector.isEmpty()) {
            object = null;
            object = writeinTMPdir ? new RandomAccessFile(new File("./tmp/" + modToBeLoaded + ".cmi"), "rw") : new RandomAccessFile(new File(String.valueOf(path) + modToBeLoaded + ".cmi"), "rw");
            long l = ((RandomAccessFile)object).length();
            ((RandomAccessFile)object).seek(l - 1L);
            ((RandomAccessFile)object).writeBoolean(true);
            ((RandomAccessFile)object).writeUTF(vector.toString());
            ((RandomAccessFile)object).close();
        }
        if (bl) {
            object = modulesToBeParsed.elements();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                if (parsedModules.contains(string)) continue;
                File file = new File(String.valueOf(path) + string + ".cmi");
                if (file.exists()) {
                    parsedModules.addElement(string);
                    continue;
                }
                InputStream inputStream = null;
                try {
                    if (writeinTMPdir) {
                        URL uRL = new URL(String.valueOf(path) + string);
                        inputStream = uRL.openStream();
                        MIBParser.ReInit(inputStream);
                        filename = String.valueOf(path) + string;
                    } else {
                        inputStream = new FileInputStream(String.valueOf(path) + string);
                        MIBParser.ReInit(inputStream);
                        filename = String.valueOf(path) + string;
                    }
                    MIBParser.parseModule(bl);
                    inputStream.close();
                    inputStream = null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (ParseException parseException) {
                    String string2 = parseException.getMessage();
                    if (string2.indexOf("Imports Error") == -1) {
                        string2 = String.valueOf(SnmpUtils.getString("Imports Error")) + " " + string2;
                    }
                    inputStream.close();
                    inputStream = null;
                    throw new ParseException(string2);
                }
            }
        }
    }

    public static final String quotedString() throws ParseException {
        errCode = "quotedString";
        Token token = null;
        token = MIBParser.jj_consume_token(75);
        return token.image;
    }

    public static final void range(Vector vector, Vector vector2) throws ParseException {
        errCode = "range";
        Boolean bl = new Boolean(true);
        Boolean bl2 = new Boolean(false);
        if (MIBParser.jj_2_9(3)) {
            long l = MIBParser.value();
            MIBParser.jj_consume_token(96);
            long l2 = MIBParser.value();
            vector.addElement(new Long(l));
            vector.addElement(new Long(l2));
            vector2.addElement(bl);
            if (JDBC) {
                rangeVector.addElement(new Long(l));
                rangeVector.addElement(new Long(l2));
                enumVector = new Vector();
            }
        } else {
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                case 24: 
                case 25: 
                case 76: 
                case 77: 
                case 78: 
                case 95: {
                    long l = MIBParser.value();
                    vector.addElement(new Long(l));
                    vector2.addElement(bl2);
                    if (!JDBC) break;
                    enumVector = new Vector();
                    rangeVector.addElement(new Long(l));
                    rangeVector.addElement(new Long(l));
                    break;
                }
                default: {
                    MIBParser.jj_la1[27] = jj_gen;
                    MIBParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public static void reInitialize() {
        JDBC = MibOperations.jdbc;
        count = -1;
        rootFlag = true;
        resolved = true;
        argStack = new Stack();
        oidList = new Hashtable();
        invalidOidList = new Hashtable(5);
        oidNumList = new Hashtable(5);
        phantomOidList = new Hashtable(5);
        phantomTCList = new Hashtable(5);
        invalidTCList = new Hashtable(5);
        tcList = new Hashtable(5);
        trapList = new Hashtable(5);
        importModules = new Hashtable(5);
        sequenceList = new Hashtable(5);
        invalidSequenceList = new Hashtable(5);
        phantomSequenceList = new Hashtable(5);
        modulesToBeParsed = new Vector(1);
        parsedModules = new Vector(1);
        moduleName = null;
        imports = new Vector(3);
        importsString = new StringBuffer("\n\t");
        SyntaxOID syntaxOID = SyntaxOID.getInstance(null, "ccitt", 0);
        oidList.put("ccitt", syntaxOID);
        oidNumList.put(new Integer(0), syntaxOID);
        syntaxOID = SyntaxOID.getInstance(null, "iso", 1);
        oidList.put("iso", syntaxOID);
        oidNumList.put(new Integer(1), syntaxOID);
        syntaxOID = SyntaxOID.getInstance(null, "joint-iso-ccitt", 2);
        oidList.put("joint-iso-ccitt", syntaxOID);
        oidNumList.put(new Integer(2), syntaxOID);
        strOID = "";
        if (JDBC) {
            dependancyString = "";
            importedNodeString = "|";
            trapString = "";
            trapStr = "";
            oidString = "";
            ottString = "";
            tcString = "";
            tcStr = "";
            mcModuleName = "";
            mcString = "";
            acString = "";
            acModuleString = "";
            acModuleStr = "";
            acVariationName = "";
            ngString = "";
            nullStr = null;
            moduleIdentityString = "";
            moduleName = null;
            nodeName = null;
            Object var1_1 = null;
            revItemStr = "";
            preModuleComments = "";
            otString = "";
            otrString = "";
            rangeString = "";
            seqString = "";
            seqStr = "";
            mcModuleString = "";
            mcModuleStr = "";
            grpObjString = "";
            acVariationString = "";
            acVariationStr = "";
            ntString = "";
            indOrAug = null;
            unitString = "";
            otherRootNodes = "";
            acSyntaxName = "";
            refer = null;
            descrip = null;
            defStr = null;
            rootNode = null;
            rootFlag = true;
            resolved = true;
            enumVector = new Vector();
            rangeVector = new Vector();
        }
    }

    public void readElements(DataInputStream dataInputStream, DataInputStream dataInputStream2) throws IOException {
    }

    static void resolveNodes(String string, int n, int n2) {
        SyntaxOID syntaxOID = SyntaxOID.getInstance(null, "iso", 1);
        String string2 = parentNodes[n2];
        if (!oidList.containsKey(string2)) {
            int n3 = standardNodes.indexOf(string2);
            int n4 = oidNums[n3];
            MIBParser.resolveNodes(string2, n4, n3);
        }
        SyntaxOID syntaxOID2 = (SyntaxOID)oidList.get(string2);
        Enumeration enumeration = invalidOidList.keys();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            vector.addElement(string3);
        }
        if (vector.contains(string) && oidList.get(string) == null && !string.equals("zeroDotZero")) {
            SyntaxOID syntaxOID3 = SyntaxOID.getInstance(syntaxOID2, string, -1 * n - 2);
            MIBParser.addOID(syntaxOID3, string);
        } else {
            SyntaxOID syntaxOID4 = string.equals("org") ? SyntaxOID.getInstance(syntaxOID2, string, -5555) : SyntaxOID.getInstance(syntaxOID2, string, n);
            MIBParser.addOID(syntaxOID4, string);
        }
    }

    static void resolvedResults() throws ParseException {
        int n;
        Object object;
        Enumeration enumeration;
        if (standardNodes == null) {
            MIBParser.stdNodes();
        }
        if (invalidOidList.size() > 0) {
            String[] stringArray = new String[]{"INTEGER", "OCTET STRING", "OBJECT IDENTIFIER", "NetworkAddress", "IpAddress"};
            int n2 = 0;
            while (n2 < 5) {
                if (invalidOidList.containsKey(stringArray[n2])) {
                    invalidOidList.remove(stringArray[n2]);
                }
                ++n2;
            }
        }
        boolean bl = false;
        Enumeration enumeration2 = importModules.keys();
        while (enumeration2.hasMoreElements()) {
            enumeration = (String)enumeration2.nextElement();
            object = (Vector)importModules.get(enumeration);
            n = 0;
            while (n < ((Vector)object).size()) {
                if (!standardNodes.contains(((Vector)object).elementAt(n))) {
                    bl = false;
                    break;
                }
                bl = true;
                SyntaxOID syntaxOID = SyntaxOID.getInstance(null, (String)((Vector)object).elementAt(n), -1);
                invalidOidList.put((String)((Vector)object).elementAt(n), syntaxOID);
                ++n;
            }
            if (!bl) continue;
            importModules.remove(enumeration);
        }
        if (invalidOidList.size() > 0) {
            enumeration = invalidOidList.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (!standardNodes.contains(object)) continue;
                n = standardNodes.indexOf(object);
                int n3 = oidNums[n];
                MIBParser.resolveNodes((String)object, n3, n);
            }
            if (invalidOidList.size() > 0) {
                throw new ParseException("\n" + SnmpUtils.getString("Couldn't resolve these MibNodes :") + "\n" + MIBParser.getConstructs(invalidOidList));
            }
        }
        if (invalidTCList.size() > 0) {
            enumeration = sequenceList.keys();
            object = MIBParser.getConstructs(invalidTCList);
            String string = "";
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (((String)object).indexOf(string) == -1) continue;
                throw new ParseException("\n" + SnmpUtils.getString("The 'INDEX' or 'AUGMENTS' keyword was missing in the table row object type construct which contains the sequence as") + " " + string + " .");
            }
            throw new ParseException("\n" + SnmpUtils.getString("Couldn't resolve these TC constructs :") + "\n" + (String)object);
        }
        if (invalidSequenceList.size() > 0) {
            throw new ParseException("\n" + SnmpUtils.getString("Couldn't resolve these sequence constructs :") + "\n" + MIBParser.getConstructs(invalidSequenceList));
        }
    }

    public static final void rightBrace() throws ParseException {
        errCode = "rightBrace";
        MIBParser.jj_consume_token(94);
    }

    public static final BaseSyntax seqEnum() throws ParseException {
        errCode = "seqEnum";
        BaseSyntax baseSyntax = null;
        MIBParser.jj_consume_token(99);
        baseSyntax = MIBParser.snmpConstructOrTypeName();
        return baseSyntax;
    }

    public static final void seqMember(Vector vector) throws ParseException {
        errCode = "seqMember";
        Token token = null;
        BaseSyntax baseSyntax = null;
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 99: {
                token = MIBParser.jj_consume_token(99);
                break;
            }
            case 98: {
                token = MIBParser.jj_consume_token(98);
                break;
            }
            default: {
                MIBParser.jj_la1[67] = jj_gen;
                MIBParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block12: while (true) {
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                default: {
                    MIBParser.jj_la1[68] = jj_gen;
                    break block12;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 14: 
                case 16: 
                case 18: 
                case 19: 
                case 58: 
                case 98: 
                case 99: {
                    switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 14: 
                        case 16: 
                        case 18: 
                        case 19: 
                        case 58: {
                            baseSyntax = MIBParser.synType();
                            continue block12;
                        }
                        case 98: {
                            baseSyntax = MIBParser.tcType();
                            continue block12;
                        }
                        case 99: {
                            baseSyntax = MIBParser.seqEnum();
                            continue block12;
                        }
                    }
                    MIBParser.jj_la1[69] = jj_gen;
                    MIBParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            break;
        }
        if (baseSyntax == null) {
            errCode = "seqBaseSyntax";
            throw new ParseException();
        }
        vector.addElement(token.image);
        if (JDBC) {
            seqStr = String.valueOf(seqStr) + token.image + "+" + new Integer(baseSyntax.getType()).toString() + "|";
            rangeVector = new Vector();
        }
        vector.addElement(new Integer(baseSyntax.getType()));
    }

    public static final BaseSyntax sequence_construct() throws ParseException {
        errCode = "sequence_construct";
        Vector vector = new Vector(5);
        SyntaxSequence syntaxSequence = new SyntaxSequence();
        MIBParser.jj_consume_token(79);
        MIBParser.tokSequence();
        MIBParser.leftBrace();
        MIBParser.seqMember(vector);
        block3: while (true) {
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                default: {
                    MIBParser.jj_la1[66] = jj_gen;
                    break block3;
                }
                case 89: {
                    MIBParser.jj_consume_token(89);
                    MIBParser.seqMember(vector);
                    continue block3;
                }
            }
            break;
        }
        MIBParser.jj_consume_token(94);
        syntaxSequence.setSequence(vector);
        macroType = "SEQ";
        return syntaxSequence;
    }

    public void setRange(RangeList rangeList) {
    }

    public static final long signed() throws ParseException {
        errCode = "signed";
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 95: {
                MIBParser.jj_consume_token(95);
                long l = MIBParser.number();
                return -1L * l;
            }
            case 76: 
            case 77: 
            case 78: {
                long l = MIBParser.number();
                return l;
            }
        }
        MIBParser.jj_la1[23] = jj_gen;
        MIBParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final BaseSyntax simpleEnumOrBit() throws ParseException {
        errCode = "simpleEnumOrBit";
        BaseSyntax baseSyntax = MIBParser.simpleSyntax();
        if (JDBC && macroType.equals("AC") && acSyntaxName.equals("")) {
            acSyntaxName = syntaxName;
        }
        return baseSyntax;
    }

    public static final BaseSyntax simpleSyntax() throws ParseException {
        errCode = "simpleSyntax";
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 58: {
                BaseSyntax baseSyntax = MIBParser.synType();
                return baseSyntax;
            }
            case 98: {
                BaseSyntax baseSyntax = MIBParser.tcType();
                return baseSyntax;
            }
        }
        MIBParser.jj_la1[38] = jj_gen;
        MIBParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final BaseSyntax snmpConstructOrTypeName() throws ParseException {
        errCode = "snmpConstructOrTypeName";
        SyntaxNumber syntaxNumber = new SyntaxNumber();
        SyntaxString syntaxString = new SyntaxString();
        Vector vector = new Vector(5);
        Vector vector2 = new Vector(5);
        Vector vector3 = new Vector(5);
        Token[] tokenArray = new Token[5];
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 19: {
                MIBParser.jj_consume_token(19);
                syntaxNumber.setType(69);
                syntaxNumber.setName("Counter");
                syntaxName = "Counter";
                return syntaxNumber;
            }
        }
        MIBParser.jj_la1[15] = jj_gen;
        if (MIBParser.jj_2_4(2)) {
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                case 16: {
                    tokenArray[0] = MIBParser.jj_consume_token(16);
                    break;
                }
                case 18: {
                    tokenArray[3] = MIBParser.jj_consume_token(18);
                    break;
                }
                default: {
                    MIBParser.jj_la1[11] = jj_gen;
                    MIBParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            MIBParser.subTypeWithoutSIZE(vector, vector2, vector3);
            if (tokenArray[0] != null) {
                syntaxNumber.setType(64);
                syntaxNumber.setName("INTEGER");
                syntaxName = "INTEGER";
            } else if (tokenArray[3] != null) {
                syntaxNumber.setType(67);
                syntaxNumber.setName("Gauge");
                syntaxName = "Gauge";
            }
            RangeList rangeList = new RangeList(vector, vector2, vector3);
            syntaxNumber.setRange(rangeList);
            return syntaxNumber;
        }
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 16: 
            case 18: {
                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    case 16: {
                        tokenArray[0] = MIBParser.jj_consume_token(16);
                        break;
                    }
                    case 18: {
                        tokenArray[3] = MIBParser.jj_consume_token(18);
                        break;
                    }
                    default: {
                        MIBParser.jj_la1[12] = jj_gen;
                        MIBParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (tokenArray[0] != null) {
                    syntaxNumber.setType(64);
                    syntaxNumber.setName("INTEGER");
                    syntaxName = "INTEGER";
                } else if (tokenArray[3] != null) {
                    syntaxName = "Gauge";
                    syntaxNumber.setName("Gauge");
                    syntaxNumber.setType(67);
                }
                return syntaxNumber;
            }
        }
        MIBParser.jj_la1[16] = jj_gen;
        if (MIBParser.jj_2_5(2)) {
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                case 5: {
                    tokenArray[0] = MIBParser.jj_consume_token(5);
                    break;
                }
                case 14: {
                    MIBParser.jj_consume_token(14);
                    break;
                }
                default: {
                    MIBParser.jj_la1[13] = jj_gen;
                    MIBParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            MIBParser.subType(vector, vector2, vector3);
            RangeList rangeList = new RangeList(vector, vector2, vector3);
            syntaxString.setRange(rangeList);
            if (tokenArray[0] != null) {
                syntaxString.setType(96);
                syntaxString.setName("OCTET STRING");
                syntaxName = "OCTET STRING";
            } else {
                syntaxString.setType(98);
                syntaxName = "Opaque";
            }
            return syntaxString;
        }
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 5: 
            case 14: {
                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    case 5: {
                        tokenArray[0] = MIBParser.jj_consume_token(5);
                        break;
                    }
                    case 14: {
                        MIBParser.jj_consume_token(14);
                        break;
                    }
                    default: {
                        MIBParser.jj_la1[14] = jj_gen;
                        MIBParser.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (tokenArray[0] != null) {
                    syntaxString.setType(96);
                    syntaxString.setName("OCTET STRING");
                    syntaxName = "OCTET STRING";
                } else {
                    syntaxString.setType(98);
                    syntaxString.setName("Opaque");
                    syntaxName = "Opaque";
                }
                return syntaxString;
            }
            case 58: {
                MIBParser.jj_consume_token(58);
                syntaxName = "OBJECT IDENTIFIER";
                return new SyntaxOID();
            }
            case 6: {
                MIBParser.jj_consume_token(6);
                syntaxName = "IpAddress";
                syntaxString.setType(97);
                syntaxString.setName("IpAddress");
                return syntaxString;
            }
            case 7: {
                MIBParser.jj_consume_token(7);
                syntaxName = "NetworkAddress";
                syntaxString.setType(99);
                syntaxString.setName("NetworkAddress");
                return syntaxString;
            }
            case 8: {
                MIBParser.jj_consume_token(8);
                syntaxName = "TimeTicks";
                syntaxNumber.setType(71);
                syntaxNumber.setName("TimeTicks");
                return syntaxNumber;
            }
        }
        MIBParser.jj_la1[17] = jj_gen;
        MIBParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final void specification() throws ParseException {
        errCode = "specification";
        try {
            MIBParser.jj_consume_token(35);
            MIBParser.jj_consume_token(79);
            MIBParser.jj_consume_token(73);
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                case 54: {
                    MIBParser.imports();
                    break;
                }
                default: {
                    MIBParser.jj_la1[1] = jj_gen;
                }
            }
            block8: while (true) {
                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    default: {
                        MIBParser.jj_la1[2] = jj_gen;
                        break block8;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 14: 
                    case 16: 
                    case 18: 
                    case 19: 
                    case 32: 
                    case 52: 
                    case 58: 
                    case 80: 
                    case 98: 
                    case 99: {
                        MIBParser.definitions();
                        continue block8;
                    }
                }
                break;
            }
            MIBParser.jj_consume_token(74);
        }
        catch (ParseException parseException) {
            String string;
            Token token = MIBParser.getToken(0);
            Token token2 = token.next;
            String string2 = "";
            if (token2 != null) {
                string2 = token.next.image;
            }
            if (string2.equals("")) {
                errCode = "tokEND";
            }
            if (!string2.equals("") && !Character.isLetter(string2.charAt(0))) {
                errCode = "The identifier should not startswith number or special character.";
            }
            if (errCode.equals("item") && (string = parseException.getMessage()).indexOf("4294967295") != -1) {
                errCode = string;
            }
            if (string2.equals("MODULE-IDENTITY") || string2.equals("AGENT-CAPABILITIES") || string2.equals("TRAP-TYPE") || string2.equals("OBJECT-IDENTITY") || string2.equals("NOTIFICATION-TYPE") || string2.equals("MODULE-COMPLIANCE") || string2.equals("NOTIFICATION-GROUP")) {
                errCode = "In the " + string2 + " construct the identifier should start with lowercase character.";
            }
            if (token.image.startsWith("\"") && errCode.startsWith("tok") && token.image.indexOf(errCode.substring(3)) != -1) {
                errCode = "The field " + errCode.substring(3) + " was missing since the previous fields quoted string was not ends with quotes.";
            }
            if (errCode.equals("object_type_construct")) {
                throw new ParseException("\n" + SnmpUtils.getString("The error occured at the line no:") + " " + token.beginLine + " ," + SnmpUtils.getString("column:") + " " + token.beginColumn + ".\n" + ParserErrorMessage.getMessage(token));
            }
            throw new ParseException("\n" + SnmpUtils.getString("The error occured at the line no:") + " " + token.beginLine + " ," + SnmpUtils.getString("column:") + " " + token.beginColumn + ".\n" + ParserErrorMessage.getMessage(errCode));
        }
    }

    public static final int statusV1() throws ParseException {
        errCode = "STATUS";
        if (!(MIBParser.getToken((int)1).image.equals("mandatory") || MIBParser.getToken((int)1).image.equals("deprecated") || MIBParser.getToken((int)1).image.equals("obsolete") || MIBParser.getToken((int)1).image.equals("optional"))) {
            MIBParser.jj_consume_token(-1);
            throw new ParseException();
        }
        MIBParser.jj_consume_token(99);
        statusName = MIBParser.token.image;
        return (Integer)statusTable.get(MIBParser.token.image);
    }

    private static void stdNodes() {
        standardNodes = new Vector(14);
        standardNodes.addElement("org");
        standardNodes.addElement("dod");
        standardNodes.addElement("internet");
        standardNodes.addElement("directory");
        standardNodes.addElement("mgmt");
        standardNodes.addElement("experimental");
        standardNodes.addElement("private");
        standardNodes.addElement("snmpV2");
        standardNodes.addElement("enterprises");
        standardNodes.addElement("mib-2");
        standardNodes.addElement("snmpDomains");
        standardNodes.addElement("snmpProxys");
        standardNodes.addElement("snmpModules");
        standardNodes.addElement("zeroDotZero");
    }

    public static final void subType(Vector vector, Vector vector2, Vector vector3) throws ParseException {
        errCode = "subType";
        if (MIBParser.jj_2_6(2)) {
            MIBParser.jj_consume_token(90);
            MIBParser.jj_consume_token(65);
            MIBParser.jj_consume_token(90);
            MIBParser.range(vector2, vector3);
            block6: while (true) {
                switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                    default: {
                        MIBParser.jj_la1[19] = jj_gen;
                        break block6;
                    }
                    case 91: {
                        MIBParser.jj_consume_token(91);
                        MIBParser.range(vector2, vector3);
                        continue block6;
                    }
                }
                break;
            }
            MIBParser.jj_consume_token(92);
            MIBParser.jj_consume_token(92);
        } else {
            switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                case 90: 
                case 93: {
                    MIBParser.subTypeWithoutSIZE(vector, vector2, vector3);
                    break;
                }
                default: {
                    MIBParser.jj_la1[20] = jj_gen;
                    MIBParser.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public static final void subTypeWithoutSIZE(Vector vector, Vector vector2, Vector vector3) throws ParseException {
        errCode = "subTypeWithoutSIZE";
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 90: {
                MIBParser.jj_consume_token(90);
                MIBParser.range(vector2, vector3);
                block7: while (true) {
                    switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                        default: {
                            MIBParser.jj_la1[21] = jj_gen;
                            break block7;
                        }
                        case 91: {
                            MIBParser.jj_consume_token(91);
                            MIBParser.range(vector2, vector3);
                            continue block7;
                        }
                    }
                    break;
                }
                MIBParser.jj_consume_token(92);
                break;
            }
            case 93: {
                MIBParser.jj_consume_token(93);
                MIBParser.named_list(vector);
                MIBParser.jj_consume_token(94);
                break;
            }
            default: {
                MIBParser.jj_la1[22] = jj_gen;
                MIBParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final BaseSyntax synType() throws ParseException {
        errCode = "synType";
        BaseSyntax baseSyntax = null;
        baseSyntax = MIBParser.snmpConstructOrTypeName();
        return baseSyntax;
    }

    public static final BaseSyntax tcType() throws ParseException {
        errCode = "tcType";
        Vector vector = new Vector(5);
        Vector vector2 = new Vector(5);
        Vector vector3 = new Vector(5);
        Token token = null;
        SyntaxTextualConvention syntaxTextualConvention = null;
        if (MIBParser.jj_2_11(2)) {
            token = MIBParser.jj_consume_token(98);
            MIBParser.subType(vector, vector2, vector3);
            syntaxName = token.image;
            if (tcList.containsKey(token.image)) {
                syntaxTextualConvention = (SyntaxTextualConvention)tcList.get(token.image);
            } else if (phantomTCList.containsKey(token.image)) {
                syntaxTextualConvention = (SyntaxTextualConvention)phantomTCList.get(token.image);
            } else if (wellKnownTCs.containsKey(token.image)) {
                syntaxTextualConvention = (SyntaxTextualConvention)wellKnownTCs.get(token.image);
            } else if (imports.contains(token.image)) {
                syntaxTextualConvention = new SyntaxTextualConvention();
                phantomTCList.put(token.image, syntaxTextualConvention);
                syntaxTextualConvention.setName(token.image);
            } else {
                syntaxTextualConvention = (SyntaxTextualConvention)invalidTCList.get(token.image);
                if (syntaxTextualConvention == null) {
                    syntaxTextualConvention = new SyntaxTextualConvention();
                    invalidTCList.put(token.image, syntaxTextualConvention);
                    syntaxTextualConvention.setName(token.image);
                }
            }
            syntaxTextualConvention = syntaxTextualConvention.copy();
            RangeList rangeList = new RangeList(vector, vector2, vector3);
            syntaxTextualConvention.setRange(rangeList);
            return syntaxTextualConvention;
        }
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 98: {
                token = MIBParser.jj_consume_token(98);
                syntaxName = token.image;
                if (tcList.containsKey(token.image)) {
                    syntaxTextualConvention = (SyntaxTextualConvention)tcList.get(token.image);
                    syntaxTextualConvention = syntaxTextualConvention.copy();
                } else if (phantomTCList.containsKey(token.image)) {
                    syntaxTextualConvention = (SyntaxTextualConvention)phantomTCList.get(token.image);
                    syntaxTextualConvention = syntaxTextualConvention.copy();
                } else if (wellKnownTCs.containsKey(token.image)) {
                    syntaxTextualConvention = (SyntaxTextualConvention)wellKnownTCs.get(token.image);
                } else if (imports.contains(token.image)) {
                    syntaxTextualConvention = new SyntaxTextualConvention();
                    phantomTCList.put(token.image, syntaxTextualConvention);
                    syntaxTextualConvention.setName(token.image);
                } else {
                    syntaxTextualConvention = (SyntaxTextualConvention)invalidTCList.get(token.image);
                    if (syntaxTextualConvention != null) {
                        return syntaxTextualConvention;
                    }
                    syntaxTextualConvention = new SyntaxTextualConvention();
                    invalidTCList.put(token.image, syntaxTextualConvention);
                    syntaxTextualConvention.setName(token.image);
                }
                return syntaxTextualConvention;
            }
        }
        MIBParser.jj_la1[37] = jj_gen;
        MIBParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final void terminalTokens() throws ParseException {
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 79: {
                MIBParser.jj_consume_token(79);
                break;
            }
            case 93: {
                MIBParser.jj_consume_token(93);
                break;
            }
            case 94: {
                MIBParser.jj_consume_token(94);
                break;
            }
            case 90: {
                MIBParser.jj_consume_token(90);
                break;
            }
            case 92: {
                MIBParser.jj_consume_token(92);
                break;
            }
            case 91: {
                MIBParser.jj_consume_token(91);
                break;
            }
            case 96: {
                MIBParser.jj_consume_token(96);
                break;
            }
            case 95: {
                MIBParser.jj_consume_token(95);
                break;
            }
            default: {
                MIBParser.jj_la1[86] = jj_gen;
                MIBParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final BaseSyntax textual_convention_construct() throws ParseException {
        macroCode = "TC";
        errCode = "textual_convention_construct";
        String string = BaseSyntax.NullString;
        String string2 = BaseSyntax.NullString;
        String string3 = BaseSyntax.NullString;
        SyntaxTextualConvention syntaxTextualConvention = new SyntaxTextualConvention();
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        Token token5 = null;
        Token token6 = null;
        Token token7 = null;
        Token token8 = null;
        Token token9 = null;
        syntaxTextualConvention.commentObj = new CommentClass();
        token2 = MIBParser.tokAssignment();
        BaseSyntax baseSyntax = MIBParser.simpleEnumOrBit();
        syntaxTextualConvention.setSyntax(baseSyntax);
        syntaxTextualConvention.commentObj.node = MIBParser.extractComments(token2.specialToken);
        if (JDBC) {
            tcStr = String.valueOf(nullStr) + "#" + nullStr + "#" + nullStr + "#" + nullStr + "#" + syntaxName;
        }
        return syntaxTextualConvention;
    }

    public static final Token tokAccess() throws ParseException {
        errCode = "tokACCESS";
        Token token = null;
        token = MIBParser.jj_consume_token(22);
        return token;
    }

    public static final Token tokAssignment() throws ParseException {
        errCode = macroCode.equals("TRAP") ? "TRAP" : (macroCode.equals("NOTIFICATION-GROUP") || macroCode.equals("NOTIFICATION-TYPE") || macroCode.equals("OBJECT-GROUP") ? "NOTI-REFERENCE" : (macroCode.equals("MODULE-COMPLIANCE") ? "MODULE-COMPLIANCE-REF" : (macroCode.equals("MCMODULE") ? "MCMODULE" : (macroCode.equals("MODULE-IDENTITY") ? "MODULE-IDENTITY" : (macroCode.equals("AC") ? "AC" : "tokASSIGNMENT (::=)")))));
        Token token = null;
        token = MIBParser.jj_consume_token(79);
        return token;
    }

    public static final Token tokContactInfo() throws ParseException {
        errCode = "tokCONTACT-INFO";
        Token token = null;
        token = MIBParser.jj_consume_token(50);
        return token;
    }

    public static final Token tokCreationRequires() throws ParseException {
        errCode = "tokCREATION-REQUIRES";
        Token token = null;
        token = MIBParser.jj_consume_token(30);
        return token;
    }

    public static final Token tokDefVal() throws ParseException {
        errCode = "tokDEFVAL";
        Token token = null;
        token = MIBParser.jj_consume_token(42);
        return token;
    }

    public static final Token tokDescription() throws ParseException {
        errCode = macroCode.equals("GROUPOROBJECT") ? "GROUPOROBJECT" : (macroCode.equals("VARIATION") ? "VARIATION" : "tokDESCRIPTION");
        Token token = null;
        token = MIBParser.jj_consume_token(67);
        return token;
    }

    public static final Token tokDisplayHint() throws ParseException {
        errCode = "tokDISPLAY-HINT";
        Token token = null;
        token = MIBParser.jj_consume_token(62);
        return token;
    }

    public static final Token tokEnterprise() throws ParseException {
        errCode = "tokENTERPRISES";
        Token token = null;
        token = MIBParser.jj_consume_token(33);
        return token;
    }

    public static final Token tokIncludes() throws ParseException {
        errCode = "tokINCLUDES";
        Token token = null;
        token = MIBParser.jj_consume_token(29);
        return token;
    }

    public static final Token tokLastUpdated() throws ParseException {
        errCode = "tokLAST-UPDATED";
        Token token = null;
        token = MIBParser.jj_consume_token(48);
        return token;
    }

    public static final Token tokLcName() throws ParseException {
        errCode = "lcName";
        Token token = null;
        token = MIBParser.jj_consume_token(99);
        return token;
    }

    public static final Token tokMandatoryGroups() throws ParseException {
        errCode = "tokMANDATORY-GROUPS";
        Token token = null;
        token = MIBParser.jj_consume_token(39);
        return token;
    }

    public static final Token tokMaxAccess() throws ParseException {
        errCode = "tokMAX-ACCESS";
        Token token = null;
        token = MIBParser.jj_consume_token(21);
        return token;
    }

    public static final Token tokMinAccess() throws ParseException {
        errCode = "tokMIN-ACCESS";
        Token token = null;
        token = MIBParser.jj_consume_token(23);
        return token;
    }

    public static final Token tokModule() throws ParseException {
        errCode = "tokMODULE";
        Token token = null;
        token = MIBParser.jj_consume_token(71);
        return token;
    }

    public static final Token tokNotifications() throws ParseException {
        errCode = "tokNOTIFICATIONS";
        Token token = null;
        token = MIBParser.jj_consume_token(38);
        return token;
    }

    public static final Token tokObject() throws ParseException {
        errCode = "OBJECT";
        Token token = null;
        token = MIBParser.jj_consume_token(61);
        return token;
    }

    public static final void tokObjectIdentifier() throws ParseException {
        errCode = "tokOBJECT IDENTIFIER";
        MIBParser.jj_consume_token(58);
    }

    public static final Token tokObjects() throws ParseException {
        errCode = "tokOBJECTS";
        Token token = null;
        token = MIBParser.jj_consume_token(60);
        return token;
    }

    public static final Token tokOrganization() throws ParseException {
        errCode = "tokORGANIZATION";
        Token token = null;
        token = MIBParser.jj_consume_token(49);
        return token;
    }

    public static final Token tokProductRelease() throws ParseException {
        errCode = "tokPRODUCT-RELEASE";
        Token token = null;
        token = MIBParser.jj_consume_token(27);
        return token;
    }

    public static final Token tokReference() throws ParseException {
        errCode = "tokREFERENCE";
        Token token = null;
        token = MIBParser.jj_consume_token(44);
        return token;
    }

    public static final Token tokRevision() throws ParseException {
        errCode = "tokDESCRIPTION";
        Token token = null;
        token = MIBParser.jj_consume_token(51);
        return token;
    }

    public static final Token tokSequence() throws ParseException {
        errCode = "tokSEQUENCE or OBJECT IDENTIFER";
        Token token = null;
        token = MIBParser.jj_consume_token(55);
        return token;
    }

    public static final Token tokSequenceOf() throws ParseException {
        errCode = "tokSEQUENCE OF";
        Token token = null;
        token = MIBParser.jj_consume_token(56);
        return token;
    }

    public static final Token tokStatus() throws ParseException {
        errCode = macroCode.equals("NOTIFICATION-TYPE") ? "NOTIFICATION-TYPE" : (macroCode.equals("TC") ? "The DISPLAY-HINT or STATUS keyword may be missing." : "tokSTATUS");
        Token token = null;
        token = MIBParser.jj_consume_token(20);
        return token;
    }

    public static final Token tokSupports() throws ParseException {
        errCode = "tokSUPPORTS";
        Token token = null;
        token = MIBParser.jj_consume_token(28);
        return token;
    }

    public static final Token tokSyntax() throws ParseException {
        errCode = macroCode.equals("TC") ? "The REFERENCE or SYNTAX keyword was missing." : "tokSYNTAX";
        Token token = null;
        token = MIBParser.jj_consume_token(72);
        return token;
    }

    public static final Token tokUcName() throws ParseException {
        errCode = "ucName";
        Token token = null;
        token = MIBParser.jj_consume_token(98);
        return token;
    }

    public static final Token tokUnits() throws ParseException {
        errCode = "tokUNITS";
        Token token = null;
        token = MIBParser.jj_consume_token(63);
        return token;
    }

    public static final Token tokVariables() throws ParseException {
        errCode = "tokVARIABLES";
        Token token = null;
        token = MIBParser.jj_consume_token(34);
        return token;
    }

    public static final Token tokVariation() throws ParseException {
        errCode = "tokVARIATION";
        Token token = null;
        token = MIBParser.jj_consume_token(41);
        return token;
    }

    public static final Token tokWriteSyntax() throws ParseException {
        errCode = "tokWRITE-SYNTAX";
        Token token = null;
        token = MIBParser.jj_consume_token(40);
        return token;
    }

    public static final Token trapNumber() throws ParseException {
        errCode = "trapNumber";
        Token token = null;
        token = MIBParser.jj_consume_token(76);
        return token;
    }

    public static final SyntaxTrapType trap_type_construct() throws ParseException {
        errCode = "trap_type_construct";
        macroCode = "TRAP";
        Vector vector = new Vector(5);
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        String string = BaseSyntax.NullString;
        String string2 = BaseSyntax.NullString;
        Vector vector2 = new Vector(1);
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        Token token5 = null;
        token5 = MIBParser.jj_consume_token(32);
        MIBParser.tokEnterprise();
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 93: {
                MIBParser.jj_consume_token(93);
                break;
            }
            default: {
                MIBParser.jj_la1[60] = jj_gen;
            }
        }
        MIBParser.lcObject(vector2);
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 94: {
                MIBParser.jj_consume_token(94);
                break;
            }
            default: {
                MIBParser.jj_la1[61] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 34: {
                MIBParser.tokVariables();
                MIBParser.leftBrace();
                MIBParser.lcObject(vector);
                block18: while (true) {
                    switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
                        default: {
                            MIBParser.jj_la1[62] = jj_gen;
                            break block18;
                        }
                        case 89: {
                            MIBParser.jj_consume_token(89);
                            MIBParser.lcObject(vector);
                            continue block18;
                        }
                    }
                    break;
                }
                MIBParser.rightBrace();
                break;
            }
            default: {
                MIBParser.jj_la1[63] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 67: {
                token4 = MIBParser.tokDescription();
                string = MIBParser.quotedString();
                break;
            }
            default: {
                MIBParser.jj_la1[64] = jj_gen;
            }
        }
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 44: {
                token3 = MIBParser.tokReference();
                string2 = MIBParser.quotedString();
                break;
            }
            default: {
                MIBParser.jj_la1[65] = jj_gen;
            }
        }
        token2 = MIBParser.tokAssignment();
        token = MIBParser.trapNumber();
        SyntaxTrapType syntaxTrapType = new SyntaxTrapType();
        syntaxTrapType.setDescription(string);
        syntaxTrapType.setReference(string2);
        SyntaxOID syntaxOID = MIBParser.getOID((String)vector2.elementAt(0));
        if (syntaxOID.oid_tree == null) {
            syntaxOID.oid_tree = new int[1];
            syntaxOID.oid_tree[0] = -1;
        }
        syntaxTrapType.setEnterprise(syntaxOID);
        syntaxTrapType.setVariables(vector);
        syntaxTrapType.setNumber(Integer.parseInt(token.image));
        syntaxTrapType.commentObj = new CommentClass();
        syntaxTrapType.commentObj.node = MIBParser.extractComments(token5.specialToken);
        if (token4 != null) {
            syntaxTrapType.commentObj.description = MIBParser.extractComments(token4.specialToken);
        }
        if (token3 != null) {
            syntaxTrapType.commentObj.reference = MIBParser.extractComments(token3.specialToken);
        }
        syntaxTrapType.commentObj.commentStr = MIBParser.extractComments(token2.specialToken);
        if (JDBC) {
            macroType = "TRAP";
            descrip = string;
            refer = string2;
            if (string2.equals("")) {
                refer = null;
            }
            if (string.equals("")) {
                descrip = null;
            }
            trapStr = String.valueOf(syntaxOID.getName()) + "#" + vector + "#" + MIBParser.convertSQLData(descrip) + "#" + MIBParser.convertSQLData(refer) + "#" + token.image;
        }
        return syntaxTrapType;
    }

    public static final BaseSyntax ucConstruct() throws ParseException {
        errCode = "ucConstruct";
        if (MIBParser.jj_2_1(2)) {
            MIBParser.choice();
            return null;
        }
        if (MIBParser.jj_2_2(2)) {
            MIBParser.dataTypeDecl1();
            return null;
        }
        if (MIBParser.jj_2_3(2)) {
            BaseSyntax baseSyntax = MIBParser.textual_convention_construct();
            return baseSyntax;
        }
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 52: {
                SyntaxOID syntaxOID = MIBParser.object_type_construct();
                return syntaxOID;
            }
            case 79: {
                BaseSyntax baseSyntax = MIBParser.sequence_construct();
                return baseSyntax;
            }
            case 58: {
                MIBParser.jj_consume_token(58);
                SyntaxOID syntaxOID = MIBParser.object_identifier_type();
                return syntaxOID;
            }
        }
        MIBParser.jj_la1[5] = jj_gen;
        MIBParser.jj_consume_token(-1);
        throw new ParseException();
    }

    static void updateOtherRootNodes() {
        Vector vector = (Vector)standardNodes.clone();
        int n = vector.size();
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = (String)vector.elementAt(n2);
            if (oidString.indexOf(string) != -1 && otherRootNodes.indexOf(string) == -1) {
                otherRootNodes = String.valueOf(otherRootNodes) + "|" + string + "|";
            }
            ++n2;
        }
        if (oidString.indexOf("zeroDotZero") != -1 && otherRootNodes.indexOf("ccitt") == -1) {
            otherRootNodes = String.valueOf(otherRootNodes) + "|ccitt|";
        }
        if (otherRootNodes.equals("")) {
            if (oidString.indexOf("$.0") != -1) {
                otherRootNodes = String.valueOf(otherRootNodes) + "|ccitt|";
            } else if (oidString.indexOf("$.1") != -1) {
                otherRootNodes = String.valueOf(otherRootNodes) + "|iso|";
            }
        }
    }

    public static final long value() throws ParseException {
        errCode = "value";
        switch (jj_ntk == -1 ? MIBParser.jj_ntk() : jj_ntk) {
            case 24: {
                MIBParser.jj_consume_token(24);
                return Long.MAX_VALUE;
            }
            case 25: {
                MIBParser.jj_consume_token(25);
                return Long.MIN_VALUE;
            }
            case 76: 
            case 77: 
            case 78: 
            case 95: {
                long l = MIBParser.signed();
                return l;
            }
        }
        MIBParser.jj_la1[28] = jj_gen;
        MIBParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final void wellKnownName(Stack stack) throws ParseException {
        errCode = "wellKnownName";
        MIBParser.jj_consume_token(99);
        Token token = MIBParser.getToken(0);
        if (!(token.image.equals("iso") || token.image.equals("ccitt") || token.image.equals("joint-iso-ccitt"))) {
            System.err.println(String.valueOf(ERR) + SnmpUtils.getString("Major Error : wellKnownName mismatch. Report to support@adventnet.com with MIB file"));
        } else {
            stack.push(token.image);
        }
    }

    public void writeElements(DataOutputStream dataOutputStream, DataOutputStream dataOutputStream2) throws IOException {
    }

    static void writeIntoDataBase(MibOperations mibOperations) {
        cdbi = new CreateDataBaseInsert(mibOperations);
        String string = moduleName;
        boolean bl = cdbi.isExist(string);
        try {
            if (MibOperations.overWriteDataBase && bl) {
                cdbi.delete(string);
                bl = false;
            }
            if (!bl) {
                cdbi.create(CreateDataBaseInsert.commonTableNames, CreateDataBaseInsert.commonFieldNames, "");
                cdbi.create(CreateDataBaseInsert.tableNames, CreateDataBaseInsert.fieldNames, string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            return;
        }
        MIBParser.updateOtherRootNodes();
        if (!otherRootNodes.equals("")) {
            cdbi.insertValues("MODULETABLE", String.valueOf(string) + "#" + "false" + "#" + otherRootNodes + "$");
        } else {
            cdbi.insertValues("MODULETABLE", String.valueOf(string) + "#" + "true" + "#" + nullStr + "$");
        }
        String string2 = cdbi.getTableName(string);
        if (!dependancyString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "DEPENDANCYTABLE", dependancyString);
        }
        if (!moduleIdentityString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "MODULEIDTYTABLE", moduleIdentityString);
        }
        if (!oidString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "NODETABLE", oidString);
        }
        if (!otString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "OBJECTTYPETABLE", otString);
        }
        if (!ottString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "OBJECTTYPETABLE", ottString);
        }
        if (!otrString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "OBJECTTYPETABLE", otrString);
        }
        if (!ngString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "OGNGNTTABLE", ngString);
        }
        if (!ogString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "OGNGNTTABLE", ogString);
        }
        if (!ntString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "OGNGNTTABLE", ntString);
        }
        if (!tcString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "TCTABLE", tcString);
        }
        if (!mcString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "ACMCTABLE", mcString);
        }
        if (!acString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "ACMCTABLE", acString);
        }
        if (!mcModuleString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "MCMTABLE", mcModuleString);
        }
        if (!acModuleString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "ACMTABLE", acModuleString);
        }
        if (!acVariationString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "ACVTABLE", acVariationString);
        }
        if (!trapString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "TRAPTABLE", trapString);
        }
        if (!seqString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "SEQTABLE", seqString);
        }
        if (!oidtyString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "OBJECTTYPETABLE", oidtyString);
        }
        if (!rangeString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "RANGELISTTABLE", rangeString);
        }
        if (!unitString.equals("")) {
            cdbi.insertValues(String.valueOf(string2) + "UNITTABLE", unitString);
        }
    }

    static void writeParams(OutputStream outputStream, OutputStream outputStream2) {
        MIBWriter mIBWriter = new MIBWriter();
        mIBWriter.setDescFileStream(outputStream2);
        mIBWriter.setFileStream(outputStream);
        mIBWriter.setTrapList(trapList);
        mIBWriter.setTCTable(tcList);
        mIBWriter.setModuleName(moduleName);
        mIBWriter.setPreModComments(preModuleComments);
        mIBWriter.setOIDTable(oidList);
        mIBWriter.setSequenceList(sequenceList);
        importsOids = MIBParser.getImportOids();
        importsTCs = MIBParser.getImportTCs();
        importSequences = MIBParser.getImportSequences();
        if (importSequences.size() != 0) {
            throw new IllegalArgumentException(" \n" + SnmpUtils.getString("Cannot have a SEQUENCE which " + SnmpUtils.getString("is not defined in the MIB :") + "\n" + MIBParser.getConstructs(importSequences)));
        }
        mIBWriter.setImportsOIDTable(importsOids);
        mIBWriter.setImportsTCTable(importsTCs);
        mIBWriter.setImports(MIBParser.getImportAsInMIB());
        mIBWriter.writeFile();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

