/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs.mibparser;

import com.adventnet.snmp.mibs.mibparser.MIBConstants;
import com.adventnet.snmp.mibs.mibparser.SyntaxOID;
import com.adventnet.snmp.mibs.mibparser.SyntaxSequence;
import com.adventnet.snmp.mibs.mibparser.SyntaxTextualConvention;
import com.adventnet.snmp.mibs.mibparser.SyntaxTrapType;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MIBWriter
implements MIBConstants {
    DataOutputStream outp;
    DataOutputStream descOutp;
    static final byte[] ver;
    Hashtable trapTable;
    Hashtable tcTable;
    Hashtable sequenceList;
    Hashtable importSequenceList;
    Hashtable primaryOidTable;
    Hashtable importsOIDTable;
    Hashtable importsTCTable;
    Hashtable oidTable;
    String moduleName;
    String modComments;
    String importList = "";

    static {
        byte[] byArray = new byte[2];
        byArray[1] = 1;
        ver = byArray;
    }

    public void setDescFileStream(OutputStream outputStream) {
        this.descOutp = new DataOutputStream(outputStream);
    }

    public void setFileStream(OutputStream outputStream) {
        this.outp = new DataOutputStream(outputStream);
    }

    public void setImports(String string) {
        this.importList = string;
    }

    public void setImportsOIDTable(Hashtable hashtable) {
        this.importsOIDTable = hashtable;
    }

    public void setImportsTCTable(Hashtable hashtable) {
        this.importsTCTable = hashtable;
    }

    public void setModuleName(String string) {
        this.moduleName = string;
    }

    public void setOIDTable(Hashtable hashtable) {
        this.oidTable = hashtable;
    }

    public void setPreModComments(String string) {
        this.modComments = string;
    }

    public void setSequenceList(Hashtable hashtable) {
        this.sequenceList = hashtable;
    }

    public void setTCTable(Hashtable hashtable) {
        this.tcTable = hashtable;
    }

    public void setTrapList(Hashtable hashtable) {
        this.trapTable = hashtable;
    }

    public void writeFile() {
        this.primaryOidTable = new Hashtable();
        try {
            this.outp.write(ver);
            this.writeMibModule();
            this.writeImportedOid(this.importsOIDTable);
            this.writeImportedTC();
            this.writeTheTC();
            this.writeTraps();
            this.writeSequences();
            SyntaxOID syntaxOID = (SyntaxOID)this.oidTable.get("iso");
            SyntaxOID syntaxOID2 = (SyntaxOID)this.oidTable.get("ccitt");
            SyntaxOID syntaxOID3 = (SyntaxOID)this.oidTable.get("joint-iso-ccitt");
            if (syntaxOID != null) {
                this.primaryOidTable.put("iso", syntaxOID);
            }
            if (syntaxOID2 != null) {
                this.primaryOidTable.put("ccitt", syntaxOID2);
            }
            if (syntaxOID3 != null) {
                this.primaryOidTable.put("joint-iso-ccitt", syntaxOID3);
            }
            this.outp.writeInt(this.primaryOidTable.size());
            this.outp.write(10);
            Enumeration enumeration = this.primaryOidTable.keys();
            while (enumeration.hasMoreElements()) {
                SyntaxOID syntaxOID4 = (SyntaxOID)this.primaryOidTable.get(enumeration.nextElement());
                syntaxOID4.writeElements(this.outp, this.descOutp);
            }
            this.outp.writeBoolean(false);
        }
        catch (IOException iOException) {
            System.err.println("IOException : " + iOException.getMessage());
        }
        this.primaryOidTable = null;
    }

    void writeImportedOid(Hashtable hashtable) throws IOException {
        this.outp.writeInt(hashtable.size());
        this.outp.write(10);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.outp.writeUTF(string);
            Vector vector = (Vector)hashtable.get(string);
            this.outp.writeInt(vector.size());
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                SyntaxOID syntaxOID = (SyntaxOID)enumeration2.nextElement();
                this.primaryOidTable.put(syntaxOID.getName(), syntaxOID);
                this.outp.writeUTF(syntaxOID.getName());
                this.outp.writeInt(syntaxOID.childOIDList.size());
                Enumeration enumeration3 = syntaxOID.childOIDList.elements();
                while (enumeration3.hasMoreElements()) {
                    this.outp.writeUTF(((SyntaxOID)enumeration3.nextElement()).getName());
                }
            }
            this.outp.write(10);
        }
    }

    void writeImportedTC() throws IOException {
        this.outp.writeInt(this.importsTCTable.size());
        this.outp.write(10);
        Enumeration enumeration = this.importsTCTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.outp.writeUTF(string);
            Vector vector = (Vector)this.importsTCTable.get(string);
            this.outp.writeInt(vector.size());
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                SyntaxTextualConvention syntaxTextualConvention = (SyntaxTextualConvention)enumeration2.nextElement();
                if (syntaxTextualConvention == null) continue;
                this.outp.writeUTF(syntaxTextualConvention.getName());
            }
            this.outp.write(10);
        }
    }

    void writeMibModule() throws IOException {
        this.outp.writeUTF(this.moduleName);
        this.outp.write(10);
        this.descOutp.writeUTF(this.modComments);
        this.descOutp.writeUTF(this.importList);
    }

    void writeSequences() throws IOException {
        this.outp.writeInt(this.sequenceList.size());
        this.outp.write(10);
        Enumeration enumeration = this.sequenceList.keys();
        while (enumeration.hasMoreElements()) {
            SyntaxSequence syntaxSequence = (SyntaxSequence)this.sequenceList.get((String)enumeration.nextElement());
            syntaxSequence.writeSyntaxRelated(this.outp, this.descOutp);
            this.outp.write(10);
        }
    }

    void writeTheTC() throws IOException {
        this.outp.writeInt(this.tcTable.size());
        this.outp.write(10);
        Enumeration enumeration = this.tcTable.keys();
        while (enumeration.hasMoreElements()) {
            SyntaxTextualConvention syntaxTextualConvention = (SyntaxTextualConvention)this.tcTable.get((String)enumeration.nextElement());
            syntaxTextualConvention.writeElements(this.outp, this.descOutp);
            this.outp.write(10);
        }
    }

    void writeTraps() throws IOException {
        this.outp.writeInt(this.trapTable.size());
        this.outp.write(10);
        Enumeration enumeration = this.trapTable.keys();
        while (enumeration.hasMoreElements()) {
            SyntaxTrapType syntaxTrapType = (SyntaxTrapType)this.trapTable.get((String)enumeration.nextElement());
            syntaxTrapType.writeElements(this.outp, this.descOutp);
            this.outp.write(10);
        }
    }
}

