/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs.mibparser;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class RangeList {
    int enumLimit = 50;
    int rangeLimit = 20;
    boolean rangeFlag = false;
    boolean enumerationFlag = false;
    public long[] values = new long[50];
    public int labelcount = 0;
    public String[] labels = new String[50];
    public long[] max = new long[20];
    public int rangecount = 0;
    public long[] min = new long[20];
    public boolean[] rangetype = new boolean[20];
    public boolean preDefinedRange = false;

    public RangeList(Vector vector, Vector vector2, Vector vector3) {
        if (vector2.size() > 0) {
            this.addRanges(vector2, vector3);
        }
        if (vector.size() > 0) {
            this.addEnums(vector);
        }
    }

    public void addEnum(String string, long l) {
        this.enumerationFlag = true;
        if (this.labelcount >= this.enumLimit) {
            String[] stringArray = new String[this.enumLimit + this.enumLimit];
            System.arraycopy(this.labels, 0, stringArray, 0, this.labelcount);
            long[] lArray = new long[this.enumLimit + this.enumLimit];
            System.arraycopy(this.values, 0, lArray, 0, this.labelcount);
            this.labels = stringArray;
            this.values = lArray;
            this.enumLimit += this.enumLimit;
        }
        this.labels[this.labelcount] = string;
        this.values[this.labelcount] = l;
        ++this.labelcount;
    }

    public void addEnums(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            long l = (Long)enumeration.nextElement();
            this.addEnum(string, l);
        }
    }

    public void addRange(long l, long l2) {
        this.rangeFlag = true;
        if (this.rangecount >= this.rangeLimit) {
            long[] lArray = new long[this.rangeLimit + this.rangeLimit];
            System.arraycopy(this.max, 0, lArray, 0, this.rangeLimit);
            long[] lArray2 = new long[this.rangeLimit + this.rangeLimit];
            System.arraycopy(this.min, 0, lArray2, 0, this.rangeLimit);
            this.min = lArray2;
            this.max = lArray;
            this.rangeLimit += this.rangeLimit;
        }
        this.max[this.rangecount] = l;
        this.min[this.rangecount] = l2;
        this.rangetype[this.rangecount] = true;
        ++this.rangecount;
    }

    public void addRangeItem(long l) {
        this.rangeFlag = true;
        this.max[this.rangecount] = l;
        this.rangetype[this.rangecount] = false;
        ++this.rangecount;
    }

    public void addRanges(Vector vector, Vector vector2) {
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = vector2.elements();
        while (enumeration2.hasMoreElements()) {
            long l;
            boolean bl = (Boolean)enumeration2.nextElement();
            if (bl) {
                l = (Long)enumeration.nextElement();
                long l2 = (Long)enumeration.nextElement();
                this.addRange(l2, l);
                continue;
            }
            l = (Long)enumeration.nextElement();
            this.addRangeItem(l);
        }
    }

    public String getLabel(long l) {
        if (this.isEnumerated()) {
            int n = 0;
            while (n < this.labelcount) {
                if (this.values[n] == l) {
                    return this.labels[n];
                }
                ++n;
            }
        }
        return null;
    }

    public boolean isEnumerated() {
        return this.enumerationFlag;
    }

    public boolean isRanged() {
        return this.rangeFlag;
    }

    public boolean isValid(long l) {
        if (this.isEnumerated()) {
            int n = 0;
            while (n < this.labelcount) {
                if (this.values[n] == l) {
                    return true;
                }
                if (this.isRanged()) {
                    n = 0;
                    while (n < this.rangecount) {
                        if (this.rangetype[n] ? l <= this.max[n] && l >= this.min[n] : l == this.max[n]) {
                            return true;
                        }
                        ++n;
                    }
                }
                ++n;
            }
        }
        return true;
    }

    public boolean isValid(String string) {
        block5: {
            block4: {
                if (!this.isEnumerated()) break block4;
                int n = 0;
                while (n < this.labelcount) {
                    if (this.labels[n].equals(string)) {
                        return true;
                    }
                    ++n;
                }
                break block5;
            }
            if (!this.isRanged()) break block5;
            int n = string.length();
            int n2 = 0;
            while (n2 < this.rangecount) {
                if (this.rangetype[n2] ? (long)n <= this.max[n2] && (long)n >= this.min[n2] : (long)n == this.max[n2]) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void writeElements(DataOutputStream dataOutputStream, DataOutputStream dataOutputStream2) throws IOException {
        block3: {
            block2: {
                dataOutputStream.writeBoolean(this.preDefinedRange);
                dataOutputStream.writeBoolean(this.isRanged());
                dataOutputStream.writeBoolean(this.isEnumerated());
                if (!this.isEnumerated()) break block2;
                dataOutputStream.writeInt(this.labelcount);
                int n = 0;
                while (n < this.labelcount) {
                    dataOutputStream.writeUTF(this.labels[n]);
                    dataOutputStream.writeLong(this.values[n]);
                    ++n;
                }
                break block3;
            }
            if (!this.isRanged()) break block3;
            dataOutputStream.writeInt(this.rangecount);
            int n = 0;
            while (n < this.rangecount) {
                dataOutputStream.writeBoolean(this.rangetype[n]);
                dataOutputStream.writeLong(this.max[n]);
                dataOutputStream.writeLong(this.min[n]);
                ++n;
            }
        }
    }
}

